import { PAGE_MAP } from '@src/utils/constants';
import { makeAutoObservable } from 'mobx';
import API from '../api/index';

const store = makeAutoObservable({
  /** 活动规则 */
  ruleInfo: '',
  /** 前端开发配置 */
  frontVariable: {},
  /** 当前页面 */
  curPage: PAGE_MAP.HOME_PAGE,
  isChangePage: false,
  pageData: {},
  /** 场景切换 */
  changePage(page, data = {}) {
    if (!this.isChangePage) this.isChangePage = true;
    this.pageData = data;
    this.curPage = page;
  },
  /** 获取活动规则 */
  async initRule() {
    // 模拟获取远程的数据
    const { data } = await API.getRule();
    this.ruleInfo = data;
  },
  /** 获取前端配置项 */
  async getFrontVariable() {
    // 获取前端开发配置
    const { data } = await API.getFrontVariable();
    this.frontVariable = data || {};
    console.log('前端开发配置', data)
  }
})
export default store;
