/** 
 * 活动首页demo 开发自行修改或替换
 */

'use strict';
import React from 'react';
import { observer } from 'mobx-react';
import './homeDemo.less';
import SquareTurntable from '@src/components/SquareTurntable/SquareTurntable';
import { _throttle } from '@src/utils/utils';
import API from '@src/api';

@observer
class HomeDemo extends React.Component {  
  constructor(props) {
    super(props);
    this.table = null;
    this.state = {
      prizeList: []
    }
  }

  async componentDidMount() {
    const res = await API.getTurntableInfo();
    if(res?.success) {
      this.setState({ prizeList: res?.data?.prizeList  || []});
    }
  }

  /** 点击抽奖 */
  handleClick = _throttle(async () => {
    console.log("table", this.table)
    const res = await API.doTurntableDraw();
    if (res?.success) {
      console.log("prizeId", res?.data?.prizeId);
      const result = await this.table.draw(res?.data?.prizeId);
      if (!!result) {
        console.log("抽奖结束", result)
      }
    }
  })
  render() {
    
    return (
      /**
       * ref 必须 获取对象
       * (废弃)drawApi 必须 抽奖接口
       * prizeList 必须 奖品列表
       * itemSelectImg 必须 奖品选中效果 这里的元素将覆盖在奖品格子上
       * renderItem 必须 定义每个格子里的内容如何布局和展示
       * className 非必须 默认全屏样式
       * renderBg 非必须 用于渲染背景，也可用于其他元素渲染，元素位置位于底层
       * renderCenter 非必须 转盘中心位置，可用于渲染抽奖按钮或logo啥的
       * (废弃)updateInfoFunction 非必须 抽奖接口成功后将调用
       * matchInitName 非必须 默认prizeId，用于初始化时往dom上挂载该命名属性的值，用于后续与接口返回的字段匹配
       * (废弃)matchApiName 非必须 默认prizeId, 定义读取接口返回的哪个字段名用于字段匹配
       *
       *  -- 转盘参数相关 --
       * moveTime 非必须 默认100，每隔多少毫秒移动一个格子
       * beginIndex 非必须 默认0，转盘从哪个格子开始转
       * turnTime 非必须 默认5000，转盘至少转动多少毫秒
       * addTime 非必须 默认5，转盘每移动一次增加的移动时间间隔
       * maxMoveTime 非必须，默认1000，转盘最久以该时间移动一格
       *
       *
       * 支持插槽自定义内容，写在标签体内部
       */
      <div className="homeDemo">
        <SquareTurntable
          ref={(ref) => (this.table = ref)}
          className="turntable"
          renderBg={<span className="bg"></span>}
          renderCenter={<span className="logo"></span>}
          prizeList={this.state.prizeList}
          itemSelectImg={<span className="mask"></span>}
          drawApi={API.doTurntableDraw}
          updateInfoFunction={() => {
            console.log("刷新数据");
          }}
          matchInitName="prizeId"
          matchApiName="prizeId"
          moveTime={100}
          beginIndex={0}
          turnTime={5000}
          addTime={5}
          maxMoveTime={1000}
          renderItem={(item, index) => {
            return (
              <div className="item" key={`@${index}`}>
                <div className="item_img_box">
                  <img src={item?.icon} alt="" className="item_img" />
                </div>
                <span className="item_name">{item?.name || ""}</span>
              </div>
            );
          }}>
          <span className="main_btn" onClick={this.handleClick}></span>
        </SquareTurntable>
      </div>
    );
  }
}

export default HomeDemo;
