"use strict";

import React from "react";
import { observer } from "mobx-react";
import "./SquareTurntable.less";

@observer
class SquareTurntable extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      // 是否已点击
      isClick: false,
    };
    // ref列表
    this.prizeRefList = [];
    // 记录上次抽奖的结束位置
    this.oldIndex = null;
    // 转盘时间控制的定时器
    this.timer = null;
  }
  async componentDidMount() {}
  /** 停顿时间 */
  waitTime = async(time) => {
    return new Promise((resolve) => setTimeout(resolve, time));
  }
  /** 
   * 抽奖
   * @params targetId 中奖的id
   * */
  draw = async (targetId) => {
      const {
        moveTime = 100,
        beginIndex = 0,
        turnTime = 5000,
        addTime = 5,
        maxMoveTime = 1000,
        drawApi = () => {},
        matchApiName = "prizeId",
        itemSelectImg = "",
        updateInfoFunction = () => {},
      } = this.props;
      if (this.state.isClick) {
        console.log("已经点过啦~憋点啦！憋点啦！");
        return false;
      }
      if(!!!targetId) {
        console.log("我辣么大个中奖id呢！转盘罢工了");
        return false;
      }
      this.setState({ isClick: true });
      // 初始速度
      let _moveTime = moveTime;
      // 起始位置
      let _beginIndex = this.oldIndex || beginIndex;
      // 判断转盘是否结束
      let flag = true;
      // 至少转动的时间
      let _turnTime = turnTime;
      // 当前被选中的节点
      let select = {};
      // 数组长度
      const len = this.prizeRefList?.length || 0;
      this.timer = setTimeout(() => {
        flag = false;
      }, _turnTime);
      const move = async () => {
        if (!flag && select.getAttribute("data-prize-id") === targetId) {
          this.setState({ isClick: false });
          this.oldIndex = _beginIndex;
          return true;
        }
        if (len === 0) return false;
        if (!!itemSelectImg) {
          this.prizeRefList[_beginIndex].lastChild.style.visibility = "hidden";
        }
        _beginIndex ++;
        if (_beginIndex >= len) _beginIndex = 0;
        select = this.prizeRefList[_beginIndex];
        if(!!!select.getAttribute("data-prize-id")) {
          console.log("当前元素未绑定id哦", select);
        }
        if (!!itemSelectImg) {
          this.prizeRefList[_beginIndex].lastChild.style.visibility = "visible";
        }
        _moveTime += addTime;
        _moveTime = _moveTime > maxMoveTime? maxMoveTime: _moveTime;
        await this.waitTime(_moveTime);
        return await move();
      };
      return await move();
  };

  render() {
    const {
      prizeList = [], 
      className = "", 
      renderBg = "", 
      renderCenter = "", 
      renderItem = () => {}, 
      children = "", 
      itemSelectImg = "",
      matchInitName = "prizeId"
    } = this.props;
    return (
      <>
        <div className={`SquareTurntable ${className}`}>
          {/* 渲染背景 */}
          {!!renderBg && renderBg}
          {/* 渲染格子 */}
          <div className="option_group">
            {(prizeList || []).map((item, index) => {
              return (
                <div
                  className={`option_basic option_${index + 1}`}
                  key={`@${index}`}
                  data-prize-id={item[matchInitName]}
                  ref={(ref) => (this.prizeRefList[index] = ref)}>
                  {renderItem(item, index)}
                  {/* 选中样式 - 图片 */}
                  {!!itemSelectImg && itemSelectImg}
                </div>
              );
            })}
            {/* 中间区域渲染 */}
            {!!renderCenter && (
              <div className="option_basic">
                {renderCenter}
              </div>
            )}
          </div>
          {/* 插槽 */}
          {children}
        </div>
      </>
    );
  }
}
export default SquareTurntable;
