### 注意事项
组件使用方式

```react
import SquareTurntable from '@src/components/SquareTurntable/SquareTurntable';

<SquareTurntable
    ref={(ref) => (this.table = ref)}
    className="turntable"
    renderBg={<span className="bg"></span>}
    renderCenter={<span className="logo"></span>}
    prizeList={this.state.prizeList}
    itemSelectImg={<span className="mask"></span>}
    matchInitName="prizeId"
    moveTime={100}
    beginIndex={0}
    turnTime={5000}
    addTime={5}
    maxMoveTime={1000}
    renderItem={(item, index) => {
      return (
        <div className="item" key={`@${index}`}>
          <div className="item_img_box">
            <img src={item?.icon} alt="" className="item_img" />
          </div>
          <span className="item_name">{item?.name || ""}</span>
        </div>
      );
    }}>
    <span className="main_btn" onClick={this.handleClick}></span>
</SquareTurntable>

```

| 属性                       | 介绍                                                         | 是否必填 | 默认值             |
| -------------------------- | ------------------------------------------------------------ | -------- | ------------------ |
| ref                        | 用于获取组件对象                                             | 是       | /                  |
| prizeList                  | 奖品列表                                                     | 是       | []                 |
| itemSelectImg              | 被选中时奖品上方展示的内容                                   | 是       | ""                 |
| drawApi（废弃）            | 抽奖接口，只需给API中定义的就行                              | 是       | ()=>{}             |
| renderItem                 | 每个格子内渲染的内容                                         | 是       | ""                 |
| className                  | 整体转盘样式设置                                             | 否       | 默认占满整个父元素 |
| renderBg                   | 渲染转盘背景也可以渲染其他元素，将渲染在转盘底层             | 否       | ""                 |
| renderCenter               | 渲染转盘中心位置的内容                                       | 否       | ""                 |
| updateInfoFunction（废弃） | 抽奖接口成功后，会执行                                       | 否       | ()=>{}             |
| matchInitName              | 奖品渲染时，将读取该奖品item上的matchInitName属性下的值绑定在dom上，例如data-prize-id={item[matchInitName]} | 否       | "prizeId"          |
| matchApiName（废弃）       | 抽奖接口返回的数据中用于和上方数据匹配的字段名               | 否       | "prizeId"          |
| moveTime                   | 转盘移动间隔时间，单位ms                                     | 否       | 100                |
| beginIndex                 | 转盘初次启动的索引                                           | 否       | 0                  |
| addTime                    | 转盘每次移动增加的间隔时间                                   | 否       | 5                  |
| maxMoveTime                | 转盘移动一格的最长时间                                       | 否       | 1000               |

##### 在标签体内也可添加内容，通过插槽展示在转盘区域内

### SquareTurntable 对象

| 属性/方法    | 介绍                           |
| ------------ | ------------------------------ |
| prizeRefList | 存放所有的奖品对象             |
| oldIndex     | 记录上一轮结束的位置           |
| timer        | 定时器，用于控制转盘转动的时间 |
| draw         | 方法，转盘转动，需要入参中奖id |

