/**
 * @author       Richard Davey <rich@photonstorm.com>
 * @copyright    2018 Photon Storm Ltd.
 * @license      {@link https://github.com/photonstorm/phaser/blob/master/license.txt|MIT License}
 */

module.exports = {

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.BACKSPACE
     * @type {integer}
     * @since 3.0.0
     */
    BACKSPACE: 8,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.TAB
     * @type {integer}
     * @since 3.0.0
     */
    TAB: 9,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.ENTER
     * @type {integer}
     * @since 3.0.0
     */
    ENTER: 13,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.SHIFT
     * @type {integer}
     * @since 3.0.0
     */
    SHIFT: 16,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.CTRL
     * @type {integer}
     * @since 3.0.0
     */
    CTRL: 17,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.ALT
     * @type {integer}
     * @since 3.0.0
     */
    ALT: 18,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.PAUSE
     * @type {integer}
     * @since 3.0.0
     */
    PAUSE: 19,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.CAPS_LOCK
     * @type {integer}
     * @since 3.0.0
     */
    CAPS_LOCK: 20,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.ESC
     * @type {integer}
     * @since 3.0.0
     */
    ESC: 27,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.SPACE
     * @type {integer}
     * @since 3.0.0
     */
    SPACE: 32,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.PAGE_UP
     * @type {integer}
     * @since 3.0.0
     */
    PAGE_UP: 33,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.PAGE_DOWN
     * @type {integer}
     * @since 3.0.0
     */
    PAGE_DOWN: 34,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.END
     * @type {integer}
     * @since 3.0.0
     */
    END: 35,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.HOME
     * @type {integer}
     * @since 3.0.0
     */
    HOME: 36,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.LEFT
     * @type {integer}
     * @since 3.0.0
     */
    LEFT: 37,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.UP
     * @type {integer}
     * @since 3.0.0
     */
    UP: 38,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.RIGHT
     * @type {integer}
     * @since 3.0.0
     */
    RIGHT: 39,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.DOWN
     * @type {integer}
     * @since 3.0.0
     */
    DOWN: 40,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.PRINT_SCREEN
     * @type {integer}
     * @since 3.0.0
     */
    PRINT_SCREEN: 42,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.INSERT
     * @type {integer}
     * @since 3.0.0
     */
    INSERT: 45,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.DELETE
     * @type {integer}
     * @since 3.0.0
     */
    DELETE: 46,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.ZERO
     * @type {integer}
     * @since 3.0.0
     */
    ZERO: 48,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.ONE
     * @type {integer}
     * @since 3.0.0
     */
    ONE: 49,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.TWO
     * @type {integer}
     * @since 3.0.0
     */
    TWO: 50,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.THREE
     * @type {integer}
     * @since 3.0.0
     */
    THREE: 51,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.FOUR
     * @type {integer}
     * @since 3.0.0
     */
    FOUR: 52,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.FIVE
     * @type {integer}
     * @since 3.0.0
     */
    FIVE: 53,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.SIX
     * @type {integer}
     * @since 3.0.0
     */
    SIX: 54,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.SEVEN
     * @type {integer}
     * @since 3.0.0
     */
    SEVEN: 55,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.EIGHT
     * @type {integer}
     * @since 3.0.0
     */
    EIGHT: 56,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.NINE
     * @type {integer}
     * @since 3.0.0
     */
    NINE: 57,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.A
     * @type {integer}
     * @since 3.0.0
     */
    A: 65,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.B
     * @type {integer}
     * @since 3.0.0
     */
    B: 66,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.C
     * @type {integer}
     * @since 3.0.0
     */
    C: 67,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.D
     * @type {integer}
     * @since 3.0.0
     */
    D: 68,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.E
     * @type {integer}
     * @since 3.0.0
     */
    E: 69,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.F
     * @type {integer}
     * @since 3.0.0
     */
    F: 70,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.G
     * @type {integer}
     * @since 3.0.0
     */
    G: 71,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.H
     * @type {integer}
     * @since 3.0.0
     */
    H: 72,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.I
     * @type {integer}
     * @since 3.0.0
     */
    I: 73,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.J
     * @type {integer}
     * @since 3.0.0
     */
    J: 74,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.K
     * @type {integer}
     * @since 3.0.0
     */
    K: 75,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.L
     * @type {integer}
     * @since 3.0.0
     */
    L: 76,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.M
     * @type {integer}
     * @since 3.0.0
     */
    M: 77,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.N
     * @type {integer}
     * @since 3.0.0
     */
    N: 78,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.O
     * @type {integer}
     * @since 3.0.0
     */
    O: 79,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.P
     * @type {integer}
     * @since 3.0.0
     */
    P: 80,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.Q
     * @type {integer}
     * @since 3.0.0
     */
    Q: 81,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.R
     * @type {integer}
     * @since 3.0.0
     */
    R: 82,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.S
     * @type {integer}
     * @since 3.0.0
     */
    S: 83,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.T
     * @type {integer}
     * @since 3.0.0
     */
    T: 84,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.U
     * @type {integer}
     * @since 3.0.0
     */
    U: 85,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.V
     * @type {integer}
     * @since 3.0.0
     */
    V: 86,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.W
     * @type {integer}
     * @since 3.0.0
     */
    W: 87,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.X
     * @type {integer}
     * @since 3.0.0
     */
    X: 88,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.Y
     * @type {integer}
     * @since 3.0.0
     */
    Y: 89,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.Z
     * @type {integer}
     * @since 3.0.0
     */
    Z: 90,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.F1
     * @type {integer}
     * @since 3.0.0
     */
    F1: 112,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.F2
     * @type {integer}
     * @since 3.0.0
     */
    F2: 113,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.F3
     * @type {integer}
     * @since 3.0.0
     */
    F3: 114,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.F4
     * @type {integer}
     * @since 3.0.0
     */
    F4: 115,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.F5
     * @type {integer}
     * @since 3.0.0
     */
    F5: 116,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.F6
     * @type {integer}
     * @since 3.0.0
     */
    F6: 117,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.F7
     * @type {integer}
     * @since 3.0.0
     */
    F7: 118,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.F8
     * @type {integer}
     * @since 3.0.0
     */
    F8: 119,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.F9
     * @type {integer}
     * @since 3.0.0
     */
    F9: 120,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.F10
     * @type {integer}
     * @since 3.0.0
     */
    F10: 121,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.F11
     * @type {integer}
     * @since 3.0.0
     */
    F11: 122,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.F12
     * @type {integer}
     * @since 3.0.0
     */
    F12: 123,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.SEMICOLON
     * @type {integer}
     * @since 3.0.0
     */
    SEMICOLON: 186,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.PLUS
     * @type {integer}
     * @since 3.0.0
     */
    PLUS: 187,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.COMMA
     * @type {integer}
     * @since 3.0.0
     */
    COMMA: 188,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.MINUS
     * @type {integer}
     * @since 3.0.0
     */
    MINUS: 189,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.PERIOD
     * @type {integer}
     * @since 3.0.0
     */
    PERIOD: 190,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.FORWARD_SLASH
     * @type {integer}
     * @since 3.0.0
     */
    FORWARD_SLASH: 191,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.BACK_SLASH
     * @type {integer}
     * @since 3.0.0
     */
    BACK_SLASH: 220,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.QUOTES
     * @type {integer}
     * @since 3.0.0
     */
    QUOTES: 222,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.BACKTICK
     * @type {integer}
     * @since 3.0.0
     */
    BACKTICK: 192,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.OPEN_BRACKET
     * @type {integer}
     * @since 3.0.0
     */
    OPEN_BRACKET: 219,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.CLOSED_BRACKET
     * @type {integer}
     * @since 3.0.0
     */
    CLOSED_BRACKET: 221

};
