/**
 * @author       Richard Davey <rich@photonstorm.com>
 * @copyright    2018 Photon Storm Ltd.
 * @license      {@link https://github.com/photonstorm/phaser/blob/master/license.txt|MIT License}
 */


module.exports = {

    /**
     * Scene state.
     * 
     * @name Phaser.Scenes.PENDING
     * @type {integer}
     * @since 3.0.0
     */
    PENDING: 0,

    /**
     * Scene state.
     * 
     * @name Phaser.Scenes.INIT
     * @type {integer}
     * @since 3.0.0
     */
    INIT: 1,

    /**
     * Scene state.
     * 
     * @name Phaser.Scenes.START
     * @type {integer}
     * @since 3.0.0
     */
    START: 2,

    /**
     * Scene state.
     * 
     * @name Phaser.Scenes.LOADING
     * @type {integer}
     * @since 3.0.0
     */
    LOADING: 3,

    /**
     * Scene state.
     * 
     * @name Phaser.Scenes.CREATING
     * @type {integer}
     * @since 3.0.0
     */
    CREATING: 4,

    /**
     * Scene state.
     * 
     * @name Phaser.Scenes.RUNNING
     * @type {integer}
     * @since 3.0.0
     */
    RUNNING: 5,

    /**
     * Scene state.
     * 
     * @name Phaser.Scenes.PAUSED
     * @type {integer}
     * @since 3.0.0
     */
    PAUSED: 6,

    /**
     * Scene state.
     * 
     * @name Phaser.Scenes.SLEEPING
     * @type {integer}
     * @since 3.0.0
     */
    SLEEPING: 7,

    /**
     * Scene state.
     * 
     * @name Phaser.Scenes.SHUTDOWN
     * @type {integer}
     * @since 3.0.0
     */
    SHUTDOWN: 8,

    /**
     * Scene state.
     * 
     * @name Phaser.Scenes.DESTROYED
     * @type {integer}
     * @since 3.0.0
     */
    DESTROYED: 9

};
