import * as utils from './utils'
import PieceControl from './PieceControl';
export default class Swap {
    static DURATION = 0.45;
    static DELAY = .9;

    static startSwap(all: PieceControl[], n: number, times: number, target: number, onSwapComplete: Function) {
        for (let index = 0; index < times; index++) {
            const list = Swap.getList(all, n, target);
            setTimeout(() => {
                Swap.swap(list, index + 1 == times ? onSwapComplete : null);
            }, Swap.DURATION * 1000 * index + Swap.DELAY * 1000 * index);
        }
    }
    private static getList(all: PieceControl[], n: number, target: number) {
        const randomizedDeck = utils.shuffle(all);
        let targetPiece;
        const randomizedDeck2 = randomizedDeck.filter(e => {
            if (e.index == target)
                targetPiece = e;
            return e.index != target;
        });
        const list = randomizedDeck2.slice(0, n - 1);
        const m = n / 2;
        const list1 = list.slice(0, m);
        const list2 = list.slice(m);
        list2.push(targetPiece);
        return list1.map(
            (val, index) => { return { a: val, b: list2[index] } }
        )
    }

    private static swap(list: { a: PieceControl, b: PieceControl }[], onComplete: Function = null) {
        let tag = true;
        for (const e of list) {
            if (tag) {
                tag = false;
                Swap.swapOne(e.a, e.b, onComplete);
            } else {
                Swap.swapOne(e.a, e.b);
            }
        }
    }

    private static swapOne(a: PieceControl, b: PieceControl, onComplete: Function = null) {
        const ax = a.container.x;
        const ay = a.container.y;
        const bx = b.container.x;
        const by = b.container.y;
        const scene = a.scene;
        if (onComplete) {
            const tween = scene.tweens.add({
                targets: b.container,
                x: ax, y: ay,
                ease: 'Quad.easeInOut',
                duration: Swap.DURATION*1000,
                onComplete: onComplete
            });
        }
        else {
            const tween = scene.tweens.add({
                targets: b.container,
                x: ax, y: ay,
                ease: 'Quad.easeInOut',
                duration: Swap.DURATION*1000,
            });
        }

        const tween = scene.tweens.add({
            targets: a.container,
            x: bx, y: by,
            ease: 'Quad.easeInOut',
            duration:Swap.DURATION*1000,
        });
    }
}