import PieceControl from './PieceControl';
import * as utils from './utils'
import Swap from './Swap';

export default class SceneControl {
    private scene;
    private _targets: number[];
    private _list: PieceControl[];

    SHOW_TIME = 1000;
    DELAY = 500;
    BORNS = 1;
    R = 3;
    TIMES = 3;
    N = 4;
    SIZE = 235;

    constructor(scene) {
        this.scene = scene;
        this.initUI();
        this.update();
    }

    initUI() {

        const n = this.R * this.R;
        const targetList = utils.fillN(n);
        const randomTargetList = utils.shuffle(targetList);
        this._targets = randomTargetList.slice(0, this.BORNS);
        this._list = [];

        for (let index = 1; index <= n; index++) {
            const inTargets = this._targets.indexOf(index) != -1;
            const p = new PieceControl(this.scene, !inTargets, index);
            p.back.setInteractive();
            p['index'] = index;
            this._list.push(p);
            p.container.x = ((index - 1) % this.R) * this.SIZE + 106 + 50;
            p.container.y = Math.floor((index - 1) / this.R) * this.SIZE + 106 + 50;
            p.flipImmediately();
            p.back.on('clicked', () => {
                // console.log(p.index);
                this.disable();
                let enable = false;
                const index = this._targets.indexOf(p.index);
                if (index != -1) {
                    this._targets.splice(index, 1);
                    if (this._targets.length == 0) {
                        console.log('good.')
                    } else {
                        enable = true;
                    }
                }
                else {
                    console.log('sorry.')
                }
                p.flip(() => {
                    if (enable) this.enable();
                });
            }, this);
        }

        this.disable();
    }

    update() {
        const onResetComplete = () => {
            setTimeout(() => {
                Swap.startSwap(this._list, this.N, this.TIMES, this._targets[0], () => {
                    this.onSwapComplete()
                })
            }, this.DELAY);
        }

        setTimeout(() => {
            for (let i = 0; i < this._list.length; i++) {
                const e = this._list[i];
                e.reset(i == 0 ? onResetComplete : null);
            }
        }, this.SHOW_TIME);
    }

    onSwapComplete() {
        console.log('onSwapComplete');
        this.enable();
    }

    disable() {
        this.scene.input.off('gameobjectup', this.ongameobjectup, this);
    }

    enable() {
        this.scene.input.on('gameobjectup', this.ongameobjectup, this);
    }

    ongameobjectup(pointer, gameObject){
        gameObject.emit('clicked', gameObject);
    }
}