export default class PieceControl {
    public scene;
    private isDog: boolean;
    private front;
    public back;
    public index: number;
    static FLIP_DURTION = 1000;
    public container;

    constructor(scene, isDog: boolean, index: number) {
        this.scene = scene;
        this.index = index;
        this.isDog = isDog;
        if (isDog) {
            this.front = this.scene.add.image(0, 0, 'front');
        } else {
            this.front = this.scene.add.image(0, 0, 'bone');
        }
        this.back = this.scene.add.image(0, 0, 'back');
        this.container = this.scene.add.container(0, 0, [this.back, this.front]);
    }

    reset(callback?) {
        const timeline = this.scene.tweens.timeline({
            tweens: [
                {
                    targets: this.front,
                    scaleX: 0.01,
                    ease:'Quad.easeInOut',
                    duration: PieceControl.FLIP_DURTION / 2,
                    onComplete: () => {
                        this.back.visible = true;
                        this.front.visible = false;
                    }
                },
                {
                    targets: this.back,
                    scaleX: 1,
                    ease:'Quad.easeInOut',
                    duration: PieceControl.FLIP_DURTION / 2,
                    onComplete: () => { 
                        callback && callback() 
                    }
                }]
        });
    }

    resetImmediately() {
        this.back.visible = true;
        this.back.scaleX = 1;
        this.front.visible = false;
        this.front.scaleX = 0.01;
    }

    flipImmediately() {
        this.back.visible = false;
        this.front.visible = true;
        this.front.scaleX = 1;
        this.back.scaleX = 0.01;
    }

    flip(callback = null) {
        const timeline = this.scene.tweens.timeline({
            tweens: [
                {
                    targets: this.back,
                    scaleX: 0.01,
                    ease:'Quad.easeInOut',
                    duration: PieceControl.FLIP_DURTION / 2,
                    onComplete: () => {
                        this.back.visible = false;
                        this.front.visible = true;
                    }
                },
                {
                    targets: this.front,
                    scaleX: 1,
                    ease:'Quad.easeInOut',
                    duration: PieceControl.FLIP_DURTION / 2,
                    onComplete: () => { callback && callback() }
                }]
        });
    }
}