declare type CallCallback = (item: Phaser.GameObjects.GameObject)=>void;

declare type GridAlignConfig = {
    /**
     * The width of the grid in items (not pixels). -1 means lay all items out horizontally, regardless of quantity.
     *                                  If both this value and height are set to -1 then this value overrides it and the `height` value is ignored.
     */
    width?: integer;
    /**
     * The height of the grid in items (not pixels). -1 means lay all items out vertically, regardless of quantity.
     *                                   If both this value and `width` are set to -1 then `width` overrides it and this value is ignored.
     */
    height?: integer;
    /**
     * The width of the cell, in pixels, in which the item is positioned.
     */
    cellWidth?: boolean;
    /**
     * The height of the cell, in pixels, in which the item is positioned.
     */
    cellHeight?: integer;
    /**
     * The alignment position. One of the Phaser.Display.Align consts such as `TOP_LEFT` or `RIGHT_CENTER`.
     */
    position?: integer;
    /**
     * Optionally place the top-left of the final grid at this coordinate.
     */
    x?: number;
    /**
     * Optionally place the top-left of the final grid at this coordinate.
     */
    y?: number;
};

declare type JSONAnimation = {
    /**
     * [description]
     */
    key: string;
    /**
     * A frame based animation (as opposed to a bone based animation)
     */
    type: string;
    /**
     * [description]
     */
    frames: JSONAnimationFrame[];
    /**
     * The frame rate of playback in frames per second (default 24 if duration is null)
     */
    frameRate: integer;
    /**
     * How long the animation should play for.
     */
    duration: integer;
    /**
     * Skip frames if the time lags, or always advanced anyway?
     */
    skipMissedFrames: boolean;
    /**
     * Delay before starting playback (in seconds)
     */
    delay: integer;
    /**
     * Number of times to repeat the animation (-1 for infinity)
     */
    repeat: integer;
    /**
     * Delay before the repeat starts (in seconds)
     */
    repeatDelay: integer;
    /**
     * Should the animation yoyo? (reverse back down to the start) before repeating?
     */
    yoyo: boolean;
    /**
     * Should sprite.visible = true when the animation starts to play?
     */
    showOnStart: boolean;
    /**
     * Should sprite.visible = false when the animation finishes?
     */
    hideOnComplete: boolean;
};

declare type AnimationFrameConfig = {
    /**
     * [description]
     */
    key: string;
    /**
     * [description]
     */
    frame: string | number;
    /**
     * [description]
     */
    duration?: number;
    /**
     * [description]
     */
    visible?: boolean;
    /**
     * [description]
     */
    onUpdate?: Function;
};

declare type AnimationConfig = {
    /**
     * [description]
     */
    frames?: AnimationFrameConfig[];
    /**
     * [description]
     */
    defaultTextureKey?: string;
    /**
     * The frame rate of playback in frames per second (default 24 if duration is null)
     */
    frameRate?: integer;
    /**
     * How long the animation should play for.
     */
    duration?: integer;
    /**
     * Skip frames if the time lags, or always advanced anyway?
     */
    skipMissedFrames?: boolean;
    /**
     * Delay before starting playback (in seconds)
     */
    delay?: integer;
    /**
     * Number of times to repeat the animation (-1 for infinity)
     */
    repeat?: integer;
    /**
     * Delay before the repeat starts (in seconds)
     */
    repeatDelay?: integer;
    /**
     * Should the animation yoyo? (reverse back down to the start) before repeating?
     */
    yoyo?: boolean;
    /**
     * Should sprite.visible = true when the animation starts to play?
     */
    showOnStart?: boolean;
    /**
     * Should sprite.visible = false when the animation finishes?
     */
    hideOnComplete?: boolean;
    /**
     * [description]
     */
    callbackScope?: any;
    /**
     * [description]
     */
    onStart?: false | Function;
    /**
     * [description]
     */
    onStartParams?: any[];
    /**
     * [description]
     */
    onRepeat?: false | Function;
    /**
     * [description]
     */
    onRepeatParams?: any[];
    /**
     * [description]
     */
    onUpdate?: false | Function;
    /**
     * [description]
     */
    onUpdateParams?: any[];
    /**
     * [description]
     */
    onComplete?: false | Function;
    /**
     * [description]
     */
    onCompleteParams?: any[];
};

declare type JSONAnimationFrame = {
    /**
     * The key of the Texture this AnimationFrame uses.
     */
    key: string;
    /**
     * The key of the Frame within the Texture that this AnimationFrame uses.
     */
    frame: string | integer;
    /**
     * Additional time (in ms) that this frame should appear for during playback.
     */
    duration: number;
};

declare type JSONAnimationManager = {
    /**
     * [description]
     */
    anims: JSONAnimation[];
    /**
     * [description]
     */
    globalTimeScale: number;
};

/**
 * This callback type is completely empty, a no-operation.
 */
declare type NOOP = ()=>void;

declare type BootCallback = (game: Phaser.Game)=>void;

declare type FPSConfig = {
    /**
     * [description]
     */
    min?: integer;
    /**
     * [description]
     */
    target?: integer;
    /**
     * [description]
     */
    forceSetTimeOut?: boolean;
    /**
     * [description]
     */
    deltaHistory?: integer;
    /**
     * [description]
     */
    panicMax?: integer;
};

declare type LoaderConfig = {
    /**
     * [description]
     */
    baseURL?: string;
    /**
     * [description]
     */
    path?: string;
    /**
     * [description]
     */
    enableParallel?: boolean;
    /**
     * [description]
     */
    maxParallelDownloads?: integer;
    /**
     * [description]
     */
    crossOrigin?: string | undefined;
    /**
     * [description]
     */
    responseType?: string;
    /**
     * [description]
     */
    async?: boolean;
    /**
     * [description]
     */
    user?: string;
    /**
     * [description]
     */
    password?: string;
    /**
     * [description]
     */
    timeout?: integer;
};

declare type GameConfig = {
    /**
     * [description]
     */
    width?: integer | string;
    /**
     * [description]
     */
    height?: integer | string;
    /**
     * [description]
     */
    zoom?: number;
    /**
     * [description]
     */
    resolution?: number;
    /**
     * [description]
     */
    type?: number;
    /**
     * [description]
     */
    parent?: any;
    /**
     * [description]
     */
    canvas?: HTMLCanvasElement;
    /**
     * [description]
     */
    canvasStyle?: string;
    /**
     * [description]
     */
    scene?: object;
    /**
     * [description]
     */
    seed?: string[];
    /**
     * [description]
     */
    title?: string;
    /**
     * [description]
     */
    url?: string;
    /**
     * [description]
     */
    version?: string;
    /**
     * [description]
     */
    input?: boolean | object;
    /**
     * [description]
     */
    "input.keyboard"?: boolean;
    /**
     * [description]
     */
    "input.keyboard.target"?: any;
    /**
     * [description]
     */
    "input.mouse"?: boolean | object;
    /**
     * [description]
     */
    "input.mouse.target"?: any;
    /**
     * [description]
     */
    "input.touch"?: boolean;
    /**
     * [description]
     */
    "input.touch.target"?: any;
    /**
     * [description]
     */
    "input.touch.capture"?: boolean;
    /**
     * [description]
     */
    "input.gamepad"?: boolean | object;
    /**
     * [description]
     */
    disableContextMenu?: boolean;
    /**
     * [description]
     */
    banner?: boolean | object;
    /**
     * [description]
     */
    "banner.hidePhaser"?: boolean;
    /**
     * [description]
     */
    "banner.text"?: string;
    /**
     * [description]
     */
    "banner.background"?: string[];
    /**
     * [description]
     */
    fps?: FPSConfig;
    /**
     * [description]
     */
    antialias?: boolean;
    /**
     * [description]
     */
    pixelArt?: boolean;
    /**
     * [description]
     */
    autoResize?: boolean;
    /**
     * [description]
     */
    roundPixels?: boolean;
    /**
     * [description]
     */
    transparent?: boolean;
    /**
     * [description]
     */
    clearBeforeRender?: boolean;
    /**
     * [description]
     */
    premultipliedAlpha?: boolean;
    /**
     * [description]
     */
    preserveDrawingBuffer?: boolean;
    /**
     * [description]
     */
    failIfMajorPerformanceCaveat?: boolean;
    /**
     * "high-performance", "low-power" or "default"
     */
    powerPreference?: boolean;
    /**
     * [description]
     */
    backgroundColor?: string | number;
    /**
     * [description]
     */
    callbacks?: object;
    /**
     * [description]
     */
    "callbacks.preBoot"?: BootCallback;
    /**
     * [description]
     */
    "callbacks.postBoot"?: BootCallback;
    /**
     * [description]
     */
    loader?: LoaderConfig;
    /**
     * [description]
     */
    images?: object;
    /**
     * [description]
     */
    "images.default"?: string;
    /**
     * [description]
     */
    "images.missing"?: string;
};

declare type GameStepCallback = ()=>void;

declare namespace PluginManager {
    /**
     * Static method called directly by the Plugins
     * Key is a reference used to get the plugin from the plugins object (i.e. InputPlugin)
     * Plugin is the object to instantiate to create the plugin
     * Mapping is what the plugin is injected into the Scene.Systems as (i.e. input)
     * @param key [description]
     * @param plugin [description]
     * @param mapping [description]
     */
    function register(key: string, plugin: object, mapping: string): void;

}

declare type TimeStepCallback = (time: number, average: number, interpolation: number)=>void;

declare type JSONCamera = {
    /**
     * The name of the camera
     */
    name: string;
    /**
     * The horizontal position of camera
     */
    x: number;
    /**
     * The vertical position of camera
     */
    y: number;
    /**
     * The width size of camera
     */
    width: number;
    /**
     * The height size of camera
     */
    height: number;
    /**
     * The zoom of camera
     */
    zoom: number;
    /**
     * The rotation of camera
     */
    rotation: number;
    /**
     * The round pixels st status of camera
     */
    roundPixels: boolean;
    /**
     * The horizontal scroll of camera
     */
    scrollX: number;
    /**
     * The vertical scroll of camera
     */
    scrollY: number;
    /**
     * The background color of camera
     */
    backgroundColor: string;
    /**
     * The bounds of camera
     */
    bounds?: object;
    /**
     * The horizontal position of bounds of camera
     */
    "bounds.x"?: number;
    /**
     * The vertical position of bounds of camera
     */
    "bounds.y"?: number;
    /**
     * The width of the bounds of camera
     */
    "bounds.width"?: number;
    /**
     * The height of the bounds of camera
     */
    "bounds.height"?: number;
};

declare type Camera2DCallback = (camera: Phaser.Cameras.Scene2D.Camera)=>void;

declare type InputJSONCameraObject = {
    /**
     * [description]
     */
    name?: string;
    /**
     * [description]
     */
    x?: integer;
    /**
     * [description]
     */
    y?: integer;
    /**
     * [description]
     */
    width?: integer;
    /**
     * [description]
     */
    height?: integer;
    /**
     * [description]
     */
    zoom?: number;
    /**
     * [description]
     */
    rotation?: number;
    /**
     * [description]
     */
    roundPixels?: boolean;
    /**
     * [description]
     */
    scrollX?: number;
    /**
     * [description]
     */
    scrollY?: number;
    /**
     * [description]
     */
    backgroundColor?: false | string;
    /**
     * [description]
     */
    bounds?: object;
    /**
     * [description]
     */
    "bounds.x"?: number;
    /**
     * [description]
     */
    "bounds.y"?: number;
    /**
     * [description]
     */
    "bounds.width"?: number;
    /**
     * [description]
     */
    "bounds.height"?: number;
};

declare type FixedKeyControlConfig = {
    /**
     * The Camera that this Control will update.
     */
    camera?: Phaser.Cameras.Scene2D.Camera;
    /**
     * The Key to be pressed that will move the Camera left.
     */
    left?: Phaser.Input.Keyboard.Key;
    /**
     * The Key to be pressed that will move the Camera right.
     */
    right?: Phaser.Input.Keyboard.Key;
    /**
     * The Key to be pressed that will move the Camera up.
     */
    up?: Phaser.Input.Keyboard.Key;
    /**
     * The Key to be pressed that will zoom the Camera in.
     */
    zoomIn?: Phaser.Input.Keyboard.Key;
    /**
     * The Key to be pressed that will zoom the Camera out.
     */
    zoomOut?: Phaser.Input.Keyboard.Key;
    /**
     * The speed at which the camera will zoom if the `zoomIn` or `zoomOut` keys are pressed.
     */
    zoomSpeed?: number;
    /**
     * The horizontal and vertical speed the camera will move.
     */
    speed?: number | Object;
};

declare type SmoothedKeyControlConfig = {
    /**
     * The Camera that this Control will update.
     */
    camera?: Phaser.Cameras.Scene2D.Camera;
    /**
     * The Key to be pressed that will move the Camera left.
     */
    left?: Phaser.Input.Keyboard.Key;
    /**
     * The Key to be pressed that will move the Camera right.
     */
    right?: Phaser.Input.Keyboard.Key;
    /**
     * The Key to be pressed that will move the Camera up.
     */
    up?: Phaser.Input.Keyboard.Key;
    /**
     * The Key to be pressed that will zoom the Camera in.
     */
    zoomIn?: Phaser.Input.Keyboard.Key;
    /**
     * The Key to be pressed that will zoom the Camera out.
     */
    zoomOut?: Phaser.Input.Keyboard.Key;
    /**
     * The speed at which the camera will zoom if the `zoomIn` or `zoomOut` keys are pressed.
     */
    zoomSpeed?: number;
    /**
     * The horizontal and vertical acceleration the camera will move.
     */
    acceleration?: number | Object;
    /**
     * The horizontal and vertical drag applied to the camera when it is moving.
     */
    drag?: number | Object;
    /**
     * The maximum horizontal and vertical speed the camera will move.
     */
    maxSpeed?: number | Object;
};

declare type RayDef = {
    /**
     * [description]
     */
    origin: Phaser.Math.Vector3;
    /**
     * [description]
     */
    direction: Phaser.Math.Vector3;
};

declare type GenerateTextureRendererCallback = (canvas: HTMLCanvasElement, context: CanvasRenderingContext2D)=>void;

declare type GenerateTextureConfig = {
    /**
     * [description]
     */
    data?: any[];
    /**
     * [description]
     */
    canvas?: HTMLCanvasElement;
    /**
     * [description]
     */
    palette?: Palette;
    /**
     * [description]
     */
    pixelWidth?: number;
    /**
     * [description]
     */
    pixelHeight?: number;
    /**
     * [description]
     */
    resizeCanvas?: boolean;
    /**
     * [description]
     */
    clearCanvas?: boolean;
    /**
     * [description]
     */
    preRender?: GenerateTextureRendererCallback;
    /**
     * [description]
     */
    postRender?: GenerateTextureRendererCallback;
};

declare type Palette = {
    /**
     * Color value 1.
     */
    "0": string;
    /**
     * Color value 2.
     */
    "1": string;
    /**
     * Color value 3.
     */
    "2": string;
    /**
     * Color value 4.
     */
    "3": string;
    /**
     * Color value 5.
     */
    "4": string;
    /**
     * Color value 6.
     */
    "5": string;
    /**
     * Color value 7.
     */
    "6": string;
    /**
     * Color value 8.
     */
    "7": string;
    /**
     * Color value 9.
     */
    "8": string;
    /**
     * Color value 10.
     */
    "9": string;
    /**
     * Color value 11.
     */
    A: string;
    /**
     * Color value 12.
     */
    B: string;
    /**
     * Color value 13.
     */
    C: string;
    /**
     * Color value 14.
     */
    D: string;
    /**
     * Color value 15.
     */
    E: string;
    /**
     * Color value 16.
     */
    F: string;
};

declare type JSONEllipseCurve = {
    /**
     * The of the curve.
     */
    type: string;
    /**
     * [description]
     */
    x: number;
    /**
     * [description]
     */
    y: number;
    /**
     * The horizontal radius of ellipse.
     */
    xRadius: number;
    /**
     * The vertical radius of ellipse.
     */
    yRadius: number;
    /**
     * The start angle of ellipse.
     */
    startAngle: integer;
    /**
     * The end angle of ellipse.
     */
    endAngle: integer;
    /**
     * The clockwise of ellipse.
     */
    clockwise: boolean;
    /**
     * The rotation of ellipse.
     */
    rotation: integer;
};

declare type EllipseCurveConfig = {
    /**
     * [description]
     */
    x?: number;
    /**
     * [description]
     */
    y?: number;
    /**
     * [description]
     */
    xRadius?: number;
    /**
     * [description]
     */
    yRadius?: number;
    /**
     * [description]
     */
    startAngle?: integer;
    /**
     * [description]
     */
    endAngle?: integer;
    /**
     * [description]
     */
    clockwise?: boolean;
    /**
     * [description]
     */
    rotation?: integer;
};

declare type JSONCurve = {
    /**
     * The of the curve
     */
    type: string;
    /**
     * The arrays of points like `[x1, y1, x2, y2]`
     */
    points: number[];
};

declare type JSONPath = {
    /**
     * The of the curve.
     */
    type: string;
    /**
     * [description]
     */
    x: number;
    /**
     * [description]
     */
    y: number;
    /**
     * The path is auto closed.
     */
    autoClose: boolean;
    /**
     * The list of the curves
     */
    curves: JSONCurve[];
};

declare type DataEachCallback = (parent: any, key: string, value: any, ...args: any[])=>void;

/**
 * Checks for support of the Full Screen API.
 */
declare function init(): void;

declare type InputColorObject = {
    /**
     * The red color value in the range 0 to 255.
     */
    r?: number;
    /**
     * The green color value in the range 0 to 255.
     */
    g?: number;
    /**
     * The blue color value in the range 0 to 255.
     */
    b?: number;
    /**
     * The alpha color value in the range 0 to 255.
     */
    a?: number;
};

declare type ColorObject = ()=>void;

declare type HSLColorObject = {
    /**
     * The hue color value. A number between 0 and 1
     */
    h: number;
    /**
     * The saturation color value. A number between 0 and 1
     */
    s: number;
    /**
     * The lightness color value. A number between 0 and 1
     */
    l: number;
};

declare type ContentLoadedCallback = ()=>void;

declare type DisplayCallback = (display: object)=>void;

declare type BitmapTextConfig = {
    /**
     * [description]
     */
    font?: string;
    /**
     * [description]
     */
    text?: string;
    /**
     * [description]
     */
    size?: number | false;
    /**
     * [description]
     */
    align?: string;
};

declare namespace ParseRetroFont {
}

declare type TextBounds = {
    /**
     * [description]
     */
    local: object;
    /**
     * [description]
     */
    "local.x": number;
    /**
     * [description]
     */
    "local.y": number;
    /**
     * [description]
     */
    "local.width": number;
    /**
     * [description]
     */
    "local.height": number;
    /**
     * [description]
     */
    global: object;
    /**
     * [description]
     */
    "global.x": number;
    /**
     * [description]
     */
    "global.y": number;
    /**
     * [description]
     */
    "global.width": number;
    /**
     * [description]
     */
    "global.height": number;
};

declare type JSONBitmapText = {
    /**
     * [description]
     */
    font: string;
    /**
     * [description]
     */
    text: string;
    /**
     * [description]
     */
    fontSize: number;
};

declare type BlitterFromCallback = (blitter: Phaser.GameObjects.Blitter, index: integer)=>void;

declare type GameObjectConfig = {
    /**
     * [description]
     */
    x?: number;
    /**
     * [description]
     */
    y?: number;
    /**
     * [description]
     */
    depth?: number;
    /**
     * [description]
     */
    flipX?: boolean;
    /**
     * [description]
     */
    flipY?: boolean;
    /**
     * [description]
     */
    scale?: number | object;
    /**
     * [description]
     */
    scrollFactor?: number | object;
    /**
     * [description]
     */
    rotation?: number;
    /**
     * [description]
     */
    angle?: number;
    /**
     * [description]
     */
    alpha?: number;
    /**
     * [description]
     */
    origin?: number | object;
    /**
     * [description]
     */
    scaleMode?: number;
    /**
     * [description]
     */
    blendMode?: number;
    /**
     * [description]
     */
    visible?: boolean;
    /**
     * [description]
     */
    add?: boolean;
};

declare type JSONGameObject = {
    /**
     * The name of this Game Object.
     */
    name: string;
    /**
     * A textual representation of this Game Object, i.e. `sprite`.
     */
    type: string;
    /**
     * The x position of this Game Object.
     */
    x: number;
    /**
     * The y position of this Game Object.
     */
    y: number;
    /**
     * The scale of this Game Object
     */
    scale: object;
    /**
     * The horizontal scale of this Game Object.
     */
    "scale.x": number;
    /**
     * The vertical scale of this Game Object.
     */
    "scale.y": number;
    /**
     * The origin of this Game Object.
     */
    origin: object;
    /**
     * The horizontal origin of this Game Object.
     */
    "origin.x": number;
    /**
     * The vertical origin of this Game Object.
     */
    "origin.y": number;
    /**
     * The horizontally flipped state of the Game Object.
     */
    flipX: boolean;
    /**
     * The vertically flipped state of the Game Object.
     */
    flipY: boolean;
    /**
     * The angle of this Game Object in radians.
     */
    rotation: number;
    /**
     * The alpha value of the Game Object.
     */
    alpha: number;
    /**
     * The visible state of the Game Object.
     */
    visible: boolean;
    /**
     * The Scale Mode being used by this Game Object.
     */
    scaleMode: integer;
    /**
     * Sets the Blend Mode being used by this Game Object.
     */
    blendMode: integer | string;
    /**
     * The texture key of this Game Object.
     */
    textureKey: string;
    /**
     * The frame key of this Game Object.
     */
    frameKey: string;
    /**
     * The data of this Game Object.
     */
    data: object;
};

declare type GroupCallback = (item: Phaser.GameObjects.GameObject)=>void;

declare type GroupMultipleCreateCallback = (items: Phaser.GameObjects.GameObject[])=>void;

declare type GroupConfig = {
    /**
     * [description]
     */
    classType?: object;
    /**
     * [description]
     */
    active?: boolean;
    /**
     * [description]
     */
    maxSize?: number;
    /**
     * [description]
     */
    defaultKey?: string;
    /**
     * [description]
     */
    defaultFrame?: string | integer;
    /**
     * [description]
     */
    runChildUpdate?: boolean;
    /**
     * [description]
     */
    createCallback?: GroupCallback;
    /**
     * [description]
     */
    removeCallback?: GroupCallback;
    /**
     * [description]
     */
    createMultipleCallback?: GroupMultipleCreateCallback;
};

declare type GroupCreateConfig = {
    /**
     * [description]
     */
    classType?: object;
    /**
     * [description]
     */
    key?: string;
    /**
     * [description]
     */
    frame?: string | integer;
    /**
     * [description]
     */
    visible?: boolean;
    /**
     * [description]
     */
    active?: boolean;
    /**
     * [description]
     */
    repeat?: number;
    /**
     * [description]
     */
    randomKey?: boolean;
    /**
     * [description]
     */
    randomFrame?: boolean;
    /**
     * [description]
     */
    yoyo?: boolean;
    /**
     * [description]
     */
    frameQuantity?: number;
    /**
     * [description]
     */
    max?: number;
    /**
     * [description]
     */
    setXY?: object;
    /**
     * [description]
     */
    "setXY.x"?: number;
    /**
     * [description]
     */
    "setXY.y"?: number;
    /**
     * [description]
     */
    "setXY.stepX"?: number;
    /**
     * [description]
     */
    "setXY.stepY"?: number;
    /**
     * [description]
     */
    setRotation?: object;
    /**
     * [description]
     */
    "setRotation.value"?: number;
    /**
     * [description]
     */
    "setRotation.step"?: number;
    /**
     * [description]
     */
    setScale?: object;
    /**
     * [description]
     */
    "setScale.x"?: number;
    /**
     * [description]
     */
    "setScale.y"?: number;
    /**
     * [description]
     */
    "setScale.stepX"?: number;
    /**
     * [description]
     */
    "setScale.stepY"?: number;
    /**
     * [description]
     */
    setAlpha?: object;
    /**
     * [description]
     */
    "setAlpha.value"?: number;
    /**
     * [description]
     */
    "setAlpha.step"?: number;
    /**
     * [description]
     */
    hitArea?: any;
    /**
     * [description]
     */
    hitAreaCallback?: HitAreaCallback;
    /**
     * [description]
     */
    gridAlign?: false | GridAlignConfig;
};

declare type LightForEach = (light: Phaser.GameObjects.Light)=>void;

/**
 * The returned value sets what the property will be at the START of the particles life, on emit.
 */
declare type EmitterOpOnEmitCallback = (particle: Phaser.GameObjects.Particles.Particle, key: string, value: number)=>void;

/**
 * The returned value updates the property for the duration of the particles life.
 */
declare type EmitterOpOnUpdateCallback = (particle: Phaser.GameObjects.Particles.Particle, key: string, t: number, value: number)=>void;

declare type GravityWellConfig = {
    /**
     * The x coordinate of the Gravity Well, in world space.
     */
    x?: number;
    /**
     * The y coordinate of the Gravity Well, in world space.
     */
    y?: number;
    /**
     * The power of the Gravity Well.
     */
    power?: number;
    /**
     * [description]
     */
    epsilon?: number;
    /**
     * The gravitational force of this Gravity Well.
     */
    gravity?: number;
};

declare type ParticleEmitterCallback = (particle: Phaser.GameObjects.Particles.Particle, emitter: Phaser.GameObjects.Particles.ParticleEmitter)=>void;

declare type ParticleDeathCallback = (particle: Phaser.GameObjects.Particles.Particle)=>void;

declare type PathConfig = {
    /**
     * [description]
     */
    duration: number;
    /**
     * [description]
     */
    from: number;
    /**
     * [description]
     */
    to: number;
    /**
     * [description]
     */
    positionOnPath?: boolean;
    /**
     * [description]
     */
    rotateToPath?: boolean;
    /**
     * [description]
     */
    rotationOffset?: number;
    /**
     * [description]
     */
    verticalAdjust?: boolean;
};

declare type RenderTextureConfig = {
    /**
     * [description]
     */
    x?: number;
    /**
     * [description]
     */
    y?: number;
    /**
     * [description]
     */
    width?: number;
    /**
     * [description]
     */
    height?: number;
};

/**
 * A custom function that will be responsible for wrapping the text.
 */
declare type TextStyleWordWrapCallback = (text: string, textObject: Phaser.GameObjects.Text)=>void;

declare type TileSprite = {
    /**
     * [description]
     */
    x?: number;
    /**
     * [description]
     */
    y?: number;
    /**
     * [description]
     */
    width?: number;
    /**
     * [description]
     */
    height?: number;
    /**
     * [description]
     */
    key?: string;
    /**
     * [description]
     */
    frame?: string;
};

declare type CenterFunction = (triangle: Phaser.Geom.Triangle)=>void;

declare type HitAreaCallback = (hitArea: any, x: number, y: number, gameObject: Phaser.GameObjects.GameObject)=>void;

declare type Pad = {
    /**
     * [description]
     */
    id: string;
    /**
     * [description]
     */
    index: integer;
};

declare type GamepadHandler = ()=>void;

declare type KeyboardKeydownCallback = (event: KeyboardEvent)=>void;

declare type KeyComboConfig = {
    /**
     * [description]
     */
    resetOnWrongKey?: boolean;
    /**
     * [description]
     */
    maxKeyDelay?: number;
    /**
     * [description]
     */
    resetOnMatch?: boolean;
    /**
     * [description]
     */
    deleteOnMatch?: boolean;
};

declare type KeyboardHandler = ()=>void;

declare type MouseHandler = ()=>void;

declare type TouchHandler = (event: TouchEvent)=>void;

declare type FileProcessCallback = (file: Phaser.Loader.File)=>void;

declare type FileConfig = {
    /**
     * The file type string (image, json, etc) for sorting within the Loader.
     */
    type?: string | false;
    /**
     * Unique cache key (unique within its file type)
     */
    key?: string | false;
    /**
     * The URL of the file, not including baseURL.
     */
    url?: string;
    /**
     * [description]
     */
    path?: string;
    /**
     * [description]
     */
    extension?: string;
    /**
     * [description]
     */
    responseType?: XMLHttpRequestResponseType;
    /**
     * [description]
     */
    xhrSettings?: XHRSettingsObject | false;
    /**
     * A config object that can be used by file types to store transitional data.
     */
    config?: object;
};

declare type XHRConfig = {
    /**
     * [description]
     */
    key: string;
    /**
     * [description]
     */
    texture: string;
    /**
     * [description]
     */
    data?: string;
    /**
     * [description]
     */
    xhr?: XHRConfig;
};

declare type FileTypeConfig = {
    /**
     * [description]
     */
    key: string;
    /**
     * [description]
     */
    texture: string;
    /**
     * [description]
     */
    data?: string;
    /**
     * [description]
     */
    url?: string;
    /**
     * [description]
     */
    path?: string;
    /**
     * [description]
     */
    extension?: string;
    /**
     * [description]
     */
    responseType?: string;
    /**
     * [description]
     */
    config?: object;
    /**
     * [description]
     */
    xhr?: XHRConfig;
};

declare type LinkFileObject = {
    /**
     * [description]
     */
    type: string;
    /**
     * [description]
     */
    fileA: Phaser.Loader.File;
    /**
     * [description]
     */
    fileB: Phaser.Loader.File;
};

declare type LoaderFileObject = {
    /**
     * [description]
     */
    key: string;
    /**
     * [description]
     */
    type: string;
    /**
     * [description]
     */
    url?: string;
    /**
     * [description]
     */
    urls?: string[];
    /**
     * [description]
     */
    textureURL?: string;
    /**
     * [description]
     */
    atlasURL?: string;
    /**
     * [description]
     */
    xmlURL?: string;
    /**
     * [description]
     */
    textureURLs?: string[];
    /**
     * [description]
     */
    atlasURLs?: string[];
    /**
     * [description]
     */
    config?: object;
    /**
     * [description]
     */
    json?: object;
    /**
     * [description]
     */
    xhrSettings?: XHRSettingsObject;
    /**
     * [description]
     */
    textureXhrSettings?: XHRSettingsObject;
    /**
     * [description]
     */
    atlasXhrSettings?: XHRSettingsObject;
    /**
     * [description]
     */
    xmlXhrSettings?: XHRSettingsObject;
    /**
     * [description]
     */
    audioXhrSettings?: XHRSettingsObject;
    /**
     * [description]
     */
    jsonXhrSettings?: XHRSettingsObject;
};

declare type XHRSettingsObject = {
    /**
     * [description]
     */
    responseType: XMLHttpRequestResponseType;
    /**
     * [description]
     */
    async: boolean;
    /**
     * [description]
     */
    user: string;
    /**
     * [description]
     */
    password: string;
    /**
     * [description]
     */
    timeout: number;
    /**
     * [description]
     */
    header: string;
    /**
     * [description]
     */
    headerValue: string;
    /**
     * [description]
     */
    overrideMimeType: string | undefined;
};

declare function P0(): void;

declare type SinCosTable = {
    /**
     * [description]
     */
    sin: number;
    /**
     * [description]
     */
    cos: number;
    /**
     * [description]
     */
    length: number;
};

declare type Vector2Like = {
    /**
     * [description]
     */
    x: number;
    /**
     * [description]
     */
    y: number;
};

declare namespace Phaser {
    namespace Actions {
        /**
         * Takes an array of Game Objects, or any objects that have a public `angle` property,
         * and then adds the given value to each of their `angle` properties.
         * 
         * The optional `step` property is applied incrementally, multiplied by each item in the array.
         * 
         * To use this with a Group: `Angle(group.getChildren(), value, step)`
         * @param items The array of items to be updated by this action.
         * @param value The amount to be added to the `angle` property.
         * @param step This is added to the `value` amount, multiplied by the iteration counter. Default 0.
         * @param index An optional offset to start searching from within the items array. Default 0.
         * @param direction The direction to iterate through the array. 1 is from beginning to end, -1 from end to beginning. Default 1.
         */
        function Angle<G extends Phaser.GameObjects.GameObject[]>(items: G, value: number, step?: number, index?: integer, direction?: integer): G;

        /**
         * Takes an array of objects and passes each of them to the given callback.
         * @param items The array of items to be updated by this action.
         * @param callback The callback to be invoked. It will be passed just one argument: the item from the array.
         * @param context The scope in which the callback will be invoked.
         */
        function Call<G extends Phaser.GameObjects.GameObject[]>(items: G, callback: CallCallback, context: any): G;

        /**
         * Takes an array of objects and returns the first element in the array that has properties which match
         * all of those specified in the `compare` object. For example, if the compare object was: `{ scaleX: 0.5, alpha: 1 }`
         * then it would return the first item which had the property `scaleX` set to 0.5 and `alpha` set to 1.
         * 
         * To use this with a Group: `GetFirst(group.getChildren(), compare, index)`
         * @param items The array of items to be searched by this action.
         * @param compare The comparison object. Each property in this object will be checked against the items of the array.
         * @param index An optional offset to start searching from within the items array. Default 0.
         */
        function GetFirst<G extends Phaser.GameObjects.GameObject[]>(items: G, compare: object, index?: integer): object | Phaser.GameObjects.GameObject;

        /**
         * Takes an array of objects and returns the last element in the array that has properties which match
         * all of those specified in the `compare` object. For example, if the compare object was: `{ scaleX: 0.5, alpha: 1 }`
         * then it would return the last item which had the property `scaleX` set to 0.5 and `alpha` set to 1.
         * 
         * To use this with a Group: `GetLast(group.getChildren(), compare, index)`
         * @param items The array of items to be searched by this action.
         * @param compare The comparison object. Each property in this object will be checked against the items of the array.
         * @param index An optional offset to start searching from within the items array. Default 0.
         */
        function GetLast<G extends Phaser.GameObjects.GameObject[]>(items: G, compare: object, index?: integer): object | Phaser.GameObjects.GameObject;

        /**
         * Takes an array of Game Objects, or any objects that have public `x` and `y` properties,
         * and then aligns them based on the grid configuration given to this action.
         * @param items The array of items to be updated by this action.
         * @param options The GridAlign Configuration object.
         */
        function GridAlign<G extends Phaser.GameObjects.GameObject[]>(items: G, options: GridAlignConfig): G;

        /**
         * Takes an array of Game Objects, or any objects that have a public `alpha` property,
         * and then adds the given value to each of their `alpha` properties.
         * 
         * The optional `step` property is applied incrementally, multiplied by each item in the array.
         * 
         * To use this with a Group: `IncAlpha(group.getChildren(), value, step)`
         * @param items The array of items to be updated by this action.
         * @param value The amount to be added to the `alpha` property.
         * @param step This is added to the `value` amount, multiplied by the iteration counter. Default 0.
         * @param index An optional offset to start searching from within the items array. Default 0.
         * @param direction The direction to iterate through the array. 1 is from beginning to end, -1 from end to beginning. Default 1.
         */
        function IncAlpha<G extends Phaser.GameObjects.GameObject[]>(items: G, value: number, step?: number, index?: integer, direction?: integer): G;

        /**
         * Takes an array of Game Objects, or any objects that have a public `x` property,
         * and then adds the given value to each of their `x` properties.
         * 
         * The optional `step` property is applied incrementally, multiplied by each item in the array.
         * 
         * To use this with a Group: `IncX(group.getChildren(), value, step)`
         * @param items The array of items to be updated by this action.
         * @param value The amount to be added to the `x` property.
         * @param step This is added to the `value` amount, multiplied by the iteration counter. Default 0.
         * @param index An optional offset to start searching from within the items array. Default 0.
         * @param direction The direction to iterate through the array. 1 is from beginning to end, -1 from end to beginning. Default 1.
         */
        function IncX<G extends Phaser.GameObjects.GameObject[]>(items: G, value: number, step?: number, index?: integer, direction?: integer): G;

        /**
         * Takes an array of Game Objects, or any objects that have public `x` and `y` properties,
         * and then adds the given value to each of them.
         * 
         * The optional `stepX` and `stepY` properties are applied incrementally, multiplied by each item in the array.
         * 
         * To use this with a Group: `IncXY(group.getChildren(), x, y, stepX, stepY)`
         * @param items The array of items to be updated by this action.
         * @param x The amount to be added to the `x` property.
         * @param y The amount to be added to the `y` property. If `undefined` or `null` it uses the `x` value. Default x.
         * @param stepX This is added to the `x` amount, multiplied by the iteration counter. Default 0.
         * @param stepY This is added to the `y` amount, multiplied by the iteration counter. Default 0.
         * @param index An optional offset to start searching from within the items array. Default 0.
         * @param direction The direction to iterate through the array. 1 is from beginning to end, -1 from end to beginning. Default 1.
         */
        function IncXY<G extends Phaser.GameObjects.GameObject[]>(items: G, x: number, y?: number, stepX?: number, stepY?: number, index?: integer, direction?: integer): G;

        /**
         * Takes an array of Game Objects, or any objects that have a public `y` property,
         * and then adds the given value to each of their `y` properties.
         * 
         * The optional `step` property is applied incrementally, multiplied by each item in the array.
         * 
         * To use this with a Group: `IncY(group.getChildren(), value, step)`
         * @param items The array of items to be updated by this action.
         * @param value The amount to be added to the `y` property.
         * @param step This is added to the `value` amount, multiplied by the iteration counter. Default 0.
         * @param index An optional offset to start searching from within the items array. Default 0.
         * @param direction The direction to iterate through the array. 1 is from beginning to end, -1 from end to beginning. Default 1.
         */
        function IncY<G extends Phaser.GameObjects.GameObject[]>(items: G, value: number, step?: number, index?: integer, direction?: integer): G;

        /**
         * [description]
         * @param items An array of Game Objects. The contents of this array are updated by this Action.
         * @param circle [description]
         * @param startAngle [description] Default 0.
         * @param endAngle [description] Default 6.28.
         */
        function PlaceOnCircle<G extends Phaser.GameObjects.GameObject[]>(items: G, circle: Phaser.Geom.Circle, startAngle?: number, endAngle?: number): G;

        /**
         * [description]
         * @param items An array of Game Objects. The contents of this array are updated by this Action.
         * @param ellipse [description]
         * @param startAngle [description] Default 0.
         * @param endAngle [description] Default 6.28.
         */
        function PlaceOnEllipse<G extends Phaser.GameObjects.GameObject[]>(items: G, ellipse: Phaser.Geom.Ellipse, startAngle?: number, endAngle?: number): G;

        /**
         * [description]
         * @param items An array of Game Objects. The contents of this array are updated by this Action.
         * @param line [description]
         */
        function PlaceOnLine<G extends Phaser.GameObjects.GameObject[]>(items: G, line: Phaser.Geom.Line): G;

        /**
         * [description]
         * @param items An array of Game Objects. The contents of this array are updated by this Action.
         * @param rect [description]
         * @param shift [description] Default 1.
         */
        function PlaceOnRectangle<G extends Phaser.GameObjects.GameObject[]>(items: G, rect: Phaser.Geom.Rectangle, shift?: integer): G;

        /**
         * [description]
         * @param items An array of Game Objects. The contents of this array are updated by this Action.
         * @param triangle [description]
         * @param stepRate [description] Default 1.
         */
        function PlaceOnTriangle<G extends Phaser.GameObjects.GameObject[]>(items: G, triangle: Phaser.Geom.Triangle, stepRate?: number): G;

        /**
         * [description]
         * @param items An array of Game Objects. The contents of this array are updated by this Action.
         * @param key [description]
         * @param startFrame [description]
         */
        function PlayAnimation<G extends Phaser.GameObjects.GameObject[]>(items: G, key: string, startFrame?: string | integer): G;

        /**
         * Takes an array of Game Objects, or any objects that have a public property as defined in `key`,
         * and then adds the given value to it.
         * 
         * The optional `step` property is applied incrementally, multiplied by each item in the array.
         * 
         * To use this with a Group: `PropertyValueInc(group.getChildren(), key, value, step)`
         * @param items The array of items to be updated by this action.
         * @param key The property to be updated.
         * @param value The amount to be added to the property.
         * @param step This is added to the `value` amount, multiplied by the iteration counter. Default 0.
         * @param index An optional offset to start searching from within the items array. Default 0.
         * @param direction The direction to iterate through the array. 1 is from beginning to end, -1 from end to beginning. Default 1.
         */
        function PropertyValueInc<G extends Phaser.GameObjects.GameObject[]>(items: G, key: string, value: number, step?: number, index?: integer, direction?: integer): G;

        /**
         * Takes an array of Game Objects, or any objects that have a public property as defined in `key`,
         * and then sets it to the given value.
         * 
         * The optional `step` property is applied incrementally, multiplied by each item in the array.
         * 
         * To use this with a Group: `PropertyValueSet(group.getChildren(), key, value, step)`
         * @param items The array of items to be updated by this action.
         * @param key The property to be updated.
         * @param value The amount to set the property to.
         * @param step This is added to the `value` amount, multiplied by the iteration counter. Default 0.
         * @param index An optional offset to start searching from within the items array. Default 0.
         * @param direction The direction to iterate through the array. 1 is from beginning to end, -1 from end to beginning. Default 1.
         */
        function PropertyValueSet<G extends Phaser.GameObjects.GameObject[]>(items: G, key: string, value: number, step?: number, index?: integer, direction?: integer): G;

        /**
         * [description]
         * @param items An array of Game Objects. The contents of this array are updated by this Action.
         * @param circle [description]
         */
        function RandomCircle<G extends Phaser.GameObjects.GameObject[]>(items: G, circle: Phaser.Geom.Circle): G;

        /**
         * [description]
         * @param items An array of Game Objects. The contents of this array are updated by this Action.
         * @param ellipse [description]
         */
        function RandomEllipse<G extends Phaser.GameObjects.GameObject[]>(items: G, ellipse: Phaser.Geom.Ellipse): G;

        /**
         * [description]
         * @param items An array of Game Objects. The contents of this array are updated by this Action.
         * @param line [description]
         */
        function RandomLine<G extends Phaser.GameObjects.GameObject[]>(items: G, line: Phaser.Geom.Line): G;

        /**
         * [description]
         * @param items An array of Game Objects. The contents of this array are updated by this Action.
         * @param rect [description]
         */
        function RandomRectangle<G extends Phaser.GameObjects.GameObject[]>(items: G, rect: Phaser.Geom.Rectangle): G;

        /**
         * [description]
         * @param items An array of Game Objects. The contents of this array are updated by this Action.
         * @param triangle [description]
         */
        function RandomTriangle<G extends Phaser.GameObjects.GameObject[]>(items: G, triangle: Phaser.Geom.Triangle): G;

        /**
         * Takes an array of Game Objects, or any objects that have a public `rotation` property,
         * and then adds the given value to each of their `rotation` properties.
         * 
         * The optional `step` property is applied incrementally, multiplied by each item in the array.
         * 
         * To use this with a Group: `Rotate(group.getChildren(), value, step)`
         * @param items The array of items to be updated by this action.
         * @param value The amount to be added to the `rotation` property (in radians).
         * @param step This is added to the `value` amount, multiplied by the iteration counter. Default 0.
         * @param index An optional offset to start searching from within the items array. Default 0.
         * @param direction The direction to iterate through the array. 1 is from beginning to end, -1 from end to beginning. Default 1.
         */
        function Rotate<G extends Phaser.GameObjects.GameObject[]>(items: G, value: number, step?: number, index?: integer, direction?: integer): G;

        /**
         * [description]
         * @param items An array of Game Objects. The contents of this array are updated by this Action.
         * @param point Any object with public `x` and `y` properties.
         * @param angle The angle to rotate by, in radians.
         */
        function RotateAround<G extends Phaser.GameObjects.GameObject[]>(items: G, point: object, angle: number): G;

        /**
         * [description]
         * @param items An array of Game Objects. The contents of this array are updated by this Action.
         * @param point Any object with public `x` and `y` properties.
         * @param angle The angle to rotate by, in radians.
         * @param distance The distance from the point of rotation in pixels.
         */
        function RotateAroundDistance<G extends Phaser.GameObjects.GameObject[]>(items: G, point: object, angle: number, distance: number): G;

        /**
         * Takes an array of Game Objects, or any objects that have a public `scaleX` property,
         * and then adds the given value to each of their `scaleX` properties.
         * 
         * The optional `step` property is applied incrementally, multiplied by each item in the array.
         * 
         * To use this with a Group: `ScaleX(group.getChildren(), value, step)`
         * @param items The array of items to be updated by this action.
         * @param value The amount to be added to the `scaleX` property.
         * @param step This is added to the `value` amount, multiplied by the iteration counter. Default 0.
         * @param index An optional offset to start searching from within the items array. Default 0.
         * @param direction The direction to iterate through the array. 1 is from beginning to end, -1 from end to beginning. Default 1.
         */
        function ScaleX<G extends Phaser.GameObjects.GameObject[]>(items: G, value: number, step?: number, index?: integer, direction?: integer): G;

        /**
         * Takes an array of Game Objects, or any objects that have public `scaleX` and `scaleY` properties,
         * and then adds the given value to each of them.
         * 
         * The optional `stepX` and `stepY` properties are applied incrementally, multiplied by each item in the array.
         * 
         * To use this with a Group: `ScaleXY(group.getChildren(), scaleX, scaleY, stepX, stepY)`
         * @param items The array of items to be updated by this action.
         * @param scaleX The amount to be added to the `scaleX` property.
         * @param scaleY The amount to be added to the `scaleY` property. If `undefined` or `null` it uses the `scaleX` value.
         * @param stepX This is added to the `scaleX` amount, multiplied by the iteration counter. Default 0.
         * @param stepY This is added to the `y` amount, multiplied by the iteration counter. Default 0.
         * @param index An optional offset to start searching from within the items array. Default 0.
         * @param direction The direction to iterate through the array. 1 is from beginning to end, -1 from end to beginning. Default 1.
         */
        function ScaleXY<G extends Phaser.GameObjects.GameObject[]>(items: G, scaleX: number, scaleY?: number, stepX?: number, stepY?: number, index?: integer, direction?: integer): G;

        /**
         * Takes an array of Game Objects, or any objects that have a public `scaleY` property,
         * and then adds the given value to each of their `scaleY` properties.
         * 
         * The optional `step` property is applied incrementally, multiplied by each item in the array.
         * 
         * To use this with a Group: `ScaleY(group.getChildren(), value, step)`
         * @param items The array of items to be updated by this action.
         * @param value The amount to be added to the `scaleY` property.
         * @param step This is added to the `value` amount, multiplied by the iteration counter. Default 0.
         * @param index An optional offset to start searching from within the items array. Default 0.
         * @param direction The direction to iterate through the array. 1 is from beginning to end, -1 from end to beginning. Default 1.
         */
        function ScaleY<G extends Phaser.GameObjects.GameObject[]>(items: G, value: number, step?: number, index?: integer, direction?: integer): G;

        /**
         * Takes an array of Game Objects, or any objects that have the public property `alpha`
         * and then sets it to the given value.
         * 
         * The optional `step` property is applied incrementally, multiplied by each item in the array.
         * 
         * To use this with a Group: `SetAlpha(group.getChildren(), value, step)`
         * @param items The array of items to be updated by this action.
         * @param value The amount to set the property to.
         * @param step This is added to the `value` amount, multiplied by the iteration counter. Default 0.
         * @param index An optional offset to start searching from within the items array. Default 0.
         * @param direction The direction to iterate through the array. 1 is from beginning to end, -1 from end to beginning. Default 1.
         */
        function SetAlpha<G extends Phaser.GameObjects.GameObject[]>(items: G, value: number, step?: number, index?: integer, direction?: integer): G;

        /**
         * Takes an array of Game Objects, or any objects that have the public property `blendMode`
         * and then sets it to the given value.
         * 
         * The optional `step` property is applied incrementally, multiplied by each item in the array.
         * 
         * To use this with a Group: `SetBlendMode(group.getChildren(), value)`
         * @param items The array of items to be updated by this action.
         * @param value The amount to set the property to.
         * @param index An optional offset to start searching from within the items array. Default 0.
         * @param direction The direction to iterate through the array. 1 is from beginning to end, -1 from end to beginning. Default 1.
         */
        function SetBlendMode<G extends Phaser.GameObjects.GameObject[]>(items: G, value: number, index?: integer, direction?: integer): G;

        /**
         * Takes an array of Game Objects, or any objects that have the public property `depth`
         * and then sets it to the given value.
         * 
         * The optional `step` property is applied incrementally, multiplied by each item in the array.
         * 
         * To use this with a Group: `SetDepth(group.getChildren(), value, step)`
         * @param items The array of items to be updated by this action.
         * @param value The amount to set the property to.
         * @param step This is added to the `value` amount, multiplied by the iteration counter. Default 0.
         * @param index An optional offset to start searching from within the items array. Default 0.
         * @param direction The direction to iterate through the array. 1 is from beginning to end, -1 from end to beginning. Default 1.
         */
        function SetDepth<G extends Phaser.GameObjects.GameObject[]>(items: G, value: number, step?: number, index?: integer, direction?: integer): G;

        /**
         * [description]
         * @param items An array of Game Objects. The contents of this array are updated by this Action.
         * @param hitArea [description]
         * @param hitAreaCallback [description]
         */
        function SetHitArea<G extends Phaser.GameObjects.GameObject[]>(items: G, hitArea: any, hitAreaCallback: HitAreaCallback): G;

        /**
         * Takes an array of Game Objects, or any objects that have the public properties `originX` and `originY`
         * and then sets them to the given values.
         * 
         * The optional `stepX` and `stepY` properties are applied incrementally, multiplied by each item in the array.
         * 
         * To use this with a Group: `SetOrigin(group.getChildren(), originX, originY, stepX, stepY)`
         * @param items The array of items to be updated by this action.
         * @param originX The amount to set the `originX` property to.
         * @param originY The amount to set the `originY` property to. If `undefined` or `null` it uses the `originX` value.
         * @param stepX This is added to the `originX` amount, multiplied by the iteration counter. Default 0.
         * @param stepY This is added to the `originY` amount, multiplied by the iteration counter. Default 0.
         * @param index An optional offset to start searching from within the items array. Default 0.
         * @param direction The direction to iterate through the array. 1 is from beginning to end, -1 from end to beginning. Default 1.
         */
        function SetOrigin<G extends Phaser.GameObjects.GameObject[]>(items: G, originX: number, originY?: number, stepX?: number, stepY?: number, index?: integer, direction?: integer): G;

        /**
         * Takes an array of Game Objects, or any objects that have the public property `rotation`
         * and then sets it to the given value.
         * 
         * The optional `step` property is applied incrementally, multiplied by each item in the array.
         * 
         * To use this with a Group: `SetRotation(group.getChildren(), value, step)`
         * @param items The array of items to be updated by this action.
         * @param value The amount to set the property to.
         * @param step This is added to the `value` amount, multiplied by the iteration counter. Default 0.
         * @param index An optional offset to start searching from within the items array. Default 0.
         * @param direction The direction to iterate through the array. 1 is from beginning to end, -1 from end to beginning. Default 1.
         */
        function SetRotation<G extends Phaser.GameObjects.GameObject[]>(items: G, value: number, step?: number, index?: integer, direction?: integer): G;

        /**
         * Takes an array of Game Objects, or any objects that have the public properties `scaleX` and `scaleY`
         * and then sets them to the given values.
         * 
         * The optional `stepX` and `stepY` properties are applied incrementally, multiplied by each item in the array.
         * 
         * To use this with a Group: `SetScale(group.getChildren(), scaleX, scaleY, stepX, stepY)`
         * @param items The array of items to be updated by this action.
         * @param scaleX The amount to set the `scaleX` property to.
         * @param scaleY The amount to set the `scaleY` property to. If `undefined` or `null` it uses the `scaleX` value.
         * @param stepX This is added to the `scaleX` amount, multiplied by the iteration counter. Default 0.
         * @param stepY This is added to the `scaleY` amount, multiplied by the iteration counter. Default 0.
         * @param index An optional offset to start searching from within the items array. Default 0.
         * @param direction The direction to iterate through the array. 1 is from beginning to end, -1 from end to beginning. Default 1.
         */
        function SetScale<G extends Phaser.GameObjects.GameObject[]>(items: G, scaleX: number, scaleY?: number, stepX?: number, stepY?: number, index?: integer, direction?: integer): G;

        /**
         * Takes an array of Game Objects, or any objects that have the public property `scaleX`
         * and then sets it to the given value.
         * 
         * The optional `step` property is applied incrementally, multiplied by each item in the array.
         * 
         * To use this with a Group: `SetScaleX(group.getChildren(), value, step)`
         * @param items The array of items to be updated by this action.
         * @param value The amount to set the property to.
         * @param step This is added to the `value` amount, multiplied by the iteration counter. Default 0.
         * @param index An optional offset to start searching from within the items array. Default 0.
         * @param direction The direction to iterate through the array. 1 is from beginning to end, -1 from end to beginning. Default 1.
         */
        function SetScaleX<G extends Phaser.GameObjects.GameObject[]>(items: G, value: number, step?: number, index?: integer, direction?: integer): G;

        /**
         * Takes an array of Game Objects, or any objects that have the public property `scaleY`
         * and then sets it to the given value.
         * 
         * The optional `step` property is applied incrementally, multiplied by each item in the array.
         * 
         * To use this with a Group: `SetScaleY(group.getChildren(), value, step)`
         * @param items The array of items to be updated by this action.
         * @param value The amount to set the property to.
         * @param step This is added to the `value` amount, multiplied by the iteration counter. Default 0.
         * @param index An optional offset to start searching from within the items array. Default 0.
         * @param direction The direction to iterate through the array. 1 is from beginning to end, -1 from end to beginning. Default 1.
         */
        function SetScaleY<G extends Phaser.GameObjects.GameObject[]>(items: G, value: number, step?: number, index?: integer, direction?: integer): G;

        /**
         * [description]
         * @param items An array of Game Objects. The contents of this array are updated by this Action.
         * @param topLeft [description]
         * @param topRight [description]
         * @param bottomLeft [description]
         * @param bottomRight [description]
         */
        function SetTint<G extends Phaser.GameObjects.GameObject[]>(items: G, topLeft: number, topRight?: number, bottomLeft?: number, bottomRight?: number): G;

        /**
         * Takes an array of Game Objects, or any objects that have the public property `visible`
         * and then sets it to the given value.
         * 
         * To use this with a Group: `SetVisible(group.getChildren(), value)`
         * @param items The array of items to be updated by this action.
         * @param value The value to set the property to.
         * @param index An optional offset to start searching from within the items array. Default 0.
         * @param direction The direction to iterate through the array. 1 is from beginning to end, -1 from end to beginning. Default 1.
         */
        function SetVisible<G extends Phaser.GameObjects.GameObject[]>(items: G, value: boolean, index?: integer, direction?: integer): G;

        /**
         * Takes an array of Game Objects, or any objects that have the public property `x`
         * and then sets it to the given value.
         * 
         * The optional `step` property is applied incrementally, multiplied by each item in the array.
         * 
         * To use this with a Group: `SetX(group.getChildren(), value, step)`
         * @param items The array of items to be updated by this action.
         * @param value The amount to set the property to.
         * @param step This is added to the `value` amount, multiplied by the iteration counter. Default 0.
         * @param index An optional offset to start searching from within the items array. Default 0.
         * @param direction The direction to iterate through the array. 1 is from beginning to end, -1 from end to beginning. Default 1.
         */
        function SetX<G extends Phaser.GameObjects.GameObject[]>(items: G, value: number, step?: number, index?: integer, direction?: integer): G;

        /**
         * Takes an array of Game Objects, or any objects that have the public properties `x` and `y`
         * and then sets them to the given values.
         * 
         * The optional `stepX` and `stepY` properties are applied incrementally, multiplied by each item in the array.
         * 
         * To use this with a Group: `SetXY(group.getChildren(), x, y, stepX, stepY)`
         * @param items The array of items to be updated by this action.
         * @param x The amount to set the `x` property to.
         * @param y The amount to set the `y` property to. If `undefined` or `null` it uses the `x` value. Default x.
         * @param stepX This is added to the `x` amount, multiplied by the iteration counter. Default 0.
         * @param stepY This is added to the `y` amount, multiplied by the iteration counter. Default 0.
         * @param index An optional offset to start searching from within the items array. Default 0.
         * @param direction The direction to iterate through the array. 1 is from beginning to end, -1 from end to beginning. Default 1.
         */
        function SetXY<G extends Phaser.GameObjects.GameObject[]>(items: G, x: number, y?: number, stepX?: number, stepY?: number, index?: integer, direction?: integer): G;

        /**
         * Takes an array of Game Objects, or any objects that have the public property `y`
         * and then sets it to the given value.
         * 
         * The optional `step` property is applied incrementally, multiplied by each item in the array.
         * 
         * To use this with a Group: `SetY(group.getChildren(), value, step)`
         * @param items The array of items to be updated by this action.
         * @param value The amount to set the property to.
         * @param step This is added to the `value` amount, multiplied by the iteration counter. Default 0.
         * @param index An optional offset to start searching from within the items array. Default 0.
         * @param direction The direction to iterate through the array. 1 is from beginning to end, -1 from end to beginning. Default 1.
         */
        function SetY<G extends Phaser.GameObjects.GameObject[]>(items: G, value: number, step?: number, index?: integer, direction?: integer): G;

        /**
         * Iterate through items changing the position of each element to
         * be that of the element that came before it in the array (or after it if direction = 1)
         * The first items position is set to x/y.
         * The final x/y coords are returned
         * @param items An array of Game Objects. The contents of this array are updated by this Action.
         * @param x [description]
         * @param y [description]
         * @param direction [description] Default 0.
         * @param output [description]
         */
        function ShiftPosition<G extends Phaser.GameObjects.GameObject[], O extends Phaser.Math.Vector2>(items: G, x: number, y: number, direction?: integer, output?: O): O;

        /**
         * [description]
         * @param items An array of Game Objects. The contents of this array are updated by this Action.
         */
        function Shuffle<G extends Phaser.GameObjects.GameObject[]>(items: G): G;

        /**
         * [description]
         * @param items An array of Game Objects. The contents of this array are updated by this Action.
         * @param property [description]
         * @param min [description]
         * @param max [description]
         * @param inc [description]
         */
        function SmootherStep<G extends Phaser.GameObjects.GameObject[]>(items: G, property: string, min: number, max: number, inc: number): G;

        /**
         * [description]
         * @param items An array of Game Objects. The contents of this array are updated by this Action.
         * @param property [description]
         * @param min [description]
         * @param max [description]
         * @param inc [description]
         */
        function SmoothStep<G extends Phaser.GameObjects.GameObject[]>(items: G, property: string, min: number, max: number, inc: number): G;

        /**
         * [description]
         * @param items An array of Game Objects. The contents of this array are updated by this Action.
         * @param property [description]
         * @param min [description]
         * @param max [description]
         * @param inc [description] Default false.
         */
        function Spread<G extends Phaser.GameObjects.GameObject[]>(items: G, property: string, min: number, max: number, inc?: number): G;

        /**
         * [description]
         * @param items An array of Game Objects. The contents of this array are updated by this Action.
         */
        function ToggleVisible<G extends Phaser.GameObjects.GameObject[]>(items: G): G;

        /**
         * Wrap each item's coordinates within a rectangle's area.
         * @param items An array of Game Objects. The contents of this array are updated by this Action.
         * @param rect The rectangle.
         * @param padding An amount added to each side of the rectangle during the operation. Default 0.
         */
        function WrapInRectangle<G extends Phaser.GameObjects.GameObject[]>(items: G, rect: Phaser.Geom.Rectangle, padding?: number): G;

    }

    namespace Animations {
        /**
         * A Frame based Animation.
         * 
         * 
         * 
         * This consists of a key, some default values (like the frame rate) and a bunch of Frame objects.
         * 
         * 
         * 
         * The Animation Manager creates these. Game Objects don't own an instance of these directly.
         * 
         * Game Objects have the Animation Component, which are like playheads to global Animations (these objects)
         * 
         * So multiple Game Objects can have playheads all pointing to this one Animation instance.
         */
        class Animation {
            /**
             * 
             * @param manager [description]
             * @param key [description]
             * @param config [description]
             */
            constructor(manager: Phaser.Animations.AnimationManager, key: string, config: AnimationConfig);

            /**
             * [description]
             */
            manager: Phaser.Animations.AnimationManager;

            /**
             * [description]
             */
            key: string;

            /**
             * A frame based animation (as opposed to a bone based animation)
             */
            type: string;

            /**
             * Extract all the frame data into the frames array
             */
            frames: Phaser.Animations.AnimationFrame[];

            /**
             * The frame rate of playback in frames per second (default 24 if duration is null)
             */
            frameRate: integer;

            /**
             * How long the animation should play for.
             * If frameRate is set it overrides this value otherwise frameRate is derived from duration.
             */
            duration: integer;

            /**
             * ms per frame (without including frame specific modifiers)
             */
            msPerFrame: integer;

            /**
             * Skip frames if the time lags, or always advanced anyway?
             */
            skipMissedFrames: boolean;

            /**
             * Delay before starting playback (in seconds)
             */
            delay: integer;

            /**
             * Number of times to repeat the animation (-1 for infinity)
             */
            repeat: integer;

            /**
             * Delay before the repeat starts (in seconds)
             */
            repeatDelay: integer;

            /**
             * Should the animation yoyo? (reverse back down to the start) before repeating?
             */
            yoyo: boolean;

            /**
             * Should sprite.visible = true when the animation starts to play?
             */
            showOnStart: boolean;

            /**
             * Should sprite.visible = false when the animation finishes?
             */
            hideOnComplete: boolean;

            /**
             * [description]
             */
            callbackScope: any;

            /**
             * [description]
             */
            onStart: false | Function;

            /**
             * [description]
             */
            onStartParams: any[];

            /**
             * [description]
             */
            onRepeat: false | Function;

            /**
             * [description]
             */
            onRepeatParams: any[];

            /**
             * Called for EVERY frame of the animation.
             * See AnimationFrame.onUpdate for a frame specific callback.
             */
            onUpdate: false | Function;

            /**
             * [description]
             */
            onUpdateParams: any[];

            /**
             * [description]
             */
            onComplete: false | Function;

            /**
             * [description]
             */
            onCompleteParams: any[];

            /**
             * Global pause, effects all Game Objects using this Animation instance
             */
            paused: boolean;

            /**
             * [description]
             * @param config [description]
             */
            addFrame(config: string | AnimationFrameConfig[]): Phaser.Animations.Animation;

            /**
             * [description]
             * @param index [description]
             * @param config [description]
             */
            addFrameAt(index: integer, config: string | AnimationFrameConfig[]): Phaser.Animations.Animation;

            /**
             * [description]
             * @param index [description]
             */
            checkFrame(index: integer): boolean;

            /**
             * [description]
             * @param component [description]
             */
            completeAnimation(component: Phaser.GameObjects.Components.Animation): void;

            /**
             * [description]
             * @param component [description]
             * @param includeDelay [description] Default true.
             */
            getFirstTick(component: Phaser.GameObjects.Components.Animation, includeDelay?: boolean): void;

            /**
             * [description]
             * @param index [description]
             */
            getFrameAt(index: integer): Phaser.Animations.AnimationFrame;

            /**
             * [description]
             * @param textureManager [description]
             * @param frames [description]
             * @param defaultTextureKey [description]
             */
            getFrames(textureManager: Phaser.Textures.TextureManager, frames: string | AnimationFrameConfig[], defaultTextureKey?: string): Phaser.Animations.AnimationFrame[];

            /**
             * [description]
             * @param component [description]
             */
            getNextTick(component: Phaser.GameObjects.Components.Animation): void;

            /**
             * [description]
             * @param component [description]
             * @param startFrame [description]
             */
            load(component: Phaser.GameObjects.Components.Animation, startFrame: integer): void;

            /**
             * [description]
             * @param component [description]
             */
            nextFrame(component: Phaser.GameObjects.Components.Animation): void;

            /**
             * [description]
             * @param component [description]
             */
            previousFrame(component: Phaser.GameObjects.Components.Animation): void;

            /**
             * [description]
             * @param frame [description]
             */
            removeFrame(frame: Phaser.Animations.AnimationFrame): Phaser.Animations.Animation;

            /**
             * [description]
             * @param index [description]
             */
            removeFrameAt(index: integer): Phaser.Animations.Animation;

            /**
             * [description]
             * @param component [description]
             */
            repeatAnimation(component: Phaser.GameObjects.Components.Animation): void;

            /**
             * [description]
             * @param component [description]
             */
            setFrame(component: Phaser.GameObjects.Components.Animation): void;

            /**
             * [description]
             */
            toJSON(): JSONAnimation;

            /**
             * [description]
             */
            updateFrameSequence(): Phaser.Animations.Animation;

            /**
             * [description]
             */
            pause(): Phaser.Animations.Animation;

            /**
             * [description]
             */
            resume(): Phaser.Animations.Animation;

            /**
             * [description]
             */
            destroy(): void;

        }

        /**
         * A single frame in an Animation sequence.
         * 
         * 
         * 
         * An AnimationFrame consists of a reference to the Texture it uses for rendering, references to other
         * 
         * frames in the animation, and index data. It also has the ability to fire its own `onUpdate` callback
         * 
         * and modify the animation timing.
         * 
         * 
         * 
         * AnimationFrames are generated automatically by the Animation class.
         */
        class AnimationFrame {
            /**
             * 
             * @param textureKey The key of the Texture this AnimationFrame uses.
             * @param textureFrame The key of the Frame within the Texture that this AnimationFrame uses.
             * @param index The index of this AnimationFrame within the Animation sequence.
             * @param frame A reference to the Texture Frame this AnimationFrame uses for rendering.
             */
            constructor(textureKey: string, textureFrame: string | integer, index: integer, frame: Phaser.Textures.Frame);

            /**
             * The key of the Texture this AnimationFrame uses.
             */
            textureKey: string;

            /**
             * The key of the Frame within the Texture that this AnimationFrame uses.
             */
            textureFrame: string | integer;

            /**
             * The index of this AnimationFrame within the Animation sequence.
             */
            index: integer;

            /**
             * A reference to the Texture Frame this AnimationFrame uses for rendering.
             */
            frame: Phaser.Textures.Frame;

            /**
             * Is this the first frame in an animation sequence?
             */
            isFirst: boolean;

            /**
             * Is this the last frame in an animation sequence?
             */
            isLast: boolean;

            /**
             * A reference to the AnimationFrame that comes before this one in the animation, if any.
             */
            prevFrame: Phaser.Animations.AnimationFrame;

            /**
             * A reference to the AnimationFrame that comes after this one in the animation, if any.
             */
            nextFrame: Phaser.Animations.AnimationFrame;

            /**
             * Additional time (in ms) that this frame should appear for during playback.
             * The value is added onto the msPerFrame set by the animation.
             */
            duration: number;

            /**
             * What % through the animation does this frame come?
             * This value is generated when the animation is created and cached here.
             */
            progress: number;

            /**
             * A frame specific callback, invoked if this frame gets displayed and the callback is set.
             */
            onUpdate: Function;

            /**
             * Generates a JavaScript object suitable for converting to JSON.
             */
            toJSON(): JSONAnimationFrame;

            /**
             * Destroys this object by removing references to external resources and callbacks.
             */
            destroy(): void;

        }

        /**
         * The Animation Manager.
         * 
         * 
         * 
         * Animations are managed by the global Animation Manager. This is a singleton class that is
         * 
         * responsible for creating and delivering animations and their corresponding data to all Game Objects.
         * 
         * Unlike plugins it is owned by the Game instance, not the Scene.
         * 
         * 
         * 
         * Sprites and other Game Objects get the data they need from the AnimationManager.
         */
        class AnimationManager extends Phaser.Events.EventEmitter {
            /**
             * 
             * @param game [description]
             */
            constructor(game: Phaser.Game);

            /**
             * [description]
             */
            protected game: Phaser.Game;

            /**
             * [description]
             */
            protected textureManager: Phaser.Textures.TextureManager;

            /**
             * [description]
             */
            globalTimeScale: number;

            /**
             * [description]
             */
            protected anims: Phaser.Structs.Map<string, Phaser.Animations.Animation>;

            /**
             * [description]
             */
            paused: boolean;

            /**
             * [description]
             */
            name: string;

            /**
             * [description]
             */
            boot(): void;

            /**
             * [description]
             * @param key [description]
             * @param animation [description]
             */
            add(key: string, animation: Phaser.Animations.Animation): Phaser.Animations.AnimationManager;

            /**
             * [description]
             * @param config [description]
             */
            create(config: AnimationConfig): Phaser.Animations.Animation;

            /**
             * [description]
             * @param data [description]
             * @param clearCurrentAnimations [description] Default false.
             */
            fromJSON(data: string | JSONAnimationManager | JSONAnimation, clearCurrentAnimations?: boolean): Phaser.Animations.Animation[];

            /**
             * [description]
             * @param key [description]
             * @param config [description]
             * @param config.prefix [description] Default ''.
             * @param config.start [description] Default 0.
             * @param config.end [description] Default 0.
             * @param config.suffix [description] Default ''.
             * @param config.zeroPad [description] Default 0.
             * @param config.outputArray [description] Default [].
             * @param config.frames [description] Default false.
             */
            generateFrameNames(key: string, config: object): AnimationFrameConfig[];

            /**
             * [description]
             * @param key [description]
             * @param config [description]
             * @param config.start [description] Default 0.
             * @param config.end [description] Default -1.
             * @param config.first [description] Default false.
             * @param config.outputArray [description] Default [].
             * @param config.frames [description] Default false.
             */
            generateFrameNumbers(key: string, config: object): AnimationFrameConfig[];

            /**
             * [description]
             * @param key [description]
             */
            get(key: string): Phaser.Animations.Animation;

            /**
             * Load an Animation into a Game Objects Animation Component.
             * @param child [description]
             * @param key [description]
             * @param startFrame [description]
             */
            load(child: Phaser.GameObjects.GameObject, key: string, startFrame?: string | integer): Phaser.GameObjects.GameObject;

            /**
             * [description]
             */
            pauseAll(): Phaser.Animations.AnimationManager;

            /**
             * [description]
             * @param key [description]
             * @param child [description]
             */
            play(key: string, child: Phaser.GameObjects.GameObject): Phaser.Animations.AnimationManager;

            /**
             * [description]
             * @param key [description]
             */
            remove(key: string): Phaser.Animations.Animation;

            /**
             * [description]
             */
            resumeAll(): Phaser.Animations.AnimationManager;

            /**
             * [description]
             * @param key [description]
             * @param child [description]
             * @param stagger [description] Default 0.
             */
            staggerPlay(key: string, child: Phaser.GameObjects.GameObject, stagger?: number): Phaser.Animations.AnimationManager;

            /**
             * [description]
             * @param key [description]
             */
            toJSON(key: string): JSONAnimationManager;

            /**
             * [description]
             */
            destroy(): void;

        }

    }

    /**
     * The Phaser.Game instance is the main controller for the entire Phaser game. It is responsible
     * 
     * for handling the boot process, parsing the configuration values, creating the renderer,
     * 
     * and setting-up all of the global Phaser systems, such as sound and input.
     * 
     * Once that is complete it will start the Scene Manager and then begin the main game loop.
     * 
     * 
     * 
     * You should generally avoid accessing any of the systems created by Game, and instead use those
     * 
     * made available to you via the Phaser.Scene Systems class instead.
     */
    class Game {
        /**
         * 
         * @param GameConfig The configuration object for your Phaser Game instance.
         */
        constructor(GameConfig?: GameConfig);

        /**
         * The parsed Game Configuration object.
         * 
         * The values stored within this object are read-only and should not be changed at run-time.
         */
        config: Phaser.Boot.Config;

        /**
         * A reference to either the Canvas or WebGL Renderer that this Game is using.
         */
        renderer: Phaser.Renderer.Canvas.CanvasRenderer | Phaser.Renderer.WebGL.WebGLRenderer;

        /**
         * A reference to the HTML Canvas Element on which the renderer is drawing.
         */
        canvas: HTMLCanvasElement;

        /**
         * A reference to the Canvas Rendering Context belonging to the Canvas Element this game is rendering to.
         */
        context: CanvasRenderingContext2D;

        /**
         * A flag indicating when this Game instance has finished its boot process.
         */
        isBooted: boolean;

        /**
         * A flag indicating if this Game is currently running its game step or not.
         */
        isRunning: boolean;

        /**
         * An Event Emitter which is used to broadcast game-level events from the global systems.
         */
        events: Phaser.Events.EventEmitter;

        /**
         * An instance of the Animation Manager.
         * 
         * The Animation Manager is a global system responsible for managing all animations used within your game.
         */
        anims: Phaser.Animations.AnimationManager;

        /**
         * An instance of the Texture Manager.
         * 
         * The Texture Manager is a global system responsible for managing all textures being used by your game.
         */
        textures: Phaser.Textures.TextureManager;

        /**
         * An instance of the Cache Manager.
         * 
         * The Cache Manager is a global system responsible for caching, accessing and releasing external game assets.
         */
        cache: Phaser.Cache.CacheManager;

        /**
         * [description]
         */
        registry: Phaser.Data.DataManager;

        /**
         * An instance of the Input Manager.
         * 
         * The Input Manager is a global system responsible for the capture of browser-level input events.
         */
        input: Phaser.Input.InputManager;

        /**
         * An instance of the Scene Manager.
         * 
         * The Scene Manager is a global system responsible for creating, modifying and updating the Scenes in your game.
         */
        scene: Phaser.Scenes.SceneManager;

        /**
         * A reference to the Device inspector.
         * 
         * Contains information about the device running this game, such as OS, browser vendor and feature support.
         * Used by various systems to determine capabilities and code paths.
         */
        device: Phaser.DeviceConf;

        /**
         * An instance of the base Sound Manager.
         * 
         * The Sound Manager is a global system responsible for the playback and updating of all audio in your game.
         */
        sound: Phaser.Sound.BaseSoundManager;

        /**
         * An instance of the Time Step.
         * 
         * The Time Step is a global system responsible for setting-up and responding to the browser frame events, processing
         * them and calculating delta values. It then automatically calls the game step.
         */
        loop: Phaser.Boot.TimeStep;

        /**
         * An instance of the Plugin Manager.
         * 
         * The Plugin Manager is a global system that allows plugins to register themselves with it, and can then install
         * those plugins into Scenes as required.
         */
        plugins: Phaser.Boot.PluginManager;

        /**
         * This method is called automatically when the DOM is ready. It is responsible for creating the renderer,
         * displaying the Debug Header, adding the game canvas to the DOM and emitting the 'boot' event.
         * It listens for a 'ready' event from the base systems and once received it will call `Game.start`.
         */
        protected boot(): void;

        /**
         * Called automatically by Game.boot once all of the global systems have finished setting themselves up.
         * By this point the Game is now ready to start the main loop running.
         * It will also enable the Visibility Handler.
         */
        protected start(): void;

        /**
         * The main Game Step. Called automatically by the Time Step, once per browser frame (typically as a result of
         * Request Animation Frame, or Set Timeout on very old browsers.)
         * 
         * The step will update the global managers first, then proceed to update each Scene in turn, via the Scene Manager.
         * 
         * It will then render each Scene in turn, via the Renderer. This process emits `prerender` and `postrender` events.
         * @param time The current timestamp as generated by the Request Animation Frame or SetTimeout.
         * @param delta The delta time, in ms, elapsed since the last frame.
         */
        step(time: integer, delta: number): void;

        /**
         * A special version of the Game Step for the HEADLESS renderer only.
         * 
         * The main Game Step. Called automatically by the Time Step, once per browser frame (typically as a result of
         * Request Animation Frame, or Set Timeout on very old browsers.)
         * 
         * The step will update the global managers first, then proceed to update each Scene in turn, via the Scene Manager.
         * 
         * This process emits `prerender` and `postrender` events, even though nothing actually displays.
         * @param time The current timestamp as generated by the Request Animation Frame or SetTimeout.
         * @param delta The delta time elapsed since the last frame.
         */
        headlessStep(time: integer, delta: number): void;

        /**
         * Called automatically by the Visibility Handler.
         * This will pause the main loop and then emit a pause event.
         */
        protected onHidden(): void;

        /**
         * Called automatically by the Visibility Handler.
         * This will resume the main loop and then emit a resume event.
         */
        protected onVisible(): void;

        /**
         * Called automatically by the Visibility Handler.
         * This will set the main loop into a 'blurred' state, which pauses it.
         */
        protected onBlur(): void;

        /**
         * Called automatically by the Visibility Handler.
         * This will set the main loop into a 'focused' state, which resumes it.
         */
        protected onFocus(): void;

        /**
         * Updates the Game Config with the new width and height values given.
         * Then resizes the Renderer and Input Manager scale.
         * @param width The new width of the game.
         * @param height The new height of the game.
         */
        resize(width: number, height: number): void;

        /**
         * Destroys this Phaser.Game instance, all global systems, all sub-systems and all Scenes.
         */
        destroy(): void;

    }

    namespace Boot {
        /**
         * [description]
         */
        class Config {
            /**
             * 
             * @param GameConfig The configuration object for your Phaser Game instance.
             */
            constructor(GameConfig?: GameConfig);

        }

        /**
         * Called automatically by Phaser.Game and responsible for creating the renderer it will use.
         * 
         * Relies upon two webpack global flags to be defined: `WEBGL_RENDERER` and `CANVAS_RENDERER` during build time, but not at run-time.
         * @param game The Phaser.Game instance on which the renderer will be set.
         */
        function CreateRenderer(game: Phaser.Game): void;

        /**
         * Called automatically by Phaser.Game and responsible for creating the console.log debug header.
         * 
         * You can customize or disable the header via the Game Config object.
         * @param game The Phaser.Game instance which will output this debug header.
         */
        function DebugHeader(game: Phaser.Game): void;

        /**
         * The PluginManager is global and belongs to the Game instance, not a Scene.
         * 
         * It handles the installation and removal of all global and Scene based plugins.
         * 
         * Plugins automatically register themselves with the PluginManager in their respective classes.
         */
        class PluginManager {
            /**
             * 
             * @param game [description]
             */
            constructor(game: Phaser.Game);

            /**
             * [description]
             */
            game: Phaser.Game;

            /**
             * [description]
             */
            boot(): void;

            /**
             * [description]
             * @param sys [description]
             * @param globalPlugins [description]
             */
            installGlobal(sys: Phaser.Scenes.Systems, globalPlugins: any[]): void;

            /**
             * [description]
             * @param sys [description]
             * @param scenePlugins [description]
             */
            installLocal(sys: Phaser.Scenes.Systems, scenePlugins: any[]): void;

            /**
             * [description]
             * @param key [description]
             */
            remove(key: string): void;

            /**
             * [description]
             */
            destroy(): void;

        }

        /**
         * [description]
         */
        class TimeStep {
            /**
             * 
             * @param game A reference to the Phaser.Game instance that owns this Time Step.
             */
            constructor(game: Phaser.Game, config: FPSConfig);

            /**
             * Called when the DOM window.onBlur event triggers.
             */
            blur(): void;

            /**
             * Called when the DOM window.onFocus event triggers.
             */
            focus(): void;

            /**
             * Called when the visibility API says the game is 'hidden' (tab switch out of view, etc)
             */
            pause(): void;

            /**
             * Called when the visibility API says the game is 'visible' again (tab switch back into view, etc)
             */
            resume(): void;

            /**
             * [description]
             */
            resetDelta(): void;

            /**
             * Starts the Time Step running, if it is not already doing so.
             * Called automatically by the Game Boot process.
             * @param callback The callback to be invoked each time the Time Step steps.
             */
            start(callback: TimeStepCallback): void;

            /**
             * The main step method. This is called each time the browser updates, either by Request Animation Frame,
             * or by Set Timeout. It is responsible for calculating the delta values, frame totals, cool down history and more.
             * You generally should never call this method directly.
             * @param time The current time. Either a High Resolution Timer value if it comes from Request Animation Frame, or Date.now if using SetTimeout.
             */
            step(time: integer): void;

            /**
             * Manually calls TimeStep.step, passing in the performance.now value to it.
             */
            tick(): void;

            /**
             * Sends the TimeStep to sleep, stopping Request Animation Frame (or SetTimeout) and toggling the `running` flag to false.
             */
            sleep(): void;

            /**
             * Wakes-up the TimeStep, restarting Request Animation Frame (or SetTimeout) and toggling the `running` flag to true.
             * The `seamless` argument controls if the wake-up should adjust the start time or not.
             * @param seamless Adjust the startTime based on the lastTime values. Default false.
             */
            wake(seamless?: boolean): void;

            /**
             * Stops the TimeStep running.
             */
            stop(): Phaser.Boot.TimeStep;

            /**
             * Destroys the TimeStep. This will stop Request Animation Frame, stop the step, clear the callbacks and null
             * any objects.
             */
            destroy(): void;

        }

        /**
         * The Visibility Handler is responsible for listening out for document level visibility change events.
         * This includes `visibilitychange` if the browser supports it, and blur and focus events. It then uses
         * the provided Event Emitter and fires the related events.
         * @param eventEmitter The EventEmitter that will emit the visibility events.
         */
        function VisibilityHandler(eventEmitter: Phaser.Events.EventEmitter): void;

    }

    namespace Cache {
        /**
         * The BaseCache is a base Cache class that can be used for storing references to any kind of data.
         * 
         * 
         * 
         * Data can be added, retrieved and removed based on the given keys.
         * 
         * 
         * 
         * Keys are string-based.
         */
        class BaseCache {
            /**
             * The Map in which the cache objects are stored.
             * 
             * You can query the Map directly or use the BaseCache methods.
             */
            entries: Phaser.Structs.Map<String, any>;

            /**
             * An instance of EventEmitter used by the cache to emit related events.
             */
            events: Phaser.Events.EventEmitter;

            /**
             * Adds an item to this cache. The item is referenced by a unique string, which you are responsible
             * for setting and keeping track of. The item can only be retrieved by using this string.
             * @param key The unique key by which the data added to the cache will be referenced.
             * @param data The data to be stored in the cache.
             */
            add(key: string, data: any): Phaser.Cache.BaseCache;

            /**
             * Checks if this cache contains an item matching the given key.
             * @param key The unique key of the item to be checked in this cache.
             */
            has(key: string): boolean;

            /**
             * Gets an item from this cache based on the given key.
             * @param key The unique key of the item to be retrieved from this cache.
             */
            get(key: string): any;

            /**
             * Removes and item from this cache based on the given key.
             * 
             * If an entry matching the key is found it is removed from the cache and a `remove` event emitted.
             * No additional checks are done on the item removed. If other systems or parts of your game code
             * are relying on this item, it is up to you to sever those relationships prior to removing the item.
             * @param key The unique key of the item to remove from the cache.
             */
            remove(key: string): Phaser.Cache.BaseCache;

            /**
             * Destroys this cache and all items within it.
             */
            destroy(): void;

        }

        /**
         * The Cache Manager is the global cache owned and maintained by the Game instance.
         * 
         * 
         * 
         * Various systems, such as the file Loader, rely on this cache in order to store the files
         * 
         * it has loaded. The manager itself doesn't store any files, but instead owns multiple BaseCache
         * 
         * instances, one per type of file. You can also add your own custom caches.
         */
        class CacheManager {
            /**
             * 
             * @param game A reference to the Phaser.Game instance that owns this CacheManager.
             */
            constructor(game: Phaser.Game);

            /**
             * A reference to the Phaser.Game instance that owns this CacheManager.
             */
            protected game: Phaser.Game;

            /**
             * A Cache storing all binary files, typically added via the Loader.
             */
            protected binary: Phaser.Cache.BaseCache;

            /**
             * A Cache storing all bitmap font data files, typically added via the Loader.
             * Only the font data is stored in this cache, the textures are part of the Texture Manager.
             */
            protected bitmapFont: Phaser.Cache.BaseCache;

            /**
             * A Cache storing all JSON data files, typically added via the Loader.
             */
            protected json: Phaser.Cache.BaseCache;

            /**
             * A Cache storing all physics data files, typically added via the Loader.
             */
            protected physics: Phaser.Cache.BaseCache;

            /**
             * A Cache storing all shader source files, typically added via the Loader.
             */
            protected shader: Phaser.Cache.BaseCache;

            /**
             * A Cache storing all non-streaming audio files, typically added via the Loader.
             */
            protected audio: Phaser.Cache.BaseCache;

            /**
             * A Cache storing all text files, typically added via the Loader.
             */
            protected text: Phaser.Cache.BaseCache;

            /**
             * A Cache storing all WaveFront OBJ files, typically added via the Loader.
             */
            protected obj: Phaser.Cache.BaseCache;

            /**
             * A Cache storing all tilemap data files, typically added via the Loader.
             * Only the data is stored in this cache, the textures are part of the Texture Manager.
             */
            protected tilemap: Phaser.Cache.BaseCache;

            /**
             * A Cache storing all xml data files, typically added via the Loader.
             */
            protected xml: Phaser.Cache.BaseCache;

            /**
             * An object that contains your own custom BaseCache entries.
             * Add to this via the `addCustom` method.
             */
            protected custom: {[key: string]: Phaser.Cache.BaseCache};

            /**
             * Add your own custom Cache for storing your own files.
             * The cache will be available under `Cache.custom.key`.
             * The cache will only be created if the key is not already in use.
             * @param key The unique key of your custom cache.
             */
            addCustom(key: string): Phaser.Cache.BaseCache;

            /**
             * Removes all entries from all BaseCaches and destroys all custom caches.
             */
            destroy(): void;

        }

    }

    namespace Cameras {
        namespace Scene2D {
            /**
             * [description]
             */
            class Camera {
                /**
                 * 
                 * @param x The x position of the Camera, relative to the top-left of the game canvas.
                 * @param y The y position of the Camera, relative to the top-left of the game canvas.
                 * @param width The width of the Camera, in pixels.
                 * @param height The height of the Camera, in pixels.
                 */
                constructor(x: number, y: number, width: number, height: number);

                /**
                 * A reference to the Scene this camera belongs to.
                 */
                scene: Phaser.Scene;

                /**
                 * The name of the Camera. This is left empty for your own use.
                 */
                name: string;

                /**
                 * The x position of the Camera, relative to the top-left of the game canvas.
                 */
                x: number;

                /**
                 * The y position of the Camera, relative to the top-left of the game canvas.
                 */
                y: number;

                /**
                 * The width of the Camera, in pixels.
                 */
                width: number;

                /**
                 * The height of the Camera, in pixels.
                 */
                height: number;

                /**
                 * Should this camera round its pixel values to integers?
                 */
                roundPixels: boolean;

                /**
                 * Is this Camera using a bounds to restrict scrolling movement?
                 * Set this property along with the bounds via `Camera.setBounds`.
                 */
                useBounds: boolean;

                /**
                 * Does this Camera allow the Game Objects it renders to receive input events?
                 */
                inputEnabled: boolean;

                /**
                 * The horizontal scroll position of this camera.
                 * Optionally restricted via the Camera bounds.
                 */
                scrollX: number;

                /**
                 * The vertical scroll position of this camera.
                 * Optionally restricted via the Camera bounds.
                 */
                scrollY: number;

                /**
                 * The Camera zoom value. Change this value to zoom in, or out of, a Scene.
                 * Set to 1 to return to the default zoom level.
                 */
                zoom: number;

                /**
                 * The rotation of the Camera. This influences the rendering of all Game Objects visible by this camera.
                 */
                rotation: number;

                /**
                 * A local transform matrix used for internal calculations.
                 */
                matrix: Phaser.GameObjects.Components.TransformMatrix;

                /**
                 * Does this Camera have a transparent background?
                 */
                transparent: boolean;

                /**
                 * TODO
                 */
                clearBeforeRender: boolean;

                /**
                 * The background color of this Camera. Only used if `transparent` is `false`.
                 */
                backgroundColor: Phaser.Display.Color;

                /**
                 * Should the camera cull Game Objects before rendering?
                 * In some special cases it may be beneficial to disable this.
                 */
                disableCull: boolean;

                /**
                 * A temporary array of culled objects.
                 */
                culledObjects: Phaser.GameObjects.GameObject[];

                /**
                 * [description]
                 */
                centerToBounds(): Phaser.Cameras.Scene2D.Camera;

                /**
                 * [description]
                 */
                centerToSize(): Phaser.Cameras.Scene2D.Camera;

                /**
                 * [description]
                 * @param renderableObjects [description]
                 */
                cull<G extends Phaser.GameObjects.GameObject[]>(renderableObjects: G): G;

                /**
                 * [description]
                 * @param interactiveObjects [description]
                 */
                cullHitTest<G extends Phaser.GameObjects.GameObject[]>(interactiveObjects: G): G;

                /**
                 * [description]
                 * @param tilemap [description]
                 */
                cullTilemap(tilemap: Phaser.Tilemaps.Tilemap): Phaser.GameObjects.GameObject[];

                /**
                 * Fades the Camera in from the given color over the duration specified.
                 * @param duration The duration of the effect in milliseconds.
                 * @param callback An optional callback to invoke when the fade completes. Will be sent one argument - a reference to this camera.
                 * @param red The value to fade the red channel from. A value between 0 and 1. Default 0.
                 * @param green The value to fade the green channel from. A value between 0 and 1. Default 0.
                 * @param blue The value to fade the blue channel from. A value between 0 and 1. Default 0.
                 */
                fadeIn(duration: number, callback?: Function, red?: number, green?: number, blue?: number): Phaser.Cameras.Scene2D.Camera;

                /**
                 * Fades the Camera out to the given color over the duration specified.
                 * This is an alias for Camera.fade that forces the fade to start, regardless of existing fades.
                 * @param duration The duration of the effect in milliseconds.
                 * @param callback An optional callback to invoke when the fade completes. Will be sent one argument - a reference to this camera.
                 * @param red The value to fade the red channel from. A value between 0 and 1. Default 0.
                 * @param green The value to fade the green channel from. A value between 0 and 1. Default 0.
                 * @param blue The value to fade the blue channel from. A value between 0 and 1. Default 0.
                 */
                fadeOut(duration: number, callback?: Function, red?: number, green?: number, blue?: number): Phaser.Cameras.Scene2D.Camera;

                /**
                 * Fades the Camera to the given color over the duration specified.
                 * @param duration The duration of the effect in milliseconds.
                 * @param red The value to fade the red channel to. A value between 0 and 1. Default 0.
                 * @param green The value to fade the green channel to. A value between 0 and 1. Default 0.
                 * @param blue The value to fade the blue channel to. A value between 0 and 1. Default 0.
                 * @param force Force the fade effect to start immediately, even if already running. Default false.
                 * @param callback An optional callback to invoke when the fade completes. Will be sent one argument - a reference to this camera.
                 */
                fade(duration: number, red?: number, green?: number, blue?: number, force?: boolean, callback?: Function): Phaser.Cameras.Scene2D.Camera;

                /**
                 * Flashes the Camera to the given color over the duration specified.
                 * @param duration The duration of the effect in milliseconds.
                 * @param red The value to flash the red channel to. A value between 0 and 1. Default 1.
                 * @param green The value to flash the green channel to. A value between 0 and 1. Default 1.
                 * @param blue The value to flash the blue channel to. A value between 0 and 1. Default 1.
                 * @param force Force the flash effect to start immediately, even if already running. Default false.
                 * @param callback An optional callback to invoke when the flash completes. Will be sent one argument - a reference to this camera.
                 */
                flash(duration: number, red?: number, green?: number, blue?: number, force?: boolean, callback?: Function): Phaser.Cameras.Scene2D.Camera;

                /**
                 * Shakes the Camera by the given intensity over the duration specified.
                 * @param duration The duration of the effect in milliseconds.
                 * @param intensity The intensity of the shake. Default 0.05.
                 * @param force Force the shake effect to start immediately, even if already running. Default false.
                 * @param callback An optional callback to invoke when the shake completes. Will be sent one argument - a reference to this camera.
                 */
                shake(duration: number, intensity?: number, force?: boolean, callback?: Function): Phaser.Cameras.Scene2D.Camera;

                /**
                 * [description]
                 * @param x [description]
                 * @param y [description]
                 * @param output [description]
                 */
                getWorldPoint<O extends Phaser.Math.Vector2>(x: number, y: number, output?: O): O;

                /**
                 * [description]
                 * @param gameObjectOrArray [description]
                 */
                ignore(gameObjectOrArray: Phaser.GameObjects.GameObject | Phaser.GameObjects.GameObject[]): Phaser.Cameras.Scene2D.Camera;

                /**
                 * [description]
                 * @param baseScale [description]
                 * @param resolution [description]
                 */
                preRender(baseScale: number, resolution: number): void;

                /**
                 * [description]
                 */
                removeBounds(): Phaser.Cameras.Scene2D.Camera;

                /**
                 * [description]
                 * @param value [description] Default 0.
                 */
                setAngle(value?: number): Phaser.Cameras.Scene2D.Camera;

                /**
                 * [description]
                 * @param color [description] Default 'rgba(0,0,0,0)'.
                 */
                setBackgroundColor(color?: string | number | InputColorObject): Phaser.Cameras.Scene2D.Camera;

                /**
                 * [description]
                 * @param x [description]
                 * @param y [description]
                 * @param width [description]
                 * @param height [description]
                 */
                setBounds(x: number, y: number, width: number, height: number): Phaser.Cameras.Scene2D.Camera;

                /**
                 * [description]
                 * @param value [description] Default ''.
                 */
                setName(value?: string): Phaser.Cameras.Scene2D.Camera;

                /**
                 * [description]
                 * @param x [description]
                 * @param y [description] Default x.
                 */
                setPosition(x: number, y?: number): Phaser.Cameras.Scene2D.Camera;

                /**
                 * [description]
                 * @param value [description] Default 0.
                 */
                setRotation(value?: number): Phaser.Cameras.Scene2D.Camera;

                /**
                 * [description]
                 * @param value [description]
                 */
                setRoundPixels(value: boolean): Phaser.Cameras.Scene2D.Camera;

                /**
                 * [description]
                 * @param scene [description]
                 */
                setScene(scene: Phaser.Scene): Phaser.Cameras.Scene2D.Camera;

                /**
                 * [description]
                 * @param x [description]
                 * @param y [description] Default x.
                 */
                setScroll(x: number, y?: number): Phaser.Cameras.Scene2D.Camera;

                /**
                 * [description]
                 * @param width [description]
                 * @param height [description] Default width.
                 */
                setSize(width: number, height?: number): Phaser.Cameras.Scene2D.Camera;

                /**
                 * [description]
                 * @param x [description]
                 * @param y [description]
                 * @param width [description]
                 * @param height [description]
                 */
                setViewport(x: number, y: number, width: number, height: number): Phaser.Cameras.Scene2D.Camera;

                /**
                 * [description]
                 * @param value [description] Default 1.
                 */
                setZoom(value?: number): Phaser.Cameras.Scene2D.Camera;

                /**
                 * [description]
                 * @param target [description]
                 * @param roundPx [description] Default false.
                 */
                startFollow(target: Phaser.GameObjects.GameObject | object, roundPx?: boolean): Phaser.Cameras.Scene2D.Camera;

                /**
                 * [description]
                 */
                stopFollow(): Phaser.Cameras.Scene2D.Camera;

                /**
                 * [description]
                 */
                toJSON(): JSONCamera;

                /**
                 * Resets any active FX, such as a fade, flash or shake. Useful to call after a fade in order to
                 * remove the fade.
                 */
                resetFX(): Phaser.Cameras.Scene2D.Camera;

                /**
                 * [description]
                 * @param time The current timestamp as generated by the Request Animation Frame or SetTimeout.
                 * @param delta The delta time, in ms, elapsed since the last frame.
                 */
                update(time: integer, delta: number): void;

                /**
                 * [description]
                 */
                destroy(): void;

            }

            /**
             * [description]
             */
            class CameraManager {
                /**
                 * 
                 * @param scene The Scene that owns the Camera Manager plugin.
                 */
                constructor(scene: Phaser.Scene);

                /**
                 * The Scene that owns the Camera Manager plugin.
                 */
                scene: Phaser.Scene;

                /**
                 * A reference to the Scene.Systems handler for the Scene that owns the Camera Manager.
                 */
                systems: Phaser.Scenes.Systems;

                /**
                 * The current Camera ID.
                 */
                currentCameraId: number;

                /**
                 * An Array of the Camera objects being managed by this Camera Manager.
                 */
                cameras: Phaser.Cameras.Scene2D.Camera[];

                /**
                 * A pool of Camera objects available to be used by the Camera Manager.
                 */
                cameraPool: Phaser.Cameras.Scene2D.Camera[];

                /**
                 * The default Camera in the Camera Manager.
                 */
                main: Phaser.Cameras.Scene2D.Camera;

                /**
                 * This scale affects all cameras. It's used by Scale Manager.
                 */
                baseScale: number;

                /**
                 * Called when the Camera Manager boots.
                 * Starts the event listeners running.
                 */
                boot(): void;

                /**
                 * [description]
                 * @param x [description] Default 0.
                 * @param y [description] Default 0.
                 * @param width [description]
                 * @param height [description]
                 * @param makeMain [description] Default false.
                 * @param name [description] Default ''.
                 */
                add(x?: number, y?: number, width?: number, height?: number, makeMain?: boolean, name?: string): Phaser.Cameras.Scene2D.Camera;

                /**
                 * [description]
                 * @param camera [description]
                 */
                addExisting(camera: Phaser.Cameras.Scene2D.Camera): Phaser.Cameras.Scene2D.Camera;

                /**
                 * [description]
                 * @param config [description]
                 */
                fromJSON(config: InputJSONCameraObject | InputJSONCameraObject[]): Phaser.Cameras.Scene2D.CameraManager;

                /**
                 * [description]
                 * @param name [description]
                 */
                getCamera(name: string): Phaser.Cameras.Scene2D.Camera;

                /**
                 * [description]
                 * @param pointer [description]
                 */
                getCameraBelowPointer(pointer: Phaser.Input.Pointer): Phaser.Cameras.Scene2D.Camera;

                /**
                 * [description]
                 * @param camera [description]
                 */
                remove(camera: Phaser.Cameras.Scene2D.Camera): void;

                /**
                 * [description]
                 * @param renderer The Renderer that will render the children to this camera.
                 * @param children An array of renderable Game Objects.
                 * @param interpolation Interpolation value. Reserved for future use.
                 */
                render(renderer: Phaser.Renderer.Canvas.CanvasRenderer | Phaser.Renderer.WebGL.WebGLRenderer, children: Phaser.GameObjects.GameObject[], interpolation: number): void;

                /**
                 * [description]
                 */
                resetAll(): Phaser.Cameras.Scene2D.Camera;

                /**
                 * [description]
                 * @param timestep [description]
                 * @param delta [description]
                 */
                update(timestep: number, delta: number): void;

                /**
                 * Resizes all cameras to the given dimensions.
                 * @param width The new width of the camera.
                 * @param height The new height of the camera.
                 */
                resize(width: number, height: number): void;

                /**
                 * [description]
                 */
                shutdown(): void;

                /**
                 * [description]
                 */
                destroy(): void;

            }

        }

        namespace Controls {
            /**
             * [description]
             */
            class FixedKeyControl {
                /**
                 * 
                 * @param config [description]
                 */
                constructor(config: FixedKeyControlConfig);

                /**
                 * The Camera that this Control will update.
                 */
                camera: Phaser.Cameras.Scene2D.Camera;

                /**
                 * The Key to be pressed that will move the Camera left.
                 */
                left: Phaser.Input.Keyboard.Key;

                /**
                 * The Key to be pressed that will move the Camera right.
                 */
                right: Phaser.Input.Keyboard.Key;

                /**
                 * The Key to be pressed that will move the Camera up.
                 */
                up: Phaser.Input.Keyboard.Key;

                /**
                 * The Key to be pressed that will move the Camera down.
                 */
                down: Phaser.Input.Keyboard.Key;

                /**
                 * The Key to be pressed that will zoom the Camera in.
                 */
                zoomIn: Phaser.Input.Keyboard.Key;

                /**
                 * The Key to be pressed that will zoom the Camera out.
                 */
                zoomOut: Phaser.Input.Keyboard.Key;

                /**
                 * The speed at which the camera will zoom if the `zoomIn` or `zoomOut` keys are pressed.
                 */
                zoomSpeed: number;

                /**
                 * The horizontal speed the camera will move.
                 */
                speedX: number;

                /**
                 * The vertical speed the camera will move.
                 */
                speedY: number;

                /**
                 * A flag controlling if the Controls will update the Camera or not.
                 */
                active: boolean;

                /**
                 * Starts the Key Control running, providing it has been linked to a camera.
                 */
                start(): Phaser.Cameras.Controls.FixedKeyControl;

                /**
                 * Stops this Key Control from running. Call `start` to start it again.
                 */
                stop(): Phaser.Cameras.Controls.FixedKeyControl;

                /**
                 * Binds this Key Control to a camera.
                 * @param camera The camera to bind this Key Control to.
                 */
                setCamera(camera: Phaser.Cameras.Scene2D.Camera): Phaser.Cameras.Controls.FixedKeyControl;

                /**
                 * [description]
                 * @param delta [description]
                 */
                update(delta: number): void;

                /**
                 * Destroys this Key Control.
                 */
                destroy(): void;

            }

            /**
             * [description]
             */
            class SmoothedKeyControl {
                /**
                 * 
                 * @param config [description]
                 */
                constructor(config: SmoothedKeyControlConfig);

                /**
                 * The Camera that this Control will update.
                 */
                camera: Phaser.Cameras.Scene2D.Camera;

                /**
                 * The Key to be pressed that will move the Camera left.
                 */
                left: Phaser.Input.Keyboard.Key;

                /**
                 * The Key to be pressed that will move the Camera right.
                 */
                right: Phaser.Input.Keyboard.Key;

                /**
                 * The Key to be pressed that will move the Camera up.
                 */
                up: Phaser.Input.Keyboard.Key;

                /**
                 * The Key to be pressed that will move the Camera down.
                 */
                down: Phaser.Input.Keyboard.Key;

                /**
                 * The Key to be pressed that will zoom the Camera in.
                 */
                zoomIn: Phaser.Input.Keyboard.Key;

                /**
                 * The Key to be pressed that will zoom the Camera out.
                 */
                zoomOut: Phaser.Input.Keyboard.Key;

                /**
                 * The speed at which the camera will zoom if the `zoomIn` or `zoomOut` keys are pressed.
                 */
                zoomSpeed: number;

                /**
                 * The horizontal acceleration the camera will move.
                 */
                accelX: number;

                /**
                 * The vertical acceleration the camera will move.
                 */
                accelY: number;

                /**
                 * The horizontal drag applied to the camera when it is moving.
                 */
                dragX: number;

                /**
                 * The vertical drag applied to the camera when it is moving.
                 */
                dragY: number;

                /**
                 * The maximum horizontal speed the camera will move.
                 */
                maxSpeedX: number;

                /**
                 * The maximum vertical speed the camera will move.
                 */
                maxSpeedY: number;

                /**
                 * A flag controlling if the Controls will update the Camera or not.
                 */
                active: boolean;

                /**
                 * Starts the Key Control running, providing it has been linked to a camera.
                 */
                start(): Phaser.Cameras.Controls.SmoothedKeyControl;

                /**
                 * Stops this Key Control from running. Call `start` to start it again.
                 */
                stop(): Phaser.Cameras.Controls.SmoothedKeyControl;

                /**
                 * Binds this Key Control to a camera.
                 * @param camera The camera to bind this Key Control to.
                 */
                setCamera(camera: Phaser.Cameras.Scene2D.Camera): Phaser.Cameras.Controls.SmoothedKeyControl;

                /**
                 * [description]
                 * @param delta The delta time, in ms, elapsed since the last frame.
                 */
                update(delta: number): void;

                /**
                 * Destroys this Key Control.
                 */
                destroy(): void;

            }

        }

        namespace Sprite3D {
            /**
             * [description]
             */
            class Camera {
                /**
                 * 
                 * @param scene [description]
                 */
                constructor(scene: Phaser.Scene);

                /**
                 * [description]
                 * @param x [description]
                 * @param y [description]
                 * @param z [description]
                 */
                setPosition(x: number, y: number, z: number): Phaser.Cameras.Sprite3D.Camera;

                /**
                 * [description]
                 * @param scene [description]
                 */
                setScene(scene: Phaser.Scene): Phaser.Cameras.Sprite3D.Camera;

                /**
                 * [description]
                 * @param value [description]
                 */
                setPixelScale(value: number): Phaser.Cameras.Sprite3D.Camera;

                /**
                 * [description]
                 * @param sprite3D [description]
                 */
                add(sprite3D: Phaser.GameObjects.Sprite3D): Phaser.GameObjects.Sprite3D;

                /**
                 * [description]
                 * @param child [description]
                 */
                remove(child: Phaser.GameObjects.GameObject): Phaser.Cameras.Sprite3D.Camera;

                /**
                 * [description]
                 */
                clear(): Phaser.Cameras.Sprite3D.Camera;

                /**
                 * [description]
                 */
                getChildren(): any[];

                /**
                 * [description]
                 * @param x [description]
                 * @param y [description]
                 * @param z [description]
                 * @param key [description]
                 * @param frame [description]
                 * @param visible [description] Default true.
                 */
                create(x: number, y: number, z: number, key: string, frame: string | number, visible?: boolean): Phaser.GameObjects.Sprite3D;

                /**
                 * [description]
                 * @param quantity [description]
                 * @param key [description]
                 * @param frame [description]
                 * @param visible [description] Default true.
                 */
                createMultiple(quantity: number, key: string, frame: string | number, visible?: boolean): Phaser.GameObjects.Sprite3D[];

                /**
                 * [description]
                 * @param size [description]
                 * @param spacing [description]
                 * @param key [description]
                 * @param frame [description]
                 */
                createRect(size: number | Object, spacing: number | Object, key: string, frame?: string | number): Phaser.GameObjects.Sprite3D[];

                /**
                 * [description]
                 * @param radius [description] Default 1.
                 * @param sprites [description]
                 */
                randomSphere(radius?: number, sprites?: Phaser.GameObjects.Sprite3D[]): Phaser.Cameras.Sprite3D.Camera;

                /**
                 * [description]
                 * @param scale [description] Default 1.
                 * @param sprites [description]
                 */
                randomCube(scale?: number, sprites?: Phaser.GameObjects.Sprite3D[]): Phaser.Cameras.Sprite3D.Camera;

                /**
                 * [description]
                 * @param vec3 [description]
                 * @param sprites [description]
                 */
                translateChildren(vec3: Phaser.Math.Vector3, sprites: Phaser.GameObjects.Sprite3D[]): Phaser.Cameras.Sprite3D.Camera;

                /**
                 * [description]
                 * @param mat4 [description]
                 * @param sprites [description]
                 */
                transformChildren(mat4: Phaser.Math.Matrix4, sprites: Phaser.GameObjects.Sprite3D[]): Phaser.Cameras.Sprite3D.Camera;

                /**
                 * Sets the width and height of the viewport. Does not update any matrices.
                 * @param width [description]
                 * @param height [description]
                 */
                setViewport(width: number, height: number): Phaser.Cameras.Sprite3D.Camera;

                /**
                 * Translates this camera by a specified Vector3 object
                 * or x, y, z parameters. Any undefined x y z values will
                 * default to zero, leaving that component unaffected.
                 * If you wish to set the camera position directly call setPosition instead.
                 * @param x [description]
                 * @param y [description]
                 * @param z [description]
                 */
                translate(x: number | object, y?: number, z?: number): Phaser.Cameras.Sprite3D.Camera;

                /**
                 * [description]
                 * @param x [description]
                 * @param y [description]
                 * @param z [description]
                 */
                lookAt(x: number | object, y?: number, z?: number): Phaser.Cameras.Sprite3D.Camera;

                /**
                 * [description]
                 * @param radians [description]
                 * @param axis [description]
                 */
                rotate(radians: number, axis: Phaser.Math.Vector3): Phaser.Cameras.Sprite3D.Camera;

                /**
                 * [description]
                 * @param point [description]
                 * @param radians [description]
                 * @param axis [description]
                 */
                rotateAround(point: Phaser.Math.Vector3, radians: number, axis: Phaser.Math.Vector3): Phaser.Cameras.Sprite3D.Camera;

                /**
                 * [description]
                 * @param vec [description]
                 * @param out [description]
                 */
                project(vec: Phaser.Math.Vector3, out: Phaser.Math.Vector4): Phaser.Math.Vector4;

                /**
                 * [description]
                 * @param vec [description]
                 * @param out [description]
                 */
                unproject(vec: Phaser.Math.Vector4, out: Phaser.Math.Vector3): Phaser.Math.Vector3;

                /**
                 * [description]
                 * @param x [description]
                 * @param y [description]
                 */
                getPickRay(x: number, y?: number): RayDef;

                /**
                 * [description]
                 */
                updateChildren(): Phaser.Cameras.Sprite3D.Camera;

                /**
                 * [description]
                 */
                update(): Phaser.Cameras.Sprite3D.Camera;

                /**
                 * [description]
                 */
                updateBillboardMatrix(): void;

                /**
                 * This is a utility function for canvas 3D rendering,
                 * which determines the "point size" of a camera-facing
                 * sprite billboard given its 3D world position
                 * (origin at center of sprite) and its world width
                 * and height in x/y.
                 * 
                 * We place into the output Vector2 the scaled width
                 * and height. If no `out` is specified, a new Vector2
                 * will be created for convenience (this should be avoided
                 * in tight loops).
                 * @param vec The position of the 3D Sprite.
                 * @param size The x and y dimensions.
                 * @param out The result, scaled x and y dimensions.
                 */
                getPointSize(vec: Phaser.Math.Vector2, size: Phaser.Math.Vector2, out: Phaser.Math.Vector2): Phaser.Math.Vector2;

                /**
                 * [description]
                 */
                destroy(): void;

                /**
                 * [description]
                 * @param value [description]
                 */
                setX(value: number): Phaser.Cameras.Sprite3D.Camera;

                /**
                 * [description]
                 * @param value [description]
                 */
                setY(value: number): Phaser.Cameras.Sprite3D.Camera;

                /**
                 * [description]
                 * @param value [description]
                 */
                setZ(value: number): Phaser.Cameras.Sprite3D.Camera;

                /**
                 * [description]
                 */
                x: number;

                /**
                 * [description]
                 */
                y: number;

                /**
                 * [description]
                 */
                z: number;

            }

            /**
             * [description]
             */
            class CameraManager {
                /**
                 * 
                 * @param scene [description]
                 */
                constructor(scene: Phaser.Scene);

                /**
                 * [description]
                 */
                scene: Phaser.Scene;

                /**
                 * [description]
                 */
                systems: Phaser.Scenes.Systems;

                /**
                 * An Array of the Camera objects being managed by this Camera Manager.
                 */
                cameras: Phaser.Cameras.Sprite3D.Camera[];

                /**
                 * [description]
                 */
                boot(): void;

                /**
                 * [description]
                 * @param fieldOfView [description] Default 80.
                 * @param width [description]
                 * @param height [description]
                 */
                add(fieldOfView?: number, width?: number, height?: number): Phaser.Cameras.Sprite3D.PerspectiveCamera;

                /**
                 * [description]
                 * @param width [description]
                 * @param height [description]
                 */
                addOrthographicCamera(width: number, height: number): Phaser.Cameras.Sprite3D.OrthographicCamera;

                /**
                 * [description]
                 * @param fieldOfView [description] Default 80.
                 * @param width [description]
                 * @param height [description]
                 */
                addPerspectiveCamera(fieldOfView?: number, width?: number, height?: number): Phaser.Cameras.Sprite3D.PerspectiveCamera;

                /**
                 * [description]
                 * @param name [description]
                 */
                getCamera(name: string): Phaser.Cameras.Sprite3D.OrthographicCamera | Phaser.Cameras.Sprite3D.PerspectiveCamera;

                /**
                 * [description]
                 * @param camera [description]
                 */
                removeCamera(camera: Phaser.Cameras.Sprite3D.OrthographicCamera | Phaser.Cameras.Sprite3D.PerspectiveCamera): void;

                /**
                 * [description]
                 */
                removeAll(): Phaser.Cameras.Sprite3D.OrthographicCamera | Phaser.Cameras.Sprite3D.PerspectiveCamera;

                /**
                 * [description]
                 * @param timestep [description]
                 * @param delta [description]
                 */
                update(timestep: number, delta: number): void;

                /**
                 * [description]
                 */
                shutdown(): void;

                /**
                 * [description]
                 */
                destroy(): void;

            }

            /**
             * [description]
             */
            class OrthographicCamera extends Camera {
                /**
                 * 
                 * @param scene [description]
                 * @param viewportWidth [description] Default 0.
                 * @param viewportHeight [description] Default 0.
                 */
                constructor(scene: Phaser.Scene, viewportWidth?: integer, viewportHeight?: integer);

                /**
                 * [description]
                 */
                viewportWidth: integer;

                /**
                 * [description]
                 */
                viewportHeight: integer;

                /**
                 * [description]
                 */
                near: number;

                /**
                 * [description]
                 * @param yDown [description]
                 * @param viewportWidth [description]
                 * @param viewportHeight [description]
                 */
                setToOrtho(yDown: number, viewportWidth?: number, viewportHeight?: number): Phaser.Cameras.Sprite3D.OrthographicCamera;

                /**
                 * [description]
                 */
                zoom: number;

            }

            /**
             * [description]
             */
            class PerspectiveCamera extends Camera {
                /**
                 * 
                 * @param scene [description]
                 * @param fieldOfView [description] Default 80.
                 * @param viewportWidth [description] Default 0.
                 * @param viewportHeight [description] Default 0.
                 */
                constructor(scene: Phaser.Scene, fieldOfView?: integer, viewportWidth?: integer, viewportHeight?: integer);

                /**
                 * [description]
                 */
                viewportWidth: integer;

                /**
                 * [description]
                 */
                viewportHeight: integer;

                /**
                 * [description]
                 */
                fieldOfView: integer;

                /**
                 * [description]
                 * @param value [description]
                 */
                setFOV(value: number): Phaser.Cameras.Sprite3D.PerspectiveCamera;

            }

        }

        class Controls {
            /**
             * This alias will be removed in a future version.
             * Use `FixedKeyControl` instead.
             */
            static Fixed: any;

            /**
             * This alias will be removed in a future version.
             * Use `SmoothedKeyControl` instead.
             */
            static Smoothed: any;

        }

        class Sprite3D {
            /**
             * [description]
             */
            scene: Phaser.Scene;

            /**
             * [description]
             */
            displayList: Phaser.GameObjects.DisplayList;

            /**
             * [description]
             */
            updateList: Phaser.GameObjects.UpdateList;

            /**
             * [description]
             */
            name: string;

            /**
             * [description]
             */
            direction: Phaser.Math.Vector3;

            /**
             * [description]
             */
            up: Phaser.Math.Vector3;

            /**
             * [description]
             */
            position: Phaser.Math.Vector3;

            /**
             * [description]
             */
            pixelScale: number;

            /**
             * [description]
             */
            projection: Phaser.Math.Matrix4;

            /**
             * [description]
             */
            view: Phaser.Math.Matrix4;

            /**
             * [description]
             */
            combined: Phaser.Math.Matrix4;

            /**
             * [description]
             */
            invProjectionView: Phaser.Math.Matrix4;

            /**
             * [description]
             */
            near: number;

            /**
             * [description]
             */
            far: number;

            /**
             * [description]
             */
            ray: RayDef;

            /**
             * [description]
             */
            viewportWidth: number;

            /**
             * [description]
             */
            viewportHeight: number;

            /**
             * [description]
             */
            billboardMatrixDirty: boolean;

            /**
             * [description]
             */
            children: Phaser.Structs.Set<Phaser.GameObjects.GameObject>;

        }

    }

    namespace Create {
        /**
         * [description]
         * @param config [description]
         */
        function GenerateTexture(config: GenerateTextureConfig): HTMLCanvasElement;

        namespace Palettes {
        }

        class Palettes {
            /**
             * A 16 color palette by [Arne](http://androidarts.com/palette/16pal.htm)
             */
            static ARNE16: Palette;

            /**
             * A 16 color palette inspired by the Commodore 64.
             */
            static C64: Palette;

            /**
             * A 16 color CGA inspired palette by [Arne](http://androidarts.com/palette/16pal.htm)
             */
            static CGA: Palette;

            /**
             * A 16 color JMP palette by [Arne](http://androidarts.com/palette/16pal.htm)
             */
            static JMP: Palette;

            /**
             * A 16 color palette inspired by Japanese computers like the MSX.
             */
            static MSX: Palette;

        }

    }

    namespace Curves {
        /**
         * [description]
         */
        class CubicBezierCurve extends Curve {
            /**
             * 
             * @param p0 Start point, or an array of point pairs.
             * @param p1 Control Point 1.
             * @param p2 Control Point 2.
             * @param p3 End Point.
             */
            constructor(p0: Phaser.Math.Vector2 | Phaser.Math.Vector2[], p1: Phaser.Math.Vector2, p2: Phaser.Math.Vector2, p3: Phaser.Math.Vector2);

            /**
             * [description]
             */
            p0: Phaser.Math.Vector2;

            /**
             * [description]
             */
            p1: Phaser.Math.Vector2;

            /**
             * [description]
             */
            p2: Phaser.Math.Vector2;

            /**
             * [description]
             */
            p3: Phaser.Math.Vector2;

            /**
             * [description]
             * @param divisions The amount of divisions used by this curve.
             */
            getResolution(divisions: number): number;

            /**
             * Get point at relative position in curve according to length.
             * @param t The position along the curve to return. Where 0 is the start and 1 is the end.
             * @param out A Vector2 object to store the result in. If not given will be created.
             */
            getPoint<O extends Phaser.Math.Vector2>(t: number, out?: O): O;

            /**
             * [description]
             */
            toJSON(): JSONCurve;

            /**
             * [description]
             * @param data The JSON object containing this curve data.
             */
            static fromJSON(data: JSONCurve): Phaser.Curves.CubicBezierCurve;

        }

        /**
         * A Base Curve class, which all other curve types extend.
         * 
         * 
         * 
         * Based on the three.js Curve classes created by [zz85](http://www.lab4games.net/zz85/blog)
         */
        class Curve {
            /**
             * 
             * @param type [description]
             */
            constructor(type: string);

            /**
             * String based identifier for the type of curve.
             */
            type: string;

            /**
             * The default number of divisions within the curve.
             */
            defaultDivisions: integer;

            /**
             * The quantity of arc length divisions within the curve.
             */
            arcLengthDivisions: integer;

            /**
             * An array of cached arc length values.
             */
            cacheArcLengths: number[];

            /**
             * Does the data of this curve need updating?
             */
            needsUpdate: boolean;

            /**
             * [description]
             */
            active: boolean;

            /**
             * Draws this curve on the given Graphics object.
             * 
             * The curve is drawn using `Graphics.strokePoints` so will be drawn at whatever the present Graphics stroke color is.
             * The Graphics object is not cleared before the draw, so the curve will appear on-top of anything else already rendered to it.
             * @param graphics The Graphics instance onto which this curve will be drawn.
             * @param pointsTotal The resolution of the curve. The higher the value the smoother it will render, at the cost of rendering performance. Default 32.
             */
            draw<G extends Phaser.GameObjects.Graphics>(graphics: Phaser.GameObjects.Graphics, pointsTotal?: integer): G;

            /**
             * Returns a Rectangle where the position and dimensions match the bounds of this Curve.
             * 
             * You can control the accuracy of the bounds. The value given is used to work out how many points
             * to plot across the curve. Higher values are more accurate at the cost of calculation speed.
             * @param out The Rectangle to store the bounds in. If falsey a new object will be created.
             * @param accuracy The accuracy of the bounds calculations. Default 16.
             */
            getBounds(out?: Phaser.Geom.Rectangle, accuracy?: integer): Phaser.Geom.Rectangle;

            /**
             * Returns an array of points, spaced out X distance pixels apart.
             * The smaller the distance, the larger the array will be.
             * @param distance The distance, in pixels, between each point along the curve.
             */
            getDistancePoints(distance: integer): Phaser.Geom.Point[];

            /**
             * [description]
             * @param out [description]
             */
            getEndPoint(out: Phaser.Math.Vector2): Phaser.Math.Vector2;

            /**
             * [description]
             */
            getLength(): number;

            /**
             * [description]
             * @param divisions [description]
             */
            getLengths(divisions?: integer): number[];

            /**
             * [description]
             * @param u [description]
             * @param out [description]
             */
            getPointAt<O extends Phaser.Math.Vector2>(u: number, out?: O): O;

            /**
             * [description]
             * @param divisions [description]
             */
            getPoints(divisions?: integer): Phaser.Math.Vector2[];

            /**
             * [description]
             * @param out [description]
             */
            getRandomPoint<O extends Phaser.Math.Vector2>(out?: O): O;

            /**
             * [description]
             * @param divisions [description]
             */
            getSpacedPoints(divisions?: integer): Phaser.Math.Vector2[];

            /**
             * [description]
             * @param out [description]
             */
            getStartPoint<O extends Phaser.Math.Vector2>(out?: O): O;

            /**
             * [description]
             * @param t [description]
             * @param out [description]
             */
            getTangent<O extends Phaser.Math.Vector2>(t: number, out?: O): O;

            /**
             * [description]
             * @param u [description]
             * @param out [description]
             */
            getTangentAt<O extends Phaser.Math.Vector2>(u: number, out?: O): O;

            /**
             * [description]
             * @param distance [description]
             * @param divisions [description]
             */
            getTFromDistance(distance: integer, divisions?: integer): number;

            /**
             * [description]
             * @param u [description]
             * @param distance [description]
             * @param divisions [description]
             */
            getUtoTmapping(u: number, distance: integer, divisions?: integer): number;

            /**
             * [description]
             */
            updateArcLengths(): void;

        }

        /**
         * [description]
         */
        class EllipseCurve extends Curve {
            /**
             * 
             * @param x [description] Default 0.
             * @param y [description] Default 0.
             * @param xRadius [description] Default 0.
             * @param yRadius [description] Default 0.
             * @param startAngle [description] Default 0.
             * @param endAngle [description] Default 360.
             * @param clockwise [description] Default false.
             * @param rotation [description] Default 0.
             */
            constructor(x?: number | EllipseCurveConfig, y?: number, xRadius?: number, yRadius?: number, startAngle?: integer, endAngle?: integer, clockwise?: boolean, rotation?: integer);

            /**
             * [description]
             */
            p0: Phaser.Math.Vector2;

            /**
             * [description]
             * @param divisions [description]
             */
            getResolution(divisions: number): number;

            /**
             * Get point at relative position in curve according to length.
             * @param t The position along the curve to return. Where 0 is the start and 1 is the end.
             * @param out A Vector2 object to store the result in. If not given will be created.
             */
            getPoint<O extends Phaser.Math.Vector2>(t: number, out?: O): O;

            /**
             * Sets the horizontal radius of this curve.
             * @param value The horizontal radius of this curve.
             */
            setXRadius(value: number): Phaser.Curves.EllipseCurve;

            /**
             * Sets the vertical radius of this curve.
             * @param value The vertical radius of this curve.
             */
            setYRadius(value: number): Phaser.Curves.EllipseCurve;

            /**
             * Sets the width of this curve.
             * @param value The width of this curve.
             */
            setWidth(value: number): Phaser.Curves.EllipseCurve;

            /**
             * Sets the height of this curve.
             * @param value The height of this curve.
             */
            setHeight(value: number): Phaser.Curves.EllipseCurve;

            /**
             * Sets the start angle of this curve.
             * @param value The start angle of this curve, in radians.
             */
            setStartAngle(value: number): Phaser.Curves.EllipseCurve;

            /**
             * Sets the end angle of this curve.
             * @param value The end angle of this curve, in radians.
             */
            setEndAngle(value: number): Phaser.Curves.EllipseCurve;

            /**
             * Sets if this curve extends clockwise or anti-clockwise.
             * @param value The clockwise state of this curve.
             */
            setClockwise(value: boolean): Phaser.Curves.EllipseCurve;

            /**
             * Sets the rotation of this curve.
             * @param value The rotation of this curve, in radians.
             */
            setRotation(value: number): Phaser.Curves.EllipseCurve;

            /**
             * [description]
             */
            x: number;

            /**
             * [description]
             */
            y: number;

            /**
             * [description]
             */
            xRadius: number;

            /**
             * [description]
             */
            yRadius: number;

            /**
             * [description]
             */
            startAngle: number;

            /**
             * [description]
             */
            endAngle: number;

            /**
             * [description]
             */
            clockwise: boolean;

            /**
             * [description]
             */
            rotation: number;

            /**
             * [description]
             */
            toJSON(): JSONEllipseCurve;

            /**
             * [description]
             * @param data The JSON object containing this curve data.
             */
            static fromJSON(data: JSONEllipseCurve): Phaser.Curves.EllipseCurve;

        }

        /**
         * [description]
         */
        class LineCurve extends Curve {
            /**
             * 
             * @param p0 [description]
             * @param p1 [description]
             */
            constructor(p0: Phaser.Math.Vector2 | number[], p1?: Phaser.Math.Vector2);

            /**
             * [description]
             */
            p0: Phaser.Math.Vector2;

            /**
             * [description]
             */
            getResolution(): integer;

            /**
             * Get point at relative position in curve according to length.
             * @param t The position along the curve to return. Where 0 is the start and 1 is the end.
             * @param out A Vector2 object to store the result in. If not given will be created.
             */
            getPoint<O extends Phaser.Math.Vector2>(t: number, out?: O): O;

            /**
             * [description]
             */
            toJSON(): JSONCurve;

            /**
             * [description]
             * @param data The JSON object containing this curve data.
             */
            static fromJSON(data: JSONCurve): Phaser.Curves.LineCurve;

        }

        /**
         * [description]
         */
        class MoveTo {
            /**
             * 
             * @param x [description]
             * @param y [description]
             */
            constructor(x?: number, y?: number);

            /**
             * [description]
             */
            active: boolean;

            /**
             * [description]
             */
            p0: Phaser.Math.Vector2;

            /**
             * Get point at relative position in curve according to length.
             * @param t The position along the curve to return. Where 0 is the start and 1 is the end.
             * @param out A Vector2 object to store the result in. If not given will be created.
             */
            getPoint<O extends Phaser.Math.Vector2>(t: number, out?: O): O;

            /**
             * [description]
             * @param u [description]
             * @param out [description]
             */
            getPointAt<O extends Phaser.Math.Vector2>(u: number, out?: O): O;

            /**
             * Gets the resolution of this curve.
             */
            getResolution(): number;

            /**
             * Gets the length of this curve.
             */
            getLength(): number;

            /**
             * [description]
             */
            toJSON(): JSONCurve;

        }

        /**
         * [description]
         */
        class Path {
            /**
             * 
             * @param x [description] Default 0.
             * @param y [description] Default 0.
             */
            constructor(x?: number, y?: number);

            /**
             * [description]
             */
            name: string;

            /**
             * [description]
             */
            curves: Phaser.Curves.Curve[];

            /**
             * [description]
             */
            cacheLengths: number[];

            /**
             * Automatically closes the path.
             */
            autoClose: boolean;

            /**
             * [description]
             */
            startPoint: Phaser.Math.Vector2;

            /**
             * [description]
             * @param curve [description]
             */
            add(curve: Phaser.Curves.Curve): Phaser.Curves.Path;

            /**
             * [description]
             * @param radius [description]
             * @param clockwise [description] Default false.
             * @param rotation [description] Default 0.
             */
            circleTo(radius: number, clockwise?: boolean, rotation?: number): Phaser.Curves.Path;

            /**
             * [description]
             */
            closePath(): Phaser.Curves.Path;

            /**
             * [description]
             * @param x [description]
             * @param y [description]
             * @param control1X [description]
             * @param control1Y [description]
             * @param control2X [description]
             * @param control2Y [description]
             */
            cubicBezierTo(x: number, y: number, control1X: Phaser.Math.Vector2, control1Y: Phaser.Math.Vector2, control2X: Phaser.Math.Vector2, control2Y: Phaser.Math.Vector2): Phaser.Curves.Path;

            /**
             * [description]
             * @param x [description]
             * @param y [description]
             * @param controlX [description]
             * @param controlY [description]
             */
            quadraticBezierTo(x: number | Phaser.Math.Vector2[], y?: number, controlX?: number, controlY?: number): Phaser.Curves.Path;

            /**
             * [description]
             * @param graphics [description]
             * @param pointsTotal [description] Default 32.
             */
            draw<G extends Phaser.GameObjects.Graphics>(graphics: Phaser.GameObjects.Graphics, pointsTotal?: integer): G;

            /**
             * Creates an ellipse curve positioned at the previous end point, using the given parameters.
             * @param xRadius [description]
             * @param yRadius [description]
             * @param startAngle [description]
             * @param endAngle [description]
             * @param clockwise [description]
             * @param rotation [description]
             */
            ellipseTo(xRadius: number, yRadius: number, startAngle: number, endAngle: number, clockwise: boolean, rotation: number): Phaser.Curves.Path;

            /**
             * [description]
             * @param data [description]
             */
            fromJSON(data: object): Phaser.Curves.Path;

            /**
             * [description]
             * @param out [description]
             * @param accuracy [description] Default 16.
             */
            getBounds<O extends Phaser.Math.Vector2>(out?: O, accuracy?: integer): O;

            /**
             * [description]
             */
            getCurveLengths(): number[];

            /**
             * [description]
             * @param out [description]
             */
            getEndPoint<O extends Phaser.Math.Vector2>(out?: O): O;

            /**
             * [description]
             */
            getLength(): number;

            /**
             * [description]
             * @param t [description]
             * @param out [description]
             */
            getPoint<O extends Phaser.Math.Vector2>(t: number, out?: O): O;

            /**
             * [description]
             * @param divisions [description] Default 12.
             */
            getPoints(divisions?: integer): Phaser.Math.Vector2[];

            /**
             * [description]
             * @param out [description]
             */
            getRandomPoint<O extends Phaser.Math.Vector2>(out?: O): O;

            /**
             * [description]
             * @param divisions [description] Default 40.
             */
            getSpacedPoints(divisions?: integer): Phaser.Math.Vector2[];

            /**
             * [description]
             * @param out [description]
             */
            getStartPoint<O extends Phaser.Math.Vector2>(out?: O): O;

            /**
             * [description]
             * @param x [description]
             * @param y [description]
             */
            lineTo(x: number | Phaser.Math.Vector2, y?: number): Phaser.Curves.Path;

            /**
             * [description]
             * @param points [description]
             */
            splineTo(points: Phaser.Math.Vector2[]): Phaser.Curves.Path;

            /**
             * [description]
             * @param x [description]
             * @param y [description]
             */
            moveTo(x: number, y: number): Phaser.Curves.Path;

            /**
             * [description]
             */
            toJSON(): JSONPath;

            /**
             * [description]
             */
            updateArcLengths(): void;

            /**
             * [description]
             */
            destroy(): void;

        }

        /**
         * [description]
         */
        class QuadraticBezier extends Curve {
            /**
             * 
             * @param p0 Start point, or an array of point pairs.
             * @param p1 Control Point 1.
             * @param p2 Control Point 2.
             */
            constructor(p0: Phaser.Math.Vector2 | number[], p1: Phaser.Math.Vector2, p2: Phaser.Math.Vector2);

            /**
             * [description]
             */
            p0: Phaser.Math.Vector2;

            /**
             * [description]
             */
            p1: Phaser.Math.Vector2;

            /**
             * [description]
             */
            p2: Phaser.Math.Vector2;

            /**
             * [description]
             * @param divisions [description]
             */
            getResolution(divisions: number): number;

            /**
             * Get point at relative position in curve according to length.
             * @param t The position along the curve to return. Where 0 is the start and 1 is the end.
             * @param out A Vector2 object to store the result in. If not given will be created.
             */
            getPoint<O extends Phaser.Math.Vector2>(t: number, out?: O): O;

            /**
             * [description]
             */
            toJSON(): JSONCurve;

            /**
             * [description]
             * @param data The JSON object containing this curve data.
             */
            static fromJSON(data: JSONCurve): Phaser.Curves.QuadraticBezier;

        }

        /**
         * [description]
         */
        class SplineCurve extends Curve {
            /**
             * 
             * @param points [description]
             */
            constructor(points?: Phaser.Math.Vector2[]);

            /**
             * [description]
             */
            points: Phaser.Math.Vector2[];

            /**
             * [description]
             * @param points [description]
             */
            addPoints(points: Phaser.Math.Vector2[] | number[] | number[][]): Phaser.Curves.SplineCurve;

            /**
             * [description]
             * @param x [description]
             * @param y [description]
             */
            addPoint(x: number, y: number): Phaser.Math.Vector2;

            /**
             * [description]
             * @param divisions [description]
             */
            getResolution(divisions: number): number;

            /**
             * Get point at relative position in curve according to length.
             * @param t The position along the curve to return. Where 0 is the start and 1 is the end.
             * @param out A Vector2 object to store the result in. If not given will be created.
             */
            getPoint<O extends Phaser.Math.Vector2>(t: number, out?: O): O;

            /**
             * [description]
             */
            toJSON(): JSONCurve;

            /**
             * [description]
             * @param data The JSON object containing this curve data.
             */
            static fromJSON(data: JSONCurve): Phaser.Curves.SplineCurve;

        }

    }

    namespace Data {
        /**
         * The Data Component features a means to store pieces of data specific to a Game Object, System or Plugin.
         * 
         * You can then search, query it, and retrieve the data. The parent must either extend EventEmitter,
         * 
         * or have a property called `events` that is an instance of it.
         */
        class DataManager {
            /**
             * 
             * @param parent The object that this DataManager belongs to.
             * @param eventEmitter The DataManager's event emitter.
             */
            constructor(parent: object, eventEmitter: Phaser.Events.EventEmitter);

            /**
             * The object that this DataManager belongs to.
             */
            parent: any;

            /**
             * The DataManager's event emitter.
             */
            events: Phaser.Events.EventEmitter;

            /**
             * The data list.
             */
            list: {[key: string]:  any};

            /**
             * Whether setting data is blocked for this DataManager.
             * 
             * Used temporarily to allow 'changedata' event listeners to prevent
             * specific data from being set.
             */
            blockSet: boolean;

            /**
             * Retrieves the value for the given key, or undefined if it doesn't exist.
             * @param key The key of the value to retrieve.
             */
            get(key: string): any;

            /**
             * Retrieves all data values.
             */
            getAll(): {[key: string]:  any};

            /**
             * Queries the DataManager for the values of keys matching the given search string.
             * @param search The search string.
             */
            query(search: string): {[key: string]:  any};

            /**
             * Sets the value for the given key.
             * 
             * Emits the 'changedata' and 'setdata' events.
             * @param key The key to set the value for.
             * @param data The value to set.
             */
            set(key: string, data: any): Phaser.Data.DataManager;

            /**
             * Passes all data entries to the given callback. Stores the result of the callback.
             * @param callback The function to call.
             * @param scope Value to use as `this` when executing callback.
             * @param args Additional arguments that will be passed to the callback, after the game object, key, and data.
             */
            each(callback: DataEachCallback, scope?: any, ...args: any[]): Phaser.Data.DataManager;

            /**
             * Merge the given data object into this DataManager's data object.
             * @param data The data to merge.
             * @param overwrite Whether to overwrite existing data. Defaults to true.
             */
            merge(data: {[key: string]:  any}, overwrite: boolean): Phaser.Data.DataManager;

            /**
             * Remove the value for the given key.
             * @param key The key to remove
             */
            remove(key: string): Phaser.Data.DataManager;

            /**
             * Retrieves the data associated with the given 'key', deletes it from this Data store, then returns it.
             * @param key The key of the value to retrieve and delete.
             */
            pop(key: string): any;

            /**
             * Determines whether the given key is set in this Data store.
             * @param key The key to check.
             */
            has(key: string): boolean;

            /**
             * Freeze or unfreeze this Data store, to allow or prevent setting its values.
             * @param value Whether to freeze the Data store.
             */
            setFreeze(value: boolean): Phaser.Data.DataManager;

            /**
             * Delete all data in this Data store and unfreeze it.
             */
            reset(): Phaser.Data.DataManager;

            /**
             * Destroy this data manager.
             */
            destroy(): void;

            /**
             * Freeze this Data component, so no values can be set.
             */
            freeze: boolean;

            /**
             * Return the total number of entries in this Data component.
             */
            count: integer;

        }

        /**
         * The Data Component features a means to store pieces of data specific to a Game Object, System or Plugin.
         * 
         * 
         * 
         * You can then search, query it, and retrieve the data. The parent must either extend EventEmitter,
         * 
         * 
         * 
         * or have a property called `events` that is an instance of it.
         */
        class DataManagerPlugin extends DataManager {
            /**
             * 
             * @param scene [description]
             */
            constructor(scene: Phaser.Scene);

            /**
             * [description]
             */
            scene: Phaser.Scene;

            /**
             * [description]
             */
            systems: Phaser.Scenes.Systems;

            /**
             * [description]
             */
            boot(): void;

            /**
             * [description]
             */
            shutdownPlugin(): void;

            /**
             * [description]
             */
            destroyPlugin(): void;

        }

    }

    namespace Device {
        /**
         * Determines the audio playback capabilities of the device running this Phaser Game instance.
         * These values are read-only and populated during the boot sequence of the game.
         * They are then referenced by internal game systems and are available for you to access
         * via `this.sys.game.device.audio` from within any Scene.
         */
        type Audio = {
            /**
             * Can this device play HTML Audio tags?
             */
            audioData: boolean;
            /**
             * Can this device play EC-3 Dolby Digital Plus files?
             */
            dolby: boolean;
            /**
             * Can this device can play m4a files.
             */
            m4a: boolean;
            /**
             * Can this device play mp3 files?
             */
            mp3: boolean;
            /**
             * Can this device play ogg files?
             */
            ogg: boolean;
            /**
             * Can this device play opus files?
             */
            opus: boolean;
            /**
             * Can this device play wav files?
             */
            wav: boolean;
            /**
             * Does this device have the Web Audio API?
             */
            webAudio: boolean;
            /**
             * Can this device play webm files?
             */
            webm: boolean;
        };

        /**
         * Determines the browser type and version running this Phaser Game instance.
         * These values are read-only and populated during the boot sequence of the game.
         * They are then referenced by internal game systems and are available for you to access
         * via `this.sys.game.device.browser` from within any Scene.
         */
        type Browser = {
            /**
             * Set to true if running in Chrome.
             */
            chrome: boolean;
            /**
             * Set to true if running in Microsoft Edge browser.
             */
            edge: boolean;
            /**
             * Set to true if running in Firefox.
             */
            firefox: boolean;
            /**
             * Set to true if running in Internet Explorer 11 or less (not Edge).
             */
            ie: boolean;
            /**
             * Set to true if running in Mobile Safari.
             */
            mobileSafari: boolean;
            /**
             * Set to true if running in Opera.
             */
            opera: boolean;
            /**
             * Set to true if running in Safari.
             */
            safari: boolean;
            /**
             * Set to true if running in the Silk browser (as used on the Amazon Kindle)
             */
            silk: boolean;
            /**
             * Set to true if running a Trident version of Internet Explorer (IE11+)
             */
            trident: boolean;
            /**
             * If running in Chrome this will contain the major version number.
             */
            chromeVersion: number;
            /**
             * If running in Firefox this will contain the major version number.
             */
            firefoxVersion: number;
            /**
             * If running in Internet Explorer this will contain the major version number. Beyond IE10 you should use Browser.trident and Browser.tridentVersion.
             */
            ieVersion: number;
            /**
             * If running in Safari this will contain the major version number.
             */
            safariVersion: number;
            /**
             * If running in Internet Explorer 11 this will contain the major version number. See {@link http://msdn.microsoft.com/en-us/library/ie/ms537503(v=vs.85).aspx}
             */
            tridentVersion: number;
        };

        /**
         * Determines the canvas features of the browser running this Phaser Game instance.
         * These values are read-only and populated during the boot sequence of the game.
         * They are then referenced by internal game systems and are available for you to access
         * via `this.sys.game.device.canvasFeatures` from within any Scene.
         */
        type CanvasFeatures = {
            /**
             * Set to true if the browser supports inversed alpha.
             */
            supportInverseAlpha: boolean;
            /**
             * Set to true if the browser supports new canvas blend modes.
             */
            supportNewBlendModes: boolean;
        };

        /**
         * Determines the features of the browser running this Phaser Game instance.
         * These values are read-only and populated during the boot sequence of the game.
         * They are then referenced by internal game systems and are available for you to access
         * via `this.sys.game.device.features` from within any Scene.
         */
        type Features = {
            /**
             * True if canvas supports a 'copy' bitblt onto itself when the source and destination regions overlap.
             */
            canvasBitBltShift: boolean;
            /**
             * Is canvas available?
             */
            canvas: boolean;
            /**
             * Is file available?
             */
            file: boolean;
            /**
             * Is fileSystem available?
             */
            fileSystem: boolean;
            /**
             * Does the device support the getUserMedia API?
             */
            getUserMedia: boolean;
            /**
             * Is the device big or little endian? (only detected if the browser supports TypedArrays)
             */
            littleEndian: boolean;
            /**
             * Is localStorage available?
             */
            localStorage: boolean;
            /**
             * Is Pointer Lock available?
             */
            pointerLock: boolean;
            /**
             * Does the device context support 32bit pixel manipulation using array buffer views?
             */
            support32bit: boolean;
            /**
             * Does the device support the Vibration API?
             */
            vibration: boolean;
            /**
             * Is webGL available?
             */
            webGL: boolean;
            /**
             * Is worker available?
             */
            worker: boolean;
        };

        /**
         * Determines the full screen support of the browser running this Phaser Game instance.
         * These values are read-only and populated during the boot sequence of the game.
         * They are then referenced by internal game systems and are available for you to access
         * via `this.sys.game.device.fullscreen` from within any Scene.
         */
        type Fullscreen = {
            /**
             * Does the browser support the Full Screen API?
             */
            available: boolean;
            /**
             * Does the browser support access to the Keyboard during Full Screen mode?
             */
            keyboard: boolean;
            /**
             * If the browser supports the Full Screen API this holds the call you need to use to cancel it.
             */
            cancel: string;
            /**
             * If the browser supports the Full Screen API this holds the call you need to use to activate it.
             */
            request: string;
        };

        /**
         * Determines the input support of the browser running this Phaser Game instance.
         * These values are read-only and populated during the boot sequence of the game.
         * They are then referenced by internal game systems and are available for you to access
         * via `this.sys.game.device.input` from within any Scene.
         */
        type Input = {
            /**
             * The newest type of Wheel/Scroll event supported: 'wheel', 'mousewheel', 'DOMMouseScroll'
             */
            wheelType: string;
            /**
             * Is navigator.getGamepads available?
             */
            gamepads: boolean;
            /**
             * Is mspointer available?
             */
            mspointer: boolean;
            /**
             * Is touch available?
             */
            touch: boolean;
        };

        /**
         * Determines the operating system of the device running this Phaser Game instance.
         * These values are read-only and populated during the boot sequence of the game.
         * They are then referenced by internal game systems and are available for you to access
         * via `this.sys.game.device.os` from within any Scene.
         */
        type OS = {
            /**
             * Is running on android?
             */
            android: boolean;
            /**
             * Is running on chromeOS?
             */
            chromeOS: boolean;
            /**
             * Is the game running under CocoonJS?
             */
            cocoonJS: boolean;
            /**
             * Is this game running with CocoonJS.App?
             */
            cocoonJSApp: boolean;
            /**
             * Is the game running under Apache Cordova?
             */
            cordova: boolean;
            /**
             * Is the game running under the Intel Crosswalk XDK?
             */
            crosswalk: boolean;
            /**
             * Is running on a desktop?
             */
            desktop: boolean;
            /**
             * Is the game running under Ejecta?
             */
            ejecta: boolean;
            /**
             * Is the game running under GitHub Electron?
             */
            electron: boolean;
            /**
             * Is running on iOS?
             */
            iOS: boolean;
            /**
             * Is running on iPad?
             */
            iPad: boolean;
            /**
             * Is running on iPhone?
             */
            iPhone: boolean;
            /**
             * Is running on an Amazon Kindle?
             */
            kindle: boolean;
            /**
             * Is running on linux?
             */
            linux: boolean;
            /**
             * Is running on macOS?
             */
            macOS: boolean;
            /**
             * Is the game running under Node.js?
             */
            node: boolean;
            /**
             * Is the game running under Node-Webkit?
             */
            nodeWebkit: boolean;
            /**
             * Set to true if running as a WebApp, i.e. within a WebView
             */
            webApp: boolean;
            /**
             * Is running on windows?
             */
            windows: boolean;
            /**
             * Is running on a Windows Phone?
             */
            windowsPhone: boolean;
            /**
             * If running in iOS this will contain the major version number.
             */
            iOSVersion: number;
            /**
             * PixelRatio of the host device?
             */
            pixelRatio: number;
        };

        /**
         * Determines the video support of the browser running this Phaser Game instance.
         * These values are read-only and populated during the boot sequence of the game.
         * They are then referenced by internal game systems and are available for you to access
         * via `this.sys.game.device.video` from within any Scene.
         */
        type Video = {
            /**
             * Can this device play h264 mp4 video files?
             */
            h264Video: boolean;
            /**
             * Can this device play hls video files?
             */
            hlsVideo: boolean;
            /**
             * Can this device play h264 mp4 video files?
             */
            mp4Video: boolean;
            /**
             * Can this device play ogg video files?
             */
            oggVideo: boolean;
            /**
             * Can this device play vp9 video files?
             */
            vp9Video: boolean;
            /**
             * Can this device play webm video files?
             */
            webmVideo: boolean;
        };

    }

    type DeviceConf = {
        /**
         * The OS Device functions.
         */
        os: Phaser.Device.OS;
        /**
         * The Browser Device functions.
         */
        browser: Phaser.Device.Browser;
        /**
         * The Features Device functions.
         */
        features: Phaser.Device.Features;
        /**
         * The Input Device functions.
         */
        input: Phaser.Device.Input;
        /**
         * The Audio Device functions.
         */
        audio: Phaser.Device.Audio;
        /**
         * The Video Device functions.
         */
        video: Phaser.Device.Video;
        /**
         * The Fullscreen Device functions.
         */
        fullscreen: Phaser.Device.Fullscreen;
        /**
         * The Canvas Device functions.
         */
        canvasFeatures: Phaser.Device.CanvasFeatures;
    };

    namespace Display {
        namespace Align {
            namespace In {
                /**
                 * Takes given Game Object and aligns it so that it is positioned in the bottom center of the other.
                 * @param gameObject The Game Object that will be positioned.
                 * @param alignIn The Game Object to base the alignment position on.
                 * @param offsetX Optional horizontal offset from the position. Default 0.
                 * @param offsetY Optional vertical offset from the position. Default 0.
                 */
                function BottomCenter<G extends Phaser.GameObjects.GameObject>(gameObject: G, alignIn: Phaser.GameObjects.GameObject, offsetX?: number, offsetY?: number): G;

                /**
                 * Takes given Game Object and aligns it so that it is positioned in the bottom left of the other.
                 * @param gameObject The Game Object that will be positioned.
                 * @param alignIn The Game Object to base the alignment position on.
                 * @param offsetX Optional horizontal offset from the position. Default 0.
                 * @param offsetY Optional vertical offset from the position. Default 0.
                 */
                function BottomLeft<G extends Phaser.GameObjects.GameObject>(gameObject: G, alignIn: Phaser.GameObjects.GameObject, offsetX?: number, offsetY?: number): G;

                /**
                 * Takes given Game Object and aligns it so that it is positioned in the bottom right of the other.
                 * @param gameObject The Game Object that will be positioned.
                 * @param alignIn The Game Object to base the alignment position on.
                 * @param offsetX Optional horizontal offset from the position. Default 0.
                 * @param offsetY Optional vertical offset from the position. Default 0.
                 */
                function BottomRight<G extends Phaser.GameObjects.GameObject>(gameObject: G, alignIn: Phaser.GameObjects.GameObject, offsetX?: number, offsetY?: number): G;

                /**
                 * Takes given Game Object and aligns it so that it is positioned in the center of the other.
                 * @param gameObject The Game Object that will be positioned.
                 * @param alignIn The Game Object to base the alignment position on.
                 * @param offsetX Optional horizontal offset from the position. Default 0.
                 * @param offsetY Optional vertical offset from the position. Default 0.
                 */
                function Center<G extends Phaser.GameObjects.GameObject>(gameObject: G, alignIn: Phaser.GameObjects.GameObject, offsetX?: number, offsetY?: number): G;

                /**
                 * Takes given Game Object and aligns it so that it is positioned in the left center of the other.
                 * @param gameObject The Game Object that will be positioned.
                 * @param alignIn The Game Object to base the alignment position on.
                 * @param offsetX Optional horizontal offset from the position. Default 0.
                 * @param offsetY Optional vertical offset from the position. Default 0.
                 */
                function LeftCenter<G extends Phaser.GameObjects.GameObject>(gameObject: G, alignIn: Phaser.GameObjects.GameObject, offsetX?: number, offsetY?: number): G;

                /**
                 * Takes given Game Object and aligns it so that it is positioned relative to the other.
                 * The alignment used is based on the `position` argument, which is an `ALIGN_CONST` value, such as `LEFT_CENTER` or `TOP_RIGHT`.
                 * @param child The Game Object that will be positioned.
                 * @param alignIn The Game Object to base the alignment position on.
                 * @param position The position to align the Game Object with. This is an align constant, such as `ALIGN_CONST.LEFT_CENTER`.
                 * @param offsetX Optional horizontal offset from the position. Default 0.
                 * @param offsetY Optional vertical offset from the position. Default 0.
                 */
                function QuickSet<G extends Phaser.GameObjects.GameObject>(child: G, alignIn: Phaser.GameObjects.GameObject, position: integer, offsetX?: number, offsetY?: number): G;

                /**
                 * Takes given Game Object and aligns it so that it is positioned in the right center of the other.
                 * @param gameObject The Game Object that will be positioned.
                 * @param alignIn The Game Object to base the alignment position on.
                 * @param offsetX Optional horizontal offset from the position. Default 0.
                 * @param offsetY Optional vertical offset from the position. Default 0.
                 */
                function RightCenter<G extends Phaser.GameObjects.GameObject>(gameObject: G, alignIn: Phaser.GameObjects.GameObject, offsetX?: number, offsetY?: number): G;

                /**
                 * Takes given Game Object and aligns it so that it is positioned in the top center of the other.
                 * @param gameObject The Game Object that will be positioned.
                 * @param alignIn The Game Object to base the alignment position on.
                 * @param offsetX Optional horizontal offset from the position. Default 0.
                 * @param offsetY Optional vertical offset from the position. Default 0.
                 */
                function TopCenter<G extends Phaser.GameObjects.GameObject>(gameObject: G, alignIn: Phaser.GameObjects.GameObject, offsetX?: number, offsetY?: number): G;

                /**
                 * Takes given Game Object and aligns it so that it is positioned in the top left of the other.
                 * @param gameObject The Game Object that will be positioned.
                 * @param alignIn The Game Object to base the alignment position on.
                 * @param offsetX Optional horizontal offset from the position. Default 0.
                 * @param offsetY Optional vertical offset from the position. Default 0.
                 */
                function TopLeft<G extends Phaser.GameObjects.GameObject>(gameObject: G, alignIn: Phaser.GameObjects.GameObject, offsetX?: number, offsetY?: number): G;

                /**
                 * Takes given Game Object and aligns it so that it is positioned in the top right of the other.
                 * @param gameObject The Game Object that will be positioned.
                 * @param alignIn The Game Object to base the alignment position on.
                 * @param offsetX Optional horizontal offset from the position. Default 0.
                 * @param offsetY Optional vertical offset from the position. Default 0.
                 */
                function TopRight<G extends Phaser.GameObjects.GameObject>(gameObject: G, alignIn: Phaser.GameObjects.GameObject, offsetX?: number, offsetY?: number): G;

            }

            namespace To {
                /**
                 * Takes given Game Object and aligns it so that it is positioned next to the bottom center position of the other.
                 * @param gameObject The Game Object that will be positioned.
                 * @param alignTo The Game Object to base the alignment position on.
                 * @param offsetX Optional horizontal offset from the position. Default 0.
                 * @param offsetY Optional vertical offset from the position. Default 0.
                 */
                function BottomCenter<G extends Phaser.GameObjects.GameObject>(gameObject: G, alignTo: Phaser.GameObjects.GameObject, offsetX?: number, offsetY?: number): G;

                /**
                 * Takes given Game Object and aligns it so that it is positioned next to the bottom left position of the other.
                 * @param gameObject The Game Object that will be positioned.
                 * @param alignTo The Game Object to base the alignment position on.
                 * @param offsetX Optional horizontal offset from the position. Default 0.
                 * @param offsetY Optional vertical offset from the position. Default 0.
                 */
                function BottomLeft<G extends Phaser.GameObjects.GameObject>(gameObject: G, alignTo: Phaser.GameObjects.GameObject, offsetX?: number, offsetY?: number): G;

                /**
                 * Takes given Game Object and aligns it so that it is positioned next to the bottom right position of the other.
                 * @param gameObject The Game Object that will be positioned.
                 * @param alignTo The Game Object to base the alignment position on.
                 * @param offsetX Optional horizontal offset from the position. Default 0.
                 * @param offsetY Optional vertical offset from the position. Default 0.
                 */
                function BottomRight<G extends Phaser.GameObjects.GameObject>(gameObject: G, alignTo: Phaser.GameObjects.GameObject, offsetX?: number, offsetY?: number): G;

                /**
                 * Takes given Game Object and aligns it so that it is positioned next to the left bottom position of the other.
                 * @param gameObject The Game Object that will be positioned.
                 * @param alignTo The Game Object to base the alignment position on.
                 * @param offsetX Optional horizontal offset from the position. Default 0.
                 * @param offsetY Optional vertical offset from the position. Default 0.
                 */
                function LeftBottom<G extends Phaser.GameObjects.GameObject>(gameObject: G, alignTo: Phaser.GameObjects.GameObject, offsetX?: number, offsetY?: number): G;

                /**
                 * Takes given Game Object and aligns it so that it is positioned next to the left center position of the other.
                 * @param gameObject The Game Object that will be positioned.
                 * @param alignTo The Game Object to base the alignment position on.
                 * @param offsetX Optional horizontal offset from the position. Default 0.
                 * @param offsetY Optional vertical offset from the position. Default 0.
                 */
                function LeftCenter<G extends Phaser.GameObjects.GameObject>(gameObject: G, alignTo: Phaser.GameObjects.GameObject, offsetX?: number, offsetY?: number): G;

                /**
                 * Takes given Game Object and aligns it so that it is positioned next to the left top position of the other.
                 * @param gameObject The Game Object that will be positioned.
                 * @param alignTo The Game Object to base the alignment position on.
                 * @param offsetX Optional horizontal offset from the position. Default 0.
                 * @param offsetY Optional vertical offset from the position. Default 0.
                 */
                function LeftTop<G extends Phaser.GameObjects.GameObject>(gameObject: G, alignTo: Phaser.GameObjects.GameObject, offsetX?: number, offsetY?: number): G;

                /**
                 * Takes given Game Object and aligns it so that it is positioned next to the right bottom position of the other.
                 * @param gameObject The Game Object that will be positioned.
                 * @param alignTo The Game Object to base the alignment position on.
                 * @param offsetX Optional horizontal offset from the position. Default 0.
                 * @param offsetY Optional vertical offset from the position. Default 0.
                 */
                function RightBottom<G extends Phaser.GameObjects.GameObject>(gameObject: G, alignTo: Phaser.GameObjects.GameObject, offsetX?: number, offsetY?: number): G;

                /**
                 * Takes given Game Object and aligns it so that it is positioned next to the right center position of the other.
                 * @param gameObject The Game Object that will be positioned.
                 * @param alignTo The Game Object to base the alignment position on.
                 * @param offsetX Optional horizontal offset from the position. Default 0.
                 * @param offsetY Optional vertical offset from the position. Default 0.
                 */
                function RightCenter<G extends Phaser.GameObjects.GameObject>(gameObject: G, alignTo: Phaser.GameObjects.GameObject, offsetX?: number, offsetY?: number): G;

                /**
                 * Takes given Game Object and aligns it so that it is positioned next to the right top position of the other.
                 * @param gameObject The Game Object that will be positioned.
                 * @param alignTo The Game Object to base the alignment position on.
                 * @param offsetX Optional horizontal offset from the position. Default 0.
                 * @param offsetY Optional vertical offset from the position. Default 0.
                 */
                function RightTop<G extends Phaser.GameObjects.GameObject>(gameObject: G, alignTo: Phaser.GameObjects.GameObject, offsetX?: number, offsetY?: number): G;

                /**
                 * Takes given Game Object and aligns it so that it is positioned next to the top center position of the other.
                 * @param gameObject The Game Object that will be positioned.
                 * @param alignTo The Game Object to base the alignment position on.
                 * @param offsetX Optional horizontal offset from the position. Default 0.
                 * @param offsetY Optional vertical offset from the position. Default 0.
                 */
                function TopCenter<G extends Phaser.GameObjects.GameObject>(gameObject: G, alignTo: Phaser.GameObjects.GameObject, offsetX?: number, offsetY?: number): G;

                /**
                 * Takes given Game Object and aligns it so that it is positioned next to the top left position of the other.
                 * @param gameObject The Game Object that will be positioned.
                 * @param alignTo The Game Object to base the alignment position on.
                 * @param offsetX Optional horizontal offset from the position. Default 0.
                 * @param offsetY Optional vertical offset from the position. Default 0.
                 */
                function TopLeft<G extends Phaser.GameObjects.GameObject>(gameObject: G, alignTo: Phaser.GameObjects.GameObject, offsetX?: number, offsetY?: number): G;

                /**
                 * Takes given Game Object and aligns it so that it is positioned next to the top right position of the other.
                 * @param gameObject The Game Object that will be positioned.
                 * @param alignTo The Game Object to base the alignment position on.
                 * @param offsetX Optional horizontal offset from the position. Default 0.
                 * @param offsetY Optional vertical offset from the position. Default 0.
                 */
                function TopRight<G extends Phaser.GameObjects.GameObject>(gameObject: G, alignTo: Phaser.GameObjects.GameObject, offsetX?: number, offsetY?: number): G;

            }

        }

        namespace Bounds {
            /**
             * Positions the Game Object so that it is centered on the given coordinates.
             * @param gameObject The Game Object that will be re-positioned.
             * @param x The horizontal coordinate to position the Game Object on.
             * @param y The vertical coordinate to position the Game Object on.
             */
            function CenterOn<G extends Phaser.GameObjects.GameObject>(gameObject: G, x: number, y: number): G;

            /**
             * Returns the bottom coordinate from the bounds of the Game Object.
             * @param gameObject The Game Object to get the bounds value from.
             */
            function GetBottom(gameObject: Phaser.GameObjects.GameObject): number;

            /**
             * Returns the center x coordinate from the bounds of the Game Object.
             * @param gameObject The Game Object to get the bounds value from.
             */
            function GetCenterX(gameObject: Phaser.GameObjects.GameObject): number;

            /**
             * Returns the center y coordinate from the bounds of the Game Object.
             * @param gameObject The Game Object to get the bounds value from.
             */
            function GetCenterY(gameObject: Phaser.GameObjects.GameObject): number;

            /**
             * Returns the left coordinate from the bounds of the Game Object.
             * @param gameObject The Game Object to get the bounds value from.
             */
            function GetLeft(gameObject: Phaser.GameObjects.GameObject): number;

            /**
             * Returns the amount the Game Object is visually offset from its x coordinate.
             * This is the same as `width * origin.x`.
             * This value will only be > 0 if `origin.x` is not equal to zero.
             * @param gameObject The Game Object to get the bounds value from.
             */
            function GetOffsetX(gameObject: Phaser.GameObjects.GameObject): number;

            /**
             * Returns the amount the Game Object is visually offset from its y coordinate.
             * This is the same as `width * origin.y`.
             * This value will only be > 0 if `origin.y` is not equal to zero.
             * @param gameObject The Game Object to get the bounds value from.
             */
            function GetOffsetY(gameObject: Phaser.GameObjects.GameObject): number;

            /**
             * Returns the right coordinate from the bounds of the Game Object.
             * @param gameObject The Game Object to get the bounds value from.
             */
            function GetRight(gameObject: Phaser.GameObjects.GameObject): number;

            /**
             * Returns the top coordinate from the bounds of the Game Object.
             * @param gameObject The Game Object to get the bounds value from.
             */
            function GetTop(gameObject: Phaser.GameObjects.GameObject): number;

            /**
             * Positions the Game Object so that the bottom of its bounds aligns with the given coordinate.
             * @param gameObject The Game Object that will be re-positioned.
             * @param value The coordinate to position the Game Object bounds on.
             */
            function SetBottom<G extends Phaser.GameObjects.GameObject>(gameObject: G, value: number): G;

            /**
             * Positions the Game Object so that the center top of its bounds aligns with the given coordinate.
             * @param gameObject The Game Object that will be re-positioned.
             * @param x The coordinate to position the Game Object bounds on.
             */
            function SetCenterX<G extends Phaser.GameObjects.GameObject>(gameObject: G, x: number): G;

            /**
             * Positions the Game Object so that the center top of its bounds aligns with the given coordinate.
             * @param gameObject The Game Object that will be re-positioned.
             * @param y The coordinate to position the Game Object bounds on.
             */
            function SetCenterY<G extends Phaser.GameObjects.GameObject>(gameObject: G, y: number): G;

            /**
             * Positions the Game Object so that the left of its bounds aligns with the given coordinate.
             * @param gameObject The Game Object that will be re-positioned.
             * @param value The coordinate to position the Game Object bounds on.
             */
            function SetLeft<G extends Phaser.GameObjects.GameObject>(gameObject: G, value: number): G;

            /**
             * Positions the Game Object so that the left of its bounds aligns with the given coordinate.
             * @param gameObject The Game Object that will be re-positioned.
             * @param value The coordinate to position the Game Object bounds on.
             */
            function SetRight<G extends Phaser.GameObjects.GameObject>(gameObject: G, value: number): G;

            /**
             * Positions the Game Object so that the top of its bounds aligns with the given coordinate.
             * @param gameObject The Game Object that will be re-positioned.
             * @param value The coordinate to position the Game Object bounds on.
             */
            function SetTop<G extends Phaser.GameObjects.GameObject>(gameObject: G, value: number): G;

        }

        namespace Canvas {
            namespace CanvasInterpolation {
                /**
                 * Sets the CSS image-rendering property on the given canvas to be 'crisp' (aka 'optimize contrast' on webkit).
                 * @param canvas The canvas object to have the style set on.
                 */
                function setCrisp(canvas: HTMLCanvasElement): HTMLCanvasElement;

                /**
                 * Sets the CSS image-rendering property on the given canvas to be 'bicubic' (aka 'auto').
                 * @param canvas The canvas object to have the style set on.
                 */
                function setBicubic(canvas: HTMLCanvasElement): HTMLCanvasElement;

            }

            /**
             * The CanvasPool is a global static object, that allows Phaser to recycle and pool Canvas DOM elements.
             * 
             * This singleton is instantiated as soon as Phaser loads,
             * before a Phaser.Game instance has even been created.
             * Which means all instances of Phaser Games on the same page
             * can share the one single pool
             */
            namespace CanvasPool {
                /**
                 * Creates a new Canvas DOM element, or pulls one from the pool if free.
                 * @param parent The parent of the Canvas object.
                 * @param width The width of the Canvas. Default 1.
                 * @param height The height of the Canvas. Default 1.
                 * @param canvasType The type of the Canvas. Either `Phaser.CANVAS` or `Phaser.WEBGL`. Default Phaser.CANVAS.
                 */
                function create(parent: any, width?: integer, height?: integer, canvasType?: integer): HTMLCanvasElement;

                /**
                 * Creates a new Canvas DOM element, or pulls one from the pool if free.
                 * @param parent The parent of the Canvas object.
                 * @param width The width of the Canvas. Default 1.
                 * @param height The height of the Canvas. Default 1.
                 */
                function create2D(parent: any, width?: integer, height?: integer): HTMLCanvasElement;

                /**
                 * Creates a new Canvas DOM element, or pulls one from the pool if free.
                 * @param parent The parent of the Canvas object.
                 * @param width The width of the Canvas. Default 1.
                 * @param height The height of the Canvas. Default 1.
                 */
                function createWebGL(parent: any, width?: integer, height?: integer): HTMLCanvasElement;

                /**
                 * Gets the first free canvas index from the pool.
                 * @param canvasType The type of the Canvas. Either `Phaser.CANVAS` or `Phaser.WEBGL`. Default Phaser.CANVAS.
                 */
                function first(canvasType?: integer): HTMLCanvasElement;

                /**
                 * Looks up a canvas based on its parent, and if found puts it back in the pool, freeing it up for re-use.
                 * The canvas has its width and height set to 1, and its parent attribute nulled.
                 * @param parent [description]
                 */
                function remove(parent: any): void;

                /**
                 * Gets the total number of used canvas elements in the pool.
                 */
                function total(): integer;

                /**
                 * Gets the total number of free canvas elements in the pool.
                 */
                function free(): integer;

                /**
                 * Disable context smoothing on any new Canvas element created.
                 */
                function disableSmoothing(): void;

                /**
                 * Enable context smoothing on any new Canvas element created.
                 */
                function enableSmoothing(): void;

            }

            namespace Smoothing {
                /**
                 * Gets the Smoothing Enabled vendor prefix being used on the given context, or null if not set.
                 * @param context [description]
                 */
                function getPrefix(context: CanvasRenderingContext2D | WebGLRenderingContext): string;

                /**
                 * Sets the Image Smoothing property on the given context. Set to false to disable image smoothing.
                 * By default browsers have image smoothing enabled, which isn't always what you visually want, especially
                 * when using pixel art in a game. Note that this sets the property on the context itself, so that any image
                 * drawn to the context will be affected. This sets the property across all current browsers but support is
                 * patchy on earlier browsers, especially on mobile.
                 * @param context [description]
                 */
                function enable(context: CanvasRenderingContext2D | WebGLRenderingContext): CanvasRenderingContext2D | WebGLRenderingContext;

                /**
                 * Sets the Image Smoothing property on the given context. Set to false to disable image smoothing.
                 * By default browsers have image smoothing enabled, which isn't always what you visually want, especially
                 * when using pixel art in a game. Note that this sets the property on the context itself, so that any image
                 * drawn to the context will be affected. This sets the property across all current browsers but support is
                 * patchy on earlier browsers, especially on mobile.
                 * @param context [description]
                 */
                function disable(context: CanvasRenderingContext2D | WebGLRenderingContext): CanvasRenderingContext2D | WebGLRenderingContext;

                /**
                 * Returns `true` if the given context has image smoothing enabled, otherwise returns `false`.
                 * Returns null if no smoothing prefix is available.
                 * @param context [description]
                 */
                function isEnabled(context: CanvasRenderingContext2D | WebGLRenderingContext): boolean;

            }

            /**
             * Sets the touch-action property on the canvas style. Can be used to disable default browser touch actions.
             * @param canvas The canvas element to have the style applied to.
             * @param value The touch action value to set on the canvas. Set to `none` to disable touch actions. Default 'none'.
             */
            function TouchAction(canvas: HTMLCanvasElement, value?: string): HTMLCanvasElement;

            /**
             * Sets the user-select property on the canvas style. Can be used to disable default browser selection actions.
             * @param canvas The canvas element to have the style applied to.
             * @param value The touch callout value to set on the canvas. Set to `none` to disable touch callouts. Default 'none'.
             */
            function UserSelect(canvas: HTMLCanvasElement, value?: string): HTMLCanvasElement;

        }

        /**
         * The Color class holds a single color value and allows for easy modification and reading of it.
         */
        class Color {
            /**
             * 
             * @param red The red color value. A number between 0 and 255. Default 0.
             * @param green The green color value. A number between 0 and 255. Default 0.
             * @param blue The blue color value. A number between 0 and 255. Default 0.
             * @param alpha The alpha value. A number between 0 and 255. Default 255.
             */
            constructor(red?: integer, green?: integer, blue?: integer, alpha?: integer);

            /**
             * An array containing the calculated color values for WebGL use.
             */
            gl: number[];

            /**
             * Sets this color to be transparent. Sets all values to zero.
             */
            transparent(): Phaser.Display.Color;

            /**
             * Sets the color of this Color component.
             * @param red The red color value. A number between 0 and 255.
             * @param green The green color value. A number between 0 and 255.
             * @param blue The blue color value. A number between 0 and 255.
             * @param alpha The alpha value. A number between 0 and 255. Default 255.
             */
            setTo(red: integer, green: integer, blue: integer, alpha?: integer): Phaser.Display.Color;

            /**
             * Sets the red, green, blue and alpha GL values of this Color component.
             * @param red The red color value. A number between 0 and 1.
             * @param green The green color value. A number between 0 and 1.
             * @param blue The blue color value. A number between 0 and 1.
             * @param alpha The alpha value. A number between 0 and 1. Default 1.
             */
            setGLTo(red: number, green: number, blue: number, alpha?: number): Phaser.Display.Color;

            /**
             * Sets the color based on the color object given.
             * @param color An object containing `r`, `g`, `b` and optionally `a` values in the range 0 to 255.
             */
            setFromRGB(color: InputColorObject): Phaser.Display.Color;

            /**
             * Updates the internal cache values.
             */
            update(): Phaser.Display.Color;

            /**
             * Returns a new Color component using the values from this one.
             */
            clone(): Phaser.Display.Color;

            /**
             * The color of this Color component, not including the alpha channel.
             */
            color: number;

            /**
             * The color of this Color component, including the alpha channel.
             */
            color32: number;

            /**
             * The color of this Color component as a string which can be used in CSS color values.
             */
            rgba: string;

            /**
             * The red color value, normalized to the range 0 to 1.
             */
            redGL: number;

            /**
             * The green color value, normalized to the range 0 to 1.
             */
            greenGL: number;

            /**
             * The blue color value, normalized to the range 0 to 1.
             */
            blueGL: number;

            /**
             * The alpha color value, normalized to the range 0 to 1.
             */
            alphaGL: number;

            /**
             * The red color value, normalized to the range 0 to 255.
             */
            red: number;

            /**
             * The green color value, normalized to the range 0 to 255.
             */
            green: number;

            /**
             * The blue color value, normalized to the range 0 to 255.
             */
            blue: number;

            /**
             * The alpha color value, normalized to the range 0 to 255.
             */
            alpha: number;

            /**
             * Converts the given color value into an Object containing r,g,b and a properties.
             * @param color A color value, optionally including the alpha value.
             */
            static ColorToRGBA(color: number): ColorObject;

            /**
             * Returns a string containing a hex representation of the given color component.
             * @param color The color channel to get the hex value for, must be a value between 0 and 255.
             */
            static ComponentToHex(color: integer): string;

            /**
             * Given 3 separate color values this will return an integer representation of it.
             * @param red The red color value. A number between 0 and 255.
             * @param green The green color value. A number between 0 and 255.
             * @param blue The blue color value. A number between 0 and 255.
             */
            static GetColor(red: integer, green: integer, blue: integer): number;

            /**
             * Given an alpha and 3 color values this will return an integer representation of it.
             * @param red The red color value. A number between 0 and 255.
             * @param green The green color value. A number between 0 and 255.
             * @param blue The blue color value. A number between 0 and 255.
             * @param alpha The alpha color value. A number between 0 and 255.
             */
            static GetColor32(red: integer, green: integer, blue: integer, alpha: integer): number;

            /**
             * Converts a hex string into a Phaser Color object.
             * 
             * The hex string can supplied as `'#0033ff'` or the short-hand format of `'#03f'`; it can begin with an optional "#" or "0x", or be unprefixed.
             * 
             * An alpha channel is _not_ supported.
             * @param hex The hex color value to convert, such as `#0033ff` or the short-hand format: `#03f`.
             */
            static HexStringToColor(hex: string): Phaser.Display.Color;

            /**
             * Converts HSL (hue, saturation and lightness) values to a Phaser Color object.
             * @param h The hue value in the range 0 to 1.
             * @param s The saturation value in the range 0 to 1.
             * @param l The lightness value in the range 0 to 1.
             */
            static HSLToColor(h: number, s: number, l: number): Phaser.Display.Color;

            /**
             * Get HSV color wheel values in an array which will be 360 elements in size.
             * @param s The saturation, in the range 0 - 1. Default 1.
             * @param v The value, in the range 0 - 1. Default 1.
             */
            static HSVColorWheel(s?: number, v?: number): any[];

            /**
             * Converts an HSV (hue, saturation and value) color value to RGB.
             * 
             * Conversion formula from http://en.wikipedia.org/wiki/HSL_color_space.
             * 
             * Assumes HSV values are contained in the set [0, 1].
             * 
             * Based on code by Michael Jackson (https://github.com/mjijackson)
             * @param h The hue, in the range 0 - 1.
             * @param s The saturation, in the range 0 - 1.
             * @param v The value, in the range 0 - 1.
             */
            static HSVToRGB(h: number, s: number, v: number): ColorObject;

            /**
             * Converts a hue to an RGB color.
             * Based on code by Michael Jackson (https://github.com/mjijackson)
             */
            static HueToComponent(p: number, q: number, t: number): number;

            /**
             * Converts the given color value into an instance of a Color object.
             * @param input The color value to convert into a Color object.
             */
            static IntegerToColor(input: integer): Phaser.Display.Color;

            /**
             * Return the component parts of a color as an Object with the properties alpha, red, green, blue.
             * 
             * Alpha will only be set if it exists in the given color (0xAARRGGBB)
             * @param input The color value to convert into a Color object.
             */
            static IntegerToRGB(input: integer): ColorObject;


            /**
             * Converts an object containing `r`, `g`, `b` and `a` properties into a Color class instance.
             * @param input An object containing `r`, `g`, `b` and `a` properties in the range 0 to 255.
             */
            static ObjectToColor(input: InputColorObject): Phaser.Display.Color;

            /**
             * Creates a new Color object where the r, g, and b values have been set to random values
             * 
             * based on the given min max values.
             * @param min The minimum value to set the random range from (between 0 and 255) Default 0.
             * @param max The maximum value to set the random range from (between 0 and 255) Default 255.
             */
            static RandomRGB(min?: integer, max?: integer): Phaser.Display.Color;

            /**
             * Converts a CSS 'web' string into a Phaser Color object.
             * 
             * 
             * 
             * The web string can be in the format `'rgb(r,g,b)'` or `'rgba(r,g,b,a)'` where r/g/b are in the range [0..255] and a is in the range [0..1].
             * @param rgb The CSS format color string, using the `rgb` or `rgba` format.
             */
            static RGBStringToColor(rgb: string): Phaser.Display.Color;

            /**
             * Converts an RGB color value to HSV (hue, saturation and value).
             * Conversion forumla from http://en.wikipedia.org/wiki/HSL_color_space.
             * Assumes RGB values are contained in the set [0, 255] and returns h, s and v in the set [0, 1].
             * Based on code by Michael Jackson (https://github.com/mjijackson)
             * @param r The red color value. A number between 0 and 255.
             * @param g The green color value. A number between 0 and 255.
             * @param b The blue color value. A number between 0 and 255.
             */
            static RGBToHSV(r: integer, g: integer, b: integer): HSLColorObject;

            /**
             * Converts the color values into an HTML compatible color string, prefixed with either `#` or `0x`.
             * @param r The red color value. A number between 0 and 255.
             * @param g The green color value. A number between 0 and 255.
             * @param b The blue color value. A number between 0 and 255.
             * @param a The alpha value. A number between 0 and 255. Default 255.
             * @param prefix The prefix of the string. Either `#` or `0x`. Default #.
             */
            static RGBToString(r: integer, g: integer, b: integer, a?: integer, prefix?: string): string;

            /**
             * Converts the given source color value into an instance of a Color class.
             * The value can be either a string, prefixed with `rgb` or a hex string, a number or an Object.
             * @param input The source color value to convert.
             */
            static ValueToColor(input: string | number | InputColorObject): Phaser.Display.Color;

        }

        namespace Masks {
            /**
             * [description]
             */
            class BitmapMask {
                /**
                 * 
                 * @param scene [description]
                 * @param renderable A renderable Game Object that uses a texture, such as a Sprite.
                 */
                constructor(scene: Phaser.Scene, renderable: Phaser.GameObjects.GameObject);

                /**
                 * A renderable Game Object that uses a texture, such as a Sprite.
                 */
                bitmapMask: Phaser.GameObjects.GameObject;

                /**
                 * [description]
                 */
                maskTexture: WebGLTexture;

                /**
                 * [description]
                 */
                mainTexture: WebGLTexture;

                /**
                 * [description]
                 */
                dirty: boolean;

                /**
                 * [description]
                 */
                mainFramebuffer: WebGLFramebuffer;

                /**
                 * [description]
                 */
                maskFramebuffer: WebGLFramebuffer;

                /**
                 * [description]
                 */
                invertAlpha: boolean;

                /**
                 * [description]
                 * @param renderable A renderable Game Object that uses a texture, such as a Sprite.
                 */
                setBitmap(renderable: Phaser.GameObjects.GameObject): void;

                /**
                 * [description]
                 * @param renderer [description]
                 * @param maskedObject [description]
                 * @param camera The Camera to render to.
                 */
                preRenderWebGL(renderer: Phaser.Renderer.Canvas.CanvasRenderer | Phaser.Renderer.WebGL.WebGLRenderer, maskedObject: Phaser.GameObjects.GameObject, camera: Phaser.Cameras.Scene2D.Camera): void;

                /**
                 * [description]
                 * @param renderer [description]
                 */
                postRenderWebGL(renderer: Phaser.Renderer.Canvas.CanvasRenderer | Phaser.Renderer.WebGL.WebGLRenderer): void;

                /**
                 * [description]
                 * @param renderer [description]
                 * @param mask [description]
                 * @param camera The Camera to render to.
                 */
                preRenderCanvas(renderer: Phaser.Renderer.Canvas.CanvasRenderer | Phaser.Renderer.WebGL.WebGLRenderer, mask: Phaser.GameObjects.GameObject, camera: Phaser.Cameras.Scene2D.Camera): void;

                /**
                 * [description]
                 * @param renderer [description]
                 */
                postRenderCanvas(renderer: Phaser.Renderer.Canvas.CanvasRenderer | Phaser.Renderer.WebGL.WebGLRenderer): void;

            }

            /**
             * [description]
             */
            class GeometryMask {
                /**
                 * 
                 * @param scene [description]
                 * @param graphicsGeometry [description]
                 */
                constructor(scene: Phaser.Scene, graphicsGeometry: Phaser.GameObjects.Graphics);

                /**
                 * [description]
                 */
                geometryMask: Phaser.GameObjects.Graphics;

                /**
                 * [description]
                 * @param graphicsGeometry [description]
                 */
                setShape(graphicsGeometry: Phaser.GameObjects.Graphics): void;

                /**
                 * [description]
                 * @param renderer [description]
                 * @param mask [description]
                 * @param camera [description]
                 */
                preRenderWebGL(renderer: Phaser.Renderer.Canvas.CanvasRenderer | Phaser.Renderer.WebGL.WebGLRenderer, mask: Phaser.GameObjects.GameObject, camera: Phaser.Cameras.Scene2D.Camera): void;

                /**
                 * [description]
                 * @param renderer [description]
                 */
                postRenderWebGL(renderer: Phaser.Renderer.Canvas.CanvasRenderer | Phaser.Renderer.WebGL.WebGLRenderer): void;

                /**
                 * [description]
                 * @param renderer [description]
                 * @param mask [description]
                 * @param camera [description]
                 */
                preRenderCanvas(renderer: Phaser.Renderer.Canvas.CanvasRenderer | Phaser.Renderer.WebGL.WebGLRenderer, mask: Phaser.GameObjects.GameObject, camera: Phaser.Cameras.Scene2D.Camera): void;

                /**
                 * [description]
                 * @param renderer [description]
                 */
                postRenderCanvas(renderer: Phaser.Renderer.Canvas.CanvasRenderer | Phaser.Renderer.WebGL.WebGLRenderer): void;

            }

        }

        class Align {
            /**
             * A constant representing a top-left alignment or position.
             */
            static readonly TOP_LEFT: integer;

            /**
             * A constant representing a top-center alignment or position.
             */
            static readonly TOP_CENTER: integer;

            /**
             * A constant representing a top-right alignment or position.
             */
            static readonly TOP_RIGHT: integer;

            /**
             * A constant representing a left-top alignment or position.
             */
            static readonly LEFT_TOP: integer;

            /**
             * A constant representing a left-center alignment or position.
             */
            static readonly LEFT_CENTER: integer;

            /**
             * A constant representing a left-bottom alignment or position.
             */
            static readonly LEFT_BOTTOM: integer;

            /**
             * A constant representing a center alignment or position.
             */
            static readonly CENTER: integer;

            /**
             * A constant representing a right-top alignment or position.
             */
            static readonly RIGHT_TOP: integer;

            /**
             * A constant representing a right-center alignment or position.
             */
            static readonly RIGHT_CENTER: integer;

            /**
             * A constant representing a right-bottom alignment or position.
             */
            static readonly RIGHT_BOTTOM: integer;

            /**
             * A constant representing a bottom-left alignment or position.
             */
            static readonly BOTTOM_LEFT: integer;

            /**
             * A constant representing a bottom-center alignment or position.
             */
            static readonly BOTTOM_CENTER: integer;

            /**
             * A constant representing a bottom-right alignment or position.
             */
            static readonly BOTTOM_RIGHT: integer;

        }

    }

    namespace DOM {
        /**
         * Adds the given element to the DOM. If a parent is provided the element is added as a child of the parent, providing it was able to access it.
         * If no parent was given or falls back to using `document.body`.
         * @param element The element to be added to the DOM. Usually a Canvas object.
         * @param parent The parent in which to add the element. Can be a string which is passed to `getElementById` or an actual DOM object.
         * @param overflowHidden [description] Default true.
         */
        function AddToDOM(element: HTMLElement, parent?: string | HTMLElement, overflowHidden?: boolean): HTMLElement;

        /**
         * Inspects the readyState of the document. If the document is already complete then it invokes the given callback.
         * If not complete it sets up several event listeners such as `deviceready`, and once those fire, it invokes the callback.
         * Called automatically by the Phaser.Game instance. Should not usually be accessed directly.
         * @param callback The callback to be invoked when the device is ready and the DOM content is loaded.
         */
        function DOMContentLoaded(callback: ContentLoadedCallback): void;

        /**
         * Takes the given data string and parses it as XML.
         * First tries to use the window.DOMParser and reverts to the Microsoft.XMLDOM if that fails.
         * The parsed XML object is returned, or `null` if there was an error while parsing the data.
         * @param data The XML source stored in a string.
         */
        function ParseXML(data: string): DOMParser | ActiveXObject;

        /**
         * Attempts to remove the element from its parentNode in the DOM.
         * @param element The DOM element to remove from its parent node.
         */
        function RemoveFromDOM(element: HTMLElement): void;

        /**
         * Abstracts away the use of RAF or setTimeOut for the core game update loop.
         * 
         * This is invoked automatically by the Phaser.Game instance.
         */
        class RequestAnimationFrame {
            /**
             * True if RequestAnimationFrame is running, otherwise false.
             */
            isRunning: boolean;

            /**
             * The callback to be invoked each step.
             */
            callback: FrameRequestCallback;

            /**
             * The most recent timestamp. Either a DOMHighResTimeStamp under RAF or `Date.now` under SetTimeout.
             */
            tick: number;

            /**
             * True if the step is using setTimeout instead of RAF.
             */
            isSetTimeOut: boolean;

            /**
             * The setTimeout or RAF callback ID used when canceling them.
             */
            timeOutID: number;

            /**
             * The previous time the step was called.
             */
            lastTime: number;

            /**
             * The RAF step function.
             * Updates the local tick value, invokes the callback and schedules another call to requestAnimationFrame.
             */
            step: FrameRequestCallback;

            /**
             * The SetTimeout step function.
             * Updates the local tick value, invokes the callback and schedules another call to setTimeout.
             */
            stepTimeout: Function;

            /**
             * Starts the requestAnimationFrame or setTimeout process running.
             * @param callback The callback to invoke each step.
             * @param forceSetTimeOut Should it use SetTimeout, even if RAF is available?
             */
            start(callback: FrameRequestCallback, forceSetTimeOut: boolean): void;

            /**
             * Stops the requestAnimationFrame or setTimeout from running.
             */
            stop(): void;

            /**
             * Stops the step from running and clears the callback reference.
             */
            destroy(): void;

        }

    }

    namespace Events {
        /**
         * EventEmitter is a Scene Systems plugin compatible version of eventemitter3.
         */
        class EventEmitter {
            /**
             * Removes all listeners.
             */
            shutdown(): void;

            /**
             * Removes all listeners.
             */
            destroy(): void;

            /**
             * Return an array listing the events for which the emitter has registered listeners.
             */
            eventNames(): any[];

            /**
             * Return the listeners registered for a given event.
             * @param event The event name.
             */
            listeners(event: string | symbol): any[];

            /**
             * Return the number of listeners listening to a given event.
             * @param event The event name.
             */
            listenerCount(event: string | symbol): number;

            /**
             * Calls each of the listeners registered for a given event.
             * @param event The event name.
             */
            emit(event: string | symbol): boolean;

            /**
             * Add a listener for a given event.
             * @param event The event name.
             * @param fn The listener function.
             * @param context The context to invoke the listener with. Default this.
             */
            on(event: string | symbol, fn: Function, context?: any): Phaser.Events.EventEmitter;

            /**
             * Add a listener for a given event.
             * @param event The event name.
             * @param fn The listener function.
             * @param context The context to invoke the listener with. Default this.
             */
            addListener(event: string | symbol, fn: Function, context?: any): Phaser.Events.EventEmitter;

            /**
             * Add a one-time listener for a given event.
             * @param event The event name.
             * @param fn The listener function.
             * @param context The context to invoke the listener with. Default this.
             */
            once(event: string | symbol, fn: Function, context?: any): Phaser.Events.EventEmitter;

            /**
             * Remove the listeners of a given event.
             * @param event The event name.
             * @param fn Only remove the listeners that match this function.
             * @param context Only remove the listeners that have this context.
             * @param once Only remove one-time listeners.
             */
            removeListener(event: string | symbol, fn: Function, context: any, once: boolean): Phaser.Events.EventEmitter;

            /**
             * Remove the listeners of a given event.
             * @param event The event name.
             * @param fn Only remove the listeners that match this function.
             * @param context Only remove the listeners that have this context.
             * @param once Only remove one-time listeners.
             */
            off(event: string | symbol, fn: Function, context: any, once: boolean): Phaser.Events.EventEmitter;

            /**
             * Remove all listeners, or those of the specified event.
             * @param event The event name.
             */
            removeAllListeners(event?: string | symbol): Phaser.Events.EventEmitter;

        }

    }

    namespace GameObjects {
        /**
         * [description]
         */
        class DynamicBitmapText extends GameObject implements Components.Alpha, Components.BlendMode, Components.Depth, Components.Origin, Components.Pipeline, Components.ScrollFactor, Components.Texture, Components.Tint, Components.Transform, Components.Visible {
            /**
             * 
             * @param scene The Scene to which this Game Object belongs. It can only belong to one Scene at any given time.
             * @param x The x coordinate of this Game Object in world space.
             * @param y The y coordinate of this Game Object in world space.
             * @param font [description]
             * @param text [description]
             * @param size [description]
             */
            constructor(scene: Phaser.Scene, x: number, y: number, font: string, text?: string | string[], size?: number);

            /**
             * [description]
             */
            font: string;

            /**
             * [description]
             */
            fontData: object;

            /**
             * [description]
             */
            text: string;

            /**
             * [description]
             */
            fontSize: number;

            /**
             * [description]
             */
            scrollX: number;

            /**
             * [description]
             */
            scrollY: number;

            /**
             * [description]
             */
            cropWidth: number;

            /**
             * [description]
             */
            cropHeight: number;

            /**
             * [description]
             */
            "displayCallback;": DisplayCallback;

            /**
             * [description]
             * @param width [description]
             * @param height [description]
             */
            setSize(width: number, height: number): Phaser.GameObjects.DynamicBitmapText;

            /**
             * [description]
             * @param callback [description]
             */
            setDisplayCallback(callback: DisplayCallback): Phaser.GameObjects.DynamicBitmapText;

            /**
             * [description]
             * @param size [description]
             */
            setFontSize(size: number): Phaser.GameObjects.DynamicBitmapText;

            /**
             * [description]
             * @param value The string, or array of strings, to be set as the content of this BitmapText.
             */
            setText(value: string | string[]): Phaser.GameObjects.DynamicBitmapText;

            /**
             * [description]
             * @param value [description]
             */
            setScrollX(value: number): Phaser.GameObjects.DynamicBitmapText;

            /**
             * [description]
             * @param value [description]
             */
            setScrollY(value: number): Phaser.GameObjects.DynamicBitmapText;

            /**
             * [description]
             * @param round [description]
             */
            getTextBounds(round: boolean): TextBounds;

            /**
             * [description]
             */
            width: number;

            /**
             * [description]
             */
            height: number;

            /**
             * Clears all alpha values associated with this Game Object.
             * Immediately sets the alpha levels back to 1 (fully opaque)
             */
            clearAlpha(): Phaser.GameObjects.GameObject;

            /**
             * Set the Alpha level of this Game Object. The alpha controls the opacity of the Game Object as it renders.
             * Alpha values are provided as a float between 0, fully transparent, and 1, fully opaque.
             * 
             * If your game is running under WebGL you can optionally specify four different alpha values, each of which
             * correspond to the four corners of the Game Object. Under Canvas only the `topLeft` value given is used.
             * @param topLeft The alpha value used for the top-left of the Game Object. If this is the only value given it's applied across the whole Game Object. Default 1.
             * @param topRight The alpha value used for the top-right of the Game Object. WebGL only.
             * @param bottomLeft The alpha value used for the bottom-left of the Game Object. WebGL only.
             * @param bottomRight The alpha value used for the bottom-right of the Game Object. WebGL only.
             */
            setAlpha(topLeft?: number, topRight?: number, bottomLeft?: number, bottomRight?: number): Phaser.GameObjects.GameObject;

            /**
             * The alpha value of the Game Object.
             * 
             * This is a global value, impacting the entire Game Object, not just a region of it.
             */
            alpha: number;

            /**
             * The alpha value starting from the top-left of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            alphaTopLeft: number;

            /**
             * The alpha value starting from the top-right of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            alphaTopRight: number;

            /**
             * The alpha value starting from the bottom-left of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            alphaBottomLeft: number;

            /**
             * The alpha value starting from the bottom-right of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            alphaBottomRight: number;

            /**
             * Sets the Blend Mode being used by this Game Object.
             * 
             * This can be a const, such as `Phaser.BlendModes.SCREEN`, or an integer, such as 4 (for Overlay)
             * 
             * Under WebGL only the following Blend Modes are available:
             * 
             * * ADD
             * * MULTIPLY
             * * SCREEN
             * 
             * Canvas has more available depending on browser support.
             * 
             * You can also create your own custom Blend Modes in WebGL.
             * 
             * Blend modes have different effects under Canvas and WebGL, and from browser to browser, depending
             * on support. Blend Modes also cause a WebGL batch flush should it encounter a new blend mode. For these
             * reasons try to be careful about the construction of your Scene and the frequency of which blend modes
             * are used.
             */
            blendMode: Phaser.BlendModes | string;

            /**
             * Sets the Blend Mode being used by this Game Object.
             * 
             * This can be a const, such as `Phaser.BlendModes.SCREEN`, or an integer, such as 4 (for Overlay)
             * 
             * Under WebGL only the following Blend Modes are available:
             * 
             * * ADD
             * * MULTIPLY
             * * SCREEN
             * 
             * Canvas has more available depending on browser support.
             * 
             * You can also create your own custom Blend Modes in WebGL.
             * 
             * Blend modes have different effects under Canvas and WebGL, and from browser to browser, depending
             * on support. Blend Modes also cause a WebGL batch flush should it encounter a new blend mode. For these
             * reasons try to be careful about the construction of your Scene and the frequency of which blend modes
             * are used.
             * @param value The BlendMode value. Either a string or a CONST.
             */
            setBlendMode(value: string | Phaser.BlendModes): Phaser.GameObjects.GameObject;

            /**
             * The depth of this Game Object within the Scene.
             * 
             * The depth is also known as the 'z-index' in some environments, and allows you to change the rendering order
             * of Game Objects, without actually moving their position in the display list.
             * 
             * The depth starts from zero (the default value) and increases from that point. A Game Object with a higher depth
             * value will always render in front of one with a lower value.
             * 
             * Setting the depth will queue a depth sort event within the Scene.
             */
            depth: number;

            /**
             * The depth of this Game Object within the Scene.
             * 
             * The depth is also known as the 'z-index' in some environments, and allows you to change the rendering order
             * of Game Objects, without actually moving their position in the display list.
             * 
             * The depth starts from zero (the default value) and increases from that point. A Game Object with a higher depth
             * value will always render in front of one with a lower value.
             * 
             * Setting the depth will queue a depth sort event within the Scene.
             * @param value The depth of this Game Object.
             */
            setDepth(value: integer): Phaser.GameObjects.GameObject;

            /**
             * The horizontal origin of this Game Object.
             * The origin maps the relationship between the size and position of the Game Object.
             * The default value is 0.5, meaning all Game Objects are positioned based on their center.
             * Setting the value to 0 means the position now relates to the left of the Game Object.
             */
            originX: number;

            /**
             * The vertical origin of this Game Object.
             * The origin maps the relationship between the size and position of the Game Object.
             * The default value is 0.5, meaning all Game Objects are positioned based on their center.
             * Setting the value to 0 means the position now relates to the top of the Game Object.
             */
            originY: number;

            /**
             * The horizontal display origin of this Game Object.
             * The origin is a normalized value between 0 and 1.
             * The displayOrigin is a pixel value, based on the size of the Game Object combined with the origin.
             */
            displayOriginX: number;

            /**
             * The vertical display origin of this Game Object.
             * The origin is a normalized value between 0 and 1.
             * The displayOrigin is a pixel value, based on the size of the Game Object combined with the origin.
             */
            displayOriginY: number;

            /**
             * Sets the origin of this Game Object.
             * 
             * The values are given in the range 0 to 1.
             * @param x The horizontal origin value. Default 0.5.
             * @param y The vertical origin value. If not defined it will be set to the value of `x`. Default x.
             */
            setOrigin(x?: number, y?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the origin of this Game Object based on the Pivot values in its Frame.
             */
            setOriginFromFrame(): Phaser.GameObjects.GameObject;

            /**
             * Sets the display origin of this Game Object.
             * The difference between this and setting the origin is that you can use pixel values for setting the display origin.
             * @param x The horizontal display origin value. Default 0.
             * @param y The vertical display origin value. If not defined it will be set to the value of `x`. Default x.
             */
            setDisplayOrigin(x?: number, y?: number): Phaser.GameObjects.GameObject;

            /**
             * Updates the Display Origin cached values internally stored on this Game Object.
             * You don't usually call this directly, but it is exposed for edge-cases where you may.
             */
            updateDisplayOrigin(): Phaser.GameObjects.GameObject;

            /**
             * [description]
             */
            defaultPipeline: Phaser.Renderer.WebGL.WebGLPipeline;

            /**
             * [description]
             */
            pipeline: Phaser.Renderer.WebGL.WebGLPipeline;

            /**
             * Sets the initial WebGL Pipeline of this Game Object.
             * This should only be called during the instantiation of the Game Object.
             * @param pipelineName The name of the pipeline to set on this Game Object.
             */
            initPipeline(pipelineName: string): boolean;

            /**
             * Sets the active WebGL Pipeline of this Game Object.
             * @param pipelineName The name of the pipeline to set on this Game Object.
             */
            setPipeline(pipelineName: string): boolean;

            /**
             * Resets the WebGL Pipeline of this Game Object back to the default it was created with.
             */
            resetPipeline(): boolean;

            /**
             * Gets the name of the WebGL Pipeline this Game Object is currently using.
             */
            getPipelineName(): string;

            /**
             * The horizontal scroll factor of this Game Object.
             * 
             * The scroll factor controls the influence of the movement of a Camera upon this Game Object.
             * 
             * When a camera scrolls it will change the location at which this Game Object is rendered on-screen.
             * It does not change the Game Objects actual position values.
             * 
             * A value of 1 means it will move exactly in sync with a camera.
             * A value of 0 means it will not move at all, even if the camera moves.
             * Other values control the degree to which the camera movement is mapped to this Game Object.
             */
            scrollFactorX: number;

            /**
             * The vertical scroll factor of this Game Object.
             * 
             * The scroll factor controls the influence of the movement of a Camera upon this Game Object.
             * 
             * When a camera scrolls it will change the location at which this Game Object is rendered on-screen.
             * It does not change the Game Objects actual position values.
             * 
             * A value of 1 means it will move exactly in sync with a camera.
             * A value of 0 means it will not move at all, even if the camera moves.
             * Other values control the degree to which the camera movement is mapped to this Game Object.
             */
            scrollFactorY: number;

            /**
             * Sets the scroll factor of this Game Object.
             * 
             * The scroll factor controls the influence of the movement of a Camera upon this Game Object.
             * 
             * When a camera scrolls it will change the location at which this Game Object is rendered on-screen.
             * It does not change the Game Objects actual position values.
             * 
             * A value of 1 means it will move exactly in sync with a camera.
             * A value of 0 means it will not move at all, even if the camera moves.
             * Other values control the degree to which the camera movement is mapped to this Game Object.
             * @param x The horizontal scroll factor of this Game Object.
             * @param y The vertical scroll factor of this Game Object. If not set it will use the `x` value. Default x.
             */
            setScrollFactor(x: number, y?: number): Phaser.GameObjects.GameObject;

            /**
             * The Texture this Game Object is using to render with.
             */
            texture: Phaser.Textures.Texture;

            /**
             * The Texture Frame this Game Object is using to render with.
             */
            frame: Phaser.Textures.Frame;

            /**
             * Sets the texture and frame this Game Object will use to render with.
             * 
             * Textures are referenced by their string-based keys, as stored in the Texture Manager.
             * @param key The key of the texture to be used, as stored in the Texture Manager.
             * @param frame The name or index of the frame within the Texture.
             */
            setTexture(key: string, frame?: string | integer): Phaser.GameObjects.GameObject;

            /**
             * Sets the frame this Game Object will use to render with.
             * 
             * The Frame has to belong to the current Texture being used.
             * 
             * It can be either a string or an index.
             * 
             * Calling `setFrame` will modify the `width` and `height` properties of your Game Object.
             * It will also change the `origin` if the Frame has a custom pivot point, as exported from packages like Texture Packer.
             * @param frame The name or index of the frame within the Texture.
             * @param updateSize Should this call adjust the size of the Game Object? Default true.
             * @param updateOrigin Should this call adjust the origin of the Game Object? Default true.
             */
            setFrame(frame: string | integer, updateSize?: boolean, updateOrigin?: boolean): Phaser.GameObjects.GameObject;

            /**
             * Clears all tint values associated with this Game Object.
             * Immediately sets the alpha levels back to 0xffffff (no tint)
             */
            clearTint(): Phaser.GameObjects.GameObject;

            /**
             * Sets the tint values for this Game Object.
             * @param topLeft The tint being applied to the top-left of the Game Object. If not other values are given this value is applied evenly, tinting the whole Game Object. Default 0xffffff.
             * @param topRight The tint being applied to the top-right of the Game Object.
             * @param bottomLeft The tint being applied to the bottom-left of the Game Object.
             * @param bottomRight The tint being applied to the bottom-right of the Game Object.
             */
            setTint(topLeft?: integer, topRight?: integer, bottomLeft?: integer, bottomRight?: integer): Phaser.GameObjects.GameObject;

            /**
             * The tint value being applied to the top-left of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            tintTopLeft: integer;

            /**
             * The tint value being applied to the top-right of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            tintTopRight: integer;

            /**
             * The tint value being applied to the bottom-left of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            tintBottomLeft: integer;

            /**
             * The tint value being applied to the bottom-right of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            tintBottomRight: integer;

            /**
             * The tint value being applied to the whole of the Game Object.
             */
            tint: integer;

            /**
             * The x position of this Game Object.
             */
            x: number;

            /**
             * The y position of this Game Object.
             */
            y: number;

            /**
             * The z position of this Game Object.
             * Note: Do not use this value to set the z-index, instead see the `depth` property.
             */
            z: number;

            /**
             * The w position of this Game Object.
             */
            w: number;

            /**
             * The horizontal scale of this Game Object.
             */
            scaleX: number;

            /**
             * The vertical scale of this Game Object.
             */
            scaleY: number;

            /**
             * The angle of this Game Object as expressed in degrees.
             * 
             * Where 0 is to the right, 90 is down, 180 is left.
             * 
             * If you prefer to work in radians, see the `rotation` property instead.
             */
            angle: integer;

            /**
             * The angle of this Game Object in radians.
             * 
             * If you prefer to work in degrees, see the `angle` property instead.
             */
            rotation: number;

            /**
             * Sets the position of this Game Object.
             * @param x The x position of this Game Object. Default 0.
             * @param y The y position of this Game Object. If not set it will use the `x` value.
             * @param z The z position of this Game Object. Default 0.
             * @param w The w position of this Game Object. Default 0.
             */
            setPosition(x?: number, y?: number, z?: number, w?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the rotation of this Game Object.
             * @param radians The rotation of this Game Object, in radians. Default 0.
             */
            setRotation(radians?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the angle of this Game Object.
             * @param degrees The rotation of this Game Object, in degrees. Default 0.
             */
            setAngle(degrees?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the scale of this Game Object.
             * @param x The horizontal scale of this Game Object.
             * @param y The vertical scale of this Game Object. If not set it will use the `x` value. Default x.
             */
            setScale(x: number, y?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the x position of this Game Object.
             * @param value The x position of this Game Object. Default 0.
             */
            setX(value?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the y position of this Game Object.
             * @param value The y position of this Game Object. Default 0.
             */
            setY(value?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the z position of this Game Object.
             * @param value The z position of this Game Object. Default 0.
             */
            setZ(value?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the w position of this Game Object.
             * @param value The w position of this Game Object. Default 0.
             */
            setW(value?: number): Phaser.GameObjects.GameObject;

            /**
             * The visible state of the Game Object.
             * 
             * An invisible Game Object will skip rendering, but will still process update logic.
             */
            visible: boolean;

            /**
             * Sets the visibility of this Game Object.
             * 
             * An invisible Game Object will skip rendering, but will still process update logic.
             * @param value The visible state of the Game Object.
             */
            setVisible(value: boolean): Phaser.GameObjects.GameObject;

        }

        /**
         * [description]
         */
        class BitmapText extends GameObject implements Components.Alpha, Components.BlendMode, Components.Depth, Components.Origin, Components.Pipeline, Components.ScaleMode, Components.ScrollFactor, Components.Texture, Components.Tint, Components.Transform, Components.Visible {
            /**
             * 
             * @param scene The Scene to which this Game Object belongs. It can only belong to one Scene at any given time.
             * @param x The x coordinate of this Game Object in world space.
             * @param y The y coordinate of this Game Object in world space.
             * @param font [description]
             * @param text [description]
             * @param size [description]
             */
            constructor(scene: Phaser.Scene, x: number, y: number, font: string, text?: string | string[], size?: number);

            /**
             * [description]
             */
            font: string;

            /**
             * [description]
             */
            fontData: object;

            /**
             * [description]
             */
            text: string;

            /**
             * [description]
             */
            fontSize: number;

            /**
             * [description]
             * @param size [description]
             */
            setFontSize(size: number): Phaser.GameObjects.BitmapText;

            /**
             * [description]
             * @param value The string, or array of strings, to be set as the content of this BitmapText.
             */
            setText(value: string | string[]): Phaser.GameObjects.BitmapText;

            /**
             * [description]
             * @param round [description]
             */
            getTextBounds(round: boolean): TextBounds;

            /**
             * [description]
             */
            width: number;

            /**
             * [description]
             */
            height: number;

            /**
             * Clears all alpha values associated with this Game Object.
             * Immediately sets the alpha levels back to 1 (fully opaque)
             */
            clearAlpha(): Phaser.GameObjects.GameObject;

            /**
             * Set the Alpha level of this Game Object. The alpha controls the opacity of the Game Object as it renders.
             * Alpha values are provided as a float between 0, fully transparent, and 1, fully opaque.
             * 
             * If your game is running under WebGL you can optionally specify four different alpha values, each of which
             * correspond to the four corners of the Game Object. Under Canvas only the `topLeft` value given is used.
             * @param topLeft The alpha value used for the top-left of the Game Object. If this is the only value given it's applied across the whole Game Object. Default 1.
             * @param topRight The alpha value used for the top-right of the Game Object. WebGL only.
             * @param bottomLeft The alpha value used for the bottom-left of the Game Object. WebGL only.
             * @param bottomRight The alpha value used for the bottom-right of the Game Object. WebGL only.
             */
            setAlpha(topLeft?: number, topRight?: number, bottomLeft?: number, bottomRight?: number): Phaser.GameObjects.GameObject;

            /**
             * The alpha value of the Game Object.
             * 
             * This is a global value, impacting the entire Game Object, not just a region of it.
             */
            alpha: number;

            /**
             * The alpha value starting from the top-left of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            alphaTopLeft: number;

            /**
             * The alpha value starting from the top-right of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            alphaTopRight: number;

            /**
             * The alpha value starting from the bottom-left of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            alphaBottomLeft: number;

            /**
             * The alpha value starting from the bottom-right of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            alphaBottomRight: number;

            /**
             * Sets the Blend Mode being used by this Game Object.
             * 
             * This can be a const, such as `Phaser.BlendModes.SCREEN`, or an integer, such as 4 (for Overlay)
             * 
             * Under WebGL only the following Blend Modes are available:
             * 
             * * ADD
             * * MULTIPLY
             * * SCREEN
             * 
             * Canvas has more available depending on browser support.
             * 
             * You can also create your own custom Blend Modes in WebGL.
             * 
             * Blend modes have different effects under Canvas and WebGL, and from browser to browser, depending
             * on support. Blend Modes also cause a WebGL batch flush should it encounter a new blend mode. For these
             * reasons try to be careful about the construction of your Scene and the frequency of which blend modes
             * are used.
             */
            blendMode: Phaser.BlendModes | string;

            /**
             * Sets the Blend Mode being used by this Game Object.
             * 
             * This can be a const, such as `Phaser.BlendModes.SCREEN`, or an integer, such as 4 (for Overlay)
             * 
             * Under WebGL only the following Blend Modes are available:
             * 
             * * ADD
             * * MULTIPLY
             * * SCREEN
             * 
             * Canvas has more available depending on browser support.
             * 
             * You can also create your own custom Blend Modes in WebGL.
             * 
             * Blend modes have different effects under Canvas and WebGL, and from browser to browser, depending
             * on support. Blend Modes also cause a WebGL batch flush should it encounter a new blend mode. For these
             * reasons try to be careful about the construction of your Scene and the frequency of which blend modes
             * are used.
             * @param value The BlendMode value. Either a string or a CONST.
             */
            setBlendMode(value: string | Phaser.BlendModes): Phaser.GameObjects.GameObject;

            /**
             * The depth of this Game Object within the Scene.
             * 
             * The depth is also known as the 'z-index' in some environments, and allows you to change the rendering order
             * of Game Objects, without actually moving their position in the display list.
             * 
             * The depth starts from zero (the default value) and increases from that point. A Game Object with a higher depth
             * value will always render in front of one with a lower value.
             * 
             * Setting the depth will queue a depth sort event within the Scene.
             */
            depth: number;

            /**
             * The depth of this Game Object within the Scene.
             * 
             * The depth is also known as the 'z-index' in some environments, and allows you to change the rendering order
             * of Game Objects, without actually moving their position in the display list.
             * 
             * The depth starts from zero (the default value) and increases from that point. A Game Object with a higher depth
             * value will always render in front of one with a lower value.
             * 
             * Setting the depth will queue a depth sort event within the Scene.
             * @param value The depth of this Game Object.
             */
            setDepth(value: integer): Phaser.GameObjects.GameObject;

            /**
             * The horizontal origin of this Game Object.
             * The origin maps the relationship between the size and position of the Game Object.
             * The default value is 0.5, meaning all Game Objects are positioned based on their center.
             * Setting the value to 0 means the position now relates to the left of the Game Object.
             */
            originX: number;

            /**
             * The vertical origin of this Game Object.
             * The origin maps the relationship between the size and position of the Game Object.
             * The default value is 0.5, meaning all Game Objects are positioned based on their center.
             * Setting the value to 0 means the position now relates to the top of the Game Object.
             */
            originY: number;

            /**
             * The horizontal display origin of this Game Object.
             * The origin is a normalized value between 0 and 1.
             * The displayOrigin is a pixel value, based on the size of the Game Object combined with the origin.
             */
            displayOriginX: number;

            /**
             * The vertical display origin of this Game Object.
             * The origin is a normalized value between 0 and 1.
             * The displayOrigin is a pixel value, based on the size of the Game Object combined with the origin.
             */
            displayOriginY: number;

            /**
             * Sets the origin of this Game Object.
             * 
             * The values are given in the range 0 to 1.
             * @param x The horizontal origin value. Default 0.5.
             * @param y The vertical origin value. If not defined it will be set to the value of `x`. Default x.
             */
            setOrigin(x?: number, y?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the origin of this Game Object based on the Pivot values in its Frame.
             */
            setOriginFromFrame(): Phaser.GameObjects.GameObject;

            /**
             * Sets the display origin of this Game Object.
             * The difference between this and setting the origin is that you can use pixel values for setting the display origin.
             * @param x The horizontal display origin value. Default 0.
             * @param y The vertical display origin value. If not defined it will be set to the value of `x`. Default x.
             */
            setDisplayOrigin(x?: number, y?: number): Phaser.GameObjects.GameObject;

            /**
             * Updates the Display Origin cached values internally stored on this Game Object.
             * You don't usually call this directly, but it is exposed for edge-cases where you may.
             */
            updateDisplayOrigin(): Phaser.GameObjects.GameObject;

            /**
             * [description]
             */
            defaultPipeline: Phaser.Renderer.WebGL.WebGLPipeline;

            /**
             * [description]
             */
            pipeline: Phaser.Renderer.WebGL.WebGLPipeline;

            /**
             * Sets the initial WebGL Pipeline of this Game Object.
             * This should only be called during the instantiation of the Game Object.
             * @param pipelineName The name of the pipeline to set on this Game Object.
             */
            initPipeline(pipelineName: string): boolean;

            /**
             * Sets the active WebGL Pipeline of this Game Object.
             * @param pipelineName The name of the pipeline to set on this Game Object.
             */
            setPipeline(pipelineName: string): boolean;

            /**
             * Resets the WebGL Pipeline of this Game Object back to the default it was created with.
             */
            resetPipeline(): boolean;

            /**
             * Gets the name of the WebGL Pipeline this Game Object is currently using.
             */
            getPipelineName(): string;

            /**
             * The Scale Mode being used by this Game Object.
             * Can be either `ScaleModes.LINEAR` or `ScaleModes.NEAREST`.
             */
            scaleMode: Phaser.ScaleModes;

            /**
             * Sets the Scale Mode being used by this Game Object.
             * Can be either `ScaleModes.LINEAR` or `ScaleModes.NEAREST`.
             * @param value The Scale Mode to be used by this Game Object.
             */
            setScaleMode(value: Phaser.ScaleModes): Phaser.GameObjects.GameObject;

            /**
             * The horizontal scroll factor of this Game Object.
             * 
             * The scroll factor controls the influence of the movement of a Camera upon this Game Object.
             * 
             * When a camera scrolls it will change the location at which this Game Object is rendered on-screen.
             * It does not change the Game Objects actual position values.
             * 
             * A value of 1 means it will move exactly in sync with a camera.
             * A value of 0 means it will not move at all, even if the camera moves.
             * Other values control the degree to which the camera movement is mapped to this Game Object.
             */
            scrollFactorX: number;

            /**
             * The vertical scroll factor of this Game Object.
             * 
             * The scroll factor controls the influence of the movement of a Camera upon this Game Object.
             * 
             * When a camera scrolls it will change the location at which this Game Object is rendered on-screen.
             * It does not change the Game Objects actual position values.
             * 
             * A value of 1 means it will move exactly in sync with a camera.
             * A value of 0 means it will not move at all, even if the camera moves.
             * Other values control the degree to which the camera movement is mapped to this Game Object.
             */
            scrollFactorY: number;

            /**
             * Sets the scroll factor of this Game Object.
             * 
             * The scroll factor controls the influence of the movement of a Camera upon this Game Object.
             * 
             * When a camera scrolls it will change the location at which this Game Object is rendered on-screen.
             * It does not change the Game Objects actual position values.
             * 
             * A value of 1 means it will move exactly in sync with a camera.
             * A value of 0 means it will not move at all, even if the camera moves.
             * Other values control the degree to which the camera movement is mapped to this Game Object.
             * @param x The horizontal scroll factor of this Game Object.
             * @param y The vertical scroll factor of this Game Object. If not set it will use the `x` value. Default x.
             */
            setScrollFactor(x: number, y?: number): Phaser.GameObjects.GameObject;

            /**
             * The Texture this Game Object is using to render with.
             */
            texture: Phaser.Textures.Texture;

            /**
             * The Texture Frame this Game Object is using to render with.
             */
            frame: Phaser.Textures.Frame;

            /**
             * Sets the texture and frame this Game Object will use to render with.
             * 
             * Textures are referenced by their string-based keys, as stored in the Texture Manager.
             * @param key The key of the texture to be used, as stored in the Texture Manager.
             * @param frame The name or index of the frame within the Texture.
             */
            setTexture(key: string, frame?: string | integer): Phaser.GameObjects.GameObject;

            /**
             * Sets the frame this Game Object will use to render with.
             * 
             * The Frame has to belong to the current Texture being used.
             * 
             * It can be either a string or an index.
             * 
             * Calling `setFrame` will modify the `width` and `height` properties of your Game Object.
             * It will also change the `origin` if the Frame has a custom pivot point, as exported from packages like Texture Packer.
             * @param frame The name or index of the frame within the Texture.
             * @param updateSize Should this call adjust the size of the Game Object? Default true.
             * @param updateOrigin Should this call adjust the origin of the Game Object? Default true.
             */
            setFrame(frame: string | integer, updateSize?: boolean, updateOrigin?: boolean): Phaser.GameObjects.GameObject;

            /**
             * Clears all tint values associated with this Game Object.
             * Immediately sets the alpha levels back to 0xffffff (no tint)
             */
            clearTint(): Phaser.GameObjects.GameObject;

            /**
             * Sets the tint values for this Game Object.
             * @param topLeft The tint being applied to the top-left of the Game Object. If not other values are given this value is applied evenly, tinting the whole Game Object. Default 0xffffff.
             * @param topRight The tint being applied to the top-right of the Game Object.
             * @param bottomLeft The tint being applied to the bottom-left of the Game Object.
             * @param bottomRight The tint being applied to the bottom-right of the Game Object.
             */
            setTint(topLeft?: integer, topRight?: integer, bottomLeft?: integer, bottomRight?: integer): Phaser.GameObjects.GameObject;

            /**
             * The tint value being applied to the top-left of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            tintTopLeft: integer;

            /**
             * The tint value being applied to the top-right of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            tintTopRight: integer;

            /**
             * The tint value being applied to the bottom-left of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            tintBottomLeft: integer;

            /**
             * The tint value being applied to the bottom-right of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            tintBottomRight: integer;

            /**
             * The tint value being applied to the whole of the Game Object.
             */
            tint: integer;

            /**
             * The x position of this Game Object.
             */
            x: number;

            /**
             * The y position of this Game Object.
             */
            y: number;

            /**
             * The z position of this Game Object.
             * Note: Do not use this value to set the z-index, instead see the `depth` property.
             */
            z: number;

            /**
             * The w position of this Game Object.
             */
            w: number;

            /**
             * The horizontal scale of this Game Object.
             */
            scaleX: number;

            /**
             * The vertical scale of this Game Object.
             */
            scaleY: number;

            /**
             * The angle of this Game Object as expressed in degrees.
             * 
             * Where 0 is to the right, 90 is down, 180 is left.
             * 
             * If you prefer to work in radians, see the `rotation` property instead.
             */
            angle: integer;

            /**
             * The angle of this Game Object in radians.
             * 
             * If you prefer to work in degrees, see the `angle` property instead.
             */
            rotation: number;

            /**
             * Sets the position of this Game Object.
             * @param x The x position of this Game Object. Default 0.
             * @param y The y position of this Game Object. If not set it will use the `x` value.
             * @param z The z position of this Game Object. Default 0.
             * @param w The w position of this Game Object. Default 0.
             */
            setPosition(x?: number, y?: number, z?: number, w?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the rotation of this Game Object.
             * @param radians The rotation of this Game Object, in radians. Default 0.
             */
            setRotation(radians?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the angle of this Game Object.
             * @param degrees The rotation of this Game Object, in degrees. Default 0.
             */
            setAngle(degrees?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the scale of this Game Object.
             * @param x The horizontal scale of this Game Object.
             * @param y The vertical scale of this Game Object. If not set it will use the `x` value. Default x.
             */
            setScale(x: number, y?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the x position of this Game Object.
             * @param value The x position of this Game Object. Default 0.
             */
            setX(value?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the y position of this Game Object.
             * @param value The y position of this Game Object. Default 0.
             */
            setY(value?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the z position of this Game Object.
             * @param value The z position of this Game Object. Default 0.
             */
            setZ(value?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the w position of this Game Object.
             * @param value The w position of this Game Object. Default 0.
             */
            setW(value?: number): Phaser.GameObjects.GameObject;

            /**
             * The visible state of the Game Object.
             * 
             * An invisible Game Object will skip rendering, but will still process update logic.
             */
            visible: boolean;

            /**
             * Sets the visibility of this Game Object.
             * 
             * An invisible Game Object will skip rendering, but will still process update logic.
             * @param value The visible state of the Game Object.
             */
            setVisible(value: boolean): Phaser.GameObjects.GameObject;

        }

        /**
         * A Blitter Game Object.
         * 
         * 
         * 
         * The Blitter Game Object is a special kind of container that creates, updates and manages Bob objects.
         * 
         * Bobs are designed for rendering speed rather than flexibility. They consist of a texture, or frame from a texture,
         * 
         * a position and an alpha value. You cannot scale or rotate them. They use a batched drawing method for speed
         * 
         * during rendering.
         * 
         * 
         * 
         * A Blitter Game Object has one texture bound to it. Bobs created by the Blitter can use any Frame from this
         * 
         * Texture to render with, but they cannot use any other Texture. It is this single texture-bind that allows
         * 
         * them their speed.
         * 
         * 
         * 
         * If you have a need to blast a large volume of frames around the screen then Blitter objects are well worth
         * 
         * investigating. They are especially useful for using as a base for your own special effects systems.
         */
        class Blitter extends GameObject implements Components.Alpha, Components.BlendMode, Components.Depth, Components.Pipeline, Components.ScaleMode, Components.ScrollFactor, Components.Size, Components.Texture, Components.Transform, Components.Visible {
            /**
             * 
             * @param scene The Scene to which this Game Object belongs. It can only belong to one Scene at any given time.
             * @param x The x coordinate of this Game Object in world space. Default 0.
             * @param y The y coordinate of this Game Object in world space. Default 0.
             * @param texture The key of the texture this Game Object will use for rendering. The Texture must already exist in the Texture Manager. Default '__DEFAULT'.
             * @param frame The Frame of the Texture that this Game Object will use. Only set if the Texture has multiple frames, such as a Texture Atlas or Sprite Sheet. Default 0.
             */
            constructor(scene: Phaser.Scene, x?: number, y?: number, texture?: string, frame?: string | integer);

            /**
             * [description]
             */
            children: Phaser.Structs.List<Phaser.GameObjects.Blitter.Bob>;

            /**
             * [description]
             */
            renderList: Phaser.GameObjects.Blitter.Bob[];

            /**
             * [description]
             * @param x The x position of the Bob. Bob coordinate are relative to the position of the Blitter object.
             * @param y The y position of the Bob. Bob coordinate are relative to the position of the Blitter object.
             * @param frame The Frame the Bob will use. It _must_ be part of the Texture the parent Blitter object is using.
             * @param visible Should the created Bob render or not? Default true.
             * @param index The position in the Blitters Display List to add the new Bob at. Defaults to the top of the list.
             */
            create(x: number, y: number, frame?: string | integer | Phaser.Textures.Frame, visible?: boolean, index?: integer): Phaser.GameObjects.Blitter.Bob;

            /**
             * [description]
             * @param callback The callback to invoke after creating a bob. It will be sent two arguments: The Bob and the index of the Bob.
             * @param quantity The quantity of Bob objects to create.
             * @param frame The Frame the Bobs will use. It must be part of the Blitter Texture.
             * @param visible [description] Default true.
             */
            createFromCallback(callback: BlitterFromCallback, quantity: integer, frame?: string | integer | Phaser.Textures.Frame | string[] | integer[] | Phaser.Textures.Frame[], visible?: boolean): Phaser.GameObjects.Blitter.Bob[];

            /**
             * [description]
             * @param quantity The quantity of Bob objects to create.
             * @param frame The Frame the Bobs will use. It must be part of the Blitter Texture.
             * @param visible [description] Default true.
             */
            createMultiple(quantity: integer, frame?: string | integer | Phaser.Textures.Frame | string[] | integer[] | Phaser.Textures.Frame[], visible?: boolean): Phaser.GameObjects.Blitter.Bob[];

            /**
             * [description]
             * @param child [description]
             */
            childCanRender(child: Phaser.GameObjects.Blitter.Bob): boolean;

            /**
             * [description]
             */
            getRenderList(): Phaser.GameObjects.Blitter.Bob[];

            /**
             * [description]
             */
            clear(): void;

            /**
             * Clears all alpha values associated with this Game Object.
             * Immediately sets the alpha levels back to 1 (fully opaque)
             */
            clearAlpha(): Phaser.GameObjects.GameObject;

            /**
             * Set the Alpha level of this Game Object. The alpha controls the opacity of the Game Object as it renders.
             * Alpha values are provided as a float between 0, fully transparent, and 1, fully opaque.
             * 
             * If your game is running under WebGL you can optionally specify four different alpha values, each of which
             * correspond to the four corners of the Game Object. Under Canvas only the `topLeft` value given is used.
             * @param topLeft The alpha value used for the top-left of the Game Object. If this is the only value given it's applied across the whole Game Object. Default 1.
             * @param topRight The alpha value used for the top-right of the Game Object. WebGL only.
             * @param bottomLeft The alpha value used for the bottom-left of the Game Object. WebGL only.
             * @param bottomRight The alpha value used for the bottom-right of the Game Object. WebGL only.
             */
            setAlpha(topLeft?: number, topRight?: number, bottomLeft?: number, bottomRight?: number): Phaser.GameObjects.GameObject;

            /**
             * The alpha value of the Game Object.
             * 
             * This is a global value, impacting the entire Game Object, not just a region of it.
             */
            alpha: number;

            /**
             * The alpha value starting from the top-left of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            alphaTopLeft: number;

            /**
             * The alpha value starting from the top-right of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            alphaTopRight: number;

            /**
             * The alpha value starting from the bottom-left of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            alphaBottomLeft: number;

            /**
             * The alpha value starting from the bottom-right of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            alphaBottomRight: number;

            /**
             * Sets the Blend Mode being used by this Game Object.
             * 
             * This can be a const, such as `Phaser.BlendModes.SCREEN`, or an integer, such as 4 (for Overlay)
             * 
             * Under WebGL only the following Blend Modes are available:
             * 
             * * ADD
             * * MULTIPLY
             * * SCREEN
             * 
             * Canvas has more available depending on browser support.
             * 
             * You can also create your own custom Blend Modes in WebGL.
             * 
             * Blend modes have different effects under Canvas and WebGL, and from browser to browser, depending
             * on support. Blend Modes also cause a WebGL batch flush should it encounter a new blend mode. For these
             * reasons try to be careful about the construction of your Scene and the frequency of which blend modes
             * are used.
             */
            blendMode: Phaser.BlendModes | string;

            /**
             * Sets the Blend Mode being used by this Game Object.
             * 
             * This can be a const, such as `Phaser.BlendModes.SCREEN`, or an integer, such as 4 (for Overlay)
             * 
             * Under WebGL only the following Blend Modes are available:
             * 
             * * ADD
             * * MULTIPLY
             * * SCREEN
             * 
             * Canvas has more available depending on browser support.
             * 
             * You can also create your own custom Blend Modes in WebGL.
             * 
             * Blend modes have different effects under Canvas and WebGL, and from browser to browser, depending
             * on support. Blend Modes also cause a WebGL batch flush should it encounter a new blend mode. For these
             * reasons try to be careful about the construction of your Scene and the frequency of which blend modes
             * are used.
             * @param value The BlendMode value. Either a string or a CONST.
             */
            setBlendMode(value: string | Phaser.BlendModes): Phaser.GameObjects.GameObject;

            /**
             * The depth of this Game Object within the Scene.
             * 
             * The depth is also known as the 'z-index' in some environments, and allows you to change the rendering order
             * of Game Objects, without actually moving their position in the display list.
             * 
             * The depth starts from zero (the default value) and increases from that point. A Game Object with a higher depth
             * value will always render in front of one with a lower value.
             * 
             * Setting the depth will queue a depth sort event within the Scene.
             */
            depth: number;

            /**
             * The depth of this Game Object within the Scene.
             * 
             * The depth is also known as the 'z-index' in some environments, and allows you to change the rendering order
             * of Game Objects, without actually moving their position in the display list.
             * 
             * The depth starts from zero (the default value) and increases from that point. A Game Object with a higher depth
             * value will always render in front of one with a lower value.
             * 
             * Setting the depth will queue a depth sort event within the Scene.
             * @param value The depth of this Game Object.
             */
            setDepth(value: integer): Phaser.GameObjects.GameObject;

            /**
             * [description]
             */
            defaultPipeline: Phaser.Renderer.WebGL.WebGLPipeline;

            /**
             * [description]
             */
            pipeline: Phaser.Renderer.WebGL.WebGLPipeline;

            /**
             * Sets the initial WebGL Pipeline of this Game Object.
             * This should only be called during the instantiation of the Game Object.
             * @param pipelineName The name of the pipeline to set on this Game Object.
             */
            initPipeline(pipelineName: string): boolean;

            /**
             * Sets the active WebGL Pipeline of this Game Object.
             * @param pipelineName The name of the pipeline to set on this Game Object.
             */
            setPipeline(pipelineName: string): boolean;

            /**
             * Resets the WebGL Pipeline of this Game Object back to the default it was created with.
             */
            resetPipeline(): boolean;

            /**
             * Gets the name of the WebGL Pipeline this Game Object is currently using.
             */
            getPipelineName(): string;

            /**
             * The Scale Mode being used by this Game Object.
             * Can be either `ScaleModes.LINEAR` or `ScaleModes.NEAREST`.
             */
            scaleMode: Phaser.ScaleModes;

            /**
             * Sets the Scale Mode being used by this Game Object.
             * Can be either `ScaleModes.LINEAR` or `ScaleModes.NEAREST`.
             * @param value The Scale Mode to be used by this Game Object.
             */
            setScaleMode(value: Phaser.ScaleModes): Phaser.GameObjects.GameObject;

            /**
             * The horizontal scroll factor of this Game Object.
             * 
             * The scroll factor controls the influence of the movement of a Camera upon this Game Object.
             * 
             * When a camera scrolls it will change the location at which this Game Object is rendered on-screen.
             * It does not change the Game Objects actual position values.
             * 
             * A value of 1 means it will move exactly in sync with a camera.
             * A value of 0 means it will not move at all, even if the camera moves.
             * Other values control the degree to which the camera movement is mapped to this Game Object.
             */
            scrollFactorX: number;

            /**
             * The vertical scroll factor of this Game Object.
             * 
             * The scroll factor controls the influence of the movement of a Camera upon this Game Object.
             * 
             * When a camera scrolls it will change the location at which this Game Object is rendered on-screen.
             * It does not change the Game Objects actual position values.
             * 
             * A value of 1 means it will move exactly in sync with a camera.
             * A value of 0 means it will not move at all, even if the camera moves.
             * Other values control the degree to which the camera movement is mapped to this Game Object.
             */
            scrollFactorY: number;

            /**
             * Sets the scroll factor of this Game Object.
             * 
             * The scroll factor controls the influence of the movement of a Camera upon this Game Object.
             * 
             * When a camera scrolls it will change the location at which this Game Object is rendered on-screen.
             * It does not change the Game Objects actual position values.
             * 
             * A value of 1 means it will move exactly in sync with a camera.
             * A value of 0 means it will not move at all, even if the camera moves.
             * Other values control the degree to which the camera movement is mapped to this Game Object.
             * @param x The horizontal scroll factor of this Game Object.
             * @param y The vertical scroll factor of this Game Object. If not set it will use the `x` value. Default x.
             */
            setScrollFactor(x: number, y?: number): Phaser.GameObjects.GameObject;

            /**
             * The native (un-scaled) width of this Game Object.
             */
            width: number;

            /**
             * The native (un-scaled) height of this Game Object.
             */
            height: number;

            /**
             * The displayed width of this Game Object.
             * This value takes into account the scale factor.
             */
            displayWidth: number;

            /**
             * The displayed height of this Game Object.
             * This value takes into account the scale factor.
             */
            displayHeight: number;

            /**
             * Sets the size of this Game Object to be that of the given Frame.
             * @param frame The frame to base the size of this Game Object on.
             */
            setSizeToFrame(frame: Phaser.Textures.Frame): Phaser.GameObjects.GameObject;

            /**
             * Sets the size of this Game Object.
             * @param width The width of this Game Object.
             * @param height The height of this Game Object.
             */
            setSize(width: number, height: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the display size of this Game Object.
             * Calling this will adjust the scale.
             * @param width The width of this Game Object.
             * @param height The height of this Game Object.
             */
            setDisplaySize(width: number, height: number): Phaser.GameObjects.GameObject;

            /**
             * The Texture this Game Object is using to render with.
             */
            texture: Phaser.Textures.Texture;

            /**
             * The Texture Frame this Game Object is using to render with.
             */
            frame: Phaser.Textures.Frame;

            /**
             * Sets the texture and frame this Game Object will use to render with.
             * 
             * Textures are referenced by their string-based keys, as stored in the Texture Manager.
             * @param key The key of the texture to be used, as stored in the Texture Manager.
             * @param frame The name or index of the frame within the Texture.
             */
            setTexture(key: string, frame?: string | integer): Phaser.GameObjects.GameObject;

            /**
             * Sets the frame this Game Object will use to render with.
             * 
             * The Frame has to belong to the current Texture being used.
             * 
             * It can be either a string or an index.
             * 
             * Calling `setFrame` will modify the `width` and `height` properties of your Game Object.
             * It will also change the `origin` if the Frame has a custom pivot point, as exported from packages like Texture Packer.
             * @param frame The name or index of the frame within the Texture.
             * @param updateSize Should this call adjust the size of the Game Object? Default true.
             * @param updateOrigin Should this call adjust the origin of the Game Object? Default true.
             */
            setFrame(frame: string | integer, updateSize?: boolean, updateOrigin?: boolean): Phaser.GameObjects.GameObject;

            /**
             * The x position of this Game Object.
             */
            x: number;

            /**
             * The y position of this Game Object.
             */
            y: number;

            /**
             * The z position of this Game Object.
             * Note: Do not use this value to set the z-index, instead see the `depth` property.
             */
            z: number;

            /**
             * The w position of this Game Object.
             */
            w: number;

            /**
             * The horizontal scale of this Game Object.
             */
            scaleX: number;

            /**
             * The vertical scale of this Game Object.
             */
            scaleY: number;

            /**
             * The angle of this Game Object as expressed in degrees.
             * 
             * Where 0 is to the right, 90 is down, 180 is left.
             * 
             * If you prefer to work in radians, see the `rotation` property instead.
             */
            angle: integer;

            /**
             * The angle of this Game Object in radians.
             * 
             * If you prefer to work in degrees, see the `angle` property instead.
             */
            rotation: number;

            /**
             * Sets the position of this Game Object.
             * @param x The x position of this Game Object. Default 0.
             * @param y The y position of this Game Object. If not set it will use the `x` value.
             * @param z The z position of this Game Object. Default 0.
             * @param w The w position of this Game Object. Default 0.
             */
            setPosition(x?: number, y?: number, z?: number, w?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the rotation of this Game Object.
             * @param radians The rotation of this Game Object, in radians. Default 0.
             */
            setRotation(radians?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the angle of this Game Object.
             * @param degrees The rotation of this Game Object, in degrees. Default 0.
             */
            setAngle(degrees?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the scale of this Game Object.
             * @param x The horizontal scale of this Game Object.
             * @param y The vertical scale of this Game Object. If not set it will use the `x` value. Default x.
             */
            setScale(x: number, y?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the x position of this Game Object.
             * @param value The x position of this Game Object. Default 0.
             */
            setX(value?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the y position of this Game Object.
             * @param value The y position of this Game Object. Default 0.
             */
            setY(value?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the z position of this Game Object.
             * @param value The z position of this Game Object. Default 0.
             */
            setZ(value?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the w position of this Game Object.
             * @param value The w position of this Game Object. Default 0.
             */
            setW(value?: number): Phaser.GameObjects.GameObject;

            /**
             * The visible state of the Game Object.
             * 
             * An invisible Game Object will skip rendering, but will still process update logic.
             */
            visible: boolean;

            /**
             * Sets the visibility of this Game Object.
             * 
             * An invisible Game Object will skip rendering, but will still process update logic.
             * @param value The visible state of the Game Object.
             */
            setVisible(value: boolean): Phaser.GameObjects.GameObject;

        }

        /**
         * Builds a Game Object using the provided configuration object.
         * @param scene [description]
         * @param gameObject [description]
         * @param config [description]
         */
        function BuildGameObject(scene: Phaser.Scene, gameObject: Phaser.GameObjects.GameObject, config: GameObjectConfig): Phaser.GameObjects.GameObject;

        /**
         * Adds an Animation component to a Sprite and populates it based on the given config.
         * @param sprite [description]
         * @param config [description]
         */
        function BuildGameObjectAnimation(sprite: Phaser.GameObjects.Sprite, config: object): Phaser.GameObjects.Sprite;

        namespace Components {
            /**
             * Provides methods used for setting the alpha properties of a Game Object.
             * Should be applied as a mixin and not used directly.
             */
            interface Alpha {
                /**
                 * Clears all alpha values associated with this Game Object.
                 * Immediately sets the alpha levels back to 1 (fully opaque)
                 */
                clearAlpha(): Phaser.GameObjects.GameObject;
                /**
                 * Set the Alpha level of this Game Object. The alpha controls the opacity of the Game Object as it renders.
                 * Alpha values are provided as a float between 0, fully transparent, and 1, fully opaque.
                 * 
                 * If your game is running under WebGL you can optionally specify four different alpha values, each of which
                 * correspond to the four corners of the Game Object. Under Canvas only the `topLeft` value given is used.
                 * @param topLeft The alpha value used for the top-left of the Game Object. If this is the only value given it's applied across the whole Game Object. Default 1.
                 * @param topRight The alpha value used for the top-right of the Game Object. WebGL only.
                 * @param bottomLeft The alpha value used for the bottom-left of the Game Object. WebGL only.
                 * @param bottomRight The alpha value used for the bottom-right of the Game Object. WebGL only.
                 */
                setAlpha(topLeft?: number, topRight?: number, bottomLeft?: number, bottomRight?: number): Phaser.GameObjects.GameObject;
                /**
                 * The alpha value of the Game Object.
                 * 
                 * This is a global value, impacting the entire Game Object, not just a region of it.
                 */
                alpha: number;
                /**
                 * The alpha value starting from the top-left of the Game Object.
                 * This value is interpolated from the corner to the center of the Game Object.
                 */
                alphaTopLeft: number;
                /**
                 * The alpha value starting from the top-right of the Game Object.
                 * This value is interpolated from the corner to the center of the Game Object.
                 */
                alphaTopRight: number;
                /**
                 * The alpha value starting from the bottom-left of the Game Object.
                 * This value is interpolated from the corner to the center of the Game Object.
                 */
                alphaBottomLeft: number;
                /**
                 * The alpha value starting from the bottom-right of the Game Object.
                 * This value is interpolated from the corner to the center of the Game Object.
                 */
                alphaBottomRight: number;
            }

            /**
             * A Game Object Animation Controller.
             * 
             * 
             * 
             * This controller lives as an instance within a Game Object, accessible as `sprite.anims`.
             */
            class Animation {
                /**
                 * 
                 * @param parent The Game Object to which this animation controller belongs.
                 */
                constructor(parent: Phaser.GameObjects.GameObject);

                /**
                 * The Game Object to which this animation controller belongs.
                 */
                parent: Phaser.GameObjects.GameObject;

                /**
                 * A reference to the global Animation Manager.
                 */
                animationManager: Phaser.Animations.AnimationManager;

                /**
                 * Is an animation currently playing or not?
                 */
                isPlaying: boolean;

                /**
                 * The current Animation loaded into this Animation Controller.
                 */
                currentAnim: Phaser.Animations.Animation;

                /**
                 * The current AnimationFrame being displayed by this Animation Controller.
                 */
                currentFrame: Phaser.Animations.AnimationFrame;

                /**
                 * The frame rate of playback in frames per second.
                 * The default is 24 if the `duration` property is `null`.
                 */
                frameRate: number;

                /**
                 * How long the animation should play for.
                 * If the `frameRate` property has been set then it overrides this value,
                 * otherwise frameRate is derived from `duration`.
                 */
                duration: number;

                /**
                 * ms per frame, not including frame specific modifiers that may be present in the Animation data.
                 */
                msPerFrame: number;

                /**
                 * Skip frames if the time lags, or always advanced anyway?
                 */
                skipMissedFrames: boolean;

                /**
                 * Will the playhead move forwards (`true`) or in reverse (`false`)
                 */
                forward: boolean;

                /**
                 * Internal time overflow accumulator.
                 */
                accumulator: number;

                /**
                 * The time point at which the next animation frame will change.
                 */
                nextTick: number;

                /**
                 * An internal counter keeping track of how many repeats are left to play.
                 */
                repeatCounter: number;

                /**
                 * An internal flag keeping track of pending repeats.
                 */
                pendingRepeat: boolean;

                /**
                 * Sets the amount of time, in seconds that the animation will be delayed before starting playback.
                 * @param value The amount of time, in seconds, to wait before starting playback.
                 */
                delay(value: number): Phaser.GameObjects.GameObject;

                /**
                 * [description]
                 * @param delay [description]
                 * @param key [description]
                 * @param startFrame [description]
                 */
                delayedPlay(delay: number, key: string, startFrame: integer): Phaser.GameObjects.GameObject;

                /**
                 * [description]
                 */
                getCurrentKey(): string;

                /**
                 * [description]
                 * @param key [description]
                 * @param startFrame [description] Default 0.
                 */
                load(key: string, startFrame?: integer): Phaser.GameObjects.GameObject;

                /**
                 * [description]
                 * @param atFrame [description]
                 */
                pause(atFrame?: Phaser.Animations.Animation): Phaser.GameObjects.GameObject;

                /**
                 * [description]
                 * @param value [description]
                 */
                paused(value?: boolean): boolean | Phaser.GameObjects.GameObject;

                /**
                 * [description]
                 * @param key [description]
                 * @param ignoreIfPlaying [description] Default false.
                 * @param startFrame [description] Default 0.
                 */
                play(key: string, ignoreIfPlaying?: boolean, startFrame?: integer): Phaser.GameObjects.GameObject;

                /**
                 * Value between 0 and 1. How far this animation is through, ignoring repeats and yoyos.
                 * If the animation has a non-zero repeat defined, progress and totalProgress will be different
                 * because progress doesn't include any repeats or repeatDelays whereas totalProgress does.
                 * @param value [description]
                 */
                progress(value?: number): number | Phaser.GameObjects.GameObject;

                /**
                 * [description]
                 * @param event [description]
                 */
                remove(event?: Phaser.Animations.Animation): void;

                /**
                 * Gets or sets the number of times that the animation should repeat
                 * after its first iteration. For example, if repeat is 1, the animation will
                 * play a total of twice (the initial play plus 1 repeat).
                 * To repeat indefinitely, use -1. repeat should always be an integer.
                 * @param value [description]
                 */
                repeat(value: number): number | Phaser.GameObjects.GameObject;

                /**
                 * Gets or sets the amount of time in seconds between repeats.
                 * For example, if repeat is 2 and repeatDelay is 1, the animation will play initially,
                 * then wait for 1 second before it repeats, then play again, then wait 1 second again
                 * before doing its final repeat.
                 * @param value [description]
                 */
                repeatDelay(value?: number): number | Phaser.GameObjects.GameObject;

                /**
                 * [description]
                 * @param includeDelay [description] Default false.
                 */
                restart(includeDelay?: boolean): Phaser.GameObjects.GameObject;

                /**
                 * [description]
                 * @param fromFrame [description]
                 */
                resume(fromFrame: Phaser.Animations.AnimationFrame): Phaser.GameObjects.GameObject;

                /**
                 * [description]
                 * @param dispatchCallbacks [description] Default false.
                 */
                stop(dispatchCallbacks?: boolean): Phaser.GameObjects.GameObject;

                /**
                 * Scale the time (make it go faster / slower)
                 * Factor that's used to scale time where 1 = normal speed (the default), 0.5 = half speed, 2 = double speed, etc.
                 * @param value [description]
                 */
                timeScale(value?: number): number | Phaser.GameObjects.GameObject;

                /**
                 * [description]
                 */
                totalFrames(): number;

                /**
                 * [description]
                 */
                totalProgres(): void;

                /**
                 * [description]
                 * @param timestamp [description]
                 * @param delta The delta time, in ms, elapsed since the last frame.
                 */
                update(timestamp: number, delta: number): void;

                /**
                 * [description]
                 * @param animationFrame [description]
                 */
                updateFrame(animationFrame: Phaser.Animations.AnimationFrame): void;

                /**
                 * [description]
                 * @param value [description]
                 */
                yoyo(value?: boolean): boolean | Phaser.GameObjects.GameObject;

                /**
                 * [description]
                 */
                destroy(): void;

            }

            /**
             * Provides methods used for setting the blend mode of a Game Object.
             * Should be applied as a mixin and not used directly.
             */
            interface BlendMode {
                /**
                 * Sets the Blend Mode being used by this Game Object.
                 * 
                 * This can be a const, such as `Phaser.BlendModes.SCREEN`, or an integer, such as 4 (for Overlay)
                 * 
                 * Under WebGL only the following Blend Modes are available:
                 * 
                 * * ADD
                 * * MULTIPLY
                 * * SCREEN
                 * 
                 * Canvas has more available depending on browser support.
                 * 
                 * You can also create your own custom Blend Modes in WebGL.
                 * 
                 * Blend modes have different effects under Canvas and WebGL, and from browser to browser, depending
                 * on support. Blend Modes also cause a WebGL batch flush should it encounter a new blend mode. For these
                 * reasons try to be careful about the construction of your Scene and the frequency of which blend modes
                 * are used.
                 */
                blendMode: Phaser.BlendModes | string;
                /**
                 * Sets the Blend Mode being used by this Game Object.
                 * 
                 * This can be a const, such as `Phaser.BlendModes.SCREEN`, or an integer, such as 4 (for Overlay)
                 * 
                 * Under WebGL only the following Blend Modes are available:
                 * 
                 * * ADD
                 * * MULTIPLY
                 * * SCREEN
                 * 
                 * Canvas has more available depending on browser support.
                 * 
                 * You can also create your own custom Blend Modes in WebGL.
                 * 
                 * Blend modes have different effects under Canvas and WebGL, and from browser to browser, depending
                 * on support. Blend Modes also cause a WebGL batch flush should it encounter a new blend mode. For these
                 * reasons try to be careful about the construction of your Scene and the frequency of which blend modes
                 * are used.
                 * @param value The BlendMode value. Either a string or a CONST.
                 */
                setBlendMode(value: string | Phaser.BlendModes): Phaser.GameObjects.GameObject;
            }

            /**
             * Provides methods used for calculating and setting the size of a non-Frame based Game Object.
             * Should be applied as a mixin and not used directly.
             */
            interface ComputedSize {
                /**
                 * The native (un-scaled) width of this Game Object.
                 */
                width: number;
                /**
                 * The native (un-scaled) height of this Game Object.
                 */
                height: number;
                /**
                 * The displayed width of this Game Object.
                 * This value takes into account the scale factor.
                 */
                displayWidth: number;
                /**
                 * The displayed height of this Game Object.
                 * This value takes into account the scale factor.
                 */
                displayHeight: number;
                /**
                 * Sets the size of this Game Object.
                 * @param width The width of this Game Object.
                 * @param height The height of this Game Object.
                 */
                setSize(width: number, height: number): Phaser.GameObjects.GameObject;
                /**
                 * Sets the display size of this Game Object.
                 * Calling this will adjust the scale.
                 * @param width The width of this Game Object.
                 * @param height The height of this Game Object.
                 */
                setDisplaySize(width: number, height: number): Phaser.GameObjects.GameObject;
            }

            /**
             * Provides methods used for setting the depth of a Game Object.
             * Should be applied as a mixin and not used directly.
             */
            interface Depth {
                /**
                 * The depth of this Game Object within the Scene.
                 * 
                 * The depth is also known as the 'z-index' in some environments, and allows you to change the rendering order
                 * of Game Objects, without actually moving their position in the display list.
                 * 
                 * The depth starts from zero (the default value) and increases from that point. A Game Object with a higher depth
                 * value will always render in front of one with a lower value.
                 * 
                 * Setting the depth will queue a depth sort event within the Scene.
                 */
                depth: number;
                /**
                 * The depth of this Game Object within the Scene.
                 * 
                 * The depth is also known as the 'z-index' in some environments, and allows you to change the rendering order
                 * of Game Objects, without actually moving their position in the display list.
                 * 
                 * The depth starts from zero (the default value) and increases from that point. A Game Object with a higher depth
                 * value will always render in front of one with a lower value.
                 * 
                 * Setting the depth will queue a depth sort event within the Scene.
                 * @param value The depth of this Game Object.
                 */
                setDepth(value: integer): Phaser.GameObjects.GameObject;
            }

            /**
             * Provides methods used for visually flipping a Game Object.
             * Should be applied as a mixin and not used directly.
             */
            interface Flip {
                /**
                 * The horizontally flipped state of the Game Object.
                 * A Game Object that is flipped horizontally will render inversed on the horizontal axis.
                 * Flipping always takes place from the middle of the texture and does not impact the scale value.
                 */
                flipX: boolean;
                /**
                 * The vertically flipped state of the Game Object.
                 * A Game Object that is flipped vertically will render inversed on the vertical axis (i.e. upside down)
                 * Flipping always takes place from the middle of the texture and does not impact the scale value.
                 */
                flipY: boolean;
                /**
                 * Toggles the horizontal flipped state of this Game Object.
                 */
                toggleFlipX(): Phaser.GameObjects.GameObject;
                /**
                 * Toggles the vertical flipped state of this Game Object.
                 */
                toggleFlipY(): Phaser.GameObjects.GameObject;
                /**
                 * Sets the horizontal flipped state of this Game Object.
                 * @param value The flipped state. `false` for no flip, or `true` to be flipped.
                 */
                setFlipX(value: boolean): Phaser.GameObjects.GameObject;
                /**
                 * Sets the vertical flipped state of this Game Object.
                 * @param value The flipped state. `false` for no flip, or `true` to be flipped.
                 */
                setFlipY(value: boolean): Phaser.GameObjects.GameObject;
                /**
                 * Sets the horizontal and vertical flipped state of this Game Object.
                 * @param x The horizontal flipped state. `false` for no flip, or `true` to be flipped.
                 * @param y The horizontal flipped state. `false` for no flip, or `true` to be flipped.
                 */
                setFlip(x: boolean, y: boolean): Phaser.GameObjects.GameObject;
                /**
                 * Resets the horizontal and vertical flipped state of this Game Object back to their default un-flipped state.
                 */
                resetFlip(): Phaser.GameObjects.GameObject;
            }

            /**
             * Provides methods used for obtaining the bounds of a Game Object.
             * Should be applied as a mixin and not used directly.
             */
            interface GetBounds {
                /**
                 * Gets the center coordinate of this Game Object, regardless of origin.
                 * @param output An object to store the values in. If not provided a new Vector2 will be created.
                 */
                getCenter(output?: O): O;
                /**
                 * Gets the top-left corner coordinate of this Game Object, regardless of origin.
                 * @param output An object to store the values in. If not provided a new Vector2 will be created.
                 */
                getTopLeft(output?: O): O;
                /**
                 * Gets the top-right corner coordinate of this Game Object, regardless of origin.
                 * @param output An object to store the values in. If not provided a new Vector2 will be created.
                 */
                getTopRight(output?: O): O;
                /**
                 * Gets the bottom-left corner coordinate of this Game Object, regardless of origin.
                 * @param output An object to store the values in. If not provided a new Vector2 will be created.
                 */
                getBottomLeft(output?: O): O;
                /**
                 * Gets the bottom-right corner coordinate of this Game Object, regardless of origin.
                 * @param output An object to store the values in. If not provided a new Vector2 will be created.
                 */
                getBottomRight(output?: O): O;
                /**
                 * Gets the bounds of this Game Object, regardless of origin.
                 * The values are stored and returned in a Rectangle, or Rectangle-like, object.
                 * @param output An object to store the values in. If not provided a new Rectangle will be created.
                 */
                getBounds(output?: O): O;
            }

            /**
             * Provides methods used for getting and setting the transform values of a Game Object.
             * Should be applied as a mixin and not used directly.
             */
            interface MatrixStack {
                /**
                 * [description]
                 */
                initMatrixStack(): Phaser.GameObjects.GameObject;
                /**
                 * [description]
                 */
                save(): Phaser.GameObjects.GameObject;
                /**
                 * [description]
                 */
                restore(): Phaser.GameObjects.GameObject;
                /**
                 * [description]
                 */
                loadIdentity(): Phaser.GameObjects.GameObject;
                /**
                 * [description]
                 * @param a [description]
                 * @param b [description]
                 * @param c [description]
                 * @param d [description]
                 * @param tx [description]
                 * @param ty [description]
                 */
                transform(a: number, b: number, c: number, d: number, tx: number, ty: number): Phaser.GameObjects.GameObject;
                /**
                 * [description]
                 * @param a [description]
                 * @param b [description]
                 * @param c [description]
                 * @param d [description]
                 * @param tx [description]
                 * @param ty [description]
                 */
                setTransform(a: number, b: number, c: number, d: number, tx: number, ty: number): Phaser.GameObjects.GameObject;
                /**
                 * [description]
                 * @param x [description]
                 * @param y [description]
                 */
                translate(x: number, y: number): Phaser.GameObjects.GameObject;
                /**
                 * [description]
                 * @param x [description]
                 * @param y [description]
                 */
                scale(x: number, y: number): Phaser.GameObjects.GameObject;
                /**
                 * [description]
                 * @param t The angle of rotation, in radians.
                 */
                rotate(t: number): Phaser.GameObjects.GameObject;
            }

            /**
             * Provides methods used for getting and setting the origin of a Game Object.
             * Values are normalized, given in the range 0 to 1.
             * Display values contain the calculated pixel values.
             * Should be applied as a mixin and not used directly.
             */
            interface Origin {
                /**
                 * The horizontal origin of this Game Object.
                 * The origin maps the relationship between the size and position of the Game Object.
                 * The default value is 0.5, meaning all Game Objects are positioned based on their center.
                 * Setting the value to 0 means the position now relates to the left of the Game Object.
                 */
                originX: number;
                /**
                 * The vertical origin of this Game Object.
                 * The origin maps the relationship between the size and position of the Game Object.
                 * The default value is 0.5, meaning all Game Objects are positioned based on their center.
                 * Setting the value to 0 means the position now relates to the top of the Game Object.
                 */
                originY: number;
                /**
                 * The horizontal display origin of this Game Object.
                 * The origin is a normalized value between 0 and 1.
                 * The displayOrigin is a pixel value, based on the size of the Game Object combined with the origin.
                 */
                displayOriginX: number;
                /**
                 * The vertical display origin of this Game Object.
                 * The origin is a normalized value between 0 and 1.
                 * The displayOrigin is a pixel value, based on the size of the Game Object combined with the origin.
                 */
                displayOriginY: number;
                /**
                 * Sets the origin of this Game Object.
                 * 
                 * The values are given in the range 0 to 1.
                 * @param x The horizontal origin value. Default 0.5.
                 * @param y The vertical origin value. If not defined it will be set to the value of `x`. Default x.
                 */
                setOrigin(x?: number, y?: number): Phaser.GameObjects.GameObject;
                /**
                 * Sets the origin of this Game Object based on the Pivot values in its Frame.
                 */
                setOriginFromFrame(): Phaser.GameObjects.GameObject;
                /**
                 * Sets the display origin of this Game Object.
                 * The difference between this and setting the origin is that you can use pixel values for setting the display origin.
                 * @param x The horizontal display origin value. Default 0.
                 * @param y The vertical display origin value. If not defined it will be set to the value of `x`. Default x.
                 */
                setDisplayOrigin(x?: number, y?: number): Phaser.GameObjects.GameObject;
                /**
                 * Updates the Display Origin cached values internally stored on this Game Object.
                 * You don't usually call this directly, but it is exposed for edge-cases where you may.
                 */
                updateDisplayOrigin(): Phaser.GameObjects.GameObject;
            }

            /**
             * Provides methods used for setting the WebGL rendering pipeline of a Game Object.
             */
            interface Pipeline {
                /**
                 * [description]
                 */
                defaultPipeline: Phaser.Renderer.WebGL.WebGLPipeline;
                /**
                 * [description]
                 */
                pipeline: Phaser.Renderer.WebGL.WebGLPipeline;
                /**
                 * Sets the initial WebGL Pipeline of this Game Object.
                 * This should only be called during the instantiation of the Game Object.
                 * @param pipelineName The name of the pipeline to set on this Game Object.
                 */
                initPipeline(pipelineName: string): boolean;
                /**
                 * Sets the active WebGL Pipeline of this Game Object.
                 * @param pipelineName The name of the pipeline to set on this Game Object.
                 */
                setPipeline(pipelineName: string): boolean;
                /**
                 * Resets the WebGL Pipeline of this Game Object back to the default it was created with.
                 */
                resetPipeline(): boolean;
                /**
                 * Gets the name of the WebGL Pipeline this Game Object is currently using.
                 */
                getPipelineName(): string;
            }

            /**
             * Provides methods used for getting and setting the scale of a Game Object.
             */
            interface ScaleMode {
                /**
                 * The Scale Mode being used by this Game Object.
                 * Can be either `ScaleModes.LINEAR` or `ScaleModes.NEAREST`.
                 */
                scaleMode: Phaser.ScaleModes;
                /**
                 * Sets the Scale Mode being used by this Game Object.
                 * Can be either `ScaleModes.LINEAR` or `ScaleModes.NEAREST`.
                 * @param value The Scale Mode to be used by this Game Object.
                 */
                setScaleMode(value: Phaser.ScaleModes): Phaser.GameObjects.GameObject;
            }

            /**
             * Provides methods used for getting and setting the Scroll Factor of a Game Object.
             */
            interface ScrollFactor {
                /**
                 * The horizontal scroll factor of this Game Object.
                 * 
                 * The scroll factor controls the influence of the movement of a Camera upon this Game Object.
                 * 
                 * When a camera scrolls it will change the location at which this Game Object is rendered on-screen.
                 * It does not change the Game Objects actual position values.
                 * 
                 * A value of 1 means it will move exactly in sync with a camera.
                 * A value of 0 means it will not move at all, even if the camera moves.
                 * Other values control the degree to which the camera movement is mapped to this Game Object.
                 */
                scrollFactorX: number;
                /**
                 * The vertical scroll factor of this Game Object.
                 * 
                 * The scroll factor controls the influence of the movement of a Camera upon this Game Object.
                 * 
                 * When a camera scrolls it will change the location at which this Game Object is rendered on-screen.
                 * It does not change the Game Objects actual position values.
                 * 
                 * A value of 1 means it will move exactly in sync with a camera.
                 * A value of 0 means it will not move at all, even if the camera moves.
                 * Other values control the degree to which the camera movement is mapped to this Game Object.
                 */
                scrollFactorY: number;
                /**
                 * Sets the scroll factor of this Game Object.
                 * 
                 * The scroll factor controls the influence of the movement of a Camera upon this Game Object.
                 * 
                 * When a camera scrolls it will change the location at which this Game Object is rendered on-screen.
                 * It does not change the Game Objects actual position values.
                 * 
                 * A value of 1 means it will move exactly in sync with a camera.
                 * A value of 0 means it will not move at all, even if the camera moves.
                 * Other values control the degree to which the camera movement is mapped to this Game Object.
                 * @param x The horizontal scroll factor of this Game Object.
                 * @param y The vertical scroll factor of this Game Object. If not set it will use the `x` value. Default x.
                 */
                setScrollFactor(x: number, y?: number): Phaser.GameObjects.GameObject;
            }

            /**
             * Provides methods used for getting and setting the size of a Game Object.
             */
            interface Size {
                /**
                 * The native (un-scaled) width of this Game Object.
                 */
                width: number;
                /**
                 * The native (un-scaled) height of this Game Object.
                 */
                height: number;
                /**
                 * The displayed width of this Game Object.
                 * This value takes into account the scale factor.
                 */
                displayWidth: number;
                /**
                 * The displayed height of this Game Object.
                 * This value takes into account the scale factor.
                 */
                displayHeight: number;
                /**
                 * Sets the size of this Game Object to be that of the given Frame.
                 * @param frame The frame to base the size of this Game Object on.
                 */
                setSizeToFrame(frame: Phaser.Textures.Frame): Phaser.GameObjects.GameObject;
                /**
                 * Sets the size of this Game Object.
                 * @param width The width of this Game Object.
                 * @param height The height of this Game Object.
                 */
                setSize(width: number, height: number): Phaser.GameObjects.GameObject;
                /**
                 * Sets the display size of this Game Object.
                 * Calling this will adjust the scale.
                 * @param width The width of this Game Object.
                 * @param height The height of this Game Object.
                 */
                setDisplaySize(width: number, height: number): Phaser.GameObjects.GameObject;
            }

            /**
             * Provides methods used for getting and setting the texture of a Game Object.
             */
            interface Texture {
                /**
                 * The Texture this Game Object is using to render with.
                 */
                texture: Phaser.Textures.Texture;
                /**
                 * The Texture Frame this Game Object is using to render with.
                 */
                frame: Phaser.Textures.Frame;
                /**
                 * Sets the texture and frame this Game Object will use to render with.
                 * 
                 * Textures are referenced by their string-based keys, as stored in the Texture Manager.
                 * @param key The key of the texture to be used, as stored in the Texture Manager.
                 * @param frame The name or index of the frame within the Texture.
                 */
                setTexture(key: string, frame?: string | integer): Phaser.GameObjects.GameObject;
                /**
                 * Sets the frame this Game Object will use to render with.
                 * 
                 * The Frame has to belong to the current Texture being used.
                 * 
                 * It can be either a string or an index.
                 * 
                 * Calling `setFrame` will modify the `width` and `height` properties of your Game Object.
                 * It will also change the `origin` if the Frame has a custom pivot point, as exported from packages like Texture Packer.
                 * @param frame The name or index of the frame within the Texture.
                 * @param updateSize Should this call adjust the size of the Game Object? Default true.
                 * @param updateOrigin Should this call adjust the origin of the Game Object? Default true.
                 */
                setFrame(frame: string | integer, updateSize?: boolean, updateOrigin?: boolean): Phaser.GameObjects.GameObject;
            }

            /**
             * Provides methods used for setting the tint of a Game Object.
             * Should be applied as a mixin and not used directly.
             */
            interface Tint {
                /**
                 * Clears all tint values associated with this Game Object.
                 * Immediately sets the alpha levels back to 0xffffff (no tint)
                 */
                clearTint(): Phaser.GameObjects.GameObject;
                /**
                 * Sets the tint values for this Game Object.
                 * @param topLeft The tint being applied to the top-left of the Game Object. If not other values are given this value is applied evenly, tinting the whole Game Object. Default 0xffffff.
                 * @param topRight The tint being applied to the top-right of the Game Object.
                 * @param bottomLeft The tint being applied to the bottom-left of the Game Object.
                 * @param bottomRight The tint being applied to the bottom-right of the Game Object.
                 */
                setTint(topLeft?: integer, topRight?: integer, bottomLeft?: integer, bottomRight?: integer): Phaser.GameObjects.GameObject;
                /**
                 * The tint value being applied to the top-left of the Game Object.
                 * This value is interpolated from the corner to the center of the Game Object.
                 */
                tintTopLeft: integer;
                /**
                 * The tint value being applied to the top-right of the Game Object.
                 * This value is interpolated from the corner to the center of the Game Object.
                 */
                tintTopRight: integer;
                /**
                 * The tint value being applied to the bottom-left of the Game Object.
                 * This value is interpolated from the corner to the center of the Game Object.
                 */
                tintBottomLeft: integer;
                /**
                 * The tint value being applied to the bottom-right of the Game Object.
                 * This value is interpolated from the corner to the center of the Game Object.
                 */
                tintBottomRight: integer;
                /**
                 * The tint value being applied to the whole of the Game Object.
                 */
                tint: integer;
            }

            /**
             * [description]
             * @param gameObject [description]
             */
            function ToJSON(gameObject: Phaser.GameObjects.GameObject): JSONGameObject;

            /**
             * Provides methods used for getting and setting the position, scale and rotation of a Game Object.
             */
            interface Transform {
                /**
                 * The x position of this Game Object.
                 */
                x: number;
                /**
                 * The y position of this Game Object.
                 */
                y: number;
                /**
                 * The z position of this Game Object.
                 * Note: Do not use this value to set the z-index, instead see the `depth` property.
                 */
                z: number;
                /**
                 * The w position of this Game Object.
                 */
                w: number;
                /**
                 * The horizontal scale of this Game Object.
                 */
                scaleX: number;
                /**
                 * The vertical scale of this Game Object.
                 */
                scaleY: number;
                /**
                 * The angle of this Game Object as expressed in degrees.
                 * 
                 * Where 0 is to the right, 90 is down, 180 is left.
                 * 
                 * If you prefer to work in radians, see the `rotation` property instead.
                 */
                angle: integer;
                /**
                 * The angle of this Game Object in radians.
                 * 
                 * If you prefer to work in degrees, see the `angle` property instead.
                 */
                rotation: number;
                /**
                 * Sets the position of this Game Object.
                 * @param x The x position of this Game Object. Default 0.
                 * @param y The y position of this Game Object. If not set it will use the `x` value.
                 * @param z The z position of this Game Object. Default 0.
                 * @param w The w position of this Game Object. Default 0.
                 */
                setPosition(x?: number, y?: number, z?: number, w?: number): Phaser.GameObjects.GameObject;
                /**
                 * Sets the rotation of this Game Object.
                 * @param radians The rotation of this Game Object, in radians. Default 0.
                 */
                setRotation(radians?: number): Phaser.GameObjects.GameObject;
                /**
                 * Sets the angle of this Game Object.
                 * @param degrees The rotation of this Game Object, in degrees. Default 0.
                 */
                setAngle(degrees?: number): Phaser.GameObjects.GameObject;
                /**
                 * Sets the scale of this Game Object.
                 * @param x The horizontal scale of this Game Object.
                 * @param y The vertical scale of this Game Object. If not set it will use the `x` value. Default x.
                 */
                setScale(x: number, y?: number): Phaser.GameObjects.GameObject;
                /**
                 * Sets the x position of this Game Object.
                 * @param value The x position of this Game Object. Default 0.
                 */
                setX(value?: number): Phaser.GameObjects.GameObject;
                /**
                 * Sets the y position of this Game Object.
                 * @param value The y position of this Game Object. Default 0.
                 */
                setY(value?: number): Phaser.GameObjects.GameObject;
                /**
                 * Sets the z position of this Game Object.
                 * @param value The z position of this Game Object. Default 0.
                 */
                setZ(value?: number): Phaser.GameObjects.GameObject;
                /**
                 * Sets the w position of this Game Object.
                 * @param value The w position of this Game Object. Default 0.
                 */
                setW(value?: number): Phaser.GameObjects.GameObject;
            }

            /**
             * [description]
             */
            class TransformMatrix {
                /**
                 * 
                 * @param a [description] Default 1.
                 * @param b [description] Default 0.
                 * @param c [description] Default 0.
                 * @param d [description] Default 1.
                 * @param tx [description] Default 0.
                 * @param ty [description] Default 0.
                 */
                constructor(a?: number, b?: number, c?: number, d?: number, tx?: number, ty?: number);

                /**
                 * [description]
                 */
                matrix: Float32Array;

                /**
                 * [description]
                 */
                decomposedMatrix: object;

                /**
                 * [description]
                 */
                loadIdentity(): Phaser.GameObjects.Components.TransformMatrix;

                /**
                 * [description]
                 * @param x [description]
                 * @param y [description]
                 */
                translate(x: number, y: number): Phaser.GameObjects.Components.TransformMatrix;

                /**
                 * [description]
                 * @param x [description]
                 * @param y [description]
                 */
                scale(x: number, y: number): Phaser.GameObjects.Components.TransformMatrix;

                /**
                 * [description]
                 * @param radian [description]
                 */
                rotate(radian: number): Phaser.GameObjects.Components.TransformMatrix;

                /**
                 * [description]
                 * @param rhs [description]
                 */
                multiply(rhs: Phaser.GameObjects.Components.TransformMatrix): Phaser.GameObjects.Components.TransformMatrix;

                /**
                 * [description]
                 * @param a [description]
                 * @param b [description]
                 * @param c [description]
                 * @param d [description]
                 * @param tx [description]
                 * @param ty [description]
                 */
                transform(a: number, b: number, c: number, d: number, tx: number, ty: number): Phaser.GameObjects.Components.TransformMatrix;

                /**
                 * [description]
                 * @param x [description]
                 * @param y [description]
                 * @param point [description]
                 */
                transformPoint(x: number, y: number, point: Phaser.Geom.Point | Phaser.Math.Vector2 | object): Phaser.Geom.Point | Phaser.Math.Vector2 | object;

                /**
                 * [description]
                 */
                invert(): Phaser.GameObjects.Components.TransformMatrix;

                /**
                 * [description]
                 * @param a [description]
                 * @param b [description]
                 * @param c [description]
                 * @param d [description]
                 * @param tx [description]
                 * @param ty [description]
                 */
                setTransform(a: number, b: number, c: number, d: number, tx: number, ty: number): Phaser.GameObjects.Components.TransformMatrix;

                /**
                 * [description]
                 */
                decomposeMatrix(): object;

                /**
                 * Identity + Translate + Rotate + Scale
                 * @param x [description]
                 * @param y [description]
                 * @param rotation [description]
                 * @param scaleX [description]
                 * @param scaleY [description]
                 */
                applyITRS(x: number, y: number, rotation: number, scaleX: number, scaleY: number): Phaser.GameObjects.Components.TransformMatrix;

            }

            /**
             * Provides methods used for setting the visibility of a Game Object.
             * Should be applied as a mixin and not used directly.
             */
            interface Visible {
                /**
                 * The visible state of the Game Object.
                 * 
                 * An invisible Game Object will skip rendering, but will still process update logic.
                 */
                visible: boolean;
                /**
                 * Sets the visibility of this Game Object.
                 * 
                 * An invisible Game Object will skip rendering, but will still process update logic.
                 * @param value The visible state of the Game Object.
                 */
                setVisible(value: boolean): Phaser.GameObjects.GameObject;
            }

            namespace TextStyle {
                /**
                 * [description]
                 * @param style [description]
                 * @param updateText [description] Default true.
                 */
                function setStyle(style: CSSStyleRule, updateText?: boolean): Phaser.GameObjects.Text;

                /**
                 * [description]
                 * @param canvas [description]
                 * @param context [description]
                 */
                function syncFont(canvas: HTMLCanvasElement, context: CanvasRenderingContext2D): void;

                /**
                 * [description]
                 * @param canvas [description]
                 * @param context [description]
                 */
                function syncStyle(canvas: HTMLCanvasElement, context: CanvasRenderingContext2D): void;

                /**
                 * [description]
                 * @param context [description]
                 * @param enabled [description]
                 */
                function syncShadow(context: CanvasRenderingContext2D, enabled: boolean): void;

                /**
                 * [description]
                 * @param recalculateMetrics [description]
                 */
                function update(recalculateMetrics: boolean): Phaser.GameObjects.Text;

                /**
                 * [description]
                 * @param font [description]
                 */
                function setFont(font: string | object): Phaser.GameObjects.Text;

                /**
                 * [description]
                 * @param family [description]
                 */
                function setFontFamily(family: string): Phaser.GameObjects.Text;

                /**
                 * [description]
                 * @param style [description]
                 */
                function setFontStyle(style: string): Phaser.GameObjects.Text;

                /**
                 * [description]
                 * @param size [description]
                 */
                function setFontSize(size: number | string): Phaser.GameObjects.Text;

                /**
                 * [description]
                 * @param string [description]
                 */
                function setTestString(string: string): Phaser.GameObjects.Text;

                /**
                 * [description]
                 * @param width [description]
                 * @param height [description]
                 */
                function setFixedSize(width: number, height: number): Phaser.GameObjects.Text;

                /**
                 * [description]
                 * @param color [description]
                 */
                function setBackgroundColor(color: string): Phaser.GameObjects.Text;

                /**
                 * [description]
                 * @param color [description]
                 */
                function setFill(color: string): Phaser.GameObjects.Text;

                /**
                 * [description]
                 * @param color [description]
                 */
                function setColor(color: string): Phaser.GameObjects.Text;

                /**
                 * [description]
                 * @param color [description]
                 * @param thickness [description]
                 */
                function setStroke(color: string, thickness: number): Phaser.GameObjects.Text;

                /**
                 * [description]
                 * @param x [description] Default 0.
                 * @param y [description] Default 0.
                 * @param color [description] Default '#000'.
                 * @param blur [description] Default 0.
                 * @param shadowStroke [description] Default false.
                 * @param shadowFill [description] Default true.
                 */
                function setShadow(x?: number, y?: number, color?: string, blur?: number, shadowStroke?: boolean, shadowFill?: boolean): Phaser.GameObjects.Text;

                /**
                 * [description]
                 * @param x [description] Default 0.
                 * @param y [description] Default 0.
                 */
                function setShadowOffset(x?: number, y?: number): Phaser.GameObjects.Text;

                /**
                 * [description]
                 * @param color [description] Default '#000'.
                 */
                function setShadowColor(color?: string): Phaser.GameObjects.Text;

                /**
                 * [description]
                 * @param blur [description] Default 0.
                 */
                function setShadowBlur(blur?: number): Phaser.GameObjects.Text;

                /**
                 * [description]
                 * @param enabled [description]
                 */
                function setShadowStroke(enabled: boolean): Phaser.GameObjects.Text;

                /**
                 * [description]
                 * @param enabled [description]
                 */
                function setShadowFill(enabled: boolean): Phaser.GameObjects.Text;

                /**
                 * Set the width (in pixels) to use for wrapping lines. Pass in null to remove wrapping by width.
                 * @param width The maximum width of a line in pixels. Set to null to remove wrapping.
                 * @param useAdvancedWrap Whether or not to use the advanced wrapping
                 * algorithm. If true, spaces are collapsed and whitespace is trimmed from lines. If false,
                 * spaces and whitespace are left as is. Default false.
                 */
                function setWordWrapWidth(width: number, useAdvancedWrap?: boolean): Phaser.GameObjects.Text;

                /**
                 * Set a custom callback for wrapping lines. Pass in null to remove wrapping by callback.
                 * @param callback A custom function that will be responsible for wrapping the
                 * text. It will receive two arguments: text (the string to wrap), textObject (this Text
                 * instance). It should return the wrapped lines either as an array of lines or as a string with
                 * newline characters in place to indicate where breaks should happen.
                 * @param scope The scope that will be applied when the callback is invoked. Default null.
                 */
                function setWordWrapCallback(callback: TextStyleWordWrapCallback, scope?: object): Phaser.GameObjects.Text;

                /**
                 * [description]
                 * @param align [description]
                 */
                function setAlign(align: string): Phaser.GameObjects.Text;

                /**
                 * [description]
                 * @param max [description] Default 0.
                 */
                function setMaxLines(max?: integer): Phaser.GameObjects.Text;

                /**
                 * [description]
                 */
                function getTextMetrics(): object;

                /**
                 * [description]
                 */
                function toJSON(): object;

                /**
                 * [description]
                 */
                function destroy(): void;

            }

            class TextStyle {
                /**
                 * The Text object that this TextStyle is styling.
                 */
                parent: Phaser.GameObjects.Text;

                /**
                 * [description]
                 */
                fontFamily: string;

                /**
                 * [description]
                 */
                fontSize: string;

                /**
                 * [description]
                 */
                fontStyle: string;

                /**
                 * [description]
                 */
                backgroundColor: string;

                /**
                 * [description]
                 */
                color: string;

                /**
                 * [description]
                 */
                stroke: string;

                /**
                 * [description]
                 */
                strokeThickness: number;

                /**
                 * [description]
                 */
                shadowOffsetX: number;

                /**
                 * [description]
                 */
                shadowOffsetY: number;

                /**
                 * [description]
                 */
                shadowColor: string;

                /**
                 * [description]
                 */
                shadowBlur: number;

                /**
                 * [description]
                 */
                shadowStroke: boolean;

                /**
                 * [description]
                 */
                shadowFill: boolean;

                /**
                 * [description]
                 */
                align: string;

                /**
                 * [description]
                 */
                maxLines: integer;

                /**
                 * [description]
                 */
                fixedWidth: number;

                /**
                 * [description]
                 */
                fixedHeight: number;

                /**
                 * [description]
                 */
                rtl: boolean;

                /**
                 * [description]
                 */
                testString: string;

                /**
                 * The amount of horizontal padding adding to the width of the text when calculating the font metrics.
                 */
                baselineX: number;

                /**
                 * The amount of vertical padding adding to the width of the text when calculating the font metrics.
                 */
                baselineY: number;

            }

        }

        /**
         * [description]
         */
        class DisplayList {
            /**
             * 
             * @param scene [description]
             */
            constructor(scene: Phaser.Scene);

            /**
             * [description]
             */
            sortChildrenFlag: boolean;

            /**
             * [description]
             */
            scene: Phaser.Scene;

            /**
             * [description]
             */
            systems: Phaser.Scenes.Systems;

            /**
             * [description]
             */
            boot(): void;

            /**
             * Force a sort of the display list on the next call to depthSort.
             */
            queueDepthSort(): void;

            /**
             * Immediately sorts the display list if the flag is set.
             */
            depthSort(): void;

            /**
             * [description]
             * @param childA [description]
             * @param childB [description]
             */
            sortByDepth(childA: Phaser.GameObjects.GameObject, childB: Phaser.GameObjects.GameObject): integer;

            /**
             * Given an array of Game Objects, sort the array and return it,
             * so that the objects are in index order with the lowest at the bottom.
             * @param gameObjects [description]
             */
            sortGameObjects(gameObjects: Phaser.GameObjects.GameObject[]): any[];

            /**
             * Note that the given array is sorted in place, even though it isn't returned directly it will still be updated.
             * @param gameObjects [description]
             */
            getTopGameObject(gameObjects: Phaser.GameObjects.GameObject[]): Phaser.GameObjects.GameObject;

        }

        /**
         * The base class that all Game Objects extend.
         * 
         * You don't create GameObjects directly and they cannot be added to the display list.
         * 
         * Instead, use them as the base for your own custom classes.
         */
        class GameObject extends Phaser.Events.EventEmitter {
            /**
             * 
             * @param scene The Scene to which this Game Object belongs.
             * @param type A textual representation of the type of Game Object, i.e. `sprite`.
             */
            constructor(scene: Phaser.Scene, type: string);

            /**
             * The Scene to which this Game Object belongs.
             * Game Objects can only belong to one Scene.
             */
            protected scene: Phaser.Scene;

            /**
             * A textual representation of this Game Object, i.e. `sprite`.
             * Used internally by Phaser but is available for your own custom classes to populate.
             */
            type: string;

            /**
             * The name of this Game Object.
             * Empty by default and never populated by Phaser, this is left for developers to use.
             */
            name: string;

            /**
             * The active state of this Game Object.
             * A Game Object with an active state of `true` is processed by the Scenes UpdateList, if added to it.
             * An active object is one which is having its logic and internal systems updated.
             */
            active: boolean;

            /**
             * The Tab Index of the Game Object.
             * Reserved for future use by plugins and the Input Manager.
             */
            tabIndex: integer;

            /**
             * A Data Manager.
             * It allows you to store, query and get key/value paired information specific to this Game Object.
             * `null` by default. Automatically created if you use `getData` or `setData` or `setDataEnabled`.
             */
            data: Phaser.Data.DataManager;

            /**
             * The flags that are compared against `RENDER_MASK` to determine if this Game Object will render or not.
             * The bits are 0001 | 0010 | 0100 | 1000 set by the components Visible, Alpha, Transform and Texture respectively.
             * If those components are not used by your custom class then you can use this bitmask as you wish.
             */
            renderFlags: integer;

            /**
             * A bitmask that controls if this Game Object is drawn by a Camera or not.
             * Not usually set directly. Instead call `Camera.ignore`.
             */
            cameraFilter: number;

            /**
             * If this Game Object is enabled for input then this property will contain an InteractiveObject instance.
             * Not usually set directly. Instead call `GameObject.setInteractive()`.
             */
            input: Phaser.Input.InteractiveObject;

            /**
             * If this Game Object is enabled for physics then this property will contain a reference to a Physics Body.
             */
            body: object;

            /**
             * Sets the `active` property of this Game Object and returns this Game Object for further chaining.
             * A Game Object with its `active` property set to `true` will be updated by the Scenes UpdateList.
             * @param value True if this Game Object should be set as active, false if not.
             */
            setActive(value: boolean): Phaser.GameObjects.GameObject;

            /**
             * Sets the `name` property of this Game Object and returns this Game Object for further chaining.
             * The `name` property is not populated by Phaser and is presented for your own use.
             * @param value The name to be given to this Game Object.
             */
            setName(value: string): Phaser.GameObjects.GameObject;

            /**
             * [description]
             */
            setDataEnabled(): Phaser.GameObjects.GameObject;

            /**
             * This is a quick chainable alias to the `DataProxy.set` method.
             * It allows you to set a key and value in this Game Objects data store.
             * @param key The key of the property to be stored.
             * @param value The value to store with the key. Can be a string, number, array or object.
             */
            setData(key: string, value: any): Phaser.GameObjects.GameObject;

            /**
             * This is a quick alias to the `DataProxy.get` method to remain consistent with `setData`.
             * @param key The key of the property to be retrieved.
             */
            getData(key: string): any;

            /**
             * Pass this Game Object to the Input Manager to enable it for Input.
             * @param shape A geometric shape that defines the hit area for the Game Object. If not specified a Rectangle will be used.
             * @param callback A callback to be invoked when the Game Object is interacted with.
             * @param dropZone Should this Game Object be treated as a drop zone target? Default false.
             */
            setInteractive(shape?: any, callback?: HitAreaCallback, dropZone?: boolean): Phaser.GameObjects.GameObject;

            /**
             * To be overridden by custom GameObjects. Allows base objects to be used in a Pool.
             */
            update(): void;

            /**
             * Returns a JSON representation of the Game Object.
             */
            toJSON(): JSONGameObject;

            /**
             * Compares the renderMask with the renderFlags to see if this Game Object will render or not.
             */
            willRender(): boolean;

            /**
             * Destroys this Game Object removing it from the Display List and Update List and
             * severing all ties to parent resources.
             * 
             * Also removes itself from the Input Manager and Physics Manager if previously enabled.
             * 
             * Use this to remove a Game Object from your game if you don't ever plan to use it again.
             * As long as no reference to it exists within your own code it should become free for
             * garbage collection by the browser.
             * 
             * If you just want to temporarily disable an object then look at using the
             * Game Object Pool instead of destroying it, as destroyed objects cannot be resurrected.
             */
            destroy(): void;

            /**
             * The bitmask that `GameObject.renderFlags` is compared against to determine if the Game Object will render or not.
             */
            static readonly RENDER_MASK: integer;

        }

        /**
         * The Game Object Creator is a Scene plugin that allows you to quickly create many common
         * 
         * types of Game Objects and return them. Unlike the Game Object Factory, they are not automatically
         * 
         * added to the Scene.
         * 
         * 
         * 
         * Game Objects directly register themselves with the Creator and inject their own creation
         * 
         * methods into the class.
         */
        class GameObjectCreator {
            /**
             * 
             * @param scene The Scene to which this Game Object Factory belongs.
             */
            constructor(scene: Phaser.Scene);

            /**
             * Creates a new Dynamic Bitmap Text Game Object and returns it.
             * 
             * Note: This method will only be available if the Dynamic Bitmap Text Game Object has been built into Phaser.
             * @param config [description]
             */
            dynamicBitmapText(config: BitmapTextConfig): Phaser.GameObjects.DynamicBitmapText;

            /**
             * Creates a new Bitmap Text Game Object and returns it.
             * 
             * Note: This method will only be available if the Bitmap Text Game Object has been built into Phaser.
             * @param config [description]
             */
            bitmapText(config: BitmapTextConfig): Phaser.GameObjects.BitmapText;

            /**
             * Creates a new Blitter Game Object and returns it.
             * 
             * Note: This method will only be available if the Blitter Game Object has been built into Phaser.
             * @param config [description]
             */
            blitter(config: object): Phaser.GameObjects.Blitter;

            /**
             * The Scene to which this Game Object Creator belongs.
             */
            protected scene: Phaser.Scene;

            /**
             * A reference to the Scene.Systems.
             */
            protected systems: Phaser.Scenes.Systems;

            /**
             * A reference to the Scene Display List.
             */
            protected displayList: Phaser.GameObjects.DisplayList;

            /**
             * A reference to the Scene Update List.
             */
            protected "updateList;": Phaser.GameObjects.UpdateList;

            /**
             * Shuts this plugin down.
             */
            shutdown(): void;

            /**
             * Destroys this plugin.
             */
            destroy(): void;

            /**
             * Creates a new Graphics Game Object and returns it.
             * 
             * Note: This method will only be available if the Graphics Game Object has been built into Phaser.
             * @param config [description]
             */
            graphics(config: object): Phaser.GameObjects.Graphics;

            /**
             * Creates a new Group Game Object and returns it.
             * 
             * Note: This method will only be available if the Group Game Object has been built into Phaser.
             * @param config [description]
             */
            group(config: GroupConfig): Phaser.GameObjects.Group;

            /**
             * Creates a new Image Game Object and returns it.
             * 
             * Note: This method will only be available if the Image Game Object has been built into Phaser.
             * @param config [description]
             */
            image(config: object): Phaser.GameObjects.Image;

            /**
             * Creates a new Mesh Game Object and returns it.
             * 
             * Note: This method will only be available if the Mesh Game Object and WebGL support have been built into Phaser.
             * @param config [description]
             */
            mesh(config: object): Phaser.GameObjects.Mesh;

            /**
             * Creates a new Particle Emitter Manager Game Object and returns it.
             * 
             * Note: This method will only be available if the Particles Game Object has been built into Phaser.
             * @param config [description]
             */
            particles(config: object): Phaser.GameObjects.Particles.ParticleEmitterManager;

            /**
             * Creates a new Quad Game Object and returns it.
             * 
             * Note: This method will only be available if the Quad Game Object and WebGL support have been built into Phaser.
             * @param config [description]
             */
            quad(config: object): Phaser.GameObjects.Quad;

            /**
             * Creates a new Render Texture Game Object and returns it.
             * 
             * Note: This method will only be available if the Render Texture Game Object has been built into Phaser.
             * @param config [description]
             */
            renderTexture(config: RenderTextureConfig): Phaser.GameObjects.RenderTexture;

            /**
             * Creates a new Sprite Game Object and returns it.
             * 
             * Note: This method will only be available if the Sprite Game Object has been built into Phaser.
             * @param config [description]
             */
            sprite(config: object): Phaser.GameObjects.Sprite;

            /**
             * Creates a new Sprite3D Game Object and returns it.
             * 
             * Note: This method will only be available if the Sprite3D Game Object has been built into Phaser.
             * @param config [description]
             */
            sprite3D(config: object): Phaser.GameObjects.Sprite3D;

            /**
             * Creates a new Text Game Object and returns it.
             * 
             * Note: This method will only be available if the Text Game Object has been built into Phaser.
             * @param config [description]
             */
            text(config: object): Phaser.GameObjects.Text;

            /**
             * Creates a new TileSprite Game Object and returns it.
             * 
             * Note: This method will only be available if the TileSprite Game Object has been built into Phaser.
             * @param config [description]
             */
            tileSprite(config: TileSprite): Phaser.GameObjects.TileSprite;

            /**
             * Creates a new Zone Game Object and returns it.
             * 
             * Note: This method will only be available if the Zone Game Object has been built into Phaser.
             * @param config [description]
             */
            zone(config: object): Phaser.GameObjects.Zone;

            /**
             * Creates a Tilemap from the given key or data, or creates a blank Tilemap if no key/data provided.
             * When loading from CSV or a 2D array, you should specify the tileWidth & tileHeight. When parsing
             * from a map from Tiled, the tileWidth, tileHeight, width & height will be pulled from the map
             * data. For an empty map, you should specify tileWidth, tileHeight, width & height.
             * @param config The config options for the Tilemap.
             * @param config.key The key in the Phaser cache that corresponds to the loaded tilemap
             * data.
             * @param config.data Instead of loading from the cache, you can also load
             * directly from a 2D array of tile indexes.
             * @param config.tileWidth The width of a tile in pixels. Default 32.
             * @param config.tileHeight The height of a tile in pixels. Default 32.
             * @param config.width The width of the map in tiles. Default 10.
             * @param config.height The height of the map in tiles. Default 10.
             * @param config.insertNull Controls how empty tiles, tiles with an index of -1,
             * in the map data are handled. If `true`, empty locations will get a value of `null`. If `false`,
             * empty location will get a Tile object with an index of -1. If you've a large sparsely populated
             * map and the tile data doesn't need to change then setting this value to `true` will help with
             * memory consumption. However if your map is small or you need to update the tiles dynamically,
             * then leave the default value set. Default false.
             */
            tilemap(config?: object): Phaser.Tilemaps.Tilemap;

            /**
             * Creates a new Tween object and returns it.
             * 
             * Note: This method will only be available if Tweens have been built into Phaser.
             * @param config The Tween configuration.
             */
            tween(config: object): Phaser.Tweens.Tween;

        }

        /**
         * The Game Object Factory is a Scene plugin that allows you to quickly create many common
         * 
         * types of Game Objects and have them automatically registered with the Scene.
         * 
         * 
         * 
         * Game Objects directly register themselves with the Factory and inject their own creation
         * 
         * methods into the class.
         */
        class GameObjectFactory {
            /**
             * 
             * @param scene The Scene to which this Game Object Factory belongs.
             */
            constructor(scene: Phaser.Scene);

            /**
             * Creates a new Path Object.
             * @param x The horizontal position of this Path.
             * @param y The vertical position of this Path.
             */
            path(x: number, y: number): Phaser.Curves.Path;

            /**
             * Creates a new Dynamic Bitmap Text Game Object and adds it to the Scene.
             * 
             * Note: This method will only be available if the Dynamic Bitmap Text Game Object has been built into Phaser.
             * @param x The x position of the Game Object.
             * @param y The y position of the Game Object.
             * @param font [description]
             * @param text [description]
             * @param size [description]
             */
            dynamicBitmapText(x: number, y: number, font: string, text?: string | string[], size?: number): Phaser.GameObjects.DynamicBitmapText;

            /**
             * Creates a new Bitmap Text Game Object and adds it to the Scene.
             * 
             * Note: This method will only be available if the Bitmap Text Game Object has been built into Phaser.
             * @param x The x position of the Game Object.
             * @param y The y position of the Game Object.
             * @param font [description]
             * @param text [description]
             * @param size [description]
             */
            bitmapText(x: number, y: number, font: string, text?: string | string[], size?: number): Phaser.GameObjects.BitmapText;

            /**
             * Creates a new Blitter Game Object and adds it to the Scene.
             * 
             * Note: This method will only be available if the Blitter Game Object has been built into Phaser.
             * @param x The x position of the Game Object.
             * @param y The y position of the Game Object.
             * @param key The key of the Texture the Blitter object will use.
             * @param frame The default Frame children of the Blitter will use.
             */
            blitter(x: number, y: number, key: string, frame?: string | integer): Phaser.GameObjects.Blitter;

            /**
             * The Scene to which this Game Object Factory belongs.
             */
            protected scene: Phaser.Scene;

            /**
             * A reference to the Scene.Systems.
             */
            protected systems: Phaser.Scenes.Systems;

            /**
             * A reference to the Scene Display List.
             */
            protected displayList: Phaser.GameObjects.DisplayList;

            /**
             * A reference to the Scene Update List.
             */
            protected "updateList;": Phaser.GameObjects.UpdateList;

            /**
             * Adds an existing Game Object to this Scene.
             * 
             * If the Game Object renders, it will be added to the Display List.
             * If it has a `preUpdate` method, it will be added to the Update List.
             * @param child The child to be added to this Scene.
             */
            existing(child: Phaser.GameObjects.GameObject): Phaser.GameObjects.GameObject;

            /**
             * Shuts this plugin down.
             */
            shutdown(): void;

            /**
             * Destroys this plugin.
             */
            destroy(): void;

            /**
             * Creates a new Graphics Game Object and adds it to the Scene.
             * 
             * Note: This method will only be available if the Graphics Game Object has been built into Phaser.
             * @param config [description]
             */
            graphics(config: object): Phaser.GameObjects.Graphics;

            /**
             * Creates a new Group Game Object and adds it to the Scene.
             * 
             * Note: This method will only be available if the Group Game Object has been built into Phaser.
             * @param children [description]
             * @param config [description]
             */
            group(children: Phaser.GameObjects.GameObject[] | GroupConfig, config?: GroupConfig): Phaser.GameObjects.Group;

            /**
             * Creates a new Image Game Object and adds it to the Scene.
             * 
             * Note: This method will only be available if the Image Game Object has been built into Phaser.
             * @param x The horizontal position of this Game Object in the world.
             * @param y The vertical position of this Game Object in the world.
             * @param texture The key of the Texture this Game Object will use to render with, as stored in the Texture Manager.
             * @param frame An optional frame from the Texture this Game Object is rendering with.
             */
            image(x: number, y: number, texture: string, frame?: string | integer): Phaser.GameObjects.Image;

            /**
             * Creates a new Mesh Game Object and adds it to the Scene.
             * 
             * Note: This method will only be available if the Mesh Game Object and WebGL support have been built into Phaser.
             * @param x The horizontal position of this Game Object in the world.
             * @param y The vertical position of this Game Object in the world.
             * @param vertices An array containing the vertices data for this Mesh.
             * @param uv An array containing the uv data for this Mesh.
             * @param colors An array containing the color data for this Mesh.
             * @param alphas An array containing the alpha data for this Mesh.
             * @param texture The key of the Texture this Game Object will use to render with, as stored in the Texture Manager.
             * @param frame An optional frame from the Texture this Game Object is rendering with.
             */
            mesh(x: number, y: number, vertices: number[], uv: number[], colors: number[], alphas: number[], texture: string, frame?: string | integer): Phaser.GameObjects.Mesh;

            /**
             * Creates a new Particle Emitter Manager Game Object and adds it to the Scene.
             * 
             * Note: This method will only be available if the Particles Game Object has been built into Phaser.
             * @param texture The key of the Texture this Game Object will use to render with, as stored in the Texture Manager.
             * @param frame [description]
             * @param emitters [description]
             */
            particles(texture: string, frame?: string | integer | object, emitters?: object): Phaser.GameObjects.Particles.ParticleEmitterManager;

            /**
             * Creates a new PathFollower Game Object and adds it to the Scene.
             * 
             * Note: This method will only be available if the PathFollower Game Object has been built into Phaser.
             * @param path The Path this PathFollower is connected to.
             * @param x The horizontal position of this Game Object in the world.
             * @param y The vertical position of this Game Object in the world.
             * @param texture The key of the Texture this Game Object will use to render with, as stored in the Texture Manager.
             * @param frame An optional frame from the Texture this Game Object is rendering with.
             */
            follower(path: Phaser.Curves.Path, x: number, y: number, texture: string, frame?: string | integer): Phaser.GameObjects.PathFollower;

            /**
             * Creates a new Quad Game Object and adds it to the Scene.
             * 
             * Note: This method will only be available if the Quad Game Object and WebGL support have been built into Phaser.
             * @param x The horizontal position of this Game Object in the world.
             * @param y The vertical position of this Game Object in the world.
             * @param texture The key of the Texture this Game Object will use to render with, as stored in the Texture Manager.
             * @param frame An optional frame from the Texture this Game Object is rendering with.
             */
            quad(x: number, y: number, texture: string, frame?: string | integer): Phaser.GameObjects.Quad;

            /**
             * Creates a new Render Texture Game Object and adds it to the Scene.
             * 
             * Note: This method will only be available if the Render Texture Game Object has been built into Phaser.
             * @param x The horizontal position of this Game Object in the world.
             * @param y The vertical position of this Game Object in the world.
             * @param width The width of the Render Texture. Default 32.
             * @param height The height of the Render Texture. Default 32.
             */
            renderTexture(x: number, y: number, width?: integer, height?: integer): Phaser.GameObjects.RenderTexture;

            /**
             * Creates a new Sprite Game Object and adds it to the Scene.
             * 
             * Note: This method will only be available if the Sprite Game Object has been built into Phaser.
             * @param x The horizontal position of this Game Object in the world.
             * @param y The vertical position of this Game Object in the world.
             * @param texture The key of the Texture this Game Object will use to render with, as stored in the Texture Manager.
             * @param frame An optional frame from the Texture this Game Object is rendering with.
             */
            sprite(x: number, y: number, texture: string, frame?: string | integer): Phaser.GameObjects.Sprite;

            /**
             * Creates a new Sprite3D Game Object and adds it to the Scene.
             * 
             * Note: This method will only be available if the Sprite3D Game Object has been built into Phaser.
             * @param x The horizontal position of this Game Object.
             * @param y The vertical position of this Game Object.
             * @param z The z position of this Game Object.
             * @param texture The key of the Texture this Game Object will use to render with, as stored in the Texture Manager.
             * @param frame An optional frame from the Texture this Game Object is rendering with.
             */
            sprite3D(x: number, y: number, z: number, texture: string, frame?: string | integer): Phaser.GameObjects.Sprite3D;

            /**
             * Creates a new Text Game Object and adds it to the Scene.
             * 
             * Note: This method will only be available if the Text Game Object has been built into Phaser.
             * @param x The horizontal position of this Game Object in the world.
             * @param y The vertical position of this Game Object in the world.
             * @param text The text this Text object will display.
             * @param style The Text style configuration object.
             */
            text(x: number, y: number, text: string | string[], style?: object): Phaser.GameObjects.Text;

            /**
             * Creates a new TileSprite Game Object and adds it to the Scene.
             * 
             * Note: This method will only be available if the TileSprite Game Object has been built into Phaser.
             * @param x The horizontal position of this Game Object in the world.
             * @param y The vertical position of this Game Object in the world.
             * @param width The width of the Game Object.
             * @param height The height of the Game Object.
             * @param texture The key of the Texture this Game Object will use to render with, as stored in the Texture Manager.
             * @param frame An optional frame from the Texture this Game Object is rendering with.
             */
            tileSprite(x: number, y: number, width: number, height: number, texture: string, frame?: string | integer): Phaser.GameObjects.TileSprite;

            /**
             * Creates a new Zone Game Object and adds it to the Scene.
             * 
             * Note: This method will only be available if the Zone Game Object has been built into Phaser.
             * @param x The horizontal position of this Game Object in the world.
             * @param y The vertical position of this Game Object in the world.
             * @param width The width of the Game Object.
             * @param height The height of the Game Object.
             */
            zone(x: number, y: number, width: number, height: number): Phaser.GameObjects.Zone;

            /**
             * Creates a Tilemap from the given key or data, or creates a blank Tilemap if no key/data provided.
             * When loading from CSV or a 2D array, you should specify the tileWidth & tileHeight. When parsing
             * from a map from Tiled, the tileWidth, tileHeight, width & height will be pulled from the map
             * data. For an empty map, you should specify tileWidth, tileHeight, width & height.
             * @param key The key in the Phaser cache that corresponds to the loaded tilemap data.
             * @param tileWidth The width of a tile in pixels. Pass in `null` to leave as the
             * default. Default 32.
             * @param tileHeight The height of a tile in pixels. Pass in `null` to leave as the
             * default. Default 32.
             * @param width The width of the map in tiles. Pass in `null` to leave as the
             * default. Default 10.
             * @param height The height of the map in tiles. Pass in `null` to leave as the
             * default. Default 10.
             * @param data Instead of loading from the cache, you can also load directly from
             * a 2D array of tile indexes. Pass in `null` for no data.
             * @param insertNull Controls how empty tiles, tiles with an index of -1, in the
             * map data are handled. If `true`, empty locations will get a value of `null`. If `false`, empty
             * location will get a Tile object with an index of -1. If you've a large sparsely populated map and
             * the tile data doesn't need to change then setting this value to `true` will help with memory
             * consumption. However if your map is small or you need to update the tiles dynamically, then leave
             * the default value set. Default false.
             */
            tilemap(key?: string, tileWidth?: integer, tileHeight?: integer, width?: integer, height?: integer, data?: integer[][], insertNull?: boolean): Phaser.Tilemaps.Tilemap;

            /**
             * Creates a new Tween object.
             * 
             * Note: This method will only be available Tweens have been built into Phaser.
             * @param config The Tween configuration.
             */
            tween(config: object): Phaser.Tweens.Tween;

        }

        /**
         * [description]
         */
        class Graphics extends GameObject implements Components.Alpha, Components.BlendMode, Components.Depth, Components.Pipeline, Components.Transform, Components.Visible, Components.ScrollFactor {
            /**
             * 
             * @param scene [description]
             * @param options [description]
             */
            constructor(scene: Phaser.Scene, options: object);


            /**
             * [description]
             */
            displayOriginX: number;

            /**
             * [description]
             */
            displayOriginY: number;

            /**
             * [description]
             */
            commandBuffer: any[];

            /**
             * [description]
             */
            defaultFillColor: number;

            /**
             * [description]
             */
            defaultFillAlpha: number;

            /**
             * [description]
             */
            defaultStrokeWidth: number;

            /**
             * [description]
             */
            defaultStrokeColor: number;

            /**
             * [description]
             */
            defaultStrokeAlpha: number;

            /**
             * [description]
             * @param options [description]
             */
            setDefaultStyles(options: object): Phaser.GameObjects.Graphics;

            /**
             * [description]
             * @param lineWidth [description]
             * @param color [description]
             * @param alpha [description] Default 1.
             */
            lineStyle(lineWidth: number, color: number, alpha?: number): Phaser.GameObjects.Graphics;

            /**
             * [description]
             * @param color [description]
             * @param alpha [description] Default 1.
             */
            fillStyle(color: number, alpha?: number): Phaser.GameObjects.Graphics;

            /**
             * [description]
             */
            beginPath(): Phaser.GameObjects.Graphics;

            /**
             * [description]
             */
            closePath(): Phaser.GameObjects.Graphics;

            /**
             * [description]
             */
            fillPath(): Phaser.GameObjects.Graphics;

            /**
             * [description]
             */
            strokePath(): Phaser.GameObjects.Graphics;

            /**
             * [description]
             * @param circle [description]
             */
            fillCircleShape(circle: Phaser.Geom.Circle): Phaser.GameObjects.Graphics;

            /**
             * [description]
             * @param circle [description]
             */
            strokeCircleShape(circle: Phaser.Geom.Circle): Phaser.GameObjects.Graphics;

            /**
             * [description]
             * @param x [description]
             * @param y [description]
             * @param radius [description]
             */
            fillCircle(x: number, y: number, radius: number): Phaser.GameObjects.Graphics;

            /**
             * [description]
             * @param x [description]
             * @param y [description]
             * @param radius [description]
             */
            strokeCircle(x: number, y: number, radius: number): Phaser.GameObjects.Graphics;

            /**
             * [description]
             * @param rect [description]
             */
            fillRectShape(rect: Phaser.Geom.Rectangle): Phaser.GameObjects.Graphics;

            /**
             * [description]
             * @param rect [description]
             */
            strokeRectShape(rect: Phaser.Geom.Rectangle): Phaser.GameObjects.Graphics;

            /**
             * [description]
             * @param x [description]
             * @param y [description]
             * @param width [description]
             * @param height [description]
             */
            fillRect(x: number, y: number, width: number, height: number): Phaser.GameObjects.Graphics;

            /**
             * [description]
             * @param x [description]
             * @param y [description]
             * @param width [description]
             * @param height [description]
             */
            strokeRect(x: number, y: number, width: number, height: number): Phaser.GameObjects.Graphics;

            /**
             * [description]
             * @param point [description]
             * @param size [description] Default 1.
             */
            fillPointShape(point: Phaser.Geom.Point | Phaser.Math.Vector2 | object, size?: number): Phaser.GameObjects.Graphics;

            /**
             * [description]
             * @param x [description]
             * @param y [description]
             * @param size [description] Default 1.
             */
            fillPoint(x: number, y: number, size?: number): Phaser.GameObjects.Graphics;

            /**
             * [description]
             * @param triangle [description]
             */
            fillTriangleShape(triangle: Phaser.Geom.Triangle): Phaser.GameObjects.Graphics;

            /**
             * [description]
             * @param triangle [description]
             */
            strokeTriangleShape(triangle: Phaser.Geom.Triangle): Phaser.GameObjects.Graphics;

            /**
             * [description]
             * @param x0 [description]
             * @param y0 [description]
             * @param x1 [description]
             * @param y1 [description]
             * @param x2 [description]
             * @param y2 [description]
             */
            fillTriangle(x0: number, y0: number, x1: number, y1: number, x2: number, y2: number): Phaser.GameObjects.Graphics;

            /**
             * [description]
             * @param x0 [description]
             * @param y0 [description]
             * @param x1 [description]
             * @param y1 [description]
             * @param x2 [description]
             * @param y2 [description]
             */
            strokeTriangle(x0: number, y0: number, x1: number, y1: number, x2: number, y2: number): Phaser.GameObjects.Graphics;

            /**
             * [description]
             * @param line [description]
             */
            strokeLineShape(line: Phaser.Geom.Line): Phaser.GameObjects.Graphics;

            /**
             * [description]
             * @param x1 [description]
             * @param y1 [description]
             * @param x2 [description]
             * @param y2 [description]
             */
            lineBetween(x1: number, y1: number, x2: number, y2: number): Phaser.GameObjects.Graphics;

            /**
             * [description]
             * @param x [description]
             * @param y [description]
             */
            lineTo(x: number, y: number): Phaser.GameObjects.Graphics;

            /**
             * [description]
             * @param x [description]
             * @param y [description]
             */
            moveTo(x: number, y: number): Phaser.GameObjects.Graphics;

            /**
             * [description]
             * @param x [description]
             * @param y [description]
             * @param width [description]
             * @param rgb [description]
             */
            lineFxTo(x: number, y: number, width: number, rgb: number): Phaser.GameObjects.Graphics;

            /**
             * [description]
             * @param x [description]
             * @param y [description]
             * @param width [description]
             * @param rgb [description]
             */
            moveFxTo(x: number, y: number, width: number, rgb: number): Phaser.GameObjects.Graphics;

            /**
             * [description]
             * @param points [description]
             * @param autoClose [description] Default false.
             * @param endIndex [description]
             */
            strokePoints(points: any[] | Phaser.Geom.Point[], autoClose?: boolean, endIndex?: integer): Phaser.GameObjects.Graphics;

            /**
             * [description]
             * @param points [description]
             * @param autoClose [description] Default false.
             * @param endIndex [description]
             */
            fillPoints(points: any[] | Phaser.Geom.Point[], autoClose?: boolean, endIndex?: integer): Phaser.GameObjects.Graphics;

            /**
             * [description]
             * @param ellipse [description]
             * @param smoothness [description] Default 32.
             */
            strokeEllipseShape(ellipse: Phaser.Geom.Ellipse, smoothness?: integer): Phaser.GameObjects.Graphics;

            /**
             * [description]
             * @param x [description]
             * @param y [description]
             * @param width [description]
             * @param height [description]
             * @param smoothness [description] Default 32.
             */
            strokeEllipse(x: number, y: number, width: number, height: number, smoothness?: integer): Phaser.GameObjects.Graphics;

            /**
             * [description]
             * @param ellipse [description]
             * @param smoothness [description] Default 32.
             */
            fillEllipseShape(ellipse: Phaser.Geom.Ellipse, smoothness?: integer): Phaser.GameObjects.Graphics;

            /**
             * [description]
             * @param x [description]
             * @param y [description]
             * @param width [description]
             * @param height [description]
             * @param smoothness [description] Default 32.
             */
            fillEllipse(x: number, y: number, width: number, height: number, smoothness?: integer): Phaser.GameObjects.Graphics;

            /**
             * [description]
             * @param x [description]
             * @param y [description]
             * @param radius [description]
             * @param startAngle [description]
             * @param endAngle [description]
             * @param anticlockwise [description]
             */
            arc(x: number, y: number, radius: number, startAngle: number, endAngle: number, anticlockwise: boolean): Phaser.GameObjects.Graphics;

            /**
             * [description]
             */
            save(): Phaser.GameObjects.Graphics;

            /**
             * [description]
             */
            restore(): Phaser.GameObjects.Graphics;

            /**
             * [description]
             * @param x [description]
             * @param y [description]
             */
            translate(x: number, y: number): Phaser.GameObjects.Graphics;

            /**
             * [description]
             * @param x [description]
             * @param y [description]
             */
            scale(x: number, y: number): Phaser.GameObjects.Graphics;

            /**
             * [description]
             * @param radians [description]
             */
            rotate(radians: number): Phaser.GameObjects.Graphics;

            /**
             * [description]
             */
            clear(): Phaser.GameObjects.Graphics;

            /**
             * If key is a string it'll generate a new texture using it and add it into the
             * Texture Manager (assuming no key conflict happens).
             * 
             * If key is a Canvas it will draw the texture to that canvas context. Note that it will NOT
             * automatically upload it to the GPU in WebGL mode.
             * @param key [description]
             * @param width [description]
             * @param height [description]
             */
            generateTexture(key: string | HTMLCanvasElement, width?: integer, height?: integer): Phaser.GameObjects.Graphics;

            /**
             * A Camera used specifically by the Graphics system for rendering to textures.
             */
            static TargetCamera: Phaser.Cameras.Scene2D.Camera;

            /**
             * Clears all alpha values associated with this Game Object.
             * Immediately sets the alpha levels back to 1 (fully opaque)
             */
            clearAlpha(): Phaser.GameObjects.GameObject;

            /**
             * Set the Alpha level of this Game Object. The alpha controls the opacity of the Game Object as it renders.
             * Alpha values are provided as a float between 0, fully transparent, and 1, fully opaque.
             * 
             * If your game is running under WebGL you can optionally specify four different alpha values, each of which
             * correspond to the four corners of the Game Object. Under Canvas only the `topLeft` value given is used.
             * @param topLeft The alpha value used for the top-left of the Game Object. If this is the only value given it's applied across the whole Game Object. Default 1.
             * @param topRight The alpha value used for the top-right of the Game Object. WebGL only.
             * @param bottomLeft The alpha value used for the bottom-left of the Game Object. WebGL only.
             * @param bottomRight The alpha value used for the bottom-right of the Game Object. WebGL only.
             */
            setAlpha(topLeft?: number, topRight?: number, bottomLeft?: number, bottomRight?: number): Phaser.GameObjects.GameObject;

            /**
             * The alpha value of the Game Object.
             * 
             * This is a global value, impacting the entire Game Object, not just a region of it.
             */
            alpha: number;

            /**
             * The alpha value starting from the top-left of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            alphaTopLeft: number;

            /**
             * The alpha value starting from the top-right of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            alphaTopRight: number;

            /**
             * The alpha value starting from the bottom-left of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            alphaBottomLeft: number;

            /**
             * The alpha value starting from the bottom-right of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            alphaBottomRight: number;

            /**
             * Sets the Blend Mode being used by this Game Object.
             * 
             * This can be a const, such as `Phaser.BlendModes.SCREEN`, or an integer, such as 4 (for Overlay)
             * 
             * Under WebGL only the following Blend Modes are available:
             * 
             * * ADD
             * * MULTIPLY
             * * SCREEN
             * 
             * Canvas has more available depending on browser support.
             * 
             * You can also create your own custom Blend Modes in WebGL.
             * 
             * Blend modes have different effects under Canvas and WebGL, and from browser to browser, depending
             * on support. Blend Modes also cause a WebGL batch flush should it encounter a new blend mode. For these
             * reasons try to be careful about the construction of your Scene and the frequency of which blend modes
             * are used.
             */
            blendMode: Phaser.BlendModes | string;

            /**
             * Sets the Blend Mode being used by this Game Object.
             * 
             * This can be a const, such as `Phaser.BlendModes.SCREEN`, or an integer, such as 4 (for Overlay)
             * 
             * Under WebGL only the following Blend Modes are available:
             * 
             * * ADD
             * * MULTIPLY
             * * SCREEN
             * 
             * Canvas has more available depending on browser support.
             * 
             * You can also create your own custom Blend Modes in WebGL.
             * 
             * Blend modes have different effects under Canvas and WebGL, and from browser to browser, depending
             * on support. Blend Modes also cause a WebGL batch flush should it encounter a new blend mode. For these
             * reasons try to be careful about the construction of your Scene and the frequency of which blend modes
             * are used.
             * @param value The BlendMode value. Either a string or a CONST.
             */
            setBlendMode(value: string | Phaser.BlendModes): Phaser.GameObjects.GameObject;

            /**
             * The depth of this Game Object within the Scene.
             * 
             * The depth is also known as the 'z-index' in some environments, and allows you to change the rendering order
             * of Game Objects, without actually moving their position in the display list.
             * 
             * The depth starts from zero (the default value) and increases from that point. A Game Object with a higher depth
             * value will always render in front of one with a lower value.
             * 
             * Setting the depth will queue a depth sort event within the Scene.
             */
            depth: number;

            /**
             * The depth of this Game Object within the Scene.
             * 
             * The depth is also known as the 'z-index' in some environments, and allows you to change the rendering order
             * of Game Objects, without actually moving their position in the display list.
             * 
             * The depth starts from zero (the default value) and increases from that point. A Game Object with a higher depth
             * value will always render in front of one with a lower value.
             * 
             * Setting the depth will queue a depth sort event within the Scene.
             * @param value The depth of this Game Object.
             */
            setDepth(value: integer): Phaser.GameObjects.GameObject;

            /**
             * [description]
             */
            defaultPipeline: Phaser.Renderer.WebGL.WebGLPipeline;

            /**
             * [description]
             */
            pipeline: Phaser.Renderer.WebGL.WebGLPipeline;

            /**
             * Sets the initial WebGL Pipeline of this Game Object.
             * This should only be called during the instantiation of the Game Object.
             * @param pipelineName The name of the pipeline to set on this Game Object.
             */
            initPipeline(pipelineName: string): boolean;

            /**
             * Sets the active WebGL Pipeline of this Game Object.
             * @param pipelineName The name of the pipeline to set on this Game Object.
             */
            setPipeline(pipelineName: string): boolean;

            /**
             * Resets the WebGL Pipeline of this Game Object back to the default it was created with.
             */
            resetPipeline(): boolean;

            /**
             * Gets the name of the WebGL Pipeline this Game Object is currently using.
             */
            getPipelineName(): string;

            /**
             * The x position of this Game Object.
             */
            x: number;

            /**
             * The y position of this Game Object.
             */
            y: number;

            /**
             * The z position of this Game Object.
             * Note: Do not use this value to set the z-index, instead see the `depth` property.
             */
            z: number;

            /**
             * The w position of this Game Object.
             */
            w: number;

            /**
             * The horizontal scale of this Game Object.
             */
            scaleX: number;

            /**
             * The vertical scale of this Game Object.
             */
            scaleY: number;

            /**
             * The angle of this Game Object as expressed in degrees.
             * 
             * Where 0 is to the right, 90 is down, 180 is left.
             * 
             * If you prefer to work in radians, see the `rotation` property instead.
             */
            angle: integer;

            /**
             * The angle of this Game Object in radians.
             * 
             * If you prefer to work in degrees, see the `angle` property instead.
             */
            rotation: number;

            /**
             * Sets the position of this Game Object.
             * @param x The x position of this Game Object. Default 0.
             * @param y The y position of this Game Object. If not set it will use the `x` value.
             * @param z The z position of this Game Object. Default 0.
             * @param w The w position of this Game Object. Default 0.
             */
            setPosition(x?: number, y?: number, z?: number, w?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the rotation of this Game Object.
             * @param radians The rotation of this Game Object, in radians. Default 0.
             */
            setRotation(radians?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the angle of this Game Object.
             * @param degrees The rotation of this Game Object, in degrees. Default 0.
             */
            setAngle(degrees?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the scale of this Game Object.
             * @param x The horizontal scale of this Game Object.
             * @param y The vertical scale of this Game Object. If not set it will use the `x` value. Default x.
             */
            setScale(x: number, y?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the x position of this Game Object.
             * @param value The x position of this Game Object. Default 0.
             */
            setX(value?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the y position of this Game Object.
             * @param value The y position of this Game Object. Default 0.
             */
            setY(value?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the z position of this Game Object.
             * @param value The z position of this Game Object. Default 0.
             */
            setZ(value?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the w position of this Game Object.
             * @param value The w position of this Game Object. Default 0.
             */
            setW(value?: number): Phaser.GameObjects.GameObject;

            /**
             * The visible state of the Game Object.
             * 
             * An invisible Game Object will skip rendering, but will still process update logic.
             */
            visible: boolean;

            /**
             * Sets the visibility of this Game Object.
             * 
             * An invisible Game Object will skip rendering, but will still process update logic.
             * @param value The visible state of the Game Object.
             */
            setVisible(value: boolean): Phaser.GameObjects.GameObject;

            /**
             * The horizontal scroll factor of this Game Object.
             * 
             * The scroll factor controls the influence of the movement of a Camera upon this Game Object.
             * 
             * When a camera scrolls it will change the location at which this Game Object is rendered on-screen.
             * It does not change the Game Objects actual position values.
             * 
             * A value of 1 means it will move exactly in sync with a camera.
             * A value of 0 means it will not move at all, even if the camera moves.
             * Other values control the degree to which the camera movement is mapped to this Game Object.
             */
            scrollFactorX: number;

            /**
             * The vertical scroll factor of this Game Object.
             * 
             * The scroll factor controls the influence of the movement of a Camera upon this Game Object.
             * 
             * When a camera scrolls it will change the location at which this Game Object is rendered on-screen.
             * It does not change the Game Objects actual position values.
             * 
             * A value of 1 means it will move exactly in sync with a camera.
             * A value of 0 means it will not move at all, even if the camera moves.
             * Other values control the degree to which the camera movement is mapped to this Game Object.
             */
            scrollFactorY: number;

            /**
             * Sets the scroll factor of this Game Object.
             * 
             * The scroll factor controls the influence of the movement of a Camera upon this Game Object.
             * 
             * When a camera scrolls it will change the location at which this Game Object is rendered on-screen.
             * It does not change the Game Objects actual position values.
             * 
             * A value of 1 means it will move exactly in sync with a camera.
             * A value of 0 means it will not move at all, even if the camera moves.
             * Other values control the degree to which the camera movement is mapped to this Game Object.
             * @param x The horizontal scroll factor of this Game Object.
             * @param y The vertical scroll factor of this Game Object. If not set it will use the `x` value. Default x.
             */
            setScrollFactor(x: number, y?: number): Phaser.GameObjects.GameObject;

        }

        /**
         * [description]
         * 
         * 
         * 
         *  children can be either an array of children, or a config object
         * 
         *  config can be either a config object, or undefined if passed as the children argument instead
         */
        class Group {
            /**
             * 
             * @param scene [description]
             * @param children [description]
             * @param config [description]
             */
            constructor(scene: Phaser.Scene, children: Phaser.GameObjects.GameObject[] | GroupConfig, config?: GroupConfig);

            /**
             * [description]
             */
            scene: Phaser.Scene;

            /**
             * [description]
             */
            children: Phaser.Structs.Set<Phaser.GameObjects.GameObject>;

            /**
             * [description]
             */
            isParent: boolean;

            /**
             * [description]
             */
            classType: object;

            /**
             * [description]
             */
            active: boolean;

            /**
             * [description]
             */
            maxSize: integer;

            /**
             * [description]
             */
            defaultKey: string;

            /**
             * [description]
             */
            defaultFrame: string | integer;

            /**
             * [description]
             */
            runChildUpdate: boolean;

            /**
             * [description]
             */
            createCallback: GroupCallback;

            /**
             * [description]
             */
            removeCallback: GroupCallback;

            /**
             * [description]
             */
            createMultipleCallback: GroupMultipleCreateCallback;

            /**
             * [description]
             * @param x The horizontal position of this Game Object in the world. Default 0.
             * @param y The vertical position of this Game Object in the world. Default 0.
             * @param key The key of the Texture this Game Object will use to render with, as stored in the Texture Manager. Default defaultKey.
             * @param frame An optional frame from the Texture this Game Object is rendering with. Default defaultFrame.
             * @param visible The {@link Phaser.GameObjects.Components.Visible#visible} state of this Game Object. Default true.
             * @param active The {@link Phaser.GameObjects.GameObject#active} state of this Game Object. Default true.
             */
            create(x?: number, y?: number, key?: string, frame?: string | integer, visible?: boolean, active?: boolean): Phaser.GameObjects.GameObject;

            /**
             * [description]
             * @param config [description]
             */
            createMultiple(config: GroupCreateConfig): Phaser.GameObjects.GameObject[];

            /**
             * [description]
             * @param options [description]
             */
            createFromConfig(options: GroupCreateConfig): Phaser.GameObjects.GameObject[];

            /**
             * [description]
             * @param time [description]
             * @param delta [description]
             */
            preUpdate(time: number, delta: number): void;

            /**
             * [description]
             * @param child [description]
             * @param addToScene [description] Default false.
             */
            add(child: Phaser.GameObjects.GameObject, addToScene?: boolean): Phaser.GameObjects.Group;

            /**
             * [description]
             * @param children [description]
             * @param addToScene [description] Default false.
             */
            addMultiple(children: Phaser.GameObjects.GameObject[], addToScene?: boolean): Phaser.GameObjects.Group;

            /**
             * [description]
             * @param child [description]
             * @param removeFromScene [description] Default false.
             */
            remove(child: Phaser.GameObjects.GameObject, removeFromScene?: boolean): Phaser.GameObjects.Group;

            /**
             * [description]
             * @param removeFromScene [description] Default false.
             */
            clear(removeFromScene?: boolean): Phaser.GameObjects.Group;

            /**
             * [description]
             * @param child [description]
             */
            contains(child: Phaser.GameObjects.GameObject): boolean;

            /**
             * [description]
             */
            getChildren(): Phaser.GameObjects.GameObject[];

            /**
             * [description]
             */
            getLength(): integer;

            /**
             * [description]
             * @param state [description] Default false.
             * @param createIfNull [description] Default false.
             * @param x The horizontal position of this Game Object in the world. Default 0.
             * @param y The vertical position of this Game Object in the world. Default 0.
             * @param key The key of the Texture this Game Object will use to render with, as stored in the Texture Manager. Default defaultKey.
             * @param frame An optional frame from the Texture this Game Object is rendering with. Default defaultFrame.
             * @param visible The {@link Phaser.GameObjects.Components.Visible#visible} state of this Game Object. Default true.
             */
            getFirst(state?: boolean, createIfNull?: boolean, x?: number, y?: number, key?: string, frame?: string | integer, visible?: boolean): Phaser.GameObjects.GameObject;

            /**
             * Scans the Group for the first child that has an `active` state set to `false` and returns it.
             * 
             * If no child is found then it will create a new one using the arguments given to this method.
             * Unless a new child is being created the arguments are ignored.
             * @param x The horizontal position of this Game Object in the world. Default 0.
             * @param y The vertical position of this Game Object in the world. Default 0.
             * @param key The key of the Texture this Game Object will use to render with, as stored in the Texture Manager. Default defaultKey.
             * @param frame An optional frame from the Texture this Game Object is rendering with. Default defaultFrame.
             * @param visible The {@link Phaser.GameObjects.Components.Visible#visible} state of this Game Object. Default true.
             */
            get(x?: number, y?: number, key?: string, frame?: string | integer, visible?: boolean): Phaser.GameObjects.GameObject;

            /**
             * Scans the Group for the first child that has an `active` state set to `true` and returns it.
             * 
             * If no child is found, and `createIfNull` is `true`, then it will create a new one using the arguments given to this method.
             * Unless a new child is being created the arguments are ignored.
             * @param createIfNull [description]
             * @param x The horizontal position of this Game Object in the world. Default 0.
             * @param y The vertical position of this Game Object in the world. Default 0.
             * @param key The key of the Texture this Game Object will use to render with, as stored in the Texture Manager. Default defaultKey.
             * @param frame An optional frame from the Texture this Game Object is rendering with. Default defaultFrame.
             * @param visible The {@link Phaser.GameObjects.Components.Visible#visible} state of this Game Object. Default true.
             */
            getFirstAlive(createIfNull: boolean, x?: number, y?: number, key?: string, frame?: string | integer, visible?: boolean): Phaser.GameObjects.GameObject;

            /**
             * Scans the Group for the first child that has an `active` state set to `false` and returns it.
             * 
             * If no child is found, and `createIfNull` is `true`, then it will create a new one using the arguments given to this method.
             * Unless a new child is being created the arguments are ignored.
             * @param createIfNull [description]
             * @param x The horizontal position of this Game Object in the world. Default 0.
             * @param y The vertical position of this Game Object in the world. Default 0.
             * @param key The key of the Texture this Game Object will use to render with, as stored in the Texture Manager. Default defaultKey.
             * @param frame An optional frame from the Texture this Game Object is rendering with. Default defaultFrame.
             * @param visible The {@link Phaser.GameObjects.Components.Visible#visible} state of this Game Object. Default true.
             */
            getFirstDead(createIfNull: boolean, x?: number, y?: number, key?: string, frame?: string | integer, visible?: boolean): Phaser.GameObjects.GameObject;

            /**
             * [description]
             * @param key [description]
             * @param startFrame [description]
             */
            playAnimation(key: string, startFrame: string): Phaser.GameObjects.Group;

            /**
             * [description]
             */
            isFull(): boolean;

            /**
             * [description]
             * @param value [description] Default true.
             */
            countActive(value?: boolean): integer;

            /**
             * [description]
             */
            getTotalUsed(): integer;

            /**
             * [description]
             */
            getTotalFree(): integer;

            /**
             * [description]
             * @param value [description]
             * @param step [description]
             */
            setDepth(value: number, step: number): Phaser.GameObjects.Group;

            /**
             * [description]
             * @param gameObject [description]
             */
            kill(gameObject: Phaser.GameObjects.GameObject): void;

            /**
             * [description]
             * @param gameObject [description]
             */
            killAndHide(gameObject: Phaser.GameObjects.GameObject): void;

            /**
             * [description]
             */
            toggleVisible(): Phaser.GameObjects.Group;

            /**
             * [description]
             * @param destroyChildren Call `GameObject.destroy` on all children of this Group? Default false.
             */
            destroy(destroyChildren?: boolean): void;

        }

        /**
         * An Image Game Object.
         * 
         * 
         * 
         * An Image is a light-weight Game Object useful for the display of static images in your game,
         * 
         * such as logos, backgrounds, scenery or other non-animated elements. Images can have input
         * 
         * events and physics bodies, or be tweened, tinted or scrolled. The main difference between an
         * 
         * Image and a Sprite is that you cannot animate an Image as they do not have the Animation component.
         */
        class Image extends GameObject implements Components.Alpha, Components.BlendMode, Components.Depth, Components.Flip, Components.GetBounds, Components.Origin, Components.Pipeline, Components.ScaleMode, Components.ScrollFactor, Components.Size, Components.Texture, Components.Tint, Components.Transform, Components.Visible {
            /**
             * 
             * @param scene The Scene to which this Game Object belongs. A Game Object can only belong to one Scene at a time.
             * @param x The horizontal position of this Game Object in the world.
             * @param y The vertical position of this Game Object in the world.
             * @param texture The key of the Texture this Game Object will use to render with, as stored in the Texture Manager.
             * @param frame An optional frame from the Texture this Game Object is rendering with.
             */
            constructor(scene: Phaser.Scene, x: number, y: number, texture: string, frame?: string | integer);

            /**
             * Clears all alpha values associated with this Game Object.
             * Immediately sets the alpha levels back to 1 (fully opaque)
             */
            clearAlpha(): Phaser.GameObjects.GameObject;

            /**
             * Set the Alpha level of this Game Object. The alpha controls the opacity of the Game Object as it renders.
             * Alpha values are provided as a float between 0, fully transparent, and 1, fully opaque.
             * 
             * If your game is running under WebGL you can optionally specify four different alpha values, each of which
             * correspond to the four corners of the Game Object. Under Canvas only the `topLeft` value given is used.
             * @param topLeft The alpha value used for the top-left of the Game Object. If this is the only value given it's applied across the whole Game Object. Default 1.
             * @param topRight The alpha value used for the top-right of the Game Object. WebGL only.
             * @param bottomLeft The alpha value used for the bottom-left of the Game Object. WebGL only.
             * @param bottomRight The alpha value used for the bottom-right of the Game Object. WebGL only.
             */
            setAlpha(topLeft?: number, topRight?: number, bottomLeft?: number, bottomRight?: number): Phaser.GameObjects.GameObject;

            /**
             * The alpha value of the Game Object.
             * 
             * This is a global value, impacting the entire Game Object, not just a region of it.
             */
            alpha: number;

            /**
             * The alpha value starting from the top-left of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            alphaTopLeft: number;

            /**
             * The alpha value starting from the top-right of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            alphaTopRight: number;

            /**
             * The alpha value starting from the bottom-left of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            alphaBottomLeft: number;

            /**
             * The alpha value starting from the bottom-right of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            alphaBottomRight: number;

            /**
             * Sets the Blend Mode being used by this Game Object.
             * 
             * This can be a const, such as `Phaser.BlendModes.SCREEN`, or an integer, such as 4 (for Overlay)
             * 
             * Under WebGL only the following Blend Modes are available:
             * 
             * * ADD
             * * MULTIPLY
             * * SCREEN
             * 
             * Canvas has more available depending on browser support.
             * 
             * You can also create your own custom Blend Modes in WebGL.
             * 
             * Blend modes have different effects under Canvas and WebGL, and from browser to browser, depending
             * on support. Blend Modes also cause a WebGL batch flush should it encounter a new blend mode. For these
             * reasons try to be careful about the construction of your Scene and the frequency of which blend modes
             * are used.
             */
            blendMode: Phaser.BlendModes | string;

            /**
             * Sets the Blend Mode being used by this Game Object.
             * 
             * This can be a const, such as `Phaser.BlendModes.SCREEN`, or an integer, such as 4 (for Overlay)
             * 
             * Under WebGL only the following Blend Modes are available:
             * 
             * * ADD
             * * MULTIPLY
             * * SCREEN
             * 
             * Canvas has more available depending on browser support.
             * 
             * You can also create your own custom Blend Modes in WebGL.
             * 
             * Blend modes have different effects under Canvas and WebGL, and from browser to browser, depending
             * on support. Blend Modes also cause a WebGL batch flush should it encounter a new blend mode. For these
             * reasons try to be careful about the construction of your Scene and the frequency of which blend modes
             * are used.
             * @param value The BlendMode value. Either a string or a CONST.
             */
            setBlendMode(value: string | Phaser.BlendModes): Phaser.GameObjects.GameObject;

            /**
             * The depth of this Game Object within the Scene.
             * 
             * The depth is also known as the 'z-index' in some environments, and allows you to change the rendering order
             * of Game Objects, without actually moving their position in the display list.
             * 
             * The depth starts from zero (the default value) and increases from that point. A Game Object with a higher depth
             * value will always render in front of one with a lower value.
             * 
             * Setting the depth will queue a depth sort event within the Scene.
             */
            depth: number;

            /**
             * The depth of this Game Object within the Scene.
             * 
             * The depth is also known as the 'z-index' in some environments, and allows you to change the rendering order
             * of Game Objects, without actually moving their position in the display list.
             * 
             * The depth starts from zero (the default value) and increases from that point. A Game Object with a higher depth
             * value will always render in front of one with a lower value.
             * 
             * Setting the depth will queue a depth sort event within the Scene.
             * @param value The depth of this Game Object.
             */
            setDepth(value: integer): Phaser.GameObjects.GameObject;

            /**
             * The horizontally flipped state of the Game Object.
             * A Game Object that is flipped horizontally will render inversed on the horizontal axis.
             * Flipping always takes place from the middle of the texture and does not impact the scale value.
             */
            flipX: boolean;

            /**
             * The vertically flipped state of the Game Object.
             * A Game Object that is flipped vertically will render inversed on the vertical axis (i.e. upside down)
             * Flipping always takes place from the middle of the texture and does not impact the scale value.
             */
            flipY: boolean;

            /**
             * Toggles the horizontal flipped state of this Game Object.
             */
            toggleFlipX(): Phaser.GameObjects.GameObject;

            /**
             * Toggles the vertical flipped state of this Game Object.
             */
            toggleFlipY(): Phaser.GameObjects.GameObject;

            /**
             * Sets the horizontal flipped state of this Game Object.
             * @param value The flipped state. `false` for no flip, or `true` to be flipped.
             */
            setFlipX(value: boolean): Phaser.GameObjects.GameObject;

            /**
             * Sets the vertical flipped state of this Game Object.
             * @param value The flipped state. `false` for no flip, or `true` to be flipped.
             */
            setFlipY(value: boolean): Phaser.GameObjects.GameObject;

            /**
             * Sets the horizontal and vertical flipped state of this Game Object.
             * @param x The horizontal flipped state. `false` for no flip, or `true` to be flipped.
             * @param y The horizontal flipped state. `false` for no flip, or `true` to be flipped.
             */
            setFlip(x: boolean, y: boolean): Phaser.GameObjects.GameObject;

            /**
             * Resets the horizontal and vertical flipped state of this Game Object back to their default un-flipped state.
             */
            resetFlip(): Phaser.GameObjects.GameObject;

            /**
             * Gets the center coordinate of this Game Object, regardless of origin.
             * @param output An object to store the values in. If not provided a new Vector2 will be created.
             */
            getCenter<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * Gets the top-left corner coordinate of this Game Object, regardless of origin.
             * @param output An object to store the values in. If not provided a new Vector2 will be created.
             */
            getTopLeft<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * Gets the top-right corner coordinate of this Game Object, regardless of origin.
             * @param output An object to store the values in. If not provided a new Vector2 will be created.
             */
            getTopRight<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * Gets the bottom-left corner coordinate of this Game Object, regardless of origin.
             * @param output An object to store the values in. If not provided a new Vector2 will be created.
             */
            getBottomLeft<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * Gets the bottom-right corner coordinate of this Game Object, regardless of origin.
             * @param output An object to store the values in. If not provided a new Vector2 will be created.
             */
            getBottomRight<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * Gets the bounds of this Game Object, regardless of origin.
             * The values are stored and returned in a Rectangle, or Rectangle-like, object.
             * @param output An object to store the values in. If not provided a new Rectangle will be created.
             */
            getBounds<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * The horizontal origin of this Game Object.
             * The origin maps the relationship between the size and position of the Game Object.
             * The default value is 0.5, meaning all Game Objects are positioned based on their center.
             * Setting the value to 0 means the position now relates to the left of the Game Object.
             */
            originX: number;

            /**
             * The vertical origin of this Game Object.
             * The origin maps the relationship between the size and position of the Game Object.
             * The default value is 0.5, meaning all Game Objects are positioned based on their center.
             * Setting the value to 0 means the position now relates to the top of the Game Object.
             */
            originY: number;

            /**
             * The horizontal display origin of this Game Object.
             * The origin is a normalized value between 0 and 1.
             * The displayOrigin is a pixel value, based on the size of the Game Object combined with the origin.
             */
            displayOriginX: number;

            /**
             * The vertical display origin of this Game Object.
             * The origin is a normalized value between 0 and 1.
             * The displayOrigin is a pixel value, based on the size of the Game Object combined with the origin.
             */
            displayOriginY: number;

            /**
             * Sets the origin of this Game Object.
             * 
             * The values are given in the range 0 to 1.
             * @param x The horizontal origin value. Default 0.5.
             * @param y The vertical origin value. If not defined it will be set to the value of `x`. Default x.
             */
            setOrigin(x?: number, y?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the origin of this Game Object based on the Pivot values in its Frame.
             */
            setOriginFromFrame(): Phaser.GameObjects.GameObject;

            /**
             * Sets the display origin of this Game Object.
             * The difference between this and setting the origin is that you can use pixel values for setting the display origin.
             * @param x The horizontal display origin value. Default 0.
             * @param y The vertical display origin value. If not defined it will be set to the value of `x`. Default x.
             */
            setDisplayOrigin(x?: number, y?: number): Phaser.GameObjects.GameObject;

            /**
             * Updates the Display Origin cached values internally stored on this Game Object.
             * You don't usually call this directly, but it is exposed for edge-cases where you may.
             */
            updateDisplayOrigin(): Phaser.GameObjects.GameObject;

            /**
             * [description]
             */
            defaultPipeline: Phaser.Renderer.WebGL.WebGLPipeline;

            /**
             * [description]
             */
            pipeline: Phaser.Renderer.WebGL.WebGLPipeline;

            /**
             * Sets the initial WebGL Pipeline of this Game Object.
             * This should only be called during the instantiation of the Game Object.
             * @param pipelineName The name of the pipeline to set on this Game Object.
             */
            initPipeline(pipelineName: string): boolean;

            /**
             * Sets the active WebGL Pipeline of this Game Object.
             * @param pipelineName The name of the pipeline to set on this Game Object.
             */
            setPipeline(pipelineName: string): boolean;

            /**
             * Resets the WebGL Pipeline of this Game Object back to the default it was created with.
             */
            resetPipeline(): boolean;

            /**
             * Gets the name of the WebGL Pipeline this Game Object is currently using.
             */
            getPipelineName(): string;

            /**
             * The Scale Mode being used by this Game Object.
             * Can be either `ScaleModes.LINEAR` or `ScaleModes.NEAREST`.
             */
            scaleMode: Phaser.ScaleModes;

            /**
             * Sets the Scale Mode being used by this Game Object.
             * Can be either `ScaleModes.LINEAR` or `ScaleModes.NEAREST`.
             * @param value The Scale Mode to be used by this Game Object.
             */
            setScaleMode(value: Phaser.ScaleModes): Phaser.GameObjects.GameObject;

            /**
             * The horizontal scroll factor of this Game Object.
             * 
             * The scroll factor controls the influence of the movement of a Camera upon this Game Object.
             * 
             * When a camera scrolls it will change the location at which this Game Object is rendered on-screen.
             * It does not change the Game Objects actual position values.
             * 
             * A value of 1 means it will move exactly in sync with a camera.
             * A value of 0 means it will not move at all, even if the camera moves.
             * Other values control the degree to which the camera movement is mapped to this Game Object.
             */
            scrollFactorX: number;

            /**
             * The vertical scroll factor of this Game Object.
             * 
             * The scroll factor controls the influence of the movement of a Camera upon this Game Object.
             * 
             * When a camera scrolls it will change the location at which this Game Object is rendered on-screen.
             * It does not change the Game Objects actual position values.
             * 
             * A value of 1 means it will move exactly in sync with a camera.
             * A value of 0 means it will not move at all, even if the camera moves.
             * Other values control the degree to which the camera movement is mapped to this Game Object.
             */
            scrollFactorY: number;

            /**
             * Sets the scroll factor of this Game Object.
             * 
             * The scroll factor controls the influence of the movement of a Camera upon this Game Object.
             * 
             * When a camera scrolls it will change the location at which this Game Object is rendered on-screen.
             * It does not change the Game Objects actual position values.
             * 
             * A value of 1 means it will move exactly in sync with a camera.
             * A value of 0 means it will not move at all, even if the camera moves.
             * Other values control the degree to which the camera movement is mapped to this Game Object.
             * @param x The horizontal scroll factor of this Game Object.
             * @param y The vertical scroll factor of this Game Object. If not set it will use the `x` value. Default x.
             */
            setScrollFactor(x: number, y?: number): Phaser.GameObjects.GameObject;

            /**
             * The native (un-scaled) width of this Game Object.
             */
            width: number;

            /**
             * The native (un-scaled) height of this Game Object.
             */
            height: number;

            /**
             * The displayed width of this Game Object.
             * This value takes into account the scale factor.
             */
            displayWidth: number;

            /**
             * The displayed height of this Game Object.
             * This value takes into account the scale factor.
             */
            displayHeight: number;

            /**
             * Sets the size of this Game Object to be that of the given Frame.
             * @param frame The frame to base the size of this Game Object on.
             */
            setSizeToFrame(frame: Phaser.Textures.Frame): Phaser.GameObjects.GameObject;

            /**
             * Sets the size of this Game Object.
             * @param width The width of this Game Object.
             * @param height The height of this Game Object.
             */
            setSize(width: number, height: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the display size of this Game Object.
             * Calling this will adjust the scale.
             * @param width The width of this Game Object.
             * @param height The height of this Game Object.
             */
            setDisplaySize(width: number, height: number): Phaser.GameObjects.GameObject;

            /**
             * The Texture this Game Object is using to render with.
             */
            texture: Phaser.Textures.Texture;

            /**
             * The Texture Frame this Game Object is using to render with.
             */
            frame: Phaser.Textures.Frame;

            /**
             * Sets the texture and frame this Game Object will use to render with.
             * 
             * Textures are referenced by their string-based keys, as stored in the Texture Manager.
             * @param key The key of the texture to be used, as stored in the Texture Manager.
             * @param frame The name or index of the frame within the Texture.
             */
            setTexture(key: string, frame?: string | integer): Phaser.GameObjects.GameObject;

            /**
             * Sets the frame this Game Object will use to render with.
             * 
             * The Frame has to belong to the current Texture being used.
             * 
             * It can be either a string or an index.
             * 
             * Calling `setFrame` will modify the `width` and `height` properties of your Game Object.
             * It will also change the `origin` if the Frame has a custom pivot point, as exported from packages like Texture Packer.
             * @param frame The name or index of the frame within the Texture.
             * @param updateSize Should this call adjust the size of the Game Object? Default true.
             * @param updateOrigin Should this call adjust the origin of the Game Object? Default true.
             */
            setFrame(frame: string | integer, updateSize?: boolean, updateOrigin?: boolean): Phaser.GameObjects.GameObject;

            /**
             * Clears all tint values associated with this Game Object.
             * Immediately sets the alpha levels back to 0xffffff (no tint)
             */
            clearTint(): Phaser.GameObjects.GameObject;

            /**
             * Sets the tint values for this Game Object.
             * @param topLeft The tint being applied to the top-left of the Game Object. If not other values are given this value is applied evenly, tinting the whole Game Object. Default 0xffffff.
             * @param topRight The tint being applied to the top-right of the Game Object.
             * @param bottomLeft The tint being applied to the bottom-left of the Game Object.
             * @param bottomRight The tint being applied to the bottom-right of the Game Object.
             */
            setTint(topLeft?: integer, topRight?: integer, bottomLeft?: integer, bottomRight?: integer): Phaser.GameObjects.GameObject;

            /**
             * The tint value being applied to the top-left of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            tintTopLeft: integer;

            /**
             * The tint value being applied to the top-right of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            tintTopRight: integer;

            /**
             * The tint value being applied to the bottom-left of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            tintBottomLeft: integer;

            /**
             * The tint value being applied to the bottom-right of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            tintBottomRight: integer;

            /**
             * The tint value being applied to the whole of the Game Object.
             */
            tint: integer;

            /**
             * The x position of this Game Object.
             */
            x: number;

            /**
             * The y position of this Game Object.
             */
            y: number;

            /**
             * The z position of this Game Object.
             * Note: Do not use this value to set the z-index, instead see the `depth` property.
             */
            z: number;

            /**
             * The w position of this Game Object.
             */
            w: number;

            /**
             * The horizontal scale of this Game Object.
             */
            scaleX: number;

            /**
             * The vertical scale of this Game Object.
             */
            scaleY: number;

            /**
             * The angle of this Game Object as expressed in degrees.
             * 
             * Where 0 is to the right, 90 is down, 180 is left.
             * 
             * If you prefer to work in radians, see the `rotation` property instead.
             */
            angle: integer;

            /**
             * The angle of this Game Object in radians.
             * 
             * If you prefer to work in degrees, see the `angle` property instead.
             */
            rotation: number;

            /**
             * Sets the position of this Game Object.
             * @param x The x position of this Game Object. Default 0.
             * @param y The y position of this Game Object. If not set it will use the `x` value.
             * @param z The z position of this Game Object. Default 0.
             * @param w The w position of this Game Object. Default 0.
             */
            setPosition(x?: number, y?: number, z?: number, w?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the rotation of this Game Object.
             * @param radians The rotation of this Game Object, in radians. Default 0.
             */
            setRotation(radians?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the angle of this Game Object.
             * @param degrees The rotation of this Game Object, in degrees. Default 0.
             */
            setAngle(degrees?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the scale of this Game Object.
             * @param x The horizontal scale of this Game Object.
             * @param y The vertical scale of this Game Object. If not set it will use the `x` value. Default x.
             */
            setScale(x: number, y?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the x position of this Game Object.
             * @param value The x position of this Game Object. Default 0.
             */
            setX(value?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the y position of this Game Object.
             * @param value The y position of this Game Object. Default 0.
             */
            setY(value?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the z position of this Game Object.
             * @param value The z position of this Game Object. Default 0.
             */
            setZ(value?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the w position of this Game Object.
             * @param value The w position of this Game Object. Default 0.
             */
            setW(value?: number): Phaser.GameObjects.GameObject;

            /**
             * The visible state of the Game Object.
             * 
             * An invisible Game Object will skip rendering, but will still process update logic.
             */
            visible: boolean;

            /**
             * Sets the visibility of this Game Object.
             * 
             * An invisible Game Object will skip rendering, but will still process update logic.
             * @param value The visible state of the Game Object.
             */
            setVisible(value: boolean): Phaser.GameObjects.GameObject;

        }

        /**
         * [description]
         */
        class Light {
            /**
             * 
             * @param x The horizontal position of the light.
             * @param y The vertical position of the light.
             * @param radius The radius of the light.
             * @param r The red color. A value between 0 and 1.
             * @param g The green color. A value between 0 and 1.
             * @param b The blue color. A value between 0 and 1.
             * @param intensity The intensity of the light.
             */
            constructor(x: number, y: number, radius: number, r: number, g: number, b: number, intensity: number);

            /**
             * [description]
             */
            x: number;

            /**
             * [description]
             */
            y: number;

            /**
             * [description]
             */
            radius: number;

            /**
             * [description]
             */
            r: number;

            /**
             * [description]
             */
            g: number;

            /**
             * [description]
             */
            b: number;

            /**
             * [description]
             */
            intensity: number;

            /**
             * [description]
             */
            scrollFactorX: number;

            /**
             * [description]
             */
            scrollFactorY: number;

            /**
             * [description]
             * @param x The horizontal position of the light.
             * @param y The vertical position of the light.
             * @param radius The radius of the light.
             * @param r The red color. A value between 0 and 1.
             * @param g The green color. A value between 0 and 1.
             * @param b The blue color. A value between 0 and 1.
             * @param intensity The intensity of the light.
             */
            set(x: number, y: number, radius: number, r: number, g: number, b: number, intensity: number): Phaser.GameObjects.Light;

            /**
             * [description]
             * @param x The horizontal scroll factor of the light.
             * @param y The vertical scroll factor of the light.
             */
            setScrollFactor(x: number, y: number): Phaser.GameObjects.Light;

            /**
             * [description]
             * @param rgb [description]
             */
            setColor(rgb: number): Phaser.GameObjects.Light;

            /**
             * [description]
             * @param intensity [description]
             */
            setIntensity(intensity: number): Phaser.GameObjects.Light;

            /**
             * [description]
             * @param x The horizontal position of the light.
             * @param y The vertical position of the light.
             */
            setPosition(x: number, y: number): Phaser.GameObjects.Light;

            /**
             * [description]
             * @param radius [description]
             */
            setRadius(radius: number): Phaser.GameObjects.Light;

        }

        /**
         * [description]
         */
        class LightsManager {
            /**
             * [description]
             */
            lightPool: Phaser.GameObjects.Light[];

            /**
             * [description]
             */
            lights: Phaser.GameObjects.Light[];

            /**
             * [description]
             */
            culledLights: Phaser.GameObjects.Light[];

            /**
             * [description]
             */
            ambientColor: Object;

            /**
             * [description]
             */
            active: boolean;

            /**
             * [description]
             */
            enable(): Phaser.GameObjects.LightsManager;

            /**
             * [description]
             */
            disable(): Phaser.GameObjects.LightsManager;

            /**
             * [description]
             * @param camera [description]
             */
            cull(camera: Phaser.Cameras.Scene2D.Camera): Phaser.GameObjects.Light[];

            /**
             * [description]
             * @param callback [description]
             */
            forEachLight(callback: LightForEach): Phaser.GameObjects.LightsManager;

            /**
             * [description]
             * @param rgb [description]
             */
            setAmbientColor(rgb: number): Phaser.GameObjects.LightsManager;

            /**
             * Returns the maximum number of Lights allowed to appear at once.
             */
            getMaxVisibleLights(): integer;

            /**
             * [description]
             */
            getLightCount(): integer;

            /**
             * [description]
             * @param x [description]
             * @param y [description]
             * @param radius [description]
             * @param rgb [description]
             * @param intensity [description]
             */
            addLight(x: number, y: number, radius: number, rgb: number, intensity: number): Phaser.GameObjects.Light;

            /**
             * [description]
             * @param light [description]
             */
            removeLight(light: Phaser.GameObjects.Light): Phaser.GameObjects.LightsManager;

            /**
             * [description]
             */
            shutdown(): void;

            /**
             * [description]
             */
            destroy(): void;

        }

        /**
         * [description]
         */
        class LightsPlugin extends LightsManager {
            /**
             * 
             * @param scene [description]
             */
            constructor(scene: Phaser.Scene);

            /**
             * [description]
             */
            scene: Phaser.Scene;

            /**
             * [description]
             */
            systems: Phaser.Scenes.Systems;

            /**
             * [description]
             */
            boot(): void;

            /**
             * [description]
             */
            destroy(): void;

        }

        /**
         * A Mesh Game Object.
         */
        class Mesh extends GameObject implements Components.Alpha, Components.BlendMode, Components.Depth, Components.Flip, Components.GetBounds, Components.Origin, Components.Pipeline, Components.ScaleMode, Components.Size, Components.Texture, Components.Transform, Components.Visible, Components.ScrollFactor {
            /**
             * 
             * @param scene The Scene to which this Game Object belongs. A Game Object can only belong to one Scene at a time.
             * @param x The horizontal position of this Game Object in the world.
             * @param y The vertical position of this Game Object in the world.
             * @param vertices An array containing the vertices data for this Mesh.
             * @param uv An array containing the uv data for this Mesh.
             * @param colors An array containing the color data for this Mesh.
             * @param alphas An array containing the alpha data for this Mesh.
             * @param texture The key of the Texture this Game Object will use to render with, as stored in the Texture Manager.
             * @param frame An optional frame from the Texture this Game Object is rendering with.
             */
            constructor(scene: Phaser.Scene, x: number, y: number, vertices: number[], uv: number[], colors: number[], alphas: number[], texture: string, frame?: string | integer);

            /**
             * [description]
             */
            vertices: Float32Array;

            /**
             * [description]
             */
            uv: Float32Array;

            /**
             * [description]
             */
            colors: Uint32Array;

            /**
             * [description]
             */
            alphas: Float32Array;

            /**
             * Clears all alpha values associated with this Game Object.
             * Immediately sets the alpha levels back to 1 (fully opaque)
             */
            clearAlpha(): Phaser.GameObjects.GameObject;

            /**
             * Set the Alpha level of this Game Object. The alpha controls the opacity of the Game Object as it renders.
             * Alpha values are provided as a float between 0, fully transparent, and 1, fully opaque.
             * 
             * If your game is running under WebGL you can optionally specify four different alpha values, each of which
             * correspond to the four corners of the Game Object. Under Canvas only the `topLeft` value given is used.
             * @param topLeft The alpha value used for the top-left of the Game Object. If this is the only value given it's applied across the whole Game Object. Default 1.
             * @param topRight The alpha value used for the top-right of the Game Object. WebGL only.
             * @param bottomLeft The alpha value used for the bottom-left of the Game Object. WebGL only.
             * @param bottomRight The alpha value used for the bottom-right of the Game Object. WebGL only.
             */
            setAlpha(topLeft?: number, topRight?: number, bottomLeft?: number, bottomRight?: number): Phaser.GameObjects.GameObject;

            /**
             * The alpha value of the Game Object.
             * 
             * This is a global value, impacting the entire Game Object, not just a region of it.
             */
            alpha: number;

            /**
             * The alpha value starting from the top-left of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            alphaTopLeft: number;

            /**
             * The alpha value starting from the top-right of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            alphaTopRight: number;

            /**
             * The alpha value starting from the bottom-left of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            alphaBottomLeft: number;

            /**
             * The alpha value starting from the bottom-right of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            alphaBottomRight: number;

            /**
             * Sets the Blend Mode being used by this Game Object.
             * 
             * This can be a const, such as `Phaser.BlendModes.SCREEN`, or an integer, such as 4 (for Overlay)
             * 
             * Under WebGL only the following Blend Modes are available:
             * 
             * * ADD
             * * MULTIPLY
             * * SCREEN
             * 
             * Canvas has more available depending on browser support.
             * 
             * You can also create your own custom Blend Modes in WebGL.
             * 
             * Blend modes have different effects under Canvas and WebGL, and from browser to browser, depending
             * on support. Blend Modes also cause a WebGL batch flush should it encounter a new blend mode. For these
             * reasons try to be careful about the construction of your Scene and the frequency of which blend modes
             * are used.
             */
            blendMode: Phaser.BlendModes | string;

            /**
             * Sets the Blend Mode being used by this Game Object.
             * 
             * This can be a const, such as `Phaser.BlendModes.SCREEN`, or an integer, such as 4 (for Overlay)
             * 
             * Under WebGL only the following Blend Modes are available:
             * 
             * * ADD
             * * MULTIPLY
             * * SCREEN
             * 
             * Canvas has more available depending on browser support.
             * 
             * You can also create your own custom Blend Modes in WebGL.
             * 
             * Blend modes have different effects under Canvas and WebGL, and from browser to browser, depending
             * on support. Blend Modes also cause a WebGL batch flush should it encounter a new blend mode. For these
             * reasons try to be careful about the construction of your Scene and the frequency of which blend modes
             * are used.
             * @param value The BlendMode value. Either a string or a CONST.
             */
            setBlendMode(value: string | Phaser.BlendModes): Phaser.GameObjects.GameObject;

            /**
             * The depth of this Game Object within the Scene.
             * 
             * The depth is also known as the 'z-index' in some environments, and allows you to change the rendering order
             * of Game Objects, without actually moving their position in the display list.
             * 
             * The depth starts from zero (the default value) and increases from that point. A Game Object with a higher depth
             * value will always render in front of one with a lower value.
             * 
             * Setting the depth will queue a depth sort event within the Scene.
             */
            depth: number;

            /**
             * The depth of this Game Object within the Scene.
             * 
             * The depth is also known as the 'z-index' in some environments, and allows you to change the rendering order
             * of Game Objects, without actually moving their position in the display list.
             * 
             * The depth starts from zero (the default value) and increases from that point. A Game Object with a higher depth
             * value will always render in front of one with a lower value.
             * 
             * Setting the depth will queue a depth sort event within the Scene.
             * @param value The depth of this Game Object.
             */
            setDepth(value: integer): Phaser.GameObjects.GameObject;

            /**
             * The horizontally flipped state of the Game Object.
             * A Game Object that is flipped horizontally will render inversed on the horizontal axis.
             * Flipping always takes place from the middle of the texture and does not impact the scale value.
             */
            flipX: boolean;

            /**
             * The vertically flipped state of the Game Object.
             * A Game Object that is flipped vertically will render inversed on the vertical axis (i.e. upside down)
             * Flipping always takes place from the middle of the texture and does not impact the scale value.
             */
            flipY: boolean;

            /**
             * Toggles the horizontal flipped state of this Game Object.
             */
            toggleFlipX(): Phaser.GameObjects.GameObject;

            /**
             * Toggles the vertical flipped state of this Game Object.
             */
            toggleFlipY(): Phaser.GameObjects.GameObject;

            /**
             * Sets the horizontal flipped state of this Game Object.
             * @param value The flipped state. `false` for no flip, or `true` to be flipped.
             */
            setFlipX(value: boolean): Phaser.GameObjects.GameObject;

            /**
             * Sets the vertical flipped state of this Game Object.
             * @param value The flipped state. `false` for no flip, or `true` to be flipped.
             */
            setFlipY(value: boolean): Phaser.GameObjects.GameObject;

            /**
             * Sets the horizontal and vertical flipped state of this Game Object.
             * @param x The horizontal flipped state. `false` for no flip, or `true` to be flipped.
             * @param y The horizontal flipped state. `false` for no flip, or `true` to be flipped.
             */
            setFlip(x: boolean, y: boolean): Phaser.GameObjects.GameObject;

            /**
             * Resets the horizontal and vertical flipped state of this Game Object back to their default un-flipped state.
             */
            resetFlip(): Phaser.GameObjects.GameObject;

            /**
             * Gets the center coordinate of this Game Object, regardless of origin.
             * @param output An object to store the values in. If not provided a new Vector2 will be created.
             */
            getCenter<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * Gets the top-left corner coordinate of this Game Object, regardless of origin.
             * @param output An object to store the values in. If not provided a new Vector2 will be created.
             */
            getTopLeft<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * Gets the top-right corner coordinate of this Game Object, regardless of origin.
             * @param output An object to store the values in. If not provided a new Vector2 will be created.
             */
            getTopRight<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * Gets the bottom-left corner coordinate of this Game Object, regardless of origin.
             * @param output An object to store the values in. If not provided a new Vector2 will be created.
             */
            getBottomLeft<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * Gets the bottom-right corner coordinate of this Game Object, regardless of origin.
             * @param output An object to store the values in. If not provided a new Vector2 will be created.
             */
            getBottomRight<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * Gets the bounds of this Game Object, regardless of origin.
             * The values are stored and returned in a Rectangle, or Rectangle-like, object.
             * @param output An object to store the values in. If not provided a new Rectangle will be created.
             */
            getBounds<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * The horizontal origin of this Game Object.
             * The origin maps the relationship between the size and position of the Game Object.
             * The default value is 0.5, meaning all Game Objects are positioned based on their center.
             * Setting the value to 0 means the position now relates to the left of the Game Object.
             */
            originX: number;

            /**
             * The vertical origin of this Game Object.
             * The origin maps the relationship between the size and position of the Game Object.
             * The default value is 0.5, meaning all Game Objects are positioned based on their center.
             * Setting the value to 0 means the position now relates to the top of the Game Object.
             */
            originY: number;

            /**
             * The horizontal display origin of this Game Object.
             * The origin is a normalized value between 0 and 1.
             * The displayOrigin is a pixel value, based on the size of the Game Object combined with the origin.
             */
            displayOriginX: number;

            /**
             * The vertical display origin of this Game Object.
             * The origin is a normalized value between 0 and 1.
             * The displayOrigin is a pixel value, based on the size of the Game Object combined with the origin.
             */
            displayOriginY: number;

            /**
             * Sets the origin of this Game Object.
             * 
             * The values are given in the range 0 to 1.
             * @param x The horizontal origin value. Default 0.5.
             * @param y The vertical origin value. If not defined it will be set to the value of `x`. Default x.
             */
            setOrigin(x?: number, y?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the origin of this Game Object based on the Pivot values in its Frame.
             */
            setOriginFromFrame(): Phaser.GameObjects.GameObject;

            /**
             * Sets the display origin of this Game Object.
             * The difference between this and setting the origin is that you can use pixel values for setting the display origin.
             * @param x The horizontal display origin value. Default 0.
             * @param y The vertical display origin value. If not defined it will be set to the value of `x`. Default x.
             */
            setDisplayOrigin(x?: number, y?: number): Phaser.GameObjects.GameObject;

            /**
             * Updates the Display Origin cached values internally stored on this Game Object.
             * You don't usually call this directly, but it is exposed for edge-cases where you may.
             */
            updateDisplayOrigin(): Phaser.GameObjects.GameObject;

            /**
             * [description]
             */
            defaultPipeline: Phaser.Renderer.WebGL.WebGLPipeline;

            /**
             * [description]
             */
            pipeline: Phaser.Renderer.WebGL.WebGLPipeline;

            /**
             * Sets the initial WebGL Pipeline of this Game Object.
             * This should only be called during the instantiation of the Game Object.
             * @param pipelineName The name of the pipeline to set on this Game Object.
             */
            initPipeline(pipelineName: string): boolean;

            /**
             * Sets the active WebGL Pipeline of this Game Object.
             * @param pipelineName The name of the pipeline to set on this Game Object.
             */
            setPipeline(pipelineName: string): boolean;

            /**
             * Resets the WebGL Pipeline of this Game Object back to the default it was created with.
             */
            resetPipeline(): boolean;

            /**
             * Gets the name of the WebGL Pipeline this Game Object is currently using.
             */
            getPipelineName(): string;

            /**
             * The Scale Mode being used by this Game Object.
             * Can be either `ScaleModes.LINEAR` or `ScaleModes.NEAREST`.
             */
            scaleMode: Phaser.ScaleModes;

            /**
             * Sets the Scale Mode being used by this Game Object.
             * Can be either `ScaleModes.LINEAR` or `ScaleModes.NEAREST`.
             * @param value The Scale Mode to be used by this Game Object.
             */
            setScaleMode(value: Phaser.ScaleModes): Phaser.GameObjects.GameObject;

            /**
             * The native (un-scaled) width of this Game Object.
             */
            width: number;

            /**
             * The native (un-scaled) height of this Game Object.
             */
            height: number;

            /**
             * The displayed width of this Game Object.
             * This value takes into account the scale factor.
             */
            displayWidth: number;

            /**
             * The displayed height of this Game Object.
             * This value takes into account the scale factor.
             */
            displayHeight: number;

            /**
             * Sets the size of this Game Object to be that of the given Frame.
             * @param frame The frame to base the size of this Game Object on.
             */
            setSizeToFrame(frame: Phaser.Textures.Frame): Phaser.GameObjects.GameObject;

            /**
             * Sets the size of this Game Object.
             * @param width The width of this Game Object.
             * @param height The height of this Game Object.
             */
            setSize(width: number, height: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the display size of this Game Object.
             * Calling this will adjust the scale.
             * @param width The width of this Game Object.
             * @param height The height of this Game Object.
             */
            setDisplaySize(width: number, height: number): Phaser.GameObjects.GameObject;

            /**
             * The Texture this Game Object is using to render with.
             */
            texture: Phaser.Textures.Texture;

            /**
             * The Texture Frame this Game Object is using to render with.
             */
            frame: Phaser.Textures.Frame;

            /**
             * Sets the texture and frame this Game Object will use to render with.
             * 
             * Textures are referenced by their string-based keys, as stored in the Texture Manager.
             * @param key The key of the texture to be used, as stored in the Texture Manager.
             * @param frame The name or index of the frame within the Texture.
             */
            setTexture(key: string, frame?: string | integer): Phaser.GameObjects.GameObject;

            /**
             * Sets the frame this Game Object will use to render with.
             * 
             * The Frame has to belong to the current Texture being used.
             * 
             * It can be either a string or an index.
             * 
             * Calling `setFrame` will modify the `width` and `height` properties of your Game Object.
             * It will also change the `origin` if the Frame has a custom pivot point, as exported from packages like Texture Packer.
             * @param frame The name or index of the frame within the Texture.
             * @param updateSize Should this call adjust the size of the Game Object? Default true.
             * @param updateOrigin Should this call adjust the origin of the Game Object? Default true.
             */
            setFrame(frame: string | integer, updateSize?: boolean, updateOrigin?: boolean): Phaser.GameObjects.GameObject;

            /**
             * The x position of this Game Object.
             */
            x: number;

            /**
             * The y position of this Game Object.
             */
            y: number;

            /**
             * The z position of this Game Object.
             * Note: Do not use this value to set the z-index, instead see the `depth` property.
             */
            z: number;

            /**
             * The w position of this Game Object.
             */
            w: number;

            /**
             * The horizontal scale of this Game Object.
             */
            scaleX: number;

            /**
             * The vertical scale of this Game Object.
             */
            scaleY: number;

            /**
             * The angle of this Game Object as expressed in degrees.
             * 
             * Where 0 is to the right, 90 is down, 180 is left.
             * 
             * If you prefer to work in radians, see the `rotation` property instead.
             */
            angle: integer;

            /**
             * The angle of this Game Object in radians.
             * 
             * If you prefer to work in degrees, see the `angle` property instead.
             */
            rotation: number;

            /**
             * Sets the position of this Game Object.
             * @param x The x position of this Game Object. Default 0.
             * @param y The y position of this Game Object. If not set it will use the `x` value.
             * @param z The z position of this Game Object. Default 0.
             * @param w The w position of this Game Object. Default 0.
             */
            setPosition(x?: number, y?: number, z?: number, w?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the rotation of this Game Object.
             * @param radians The rotation of this Game Object, in radians. Default 0.
             */
            setRotation(radians?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the angle of this Game Object.
             * @param degrees The rotation of this Game Object, in degrees. Default 0.
             */
            setAngle(degrees?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the scale of this Game Object.
             * @param x The horizontal scale of this Game Object.
             * @param y The vertical scale of this Game Object. If not set it will use the `x` value. Default x.
             */
            setScale(x: number, y?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the x position of this Game Object.
             * @param value The x position of this Game Object. Default 0.
             */
            setX(value?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the y position of this Game Object.
             * @param value The y position of this Game Object. Default 0.
             */
            setY(value?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the z position of this Game Object.
             * @param value The z position of this Game Object. Default 0.
             */
            setZ(value?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the w position of this Game Object.
             * @param value The w position of this Game Object. Default 0.
             */
            setW(value?: number): Phaser.GameObjects.GameObject;

            /**
             * The visible state of the Game Object.
             * 
             * An invisible Game Object will skip rendering, but will still process update logic.
             */
            visible: boolean;

            /**
             * Sets the visibility of this Game Object.
             * 
             * An invisible Game Object will skip rendering, but will still process update logic.
             * @param value The visible state of the Game Object.
             */
            setVisible(value: boolean): Phaser.GameObjects.GameObject;

            /**
             * The horizontal scroll factor of this Game Object.
             * 
             * The scroll factor controls the influence of the movement of a Camera upon this Game Object.
             * 
             * When a camera scrolls it will change the location at which this Game Object is rendered on-screen.
             * It does not change the Game Objects actual position values.
             * 
             * A value of 1 means it will move exactly in sync with a camera.
             * A value of 0 means it will not move at all, even if the camera moves.
             * Other values control the degree to which the camera movement is mapped to this Game Object.
             */
            scrollFactorX: number;

            /**
             * The vertical scroll factor of this Game Object.
             * 
             * The scroll factor controls the influence of the movement of a Camera upon this Game Object.
             * 
             * When a camera scrolls it will change the location at which this Game Object is rendered on-screen.
             * It does not change the Game Objects actual position values.
             * 
             * A value of 1 means it will move exactly in sync with a camera.
             * A value of 0 means it will not move at all, even if the camera moves.
             * Other values control the degree to which the camera movement is mapped to this Game Object.
             */
            scrollFactorY: number;

            /**
             * Sets the scroll factor of this Game Object.
             * 
             * The scroll factor controls the influence of the movement of a Camera upon this Game Object.
             * 
             * When a camera scrolls it will change the location at which this Game Object is rendered on-screen.
             * It does not change the Game Objects actual position values.
             * 
             * A value of 1 means it will move exactly in sync with a camera.
             * A value of 0 means it will not move at all, even if the camera moves.
             * Other values control the degree to which the camera movement is mapped to this Game Object.
             * @param x The horizontal scroll factor of this Game Object.
             * @param y The vertical scroll factor of this Game Object. If not set it will use the `x` value. Default x.
             */
            setScrollFactor(x: number, y?: number): Phaser.GameObjects.GameObject;

        }

        namespace Particles {
            /**
             * [description]
             */
            class EmitterOp {
                /**
                 * 
                 * @param config [description]
                 * @param key [description]
                 * @param defaultValue [description]
                 * @param emitOnly [description] Default false.
                 */
                constructor(config: object, key: string, defaultValue: number, emitOnly?: boolean);

                /**
                 * [description]
                 */
                propertyKey: string;

                /**
                 * [description]
                 */
                propertyValue: number;

                /**
                 * [description]
                 */
                defaultValue: number;

                /**
                 * [description]
                 */
                steps: number;

                /**
                 * [description]
                 */
                counter: number;

                /**
                 * [description]
                 */
                start: number;

                /**
                 * [description]
                 */
                end: number;

                /**
                 * [description]
                 */
                ease: Function;

                /**
                 * [description]
                 */
                emitOnly: boolean;

                /**
                 * [description]
                 */
                onEmit: EmitterOpOnEmitCallback;

                /**
                 * [description]
                 */
                onUpdate: EmitterOpOnUpdateCallback;

                /**
                 * [description]
                 * @param config [description]
                 * @param newKey [description]
                 */
                loadConfig(config?: object, newKey?: string): void;

                /**
                 * [description]
                 */
                toJSON(): object;

                /**
                 * [description]
                 * @param value [description]
                 */
                onChange(value: number): Phaser.GameObjects.Particles.EmitterOp;

                /**
                 * [description]
                 */
                setMethods(): Phaser.GameObjects.Particles.EmitterOp;

                /**
                 * [description]
                 * @param object [description]
                 * @param key [description]
                 */
                has(object: object, key: string): boolean;

                /**
                 * [description]
                 * @param object [description]
                 * @param key1 [description]
                 * @param key2 [description]
                 */
                hasBoth(object: object, key1: string, key2: string): boolean;

                /**
                 * [description]
                 * @param object [description]
                 * @param key1 [description]
                 * @param key2 [description]
                 */
                hasEither(object: object, key1: string, key2: string): boolean;

                /**
                 * The returned value sets what the property will be at the START of the particles life, on emit.
                 * @param particle [description]
                 * @param key [description]
                 * @param value [description]
                 */
                defaultEmit(particle: Phaser.GameObjects.Particles.Particle, key: string, value: number): number;

                /**
                 * The returned value updates the property for the duration of the particles life.
                 * @param particle [description]
                 * @param key [description]
                 * @param t The T value (between 0 and 1)
                 * @param value [description]
                 */
                defaultUpdate(particle: Phaser.GameObjects.Particles.Particle, key: string, t: number, value: number): number;

                /**
                 * [description]
                 */
                staticValueEmit(): number;

                /**
                 * [description]
                 */
                staticValueUpdate(): number;

                /**
                 * [description]
                 */
                randomStaticValueEmit(): number;

                /**
                 * [description]
                 * @param particle [description]
                 * @param key [description]
                 */
                randomRangedValueEmit(particle: Phaser.GameObjects.Particles.Particle, key: string): number;

                /**
                 * [description]
                 */
                steppedEmit(): number;

                /**
                 * [description]
                 * @param particle [description]
                 * @param key [description]
                 */
                easedValueEmit(particle: Phaser.GameObjects.Particles.Particle, key: string): number;

                /**
                 * [description]
                 * @param particle [description]
                 * @param key [description]
                 * @param t The T value (between 0 and 1)
                 */
                easeValueUpdate(particle: Phaser.GameObjects.Particles.Particle, key: string, t: number): number;

            }

            /**
             * [description]
             */
            class GravityWell {
                /**
                 * 
                 * @param x The x coordinate of the Gravity Well, in world space. Default 0.
                 * @param y The y coordinate of the Gravity Well, in world space. Default 0.
                 * @param power The power of the Gravity Well. Default 0.
                 * @param epsilon [description] Default 100.
                 * @param gravity The gravitational force of this Gravity Well. Default 50.
                 */
                constructor(x?: number | GravityWellConfig, y?: number, power?: number, epsilon?: number, gravity?: number);

                /**
                 * The x coordinate of the Gravity Well, in world space.
                 */
                x: number;

                /**
                 * The y coordinate of the Gravity Well, in world space.
                 */
                y: number;

                /**
                 * The active state of the Gravity Well. An inactive Gravity Well will not influence any particles.
                 */
                active: boolean;

                /**
                 * The power of the Gravity Well.
                 */
                power: number;

                /**
                 * [description]
                 */
                epsilon: number;

                /**
                 * Takes a Particle and updates it based on the properties of this Gravity Well.
                 * @param particle The Particle to update.
                 * @param delta The delta time in ms.
                 * @param step The delta value divided by 1000.
                 */
                update(particle: Phaser.GameObjects.Particles.Particle, delta: number, step: number): void;

            }

            /**
             * [description]
             */
            class Particle {
                /**
                 * 
                 * @param emitter The Emitter to which this Particle belongs.
                 */
                constructor(emitter: Phaser.GameObjects.Particles.ParticleEmitter);

                /**
                 * The Emitter to which this Particle belongs.
                 * 
                 * A Particle can only belong to a single Emitter and is created, updated and destroyed via it.
                 */
                emitter: Phaser.GameObjects.Particles.ParticleEmitter;

                /**
                 * [description]
                 */
                frame: Phaser.Textures.Frame;

                /**
                 * [description]
                 */
                index: number;

                /**
                 * The x coordinate of this Particle.
                 */
                x: number;

                /**
                 * The y coordinate of this Particle.
                 */
                y: number;

                /**
                 * The x velocity of this Particle.
                 */
                velocityX: number;

                /**
                 * The y velocity of this Particle.
                 */
                velocityY: number;

                /**
                 * The x acceleration of this Particle.
                 */
                accelerationX: number;

                /**
                 * The y acceleration of this Particle.
                 */
                accelerationY: number;

                /**
                 * The maximum horizontal velocity this Particle can travel at.
                 */
                maxVelocityX: number;

                /**
                 * The maximum vertical velocity this Particle can travel at.
                 */
                maxVelocityY: number;

                /**
                 * The bounciness, or restitution, of this Particle.
                 */
                bounce: number;

                /**
                 * The horizontal scale of this Particle.
                 */
                scaleX: number;

                /**
                 * The vertical scale of this Particle.
                 */
                scaleY: number;

                /**
                 * The alpha value of this Particle.
                 */
                alpha: number;

                /**
                 * The angle of this Particle in degrees.
                 */
                angle: number;

                /**
                 * The angle of this Particle in radians.
                 */
                rotation: number;

                /**
                 * The horizontal scroll factor of this Particle.
                 */
                scrollFactorX: number;

                /**
                 * The vertical scroll factor of this Particle.
                 */
                scrollFactorY: number;

                /**
                 * The tint applied to this Particle.
                 */
                tint: number;

                /**
                 * [description]
                 */
                color: number;

                /**
                 * The lifespan of this Particle in ms.
                 */
                life: number;

                /**
                 * The current life of this Particle in ms.
                 */
                lifeCurrent: number;

                /**
                 * The delay applied to this Particle upon emission, in ms.
                 */
                delayCurrent: number;

                /**
                 * The normalized lifespan T value.
                 */
                lifeT: number;

                /**
                 * The data used by the ease equation.
                 */
                data: object;

                /**
                 * Checks to see if this Particle is alive and updating.
                 */
                isAlive(): boolean;

                /**
                 * Starts this Particle from the given coordinates.
                 * @param x The x coordinate to launch this Particle from.
                 * @param y The y coordinate to launch this Particle from.
                 */
                fire(x: number, y: number): void;

                /**
                 * An internal method that calculates the velocity of the Particle.
                 * @param emitter The Emitter that is updating this Particle.
                 * @param delta The delta time in ms.
                 * @param step The delta value divided by 1000.
                 * @param processors [description]
                 */
                computeVelocity(emitter: Phaser.GameObjects.Particles.ParticleEmitter, delta: number, step: number, processors: any[]): void;

                /**
                 * Checks if this Particle is still within the bounds defined by the given Emitter.
                 * 
                 * If not, and depending on the Emitter collision flags, the Particle may either stop or rebound.
                 * @param emitter The Emitter to check the bounds against.
                 */
                checkBounds(emitter: Phaser.GameObjects.Particles.ParticleEmitter): void;

                /**
                 * The main update method for this Particle.
                 * 
                 * Updates its life values, computes the velocity and repositions the Particle.
                 * @param delta The delta time in ms.
                 * @param step The delta value divided by 1000.
                 * @param processors An optional array of update processors.
                 */
                update(delta: number, step: number, processors: any[]): boolean;

            }

            /**
             * [description]
             */
            class ParticleEmitter implements Phaser.GameObjects.Components.BlendMode, Phaser.GameObjects.Components.ScrollFactor, Phaser.GameObjects.Components.Visible {
                /**
                 * 
                 * @param manager The Emitter Manager this Emitter belongs to.
                 * @param config [description]
                 */
                constructor(manager: Phaser.GameObjects.Particles.ParticleEmitterManager, config: object);

                /**
                 * The Emitter Manager this Emitter belongs to.
                 */
                manager: Phaser.GameObjects.Particles.ParticleEmitterManager;

                /**
                 * [description]
                 */
                texture: Phaser.Textures.Texture;

                /**
                 * [description]
                 */
                frames: Phaser.Textures.Frame[];

                /**
                 * [description]
                 */
                defaultFrame: Phaser.Textures.Frame;

                /**
                 * [description]
                 */
                configFastMap: object;

                /**
                 * [description]
                 */
                configOpMap: object;

                /**
                 * The name of this Game Object.
                 * 
                 * Empty by default and never populated by Phaser, this is left for developers to use.
                 */
                name: string;

                /**
                 * The Particle Class which will be emitted by this Emitter.
                 */
                particleClass: Phaser.GameObjects.Particles.Particle;

                /**
                 * [description]
                 */
                x: number;

                /**
                 * [description]
                 */
                y: number;

                /**
                 * A radial emitter will emit particles in all directions between angle min and max,
                 * using speed as the value. If set to false then this acts as a point Emitter.
                 * A point emitter will emit particles only in the direction derived from the speedX and speedY values.
                 */
                radial: boolean;

                /**
                 * [description]
                 */
                gravityX: number;

                /**
                 * [description]
                 */
                gravityY: number;

                /**
                 * [description]
                 */
                acceleration: boolean;

                /**
                 * [description]
                 */
                accelerationX: number;

                /**
                 * [description]
                 */
                accelerationY: number;

                /**
                 * [description]
                 */
                maxVelocityX: number;

                /**
                 * [description]
                 */
                maxVelocityY: number;

                /**
                 * [description]
                 */
                speedX: number;

                /**
                 * [description]
                 */
                speedY: number;

                /**
                 * [description]
                 */
                moveTo: boolean;

                /**
                 * [description]
                 */
                moveToX: number;

                /**
                 * [description]
                 */
                moveToY: number;

                /**
                 * [description]
                 */
                bounce: number;

                /**
                 * [description]
                 */
                scaleX: number;

                /**
                 * [description]
                 */
                scaleY: number;

                /**
                 * [description]
                 */
                tint: integer;

                /**
                 * [description]
                 */
                alpha: number;

                /**
                 * [description]
                 */
                lifespan: number;

                /**
                 * [description]
                 */
                angle: number;

                /**
                 * [description]
                 */
                rotate: number;

                /**
                 * [description]
                 */
                emitCallback: ParticleEmitterCallback;

                /**
                 * [description]
                 */
                emitCallbackScope: any;

                /**
                 * [description]
                 */
                deathCallback: ParticleDeathCallback;

                /**
                 * [description]
                 */
                deathCallbackScope: any;

                /**
                 * Set to hard limit the amount of particle objects this emitter is allowed to create.
                 * 0 means unlimited.
                 */
                maxParticles: number;

                /**
                 * How many particles are emitted each time the emitter updates.
                 */
                quantity: number;

                /**
                 * How many ms to wait after emission before the particles start updating.
                 */
                delay: number;

                /**
                 * How often a particle is emitted in ms (if emitter is a constant / flow emitter)
                 * If emitter is an explosion emitter this value will be -1.
                 * Anything > -1 sets this to be a flow emitter.
                 */
                frequency: number;

                /**
                 * Controls if the emitter is currently emitting particles.
                 * Already alive particles will continue to update until they expire.
                 */
                on: boolean;

                /**
                 * Newly emitted particles are added to the top of the particle list, i.e. rendered above those already alive.
                 * Set to false to send them to the back.
                 */
                particleBringToTop: boolean;

                /**
                 * [description]
                 */
                timeScale: number;

                /**
                 * [description]
                 */
                emitZone: object;

                /**
                 * [description]
                 */
                deathZone: object;

                /**
                 * [description]
                 */
                bounds: Phaser.Geom.Rectangle;

                /**
                 * [description]
                 */
                collideLeft: boolean;

                /**
                 * [description]
                 */
                collideRight: boolean;

                /**
                 * [description]
                 */
                collideTop: boolean;

                /**
                 * [description]
                 */
                collideBottom: boolean;

                /**
                 * [description]
                 */
                active: boolean;

                /**
                 * [description]
                 */
                visible: boolean;

                /**
                 * [description]
                 */
                blendMode: integer;

                /**
                 * [description]
                 */
                follow: Phaser.GameObjects.Particles.Particle;

                /**
                 * [description]
                 */
                followOffset: Phaser.Math.Vector2;

                /**
                 * [description]
                 */
                trackVisible: boolean;

                /**
                 * [description]
                 */
                currentFrame: number;

                /**
                 * [description]
                 */
                randomFrame: boolean;

                /**
                 * [description]
                 */
                frameQuantity: number;

                /**
                 * [description]
                 * @param config [description]
                 */
                fromJSON(config: object): Phaser.GameObjects.Particles.ParticleEmitter;

                /**
                 * [description]
                 * @param output [description]
                 */
                toJSON(output: object): object;

                /**
                 * [description]
                 * @param target [description]
                 * @param offsetX [description] Default 0.
                 * @param offsetY [description] Default 0.
                 * @param trackVisible [description] Default false.
                 */
                startFollow(target: Phaser.GameObjects.Particles.Particle, offsetX?: number, offsetY?: number, trackVisible?: boolean): Phaser.GameObjects.Particles.ParticleEmitter;

                /**
                 * [description]
                 */
                stopFollow(): Phaser.GameObjects.Particles.ParticleEmitter;

                /**
                 * [description]
                 */
                getFrame(): Phaser.Textures.Frame;

                /**
                 * [description]
                 * @param frames [description]
                 * @param pickRandom [description] Default true.
                 * @param quantity [description] Default 1.
                 */
                setFrame(frames: any[] | string | integer | object, pickRandom?: boolean, quantity?: integer): Phaser.GameObjects.Particles.ParticleEmitter;

                /**
                 * [description]
                 * @param value [description]
                 */
                setRadial(value: boolean): Phaser.GameObjects.Particles.ParticleEmitter;

                /**
                 * [description]
                 * @param x [description]
                 * @param y [description]
                 */
                setPosition(x: number, y: number): Phaser.GameObjects.Particles.ParticleEmitter;

                /**
                 * [description]
                 * @param x [description]
                 * @param y [description]
                 * @param width [description]
                 * @param height [description]
                 */
                setBounds(x: number | object, y: number, width: number, height: number): Phaser.GameObjects.Particles.ParticleEmitter;

                /**
                 * [description]
                 * @param value [description]
                 */
                setSpeedX(value: number): Phaser.GameObjects.Particles.ParticleEmitter;

                /**
                 * [description]
                 * @param value [description]
                 */
                setSpeedY(value: number): Phaser.GameObjects.Particles.ParticleEmitter;

                /**
                 * [description]
                 * @param value [description]
                 */
                setSpeed(value: number): Phaser.GameObjects.Particles.ParticleEmitter;

                /**
                 * [description]
                 * @param value [description]
                 */
                setScaleX(value: number): Phaser.GameObjects.Particles.ParticleEmitter;

                /**
                 * [description]
                 * @param value [description]
                 */
                setScaleY(value: number): Phaser.GameObjects.Particles.ParticleEmitter;

                /**
                 * [description]
                 * @param value [description]
                 */
                setScale(value: number): Phaser.GameObjects.Particles.ParticleEmitter;

                /**
                 * [description]
                 * @param value [description]
                 */
                setGravityX(value: number): Phaser.GameObjects.Particles.ParticleEmitter;

                /**
                 * [description]
                 * @param value [description]
                 */
                setGravityY(value: number): Phaser.GameObjects.Particles.ParticleEmitter;

                /**
                 * [description]
                 * @param x [description]
                 * @param y [description]
                 */
                setGravity(x: number, y: number): Phaser.GameObjects.Particles.ParticleEmitter;

                /**
                 * [description]
                 * @param value [description]
                 */
                setAlpha(value: number): Phaser.GameObjects.Particles.ParticleEmitter;

                /**
                 * [description]
                 * @param value [description]
                 */
                setEmitterAngle(value: number): Phaser.GameObjects.Particles.ParticleEmitter;

                /**
                 * [description]
                 * @param value [description]
                 */
                setAngle(value: number): Phaser.GameObjects.Particles.ParticleEmitter;

                /**
                 * [description]
                 * @param value [description]
                 */
                setLifespan(value: number): Phaser.GameObjects.Particles.ParticleEmitter;

                /**
                 * [description]
                 * @param quantity [description]
                 */
                setQuantity(quantity: integer): Phaser.GameObjects.Particles.ParticleEmitter;

                /**
                 * [description]
                 * @param frequency [description]
                 * @param quantity [description]
                 */
                setFrequency(frequency: number, quantity?: integer): Phaser.GameObjects.Particles.ParticleEmitter;

                /**
                 * The zone must have a function called `getPoint` that takes a particle object and sets
                 * its x and y properties accordingly then returns that object.
                 * @param zoneConfig [description]
                 */
                setEmitZone(zoneConfig?: object): Phaser.GameObjects.Particles.ParticleEmitter;

                /**
                 * [description]
                 * @param zoneConfig [description]
                 */
                setDeathZone(zoneConfig?: object): Phaser.GameObjects.Particles.ParticleEmitter;

                /**
                 * [description]
                 * @param particleCount [description]
                 */
                reserve(particleCount: integer): Phaser.GameObjects.Particles.ParticleEmitter;

                /**
                 * [description]
                 */
                getAliveParticleCount(): integer;

                /**
                 * [description]
                 */
                getDeadParticleCount(): integer;

                /**
                 * [description]
                 */
                getParticleCount(): integer;

                /**
                 * [description]
                 */
                atLimit(): boolean;

                /**
                 * [description]
                 * @param callback [description]
                 * @param context [description]
                 */
                onParticleEmit(callback: ParticleEmitterCallback, context?: any): Phaser.GameObjects.Particles.ParticleEmitter;

                /**
                 * [description]
                 * @param callback [description]
                 * @param context [description]
                 */
                onParticleDeath(callback: ParticleDeathCallback, context?: any): Phaser.GameObjects.Particles.ParticleEmitter;

                /**
                 * [description]
                 */
                killAll(): Phaser.GameObjects.Particles.ParticleEmitter;

                /**
                 * [description]
                 * @param callback [description]
                 * @param thisArg [description]
                 */
                forEachAlive(callback: ParticleEmitterCallback, thisArg: any): Phaser.GameObjects.Particles.ParticleEmitter;

                /**
                 * [description]
                 * @param callback [description]
                 * @param thisArg [description]
                 */
                forEachDead(callback: ParticleEmitterCallback, thisArg: any): Phaser.GameObjects.Particles.ParticleEmitter;

                /**
                 * [description]
                 */
                start(): Phaser.GameObjects.Particles.ParticleEmitter;

                /**
                 * [description]
                 */
                pause(): Phaser.GameObjects.Particles.ParticleEmitter;

                /**
                 * [description]
                 */
                resume(): Phaser.GameObjects.Particles.ParticleEmitter;

                /**
                 * [description]
                 */
                depthSort(): Phaser.GameObjects.Particles.ParticleEmitter;

                /**
                 * [description]
                 * @param frequency [description]
                 * @param count [description] Default 1.
                 */
                flow(frequency: number, count?: integer): Phaser.GameObjects.Particles.ParticleEmitter;

                /**
                 * [description]
                 * @param count The amount of Particles to emit.
                 * @param x The x coordinate to emit the Particles from.
                 * @param y The y coordinate to emit the Particles from.
                 */
                explode(count: integer, x: number, y: number): Phaser.GameObjects.Particles.Particle;

                /**
                 * [description]
                 * @param x The x coordinate to emit the Particles from.
                 * @param y The y coordinate to emit the Particles from.
                 * @param count The amount of Particles to emit.
                 */
                emitParticleAt(x: number, y: number, count: integer): Phaser.GameObjects.Particles.Particle;

                /**
                 * [description]
                 * @param count The amount of Particles to emit.
                 * @param x The x coordinate to emit the Particles from.
                 * @param y The y coordinate to emit the Particles from.
                 */
                emitParticle(count: integer, x: number, y: number): Phaser.GameObjects.Particles.Particle;

                /**
                 * [description]
                 * @param time The current timestamp as generated by the Request Animation Frame or SetTimeout.
                 * @param delta The delta time, in ms, elapsed since the last frame.
                 */
                preUpdate(time: integer, delta: number): void;

                /**
                 * [description]
                 * @param a [description]
                 * @param b [description]
                 */
                depthSortCallback(a: object, b: object): integer;

                /**
                 * [description]
                 * @param a [description]
                 * @param b [description]
                 */
                indexSortCallback(a: object, b: object): integer;

                /**
                 * Sets the Blend Mode being used by this Game Object.
                 * 
                 * This can be a const, such as `Phaser.BlendModes.SCREEN`, or an integer, such as 4 (for Overlay)
                 * 
                 * Under WebGL only the following Blend Modes are available:
                 * 
                 * * ADD
                 * * MULTIPLY
                 * * SCREEN
                 * 
                 * Canvas has more available depending on browser support.
                 * 
                 * You can also create your own custom Blend Modes in WebGL.
                 * 
                 * Blend modes have different effects under Canvas and WebGL, and from browser to browser, depending
                 * on support. Blend Modes also cause a WebGL batch flush should it encounter a new blend mode. For these
                 * reasons try to be careful about the construction of your Scene and the frequency of which blend modes
                 * are used.
                 * @param value The BlendMode value. Either a string or a CONST.
                 */
                setBlendMode(value: string | Phaser.BlendModes): Phaser.GameObjects.GameObject;

                /**
                 * The horizontal scroll factor of this Game Object.
                 * 
                 * The scroll factor controls the influence of the movement of a Camera upon this Game Object.
                 * 
                 * When a camera scrolls it will change the location at which this Game Object is rendered on-screen.
                 * It does not change the Game Objects actual position values.
                 * 
                 * A value of 1 means it will move exactly in sync with a camera.
                 * A value of 0 means it will not move at all, even if the camera moves.
                 * Other values control the degree to which the camera movement is mapped to this Game Object.
                 */
                scrollFactorX: number;

                /**
                 * The vertical scroll factor of this Game Object.
                 * 
                 * The scroll factor controls the influence of the movement of a Camera upon this Game Object.
                 * 
                 * When a camera scrolls it will change the location at which this Game Object is rendered on-screen.
                 * It does not change the Game Objects actual position values.
                 * 
                 * A value of 1 means it will move exactly in sync with a camera.
                 * A value of 0 means it will not move at all, even if the camera moves.
                 * Other values control the degree to which the camera movement is mapped to this Game Object.
                 */
                scrollFactorY: number;

                /**
                 * Sets the scroll factor of this Game Object.
                 * 
                 * The scroll factor controls the influence of the movement of a Camera upon this Game Object.
                 * 
                 * When a camera scrolls it will change the location at which this Game Object is rendered on-screen.
                 * It does not change the Game Objects actual position values.
                 * 
                 * A value of 1 means it will move exactly in sync with a camera.
                 * A value of 0 means it will not move at all, even if the camera moves.
                 * Other values control the degree to which the camera movement is mapped to this Game Object.
                 * @param x The horizontal scroll factor of this Game Object.
                 * @param y The vertical scroll factor of this Game Object. If not set it will use the `x` value. Default x.
                 */
                setScrollFactor(x: number, y?: number): Phaser.GameObjects.GameObject;

                /**
                 * Sets the visibility of this Game Object.
                 * 
                 * An invisible Game Object will skip rendering, but will still process update logic.
                 * @param value The visible state of the Game Object.
                 */
                setVisible(value: boolean): Phaser.GameObjects.GameObject;

            }

            /**
             * [description]
             */
            class ParticleEmitterManager {
                /**
                 * 
                 * @param scene [description]
                 * @param texture [description]
                 * @param frame [description]
                 * @param emitters [description]
                 */
                constructor(scene: Phaser.Scene, texture: string, frame: string | integer, emitters: Phaser.GameObjects.Particles.ParticleEmitter[]);

                /**
                 * [description]
                 */
                timeScale: number;

                /**
                 * [description]
                 */
                texture: Phaser.Textures.Texture;

                /**
                 * [description]
                 */
                frame: Phaser.Textures.Frame;

                /**
                 * [description]
                 */
                frameNames: Phaser.Textures.Frame[];

                /**
                 * A list of Emitters being managed by this Emitter Manager.
                 */
                emitters: Phaser.Structs.List<Phaser.GameObjects.Particles.ParticleEmitter>;

                /**
                 * A list of Gravity Wells being managed by this Emitter Manager.
                 */
                wells: Phaser.Structs.List<Phaser.GameObjects.Particles.GravityWell>;

                /**
                 * Sets the texture and frame this Game Object will use to render with.
                 * 
                 * Textures are referenced by their string-based keys, as stored in the Texture Manager.
                 * @param key The key of the texture to be used, as stored in the Texture Manager.
                 * @param frame The name or index of the frame within the Texture.
                 */
                setTexture(key: string, frame?: string | integer): Phaser.GameObjects.Particles.ParticleEmitterManager;

                /**
                 * Sets the frame this Game Object will use to render with.
                 * 
                 * The Frame has to belong to the current Texture being used.
                 * 
                 * It can be either a string or an index.
                 * @param frame The name or index of the frame within the Texture.
                 */
                setFrame(frame?: string | integer): Phaser.GameObjects.Particles.ParticleEmitterManager;

                /**
                 * [description]
                 * @param frames [description]
                 * @param emitter [description]
                 */
                setEmitterFrames(frames: Phaser.Textures.Frame | Phaser.Textures.Frame[], emitter: Phaser.GameObjects.Particles.ParticleEmitter): Phaser.GameObjects.Particles.ParticleEmitterManager;

                /**
                 * Adds an existing Particle Emitter to this Manager.
                 * @param emitter The Particle Emitter to add to this Emitter Manager.
                 */
                addEmitter(emitter: Phaser.GameObjects.Particles.ParticleEmitter): Phaser.GameObjects.Particles.ParticleEmitter;

                /**
                 * Creates a new Particle Emitter object, adds it to this Manager and returns a reference to it.
                 * @param config [description]
                 */
                createEmitter(config: object): Phaser.GameObjects.Particles.ParticleEmitter;

                /**
                 * Adds an existing Gravity Well object to this Manager.
                 * @param well The Gravity Well to add to this Emitter Manager.
                 */
                addGravityWell(well: Phaser.GameObjects.Particles.GravityWell): Phaser.GameObjects.Particles.GravityWell;

                /**
                 * Creates a new Gravity Well, adds it to this Manager and returns a reference to it.
                 * @param config [description]
                 */
                createGravityWell(config: object): Phaser.GameObjects.Particles.GravityWell;

                /**
                 * [description]
                 * @param count [description]
                 * @param x [description]
                 * @param y [description]
                 */
                emitParticle(count: integer, x: number, y: number): Phaser.GameObjects.Particles.ParticleEmitterManager;

                /**
                 * [description]
                 * @param x [description]
                 * @param y [description]
                 * @param count [description]
                 */
                emitParticleAt(x: number, y: number, count: integer): Phaser.GameObjects.Particles.ParticleEmitterManager;

                /**
                 * Pauses this Emitter Manager.
                 * 
                 * This has the effect of pausing all emitters, and all particles of those emitters, currently under its control.
                 * 
                 * The particles will still render, but they will not have any of their logic updated.
                 */
                pause(): Phaser.GameObjects.Particles.ParticleEmitterManager;

                /**
                 * Resumes this Emitter Manager, should it have been previously paused.
                 */
                resume(): Phaser.GameObjects.Particles.ParticleEmitterManager;

                /**
                 * [description]
                 */
                getProcessors(): Phaser.GameObjects.Particles.GravityWell[];

                /**
                 * [description]
                 * @param time The current timestamp as generated by the Request Animation Frame or SetTimeout.
                 * @param delta The delta time, in ms, elapsed since the last frame.
                 */
                preUpdate(time: integer, delta: number): void;

            }

            namespace Zones {
                /**
                 * A Death Zone.
                 * 
                 * 
                 * 
                 * A Death Zone is a special type of zone that will kill a Particle as soon as it either enters, or leaves, the zone.
                 * 
                 * 
                 * 
                 * The zone consists of a `source` which could be a Geometric shape, such as a Rectangle or Ellipse, or your own
                 * 
                 * object as long as it includes a `contains` method for which the Particles can be tested against.
                 */
                class DeathZone {
                    /**
                     * 
                     * @param source An object instance that has a `contains` method that returns a boolean when given `x` and `y` arguments.
                     * @param killOnEnter Should the Particle be killed when it enters the zone? `true` or leaves it? `false`
                     */
                    constructor(source: object, killOnEnter: boolean);

                    /**
                     * An object instance that has a `contains` method that returns a boolean when given `x` and `y` arguments.
                     * This could be a Geometry shape, such as `Phaser.Geom.Circle`, or your own custom object.
                     */
                    source: object;

                    /**
                     * Set to `true` if the Particle should be killed if it enters this zone.
                     * Set to `false` to kill the Particle if it leaves this zone.
                     */
                    killOnEnter: boolean;

                    /**
                     * Checks if the given Particle will be killed or not by this zone.
                     * @param particle The Particle to be checked against this zone.
                     */
                    willKill(particle: Phaser.GameObjects.Particles.Particle): boolean;

                }

                /**
                 * [description]
                 */
                class EdgeZone {
                    /**
                     * 
                     * @param source [description]
                     * @param quantity [description]
                     * @param stepRate [description]
                     * @param yoyo [description] Default false.
                     * @param seamless [description] Default true.
                     */
                    constructor(source: object, quantity: number, stepRate: number, yoyo?: boolean, seamless?: boolean);

                    /**
                     * [description]
                     */
                    source: object;

                    /**
                     * [description]
                     */
                    points: Phaser.Geom.Point[];

                    /**
                     * [description]
                     */
                    quantity: number;

                    /**
                     * [description]
                     */
                    stepRate: number;

                    /**
                     * [description]
                     */
                    yoyo: boolean;

                    /**
                     * [description]
                     */
                    counter: number;

                    /**
                     * [description]
                     */
                    seamless: boolean;

                    /**
                     * [description]
                     */
                    updateSource(): Phaser.GameObjects.Particles.Zones.EdgeZone;

                    /**
                     * [description]
                     * @param source [description]
                     */
                    changeSource(source: object): Phaser.GameObjects.Particles.Zones.EdgeZone;

                    /**
                     * [description]
                     * @param particle [description]
                     */
                    getPoint(particle: Phaser.GameObjects.Particles.Particle): void;

                }

                /**
                 * [description]
                 */
                class RandomZone {
                    /**
                     * 
                     * @param source [description]
                     */
                    constructor(source: object);

                    /**
                     * [description]
                     */
                    source: object;

                    /**
                     * [description]
                     * @param particle [description]
                     */
                    getPoint(particle: Phaser.GameObjects.Particles.Particle): void;

                }

            }

        }

        /**
         * A PathFollower Game Object.
         * 
         * 
         * 
         * A PathFollower is a Sprite Game Object with some extra helpers to allow it to follow a Path automatically.
         * 
         * 
         * 
         * Anything you can do with a standard Sprite can be done with this PathFollower, such as animate it, tint it,
         * 
         * scale it and so on.
         * 
         * 
         * 
         * PathFollowers are bound to a single Path at any one time and can traverse the length of the Path, from start
         * 
         * to finish, forwards or backwards, or from any given point on the Path to its end. They can optionally rotate
         * 
         * to face the direction of the path, be offset from the path coordinates or rotate independently of the Path.
         */
        class PathFollower extends Sprite {
            /**
             * 
             * @param scene [description]
             * @param path The Path this PathFollower is following. It can only follow one Path at a time.
             * @param x The horizontal position of this Game Object in the world.
             * @param y The vertical position of this Game Object in the world.
             * @param texture The key of the Texture this Game Object will use to render with, as stored in the Texture Manager.
             * @param frame An optional frame from the Texture this Game Object is rendering with.
             */
            constructor(scene: Phaser.Scene, path: Phaser.Curves.Path, x: number, y: number, texture: string, frame?: string | integer);

            /**
             * The Path this PathFollower is following. It can only follow one Path at a time.
             */
            path: Phaser.Curves.Path;

            /**
             * Should the PathFollower automatically rotate to point in the direction of the Path?
             */
            rotateToPath: boolean;

            /**
             * [description]
             */
            pathRotationVerticalAdjust: boolean;

            /**
             * If the PathFollower is rotating to match the Path (@see Phaser.GameObjects.PathFollower#rotateToPath)
             * this value is added to the rotation value. This allows you to rotate objects to a path but control
             * the angle of the rotation as well.
             */
            pathRotationOffset: number;

            /**
             * An additional vector to add to the PathFollowers position, allowing you to offset it from the
             * Path coordinates.
             */
            pathOffset: Phaser.Math.Vector2;

            /**
             * [description]
             */
            pathVector: Phaser.Math.Vector2;

            /**
             * [description]
             */
            pathTween: Phaser.Tweens.Tween;

            /**
             * [description]
             */
            pathConfig: PathConfig;

            /**
             * [description]
             * @param path The Path this PathFollower is following. It can only follow one Path at a time.
             * @param config [description]
             */
            setPath(path: Phaser.Curves.Path, config?: PathConfig): Phaser.GameObjects.PathFollower;

            /**
             * [description]
             * @param value [description]
             * @param offset Rotation offset in degrees. Default 0.
             * @param verticalAdjust [description] Default false.
             */
            setRotateToPath(value: number, offset?: number, verticalAdjust?: boolean): Phaser.GameObjects.PathFollower;

            /**
             * Is this PathFollower actively following a Path or not?
             * To be considered as `isFollowing` it must be currently moving on a Path, and not paused.
             */
            isFollowing(): boolean;

            /**
             * Starts this PathFollower following its given Path.
             * @param config [description] Default {}.
             * @param startAt [description] Default 0.
             */
            startFollow(config?: number | PathConfig, startAt?: number): Phaser.GameObjects.PathFollower;

            /**
             * Pauses this PathFollower. It will still continue to render, but it will remain motionless at the
             * point on the Path at which you paused it.
             */
            pauseFollow(): Phaser.GameObjects.PathFollower;

            /**
             * Resumes a previously paused PathFollower.
             * If the PathFollower was not paused this has no effect.
             */
            resumeFollow(): Phaser.GameObjects.PathFollower;

            /**
             * Stops this PathFollower from following the path any longer.
             * This will invoke any 'stop' conditions that may exist on the Path, or for the follower.
             */
            stopFollow(): Phaser.GameObjects.PathFollower;

            /**
             * [description]
             */
            toJSON(): JSONGameObject;

            /**
             * Clears all alpha values associated with this Game Object.
             * Immediately sets the alpha levels back to 1 (fully opaque)
             */
            clearAlpha(): Phaser.GameObjects.GameObject;

            /**
             * Set the Alpha level of this Game Object. The alpha controls the opacity of the Game Object as it renders.
             * Alpha values are provided as a float between 0, fully transparent, and 1, fully opaque.
             * 
             * If your game is running under WebGL you can optionally specify four different alpha values, each of which
             * correspond to the four corners of the Game Object. Under Canvas only the `topLeft` value given is used.
             * @param topLeft The alpha value used for the top-left of the Game Object. If this is the only value given it's applied across the whole Game Object. Default 1.
             * @param topRight The alpha value used for the top-right of the Game Object. WebGL only.
             * @param bottomLeft The alpha value used for the bottom-left of the Game Object. WebGL only.
             * @param bottomRight The alpha value used for the bottom-right of the Game Object. WebGL only.
             */
            setAlpha(topLeft?: number, topRight?: number, bottomLeft?: number, bottomRight?: number): Phaser.GameObjects.GameObject;

            /**
             * The alpha value of the Game Object.
             * 
             * This is a global value, impacting the entire Game Object, not just a region of it.
             */
            alpha: number;

            /**
             * The alpha value starting from the top-left of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            alphaTopLeft: number;

            /**
             * The alpha value starting from the top-right of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            alphaTopRight: number;

            /**
             * The alpha value starting from the bottom-left of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            alphaBottomLeft: number;

            /**
             * The alpha value starting from the bottom-right of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            alphaBottomRight: number;

            /**
             * Sets the Blend Mode being used by this Game Object.
             * 
             * This can be a const, such as `Phaser.BlendModes.SCREEN`, or an integer, such as 4 (for Overlay)
             * 
             * Under WebGL only the following Blend Modes are available:
             * 
             * * ADD
             * * MULTIPLY
             * * SCREEN
             * 
             * Canvas has more available depending on browser support.
             * 
             * You can also create your own custom Blend Modes in WebGL.
             * 
             * Blend modes have different effects under Canvas and WebGL, and from browser to browser, depending
             * on support. Blend Modes also cause a WebGL batch flush should it encounter a new blend mode. For these
             * reasons try to be careful about the construction of your Scene and the frequency of which blend modes
             * are used.
             */
            blendMode: Phaser.BlendModes | string;

            /**
             * Sets the Blend Mode being used by this Game Object.
             * 
             * This can be a const, such as `Phaser.BlendModes.SCREEN`, or an integer, such as 4 (for Overlay)
             * 
             * Under WebGL only the following Blend Modes are available:
             * 
             * * ADD
             * * MULTIPLY
             * * SCREEN
             * 
             * Canvas has more available depending on browser support.
             * 
             * You can also create your own custom Blend Modes in WebGL.
             * 
             * Blend modes have different effects under Canvas and WebGL, and from browser to browser, depending
             * on support. Blend Modes also cause a WebGL batch flush should it encounter a new blend mode. For these
             * reasons try to be careful about the construction of your Scene and the frequency of which blend modes
             * are used.
             * @param value The BlendMode value. Either a string or a CONST.
             */
            setBlendMode(value: string | Phaser.BlendModes): Phaser.GameObjects.GameObject;

            /**
             * The depth of this Game Object within the Scene.
             * 
             * The depth is also known as the 'z-index' in some environments, and allows you to change the rendering order
             * of Game Objects, without actually moving their position in the display list.
             * 
             * The depth starts from zero (the default value) and increases from that point. A Game Object with a higher depth
             * value will always render in front of one with a lower value.
             * 
             * Setting the depth will queue a depth sort event within the Scene.
             */
            depth: number;

            /**
             * The depth of this Game Object within the Scene.
             * 
             * The depth is also known as the 'z-index' in some environments, and allows you to change the rendering order
             * of Game Objects, without actually moving their position in the display list.
             * 
             * The depth starts from zero (the default value) and increases from that point. A Game Object with a higher depth
             * value will always render in front of one with a lower value.
             * 
             * Setting the depth will queue a depth sort event within the Scene.
             * @param value The depth of this Game Object.
             */
            setDepth(value: integer): Phaser.GameObjects.GameObject;

            /**
             * The horizontally flipped state of the Game Object.
             * A Game Object that is flipped horizontally will render inversed on the horizontal axis.
             * Flipping always takes place from the middle of the texture and does not impact the scale value.
             */
            flipX: boolean;

            /**
             * The vertically flipped state of the Game Object.
             * A Game Object that is flipped vertically will render inversed on the vertical axis (i.e. upside down)
             * Flipping always takes place from the middle of the texture and does not impact the scale value.
             */
            flipY: boolean;

            /**
             * Toggles the horizontal flipped state of this Game Object.
             */
            toggleFlipX(): Phaser.GameObjects.GameObject;

            /**
             * Toggles the vertical flipped state of this Game Object.
             */
            toggleFlipY(): Phaser.GameObjects.GameObject;

            /**
             * Sets the horizontal flipped state of this Game Object.
             * @param value The flipped state. `false` for no flip, or `true` to be flipped.
             */
            setFlipX(value: boolean): Phaser.GameObjects.GameObject;

            /**
             * Sets the vertical flipped state of this Game Object.
             * @param value The flipped state. `false` for no flip, or `true` to be flipped.
             */
            setFlipY(value: boolean): Phaser.GameObjects.GameObject;

            /**
             * Sets the horizontal and vertical flipped state of this Game Object.
             * @param x The horizontal flipped state. `false` for no flip, or `true` to be flipped.
             * @param y The horizontal flipped state. `false` for no flip, or `true` to be flipped.
             */
            setFlip(x: boolean, y: boolean): Phaser.GameObjects.GameObject;

            /**
             * Resets the horizontal and vertical flipped state of this Game Object back to their default un-flipped state.
             */
            resetFlip(): Phaser.GameObjects.GameObject;

            /**
             * Gets the center coordinate of this Game Object, regardless of origin.
             * @param output An object to store the values in. If not provided a new Vector2 will be created.
             */
            getCenter<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * Gets the top-left corner coordinate of this Game Object, regardless of origin.
             * @param output An object to store the values in. If not provided a new Vector2 will be created.
             */
            getTopLeft<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * Gets the top-right corner coordinate of this Game Object, regardless of origin.
             * @param output An object to store the values in. If not provided a new Vector2 will be created.
             */
            getTopRight<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * Gets the bottom-left corner coordinate of this Game Object, regardless of origin.
             * @param output An object to store the values in. If not provided a new Vector2 will be created.
             */
            getBottomLeft<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * Gets the bottom-right corner coordinate of this Game Object, regardless of origin.
             * @param output An object to store the values in. If not provided a new Vector2 will be created.
             */
            getBottomRight<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * Gets the bounds of this Game Object, regardless of origin.
             * The values are stored and returned in a Rectangle, or Rectangle-like, object.
             * @param output An object to store the values in. If not provided a new Rectangle will be created.
             */
            getBounds<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * The horizontal origin of this Game Object.
             * The origin maps the relationship between the size and position of the Game Object.
             * The default value is 0.5, meaning all Game Objects are positioned based on their center.
             * Setting the value to 0 means the position now relates to the left of the Game Object.
             */
            originX: number;

            /**
             * The vertical origin of this Game Object.
             * The origin maps the relationship between the size and position of the Game Object.
             * The default value is 0.5, meaning all Game Objects are positioned based on their center.
             * Setting the value to 0 means the position now relates to the top of the Game Object.
             */
            originY: number;

            /**
             * The horizontal display origin of this Game Object.
             * The origin is a normalized value between 0 and 1.
             * The displayOrigin is a pixel value, based on the size of the Game Object combined with the origin.
             */
            displayOriginX: number;

            /**
             * The vertical display origin of this Game Object.
             * The origin is a normalized value between 0 and 1.
             * The displayOrigin is a pixel value, based on the size of the Game Object combined with the origin.
             */
            displayOriginY: number;

            /**
             * Sets the origin of this Game Object.
             * 
             * The values are given in the range 0 to 1.
             * @param x The horizontal origin value. Default 0.5.
             * @param y The vertical origin value. If not defined it will be set to the value of `x`. Default x.
             */
            setOrigin(x?: number, y?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the origin of this Game Object based on the Pivot values in its Frame.
             */
            setOriginFromFrame(): Phaser.GameObjects.GameObject;

            /**
             * Sets the display origin of this Game Object.
             * The difference between this and setting the origin is that you can use pixel values for setting the display origin.
             * @param x The horizontal display origin value. Default 0.
             * @param y The vertical display origin value. If not defined it will be set to the value of `x`. Default x.
             */
            setDisplayOrigin(x?: number, y?: number): Phaser.GameObjects.GameObject;

            /**
             * Updates the Display Origin cached values internally stored on this Game Object.
             * You don't usually call this directly, but it is exposed for edge-cases where you may.
             */
            updateDisplayOrigin(): Phaser.GameObjects.GameObject;

            /**
             * [description]
             */
            defaultPipeline: Phaser.Renderer.WebGL.WebGLPipeline;

            /**
             * [description]
             */
            pipeline: Phaser.Renderer.WebGL.WebGLPipeline;

            /**
             * Sets the initial WebGL Pipeline of this Game Object.
             * This should only be called during the instantiation of the Game Object.
             * @param pipelineName The name of the pipeline to set on this Game Object.
             */
            initPipeline(pipelineName: string): boolean;

            /**
             * Sets the active WebGL Pipeline of this Game Object.
             * @param pipelineName The name of the pipeline to set on this Game Object.
             */
            setPipeline(pipelineName: string): boolean;

            /**
             * Resets the WebGL Pipeline of this Game Object back to the default it was created with.
             */
            resetPipeline(): boolean;

            /**
             * Gets the name of the WebGL Pipeline this Game Object is currently using.
             */
            getPipelineName(): string;

            /**
             * The Scale Mode being used by this Game Object.
             * Can be either `ScaleModes.LINEAR` or `ScaleModes.NEAREST`.
             */
            scaleMode: Phaser.ScaleModes;

            /**
             * Sets the Scale Mode being used by this Game Object.
             * Can be either `ScaleModes.LINEAR` or `ScaleModes.NEAREST`.
             * @param value The Scale Mode to be used by this Game Object.
             */
            setScaleMode(value: Phaser.ScaleModes): Phaser.GameObjects.GameObject;

            /**
             * The horizontal scroll factor of this Game Object.
             * 
             * The scroll factor controls the influence of the movement of a Camera upon this Game Object.
             * 
             * When a camera scrolls it will change the location at which this Game Object is rendered on-screen.
             * It does not change the Game Objects actual position values.
             * 
             * A value of 1 means it will move exactly in sync with a camera.
             * A value of 0 means it will not move at all, even if the camera moves.
             * Other values control the degree to which the camera movement is mapped to this Game Object.
             */
            scrollFactorX: number;

            /**
             * The vertical scroll factor of this Game Object.
             * 
             * The scroll factor controls the influence of the movement of a Camera upon this Game Object.
             * 
             * When a camera scrolls it will change the location at which this Game Object is rendered on-screen.
             * It does not change the Game Objects actual position values.
             * 
             * A value of 1 means it will move exactly in sync with a camera.
             * A value of 0 means it will not move at all, even if the camera moves.
             * Other values control the degree to which the camera movement is mapped to this Game Object.
             */
            scrollFactorY: number;

            /**
             * Sets the scroll factor of this Game Object.
             * 
             * The scroll factor controls the influence of the movement of a Camera upon this Game Object.
             * 
             * When a camera scrolls it will change the location at which this Game Object is rendered on-screen.
             * It does not change the Game Objects actual position values.
             * 
             * A value of 1 means it will move exactly in sync with a camera.
             * A value of 0 means it will not move at all, even if the camera moves.
             * Other values control the degree to which the camera movement is mapped to this Game Object.
             * @param x The horizontal scroll factor of this Game Object.
             * @param y The vertical scroll factor of this Game Object. If not set it will use the `x` value. Default x.
             */
            setScrollFactor(x: number, y?: number): Phaser.GameObjects.GameObject;

            /**
             * The native (un-scaled) width of this Game Object.
             */
            width: number;

            /**
             * The native (un-scaled) height of this Game Object.
             */
            height: number;

            /**
             * The displayed width of this Game Object.
             * This value takes into account the scale factor.
             */
            displayWidth: number;

            /**
             * The displayed height of this Game Object.
             * This value takes into account the scale factor.
             */
            displayHeight: number;

            /**
             * Sets the size of this Game Object to be that of the given Frame.
             * @param frame The frame to base the size of this Game Object on.
             */
            setSizeToFrame(frame: Phaser.Textures.Frame): Phaser.GameObjects.GameObject;

            /**
             * Sets the size of this Game Object.
             * @param width The width of this Game Object.
             * @param height The height of this Game Object.
             */
            setSize(width: number, height: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the display size of this Game Object.
             * Calling this will adjust the scale.
             * @param width The width of this Game Object.
             * @param height The height of this Game Object.
             */
            setDisplaySize(width: number, height: number): Phaser.GameObjects.GameObject;

            /**
             * The Texture this Game Object is using to render with.
             */
            texture: Phaser.Textures.Texture;

            /**
             * The Texture Frame this Game Object is using to render with.
             */
            frame: Phaser.Textures.Frame;

            /**
             * Sets the texture and frame this Game Object will use to render with.
             * 
             * Textures are referenced by their string-based keys, as stored in the Texture Manager.
             * @param key The key of the texture to be used, as stored in the Texture Manager.
             * @param frame The name or index of the frame within the Texture.
             */
            setTexture(key: string, frame?: string | integer): Phaser.GameObjects.GameObject;

            /**
             * Sets the frame this Game Object will use to render with.
             * 
             * The Frame has to belong to the current Texture being used.
             * 
             * It can be either a string or an index.
             * 
             * Calling `setFrame` will modify the `width` and `height` properties of your Game Object.
             * It will also change the `origin` if the Frame has a custom pivot point, as exported from packages like Texture Packer.
             * @param frame The name or index of the frame within the Texture.
             * @param updateSize Should this call adjust the size of the Game Object? Default true.
             * @param updateOrigin Should this call adjust the origin of the Game Object? Default true.
             */
            setFrame(frame: string | integer, updateSize?: boolean, updateOrigin?: boolean): Phaser.GameObjects.GameObject;

            /**
             * Clears all tint values associated with this Game Object.
             * Immediately sets the alpha levels back to 0xffffff (no tint)
             */
            clearTint(): Phaser.GameObjects.GameObject;

            /**
             * Sets the tint values for this Game Object.
             * @param topLeft The tint being applied to the top-left of the Game Object. If not other values are given this value is applied evenly, tinting the whole Game Object. Default 0xffffff.
             * @param topRight The tint being applied to the top-right of the Game Object.
             * @param bottomLeft The tint being applied to the bottom-left of the Game Object.
             * @param bottomRight The tint being applied to the bottom-right of the Game Object.
             */
            setTint(topLeft?: integer, topRight?: integer, bottomLeft?: integer, bottomRight?: integer): Phaser.GameObjects.GameObject;

            /**
             * The tint value being applied to the top-left of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            tintTopLeft: integer;

            /**
             * The tint value being applied to the top-right of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            tintTopRight: integer;

            /**
             * The tint value being applied to the bottom-left of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            tintBottomLeft: integer;

            /**
             * The tint value being applied to the bottom-right of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            tintBottomRight: integer;

            /**
             * The tint value being applied to the whole of the Game Object.
             */
            tint: integer;

            /**
             * The x position of this Game Object.
             */
            x: number;

            /**
             * The y position of this Game Object.
             */
            y: number;

            /**
             * The z position of this Game Object.
             * Note: Do not use this value to set the z-index, instead see the `depth` property.
             */
            z: number;

            /**
             * The w position of this Game Object.
             */
            w: number;

            /**
             * The horizontal scale of this Game Object.
             */
            scaleX: number;

            /**
             * The vertical scale of this Game Object.
             */
            scaleY: number;

            /**
             * The angle of this Game Object as expressed in degrees.
             * 
             * Where 0 is to the right, 90 is down, 180 is left.
             * 
             * If you prefer to work in radians, see the `rotation` property instead.
             */
            angle: integer;

            /**
             * The angle of this Game Object in radians.
             * 
             * If you prefer to work in degrees, see the `angle` property instead.
             */
            rotation: number;

            /**
             * Sets the position of this Game Object.
             * @param x The x position of this Game Object. Default 0.
             * @param y The y position of this Game Object. If not set it will use the `x` value.
             * @param z The z position of this Game Object. Default 0.
             * @param w The w position of this Game Object. Default 0.
             */
            setPosition(x?: number, y?: number, z?: number, w?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the rotation of this Game Object.
             * @param radians The rotation of this Game Object, in radians. Default 0.
             */
            setRotation(radians?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the angle of this Game Object.
             * @param degrees The rotation of this Game Object, in degrees. Default 0.
             */
            setAngle(degrees?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the scale of this Game Object.
             * @param x The horizontal scale of this Game Object.
             * @param y The vertical scale of this Game Object. If not set it will use the `x` value. Default x.
             */
            setScale(x: number, y?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the x position of this Game Object.
             * @param value The x position of this Game Object. Default 0.
             */
            setX(value?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the y position of this Game Object.
             * @param value The y position of this Game Object. Default 0.
             */
            setY(value?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the z position of this Game Object.
             * @param value The z position of this Game Object. Default 0.
             */
            setZ(value?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the w position of this Game Object.
             * @param value The w position of this Game Object. Default 0.
             */
            setW(value?: number): Phaser.GameObjects.GameObject;

            /**
             * The visible state of the Game Object.
             * 
             * An invisible Game Object will skip rendering, but will still process update logic.
             */
            visible: boolean;

            /**
             * Sets the visibility of this Game Object.
             * 
             * An invisible Game Object will skip rendering, but will still process update logic.
             * @param value The visible state of the Game Object.
             */
            setVisible(value: boolean): Phaser.GameObjects.GameObject;

        }

        /**
         * A Quad Game Object.
         * 
         * 
         * 
         * A Quad is a Mesh Game Object pre-configured with two triangles arranged into a rectangle, with a single
         * 
         * texture spread across them.
         * 
         * 
         * 
         * You can manipulate the corner points of the quad via the getters and setters such as `topLeftX`, and also
         * 
         * change their alpha and color values. The quad itself can be moved by adjusting the `x` and `y` properties.
         */
        class Quad extends Mesh {
            /**
             * 
             * @param scene [description]
             * @param x The horizontal position of this Game Object in the world.
             * @param y The vertical position of this Game Object in the world.
             * @param texture The key of the Texture this Game Object will use to render with, as stored in the Texture Manager.
             * @param frame An optional frame from the Texture this Game Object is rendering with.
             */
            constructor(scene: Phaser.Scene, x: number, y: number, texture: string, frame?: string | integer);

            /**
             * The top-left x vertex of this Quad.
             */
            topLeftX: number;

            /**
             * The top-left y vertex of this Quad.
             */
            topLeftY: number;

            /**
             * The top-right x vertex of this Quad.
             */
            topRightX: number;

            /**
             * The top-right y vertex of this Quad.
             */
            topRightY: number;

            /**
             * The bottom-left x vertex of this Quad.
             */
            bottomLeftX: number;

            /**
             * The bottom-left y vertex of this Quad.
             */
            bottomLeftY: number;

            /**
             * The bottom-right x vertex of this Quad.
             */
            bottomRightX: number;

            /**
             * The bottom-right y vertex of this Quad.
             */
            bottomRightY: number;

            /**
             * The top-left alpha value of this Quad.
             */
            topLeftAlpha: number;

            /**
             * The top-right alpha value of this Quad.
             */
            topRightAlpha: number;

            /**
             * The bottom-left alpha value of this Quad.
             */
            bottomLeftAlpha: number;

            /**
             * The bottom-right alpha value of this Quad.
             */
            bottomRightAlpha: number;

            /**
             * The top-left color value of this Quad.
             */
            topLeftColor: number;

            /**
             * The top-right color value of this Quad.
             */
            topRightColor: number;

            /**
             * The bottom-left color value of this Quad.
             */
            bottomLeftColor: number;

            /**
             * The bottom-right color value of this Quad.
             */
            bottomRightColor: number;

            /**
             * Sets the top-left vertex position of this Quad.
             * @param x The horizontal coordinate of the vertex.
             * @param y The vertical coordinate of the vertex.
             */
            setTopLeft(x: number, y: number): Phaser.GameObjects.Quad;

            /**
             * Sets the top-right vertex position of this Quad.
             * @param x The horizontal coordinate of the vertex.
             * @param y The vertical coordinate of the vertex.
             */
            setTopRight(x: number, y: number): Phaser.GameObjects.Quad;

            /**
             * Sets the bottom-left vertex position of this Quad.
             * @param x The horizontal coordinate of the vertex.
             * @param y The vertical coordinate of the vertex.
             */
            setBottomLeft(x: number, y: number): Phaser.GameObjects.Quad;

            /**
             * Sets the bottom-right vertex position of this Quad.
             * @param x The horizontal coordinate of the vertex.
             * @param y The vertical coordinate of the vertex.
             */
            setBottomRight(x: number, y: number): Phaser.GameObjects.Quad;

            /**
             * Resets the positions of the four corner vertices of this Quad.
             */
            resetPosition(): Phaser.GameObjects.Quad;

            /**
             * Resets the alpha values used by this Quad back to 1.
             */
            resetAlpha(): Phaser.GameObjects.Quad;

            /**
             * Resets the color values used by this Quad back to 0xffffff.
             */
            resetColors(): Phaser.GameObjects.Quad;

            /**
             * Resets the position, alpha and color values used by this Quad.
             */
            reset(): Phaser.GameObjects.Quad;

            /**
             * Clears all alpha values associated with this Game Object.
             * Immediately sets the alpha levels back to 1 (fully opaque)
             */
            clearAlpha(): Phaser.GameObjects.GameObject;

            /**
             * Set the Alpha level of this Game Object. The alpha controls the opacity of the Game Object as it renders.
             * Alpha values are provided as a float between 0, fully transparent, and 1, fully opaque.
             * 
             * If your game is running under WebGL you can optionally specify four different alpha values, each of which
             * correspond to the four corners of the Game Object. Under Canvas only the `topLeft` value given is used.
             * @param topLeft The alpha value used for the top-left of the Game Object. If this is the only value given it's applied across the whole Game Object. Default 1.
             * @param topRight The alpha value used for the top-right of the Game Object. WebGL only.
             * @param bottomLeft The alpha value used for the bottom-left of the Game Object. WebGL only.
             * @param bottomRight The alpha value used for the bottom-right of the Game Object. WebGL only.
             */
            setAlpha(topLeft?: number, topRight?: number, bottomLeft?: number, bottomRight?: number): Phaser.GameObjects.GameObject;

            /**
             * The alpha value of the Game Object.
             * 
             * This is a global value, impacting the entire Game Object, not just a region of it.
             */
            alpha: number;

            /**
             * The alpha value starting from the top-left of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            alphaTopLeft: number;

            /**
             * The alpha value starting from the top-right of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            alphaTopRight: number;

            /**
             * The alpha value starting from the bottom-left of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            alphaBottomLeft: number;

            /**
             * The alpha value starting from the bottom-right of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            alphaBottomRight: number;

            /**
             * Sets the Blend Mode being used by this Game Object.
             * 
             * This can be a const, such as `Phaser.BlendModes.SCREEN`, or an integer, such as 4 (for Overlay)
             * 
             * Under WebGL only the following Blend Modes are available:
             * 
             * * ADD
             * * MULTIPLY
             * * SCREEN
             * 
             * Canvas has more available depending on browser support.
             * 
             * You can also create your own custom Blend Modes in WebGL.
             * 
             * Blend modes have different effects under Canvas and WebGL, and from browser to browser, depending
             * on support. Blend Modes also cause a WebGL batch flush should it encounter a new blend mode. For these
             * reasons try to be careful about the construction of your Scene and the frequency of which blend modes
             * are used.
             */
            blendMode: Phaser.BlendModes | string;

            /**
             * Sets the Blend Mode being used by this Game Object.
             * 
             * This can be a const, such as `Phaser.BlendModes.SCREEN`, or an integer, such as 4 (for Overlay)
             * 
             * Under WebGL only the following Blend Modes are available:
             * 
             * * ADD
             * * MULTIPLY
             * * SCREEN
             * 
             * Canvas has more available depending on browser support.
             * 
             * You can also create your own custom Blend Modes in WebGL.
             * 
             * Blend modes have different effects under Canvas and WebGL, and from browser to browser, depending
             * on support. Blend Modes also cause a WebGL batch flush should it encounter a new blend mode. For these
             * reasons try to be careful about the construction of your Scene and the frequency of which blend modes
             * are used.
             * @param value The BlendMode value. Either a string or a CONST.
             */
            setBlendMode(value: string | Phaser.BlendModes): Phaser.GameObjects.GameObject;

            /**
             * The depth of this Game Object within the Scene.
             * 
             * The depth is also known as the 'z-index' in some environments, and allows you to change the rendering order
             * of Game Objects, without actually moving their position in the display list.
             * 
             * The depth starts from zero (the default value) and increases from that point. A Game Object with a higher depth
             * value will always render in front of one with a lower value.
             * 
             * Setting the depth will queue a depth sort event within the Scene.
             */
            depth: number;

            /**
             * The depth of this Game Object within the Scene.
             * 
             * The depth is also known as the 'z-index' in some environments, and allows you to change the rendering order
             * of Game Objects, without actually moving their position in the display list.
             * 
             * The depth starts from zero (the default value) and increases from that point. A Game Object with a higher depth
             * value will always render in front of one with a lower value.
             * 
             * Setting the depth will queue a depth sort event within the Scene.
             * @param value The depth of this Game Object.
             */
            setDepth(value: integer): Phaser.GameObjects.GameObject;

            /**
             * The horizontally flipped state of the Game Object.
             * A Game Object that is flipped horizontally will render inversed on the horizontal axis.
             * Flipping always takes place from the middle of the texture and does not impact the scale value.
             */
            flipX: boolean;

            /**
             * The vertically flipped state of the Game Object.
             * A Game Object that is flipped vertically will render inversed on the vertical axis (i.e. upside down)
             * Flipping always takes place from the middle of the texture and does not impact the scale value.
             */
            flipY: boolean;

            /**
             * Toggles the horizontal flipped state of this Game Object.
             */
            toggleFlipX(): Phaser.GameObjects.GameObject;

            /**
             * Toggles the vertical flipped state of this Game Object.
             */
            toggleFlipY(): Phaser.GameObjects.GameObject;

            /**
             * Sets the horizontal flipped state of this Game Object.
             * @param value The flipped state. `false` for no flip, or `true` to be flipped.
             */
            setFlipX(value: boolean): Phaser.GameObjects.GameObject;

            /**
             * Sets the vertical flipped state of this Game Object.
             * @param value The flipped state. `false` for no flip, or `true` to be flipped.
             */
            setFlipY(value: boolean): Phaser.GameObjects.GameObject;

            /**
             * Sets the horizontal and vertical flipped state of this Game Object.
             * @param x The horizontal flipped state. `false` for no flip, or `true` to be flipped.
             * @param y The horizontal flipped state. `false` for no flip, or `true` to be flipped.
             */
            setFlip(x: boolean, y: boolean): Phaser.GameObjects.GameObject;

            /**
             * Resets the horizontal and vertical flipped state of this Game Object back to their default un-flipped state.
             */
            resetFlip(): Phaser.GameObjects.GameObject;

            /**
             * Gets the center coordinate of this Game Object, regardless of origin.
             * @param output An object to store the values in. If not provided a new Vector2 will be created.
             */
            getCenter<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * Gets the top-left corner coordinate of this Game Object, regardless of origin.
             * @param output An object to store the values in. If not provided a new Vector2 will be created.
             */
            getTopLeft<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * Gets the top-right corner coordinate of this Game Object, regardless of origin.
             * @param output An object to store the values in. If not provided a new Vector2 will be created.
             */
            getTopRight<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * Gets the bottom-left corner coordinate of this Game Object, regardless of origin.
             * @param output An object to store the values in. If not provided a new Vector2 will be created.
             */
            getBottomLeft<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * Gets the bottom-right corner coordinate of this Game Object, regardless of origin.
             * @param output An object to store the values in. If not provided a new Vector2 will be created.
             */
            getBottomRight<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * Gets the bounds of this Game Object, regardless of origin.
             * The values are stored and returned in a Rectangle, or Rectangle-like, object.
             * @param output An object to store the values in. If not provided a new Rectangle will be created.
             */
            getBounds<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * The horizontal origin of this Game Object.
             * The origin maps the relationship between the size and position of the Game Object.
             * The default value is 0.5, meaning all Game Objects are positioned based on their center.
             * Setting the value to 0 means the position now relates to the left of the Game Object.
             */
            originX: number;

            /**
             * The vertical origin of this Game Object.
             * The origin maps the relationship between the size and position of the Game Object.
             * The default value is 0.5, meaning all Game Objects are positioned based on their center.
             * Setting the value to 0 means the position now relates to the top of the Game Object.
             */
            originY: number;

            /**
             * The horizontal display origin of this Game Object.
             * The origin is a normalized value between 0 and 1.
             * The displayOrigin is a pixel value, based on the size of the Game Object combined with the origin.
             */
            displayOriginX: number;

            /**
             * The vertical display origin of this Game Object.
             * The origin is a normalized value between 0 and 1.
             * The displayOrigin is a pixel value, based on the size of the Game Object combined with the origin.
             */
            displayOriginY: number;

            /**
             * Sets the origin of this Game Object.
             * 
             * The values are given in the range 0 to 1.
             * @param x The horizontal origin value. Default 0.5.
             * @param y The vertical origin value. If not defined it will be set to the value of `x`. Default x.
             */
            setOrigin(x?: number, y?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the origin of this Game Object based on the Pivot values in its Frame.
             */
            setOriginFromFrame(): Phaser.GameObjects.GameObject;

            /**
             * Sets the display origin of this Game Object.
             * The difference between this and setting the origin is that you can use pixel values for setting the display origin.
             * @param x The horizontal display origin value. Default 0.
             * @param y The vertical display origin value. If not defined it will be set to the value of `x`. Default x.
             */
            setDisplayOrigin(x?: number, y?: number): Phaser.GameObjects.GameObject;

            /**
             * Updates the Display Origin cached values internally stored on this Game Object.
             * You don't usually call this directly, but it is exposed for edge-cases where you may.
             */
            updateDisplayOrigin(): Phaser.GameObjects.GameObject;

            /**
             * [description]
             */
            defaultPipeline: Phaser.Renderer.WebGL.WebGLPipeline;

            /**
             * [description]
             */
            pipeline: Phaser.Renderer.WebGL.WebGLPipeline;

            /**
             * Sets the initial WebGL Pipeline of this Game Object.
             * This should only be called during the instantiation of the Game Object.
             * @param pipelineName The name of the pipeline to set on this Game Object.
             */
            initPipeline(pipelineName: string): boolean;

            /**
             * Sets the active WebGL Pipeline of this Game Object.
             * @param pipelineName The name of the pipeline to set on this Game Object.
             */
            setPipeline(pipelineName: string): boolean;

            /**
             * Resets the WebGL Pipeline of this Game Object back to the default it was created with.
             */
            resetPipeline(): boolean;

            /**
             * Gets the name of the WebGL Pipeline this Game Object is currently using.
             */
            getPipelineName(): string;

            /**
             * The Scale Mode being used by this Game Object.
             * Can be either `ScaleModes.LINEAR` or `ScaleModes.NEAREST`.
             */
            scaleMode: Phaser.ScaleModes;

            /**
             * Sets the Scale Mode being used by this Game Object.
             * Can be either `ScaleModes.LINEAR` or `ScaleModes.NEAREST`.
             * @param value The Scale Mode to be used by this Game Object.
             */
            setScaleMode(value: Phaser.ScaleModes): Phaser.GameObjects.GameObject;

            /**
             * The native (un-scaled) width of this Game Object.
             */
            width: number;

            /**
             * The native (un-scaled) height of this Game Object.
             */
            height: number;

            /**
             * The displayed width of this Game Object.
             * This value takes into account the scale factor.
             */
            displayWidth: number;

            /**
             * The displayed height of this Game Object.
             * This value takes into account the scale factor.
             */
            displayHeight: number;

            /**
             * Sets the size of this Game Object to be that of the given Frame.
             * @param frame The frame to base the size of this Game Object on.
             */
            setSizeToFrame(frame: Phaser.Textures.Frame): Phaser.GameObjects.GameObject;

            /**
             * Sets the size of this Game Object.
             * @param width The width of this Game Object.
             * @param height The height of this Game Object.
             */
            setSize(width: number, height: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the display size of this Game Object.
             * Calling this will adjust the scale.
             * @param width The width of this Game Object.
             * @param height The height of this Game Object.
             */
            setDisplaySize(width: number, height: number): Phaser.GameObjects.GameObject;

            /**
             * The Texture this Game Object is using to render with.
             */
            texture: Phaser.Textures.Texture;

            /**
             * The Texture Frame this Game Object is using to render with.
             */
            frame: Phaser.Textures.Frame;

            /**
             * Sets the texture and frame this Game Object will use to render with.
             * 
             * Textures are referenced by their string-based keys, as stored in the Texture Manager.
             * @param key The key of the texture to be used, as stored in the Texture Manager.
             * @param frame The name or index of the frame within the Texture.
             */
            setTexture(key: string, frame?: string | integer): Phaser.GameObjects.GameObject;

            /**
             * Sets the frame this Game Object will use to render with.
             * 
             * The Frame has to belong to the current Texture being used.
             * 
             * It can be either a string or an index.
             * 
             * Calling `setFrame` will modify the `width` and `height` properties of your Game Object.
             * It will also change the `origin` if the Frame has a custom pivot point, as exported from packages like Texture Packer.
             * @param frame The name or index of the frame within the Texture.
             * @param updateSize Should this call adjust the size of the Game Object? Default true.
             * @param updateOrigin Should this call adjust the origin of the Game Object? Default true.
             */
            setFrame(frame: string | integer, updateSize?: boolean, updateOrigin?: boolean): Phaser.GameObjects.GameObject;

            /**
             * The x position of this Game Object.
             */
            x: number;

            /**
             * The y position of this Game Object.
             */
            y: number;

            /**
             * The z position of this Game Object.
             * Note: Do not use this value to set the z-index, instead see the `depth` property.
             */
            z: number;

            /**
             * The w position of this Game Object.
             */
            w: number;

            /**
             * The horizontal scale of this Game Object.
             */
            scaleX: number;

            /**
             * The vertical scale of this Game Object.
             */
            scaleY: number;

            /**
             * The angle of this Game Object as expressed in degrees.
             * 
             * Where 0 is to the right, 90 is down, 180 is left.
             * 
             * If you prefer to work in radians, see the `rotation` property instead.
             */
            angle: integer;

            /**
             * The angle of this Game Object in radians.
             * 
             * If you prefer to work in degrees, see the `angle` property instead.
             */
            rotation: number;

            /**
             * Sets the position of this Game Object.
             * @param x The x position of this Game Object. Default 0.
             * @param y The y position of this Game Object. If not set it will use the `x` value.
             * @param z The z position of this Game Object. Default 0.
             * @param w The w position of this Game Object. Default 0.
             */
            setPosition(x?: number, y?: number, z?: number, w?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the rotation of this Game Object.
             * @param radians The rotation of this Game Object, in radians. Default 0.
             */
            setRotation(radians?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the angle of this Game Object.
             * @param degrees The rotation of this Game Object, in degrees. Default 0.
             */
            setAngle(degrees?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the scale of this Game Object.
             * @param x The horizontal scale of this Game Object.
             * @param y The vertical scale of this Game Object. If not set it will use the `x` value. Default x.
             */
            setScale(x: number, y?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the x position of this Game Object.
             * @param value The x position of this Game Object. Default 0.
             */
            setX(value?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the y position of this Game Object.
             * @param value The y position of this Game Object. Default 0.
             */
            setY(value?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the z position of this Game Object.
             * @param value The z position of this Game Object. Default 0.
             */
            setZ(value?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the w position of this Game Object.
             * @param value The w position of this Game Object. Default 0.
             */
            setW(value?: number): Phaser.GameObjects.GameObject;

            /**
             * The visible state of the Game Object.
             * 
             * An invisible Game Object will skip rendering, but will still process update logic.
             */
            visible: boolean;

            /**
             * Sets the visibility of this Game Object.
             * 
             * An invisible Game Object will skip rendering, but will still process update logic.
             * @param value The visible state of the Game Object.
             */
            setVisible(value: boolean): Phaser.GameObjects.GameObject;

            /**
             * The horizontal scroll factor of this Game Object.
             * 
             * The scroll factor controls the influence of the movement of a Camera upon this Game Object.
             * 
             * When a camera scrolls it will change the location at which this Game Object is rendered on-screen.
             * It does not change the Game Objects actual position values.
             * 
             * A value of 1 means it will move exactly in sync with a camera.
             * A value of 0 means it will not move at all, even if the camera moves.
             * Other values control the degree to which the camera movement is mapped to this Game Object.
             */
            scrollFactorX: number;

            /**
             * The vertical scroll factor of this Game Object.
             * 
             * The scroll factor controls the influence of the movement of a Camera upon this Game Object.
             * 
             * When a camera scrolls it will change the location at which this Game Object is rendered on-screen.
             * It does not change the Game Objects actual position values.
             * 
             * A value of 1 means it will move exactly in sync with a camera.
             * A value of 0 means it will not move at all, even if the camera moves.
             * Other values control the degree to which the camera movement is mapped to this Game Object.
             */
            scrollFactorY: number;

            /**
             * Sets the scroll factor of this Game Object.
             * 
             * The scroll factor controls the influence of the movement of a Camera upon this Game Object.
             * 
             * When a camera scrolls it will change the location at which this Game Object is rendered on-screen.
             * It does not change the Game Objects actual position values.
             * 
             * A value of 1 means it will move exactly in sync with a camera.
             * A value of 0 means it will not move at all, even if the camera moves.
             * Other values control the degree to which the camera movement is mapped to this Game Object.
             * @param x The horizontal scroll factor of this Game Object.
             * @param y The vertical scroll factor of this Game Object. If not set it will use the `x` value. Default x.
             */
            setScrollFactor(x: number, y?: number): Phaser.GameObjects.GameObject;

        }

        /**
         * A Render Texture.
         */
        class RenderTexture extends GameObject implements Components.Alpha, Components.BlendMode, Components.ComputedSize, Components.Depth, Components.Flip, Components.GetBounds, Components.MatrixStack, Components.Origin, Components.Pipeline, Components.ScaleMode, Components.ScrollFactor, Components.Tint, Components.Transform, Components.Visible {
            /**
             * 
             * @param scene The Scene to which this Game Object belongs. A Game Object can only belong to one Scene at a time.
             * @param x The horizontal position of this Game Object in the world.
             * @param y The vertical position of this Game Object in the world.
             * @param width The width of the Render Texture. Default 32.
             * @param height The height of the Render Texture. Default 32.
             */
            constructor(scene: Phaser.Scene, x: number, y: number, width?: integer, height?: integer);

            /**
             * A reference to either the Canvas or WebGL Renderer that the Game instance is using.
             */
            renderer: Phaser.Renderer.Canvas.CanvasRenderer | Phaser.Renderer.WebGL.WebGLRenderer;

            /**
             * [description]
             */
            globalTint: number;

            /**
             * [description]
             */
            globalAlpha: number;

            /**
             * [description]
             */
            destroy(): void;

            /**
             * [description]
             * @param tint [description]
             */
            setGlobalTint(tint: integer): Phaser.GameObjects.RenderTexture;

            /**
             * [description]
             * @param alpha [description]
             */
            setGlobalAlpha(alpha: number): Phaser.GameObjects.RenderTexture;

            /**
             * Clears all alpha values associated with this Game Object.
             * Immediately sets the alpha levels back to 1 (fully opaque)
             */
            clearAlpha(): Phaser.GameObjects.GameObject;

            /**
             * Set the Alpha level of this Game Object. The alpha controls the opacity of the Game Object as it renders.
             * Alpha values are provided as a float between 0, fully transparent, and 1, fully opaque.
             * 
             * If your game is running under WebGL you can optionally specify four different alpha values, each of which
             * correspond to the four corners of the Game Object. Under Canvas only the `topLeft` value given is used.
             * @param topLeft The alpha value used for the top-left of the Game Object. If this is the only value given it's applied across the whole Game Object. Default 1.
             * @param topRight The alpha value used for the top-right of the Game Object. WebGL only.
             * @param bottomLeft The alpha value used for the bottom-left of the Game Object. WebGL only.
             * @param bottomRight The alpha value used for the bottom-right of the Game Object. WebGL only.
             */
            setAlpha(topLeft?: number, topRight?: number, bottomLeft?: number, bottomRight?: number): Phaser.GameObjects.GameObject;

            /**
             * The alpha value of the Game Object.
             * 
             * This is a global value, impacting the entire Game Object, not just a region of it.
             */
            alpha: number;

            /**
             * The alpha value starting from the top-left of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            alphaTopLeft: number;

            /**
             * The alpha value starting from the top-right of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            alphaTopRight: number;

            /**
             * The alpha value starting from the bottom-left of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            alphaBottomLeft: number;

            /**
             * The alpha value starting from the bottom-right of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            alphaBottomRight: number;

            /**
             * Sets the Blend Mode being used by this Game Object.
             * 
             * This can be a const, such as `Phaser.BlendModes.SCREEN`, or an integer, such as 4 (for Overlay)
             * 
             * Under WebGL only the following Blend Modes are available:
             * 
             * * ADD
             * * MULTIPLY
             * * SCREEN
             * 
             * Canvas has more available depending on browser support.
             * 
             * You can also create your own custom Blend Modes in WebGL.
             * 
             * Blend modes have different effects under Canvas and WebGL, and from browser to browser, depending
             * on support. Blend Modes also cause a WebGL batch flush should it encounter a new blend mode. For these
             * reasons try to be careful about the construction of your Scene and the frequency of which blend modes
             * are used.
             */
            blendMode: Phaser.BlendModes | string;

            /**
             * Sets the Blend Mode being used by this Game Object.
             * 
             * This can be a const, such as `Phaser.BlendModes.SCREEN`, or an integer, such as 4 (for Overlay)
             * 
             * Under WebGL only the following Blend Modes are available:
             * 
             * * ADD
             * * MULTIPLY
             * * SCREEN
             * 
             * Canvas has more available depending on browser support.
             * 
             * You can also create your own custom Blend Modes in WebGL.
             * 
             * Blend modes have different effects under Canvas and WebGL, and from browser to browser, depending
             * on support. Blend Modes also cause a WebGL batch flush should it encounter a new blend mode. For these
             * reasons try to be careful about the construction of your Scene and the frequency of which blend modes
             * are used.
             * @param value The BlendMode value. Either a string or a CONST.
             */
            setBlendMode(value: string | Phaser.BlendModes): Phaser.GameObjects.GameObject;

            /**
             * The native (un-scaled) width of this Game Object.
             */
            width: number;

            /**
             * The native (un-scaled) height of this Game Object.
             */
            height: number;

            /**
             * The displayed width of this Game Object.
             * This value takes into account the scale factor.
             */
            displayWidth: number;

            /**
             * The displayed height of this Game Object.
             * This value takes into account the scale factor.
             */
            displayHeight: number;

            /**
             * Sets the size of this Game Object.
             * @param width The width of this Game Object.
             * @param height The height of this Game Object.
             */
            setSize(width: number, height: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the display size of this Game Object.
             * Calling this will adjust the scale.
             * @param width The width of this Game Object.
             * @param height The height of this Game Object.
             */
            setDisplaySize(width: number, height: number): Phaser.GameObjects.GameObject;

            /**
             * The depth of this Game Object within the Scene.
             * 
             * The depth is also known as the 'z-index' in some environments, and allows you to change the rendering order
             * of Game Objects, without actually moving their position in the display list.
             * 
             * The depth starts from zero (the default value) and increases from that point. A Game Object with a higher depth
             * value will always render in front of one with a lower value.
             * 
             * Setting the depth will queue a depth sort event within the Scene.
             */
            depth: number;

            /**
             * The depth of this Game Object within the Scene.
             * 
             * The depth is also known as the 'z-index' in some environments, and allows you to change the rendering order
             * of Game Objects, without actually moving their position in the display list.
             * 
             * The depth starts from zero (the default value) and increases from that point. A Game Object with a higher depth
             * value will always render in front of one with a lower value.
             * 
             * Setting the depth will queue a depth sort event within the Scene.
             * @param value The depth of this Game Object.
             */
            setDepth(value: integer): Phaser.GameObjects.GameObject;

            /**
             * The horizontally flipped state of the Game Object.
             * A Game Object that is flipped horizontally will render inversed on the horizontal axis.
             * Flipping always takes place from the middle of the texture and does not impact the scale value.
             */
            flipX: boolean;

            /**
             * The vertically flipped state of the Game Object.
             * A Game Object that is flipped vertically will render inversed on the vertical axis (i.e. upside down)
             * Flipping always takes place from the middle of the texture and does not impact the scale value.
             */
            flipY: boolean;

            /**
             * Toggles the horizontal flipped state of this Game Object.
             */
            toggleFlipX(): Phaser.GameObjects.GameObject;

            /**
             * Toggles the vertical flipped state of this Game Object.
             */
            toggleFlipY(): Phaser.GameObjects.GameObject;

            /**
             * Sets the horizontal flipped state of this Game Object.
             * @param value The flipped state. `false` for no flip, or `true` to be flipped.
             */
            setFlipX(value: boolean): Phaser.GameObjects.GameObject;

            /**
             * Sets the vertical flipped state of this Game Object.
             * @param value The flipped state. `false` for no flip, or `true` to be flipped.
             */
            setFlipY(value: boolean): Phaser.GameObjects.GameObject;

            /**
             * Sets the horizontal and vertical flipped state of this Game Object.
             * @param x The horizontal flipped state. `false` for no flip, or `true` to be flipped.
             * @param y The horizontal flipped state. `false` for no flip, or `true` to be flipped.
             */
            setFlip(x: boolean, y: boolean): Phaser.GameObjects.GameObject;

            /**
             * Resets the horizontal and vertical flipped state of this Game Object back to their default un-flipped state.
             */
            resetFlip(): Phaser.GameObjects.GameObject;

            /**
             * Gets the center coordinate of this Game Object, regardless of origin.
             * @param output An object to store the values in. If not provided a new Vector2 will be created.
             */
            getCenter<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * Gets the top-left corner coordinate of this Game Object, regardless of origin.
             * @param output An object to store the values in. If not provided a new Vector2 will be created.
             */
            getTopLeft<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * Gets the top-right corner coordinate of this Game Object, regardless of origin.
             * @param output An object to store the values in. If not provided a new Vector2 will be created.
             */
            getTopRight<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * Gets the bottom-left corner coordinate of this Game Object, regardless of origin.
             * @param output An object to store the values in. If not provided a new Vector2 will be created.
             */
            getBottomLeft<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * Gets the bottom-right corner coordinate of this Game Object, regardless of origin.
             * @param output An object to store the values in. If not provided a new Vector2 will be created.
             */
            getBottomRight<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * Gets the bounds of this Game Object, regardless of origin.
             * The values are stored and returned in a Rectangle, or Rectangle-like, object.
             * @param output An object to store the values in. If not provided a new Rectangle will be created.
             */
            getBounds<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * [description]
             */
            initMatrixStack(): Phaser.GameObjects.GameObject;

            /**
             * [description]
             */
            save(): Phaser.GameObjects.GameObject;

            /**
             * [description]
             */
            restore(): Phaser.GameObjects.GameObject;

            /**
             * [description]
             */
            loadIdentity(): Phaser.GameObjects.GameObject;

            /**
             * [description]
             * @param a [description]
             * @param b [description]
             * @param c [description]
             * @param d [description]
             * @param tx [description]
             * @param ty [description]
             */
            transform(a: number, b: number, c: number, d: number, tx: number, ty: number): Phaser.GameObjects.GameObject;

            /**
             * [description]
             * @param a [description]
             * @param b [description]
             * @param c [description]
             * @param d [description]
             * @param tx [description]
             * @param ty [description]
             */
            setTransform(a: number, b: number, c: number, d: number, tx: number, ty: number): Phaser.GameObjects.GameObject;

            /**
             * [description]
             * @param x [description]
             * @param y [description]
             */
            translate(x: number, y: number): Phaser.GameObjects.GameObject;

            /**
             * [description]
             * @param x [description]
             * @param y [description]
             */
            scale(x: number, y: number): Phaser.GameObjects.GameObject;

            /**
             * [description]
             * @param t The angle of rotation, in radians.
             */
            rotate(t: number): Phaser.GameObjects.GameObject;

            /**
             * The horizontal origin of this Game Object.
             * The origin maps the relationship between the size and position of the Game Object.
             * The default value is 0.5, meaning all Game Objects are positioned based on their center.
             * Setting the value to 0 means the position now relates to the left of the Game Object.
             */
            originX: number;

            /**
             * The vertical origin of this Game Object.
             * The origin maps the relationship between the size and position of the Game Object.
             * The default value is 0.5, meaning all Game Objects are positioned based on their center.
             * Setting the value to 0 means the position now relates to the top of the Game Object.
             */
            originY: number;

            /**
             * The horizontal display origin of this Game Object.
             * The origin is a normalized value between 0 and 1.
             * The displayOrigin is a pixel value, based on the size of the Game Object combined with the origin.
             */
            displayOriginX: number;

            /**
             * The vertical display origin of this Game Object.
             * The origin is a normalized value between 0 and 1.
             * The displayOrigin is a pixel value, based on the size of the Game Object combined with the origin.
             */
            displayOriginY: number;

            /**
             * Sets the origin of this Game Object.
             * 
             * The values are given in the range 0 to 1.
             * @param x The horizontal origin value. Default 0.5.
             * @param y The vertical origin value. If not defined it will be set to the value of `x`. Default x.
             */
            setOrigin(x?: number, y?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the origin of this Game Object based on the Pivot values in its Frame.
             */
            setOriginFromFrame(): Phaser.GameObjects.GameObject;

            /**
             * Sets the display origin of this Game Object.
             * The difference between this and setting the origin is that you can use pixel values for setting the display origin.
             * @param x The horizontal display origin value. Default 0.
             * @param y The vertical display origin value. If not defined it will be set to the value of `x`. Default x.
             */
            setDisplayOrigin(x?: number, y?: number): Phaser.GameObjects.GameObject;

            /**
             * Updates the Display Origin cached values internally stored on this Game Object.
             * You don't usually call this directly, but it is exposed for edge-cases where you may.
             */
            updateDisplayOrigin(): Phaser.GameObjects.GameObject;

            /**
             * [description]
             */
            defaultPipeline: Phaser.Renderer.WebGL.WebGLPipeline;

            /**
             * [description]
             */
            pipeline: Phaser.Renderer.WebGL.WebGLPipeline;

            /**
             * Sets the initial WebGL Pipeline of this Game Object.
             * This should only be called during the instantiation of the Game Object.
             * @param pipelineName The name of the pipeline to set on this Game Object.
             */
            initPipeline(pipelineName: string): boolean;

            /**
             * Sets the active WebGL Pipeline of this Game Object.
             * @param pipelineName The name of the pipeline to set on this Game Object.
             */
            setPipeline(pipelineName: string): boolean;

            /**
             * Resets the WebGL Pipeline of this Game Object back to the default it was created with.
             */
            resetPipeline(): boolean;

            /**
             * Gets the name of the WebGL Pipeline this Game Object is currently using.
             */
            getPipelineName(): string;

            /**
             * The Scale Mode being used by this Game Object.
             * Can be either `ScaleModes.LINEAR` or `ScaleModes.NEAREST`.
             */
            scaleMode: Phaser.ScaleModes;

            /**
             * Sets the Scale Mode being used by this Game Object.
             * Can be either `ScaleModes.LINEAR` or `ScaleModes.NEAREST`.
             * @param value The Scale Mode to be used by this Game Object.
             */
            setScaleMode(value: Phaser.ScaleModes): Phaser.GameObjects.GameObject;

            /**
             * The horizontal scroll factor of this Game Object.
             * 
             * The scroll factor controls the influence of the movement of a Camera upon this Game Object.
             * 
             * When a camera scrolls it will change the location at which this Game Object is rendered on-screen.
             * It does not change the Game Objects actual position values.
             * 
             * A value of 1 means it will move exactly in sync with a camera.
             * A value of 0 means it will not move at all, even if the camera moves.
             * Other values control the degree to which the camera movement is mapped to this Game Object.
             */
            scrollFactorX: number;

            /**
             * The vertical scroll factor of this Game Object.
             * 
             * The scroll factor controls the influence of the movement of a Camera upon this Game Object.
             * 
             * When a camera scrolls it will change the location at which this Game Object is rendered on-screen.
             * It does not change the Game Objects actual position values.
             * 
             * A value of 1 means it will move exactly in sync with a camera.
             * A value of 0 means it will not move at all, even if the camera moves.
             * Other values control the degree to which the camera movement is mapped to this Game Object.
             */
            scrollFactorY: number;

            /**
             * Sets the scroll factor of this Game Object.
             * 
             * The scroll factor controls the influence of the movement of a Camera upon this Game Object.
             * 
             * When a camera scrolls it will change the location at which this Game Object is rendered on-screen.
             * It does not change the Game Objects actual position values.
             * 
             * A value of 1 means it will move exactly in sync with a camera.
             * A value of 0 means it will not move at all, even if the camera moves.
             * Other values control the degree to which the camera movement is mapped to this Game Object.
             * @param x The horizontal scroll factor of this Game Object.
             * @param y The vertical scroll factor of this Game Object. If not set it will use the `x` value. Default x.
             */
            setScrollFactor(x: number, y?: number): Phaser.GameObjects.GameObject;

            /**
             * Clears all tint values associated with this Game Object.
             * Immediately sets the alpha levels back to 0xffffff (no tint)
             */
            clearTint(): Phaser.GameObjects.GameObject;

            /**
             * Sets the tint values for this Game Object.
             * @param topLeft The tint being applied to the top-left of the Game Object. If not other values are given this value is applied evenly, tinting the whole Game Object. Default 0xffffff.
             * @param topRight The tint being applied to the top-right of the Game Object.
             * @param bottomLeft The tint being applied to the bottom-left of the Game Object.
             * @param bottomRight The tint being applied to the bottom-right of the Game Object.
             */
            setTint(topLeft?: integer, topRight?: integer, bottomLeft?: integer, bottomRight?: integer): Phaser.GameObjects.GameObject;

            /**
             * The tint value being applied to the top-left of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            tintTopLeft: integer;

            /**
             * The tint value being applied to the top-right of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            tintTopRight: integer;

            /**
             * The tint value being applied to the bottom-left of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            tintBottomLeft: integer;

            /**
             * The tint value being applied to the bottom-right of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            tintBottomRight: integer;

            /**
             * The tint value being applied to the whole of the Game Object.
             */
            tint: integer;

            /**
             * The x position of this Game Object.
             */
            x: number;

            /**
             * The y position of this Game Object.
             */
            y: number;

            /**
             * The z position of this Game Object.
             * Note: Do not use this value to set the z-index, instead see the `depth` property.
             */
            z: number;

            /**
             * The w position of this Game Object.
             */
            w: number;

            /**
             * The horizontal scale of this Game Object.
             */
            scaleX: number;

            /**
             * The vertical scale of this Game Object.
             */
            scaleY: number;

            /**
             * The angle of this Game Object as expressed in degrees.
             * 
             * Where 0 is to the right, 90 is down, 180 is left.
             * 
             * If you prefer to work in radians, see the `rotation` property instead.
             */
            angle: integer;

            /**
             * The angle of this Game Object in radians.
             * 
             * If you prefer to work in degrees, see the `angle` property instead.
             */
            rotation: number;

            /**
             * Sets the position of this Game Object.
             * @param x The x position of this Game Object. Default 0.
             * @param y The y position of this Game Object. If not set it will use the `x` value.
             * @param z The z position of this Game Object. Default 0.
             * @param w The w position of this Game Object. Default 0.
             */
            setPosition(x?: number, y?: number, z?: number, w?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the rotation of this Game Object.
             * @param radians The rotation of this Game Object, in radians. Default 0.
             */
            setRotation(radians?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the angle of this Game Object.
             * @param degrees The rotation of this Game Object, in degrees. Default 0.
             */
            setAngle(degrees?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the scale of this Game Object.
             * @param x The horizontal scale of this Game Object.
             * @param y The vertical scale of this Game Object. If not set it will use the `x` value. Default x.
             */
            setScale(x: number, y?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the x position of this Game Object.
             * @param value The x position of this Game Object. Default 0.
             */
            setX(value?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the y position of this Game Object.
             * @param value The y position of this Game Object. Default 0.
             */
            setY(value?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the z position of this Game Object.
             * @param value The z position of this Game Object. Default 0.
             */
            setZ(value?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the w position of this Game Object.
             * @param value The w position of this Game Object. Default 0.
             */
            setW(value?: number): Phaser.GameObjects.GameObject;

            /**
             * The visible state of the Game Object.
             * 
             * An invisible Game Object will skip rendering, but will still process update logic.
             */
            visible: boolean;

            /**
             * Sets the visibility of this Game Object.
             * 
             * An invisible Game Object will skip rendering, but will still process update logic.
             * @param value The visible state of the Game Object.
             */
            setVisible(value: boolean): Phaser.GameObjects.GameObject;

        }

        /**
         * A Sprite Game Object.
         * 
         * 
         * 
         * A Sprite Game Object is used for the display of both static and animated images in your game.
         * 
         * Sprites can have input events and physics bodies. They can also be tweened, tinted, scrolled
         * 
         * and animated.
         * 
         * 
         * 
         * The main difference between a Sprite and an Image Game Object is that you cannot animate Images.
         * 
         * As such, Sprites take a fraction longer to process and have a larger API footprint due to the Animation
         * 
         * Component. If you do not require animation then you can safely use Images to replace Sprites in all cases.
         */
        class Sprite extends GameObject implements Components.Alpha, Components.BlendMode, Components.Depth, Components.Flip, Components.GetBounds, Components.Origin, Components.Pipeline, Components.ScaleMode, Components.ScrollFactor, Components.Size, Components.Texture, Components.Tint, Components.Transform, Components.Visible {
            /**
             * 
             * @param scene The Scene to which this Game Object belongs. A Game Object can only belong to one Scene at a time.
             * @param x The horizontal position of this Game Object in the world.
             * @param y The vertical position of this Game Object in the world.
             * @param texture The key of the Texture this Game Object will use to render with, as stored in the Texture Manager.
             * @param frame An optional frame from the Texture this Game Object is rendering with.
             */
            constructor(scene: Phaser.Scene, x: number, y: number, texture: string, frame?: string | integer);

            /**
             * [description]
             */
            anims: Phaser.GameObjects.Components.Animation;

            /**
             * [description]
             * @param time [description]
             * @param delta [description]
             */
            preUpdate(time: number, delta: number): void;

            /**
             * [description]
             * @param key [description]
             * @param ignoreIfPlaying [description] Default false.
             * @param startFrame [description] Default 0.
             */
            play(key: string, ignoreIfPlaying?: boolean, startFrame?: integer): Phaser.GameObjects.Sprite;

            /**
             * Clears all alpha values associated with this Game Object.
             * Immediately sets the alpha levels back to 1 (fully opaque)
             */
            clearAlpha(): Phaser.GameObjects.GameObject;

            /**
             * Set the Alpha level of this Game Object. The alpha controls the opacity of the Game Object as it renders.
             * Alpha values are provided as a float between 0, fully transparent, and 1, fully opaque.
             * 
             * If your game is running under WebGL you can optionally specify four different alpha values, each of which
             * correspond to the four corners of the Game Object. Under Canvas only the `topLeft` value given is used.
             * @param topLeft The alpha value used for the top-left of the Game Object. If this is the only value given it's applied across the whole Game Object. Default 1.
             * @param topRight The alpha value used for the top-right of the Game Object. WebGL only.
             * @param bottomLeft The alpha value used for the bottom-left of the Game Object. WebGL only.
             * @param bottomRight The alpha value used for the bottom-right of the Game Object. WebGL only.
             */
            setAlpha(topLeft?: number, topRight?: number, bottomLeft?: number, bottomRight?: number): Phaser.GameObjects.GameObject;

            /**
             * The alpha value of the Game Object.
             * 
             * This is a global value, impacting the entire Game Object, not just a region of it.
             */
            alpha: number;

            /**
             * The alpha value starting from the top-left of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            alphaTopLeft: number;

            /**
             * The alpha value starting from the top-right of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            alphaTopRight: number;

            /**
             * The alpha value starting from the bottom-left of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            alphaBottomLeft: number;

            /**
             * The alpha value starting from the bottom-right of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            alphaBottomRight: number;

            /**
             * Sets the Blend Mode being used by this Game Object.
             * 
             * This can be a const, such as `Phaser.BlendModes.SCREEN`, or an integer, such as 4 (for Overlay)
             * 
             * Under WebGL only the following Blend Modes are available:
             * 
             * * ADD
             * * MULTIPLY
             * * SCREEN
             * 
             * Canvas has more available depending on browser support.
             * 
             * You can also create your own custom Blend Modes in WebGL.
             * 
             * Blend modes have different effects under Canvas and WebGL, and from browser to browser, depending
             * on support. Blend Modes also cause a WebGL batch flush should it encounter a new blend mode. For these
             * reasons try to be careful about the construction of your Scene and the frequency of which blend modes
             * are used.
             */
            blendMode: Phaser.BlendModes | string;

            /**
             * Sets the Blend Mode being used by this Game Object.
             * 
             * This can be a const, such as `Phaser.BlendModes.SCREEN`, or an integer, such as 4 (for Overlay)
             * 
             * Under WebGL only the following Blend Modes are available:
             * 
             * * ADD
             * * MULTIPLY
             * * SCREEN
             * 
             * Canvas has more available depending on browser support.
             * 
             * You can also create your own custom Blend Modes in WebGL.
             * 
             * Blend modes have different effects under Canvas and WebGL, and from browser to browser, depending
             * on support. Blend Modes also cause a WebGL batch flush should it encounter a new blend mode. For these
             * reasons try to be careful about the construction of your Scene and the frequency of which blend modes
             * are used.
             * @param value The BlendMode value. Either a string or a CONST.
             */
            setBlendMode(value: string | Phaser.BlendModes): Phaser.GameObjects.GameObject;

            /**
             * The depth of this Game Object within the Scene.
             * 
             * The depth is also known as the 'z-index' in some environments, and allows you to change the rendering order
             * of Game Objects, without actually moving their position in the display list.
             * 
             * The depth starts from zero (the default value) and increases from that point. A Game Object with a higher depth
             * value will always render in front of one with a lower value.
             * 
             * Setting the depth will queue a depth sort event within the Scene.
             */
            depth: number;

            /**
             * The depth of this Game Object within the Scene.
             * 
             * The depth is also known as the 'z-index' in some environments, and allows you to change the rendering order
             * of Game Objects, without actually moving their position in the display list.
             * 
             * The depth starts from zero (the default value) and increases from that point. A Game Object with a higher depth
             * value will always render in front of one with a lower value.
             * 
             * Setting the depth will queue a depth sort event within the Scene.
             * @param value The depth of this Game Object.
             */
            setDepth(value: integer): Phaser.GameObjects.GameObject;

            /**
             * The horizontally flipped state of the Game Object.
             * A Game Object that is flipped horizontally will render inversed on the horizontal axis.
             * Flipping always takes place from the middle of the texture and does not impact the scale value.
             */
            flipX: boolean;

            /**
             * The vertically flipped state of the Game Object.
             * A Game Object that is flipped vertically will render inversed on the vertical axis (i.e. upside down)
             * Flipping always takes place from the middle of the texture and does not impact the scale value.
             */
            flipY: boolean;

            /**
             * Toggles the horizontal flipped state of this Game Object.
             */
            toggleFlipX(): Phaser.GameObjects.GameObject;

            /**
             * Toggles the vertical flipped state of this Game Object.
             */
            toggleFlipY(): Phaser.GameObjects.GameObject;

            /**
             * Sets the horizontal flipped state of this Game Object.
             * @param value The flipped state. `false` for no flip, or `true` to be flipped.
             */
            setFlipX(value: boolean): Phaser.GameObjects.GameObject;

            /**
             * Sets the vertical flipped state of this Game Object.
             * @param value The flipped state. `false` for no flip, or `true` to be flipped.
             */
            setFlipY(value: boolean): Phaser.GameObjects.GameObject;

            /**
             * Sets the horizontal and vertical flipped state of this Game Object.
             * @param x The horizontal flipped state. `false` for no flip, or `true` to be flipped.
             * @param y The horizontal flipped state. `false` for no flip, or `true` to be flipped.
             */
            setFlip(x: boolean, y: boolean): Phaser.GameObjects.GameObject;

            /**
             * Resets the horizontal and vertical flipped state of this Game Object back to their default un-flipped state.
             */
            resetFlip(): Phaser.GameObjects.GameObject;

            /**
             * Gets the center coordinate of this Game Object, regardless of origin.
             * @param output An object to store the values in. If not provided a new Vector2 will be created.
             */
            getCenter<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * Gets the top-left corner coordinate of this Game Object, regardless of origin.
             * @param output An object to store the values in. If not provided a new Vector2 will be created.
             */
            getTopLeft<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * Gets the top-right corner coordinate of this Game Object, regardless of origin.
             * @param output An object to store the values in. If not provided a new Vector2 will be created.
             */
            getTopRight<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * Gets the bottom-left corner coordinate of this Game Object, regardless of origin.
             * @param output An object to store the values in. If not provided a new Vector2 will be created.
             */
            getBottomLeft<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * Gets the bottom-right corner coordinate of this Game Object, regardless of origin.
             * @param output An object to store the values in. If not provided a new Vector2 will be created.
             */
            getBottomRight<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * Gets the bounds of this Game Object, regardless of origin.
             * The values are stored and returned in a Rectangle, or Rectangle-like, object.
             * @param output An object to store the values in. If not provided a new Rectangle will be created.
             */
            getBounds<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * The horizontal origin of this Game Object.
             * The origin maps the relationship between the size and position of the Game Object.
             * The default value is 0.5, meaning all Game Objects are positioned based on their center.
             * Setting the value to 0 means the position now relates to the left of the Game Object.
             */
            originX: number;

            /**
             * The vertical origin of this Game Object.
             * The origin maps the relationship between the size and position of the Game Object.
             * The default value is 0.5, meaning all Game Objects are positioned based on their center.
             * Setting the value to 0 means the position now relates to the top of the Game Object.
             */
            originY: number;

            /**
             * The horizontal display origin of this Game Object.
             * The origin is a normalized value between 0 and 1.
             * The displayOrigin is a pixel value, based on the size of the Game Object combined with the origin.
             */
            displayOriginX: number;

            /**
             * The vertical display origin of this Game Object.
             * The origin is a normalized value between 0 and 1.
             * The displayOrigin is a pixel value, based on the size of the Game Object combined with the origin.
             */
            displayOriginY: number;

            /**
             * Sets the origin of this Game Object.
             * 
             * The values are given in the range 0 to 1.
             * @param x The horizontal origin value. Default 0.5.
             * @param y The vertical origin value. If not defined it will be set to the value of `x`. Default x.
             */
            setOrigin(x?: number, y?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the origin of this Game Object based on the Pivot values in its Frame.
             */
            setOriginFromFrame(): Phaser.GameObjects.GameObject;

            /**
             * Sets the display origin of this Game Object.
             * The difference between this and setting the origin is that you can use pixel values for setting the display origin.
             * @param x The horizontal display origin value. Default 0.
             * @param y The vertical display origin value. If not defined it will be set to the value of `x`. Default x.
             */
            setDisplayOrigin(x?: number, y?: number): Phaser.GameObjects.GameObject;

            /**
             * Updates the Display Origin cached values internally stored on this Game Object.
             * You don't usually call this directly, but it is exposed for edge-cases where you may.
             */
            updateDisplayOrigin(): Phaser.GameObjects.GameObject;

            /**
             * [description]
             */
            defaultPipeline: Phaser.Renderer.WebGL.WebGLPipeline;

            /**
             * [description]
             */
            pipeline: Phaser.Renderer.WebGL.WebGLPipeline;

            /**
             * Sets the initial WebGL Pipeline of this Game Object.
             * This should only be called during the instantiation of the Game Object.
             * @param pipelineName The name of the pipeline to set on this Game Object.
             */
            initPipeline(pipelineName: string): boolean;

            /**
             * Sets the active WebGL Pipeline of this Game Object.
             * @param pipelineName The name of the pipeline to set on this Game Object.
             */
            setPipeline(pipelineName: string): boolean;

            /**
             * Resets the WebGL Pipeline of this Game Object back to the default it was created with.
             */
            resetPipeline(): boolean;

            /**
             * Gets the name of the WebGL Pipeline this Game Object is currently using.
             */
            getPipelineName(): string;

            /**
             * The Scale Mode being used by this Game Object.
             * Can be either `ScaleModes.LINEAR` or `ScaleModes.NEAREST`.
             */
            scaleMode: Phaser.ScaleModes;

            /**
             * Sets the Scale Mode being used by this Game Object.
             * Can be either `ScaleModes.LINEAR` or `ScaleModes.NEAREST`.
             * @param value The Scale Mode to be used by this Game Object.
             */
            setScaleMode(value: Phaser.ScaleModes): Phaser.GameObjects.GameObject;

            /**
             * The horizontal scroll factor of this Game Object.
             * 
             * The scroll factor controls the influence of the movement of a Camera upon this Game Object.
             * 
             * When a camera scrolls it will change the location at which this Game Object is rendered on-screen.
             * It does not change the Game Objects actual position values.
             * 
             * A value of 1 means it will move exactly in sync with a camera.
             * A value of 0 means it will not move at all, even if the camera moves.
             * Other values control the degree to which the camera movement is mapped to this Game Object.
             */
            scrollFactorX: number;

            /**
             * The vertical scroll factor of this Game Object.
             * 
             * The scroll factor controls the influence of the movement of a Camera upon this Game Object.
             * 
             * When a camera scrolls it will change the location at which this Game Object is rendered on-screen.
             * It does not change the Game Objects actual position values.
             * 
             * A value of 1 means it will move exactly in sync with a camera.
             * A value of 0 means it will not move at all, even if the camera moves.
             * Other values control the degree to which the camera movement is mapped to this Game Object.
             */
            scrollFactorY: number;

            /**
             * Sets the scroll factor of this Game Object.
             * 
             * The scroll factor controls the influence of the movement of a Camera upon this Game Object.
             * 
             * When a camera scrolls it will change the location at which this Game Object is rendered on-screen.
             * It does not change the Game Objects actual position values.
             * 
             * A value of 1 means it will move exactly in sync with a camera.
             * A value of 0 means it will not move at all, even if the camera moves.
             * Other values control the degree to which the camera movement is mapped to this Game Object.
             * @param x The horizontal scroll factor of this Game Object.
             * @param y The vertical scroll factor of this Game Object. If not set it will use the `x` value. Default x.
             */
            setScrollFactor(x: number, y?: number): Phaser.GameObjects.GameObject;

            /**
             * The native (un-scaled) width of this Game Object.
             */
            width: number;

            /**
             * The native (un-scaled) height of this Game Object.
             */
            height: number;

            /**
             * The displayed width of this Game Object.
             * This value takes into account the scale factor.
             */
            displayWidth: number;

            /**
             * The displayed height of this Game Object.
             * This value takes into account the scale factor.
             */
            displayHeight: number;

            /**
             * Sets the size of this Game Object to be that of the given Frame.
             * @param frame The frame to base the size of this Game Object on.
             */
            setSizeToFrame(frame: Phaser.Textures.Frame): Phaser.GameObjects.GameObject;

            /**
             * Sets the size of this Game Object.
             * @param width The width of this Game Object.
             * @param height The height of this Game Object.
             */
            setSize(width: number, height: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the display size of this Game Object.
             * Calling this will adjust the scale.
             * @param width The width of this Game Object.
             * @param height The height of this Game Object.
             */
            setDisplaySize(width: number, height: number): Phaser.GameObjects.GameObject;

            /**
             * The Texture this Game Object is using to render with.
             */
            texture: Phaser.Textures.Texture;

            /**
             * The Texture Frame this Game Object is using to render with.
             */
            frame: Phaser.Textures.Frame;

            /**
             * Sets the texture and frame this Game Object will use to render with.
             * 
             * Textures are referenced by their string-based keys, as stored in the Texture Manager.
             * @param key The key of the texture to be used, as stored in the Texture Manager.
             * @param frame The name or index of the frame within the Texture.
             */
            setTexture(key: string, frame?: string | integer): Phaser.GameObjects.GameObject;

            /**
             * Sets the frame this Game Object will use to render with.
             * 
             * The Frame has to belong to the current Texture being used.
             * 
             * It can be either a string or an index.
             * 
             * Calling `setFrame` will modify the `width` and `height` properties of your Game Object.
             * It will also change the `origin` if the Frame has a custom pivot point, as exported from packages like Texture Packer.
             * @param frame The name or index of the frame within the Texture.
             * @param updateSize Should this call adjust the size of the Game Object? Default true.
             * @param updateOrigin Should this call adjust the origin of the Game Object? Default true.
             */
            setFrame(frame: string | integer, updateSize?: boolean, updateOrigin?: boolean): Phaser.GameObjects.GameObject;

            /**
             * Clears all tint values associated with this Game Object.
             * Immediately sets the alpha levels back to 0xffffff (no tint)
             */
            clearTint(): Phaser.GameObjects.GameObject;

            /**
             * Sets the tint values for this Game Object.
             * @param topLeft The tint being applied to the top-left of the Game Object. If not other values are given this value is applied evenly, tinting the whole Game Object. Default 0xffffff.
             * @param topRight The tint being applied to the top-right of the Game Object.
             * @param bottomLeft The tint being applied to the bottom-left of the Game Object.
             * @param bottomRight The tint being applied to the bottom-right of the Game Object.
             */
            setTint(topLeft?: integer, topRight?: integer, bottomLeft?: integer, bottomRight?: integer): Phaser.GameObjects.GameObject;

            /**
             * The tint value being applied to the top-left of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            tintTopLeft: integer;

            /**
             * The tint value being applied to the top-right of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            tintTopRight: integer;

            /**
             * The tint value being applied to the bottom-left of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            tintBottomLeft: integer;

            /**
             * The tint value being applied to the bottom-right of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            tintBottomRight: integer;

            /**
             * The tint value being applied to the whole of the Game Object.
             */
            tint: integer;

            /**
             * The x position of this Game Object.
             */
            x: number;

            /**
             * The y position of this Game Object.
             */
            y: number;

            /**
             * The z position of this Game Object.
             * Note: Do not use this value to set the z-index, instead see the `depth` property.
             */
            z: number;

            /**
             * The w position of this Game Object.
             */
            w: number;

            /**
             * The horizontal scale of this Game Object.
             */
            scaleX: number;

            /**
             * The vertical scale of this Game Object.
             */
            scaleY: number;

            /**
             * The angle of this Game Object as expressed in degrees.
             * 
             * Where 0 is to the right, 90 is down, 180 is left.
             * 
             * If you prefer to work in radians, see the `rotation` property instead.
             */
            angle: integer;

            /**
             * The angle of this Game Object in radians.
             * 
             * If you prefer to work in degrees, see the `angle` property instead.
             */
            rotation: number;

            /**
             * Sets the position of this Game Object.
             * @param x The x position of this Game Object. Default 0.
             * @param y The y position of this Game Object. If not set it will use the `x` value.
             * @param z The z position of this Game Object. Default 0.
             * @param w The w position of this Game Object. Default 0.
             */
            setPosition(x?: number, y?: number, z?: number, w?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the rotation of this Game Object.
             * @param radians The rotation of this Game Object, in radians. Default 0.
             */
            setRotation(radians?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the angle of this Game Object.
             * @param degrees The rotation of this Game Object, in degrees. Default 0.
             */
            setAngle(degrees?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the scale of this Game Object.
             * @param x The horizontal scale of this Game Object.
             * @param y The vertical scale of this Game Object. If not set it will use the `x` value. Default x.
             */
            setScale(x: number, y?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the x position of this Game Object.
             * @param value The x position of this Game Object. Default 0.
             */
            setX(value?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the y position of this Game Object.
             * @param value The y position of this Game Object. Default 0.
             */
            setY(value?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the z position of this Game Object.
             * @param value The z position of this Game Object. Default 0.
             */
            setZ(value?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the w position of this Game Object.
             * @param value The w position of this Game Object. Default 0.
             */
            setW(value?: number): Phaser.GameObjects.GameObject;

            /**
             * The visible state of the Game Object.
             * 
             * An invisible Game Object will skip rendering, but will still process update logic.
             */
            visible: boolean;

            /**
             * Sets the visibility of this Game Object.
             * 
             * An invisible Game Object will skip rendering, but will still process update logic.
             * @param value The visible state of the Game Object.
             */
            setVisible(value: boolean): Phaser.GameObjects.GameObject;

        }

        /**
         * A Sprite 3D Game Object.
         * 
         * 
         * 
         * The Sprite 3D object is an encapsulation of a standard Sprite object, with additional methods to allow
         * 
         * it to be rendered by a 3D Camera. The Sprite can be positioned anywhere within 3D space.
         */
        class Sprite3D extends GameObject {
            /**
             * 
             * @param scene The Scene to which this Game Object belongs. A Game Object can only belong to one Scene at a time.
             * @param x The x position of this Game Object.
             * @param y The y position of this Game Object.
             * @param z The z position of this Game Object.
             * @param texture The key of the Texture this Game Object will use to render with, as stored in the Texture Manager.
             * @param frame An optional frame from the Texture this Game Object is rendering with.
             */
            constructor(scene: Phaser.Scene, x: number, y: number, z: number, texture: string, frame?: string | integer);

            /**
             * [description]
             */
            gameObject: Phaser.GameObjects.GameObject;

            /**
             * [description]
             */
            position: Phaser.Math.Vector4;

            /**
             * [description]
             */
            size: Phaser.Math.Vector2;

            /**
             * [description]
             */
            scale: Phaser.Math.Vector2;

            /**
             * [description]
             */
            adjustScaleX: boolean;

            /**
             * [description]
             */
            adjustScaleY: boolean;

            /**
             * [description]
             * @param camera The 3D Camera onto which to project this Sprite.
             */
            project(camera: Phaser.Cameras.Sprite3D.Camera): void;

            /**
             * [description]
             * @param value [description]
             */
            setVisible(value: boolean): Phaser.GameObjects.Sprite3D;

            /**
             * The visible state of the Game Object.
             * 
             * An invisible Game Object will skip rendering, but will still process update logic.
             */
            visible: boolean;

            /**
             * The x position of this Game Object.
             */
            x: number;

            /**
             * The y position of this Game Object.
             */
            y: number;

            /**
             * The z position of this Game Object.
             */
            z: number;

        }

        /**
         * [description]
         */
        class Text extends GameObject implements Components.Alpha, Components.BlendMode, Components.ComputedSize, Components.Depth, Components.Flip, Components.GetBounds, Components.Origin, Components.Pipeline, Components.ScaleMode, Components.ScrollFactor, Components.Tint, Components.Transform, Components.Visible {
            /**
             * 
             * @param scene The Scene to which this Game Object belongs. A Game Object can only belong to one Scene at a time.
             * @param x The horizontal position of this Game Object in the world.
             * @param y The vertical position of this Game Object in the world.
             * @param text The text this Text object will display.
             * @param style The text style configuration object.
             */
            constructor(scene: Phaser.Scene, x: number, y: number, text: string | string[], style: object);

            /**
             * Returns an object containing dimensions of the Text object.
             * @param text The Text object to get the size from.
             * @param size [description]
             * @param lines [description]
             */
            static GetTextSize(text: Phaser.GameObjects.Text, size: number, lines: any[]): object;

            /**
             * Calculates the ascent, descent and fontSize of a given font style.
             * @param textStyle The TextStyle object to measure.
             */
            static MeasureText(textStyle: Phaser.GameObjects.Text.TextStyle): object;

            /**
             * The canvas element that the text is rendered to.
             */
            canvas: HTMLCanvasElement;

            /**
             * The context of the canvas element that the text is rendered to.
             */
            context: CanvasRenderingContext2D;

            /**
             * [description]
             */
            style: Phaser.GameObjects.Components.TextStyle;

            /**
             * [description]
             */
            autoRound: boolean;

            /**
             * The Regular Expression that is used to split the text up into lines, in
             * multi-line text. By default this is `/(?:\r\n|\r|\n)/`.
             * You can change this RegExp to be anything else that you may need.
             */
            splitRegExp: object;

            /**
             * [description]
             */
            text: string;

            /**
             * [description]
             */
            resolution: number;

            /**
             * Specify a padding value which is added to the line width and height when calculating the Text size.
             * Allows you to add extra spacing if the browser is unable to accurately determine the true font dimensions.
             */
            padding: Object;

            /**
             * [description]
             */
            width: number;

            /**
             * [description]
             */
            height: number;

            /**
             * [description]
             */
            canvasTexture: HTMLCanvasElement;

            /**
             * [description]
             */
            dirty: boolean;

            /**
             * [description]
             */
            initRTL(): void;

            /**
             * Greedy wrapping algorithm that will wrap words as the line grows longer than its horizontal
             * bounds.
             * @param text The text to perform word wrap detection against.
             */
            runWordWrap(text: string): string;

            /**
             * Advanced wrapping algorithm that will wrap words as the line grows longer than its horizontal
             * bounds. Consecutive spaces will be collapsed and replaced with a single space. Lines will be
             * trimmed of white space before processing. Throws an error if wordWrapWidth is less than a
             * single character.
             * @param text The text to perform word wrap detection against.
             * @param context [description]
             * @param wordWrapWidth [description]
             */
            advancedWordWrap(text: string, context: CanvasRenderingContext2D, wordWrapWidth: number): string;

            /**
             * Greedy wrapping algorithm that will wrap words as the line grows longer than its horizontal
             * bounds. Spaces are not collapsed and whitespace is not trimmed.
             * @param text The text to perform word wrap detection against.
             * @param context [description]
             * @param wordWrapWidth [description]
             */
            basicWordWrap(text: string, context: CanvasRenderingContext2D, wordWrapWidth: number): string;

            /**
             * Runs the given text through this Text objects word wrapping and returns the results as an
             * array, where each element of the array corresponds to a wrapped line of text.
             * @param text The text for which the wrapping will be calculated. If unspecified, the Text objects current text will be used.
             */
            getWrappedText(text: string): string[];

            /**
             * [description]
             * @param value The string, or array of strings, to be set as the content of this Text object.
             */
            setText(value: string | string[]): Phaser.GameObjects.Text;

            /**
             * [description]
             * @param style [description]
             */
            setStyle(style: object): Phaser.GameObjects.Text;

            /**
             * [description]
             * @param font [description]
             */
            setFont(font: string): Phaser.GameObjects.Text;

            /**
             * [description]
             * @param family [description]
             */
            setFontFamily(family: string): Phaser.GameObjects.Text;

            /**
             * [description]
             * @param size [description]
             */
            setFontSize(size: number): Phaser.GameObjects.Text;

            /**
             * [description]
             * @param style [description]
             */
            setFontStyle(style: string): Phaser.GameObjects.Text;

            /**
             * [description]
             * @param width [description]
             * @param height [description]
             */
            setFixedSize(width: number, height: number): Phaser.GameObjects.Text;

            /**
             * [description]
             * @param color [description]
             */
            setBackgroundColor(color: string): Phaser.GameObjects.Text;

            /**
             * [description]
             * @param color [description]
             */
            setFill(color: string): Phaser.GameObjects.Text;

            /**
             * [description]
             * @param color [description]
             */
            setColor(color: string): Phaser.GameObjects.Text;

            /**
             * [description]
             * @param color [description]
             * @param thickness [description]
             */
            setStroke(color: string, thickness: number): Phaser.GameObjects.Text;

            /**
             * [description]
             * @param x [description]
             * @param y [description]
             * @param color [description]
             * @param blur [description]
             * @param shadowStroke [description]
             * @param shadowFill [description]
             */
            setShadow(x: number, y: number, color: string, blur: number, shadowStroke: boolean, shadowFill: boolean): Phaser.GameObjects.Text;

            /**
             * [description]
             * @param x [description]
             * @param y [description]
             */
            setShadowOffset(x: number, y: number): Phaser.GameObjects.Text;

            /**
             * [description]
             * @param color [description]
             */
            setShadowColor(color: string): Phaser.GameObjects.Text;

            /**
             * [description]
             * @param blur [description]
             */
            setShadowBlur(blur: number): Phaser.GameObjects.Text;

            /**
             * [description]
             * @param enabled [description]
             */
            setShadowStroke(enabled: boolean): Phaser.GameObjects.Text;

            /**
             * [description]
             * @param enabled [description]
             */
            setShadowFill(enabled: boolean): Phaser.GameObjects.Text;

            /**
             * Set the width (in pixels) to use for wrapping lines. Pass in null to remove wrapping by width.
             * @param width The maximum width of a line in pixels. Set to null to remove wrapping.
             * @param useAdvancedWrap Whether or not to use the advanced wrapping
             * algorithm. If true, spaces are collapsed and whitespace is trimmed from lines. If false,
             * spaces and whitespace are left as is. Default false.
             */
            setWordWrapWidth(width: number, useAdvancedWrap?: boolean): Phaser.GameObjects.Text;

            /**
             * Set a custom callback for wrapping lines. Pass in null to remove wrapping by callback.
             * @param callback A custom function that will be responsible for wrapping the
             * text. It will receive two arguments: text (the string to wrap), textObject (this Text
             * instance). It should return the wrapped lines either as an array of lines or as a string with
             * newline characters in place to indicate where breaks should happen.
             * @param scope The scope that will be applied when the callback is invoked. Default null.
             */
            setWordWrapCallback(callback: TextStyleWordWrapCallback, scope?: object): Phaser.GameObjects.Text;

            /**
             * [description]
             * @param align [description]
             */
            setAlign(align: string): Phaser.GameObjects.Text;

            /**
             * 'left' can be an object.
             * If only 'left' and 'top' are given they are treated as 'x' and 'y'
             * @param left [description]
             * @param top [description]
             * @param right [description]
             * @param bottom [description]
             */
            setPadding(left: number | object, top: number, right: number, bottom: number): Phaser.GameObjects.Text;

            /**
             * [description]
             * @param max [description] Default 0.
             */
            setMaxLines(max?: integer): Phaser.GameObjects.Text;

            /**
             * [description]
             */
            updateText(): Phaser.GameObjects.Text;

            /**
             * [description]
             */
            getTextMetrics(): object;

            /**
             * [description]
             */
            preDestroy(): void;

            /**
             * Clears all alpha values associated with this Game Object.
             * Immediately sets the alpha levels back to 1 (fully opaque)
             */
            clearAlpha(): Phaser.GameObjects.GameObject;

            /**
             * Set the Alpha level of this Game Object. The alpha controls the opacity of the Game Object as it renders.
             * Alpha values are provided as a float between 0, fully transparent, and 1, fully opaque.
             * 
             * If your game is running under WebGL you can optionally specify four different alpha values, each of which
             * correspond to the four corners of the Game Object. Under Canvas only the `topLeft` value given is used.
             * @param topLeft The alpha value used for the top-left of the Game Object. If this is the only value given it's applied across the whole Game Object. Default 1.
             * @param topRight The alpha value used for the top-right of the Game Object. WebGL only.
             * @param bottomLeft The alpha value used for the bottom-left of the Game Object. WebGL only.
             * @param bottomRight The alpha value used for the bottom-right of the Game Object. WebGL only.
             */
            setAlpha(topLeft?: number, topRight?: number, bottomLeft?: number, bottomRight?: number): Phaser.GameObjects.GameObject;

            /**
             * The alpha value of the Game Object.
             * 
             * This is a global value, impacting the entire Game Object, not just a region of it.
             */
            alpha: number;

            /**
             * The alpha value starting from the top-left of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            alphaTopLeft: number;

            /**
             * The alpha value starting from the top-right of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            alphaTopRight: number;

            /**
             * The alpha value starting from the bottom-left of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            alphaBottomLeft: number;

            /**
             * The alpha value starting from the bottom-right of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            alphaBottomRight: number;

            /**
             * Sets the Blend Mode being used by this Game Object.
             * 
             * This can be a const, such as `Phaser.BlendModes.SCREEN`, or an integer, such as 4 (for Overlay)
             * 
             * Under WebGL only the following Blend Modes are available:
             * 
             * * ADD
             * * MULTIPLY
             * * SCREEN
             * 
             * Canvas has more available depending on browser support.
             * 
             * You can also create your own custom Blend Modes in WebGL.
             * 
             * Blend modes have different effects under Canvas and WebGL, and from browser to browser, depending
             * on support. Blend Modes also cause a WebGL batch flush should it encounter a new blend mode. For these
             * reasons try to be careful about the construction of your Scene and the frequency of which blend modes
             * are used.
             */
            blendMode: Phaser.BlendModes | string;

            /**
             * Sets the Blend Mode being used by this Game Object.
             * 
             * This can be a const, such as `Phaser.BlendModes.SCREEN`, or an integer, such as 4 (for Overlay)
             * 
             * Under WebGL only the following Blend Modes are available:
             * 
             * * ADD
             * * MULTIPLY
             * * SCREEN
             * 
             * Canvas has more available depending on browser support.
             * 
             * You can also create your own custom Blend Modes in WebGL.
             * 
             * Blend modes have different effects under Canvas and WebGL, and from browser to browser, depending
             * on support. Blend Modes also cause a WebGL batch flush should it encounter a new blend mode. For these
             * reasons try to be careful about the construction of your Scene and the frequency of which blend modes
             * are used.
             * @param value The BlendMode value. Either a string or a CONST.
             */
            setBlendMode(value: string | Phaser.BlendModes): Phaser.GameObjects.GameObject;

            /**
             * The displayed width of this Game Object.
             * This value takes into account the scale factor.
             */
            displayWidth: number;

            /**
             * The displayed height of this Game Object.
             * This value takes into account the scale factor.
             */
            displayHeight: number;

            /**
             * Sets the size of this Game Object.
             * @param width The width of this Game Object.
             * @param height The height of this Game Object.
             */
            setSize(width: number, height: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the display size of this Game Object.
             * Calling this will adjust the scale.
             * @param width The width of this Game Object.
             * @param height The height of this Game Object.
             */
            setDisplaySize(width: number, height: number): Phaser.GameObjects.GameObject;

            /**
             * The depth of this Game Object within the Scene.
             * 
             * The depth is also known as the 'z-index' in some environments, and allows you to change the rendering order
             * of Game Objects, without actually moving their position in the display list.
             * 
             * The depth starts from zero (the default value) and increases from that point. A Game Object with a higher depth
             * value will always render in front of one with a lower value.
             * 
             * Setting the depth will queue a depth sort event within the Scene.
             */
            depth: number;

            /**
             * The depth of this Game Object within the Scene.
             * 
             * The depth is also known as the 'z-index' in some environments, and allows you to change the rendering order
             * of Game Objects, without actually moving their position in the display list.
             * 
             * The depth starts from zero (the default value) and increases from that point. A Game Object with a higher depth
             * value will always render in front of one with a lower value.
             * 
             * Setting the depth will queue a depth sort event within the Scene.
             * @param value The depth of this Game Object.
             */
            setDepth(value: integer): Phaser.GameObjects.GameObject;

            /**
             * The horizontally flipped state of the Game Object.
             * A Game Object that is flipped horizontally will render inversed on the horizontal axis.
             * Flipping always takes place from the middle of the texture and does not impact the scale value.
             */
            flipX: boolean;

            /**
             * The vertically flipped state of the Game Object.
             * A Game Object that is flipped vertically will render inversed on the vertical axis (i.e. upside down)
             * Flipping always takes place from the middle of the texture and does not impact the scale value.
             */
            flipY: boolean;

            /**
             * Toggles the horizontal flipped state of this Game Object.
             */
            toggleFlipX(): Phaser.GameObjects.GameObject;

            /**
             * Toggles the vertical flipped state of this Game Object.
             */
            toggleFlipY(): Phaser.GameObjects.GameObject;

            /**
             * Sets the horizontal flipped state of this Game Object.
             * @param value The flipped state. `false` for no flip, or `true` to be flipped.
             */
            setFlipX(value: boolean): Phaser.GameObjects.GameObject;

            /**
             * Sets the vertical flipped state of this Game Object.
             * @param value The flipped state. `false` for no flip, or `true` to be flipped.
             */
            setFlipY(value: boolean): Phaser.GameObjects.GameObject;

            /**
             * Sets the horizontal and vertical flipped state of this Game Object.
             * @param x The horizontal flipped state. `false` for no flip, or `true` to be flipped.
             * @param y The horizontal flipped state. `false` for no flip, or `true` to be flipped.
             */
            setFlip(x: boolean, y: boolean): Phaser.GameObjects.GameObject;

            /**
             * Resets the horizontal and vertical flipped state of this Game Object back to their default un-flipped state.
             */
            resetFlip(): Phaser.GameObjects.GameObject;

            /**
             * Gets the center coordinate of this Game Object, regardless of origin.
             * @param output An object to store the values in. If not provided a new Vector2 will be created.
             */
            getCenter<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * Gets the top-left corner coordinate of this Game Object, regardless of origin.
             * @param output An object to store the values in. If not provided a new Vector2 will be created.
             */
            getTopLeft<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * Gets the top-right corner coordinate of this Game Object, regardless of origin.
             * @param output An object to store the values in. If not provided a new Vector2 will be created.
             */
            getTopRight<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * Gets the bottom-left corner coordinate of this Game Object, regardless of origin.
             * @param output An object to store the values in. If not provided a new Vector2 will be created.
             */
            getBottomLeft<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * Gets the bottom-right corner coordinate of this Game Object, regardless of origin.
             * @param output An object to store the values in. If not provided a new Vector2 will be created.
             */
            getBottomRight<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * Gets the bounds of this Game Object, regardless of origin.
             * The values are stored and returned in a Rectangle, or Rectangle-like, object.
             * @param output An object to store the values in. If not provided a new Rectangle will be created.
             */
            getBounds<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * The horizontal origin of this Game Object.
             * The origin maps the relationship between the size and position of the Game Object.
             * The default value is 0.5, meaning all Game Objects are positioned based on their center.
             * Setting the value to 0 means the position now relates to the left of the Game Object.
             */
            originX: number;

            /**
             * The vertical origin of this Game Object.
             * The origin maps the relationship between the size and position of the Game Object.
             * The default value is 0.5, meaning all Game Objects are positioned based on their center.
             * Setting the value to 0 means the position now relates to the top of the Game Object.
             */
            originY: number;

            /**
             * The horizontal display origin of this Game Object.
             * The origin is a normalized value between 0 and 1.
             * The displayOrigin is a pixel value, based on the size of the Game Object combined with the origin.
             */
            displayOriginX: number;

            /**
             * The vertical display origin of this Game Object.
             * The origin is a normalized value between 0 and 1.
             * The displayOrigin is a pixel value, based on the size of the Game Object combined with the origin.
             */
            displayOriginY: number;

            /**
             * Sets the origin of this Game Object.
             * 
             * The values are given in the range 0 to 1.
             * @param x The horizontal origin value. Default 0.5.
             * @param y The vertical origin value. If not defined it will be set to the value of `x`. Default x.
             */
            setOrigin(x?: number, y?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the origin of this Game Object based on the Pivot values in its Frame.
             */
            setOriginFromFrame(): Phaser.GameObjects.GameObject;

            /**
             * Sets the display origin of this Game Object.
             * The difference between this and setting the origin is that you can use pixel values for setting the display origin.
             * @param x The horizontal display origin value. Default 0.
             * @param y The vertical display origin value. If not defined it will be set to the value of `x`. Default x.
             */
            setDisplayOrigin(x?: number, y?: number): Phaser.GameObjects.GameObject;

            /**
             * Updates the Display Origin cached values internally stored on this Game Object.
             * You don't usually call this directly, but it is exposed for edge-cases where you may.
             */
            updateDisplayOrigin(): Phaser.GameObjects.GameObject;

            /**
             * [description]
             */
            defaultPipeline: Phaser.Renderer.WebGL.WebGLPipeline;

            /**
             * [description]
             */
            pipeline: Phaser.Renderer.WebGL.WebGLPipeline;

            /**
             * Sets the initial WebGL Pipeline of this Game Object.
             * This should only be called during the instantiation of the Game Object.
             * @param pipelineName The name of the pipeline to set on this Game Object.
             */
            initPipeline(pipelineName: string): boolean;

            /**
             * Sets the active WebGL Pipeline of this Game Object.
             * @param pipelineName The name of the pipeline to set on this Game Object.
             */
            setPipeline(pipelineName: string): boolean;

            /**
             * Resets the WebGL Pipeline of this Game Object back to the default it was created with.
             */
            resetPipeline(): boolean;

            /**
             * Gets the name of the WebGL Pipeline this Game Object is currently using.
             */
            getPipelineName(): string;

            /**
             * The Scale Mode being used by this Game Object.
             * Can be either `ScaleModes.LINEAR` or `ScaleModes.NEAREST`.
             */
            scaleMode: Phaser.ScaleModes;

            /**
             * Sets the Scale Mode being used by this Game Object.
             * Can be either `ScaleModes.LINEAR` or `ScaleModes.NEAREST`.
             * @param value The Scale Mode to be used by this Game Object.
             */
            setScaleMode(value: Phaser.ScaleModes): Phaser.GameObjects.GameObject;

            /**
             * The horizontal scroll factor of this Game Object.
             * 
             * The scroll factor controls the influence of the movement of a Camera upon this Game Object.
             * 
             * When a camera scrolls it will change the location at which this Game Object is rendered on-screen.
             * It does not change the Game Objects actual position values.
             * 
             * A value of 1 means it will move exactly in sync with a camera.
             * A value of 0 means it will not move at all, even if the camera moves.
             * Other values control the degree to which the camera movement is mapped to this Game Object.
             */
            scrollFactorX: number;

            /**
             * The vertical scroll factor of this Game Object.
             * 
             * The scroll factor controls the influence of the movement of a Camera upon this Game Object.
             * 
             * When a camera scrolls it will change the location at which this Game Object is rendered on-screen.
             * It does not change the Game Objects actual position values.
             * 
             * A value of 1 means it will move exactly in sync with a camera.
             * A value of 0 means it will not move at all, even if the camera moves.
             * Other values control the degree to which the camera movement is mapped to this Game Object.
             */
            scrollFactorY: number;

            /**
             * Sets the scroll factor of this Game Object.
             * 
             * The scroll factor controls the influence of the movement of a Camera upon this Game Object.
             * 
             * When a camera scrolls it will change the location at which this Game Object is rendered on-screen.
             * It does not change the Game Objects actual position values.
             * 
             * A value of 1 means it will move exactly in sync with a camera.
             * A value of 0 means it will not move at all, even if the camera moves.
             * Other values control the degree to which the camera movement is mapped to this Game Object.
             * @param x The horizontal scroll factor of this Game Object.
             * @param y The vertical scroll factor of this Game Object. If not set it will use the `x` value. Default x.
             */
            setScrollFactor(x: number, y?: number): Phaser.GameObjects.GameObject;

            /**
             * Clears all tint values associated with this Game Object.
             * Immediately sets the alpha levels back to 0xffffff (no tint)
             */
            clearTint(): Phaser.GameObjects.GameObject;

            /**
             * Sets the tint values for this Game Object.
             * @param topLeft The tint being applied to the top-left of the Game Object. If not other values are given this value is applied evenly, tinting the whole Game Object. Default 0xffffff.
             * @param topRight The tint being applied to the top-right of the Game Object.
             * @param bottomLeft The tint being applied to the bottom-left of the Game Object.
             * @param bottomRight The tint being applied to the bottom-right of the Game Object.
             */
            setTint(topLeft?: integer, topRight?: integer, bottomLeft?: integer, bottomRight?: integer): Phaser.GameObjects.GameObject;

            /**
             * The tint value being applied to the top-left of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            tintTopLeft: integer;

            /**
             * The tint value being applied to the top-right of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            tintTopRight: integer;

            /**
             * The tint value being applied to the bottom-left of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            tintBottomLeft: integer;

            /**
             * The tint value being applied to the bottom-right of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            tintBottomRight: integer;

            /**
             * The tint value being applied to the whole of the Game Object.
             */
            tint: integer;

            /**
             * The x position of this Game Object.
             */
            x: number;

            /**
             * The y position of this Game Object.
             */
            y: number;

            /**
             * The z position of this Game Object.
             * Note: Do not use this value to set the z-index, instead see the `depth` property.
             */
            z: number;

            /**
             * The w position of this Game Object.
             */
            w: number;

            /**
             * The horizontal scale of this Game Object.
             */
            scaleX: number;

            /**
             * The vertical scale of this Game Object.
             */
            scaleY: number;

            /**
             * The angle of this Game Object as expressed in degrees.
             * 
             * Where 0 is to the right, 90 is down, 180 is left.
             * 
             * If you prefer to work in radians, see the `rotation` property instead.
             */
            angle: integer;

            /**
             * The angle of this Game Object in radians.
             * 
             * If you prefer to work in degrees, see the `angle` property instead.
             */
            rotation: number;

            /**
             * Sets the position of this Game Object.
             * @param x The x position of this Game Object. Default 0.
             * @param y The y position of this Game Object. If not set it will use the `x` value.
             * @param z The z position of this Game Object. Default 0.
             * @param w The w position of this Game Object. Default 0.
             */
            setPosition(x?: number, y?: number, z?: number, w?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the rotation of this Game Object.
             * @param radians The rotation of this Game Object, in radians. Default 0.
             */
            setRotation(radians?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the angle of this Game Object.
             * @param degrees The rotation of this Game Object, in degrees. Default 0.
             */
            setAngle(degrees?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the scale of this Game Object.
             * @param x The horizontal scale of this Game Object.
             * @param y The vertical scale of this Game Object. If not set it will use the `x` value. Default x.
             */
            setScale(x: number, y?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the x position of this Game Object.
             * @param value The x position of this Game Object. Default 0.
             */
            setX(value?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the y position of this Game Object.
             * @param value The y position of this Game Object. Default 0.
             */
            setY(value?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the z position of this Game Object.
             * @param value The z position of this Game Object. Default 0.
             */
            setZ(value?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the w position of this Game Object.
             * @param value The w position of this Game Object. Default 0.
             */
            setW(value?: number): Phaser.GameObjects.GameObject;

            /**
             * The visible state of the Game Object.
             * 
             * An invisible Game Object will skip rendering, but will still process update logic.
             */
            visible: boolean;

            /**
             * Sets the visibility of this Game Object.
             * 
             * An invisible Game Object will skip rendering, but will still process update logic.
             * @param value The visible state of the Game Object.
             */
            setVisible(value: boolean): Phaser.GameObjects.GameObject;

        }

        /**
         * [description]
         */
        class TileSprite extends GameObject implements Components.Alpha, Components.BlendMode, Components.Depth, Components.Flip, Components.GetBounds, Components.Origin, Components.Pipeline, Components.ScaleMode, Components.ScrollFactor, Components.Size, Components.Texture, Components.Tint, Components.Transform, Components.Visible {
            /**
             * 
             * @param scene The Scene to which this Game Object belongs. A Game Object can only belong to one Scene at a time.
             * @param x The horizontal position of this Game Object in the world.
             * @param y The vertical position of this Game Object in the world.
             * @param width The width of the Game Object.
             * @param height The height of the Game Object.
             * @param texture The key of the Texture this Game Object will use to render with, as stored in the Texture Manager.
             * @param frame An optional frame from the Texture this Game Object is rendering with.
             */
            constructor(scene: Phaser.Scene, x: number, y: number, width: number, height: number, texture: string, frame?: string | integer);

            /**
             * [description]
             */
            tilePositionX: number;

            /**
             * [description]
             */
            tilePositionY: number;

            /**
             * [description]
             */
            dirty: boolean;

            /**
             * [description]
             */
            tileTexture: WebGLTexture;

            /**
             * [description]
             */
            renderer: Phaser.Renderer.Canvas.CanvasRenderer | Phaser.Renderer.WebGL.WebGLRenderer;

            /**
             * The next power of two value from the width of the Frame.
             */
            potWidth: integer;

            /**
             * The next power of two value from the height of the Frame.
             */
            potHeight: integer;

            /**
             * [description]
             */
            canvasPattern: CanvasPattern;

            /**
             * [description]
             */
            canvasBuffer: HTMLCanvasElement;

            /**
             * [description]
             */
            canvasBufferCtx: CanvasRenderingContext2D;

            /**
             * Sets {@link Phaser.GameObjects.TileSprite#tilePositionX} and {@link Phaser.GameObjects.TileSprite#tilePositionY}.
             * @param x The x position of this sprite's tiling texture.
             * @param y The y position of this sprite's tiling texture.
             */
            setTilePosition(x?: number, y?: number): Phaser.GameObjects.TileSprite;

            /**
             * [description]
             */
            updateTileTexture(): void;

            /**
             * [description]
             */
            destroy(): void;

            /**
             * Clears all alpha values associated with this Game Object.
             * Immediately sets the alpha levels back to 1 (fully opaque)
             */
            clearAlpha(): Phaser.GameObjects.GameObject;

            /**
             * Set the Alpha level of this Game Object. The alpha controls the opacity of the Game Object as it renders.
             * Alpha values are provided as a float between 0, fully transparent, and 1, fully opaque.
             * 
             * If your game is running under WebGL you can optionally specify four different alpha values, each of which
             * correspond to the four corners of the Game Object. Under Canvas only the `topLeft` value given is used.
             * @param topLeft The alpha value used for the top-left of the Game Object. If this is the only value given it's applied across the whole Game Object. Default 1.
             * @param topRight The alpha value used for the top-right of the Game Object. WebGL only.
             * @param bottomLeft The alpha value used for the bottom-left of the Game Object. WebGL only.
             * @param bottomRight The alpha value used for the bottom-right of the Game Object. WebGL only.
             */
            setAlpha(topLeft?: number, topRight?: number, bottomLeft?: number, bottomRight?: number): Phaser.GameObjects.GameObject;

            /**
             * The alpha value of the Game Object.
             * 
             * This is a global value, impacting the entire Game Object, not just a region of it.
             */
            alpha: number;

            /**
             * The alpha value starting from the top-left of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            alphaTopLeft: number;

            /**
             * The alpha value starting from the top-right of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            alphaTopRight: number;

            /**
             * The alpha value starting from the bottom-left of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            alphaBottomLeft: number;

            /**
             * The alpha value starting from the bottom-right of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            alphaBottomRight: number;

            /**
             * Sets the Blend Mode being used by this Game Object.
             * 
             * This can be a const, such as `Phaser.BlendModes.SCREEN`, or an integer, such as 4 (for Overlay)
             * 
             * Under WebGL only the following Blend Modes are available:
             * 
             * * ADD
             * * MULTIPLY
             * * SCREEN
             * 
             * Canvas has more available depending on browser support.
             * 
             * You can also create your own custom Blend Modes in WebGL.
             * 
             * Blend modes have different effects under Canvas and WebGL, and from browser to browser, depending
             * on support. Blend Modes also cause a WebGL batch flush should it encounter a new blend mode. For these
             * reasons try to be careful about the construction of your Scene and the frequency of which blend modes
             * are used.
             */
            blendMode: Phaser.BlendModes | string;

            /**
             * Sets the Blend Mode being used by this Game Object.
             * 
             * This can be a const, such as `Phaser.BlendModes.SCREEN`, or an integer, such as 4 (for Overlay)
             * 
             * Under WebGL only the following Blend Modes are available:
             * 
             * * ADD
             * * MULTIPLY
             * * SCREEN
             * 
             * Canvas has more available depending on browser support.
             * 
             * You can also create your own custom Blend Modes in WebGL.
             * 
             * Blend modes have different effects under Canvas and WebGL, and from browser to browser, depending
             * on support. Blend Modes also cause a WebGL batch flush should it encounter a new blend mode. For these
             * reasons try to be careful about the construction of your Scene and the frequency of which blend modes
             * are used.
             * @param value The BlendMode value. Either a string or a CONST.
             */
            setBlendMode(value: string | Phaser.BlendModes): Phaser.GameObjects.GameObject;

            /**
             * The depth of this Game Object within the Scene.
             * 
             * The depth is also known as the 'z-index' in some environments, and allows you to change the rendering order
             * of Game Objects, without actually moving their position in the display list.
             * 
             * The depth starts from zero (the default value) and increases from that point. A Game Object with a higher depth
             * value will always render in front of one with a lower value.
             * 
             * Setting the depth will queue a depth sort event within the Scene.
             */
            depth: number;

            /**
             * The depth of this Game Object within the Scene.
             * 
             * The depth is also known as the 'z-index' in some environments, and allows you to change the rendering order
             * of Game Objects, without actually moving their position in the display list.
             * 
             * The depth starts from zero (the default value) and increases from that point. A Game Object with a higher depth
             * value will always render in front of one with a lower value.
             * 
             * Setting the depth will queue a depth sort event within the Scene.
             * @param value The depth of this Game Object.
             */
            setDepth(value: integer): Phaser.GameObjects.GameObject;

            /**
             * The horizontally flipped state of the Game Object.
             * A Game Object that is flipped horizontally will render inversed on the horizontal axis.
             * Flipping always takes place from the middle of the texture and does not impact the scale value.
             */
            flipX: boolean;

            /**
             * The vertically flipped state of the Game Object.
             * A Game Object that is flipped vertically will render inversed on the vertical axis (i.e. upside down)
             * Flipping always takes place from the middle of the texture and does not impact the scale value.
             */
            flipY: boolean;

            /**
             * Toggles the horizontal flipped state of this Game Object.
             */
            toggleFlipX(): Phaser.GameObjects.GameObject;

            /**
             * Toggles the vertical flipped state of this Game Object.
             */
            toggleFlipY(): Phaser.GameObjects.GameObject;

            /**
             * Sets the horizontal flipped state of this Game Object.
             * @param value The flipped state. `false` for no flip, or `true` to be flipped.
             */
            setFlipX(value: boolean): Phaser.GameObjects.GameObject;

            /**
             * Sets the vertical flipped state of this Game Object.
             * @param value The flipped state. `false` for no flip, or `true` to be flipped.
             */
            setFlipY(value: boolean): Phaser.GameObjects.GameObject;

            /**
             * Sets the horizontal and vertical flipped state of this Game Object.
             * @param x The horizontal flipped state. `false` for no flip, or `true` to be flipped.
             * @param y The horizontal flipped state. `false` for no flip, or `true` to be flipped.
             */
            setFlip(x: boolean, y: boolean): Phaser.GameObjects.GameObject;

            /**
             * Resets the horizontal and vertical flipped state of this Game Object back to their default un-flipped state.
             */
            resetFlip(): Phaser.GameObjects.GameObject;

            /**
             * Gets the center coordinate of this Game Object, regardless of origin.
             * @param output An object to store the values in. If not provided a new Vector2 will be created.
             */
            getCenter<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * Gets the top-left corner coordinate of this Game Object, regardless of origin.
             * @param output An object to store the values in. If not provided a new Vector2 will be created.
             */
            getTopLeft<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * Gets the top-right corner coordinate of this Game Object, regardless of origin.
             * @param output An object to store the values in. If not provided a new Vector2 will be created.
             */
            getTopRight<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * Gets the bottom-left corner coordinate of this Game Object, regardless of origin.
             * @param output An object to store the values in. If not provided a new Vector2 will be created.
             */
            getBottomLeft<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * Gets the bottom-right corner coordinate of this Game Object, regardless of origin.
             * @param output An object to store the values in. If not provided a new Vector2 will be created.
             */
            getBottomRight<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * Gets the bounds of this Game Object, regardless of origin.
             * The values are stored and returned in a Rectangle, or Rectangle-like, object.
             * @param output An object to store the values in. If not provided a new Rectangle will be created.
             */
            getBounds<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * The horizontal origin of this Game Object.
             * The origin maps the relationship between the size and position of the Game Object.
             * The default value is 0.5, meaning all Game Objects are positioned based on their center.
             * Setting the value to 0 means the position now relates to the left of the Game Object.
             */
            originX: number;

            /**
             * The vertical origin of this Game Object.
             * The origin maps the relationship between the size and position of the Game Object.
             * The default value is 0.5, meaning all Game Objects are positioned based on their center.
             * Setting the value to 0 means the position now relates to the top of the Game Object.
             */
            originY: number;

            /**
             * The horizontal display origin of this Game Object.
             * The origin is a normalized value between 0 and 1.
             * The displayOrigin is a pixel value, based on the size of the Game Object combined with the origin.
             */
            displayOriginX: number;

            /**
             * The vertical display origin of this Game Object.
             * The origin is a normalized value between 0 and 1.
             * The displayOrigin is a pixel value, based on the size of the Game Object combined with the origin.
             */
            displayOriginY: number;

            /**
             * Sets the origin of this Game Object.
             * 
             * The values are given in the range 0 to 1.
             * @param x The horizontal origin value. Default 0.5.
             * @param y The vertical origin value. If not defined it will be set to the value of `x`. Default x.
             */
            setOrigin(x?: number, y?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the origin of this Game Object based on the Pivot values in its Frame.
             */
            setOriginFromFrame(): Phaser.GameObjects.GameObject;

            /**
             * Sets the display origin of this Game Object.
             * The difference between this and setting the origin is that you can use pixel values for setting the display origin.
             * @param x The horizontal display origin value. Default 0.
             * @param y The vertical display origin value. If not defined it will be set to the value of `x`. Default x.
             */
            setDisplayOrigin(x?: number, y?: number): Phaser.GameObjects.GameObject;

            /**
             * Updates the Display Origin cached values internally stored on this Game Object.
             * You don't usually call this directly, but it is exposed for edge-cases where you may.
             */
            updateDisplayOrigin(): Phaser.GameObjects.GameObject;

            /**
             * [description]
             */
            defaultPipeline: Phaser.Renderer.WebGL.WebGLPipeline;

            /**
             * [description]
             */
            pipeline: Phaser.Renderer.WebGL.WebGLPipeline;

            /**
             * Sets the initial WebGL Pipeline of this Game Object.
             * This should only be called during the instantiation of the Game Object.
             * @param pipelineName The name of the pipeline to set on this Game Object.
             */
            initPipeline(pipelineName: string): boolean;

            /**
             * Sets the active WebGL Pipeline of this Game Object.
             * @param pipelineName The name of the pipeline to set on this Game Object.
             */
            setPipeline(pipelineName: string): boolean;

            /**
             * Resets the WebGL Pipeline of this Game Object back to the default it was created with.
             */
            resetPipeline(): boolean;

            /**
             * Gets the name of the WebGL Pipeline this Game Object is currently using.
             */
            getPipelineName(): string;

            /**
             * The Scale Mode being used by this Game Object.
             * Can be either `ScaleModes.LINEAR` or `ScaleModes.NEAREST`.
             */
            scaleMode: Phaser.ScaleModes;

            /**
             * Sets the Scale Mode being used by this Game Object.
             * Can be either `ScaleModes.LINEAR` or `ScaleModes.NEAREST`.
             * @param value The Scale Mode to be used by this Game Object.
             */
            setScaleMode(value: Phaser.ScaleModes): Phaser.GameObjects.GameObject;

            /**
             * The horizontal scroll factor of this Game Object.
             * 
             * The scroll factor controls the influence of the movement of a Camera upon this Game Object.
             * 
             * When a camera scrolls it will change the location at which this Game Object is rendered on-screen.
             * It does not change the Game Objects actual position values.
             * 
             * A value of 1 means it will move exactly in sync with a camera.
             * A value of 0 means it will not move at all, even if the camera moves.
             * Other values control the degree to which the camera movement is mapped to this Game Object.
             */
            scrollFactorX: number;

            /**
             * The vertical scroll factor of this Game Object.
             * 
             * The scroll factor controls the influence of the movement of a Camera upon this Game Object.
             * 
             * When a camera scrolls it will change the location at which this Game Object is rendered on-screen.
             * It does not change the Game Objects actual position values.
             * 
             * A value of 1 means it will move exactly in sync with a camera.
             * A value of 0 means it will not move at all, even if the camera moves.
             * Other values control the degree to which the camera movement is mapped to this Game Object.
             */
            scrollFactorY: number;

            /**
             * Sets the scroll factor of this Game Object.
             * 
             * The scroll factor controls the influence of the movement of a Camera upon this Game Object.
             * 
             * When a camera scrolls it will change the location at which this Game Object is rendered on-screen.
             * It does not change the Game Objects actual position values.
             * 
             * A value of 1 means it will move exactly in sync with a camera.
             * A value of 0 means it will not move at all, even if the camera moves.
             * Other values control the degree to which the camera movement is mapped to this Game Object.
             * @param x The horizontal scroll factor of this Game Object.
             * @param y The vertical scroll factor of this Game Object. If not set it will use the `x` value. Default x.
             */
            setScrollFactor(x: number, y?: number): Phaser.GameObjects.GameObject;

            /**
             * The native (un-scaled) width of this Game Object.
             */
            width: number;

            /**
             * The native (un-scaled) height of this Game Object.
             */
            height: number;

            /**
             * The displayed width of this Game Object.
             * This value takes into account the scale factor.
             */
            displayWidth: number;

            /**
             * The displayed height of this Game Object.
             * This value takes into account the scale factor.
             */
            displayHeight: number;

            /**
             * Sets the size of this Game Object to be that of the given Frame.
             * @param frame The frame to base the size of this Game Object on.
             */
            setSizeToFrame(frame: Phaser.Textures.Frame): Phaser.GameObjects.GameObject;

            /**
             * Sets the size of this Game Object.
             * @param width The width of this Game Object.
             * @param height The height of this Game Object.
             */
            setSize(width: number, height: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the display size of this Game Object.
             * Calling this will adjust the scale.
             * @param width The width of this Game Object.
             * @param height The height of this Game Object.
             */
            setDisplaySize(width: number, height: number): Phaser.GameObjects.GameObject;

            /**
             * The Texture this Game Object is using to render with.
             */
            texture: Phaser.Textures.Texture;

            /**
             * The Texture Frame this Game Object is using to render with.
             */
            frame: Phaser.Textures.Frame;

            /**
             * Sets the texture and frame this Game Object will use to render with.
             * 
             * Textures are referenced by their string-based keys, as stored in the Texture Manager.
             * @param key The key of the texture to be used, as stored in the Texture Manager.
             * @param frame The name or index of the frame within the Texture.
             */
            setTexture(key: string, frame?: string | integer): Phaser.GameObjects.GameObject;

            /**
             * Sets the frame this Game Object will use to render with.
             * 
             * The Frame has to belong to the current Texture being used.
             * 
             * It can be either a string or an index.
             * 
             * Calling `setFrame` will modify the `width` and `height` properties of your Game Object.
             * It will also change the `origin` if the Frame has a custom pivot point, as exported from packages like Texture Packer.
             * @param frame The name or index of the frame within the Texture.
             * @param updateSize Should this call adjust the size of the Game Object? Default true.
             * @param updateOrigin Should this call adjust the origin of the Game Object? Default true.
             */
            setFrame(frame: string | integer, updateSize?: boolean, updateOrigin?: boolean): Phaser.GameObjects.GameObject;

            /**
             * Clears all tint values associated with this Game Object.
             * Immediately sets the alpha levels back to 0xffffff (no tint)
             */
            clearTint(): Phaser.GameObjects.GameObject;

            /**
             * Sets the tint values for this Game Object.
             * @param topLeft The tint being applied to the top-left of the Game Object. If not other values are given this value is applied evenly, tinting the whole Game Object. Default 0xffffff.
             * @param topRight The tint being applied to the top-right of the Game Object.
             * @param bottomLeft The tint being applied to the bottom-left of the Game Object.
             * @param bottomRight The tint being applied to the bottom-right of the Game Object.
             */
            setTint(topLeft?: integer, topRight?: integer, bottomLeft?: integer, bottomRight?: integer): Phaser.GameObjects.GameObject;

            /**
             * The tint value being applied to the top-left of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            tintTopLeft: integer;

            /**
             * The tint value being applied to the top-right of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            tintTopRight: integer;

            /**
             * The tint value being applied to the bottom-left of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            tintBottomLeft: integer;

            /**
             * The tint value being applied to the bottom-right of the Game Object.
             * This value is interpolated from the corner to the center of the Game Object.
             */
            tintBottomRight: integer;

            /**
             * The tint value being applied to the whole of the Game Object.
             */
            tint: integer;

            /**
             * The x position of this Game Object.
             */
            x: number;

            /**
             * The y position of this Game Object.
             */
            y: number;

            /**
             * The z position of this Game Object.
             * Note: Do not use this value to set the z-index, instead see the `depth` property.
             */
            z: number;

            /**
             * The w position of this Game Object.
             */
            w: number;

            /**
             * The horizontal scale of this Game Object.
             */
            scaleX: number;

            /**
             * The vertical scale of this Game Object.
             */
            scaleY: number;

            /**
             * The angle of this Game Object as expressed in degrees.
             * 
             * Where 0 is to the right, 90 is down, 180 is left.
             * 
             * If you prefer to work in radians, see the `rotation` property instead.
             */
            angle: integer;

            /**
             * The angle of this Game Object in radians.
             * 
             * If you prefer to work in degrees, see the `angle` property instead.
             */
            rotation: number;

            /**
             * Sets the position of this Game Object.
             * @param x The x position of this Game Object. Default 0.
             * @param y The y position of this Game Object. If not set it will use the `x` value.
             * @param z The z position of this Game Object. Default 0.
             * @param w The w position of this Game Object. Default 0.
             */
            setPosition(x?: number, y?: number, z?: number, w?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the rotation of this Game Object.
             * @param radians The rotation of this Game Object, in radians. Default 0.
             */
            setRotation(radians?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the angle of this Game Object.
             * @param degrees The rotation of this Game Object, in degrees. Default 0.
             */
            setAngle(degrees?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the scale of this Game Object.
             * @param x The horizontal scale of this Game Object.
             * @param y The vertical scale of this Game Object. If not set it will use the `x` value. Default x.
             */
            setScale(x: number, y?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the x position of this Game Object.
             * @param value The x position of this Game Object. Default 0.
             */
            setX(value?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the y position of this Game Object.
             * @param value The y position of this Game Object. Default 0.
             */
            setY(value?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the z position of this Game Object.
             * @param value The z position of this Game Object. Default 0.
             */
            setZ(value?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the w position of this Game Object.
             * @param value The w position of this Game Object. Default 0.
             */
            setW(value?: number): Phaser.GameObjects.GameObject;

            /**
             * The visible state of the Game Object.
             * 
             * An invisible Game Object will skip rendering, but will still process update logic.
             */
            visible: boolean;

            /**
             * Sets the visibility of this Game Object.
             * 
             * An invisible Game Object will skip rendering, but will still process update logic.
             * @param value The visible state of the Game Object.
             */
            setVisible(value: boolean): Phaser.GameObjects.GameObject;

        }

        /**
         * [description]
         */
        class UpdateList {
            /**
             * 
             * @param scene [description]
             */
            constructor(scene: Phaser.Scene);

            /**
             * [description]
             */
            scene: Phaser.Scene;

            /**
             * [description]
             */
            systems: Phaser.Scenes.Systems;

            /**
             * [description]
             */
            boot(): void;

            /**
             * [description]
             * @param child [description]
             */
            add(child: Phaser.GameObjects.GameObject): Phaser.GameObjects.GameObject;

            /**
             * [description]
             * @param time [description]
             * @param delta [description]
             */
            preUpdate(time: number, delta: number): void;

            /**
             * [description]
             * @param time [description]
             * @param delta [description]
             */
            update(time: number, delta: number): void;

            /**
             * [description]
             * @param child [description]
             */
            remove(child: Phaser.GameObjects.GameObject): Phaser.GameObjects.GameObject;

            /**
             * [description]
             */
            removeAll(): Phaser.GameObjects.UpdateList;

            /**
             * [description]
             */
            shutdown(): void;

            /**
             * [description]
             */
            destroy(): void;

        }

        /**
         * A Zone Game Object.
         * 
         * 
         * 
         * A Zone is a non-rendering rectangular Game Object that has a position and size.
         * 
         * It has no texture and never displays, but does live on the display list and
         * 
         * can be moved, scaled and rotated like any other Game Object.
         * 
         * 
         * 
         * Its primary use is for creating Drop Zones and Input Hit Areas and it has a couple of helper methods
         * 
         * specifically for this. It is also useful for object overlap checks, or as a base for your own
         * 
         * non-displaying Game Objects.
         * 
         * The default origin is 0.5, the center of the Zone, the same as with Game Objects.
         */
        class Zone extends GameObject implements Components.Depth, Components.GetBounds, Components.Origin, Components.ScaleMode, Components.Transform, Components.ScrollFactor, Components.Visible {
            /**
             * 
             * @param scene [description]
             * @param x The horizontal position of this Game Object in the world.
             * @param y The vertical position of this Game Object in the world.
             * @param width The width of the Game Object. Default 1.
             * @param height The height of the Game Object. Default 1.
             */
            constructor(scene: Phaser.Scene, x: number, y: number, width?: number, height?: number);

            /**
             * The native (un-scaled) width of this Game Object.
             */
            width: number;

            /**
             * The native (un-scaled) height of this Game Object.
             */
            height: number;

            /**
             * The Blend Mode of the Game Object.
             * Although a Zone never renders, it still has a blend mode to allow it to fit seamlessly into
             * display lists without causing a batch flush.
             */
            blendMode: integer;

            /**
             * The displayed width of this Game Object.
             * This value takes into account the scale factor.
             */
            displayWidth: number;

            /**
             * The displayed height of this Game Object.
             * This value takes into account the scale factor.
             */
            displayHeight: number;

            /**
             * Sets the size of this Game Object.
             * @param width The width of this Game Object.
             * @param height The height of this Game Object.
             * @param resizeInput If this Zone has a Rectangle for a hit area this argument will resize the hit area as well. Default true.
             */
            setSize(width: number, height: number, resizeInput?: boolean): Phaser.GameObjects.Zone;

            /**
             * Sets the display size of this Game Object.
             * Calling this will adjust the scale.
             * @param width The width of this Game Object.
             * @param height The height of this Game Object.
             */
            setDisplaySize(width: number, height: number): Phaser.GameObjects.Zone;

            /**
             * Sets this Zone to be a Circular Drop Zone.
             * The circle is centered on this Zones `x` and `y` coordinates.
             * @param radius The radius of the Circle that will form the Drop Zone.
             */
            setCircleDropZone(radius: number): Phaser.GameObjects.Zone;

            /**
             * Sets this Zone to be a Rectangle Drop Zone.
             * The rectangle is centered on this Zones `x` and `y` coordinates.
             * @param width The width of the rectangle drop zone.
             * @param height The height of the rectangle drop zone.
             */
            setRectangleDropZone(width: number, height: number): Phaser.GameObjects.Zone;

            /**
             * Allows you to define your own Geometry shape to be used as a Drop Zone.
             * @param shape A Geometry shape instance, such as Phaser.Geom.Ellipse, or your own custom shape.
             * @param callback A function that will return `true` if the given x/y coords it is sent are within the shape.
             */
            setDropZone(shape: object, callback: HitAreaCallback): Phaser.GameObjects.Zone;

            /**
             * The depth of this Game Object within the Scene.
             * 
             * The depth is also known as the 'z-index' in some environments, and allows you to change the rendering order
             * of Game Objects, without actually moving their position in the display list.
             * 
             * The depth starts from zero (the default value) and increases from that point. A Game Object with a higher depth
             * value will always render in front of one with a lower value.
             * 
             * Setting the depth will queue a depth sort event within the Scene.
             */
            depth: number;

            /**
             * The depth of this Game Object within the Scene.
             * 
             * The depth is also known as the 'z-index' in some environments, and allows you to change the rendering order
             * of Game Objects, without actually moving their position in the display list.
             * 
             * The depth starts from zero (the default value) and increases from that point. A Game Object with a higher depth
             * value will always render in front of one with a lower value.
             * 
             * Setting the depth will queue a depth sort event within the Scene.
             * @param value The depth of this Game Object.
             */
            setDepth(value: integer): Phaser.GameObjects.GameObject;

            /**
             * Gets the center coordinate of this Game Object, regardless of origin.
             * @param output An object to store the values in. If not provided a new Vector2 will be created.
             */
            getCenter<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * Gets the top-left corner coordinate of this Game Object, regardless of origin.
             * @param output An object to store the values in. If not provided a new Vector2 will be created.
             */
            getTopLeft<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * Gets the top-right corner coordinate of this Game Object, regardless of origin.
             * @param output An object to store the values in. If not provided a new Vector2 will be created.
             */
            getTopRight<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * Gets the bottom-left corner coordinate of this Game Object, regardless of origin.
             * @param output An object to store the values in. If not provided a new Vector2 will be created.
             */
            getBottomLeft<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * Gets the bottom-right corner coordinate of this Game Object, regardless of origin.
             * @param output An object to store the values in. If not provided a new Vector2 will be created.
             */
            getBottomRight<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * Gets the bounds of this Game Object, regardless of origin.
             * The values are stored and returned in a Rectangle, or Rectangle-like, object.
             * @param output An object to store the values in. If not provided a new Rectangle will be created.
             */
            getBounds<O extends Phaser.Math.Vector2>(output?: O): O;

            /**
             * The horizontal origin of this Game Object.
             * The origin maps the relationship between the size and position of the Game Object.
             * The default value is 0.5, meaning all Game Objects are positioned based on their center.
             * Setting the value to 0 means the position now relates to the left of the Game Object.
             */
            originX: number;

            /**
             * The vertical origin of this Game Object.
             * The origin maps the relationship between the size and position of the Game Object.
             * The default value is 0.5, meaning all Game Objects are positioned based on their center.
             * Setting the value to 0 means the position now relates to the top of the Game Object.
             */
            originY: number;

            /**
             * The horizontal display origin of this Game Object.
             * The origin is a normalized value between 0 and 1.
             * The displayOrigin is a pixel value, based on the size of the Game Object combined with the origin.
             */
            displayOriginX: number;

            /**
             * The vertical display origin of this Game Object.
             * The origin is a normalized value between 0 and 1.
             * The displayOrigin is a pixel value, based on the size of the Game Object combined with the origin.
             */
            displayOriginY: number;

            /**
             * Sets the origin of this Game Object.
             * 
             * The values are given in the range 0 to 1.
             * @param x The horizontal origin value. Default 0.5.
             * @param y The vertical origin value. If not defined it will be set to the value of `x`. Default x.
             */
            setOrigin(x?: number, y?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the origin of this Game Object based on the Pivot values in its Frame.
             */
            setOriginFromFrame(): Phaser.GameObjects.GameObject;

            /**
             * Sets the display origin of this Game Object.
             * The difference between this and setting the origin is that you can use pixel values for setting the display origin.
             * @param x The horizontal display origin value. Default 0.
             * @param y The vertical display origin value. If not defined it will be set to the value of `x`. Default x.
             */
            setDisplayOrigin(x?: number, y?: number): Phaser.GameObjects.GameObject;

            /**
             * Updates the Display Origin cached values internally stored on this Game Object.
             * You don't usually call this directly, but it is exposed for edge-cases where you may.
             */
            updateDisplayOrigin(): Phaser.GameObjects.GameObject;

            /**
             * The Scale Mode being used by this Game Object.
             * Can be either `ScaleModes.LINEAR` or `ScaleModes.NEAREST`.
             */
            scaleMode: Phaser.ScaleModes;

            /**
             * Sets the Scale Mode being used by this Game Object.
             * Can be either `ScaleModes.LINEAR` or `ScaleModes.NEAREST`.
             * @param value The Scale Mode to be used by this Game Object.
             */
            setScaleMode(value: Phaser.ScaleModes): Phaser.GameObjects.GameObject;

            /**
             * The x position of this Game Object.
             */
            x: number;

            /**
             * The y position of this Game Object.
             */
            y: number;

            /**
             * The z position of this Game Object.
             * Note: Do not use this value to set the z-index, instead see the `depth` property.
             */
            z: number;

            /**
             * The w position of this Game Object.
             */
            w: number;

            /**
             * The horizontal scale of this Game Object.
             */
            scaleX: number;

            /**
             * The vertical scale of this Game Object.
             */
            scaleY: number;

            /**
             * The angle of this Game Object as expressed in degrees.
             * 
             * Where 0 is to the right, 90 is down, 180 is left.
             * 
             * If you prefer to work in radians, see the `rotation` property instead.
             */
            angle: integer;

            /**
             * The angle of this Game Object in radians.
             * 
             * If you prefer to work in degrees, see the `angle` property instead.
             */
            rotation: number;

            /**
             * Sets the position of this Game Object.
             * @param x The x position of this Game Object. Default 0.
             * @param y The y position of this Game Object. If not set it will use the `x` value.
             * @param z The z position of this Game Object. Default 0.
             * @param w The w position of this Game Object. Default 0.
             */
            setPosition(x?: number, y?: number, z?: number, w?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the rotation of this Game Object.
             * @param radians The rotation of this Game Object, in radians. Default 0.
             */
            setRotation(radians?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the angle of this Game Object.
             * @param degrees The rotation of this Game Object, in degrees. Default 0.
             */
            setAngle(degrees?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the scale of this Game Object.
             * @param x The horizontal scale of this Game Object.
             * @param y The vertical scale of this Game Object. If not set it will use the `x` value. Default x.
             */
            setScale(x: number, y?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the x position of this Game Object.
             * @param value The x position of this Game Object. Default 0.
             */
            setX(value?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the y position of this Game Object.
             * @param value The y position of this Game Object. Default 0.
             */
            setY(value?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the z position of this Game Object.
             * @param value The z position of this Game Object. Default 0.
             */
            setZ(value?: number): Phaser.GameObjects.GameObject;

            /**
             * Sets the w position of this Game Object.
             * @param value The w position of this Game Object. Default 0.
             */
            setW(value?: number): Phaser.GameObjects.GameObject;

            /**
             * The horizontal scroll factor of this Game Object.
             * 
             * The scroll factor controls the influence of the movement of a Camera upon this Game Object.
             * 
             * When a camera scrolls it will change the location at which this Game Object is rendered on-screen.
             * It does not change the Game Objects actual position values.
             * 
             * A value of 1 means it will move exactly in sync with a camera.
             * A value of 0 means it will not move at all, even if the camera moves.
             * Other values control the degree to which the camera movement is mapped to this Game Object.
             */
            scrollFactorX: number;

            /**
             * The vertical scroll factor of this Game Object.
             * 
             * The scroll factor controls the influence of the movement of a Camera upon this Game Object.
             * 
             * When a camera scrolls it will change the location at which this Game Object is rendered on-screen.
             * It does not change the Game Objects actual position values.
             * 
             * A value of 1 means it will move exactly in sync with a camera.
             * A value of 0 means it will not move at all, even if the camera moves.
             * Other values control the degree to which the camera movement is mapped to this Game Object.
             */
            scrollFactorY: number;

            /**
             * Sets the scroll factor of this Game Object.
             * 
             * The scroll factor controls the influence of the movement of a Camera upon this Game Object.
             * 
             * When a camera scrolls it will change the location at which this Game Object is rendered on-screen.
             * It does not change the Game Objects actual position values.
             * 
             * A value of 1 means it will move exactly in sync with a camera.
             * A value of 0 means it will not move at all, even if the camera moves.
             * Other values control the degree to which the camera movement is mapped to this Game Object.
             * @param x The horizontal scroll factor of this Game Object.
             * @param y The vertical scroll factor of this Game Object. If not set it will use the `x` value. Default x.
             */
            setScrollFactor(x: number, y?: number): Phaser.GameObjects.GameObject;

            /**
             * The visible state of the Game Object.
             * 
             * An invisible Game Object will skip rendering, but will still process update logic.
             */
            visible: boolean;

            /**
             * Sets the visibility of this Game Object.
             * 
             * An invisible Game Object will skip rendering, but will still process update logic.
             * @param value The visible state of the Game Object.
             */
            setVisible(value: boolean): Phaser.GameObjects.GameObject;

        }

        namespace Blitter {
            /**
             * A Bob Game Object.
             * 
             * 
             * 
             * A Bob belongs to a Blitter Game Object. The Blitter is responsible for managing and rendering this object.
             * 
             * 
             * 
             * A Bob has a position, alpha value and a frame from a texture that it uses to render with. You can also toggle
             * 
             * the flipped and visible state of the Bob. The Frame the Bob uses to render can be changed dynamically, but it
             * 
             * must be a Frame within the Texture used by the parent Blitter.
             * 
             * 
             * 
             * Bob positions are relative to the Blitter parent. So if you move the Blitter parent, all Bob children will
             * 
             * have their positions impacted by this change as well.
             * 
             * 
             * 
             * You can manipulate Bob objects directly from your game code, but the creation and destruction of them should be
             * 
             * handled via the Blitter parent.
             */
            class Bob {
                /**
                 * 
                 * @param blitter The parent Blitter object is responsible for updating this Bob.
                 * @param x The horizontal position of this Game Object in the world, relative to the parent Blitter position.
                 * @param y The vertical position of this Game Object in the world, relative to the parent Blitter position.
                 * @param frame The Frame this Bob will render with, as defined in the Texture the parent Blitter is using.
                 * @param visible Should the Bob render visible or not to start with?
                 */
                constructor(blitter: Phaser.GameObjects.Blitter, x: number, y: number, frame: string | integer, visible: boolean);

                /**
                 * [description]
                 */
                parent: Phaser.GameObjects.Blitter;

                /**
                 * [description]
                 */
                x: number;

                /**
                 * [description]
                 */
                y: number;

                /**
                 * [description]
                 */
                frame: string | integer;

                /**
                 * [description]
                 */
                data: object;

                /**
                 * [description]
                 */
                flipX: boolean;

                /**
                 * [description]
                 */
                flipY: boolean;

                /**
                 * [description]
                 * @param frame [description]
                 */
                setFrame(frame?: Phaser.Textures.Frame): Phaser.GameObjects.Blitter.Bob;

                /**
                 * [description]
                 */
                resetFlip(): Phaser.GameObjects.Blitter.Bob;

                /**
                 * [description]
                 * @param x [description]
                 * @param y [description]
                 * @param frame [description]
                 */
                reset(x: number, y: number, frame: Phaser.Textures.Frame): Phaser.GameObjects.Blitter.Bob;

                /**
                 * [description]
                 * @param value [description]
                 */
                setFlipX(value: number): Phaser.GameObjects.Blitter.Bob;

                /**
                 * [description]
                 * @param value [description]
                 */
                setFlipY(value: number): Phaser.GameObjects.Blitter.Bob;

                /**
                 * [description]
                 * @param x [description]
                 * @param y [description]
                 */
                setFlip(x: number, y: number): Phaser.GameObjects.Blitter.Bob;

                /**
                 * [description]
                 * @param value [description]
                 */
                setVisible(value: boolean): Phaser.GameObjects.Blitter.Bob;

                /**
                 * [description]
                 * @param value [description]
                 */
                setAlpha(value: number): Phaser.GameObjects.Blitter.Bob;

                /**
                 * [description]
                 */
                destroy(): void;

                /**
                 * [description]
                 */
                visible: boolean;

                /**
                 * [description]
                 */
                alpha: number;

            }

        }

        namespace Text {
            /**
             * [description]
             */
            class TextStyle {
                /**
                 * 
                 * @param text The Text object that this TextStyle is styling.
                 * @param style [description]
                 */
                constructor(text: Phaser.GameObjects.Text, style: object);

            }

        }

    }

    namespace Geom {
        /**
         * A Circle object.
         * 
         * 
         * 
         * This is a geometry object, containing numerical values and related methods to inspect and modify them.
         * 
         * It is not a Game Object, in that you cannot add it to the display list, and it has no texture.
         * 
         * To render a Circle you should look at the capabilities of the Graphics class.
         */
        class Circle {
            /**
             * 
             * @param x The x position of the center of the circle. Default 0.
             * @param y The y position of the center of the circle. Default 0.
             * @param radius The radius of the circle. Default 0.
             */
            constructor(x?: number, y?: number, radius?: number);

            /**
             * Calculates the area of the circle.
             * @param circle The Circle to get the area of.
             */
            static Area(circle: Phaser.Geom.Circle): number;

            /**
             * The x position of the center of the circle.
             */
            x: number;

            /**
             * The y position of the center of the circle.
             */
            y: number;

            /**
             * Check to see if the Circle contains the given x / y coordinates.
             * @param x The x coordinate to check within the circle.
             * @param y The y coordinate to check within the circle.
             */
            contains(x: number, y: number): boolean;

            /**
             * Returns a Point object containing the coordinates of a point on the circumference of the Circle
             * based on the given angle normalized to the range 0 to 1. I.e. a value of 0.5 will give the point
             * at 180 degrees around the circle.
             * @param position A value between 0 and 1, where 0 equals 0 degrees, 0.5 equals 180 degrees and 1 equals 360 around the circle.
             * @param out An object to store the return values in. If not given a Point object will be created.
             */
            getPoint<O extends Phaser.Geom.Point>(position: number, out?: O): O;

            /**
             * Returns an array of Point objects containing the coordinates of the points around the circumference of the Circle,
             * based on the given quantity or stepRate values.
             * @param quantity The amount of points to return. If a falsey value the quantity will be derived from the `stepRate` instead.
             * @param stepRate Sets the quantity by getting the circumference of the circle and dividing it by the stepRate.
             * @param output An array to insert the points in to. If not provided a new array will be created.
             */
            getPoints<O extends Phaser.Geom.Point[]>(quantity: integer, stepRate?: number, output?: O): O;

            /**
             * Returns a uniformly distributed random point from anywhere within the Circle.
             * @param point A Point or point-like object to set the random `x` and `y` values in.
             */
            getRandomPoint<O extends Phaser.Geom.Point>(point?: O): O;

            /**
             * Sets the x, y and radius of this circle.
             * @param x The x position of the center of the circle. Default 0.
             * @param y The y position of the center of the circle. Default 0.
             * @param radius The radius of the circle. Default 0.
             */
            setTo(x?: number, y?: number, radius?: number): Phaser.Geom.Circle;

            /**
             * Sets this Circle to be empty with a radius of zero.
             * Does not change its position.
             */
            setEmpty(): Phaser.Geom.Circle;

            /**
             * Sets the position of this Circle.
             * @param x The x position of the center of the circle. Default 0.
             * @param y The y position of the center of the circle. Default 0.
             */
            setPosition(x?: number, y?: number): Phaser.Geom.Circle;

            /**
             * Checks to see if the Circle is empty: has a radius of zero.
             */
            isEmpty(): boolean;

            /**
             * The radius of the Circle.
             */
            radius: number;

            /**
             * The diameter of the Circle.
             */
            diameter: number;

            /**
             * The left position of the Circle.
             */
            left: number;

            /**
             * The right position of the Circle.
             */
            right: number;

            /**
             * The top position of the Circle.
             */
            top: number;

            /**
             * The bottom position of the Circle.
             */
            bottom: number;

            /**
             * Returns the circumference of the given Circle.
             * @param circle The Circle to get the circumference of.
             */
            static Circumference(circle: Phaser.Geom.Circle): number;

            /**
             * Returns a Point object containing the coordinates of a point on the circumference of the Circle based on the given angle.
             * @param circle The Circle to get the circumference point on.
             * @param angle The angle from the center of the Circle to the circumference to return the point from. Given in radians.
             * @param out A Point, or point-like object, to store the results in. If not given a Point will be created.
             */
            static CircumferencePoint<O extends Phaser.Geom.Point>(circle: Phaser.Geom.Circle, angle: number, out?: O): O;

            /**
             * Creates a new Circle instance based on the values contained in the given source.
             * @param source The Circle to be cloned. Can be an instance of a Circle or a circle-like object, with x, y and radius properties.
             */
            static Clone(source: Phaser.Geom.Circle | object): Phaser.Geom.Circle;

            /**
             * Check to see if the Circle contains the given x / y coordinates.
             * @param circle The Circle to check.
             * @param x The x coordinate to check within the circle.
             * @param y The y coordinate to check within the circle.
             */
            static Contains(circle: Phaser.Geom.Circle, x: number, y: number): boolean;

            /**
             * Check to see if the Circle contains the given Point object.
             * @param circle The Circle to check.
             * @param point The Point object to check if it's within the Circle or not.
             */
            static ContainsPoint(circle: Phaser.Geom.Circle, point: Phaser.Geom.Point | object): boolean;

            /**
             * Check to see if the Circle contains all four points of the given Rectangle object.
             * @param circle The Circle to check.
             * @param rect The Rectangle object to check if it's within the Circle or not.
             */
            static ContainsRect(circle: Phaser.Geom.Circle, rect: Phaser.Geom.Rectangle | object): boolean;

            /**
             * Copies the `x`, `y` and `radius` properties from the `source` Circle
             * into the given `dest` Circle, then returns the `dest` Circle.
             * @param source The source Circle to copy the values from.
             * @param dest The destination Circle to copy the values to.
             */
            static CopyFrom<O extends Phaser.Geom.Circle>(source: Phaser.Geom.Circle, dest: O): O;

            /**
             * Compares the `x`, `y` and `radius` properties of the two given Circles.
             * Returns `true` if they all match, otherwise returns `false`.
             * @param circle The first Circle to compare.
             * @param toCompare The second Circle to compare.
             */
            static Equals(circle: Phaser.Geom.Circle, toCompare: Phaser.Geom.Circle): boolean;

            /**
             * Returns the bounds of the Circle object.
             * @param circle The Circle to get the bounds from.
             * @param out A Rectangle, or rectangle-like object, to store the circle bounds in. If not given a new Rectangle will be created.
             */
            static GetBounds<O extends Phaser.Geom.Rectangle>(circle: Phaser.Geom.Circle, out?: O): O;

            /**
             * Returns a Point object containing the coordinates of a point on the circumference of the Circle
             * based on the given angle normalized to the range 0 to 1. I.e. a value of 0.5 will give the point
             * at 180 degrees around the circle.
             * @param circle The Circle to get the circumference point on.
             * @param position A value between 0 and 1, where 0 equals 0 degrees, 0.5 equals 180 degrees and 1 equals 360 around the circle.
             * @param out An object to store the return values in. If not given a Point object will be created.
             */
            static GetPoint<O extends Phaser.Geom.Point>(circle: Phaser.Geom.Circle, position: number, out?: O): O;

            /**
             * Returns an array of Point objects containing the coordinates of the points around the circumference of the Circle,
             * based on the given quantity or stepRate values.
             * @param circle The Circle to get the points from.
             * @param quantity The amount of points to return. If a falsey value the quantity will be derived from the `stepRate` instead.
             * @param stepRate Sets the quantity by getting the circumference of the circle and dividing it by the stepRate.
             * @param output An array to insert the points in to. If not provided a new array will be created.
             */
            static GetPoints(circle: Phaser.Geom.Circle, quantity: integer, stepRate?: number, output?: any[]): Phaser.Geom.Point[];

            /**
             * Offsets the Circle by the values given.
             * @param circle The Circle to be offset (translated.)
             * @param x The amount to horizontally offset the Circle by.
             * @param y The amount to vertically offset the Circle by.
             */
            static Offset<O extends Phaser.Geom.Circle>(circle: O, x: number, y: number): O;

            /**
             * Offsets the Circle by the values given in the `x` and `y` properties of the Point object.
             * @param circle The Circle to be offset (translated.)
             * @param point The Point object containing the values to offset the Circle by.
             */
            static OffsetPoint<O extends Phaser.Geom.Circle>(circle: O, point: Phaser.Geom.Point | object): O;

            /**
             * Returns a uniformly distributed random point from anywhere within the given Circle.
             * @param circle The Circle to get a random point from.
             * @param out A Point or point-like object to set the random `x` and `y` values in.
             */
            static Random<O extends Phaser.Geom.Point>(circle: Phaser.Geom.Circle, out?: O): O;

        }

        /**
         * An Ellipse object.
         * 
         * 
         * 
         * This is a geometry object, containing numerical values and related methods to inspect and modify them.
         * 
         * It is not a Game Object, in that you cannot add it to the display list, and it has no texture.
         * 
         * To render an Ellipse you should look at the capabilities of the Graphics class.
         */
        class Ellipse {
            /**
             * 
             * @param x The x position of the center of the ellipse. Default 0.
             * @param y The y position of the center of the ellipse. Default 0.
             * @param width The width of the ellipse. Default 0.
             * @param height The height of the ellipse. Default 0.
             */
            constructor(x?: number, y?: number, width?: number, height?: number);

            /**
             * Calculates the area of the Ellipse.
             * @param ellipse The Ellipse to get the area of.
             */
            static Area(ellipse: Phaser.Geom.Ellipse): number;

            /**
             * Returns the circumference of the given Ellipse.
             * @param ellipse The Ellipse to get the circumference of.
             */
            static Circumference(ellipse: Phaser.Geom.Ellipse): number;

            /**
             * Returns a Point object containing the coordinates of a point on the circumference of the Ellipse based on the given angle.
             * @param ellipse The Ellipse to get the circumference point on.
             * @param angle The angle from the center of the Ellipse to the circumference to return the point from. Given in radians.
             * @param out A Point, or point-like object, to store the results in. If not given a Point will be created.
             */
            static CircumferencePoint<O extends Phaser.Geom.Point>(ellipse: Phaser.Geom.Ellipse, angle: number, out?: O): O;

            /**
             * Creates a new Ellipse instance based on the values contained in the given source.
             * @param source The Ellipse to be cloned. Can be an instance of an Ellipse or a ellipse-like object, with x, y, width and height properties.
             */
            static Clone(source: Phaser.Geom.Ellipse): Phaser.Geom.Ellipse;

            /**
             * Check to see if the Ellipse contains the given x / y coordinates.
             * @param ellipse The Ellipse to check.
             * @param x The x coordinate to check within the ellipse.
             * @param y The y coordinate to check within the ellipse.
             */
            static Contains(ellipse: Phaser.Geom.Ellipse, x: number, y: number): boolean;

            /**
             * Check to see if the Ellipse contains the given Point object.
             * @param ellipse The Ellipse to check.
             * @param point The Point object to check if it's within the Circle or not.
             */
            static ContainsPoint(ellipse: Phaser.Geom.Ellipse, point: Phaser.Geom.Point | object): boolean;

            /**
             * Check to see if the Ellipse contains all four points of the given Rectangle object.
             * @param ellipse [description]
             * @param rect The Rectangle object to check if it's within the Ellipse or not.
             */
            static ContainsRect(ellipse: Phaser.Geom.Ellipse, rect: Phaser.Geom.Rectangle | object): boolean;

            /**
             * Copies the `x`, `y`, `width` and `height` properties from the `source` Ellipse
             * into the given `dest` Ellipse, then returns the `dest` Ellipse.
             * @param source The source Ellipse to copy the values from.
             * @param dest The destination Ellipse to copy the values to.
             */
            static CopyFrom<O extends Phaser.Geom.Ellipse>(source: Phaser.Geom.Ellipse, dest: O): O;

            /**
             * The x position of the center of the ellipse.
             */
            x: number;

            /**
             * The y position of the center of the ellipse.
             */
            y: number;

            /**
             * The width of the ellipse.
             */
            width: number;

            /**
             * The height of the ellipse.
             */
            height: number;

            /**
             * Check to see if the Ellipse contains the given x / y coordinates.
             * @param x The x coordinate to check within the ellipse.
             * @param y The y coordinate to check within the ellipse.
             */
            contains(x: number, y: number): boolean;

            /**
             * Returns a Point object containing the coordinates of a point on the circumference of the Ellipse
             * based on the given angle normalized to the range 0 to 1. I.e. a value of 0.5 will give the point
             * at 180 degrees around the circle.
             * @param position A value between 0 and 1, where 0 equals 0 degrees, 0.5 equals 180 degrees and 1 equals 360 around the ellipse.
             * @param out An object to store the return values in. If not given a Point object will be created.
             */
            getPoint<O extends Phaser.Geom.Point>(position: number, out?: O): O;

            /**
             * Returns an array of Point objects containing the coordinates of the points around the circumference of the Ellipse,
             * based on the given quantity or stepRate values.
             * @param quantity The amount of points to return. If a falsey value the quantity will be derived from the `stepRate` instead.
             * @param stepRate Sets the quantity by getting the circumference of the ellipse and dividing it by the stepRate.
             * @param output An array to insert the points in to. If not provided a new array will be created.
             */
            getPoints(quantity: integer, stepRate?: number, output?: any[]): Phaser.Geom.Point[];

            /**
             * Returns a uniformly distributed random point from anywhere within the given Ellipse.
             * @param point A Point or point-like object to set the random `x` and `y` values in.
             */
            getRandomPoint<O extends Phaser.Geom.Point>(point?: O): O;

            /**
             * Sets the x, y, width and height of this ellipse.
             * @param x The x position of the center of the ellipse.
             * @param y The y position of the center of the ellipse.
             * @param width The width of the ellipse.
             * @param height The height of the ellipse.
             */
            setTo(x: number, y: number, width: number, height: number): Phaser.Geom.Ellipse;

            /**
             * Sets this Ellipse to be empty with a width and height of zero.
             * Does not change its position.
             */
            setEmpty(): Phaser.Geom.Ellipse;

            /**
             * Sets the position of this Ellipse.
             * @param x The x position of the center of the ellipse.
             * @param y The y position of the center of the ellipse.
             */
            setPosition(x: number, y: number): Phaser.Geom.Ellipse;

            /**
             * Sets the size of this Ellipse.
             * Does not change its position.
             * @param width The width of the ellipse.
             * @param height The height of the ellipse. Default width.
             */
            setSize(width: number, height?: number): Phaser.Geom.Ellipse;

            /**
             * Checks to see if the Ellipse is empty: has a width or height equal to zero.
             */
            isEmpty(): boolean;

            /**
             * Returns the minor radius of the ellipse. Also known as the Semi Minor Axis.
             */
            getMinorRadius(): number;

            /**
             * Returns the major radius of the ellipse. Also known as the Semi Major Axis.
             */
            getMajorRadius(): number;

            /**
             * The left position of the Ellipse.
             */
            left: number;

            /**
             * The right position of the Ellipse.
             */
            right: number;

            /**
             * The top position of the Ellipse.
             */
            top: number;

            /**
             * The bottom position of the Ellipse.
             */
            bottom: number;

            /**
             * Compares the `x`, `y`, `width` and `height` properties of the two given Ellipses.
             * Returns `true` if they all match, otherwise returns `false`.
             * @param ellipse The first Ellipse to compare.
             * @param toCompare The second Ellipse to compare.
             */
            static Equals(ellipse: Phaser.Geom.Ellipse, toCompare: Phaser.Geom.Ellipse): boolean;

            /**
             * Returns the bounds of the Ellipse object.
             * @param ellipse The Ellipse to get the bounds from.
             * @param out A Rectangle, or rectangle-like object, to store the ellipse bounds in. If not given a new Rectangle will be created.
             */
            static GetBounds<O extends Phaser.Geom.Rectangle>(ellipse: Phaser.Geom.Ellipse, out?: O): O;

            /**
             * Returns a Point object containing the coordinates of a point on the circumference of the Ellipse
             * based on the given angle normalized to the range 0 to 1. I.e. a value of 0.5 will give the point
             * at 180 degrees around the circle.
             * @param ellipse The Ellipse to get the circumference point on.
             * @param position A value between 0 and 1, where 0 equals 0 degrees, 0.5 equals 180 degrees and 1 equals 360 around the ellipse.
             * @param out An object to store the return values in. If not given a Point object will be created.
             */
            static GetPoint<O extends Phaser.Geom.Point>(ellipse: Phaser.Geom.Ellipse, position: number, out?: O): O;

            /**
             * Returns an array of Point objects containing the coordinates of the points around the circumference of the Ellipse,
             * based on the given quantity or stepRate values.
             * @param ellipse The Ellipse to get the points from.
             * @param quantity The amount of points to return. If a falsey value the quantity will be derived from the `stepRate` instead.
             * @param stepRate Sets the quantity by getting the circumference of the ellipse and dividing it by the stepRate.
             * @param out An array to insert the points in to. If not provided a new array will be created.
             */
            static GetPoints<O extends Phaser.Geom.Point[]>(ellipse: Phaser.Geom.Ellipse, quantity: integer, stepRate?: number, out?: O): O;

            /**
             * Offsets the Ellipse by the values given.
             * @param ellipse The Ellipse to be offset (translated.)
             * @param x The amount to horizontally offset the Ellipse by.
             * @param y The amount to vertically offset the Ellipse by.
             */
            static Offset<O extends Phaser.Geom.Ellipse>(ellipse: O, x: number, y: number): O;

            /**
             * Offsets the Ellipse by the values given in the `x` and `y` properties of the Point object.
             * @param ellipse The Ellipse to be offset (translated.)
             * @param point The Point object containing the values to offset the Ellipse by.
             */
            static OffsetPoint<O extends Phaser.Geom.Ellipse>(ellipse: O, point: Phaser.Geom.Point | object): O;

            /**
             * Returns a uniformly distributed random point from anywhere within the given Ellipse.
             * @param ellipse The Ellipse to get a random point from.
             * @param out A Point or point-like object to set the random `x` and `y` values in.
             */
            static Random<O extends Phaser.Geom.Point>(ellipse: Phaser.Geom.Ellipse, out?: O): O;

        }

        namespace Intersects {
            /**
             * [description]
             * @param circleA [description]
             * @param circleB [description]
             */
            function CircleToCircle(circleA: Phaser.Geom.Circle, circleB: Phaser.Geom.Circle): boolean;

            /**
             * [description]
             * @param circle [description]
             * @param rect [description]
             */
            function CircleToRectangle(circle: Phaser.Geom.Circle, rect: Phaser.Geom.Rectangle): boolean;

            /**
             * [description]
             * @param rectA [description]
             * @param rectB [description]
             * @param output [description]
             */
            function GetRectangleIntersection<O extends Phaser.Geom.Rectangle>(rectA: Phaser.Geom.Rectangle, rectB: Phaser.Geom.Rectangle, output?: O): O;

            /**
             * [description]
             * @param line [description]
             * @param circle [description]
             * @param nearest [description]
             */
            function LineToCircle(line: Phaser.Geom.Line, circle: Phaser.Geom.Circle, nearest?: Phaser.Geom.Point): boolean;

            /**
             * [description]
             * @param line1 [description]
             * @param line2 [description]
             * @param out [description]
             */
            function LineToLine(line1: Phaser.Geom.Line, line2: Phaser.Geom.Line, out?: Phaser.Geom.Point): boolean;

            /**
             * Checks for intersection between the Line and a Rectangle shape, or a rectangle-like
             * object, with public `x`, `y`, `right` and `bottom` properties, such as a Sprite or Body.
             * 
             * An intersection is considered valid if:
             * 
             * The line starts within, or ends within, the Rectangle.
             * The line segment intersects one of the 4 rectangle edges.
             * 
             * The for the purposes of this function rectangles are considered 'solid'.
             * @param line [description]
             * @param rect [description]
             */
            function LineToRectangle(line: Phaser.Geom.Line, rect: Phaser.Geom.Rectangle | object): boolean;

            /**
             * [description]
             * @param point [description]
             * @param line [description]
             */
            function PointToLine(point: Phaser.Geom.Point, line: Phaser.Geom.Line): boolean;

            /**
             * [description]
             * @param point [description]
             * @param line [description]
             */
            function PointToLineSegment(point: Phaser.Geom.Point, line: Phaser.Geom.Line): boolean;

            /**
             * [description]
             * @param rectA [description]
             * @param rectB [description]
             */
            function RectangleToRectangle(rectA: Phaser.Geom.Rectangle, rectB: Phaser.Geom.Rectangle): boolean;

            /**
             * [description]
             * @param rect [description]
             * @param triangle [description]
             */
            function RectangleToTriangle(rect: Phaser.Geom.Rectangle, triangle: Phaser.Geom.Triangle): boolean;

            /**
             * [description]
             * @param rect [description]
             * @param left [description]
             * @param right [description]
             * @param top [description]
             * @param bottom [description]
             * @param tolerance [description] Default 0.
             */
            function RectangleToValues(rect: Phaser.Geom.Rectangle, left: number, right: number, top: number, bottom: number, tolerance?: number): boolean;

            /**
             * [description]
             * @param triangle [description]
             * @param circle [description]
             */
            function TriangleToCircle(triangle: Phaser.Geom.Triangle, circle: Phaser.Geom.Circle): boolean;

            /**
             * [description]
             * @param triangle [description]
             * @param line [description]
             */
            function TriangleToLine(triangle: Phaser.Geom.Triangle, line: Phaser.Geom.Line): boolean;

            /**
             * [description]
             * @param triangleA [description]
             * @param triangleB [description]
             */
            function TriangleToTriangle(triangleA: Phaser.Geom.Triangle, triangleB: Phaser.Geom.Triangle): boolean;

        }

        /**
         * Defines a Line segment, a part of a line between two endpoints.
         */
        class Line {
            /**
             * 
             * @param x1 [description] Default 0.
             * @param y1 [description] Default 0.
             * @param x2 [description] Default 0.
             * @param y2 [description] Default 0.
             */
            constructor(x1?: number, y1?: number, x2?: number, y2?: number);

            /**
             * [description]
             * @param line [description]
             */
            static Angle(line: Phaser.Geom.Line): number;

            /**
             * Using Bresenham's line algorithm this will return an array of all coordinates on this line.
             * The start and end points are rounded before this runs as the algorithm works on integers.
             * @param line [description]
             * @param stepRate [description] Default 1.
             * @param results [description]
             */
            static BresenhamPoints(line: Phaser.Geom.Line, stepRate?: integer, results?: any[]): any[];

            /**
             * [description]
             * @param line [description]
             * @param x [description]
             * @param y [description]
             */
            static CenterOn(line: Phaser.Geom.Line, x: number, y: number): Phaser.Geom.Line;

            /**
             * [description]
             * @param source [description]
             */
            static Clone(source: Phaser.Geom.Line): Phaser.Geom.Line;

            /**
             * [description]
             * @param source [description]
             * @param dest [description]
             */
            static CopyFrom<O extends Phaser.Geom.Line>(source: Phaser.Geom.Line, dest: O): O;

            /**
             * [description]
             * @param line [description]
             * @param toCompare [description]
             */
            static Equals(line: Phaser.Geom.Line, toCompare: Phaser.Geom.Line): boolean;

            /**
             * [description]
             * @param line [description]
             * @param out [description]
             */
            static GetMidPoint<O extends Phaser.Geom.Point>(line: Phaser.Geom.Line, out?: O): O;

            /**
             * [description]
             * @param line [description]
             * @param out [description]
             */
            static GetNormal<O extends Phaser.Geom.Point>(line: Phaser.Geom.Line, out?: O): O;

            /**
             * [description]
             * @param line [description]
             * @param position A value between 0 and 1, where 0 equals 0 degrees, 0.5 equals 180 degrees and 1 equals 360 around the circle.
             * @param out [description]
             */
            static GetPoint<O extends Phaser.Geom.Point>(line: Phaser.Geom.Line, position: number, out?: O): O;

            /**
             * [description]
             * @param line [description]
             * @param quantity [description]
             * @param stepRate [description]
             * @param out [description]
             */
            static GetPoints<O extends Phaser.Geom.Point[]>(line: Phaser.Geom.Line, quantity: integer, stepRate?: integer, out?: O): O;

            /**
             * [description]
             * @param line [description]
             */
            static Height(line: Phaser.Geom.Line): number;

            /**
             * [description]
             * @param line [description]
             */
            static Length(line: Phaser.Geom.Line): number;

            /**
             * [description]
             */
            x1: number;

            /**
             * [description]
             */
            y1: number;

            /**
             * [description]
             */
            x2: number;

            /**
             * [description]
             */
            y2: number;

            /**
             * [description]
             * @param position [description]
             * @param output [description]
             */
            getPoint<O extends Phaser.Geom.Point>(position: number, output?: O): O;

            /**
             * [description]
             * @param quantity [description]
             * @param stepRate [description]
             * @param output [description]
             */
            getPoints<O extends Phaser.Geom.Point>(quantity: integer, stepRate?: integer, output?: O): O;

            /**
             * [description]
             * @param point [description]
             */
            getRandomPoint<O extends Phaser.Geom.Point>(point?: O): O;

            /**
             * [description]
             * @param x1 [description] Default 0.
             * @param y1 [description] Default 0.
             * @param x2 [description] Default 0.
             * @param y2 [description] Default 0.
             */
            setTo(x1?: number, y1?: number, x2?: number, y2?: number): Phaser.Geom.Line;

            /**
             * Returns a Vector2 object that corresponds to the start of this Line.
             * @param vec2 A Vector2 object to set the results in. If `undefined` a new Vector2 will be created.
             */
            getPointA<O extends Phaser.Math.Vector2>(vec2?: O): O;

            /**
             * Returns a Vector2 object that corresponds to the start of this Line.
             * @param vec2 A Vector2 object to set the results in. If `undefined` a new Vector2 will be created.
             */
            getPointB<O extends Phaser.Math.Vector2>(vec2?: O): O;

            /**
             * The left position of the Line.
             */
            left: number;

            /**
             * The right position of the Line.
             */
            right: number;

            /**
             * The top position of the Line.
             */
            top: number;

            /**
             * The bottom position of the Line.
             */
            bottom: number;

            /**
             * [description]
             * @param line [description]
             */
            static NormalAngle(line: Phaser.Geom.Line): number;

            /**
             * [description]
             * @param line [description]
             */
            static NormalX(line: Phaser.Geom.Line): number;

            /**
             * [description]
             * @param line [description]
             */
            static NormalY(line: Phaser.Geom.Line): number;

            /**
             * [description]
             * @param line [description]
             * @param x [description]
             * @param y [description]
             */
            static Offset<O extends Phaser.Geom.Line>(line: O, x: number, y: number): O;

            /**
             * [description]
             * @param line [description]
             */
            static PerpSlope(line: Phaser.Geom.Line): number;

            /**
             * [description]
             * @param line [description]
             * @param out [description]
             */
            static Random<O extends Phaser.Geom.Point>(line: Phaser.Geom.Line, out?: O): O;

            /**
             * [description]
             * @param lineA [description]
             * @param lineB [description]
             */
            static ReflectAngle(lineA: Phaser.Geom.Line, lineB: Phaser.Geom.Line): number;

            /**
             * [description]
             * @param line [description]
             * @param angle [description]
             */
            static Rotate<O extends Phaser.Geom.Line>(line: O, angle: number): O;

            /**
             * [description]
             * @param line [description]
             * @param point [description]
             * @param angle [description]
             */
            static RotateAroundPoint<O extends Phaser.Geom.Line>(line: O, point: Phaser.Geom.Point | object, angle: number): O;

            /**
             * [description]
             * @param line [description]
             * @param x [description]
             * @param y [description]
             * @param angle [description]
             */
            static RotateAroundXY<O extends Phaser.Geom.Line>(line: O, x: number, y: number, angle: number): O;

            /**
             * [description]
             * @param line [description]
             * @param x [description]
             * @param y [description]
             * @param angle [description]
             * @param length [description]
             */
            static SetToAngle<O extends Phaser.Geom.Line>(line: O, x: number, y: number, angle: number, length: number): O;

            /**
             * [description]
             * @param line [description]
             */
            static Slope(line: Phaser.Geom.Line): number;

            /**
             * [description]
             * @param line [description]
             */
            static Width(line: Phaser.Geom.Line): number;

        }

        /**
         * [description]
         */
        class Point {
            /**
             * 
             * @param x The x coordinate of this Point. Default 0.
             * @param y The y coordinate of this Point. Default x.
             */
            constructor(x?: number, y?: number);

            /**
             * [description]
             * @param point [description]
             */
            static Ceil<O extends Phaser.Geom.Point>(point: O): O;

            /**
             * [description]
             * @param source [description]
             */
            static Clone(source: Phaser.Geom.Point): Phaser.Geom.Point;

            /**
             * [description]
             * @param source [description]
             * @param dest [description]
             */
            static CopyFrom<O extends Phaser.Geom.Point>(source: Phaser.Geom.Point, dest: O): O;

            /**
             * [description]
             * @param point [description]
             * @param toCompare [description]
             */
            static Equals(point: Phaser.Geom.Point, toCompare: Phaser.Geom.Point): boolean;

            /**
             * [description]
             * @param point [description]
             */
            static Floor<O extends Phaser.Geom.Point>(point: O): O;

            /**
             * [description]
             * @param points [description]
             * @param out [description]
             */
            static GetCentroid<O extends Phaser.Geom.Point>(points: Phaser.Geom.Point[], out?: O): O;

            /**
             * [description]
             * @param point [description]
             */
            static GetMagnitude(point: Phaser.Geom.Point): number;

            /**
             * [description]
             * @param point [description]
             */
            static GetMagnitudeSq(point: Phaser.Geom.Point): number;

            /**
             * Calculates the Axis Aligned Bounding Box (or aabb) from an array of points.
             * @param points [description]
             * @param out [description]
             */
            static GetRectangleFromPoints<O extends Phaser.Geom.Rectangle>(points: Phaser.Geom.Point[], out?: O): O;

            /**
             * [description]
             * @param pointA [description]
             * @param pointB [description]
             * @param t [description] Default 0.
             * @param out [description]
             */
            static Interpolate<O extends Phaser.Geom.Point>(pointA: Phaser.Geom.Point, pointB: Phaser.Geom.Point, t?: number, out?: O): O;

            /**
             * [description]
             * @param point [description]
             */
            static Invert<O extends Phaser.Geom.Point>(point: O): O;

            /**
             * [description]
             * @param point [description]
             * @param out [description]
             */
            static Negative<O extends Phaser.Geom.Point>(point: Phaser.Geom.Point, out?: O): O;

            /**
             * The x coordinate of this Point.
             */
            x: number;

            /**
             * The y coordinate of this Point.
             */
            y: number;

            /**
             * [description]
             * @param x The x coordinate of this Point. Default 0.
             * @param y The y coordinate of this Point. Default x.
             */
            setTo(x?: number, y?: number): Phaser.Geom.Point;

            /**
             * [description]
             * @param pointA [description]
             * @param pointB [description]
             * @param out [description]
             */
            static Project<O extends Phaser.Geom.Point>(pointA: Phaser.Geom.Point, pointB: Phaser.Geom.Point, out?: O): O;

            /**
             * [description]
             * @param pointA [description]
             * @param pointB [description]
             * @param out [description]
             */
            static ProjectUnit<O extends Phaser.Geom.Point>(pointA: Phaser.Geom.Point, pointB: Phaser.Geom.Point, out?: O): O;

            /**
             * [description]
             * @param point [description]
             * @param magnitude [description]
             */
            static SetMagnitude<O extends Phaser.Geom.Point>(point: O, magnitude: number): O;

        }

        /**
         * [description]
         */
        class Polygon {
            /**
             * 
             * @param points [description]
             */
            constructor(points?: Phaser.Geom.Point[]);

            /**
             * [description]
             * @param polygon [description]
             */
            static Clone(polygon: Phaser.Geom.Polygon): Phaser.Geom.Polygon;

            /**
             * [description]
             * @param polygon [description]
             * @param x [description]
             * @param y [description]
             */
            static Contains(polygon: Phaser.Geom.Polygon, x: number, y: number): boolean;

            /**
             * [description]
             * @param polygon [description]
             * @param point [description]
             */
            static ContainsPoint(polygon: Phaser.Geom.Polygon, point: Phaser.Geom.Point): boolean;

            /**
             * [description]
             * @param polygon [description]
             * @param out [description]
             */
            static GetAABB<O extends Phaser.Geom.Rectangle>(polygon: Phaser.Geom.Polygon, out?: O): O;

            /**
             * [description]
             * @param polygon [description]
             * @param output [description]
             */
            static GetNumberArray<O extends number[]>(polygon: Phaser.Geom.Polygon, output?: O): O;

            /**
             * The area of this Polygon.
             */
            area: number;

            /**
             * An array of number pair objects that make up this polygon. I.e. [ {x,y}, {x,y}, {x,y} ]
             */
            points: Phaser.Geom.Point[];

            /**
             * [description]
             * @param x [description]
             * @param y [description]
             */
            contains(x: number, y: number): boolean;

            /**
             * Sets this Polygon to the given points.
             * 
             * The points can be set from a variety of formats:
             * 
             * - An array of Point objects: `[new Phaser.Point(x1, y1), ...]`
             * - An array of objects with public x/y properties: `[obj1, obj2, ...]`
             * - An array of paired numbers that represent point coordinates: `[x1,y1, x2,y2, ...]`
             * - An array of arrays with two elements representing x/y coordinates: `[[x1, y1], [x2, y2], ...]`
             * 
             * `setTo` may also be called without any arguments to remove all points.
             * @param points [description]
             */
            setTo(points: any[]): Phaser.Geom.Polygon;

            /**
             * Calculates the area of the Polygon. This is available in the property Polygon.area
             */
            calculateArea(): number;

            /**
             * [description]
             * @param polygon [description]
             */
            static Reverse<O extends Phaser.Geom.Polygon>(polygon: O): O;

        }

        /**
         * Encapsulates a 2D rectangle defined by its corner point in the top-left and its extends in x (width) and y (height)
         */
        class Rectangle {
            /**
             * 
             * @param x [description] Default 0.
             * @param y [description] Default 0.
             * @param width [description] Default 0.
             * @param height [description] Default 0.
             */
            constructor(x?: number, y?: number, width?: number, height?: number);

            /**
             * [description]
             * @param rect [description]
             */
            static Area(rect: Phaser.Geom.Rectangle): number;

            /**
             * [description]
             * @param rect [description]
             */
            static Ceil<O extends Phaser.Geom.Rectangle>(rect: O): O;

            /**
             * [description]
             * @param rect [description]
             */
            static CeilAll<O extends Phaser.Geom.Rectangle>(rect: O): O;

            /**
             * [description]
             * @param rect [description]
             * @param x [description]
             * @param y [description]
             */
            static CenterOn<O extends Phaser.Geom.Rectangle>(rect: O, x: number, y: number): O;

            /**
             * [description]
             * @param source [description]
             */
            static Clone(source: Phaser.Geom.Rectangle): Phaser.Geom.Rectangle;

            /**
             * [description]
             * @param rect [description]
             * @param x [description]
             * @param y [description]
             */
            static Contains(rect: Phaser.Geom.Rectangle, x: number, y: number): boolean;

            /**
             * [description]
             * @param rect [description]
             * @param point [description]
             */
            static ContainsPoint(rect: Phaser.Geom.Rectangle, point: Phaser.Geom.Point): boolean;

            /**
             * [description]
             * @param rectA [description]
             * @param rectB [description]
             */
            static ContainsRect(rectA: Phaser.Geom.Rectangle, rectB: Phaser.Geom.Rectangle): boolean;

            /**
             * [description]
             * @param source [description]
             * @param dest [description]
             */
            static CopyFrom<O extends Phaser.Geom.Rectangle>(source: Phaser.Geom.Rectangle, dest: O): O;

            /**
             * [description]
             * @param rect [description]
             * @param out [description]
             */
            static Decompose(rect: Phaser.Geom.Rectangle, out?: any[]): any[];

            /**
             * [description]
             * @param rect [description]
             * @param toCompare [description]
             */
            static Equals(rect: Phaser.Geom.Rectangle, toCompare: Phaser.Geom.Rectangle): boolean;

            /**
             * [description]
             * @param target [description]
             * @param source [description]
             */
            static FitInside<O extends Phaser.Geom.Rectangle>(target: O, source: Phaser.Geom.Rectangle): O;

            /**
             * [description]
             * @param target [description]
             * @param source [description]
             */
            static FitOutside<O extends Phaser.Geom.Rectangle>(target: O, source: Phaser.Geom.Rectangle): O;

            /**
             * [description]
             * @param rect [description]
             */
            static Floor<O extends Phaser.Geom.Rectangle>(rect: O): O;

            /**
             * [description]
             * @param rect [description]
             */
            static FloorAll<O extends Phaser.Geom.Rectangle>(rect: O): O;

            /**
             * [description]
             * @param points [description]
             * @param out [description]
             */
            static FromPoints<O extends Phaser.Geom.Rectangle>(points: any[], out?: O): O;

            /**
             * [description]
             * @param rect [description]
             */
            static GetAspectRatio(rect: Phaser.Geom.Rectangle): number;

            /**
             * [description]
             * @param rect [description]
             * @param out [description]
             */
            static GetCenter<O extends Phaser.Geom.Point>(rect: Phaser.Geom.Rectangle, out?: O): O;

            /**
             * Position is a value between 0 and 1 where 0 = the top-left of the rectangle and 0.5 = the bottom right.
             * @param rectangle [description]
             * @param position [description]
             * @param out [description]
             */
            static GetPoint<O extends Phaser.Geom.Point>(rectangle: Phaser.Geom.Rectangle, position: number, out?: O): O;

            /**
             * [description]
             * @param rectangle [description]
             * @param step [description]
             * @param quantity [description]
             * @param out [description]
             */
            static GetPoints<O extends Phaser.Geom.Point[]>(rectangle: Phaser.Geom.Rectangle, step: number, quantity: integer, out?: O): O;

            /**
             * [description]
             * @param rect [description]
             * @param out [description]
             */
            static GetSize<O extends Phaser.Geom.Point>(rect: Phaser.Geom.Rectangle, out?: O): O;

            /**
             * [description]
             * @param rect [description]
             * @param x [description]
             * @param y [description]
             */
            static Inflate<O extends Phaser.Geom.Rectangle>(rect: O, x: number, y: number): O;

            /**
             * [description]
             * @param rect [description]
             * @param step [description]
             * @param quantity [description]
             * @param out [description]
             */
            static MarchingAnts<O extends Phaser.Geom.Point[]>(rect: Phaser.Geom.Rectangle, step: number, quantity: integer, out?: O): O;

            /**
             * [description]
             * @param target [description]
             * @param points [description]
             */
            static MergePoints<O extends Phaser.Geom.Rectangle>(target: O, points: Phaser.Geom.Point[]): O;

            /**
             * [description]
             * @param target [description]
             * @param source [description]
             */
            static MergeRect<O extends Phaser.Geom.Rectangle>(target: O, source: Phaser.Geom.Rectangle): O;

            /**
             * [description]
             * @param target [description]
             * @param x [description]
             * @param y [description]
             */
            static MergeXY<O extends Phaser.Geom.Rectangle>(target: O, x: number, y: number): O;

            /**
             * [description]
             * @param rect [description]
             * @param x [description]
             * @param y [description]
             */
            static Offset<O extends Phaser.Geom.Rectangle>(rect: O, x: number, y: number): O;

            /**
             * [description]
             * @param rect [description]
             * @param point [description]
             */
            static OffsetPoint<O extends Phaser.Geom.Rectangle>(rect: O, point: Phaser.Geom.Point): O;

            /**
             * [description]
             * @param rectA [description]
             * @param rectB [description]
             */
            static Overlaps(rectA: Phaser.Geom.Rectangle, rectB: Phaser.Geom.Rectangle): boolean;

            /**
             * [description]
             * @param rect [description]
             */
            static Perimeter(rect: Phaser.Geom.Rectangle): number;

            /**
             * [description]
             * @param rectangle [description]
             * @param angle [description]
             * @param out [description]
             */
            static PerimeterPoint<O extends Phaser.Geom.Point>(rectangle: Phaser.Geom.Rectangle, angle: integer, out?: O): O;

            /**
             * [description]
             * @param rect [description]
             * @param out [description]
             */
            static Random<O extends Phaser.Geom.Point>(rect: Phaser.Geom.Rectangle, out: O): O;

            /**
             * [description]
             */
            x: number;

            /**
             * [description]
             */
            y: number;

            /**
             * [description]
             */
            width: number;

            /**
             * [description]
             */
            height: number;

            /**
             * [description]
             * @param x [description]
             * @param y [description]
             */
            contains(x: number, y: number): boolean;

            /**
             * [description]
             * @param position [description]
             * @param output [description]
             */
            getPoint<O extends Phaser.Geom.Point>(position: number, output?: O): O;

            /**
             * [description]
             * @param quantity [description]
             * @param stepRate [description]
             * @param output [description]
             */
            getPoints<O extends Phaser.Geom.Point[]>(quantity: integer, stepRate?: number, output?: O): O;

            /**
             * [description]
             * @param point [description]
             */
            getRandomPoint<O extends Phaser.Geom.Point>(point?: O): O;

            /**
             * [description]
             * @param x [description]
             * @param y [description]
             * @param width [description]
             * @param height [description]
             */
            setTo(x: number, y: number, width: number, height: number): Phaser.Geom.Rectangle;

            /**
             * [description]
             */
            setEmpty(): Phaser.Geom.Rectangle;

            /**
             * [description]
             * @param x [description]
             * @param y [description] Default x.
             */
            setPosition(x: number, y?: number): Phaser.Geom.Rectangle;

            /**
             * [description]
             * @param width [description]
             * @param height [description] Default width.
             */
            setSize(width: number, height?: number): Phaser.Geom.Rectangle;

            /**
             * [description]
             */
            isEmpty(): boolean;

            /**
             * Returns a Line object that corresponds to the top of this Rectangle.
             * @param line A Line object to set the results in. If `undefined` a new Line will be created.
             */
            getLineA<O extends Phaser.Geom.Line>(line?: O): O;

            /**
             * Returns a Line object that corresponds to the right of this Rectangle.
             * @param line A Line object to set the results in. If `undefined` a new Line will be created.
             */
            getLineB<O extends Phaser.Geom.Line>(line?: O): O;

            /**
             * Returns a Line object that corresponds to the bottom of this Rectangle.
             * @param line A Line object to set the results in. If `undefined` a new Line will be created.
             */
            getLineC<O extends Phaser.Geom.Line>(line?: O): O;

            /**
             * Returns a Line object that corresponds to the left of this Rectangle.
             * @param line A Line object to set the results in. If `undefined` a new Line will be created.
             */
            getLineD<O extends Phaser.Geom.Line>(line?: O): O;

            /**
             * [description]
             */
            left: number;

            /**
             * [description]
             */
            right: number;

            /**
             * [description]
             */
            top: number;

            /**
             * [description]
             */
            bottom: number;

            /**
             * [description]
             */
            centerX: number;

            /**
             * [description]
             */
            centerY: number;

            /**
             * [description]
             * @param rect [description]
             * @param x [description]
             * @param y [description]
             */
            static Scale<O extends Phaser.Geom.Rectangle>(rect: O, x: number, y: number): O;

            /**
             * [description]
             * @param rectA [description]
             * @param rectB [description]
             * @param out [description]
             */
            static Union<O extends Phaser.Geom.Rectangle>(rectA: Phaser.Geom.Rectangle, rectB: Phaser.Geom.Rectangle, out?: O): O;

        }

        /**
         * A triangle is a plane created by connecting three points.
         * 
         * The first two arguments specify the first point, the middle two arguments
         * 
         * specify the second point, and the last two arguments specify the third point.
         */
        class Triangle {
            /**
             * 
             * @param x1 [description] Default 0.
             * @param y1 [description] Default 0.
             * @param x2 [description] Default 0.
             * @param y2 [description] Default 0.
             * @param x3 [description] Default 0.
             * @param y3 [description] Default 0.
             */
            constructor(x1?: number, y1?: number, x2?: number, y2?: number, x3?: number, y3?: number);

            /**
             * [description]
             * @param triangle [description]
             */
            static Area(triangle: Phaser.Geom.Triangle): number;

            /**
             * [description]
             * @param x [description]
             * @param y [description]
             * @param length [description]
             */
            static BuildEquilateral(x: number, y: number, length: number): Phaser.Geom.Triangle;

            /**
             * [description]
             * @param data A flat array of vertice coordinates like [x0,y0, x1,y1, x2,y2, ...]
             * @param holes An array of hole indices if any (e.g. [5, 8] for a 12-vertice input would mean one hole with vertices 5–7 and another with 8–11). Default null.
             * @param scaleX [description] Default 1.
             * @param scaleY [description] Default 1.
             * @param out [description]
             */
            static BuildFromPolygon<O extends Phaser.Geom.Triangle[]>(data: any[], holes?: any[], scaleX?: number, scaleY?: number, out?: O): O;

            /**
             * [description]
             * @param x [description]
             * @param y [description]
             * @param width [description]
             * @param height [description]
             */
            static BuildRight(x: number, y: number, width: number, height: number): Phaser.Geom.Triangle;

            /**
             * [description]
             * @param triangle [description]
             * @param x [description]
             * @param y [description]
             * @param centerFunc [description]
             */
            static CenterOn<O extends Phaser.Geom.Triangle>(triangle: O, x: number, y: number, centerFunc?: CenterFunction): O;

            /**
             * [description]
             * @param triangle [description]
             * @param out [description]
             */
            static Centroid<O extends Phaser.Geom.Point>(triangle: Phaser.Geom.Triangle, out?: O): O;

            /**
             * Computes the circumcentre of a triangle. The circumcentre is the centre of
             * the circumcircle, the smallest circle which encloses the triangle. It is also
             * the common intersection point of the perpendicular bisectors of the sides of
             * the triangle, and is the only point which has equal distance to all three
             * vertices of the triangle.
             * @param triangle [description]
             * @param out [description]
             */
            static CircumCenter<O extends Phaser.Math.Vector2>(triangle: Phaser.Geom.Triangle, out?: O): O;

            /**
             * [description]
             * @param triangle [description]
             * @param out [description]
             */
            static CircumCircle<O extends Phaser.Geom.Circle>(triangle: Phaser.Geom.Triangle, out?: O): O;

            /**
             * [description]
             * @param source [description]
             */
            static Clone(source: Phaser.Geom.Triangle): Phaser.Geom.Triangle;

            /**
             * [description]
             * @param triangle [description]
             * @param x [description]
             * @param y [description]
             */
            static Contains(triangle: Phaser.Geom.Triangle, x: number, y: number): boolean;

            /**
             * [description]
             * @param triangle [description]
             * @param points [description]
             * @param returnFirst [description]
             * @param out [description]
             */
            static ContainsArray(triangle: Phaser.Geom.Triangle, points: Phaser.Geom.Point[], returnFirst?: boolean, out?: any[]): Phaser.Geom.Point[];

            /**
             * [description]
             * @param triangle [description]
             * @param point [description]
             */
            static ContainsPoint(triangle: Phaser.Geom.Triangle, point: Phaser.Geom.Point): boolean;

            /**
             * [description]
             * @param source [description]
             * @param dest [description]
             */
            static CopyFrom<O extends Phaser.Geom.Triangle>(source: Phaser.Geom.Triangle, dest: O): O;

            /**
             * [description]
             * @param triangle [description]
             * @param out [description]
             */
            static Decompose(triangle: Phaser.Geom.Triangle, out?: any[]): any[];

            /**
             * [description]
             * @param triangle [description]
             * @param toCompare [description]
             */
            static Equals(triangle: Phaser.Geom.Triangle, toCompare: Phaser.Geom.Triangle): boolean;

            /**
             * [description]
             * @param triangle [description]
             * @param position [description]
             * @param out [description]
             */
            static GetPoint<O extends Phaser.Geom.Point>(triangle: Phaser.Geom.Triangle, position: number, out?: O): O;

            /**
             * [description]
             * @param triangle [description]
             * @param quantity [description]
             * @param stepRate [description]
             * @param out [description]
             */
            static GetPoints<O extends Phaser.Geom.Point>(triangle: Phaser.Geom.Triangle, quantity: integer, stepRate: number, out?: O): O;

            /**
             * [description]
             * @param triangle [description]
             * @param out [description]
             */
            static InCenter<O extends Phaser.Geom.Point>(triangle: Phaser.Geom.Triangle, out?: O): O;

            /**
             * [description]
             * @param triangle [description]
             * @param x [description]
             * @param y [description]
             */
            static Offset<O extends Phaser.Geom.Triangle>(triangle: O, x: number, y: number): O;

            /**
             * [description]
             * @param triangle [description]
             */
            static Perimeter(triangle: Phaser.Geom.Triangle): number;

            /**
             * [description]
             * @param triangle [description]
             * @param out [description]
             */
            static Random<O extends Phaser.Geom.Point>(triangle: Phaser.Geom.Triangle, out?: O): O;

            /**
             * [description]
             * @param triangle [description]
             * @param angle [description]
             */
            static Rotate<O extends Phaser.Geom.Triangle>(triangle: O, angle: number): O;

            /**
             * [description]
             * @param triangle [description]
             * @param point [description]
             * @param angle [description]
             */
            static RotateAroundPoint<O extends Phaser.Geom.Triangle>(triangle: O, point: Phaser.Geom.Point, angle: number): O;

            /**
             * [description]
             * @param triangle [description]
             * @param x [description]
             * @param y [description]
             * @param angle [description]
             */
            static RotateAroundXY<O extends Phaser.Geom.Triangle>(triangle: O, x: number, y: number, angle: number): O;

            /**
             * [description]
             */
            x1: number;

            /**
             * [description]
             */
            y1: number;

            /**
             * [description]
             */
            x2: number;

            /**
             * [description]
             */
            y2: number;

            /**
             * [description]
             */
            x3: number;

            /**
             * [description]
             */
            y3: number;

            /**
             * [description]
             * @param x [description]
             * @param y [description]
             */
            contains(x: number, y: number): boolean;

            /**
             * [description]
             * @param position [description]
             * @param output [description]
             */
            getPoint<O extends Phaser.Geom.Point>(position: number, output?: O): O;

            /**
             * [description]
             * @param quantity [description]
             * @param stepRate [description]
             * @param output [description]
             */
            getPoints<O extends Phaser.Geom.Point[]>(quantity: integer, stepRate?: number, output?: O): O;

            /**
             * [description]
             * @param point [description]
             */
            getRandomPoint<O extends Phaser.Geom.Point>(point?: O): O;

            /**
             * [description]
             * @param x1 [description] Default 0.
             * @param y1 [description] Default 0.
             * @param x2 [description] Default 0.
             * @param y2 [description] Default 0.
             * @param x3 [description] Default 0.
             * @param y3 [description] Default 0.
             */
            setTo(x1?: number, y1?: number, x2?: number, y2?: number, x3?: number, y3?: number): Phaser.Geom.Triangle;

            /**
             * Returns a Line object that corresponds to Line A of this Triangle.
             * @param line A Line object to set the results in. If `undefined` a new Line will be created.
             */
            getLineA<O extends Phaser.Geom.Line>(line?: O): O;

            /**
             * Returns a Line object that corresponds to Line B of this Triangle.
             * @param line A Line object to set the results in. If `undefined` a new Line will be created.
             */
            getLineB<O extends Phaser.Geom.Line>(line?: O): O;

            /**
             * Returns a Line object that corresponds to Line C of this Triangle.
             * @param line A Line object to set the results in. If `undefined` a new Line will be created.
             */
            getLineC<O extends Phaser.Geom.Line>(line?: O): O;

            /**
             * [description]
             */
            left: number;

            /**
             * [description]
             */
            right: number;

            /**
             * [description]
             */
            top: number;

            /**
             * [description]
             */
            bottom: number;

        }

    }

    namespace Input {
        type InteractiveObject = {
            /**
             * [description]
             */
            gameObject: Phaser.GameObjects.GameObject;
            /**
             * [description]
             */
            enabled: boolean;
            /**
             * [description]
             */
            draggable: boolean;
            /**
             * [description]
             */
            dropZone: boolean;
            /**
             * [description]
             */
            target: Phaser.GameObjects.GameObject;
            /**
             * [description]
             */
            camera: Phaser.Cameras.Scene2D.Camera;
            /**
             * [description]
             */
            hitArea: any;
            /**
             * [description]
             */
            hitAreaCallback: HitAreaCallback;
            /**
             * [description]
             */
            localX: number;
            /**
             * [description]
             */
            localY: number;
            /**
             * [description]
             */
            dragState: 0 | 1 | 2;
            /**
             * [description]
             */
            dragStartX: number;
            /**
             * [description]
             */
            dragStartY: number;
            /**
             * [description]
             */
            dragX: number;
            /**
             * [description]
             */
            dragY: number;
        };

        /**
         * [description]
         * @param gameObject [description]
         * @param hitArea [description]
         * @param hitAreaCallback [description]
         */
        function CreateInteractiveObject(gameObject: Phaser.GameObjects.GameObject, hitArea: any, hitAreaCallback: HitAreaCallback): Phaser.Input.InteractiveObject;

        namespace Gamepad {
            /**
             * [description]
             */
            class Axis {
                /**
                 * 
                 * @param pad [description]
                 * @param index [description]
                 */
                constructor(pad: Phaser.Input.Gamepad.Gamepad, index: integer);

                /**
                 * [description]
                 */
                pad: Phaser.Input.Gamepad.Gamepad;

                /**
                 * [description]
                 */
                events: Phaser.Events.EventEmitter;

                /**
                 * [description]
                 */
                index: integer;

                /**
                 * The raw axis value, between -1 and 1 with 0 being dead center.
                 * Use the method `getValue` to get a normalized value with the threshold applied.
                 */
                value: number;

                /**
                 * Movement tolerance threshold below which axis values are ignored in `getValue`.
                 */
                threshold: number;

                /**
                 * [description]
                 * @param value [description]
                 */
                update(value: number): void;

                /**
                 * Applies threshold to the value and returns it.
                 */
                getValue(): number;

            }

            /**
             * [description]
             */
            class Button {
                /**
                 * 
                 * @param pad [description]
                 * @param index [description]
                 */
                constructor(pad: Phaser.Input.Gamepad.Gamepad, index: integer);

                /**
                 * [description]
                 */
                pad: Phaser.Input.Gamepad.Gamepad;

                /**
                 * [description]
                 */
                events: Phaser.Events.EventEmitter;

                /**
                 * [description]
                 */
                index: integer;

                /**
                 * Between 0 and 1.
                 */
                value: number;

                /**
                 * Can be set for Analogue buttons to enable a 'pressure' threshold before considered as 'pressed'.
                 */
                threshold: number;

                /**
                 * Is the Button being pressed down or not?
                 */
                pressed: boolean;

                /**
                 * [description]
                 * @param data [description]
                 */
                update(data: GamepadButton): void;

            }

            namespace Configs {
            }

            /**
             * [description]
             */
            class Gamepad {
                /**
                 * 
                 * @param manager [description]
                 * @param id [description]
                 * @param index [description]
                 */
                constructor(manager: Phaser.Input.Gamepad.GamepadManager, id: string, index: number);

                /**
                 * [description]
                 */
                manager: Phaser.Input.Gamepad.GamepadManager;

                /**
                 * [description]
                 */
                id: string;

                /**
                 * [description]
                 */
                index: number;

                /**
                 * [description]
                 */
                connected: boolean;

                /**
                 * [description]
                 */
                timestamp: number;

                /**
                 * [description]
                 */
                buttons: Phaser.Input.Gamepad.Button[];

                /**
                 * [description]
                 */
                axes: Phaser.Input.Gamepad.Axis[];

                /**
                 * [description]
                 * @param data [description]
                 */
                update(data: Gamepad): void;

            }

            /**
             * [description]
             */
            class GamepadManager extends Phaser.Events.EventEmitter {
                /**
                 * 
                 * @param inputManager [description]
                 */
                constructor(inputManager: Phaser.Input.InputManager);

                /**
                 * [description]
                 */
                manager: Phaser.Input.InputManager;

                /**
                 * [description]
                 */
                enabled: boolean;

                /**
                 * [description]
                 */
                target: object;

                /**
                 * [description]
                 */
                handler: GamepadHandler;

                /**
                 * [description]
                 */
                gamepads: Phaser.Input.Gamepad.Gamepad[];

                /**
                 * Standard FIFO queue.
                 */
                queue: GamepadEvent[];

                /**
                 * [description]
                 */
                boot(): void;

                /**
                 * [description]
                 */
                startListeners(): void;

                /**
                 * [description]
                 */
                stopListeners(): void;

                /**
                 * [description]
                 */
                disconnectAll(): void;

                /**
                 * [description]
                 * @param pad [description]
                 */
                addPad(pad: Pad): Phaser.Input.Gamepad.Gamepad;

                /**
                 * [description]
                 * @param index [description]
                 * @param pad [description]
                 */
                removePad(index: number, pad: Pad): void;

                /**
                 * [description]
                 * @param pads [description]
                 */
                refreshPads(pads: Pad[]): void;

                /**
                 * [description]
                 */
                getAll(): Phaser.Input.Gamepad.Gamepad[];

                /**
                 * [description]
                 * @param index [description]
                 */
                getPad(index: number): Phaser.Input.Gamepad.Gamepad;

                /**
                 * [description]
                 */
                update(): void;

                /**
                 * [description]
                 */
                destroy(): void;

                /**
                 * The total number of connected game pads.
                 */
                total: number;

            }

            class Configs {
                /**
                 * Tatar SNES USB Controller Gamepad Configuration.
                 * USB Gamepad  (STANDARD GAMEPAD Vendor: 0079 Product: 0011)
                 */
                static SNES_USB: object;

                /**
                 * PlayStation DualShock 4 Gamepad Configuration.
                 * Sony PlayStation DualShock 4 (v2) wireless controller
                 */
                static DUALSHOCK_4: object;

                /**
                 * XBox 360 Gamepad Configuration.
                 */
                static XBOX_360: object;

            }

        }

        /**
         * [description]
         */
        class InputManager {
            /**
             * 
             * @param game [description]
             * @param config [description]
             */
            constructor(game: Phaser.Game, config: object);

            /**
             * [description]
             */
            game: Phaser.Game;

            /**
             * [description]
             */
            canvas: HTMLCanvasElement;

            /**
             * [description]
             */
            config: object;

            /**
             * [description]
             */
            enabled: boolean;

            /**
             * [description]
             */
            events: Phaser.Events.EventEmitter;

            /**
             * Standard FIFO queue.
             */
            queue: any[];

            /**
             * [description]
             */
            keyboard: Phaser.Input.Keyboard.KeyboardManager;

            /**
             * [description]
             */
            mouse: Phaser.Input.Mouse.MouseManager;

            /**
             * [description]
             */
            touch: Phaser.Input.Touch.TouchManager;

            /**
             * [description]
             */
            gamepad: Phaser.Input.Gamepad.GamepadManager;

            /**
             * [description]
             */
            activePointer: Phaser.Input.Pointer;

            /**
             * [description]
             */
            scale: Object;

            /**
             * If the top-most Scene in the Scene List receives an input it will stop input from
             * propagating any lower down the scene list, i.e. if you have a UI Scene at the top
             * and click something on it, that click will not then be passed down to any other
             * Scene below. Disable this to have input events passed through all Scenes, all the time.
             */
            globalTopOnly: boolean;

            /**
             * [description]
             */
            ignoreEvents: boolean;

            /**
             * [description]
             */
            bounds: Phaser.Geom.Rectangle;

            /**
             * The Boot handler is called by Phaser.Game when it first starts up.
             * The renderer is available by now.
             */
            boot(): void;

            /**
             * [description]
             */
            updateBounds(): void;

            /**
             * [description]
             */
            resize(): void;

            /**
             * [description]
             * @param time [description]
             */
            update(time: number): void;

            /**
             * Will always return an array.
             * Array contains matching Interactive Objects.
             * Array will be empty if no objects were matched.
             * x/y = pointer x/y (un-translated)
             * @param x [description]
             * @param y [description]
             * @param gameObjects [description]
             * @param camera [description]
             * @param output [description]
             */
            hitTest(x: number, y: number, gameObjects: any[], camera: Phaser.Cameras.Scene2D.Camera, output: any[]): any[];

            /**
             * x/y MUST be translated before being passed to this function,
             * unless the gameObject is guaranteed to not be rotated or scaled in any way.
             * @param gameObject [description]
             * @param x [description]
             * @param y [description]
             */
            pointWithinHitArea(gameObject: Phaser.GameObjects.GameObject, x: number, y: number): boolean;

            /**
             * x/y MUST be translated before being passed to this function,
             * unless the gameObject is guaranteed to not be rotated or scaled in any way.
             * @param object [description]
             * @param x [description]
             * @param y [description]
             */
            pointWithinInteractiveObject(object: Phaser.Input.InteractiveObject, x: number, y: number): boolean;

            /**
             * [description]
             * @param pageX [description]
             */
            transformX(pageX: number): number;

            /**
             * [description]
             * @param pageY [description]
             */
            transformY(pageY: number): number;

            /**
             * [description]
             */
            getOffsetX(): number;

            /**
             * [description]
             */
            getOffsetY(): number;

            /**
             * [description]
             */
            getScaleX(): number;

            /**
             * [description]
             */
            getScaleY(): number;

            /**
             * [description]
             */
            destroy(): void;

        }

        /**
         * [description]
         */
        class InputPlugin extends Phaser.Events.EventEmitter {
            /**
             * 
             * @param scene The Scene that owns this plugin.
             */
            constructor(scene: Phaser.Scene);

            /**
             * The Scene that owns this plugin.
             */
            scene: Phaser.Scene;

            /**
             * [description]
             */
            systems: Phaser.Scenes.Systems;

            /**
             * [description]
             */
            manager: Phaser.Input.InputManager;

            /**
             * A reference to this.scene.sys.displayList (set in boot)
             */
            displayList: Phaser.GameObjects.DisplayList;

            /**
             * A reference to the this.scene.sys.cameras (set in boot)
             */
            cameras: null;

            /**
             * [description]
             */
            keyboard: Phaser.Input.Keyboard.KeyboardManager;

            /**
             * [description]
             */
            mouse: Phaser.Input.Mouse.MouseManager;

            /**
             * [description]
             */
            gamepad: Phaser.Input.Gamepad.GamepadManager;

            /**
             * Only fire callbacks and events on the top-most Game Object in the display list (emulating DOM behavior)
             * and ignore any GOs below it, or call them all?
             */
            topOnly: boolean;

            /**
             * How often should the pointer input be checked?
             * Time given in ms
             * Pointer will *always* be checked if it has been moved by the user.
             * This controls how often it will be polled if it hasn't been moved.
             * Set to 0 to poll constantly. Set to -1 to only poll on user movement.
             */
            pollRate: integer;

            /**
             * The distance, in pixels, the pointer has to move while being held down, before it thinks it is being dragged.
             */
            dragDistanceThreshold: number;

            /**
             * The amount of time, in ms, the pointer has to be held down before it thinks it is dragging.
             */
            dragTimeThreshold: number;

            /**
             * [description]
             */
            boot(): void;

            /**
             * [description]
             */
            preUpdate(): void;

            /**
             * [description]
             * @param gameObject [description]
             */
            clear(gameObject: Phaser.GameObjects.GameObject): Phaser.GameObjects.GameObject;

            /**
             * [description]
             * @param gameObject [description]
             */
            disable(gameObject: Phaser.GameObjects.GameObject): void;

            /**
             * [description]
             * @param gameObject [description]
             * @param shape [description]
             * @param callback [description]
             * @param dropZone [description] Default false.
             */
            enable(gameObject: Phaser.GameObjects.GameObject, shape: object, callback: HitAreaCallback, dropZone?: boolean): Phaser.Input.InputPlugin;

            /**
             * [description]
             * @param pointer [description]
             */
            hitTestPointer(pointer: Phaser.Input.Pointer): any[];

            /**
             * [description]
             * @param pointer The Pointer to check for events against.
             */
            processDownEvents(pointer: Phaser.Input.Pointer): integer;

            /**
             * [description]
             * @param pointer [description]
             * @param time [description]
             */
            processDragEvents(pointer: number, time: number): integer;

            /**
             * [description]
             * @param pointer The pointer to check for events against.
             */
            processMoveEvents(pointer: Phaser.Input.Pointer): integer;

            /**
             * [description]
             * @param pointer [description]
             */
            processOverOutEvents(pointer: Phaser.Input.Pointer): integer;

            /**
             * [description]
             * @param pointer [description]
             */
            processUpEvents(pointer: Phaser.Input.Pointer): void;

            /**
             * Queues a Game Object for insertion into this Input Manager on the next update.
             * @param child The Game Object to add.
             */
            queueForInsertion(child: Phaser.GameObjects.GameObject): Phaser.Input.InputPlugin;

            /**
             * Queues a Game Object for removal from this Input Manager on the next update.
             * @param child The Game Object to remove.
             */
            queueForRemoval(child: Phaser.GameObjects.GameObject): Phaser.Input.InputPlugin;

            /**
             * [description]
             * @param gameObjects An array of Game Objects to change the draggable state on.
             * @param value Set to `true` if the Game Objects should be made draggable, `false` if they should be unset. Default true.
             */
            setDraggable(gameObjects: Phaser.GameObjects.GameObject | Phaser.GameObjects.GameObject[], value?: boolean): Phaser.Input.InputPlugin;

            /**
             * [description]
             * @param gameObjects An array of Game Objects to set the hit area on.
             * @param shape The shape or object to check if the pointer is within for hit area checks.
             * @param callback The 'contains' function to invoke to check if the pointer is within the hit area.
             */
            setHitArea(gameObjects: Phaser.GameObjects.GameObject | Phaser.GameObjects.GameObject[], shape?: object, callback?: HitAreaCallback): Phaser.Input.InputPlugin;

            /**
             * [description]
             * @param gameObjects An array of Game Objects to set as having a circle hit area.
             * @param x The center of the circle.
             * @param y The center of the circle.
             * @param radius The radius of the circle.
             * @param callback The hit area callback. If undefined it uses Circle.Contains.
             */
            setHitAreaCircle(gameObjects: Phaser.GameObjects.GameObject | Phaser.GameObjects.GameObject[], x: number, y: number, radius: number, callback?: HitAreaCallback): Phaser.Input.InputPlugin;

            /**
             * [description]
             * @param gameObjects An array of Game Objects to set as having an ellipse hit area.
             * @param x The center of the ellipse.
             * @param y The center of the ellipse.
             * @param width The width of the ellipse.
             * @param height The height of the ellipse.
             * @param callback The hit area callback. If undefined it uses Ellipse.Contains.
             */
            setHitAreaEllipse(gameObjects: Phaser.GameObjects.GameObject | Phaser.GameObjects.GameObject[], x: number, y: number, width: number, height: number, callback?: HitAreaCallback): Phaser.Input.InputPlugin;

            /**
             * [description]
             * @param gameObjects An array of Game Objects to set as having an ellipse hit area.
             * @param callback The hit area callback. If undefined it uses Rectangle.Contains.
             */
            setHitAreaFromTexture(gameObjects: Phaser.GameObjects.GameObject | Phaser.GameObjects.GameObject[], callback?: HitAreaCallback): Phaser.Input.InputPlugin;

            /**
             * [description]
             * @param gameObjects An array of Game Objects to set as having a rectangular hit area.
             * @param x The top-left of the rectangle.
             * @param y The top-left of the rectangle.
             * @param width The width of the rectangle.
             * @param height The height of the rectangle.
             * @param callback The hit area callback. If undefined it uses Rectangle.Contains.
             */
            setHitAreaRectangle(gameObjects: Phaser.GameObjects.GameObject | Phaser.GameObjects.GameObject[], x: number, y: number, width: number, height: number, callback?: HitAreaCallback): Phaser.Input.InputPlugin;

            /**
             * [description]
             * @param gameObjects An array of Game Objects to set as having a  triangular hit area.
             * @param x1 The x coordinate of the first point of the triangle.
             * @param y1 The y coordinate of the first point of the triangle.
             * @param x2 The x coordinate of the second point of the triangle.
             * @param y2 The y coordinate of the second point of the triangle.
             * @param x3 The x coordinate of the third point of the triangle.
             * @param y3 The y coordinate of the third point of the triangle.
             * @param callback The hit area callback. If undefined it uses Triangle.Contains.
             */
            setHitAreaTriangle(gameObjects: Phaser.GameObjects.GameObject | Phaser.GameObjects.GameObject[], x1: number, y1: number, x2: number, y2: number, x3: number, y3: number, callback?: HitAreaCallback): Phaser.Input.InputPlugin;

            /**
             * [description]
             */
            setPollAlways(): Phaser.Input.InputPlugin;

            /**
             * [description]
             */
            setPollOnMove(): Phaser.Input.InputPlugin;

            /**
             * [description]
             * @param value [description]
             */
            setPollRate(value: number): Phaser.Input.InputPlugin;

            /**
             * [description]
             * @param value [description]
             */
            setGlobalTopOnly(value: boolean): Phaser.Input.InputPlugin;

            /**
             * [description]
             * @param value [description]
             */
            setTopOnly(value: boolean): Phaser.Input.InputPlugin;

            /**
             * Given an array of Game Objects, sort the array and return it,
             * so that the objects are in index order with the lowest at the bottom.
             * @param gameObjects [description]
             */
            sortGameObjects(gameObjects: Phaser.GameObjects.GameObject[]): Phaser.GameObjects.GameObject[];

            /**
             * Return the child lowest down the display list (with the smallest index)
             * @param childA [description]
             * @param childB [description]
             */
            sortHandlerGO(childA: Phaser.GameObjects.GameObject, childB: Phaser.GameObjects.GameObject): integer;

            /**
             * Return the child lowest down the display list (with the smallest index)
             * @param childA [description]
             * @param childB [description]
             */
            sortHandlerIO(childA: Phaser.Input.InteractiveObject, childB: Phaser.Input.InteractiveObject): integer;

            /**
             * Given an array of Interactive Objects, sort the array and return it,
             * so that the objects are in index order with the lowest at the bottom.
             * @param interactiveObjects [description]
             */
            sortInteractiveObjects(interactiveObjects: Phaser.Input.InteractiveObject[]): Phaser.Input.InteractiveObject[];

            /**
             * [description]
             */
            stopPropagation(): Phaser.Input.InputPlugin;

            /**
             * [description]
             * @param time [description]
             * @param delta [description]
             */
            update(time: number, delta: number): void;

            /**
             * The Scene that owns this plugin is shutting down.
             */
            shutdown(): void;

            /**
             * [description]
             */
            destroy(): void;

            /**
             * The current active input Pointer.
             */
            activePointer: Phaser.Input.Pointer;

            /**
             * The x coordinates of the ActivePointer based on the first camera in the camera list.
             * This is only safe to use if your game has just 1 non-transformed camera and doesn't use multi-touch.
             */
            x: number;

            /**
             * The y coordinates of the ActivePointer based on the first camera in the camera list.
             * This is only safe to use if your game has just 1 non-transformed camera and doesn't use multi-touch.
             */
            y: number;

        }

        namespace Keyboard {
            /**
             * [description]
             * 
             * 
             * 
             * `keys` argument can be:
             * 
             * 
             * 
             * A string (ATARI)
             * 
             * An array of either integers (key codes) or strings, or a mixture of both
             * 
             * An array of objects (such as Key objects) with a public 'keyCode' property
             */
            class KeyCombo {
                /**
                 * 
                 * @param keyboardManager [description]
                 * @param keys [description]
                 * @param config [description]
                 */
                constructor(keyboardManager: Phaser.Input.Keyboard.KeyboardManager, keys: string | integer[] | object[], config?: KeyComboConfig);

                /**
                 * Used internally by the KeyCombo class.
                 * Return `true` if it reached the end of the combo, `false` if not.
                 * @param event [description]
                 * @param combo [description]
                 */
                static AdvanceKeyCombo(event: KeyboardEvent, combo: Phaser.Input.Keyboard.KeyCombo): boolean;

                /**
                 * [description]
                 */
                manager: Phaser.Input.Keyboard.KeyboardManager;

                /**
                 * [description]
                 */
                enabled: boolean;

                /**
                 * [description]
                 */
                keyCodes: any[];

                /**
                 * The current keyCode the combo is waiting for.
                 */
                current: integer;

                /**
                 * The current index of the key being waited for in the 'keys' string.
                 */
                index: number;

                /**
                 * The length of this combo (in keycodes)
                 */
                size: number;

                /**
                 * The time the previous key in the combo was matched.
                 */
                timeLastMatched: number;

                /**
                 * Has this Key Combo been matched yet?
                 */
                matched: boolean;

                /**
                 * The time the entire combo was matched.
                 */
                timeMatched: number;

                /**
                 * If they press the wrong key do we reset the combo?
                 */
                resetOnWrongKey: boolean;

                /**
                 * The max delay in ms between each key press. Above this the combo is reset. 0 means disabled.
                 */
                maxKeyDelay: integer;

                /**
                 * If previously matched and they press Key 1 again, will it reset?
                 */
                resetOnMatch: boolean;

                /**
                 * If the combo matches, will it delete itself?
                 */
                deleteOnMatch: boolean;

                /**
                 * [description]
                 */
                onKeyDown: KeyboardKeydownCallback;

                /**
                 * How far complete is this combo? A value between 0 and 1.
                 */
                progress: number;

                /**
                 * [description]
                 */
                destroy(): void;

                /**
                 * Used internally by the KeyCombo class.
                 * @param event [description]
                 * @param combo [description]
                 */
                static ProcessKeyCombo(event: KeyboardEvent, combo: Phaser.Input.Keyboard.KeyCombo): boolean;

                /**
                 * Used internally by the KeyCombo class.
                 * @param combo The KeyCombo to reset.
                 */
                static ResetKeyCombo(combo: Phaser.Input.Keyboard.KeyCombo): Phaser.Input.Keyboard.KeyCombo;

            }

            /**
             * The Keyboard class monitors keyboard input and dispatches keyboard events.
             * 
             * 
             * 
             * _Note_: many keyboards are unable to process certain combinations of keys due to hardware limitations known as ghosting.
             * 
             * See http://www.html5gamedevs.com/topic/4876-impossible-to-use-more-than-2-keyboard-input-buttons-at-the-same-time/ for more details.
             * 
             * 
             * 
             * Also please be aware that certain browser extensions can disable or override Phaser keyboard handling.
             * 
             * For example the Chrome extension vimium is known to disable Phaser from using the D key. And there are others.
             * 
             * So please check your extensions before opening Phaser issues.
             */
            class KeyboardManager extends Phaser.Events.EventEmitter {
                /**
                 * 
                 * @param inputManager [description]
                 */
                constructor(inputManager: Phaser.Input.InputManager);

                /**
                 * [description]
                 */
                manager: Phaser.Input.InputManager;

                /**
                 * [description]
                 */
                enabled: boolean;

                /**
                 * [description]
                 */
                target: object;

                /**
                 * [description]
                 */
                keys: Phaser.Input.Keyboard.Key[];

                /**
                 * [description]
                 */
                combos: Phaser.Input.Keyboard.KeyCombo[];

                /**
                 * [description]
                 */
                captures: any[];

                /**
                 * [description]
                 */
                queue: KeyboardEvent[];

                /**
                 * [description]
                 */
                handler: KeyboardHandler;

                /**
                 * The Boot handler is called by Phaser.Game when it first starts up.
                 */
                boot(): void;

                /**
                 * [description]
                 */
                startListeners(): void;

                /**
                 * [description]
                 */
                stopListeners(): void;

                /**
                 * Creates and returns an object containing 4 hotkeys for Up, Down, Left and Right, and also space and shift.
                 */
                createCursorKeys(): object;

                /**
                 * A practical way to create an object containing user selected hotkeys.
                 * 
                 * For example,
                 * 
                 *     addKeys({ 'up': Phaser.Input.Keyboard.KeyCodes.W, 'down': Phaser.Input.Keyboard.KeyCodes.S });
                 * 
                 * would return an object containing properties (`up` and `down`) referring to {@link Phaser.Input.Keyboard.Key} objects.
                 * @param keys [description]
                 */
                addKeys(keys: object): object;

                /**
                 * If you need more fine-grained control over a Key you can create a new Phaser.Key object via this method.
                 * The Key object can then be polled, have events attached to it, etc.
                 * @param keyCode [description]
                 */
                addKey(keyCode: string | integer): Phaser.Input.Keyboard.Key;

                /**
                 * Removes a Key object from the Keyboard manager.
                 * @param keyCode [description]
                 */
                removeKey(keyCode: string | integer): void;

                /**
                 * [description]
                 * @param keyCodes [description]
                 */
                addKeyCapture(keyCodes: string | integer | string[] | integer[]): void;

                /**
                 * [description]
                 * @param keyCodes [description]
                 */
                removeKeyCapture(keyCodes: string | integer | string[] | integer[]): void;

                /**
                 * [description]
                 * @param keys [description]
                 * @param config [description]
                 */
                createCombo(keys: string | integer[] | object[], config: KeyComboConfig): Phaser.Input.Keyboard.KeyCombo;

                /**
                 * [description]
                 */
                update(): void;

                /**
                 * [description]
                 */
                shutdown(): void;

                /**
                 * [description]
                 */
                destroy(): void;

            }

            /**
             * Returns `true` if the Key was pressed down within the `duration` value given, or `false` if it either isn't down,
             * or was pressed down longer ago than then given duration.
             * @param key [description]
             * @param duration [description] Default 50.
             */
            function DownDuration(key: Phaser.Input.Keyboard.Key, duration?: integer): boolean;

            /**
             * The justDown value allows you to test if this Key has just been pressed down or not.
             * When you check this value it will return `true` if the Key is down, otherwise `false`.
             * You can only call justDown once per key press. It will only return `true` once, until the Key is released and pressed down again.
             * This allows you to use it in situations where you want to check if this key is down without using a Signal, such as in a core game loop.
             * @param key [description]
             */
            function JustDown(key: Phaser.Input.Keyboard.Key): boolean;

            /**
             * The justUp value allows you to test if this Key has just been released or not.
             * When you check this value it will return `true` if the Key is up, otherwise `false`.
             * You can only call justUp once per key release. It will only return `true` once, until the Key is pressed down and released again.
             * This allows you to use it in situations where you want to check if this key is up without using a Signal, such as in a core game loop.
             * @param key [description]
             */
            function JustUp(key: Phaser.Input.Keyboard.Key): boolean;

            /**
             * A generic Key object which can be passed to the Process functions (and so on)
             * 
             * keycode must be an integer
             */
            class Key {
                /**
                 * 
                 * @param keyCode The keycode of this key.
                 */
                constructor(keyCode: integer);

                /**
                 * The keycode of this key.
                 */
                keyCode: integer;

                /**
                 * The original DOM event.
                 */
                originalEvent: KeyboardEvent;

                /**
                 * Should this Key prevent event propagation?
                 */
                preventDefault: boolean;

                /**
                 * Can this Key be processed?
                 */
                enabled: boolean;

                /**
                 * The "down" state of the key. This will remain `true` for as long as the keyboard thinks this key is held down.
                 */
                isDown: boolean;

                /**
                 * The "up" state of the key. This will remain `true` for as long as the keyboard thinks this key is up.
                 */
                isUp: boolean;

                /**
                 * The down state of the ALT key, if pressed at the same time as this key.
                 */
                altKey: boolean;

                /**
                 * The down state of the CTRL key, if pressed at the same time as this key.
                 */
                ctrlKey: boolean;

                /**
                 * The down state of the SHIFT key, if pressed at the same time as this key.
                 */
                shiftKey: boolean;

                /**
                 * The location of the modifier key. 0 for standard (or unknown), 1 for left, 2 for right, 3 for numpad.
                 */
                location: number;

                /**
                 * The timestamp when the key was last pressed down.
                 */
                timeDown: number;

                /**
                 * The number of milliseconds this key has been held down for.
                 * If the key is down this value holds the duration of that key press and is constantly updated.
                 * If the key is up it holds the duration of the previous down session.
                 */
                duration: number;

                /**
                 * The timestamp when the key was last released.
                 */
                timeUp: number;

                /**
                 * If a key is held down this holds down the number of times the key has 'repeated'.
                 */
                repeats: number;

            }

            /**
             * Keyboard Codes.
             */
            enum KeyCodes {
                BACKSPACE,
                TAB,
                ENTER,
                SHIFT,
                CTRL,
                ALT,
                PAUSE,
                CAPS_LOCK,
                ESC,
                SPACE,
                PAGE_UP,
                PAGE_DOWN,
                END,
                HOME,
                LEFT,
                UP,
                RIGHT,
                DOWN,
                PRINT_SCREEN,
                INSERT,
                DELETE,
                ZERO,
                ONE,
                TWO,
                THREE,
                FOUR,
                FIVE,
                SIX,
                SEVEN,
                EIGHT,
                NINE,
                A,
                B,
                C,
                D,
                E,
                F,
                G,
                H,
                I,
                J,
                K,
                L,
                M,
                N,
                O,
                P,
                Q,
                R,
                S,
                T,
                U,
                V,
                W,
                X,
                Y,
                Z,
                F1,
                F2,
                F3,
                F4,
                F5,
                F6,
                F7,
                F8,
                F9,
                F10,
                F11,
                F12,
                SEMICOLON,
                PLUS,
                COMMA,
                MINUS,
                PERIOD,
                FORWARD_SLASH,
                BACK_SLASH,
                QUOTES,
                BACKTICK,
                OPEN_BRACKET,
                CLOSED_BRACKET,
            }

            namespace Keys {
                /**
                 * Used internally by the KeyboardManager.
                 * @param key [description]
                 * @param event [description]
                 */
                function ProcessKeyDown(key: Phaser.Input.Keyboard.Key, event: KeyboardEvent): Phaser.Input.Keyboard.Key;

                /**
                 * Used internally by the KeyboardManager.
                 * @param key [description]
                 * @param event [description]
                 */
                function ProcessKeyUp(key: Phaser.Input.Keyboard.Key, event: KeyboardEvent): Phaser.Input.Keyboard.Key;

                /**
                 * Resets a Key object back to its default settings.
                 *  Optionally resets the keyCode as well.
                 * @param key [description]
                 * @param clearKeyCode [description] Default false.
                 */
                function ResetKey(key: Phaser.Input.Keyboard.Key, clearKeyCode?: boolean): Phaser.Input.Keyboard.Key;

            }

            /**
             * Returns `true` if the Key was released within the `duration` value given, or `false` if it either isn't up,
             * or was released longer ago than then given duration.
             * @param key [description]
             * @param duration [description] Default 50.
             */
            function UpDuration(key: Phaser.Input.Keyboard.Key, duration?: integer): boolean;

        }

        namespace Mouse {
            /**
             * [description]
             */
            class MouseManager {
                /**
                 * 
                 * @param inputManager [description]
                 */
                constructor(inputManager: Phaser.Input.InputManager);

                /**
                 * [description]
                 */
                manager: Phaser.Input.InputManager;

                /**
                 * If true the DOM mouse events will have event.preventDefault applied to them, if false they will propagate fully.
                 */
                capture: boolean;

                /**
                 * [description]
                 */
                enabled: boolean;

                /**
                 * [description]
                 */
                target: null;

                /**
                 * [description]
                 */
                handler: MouseHandler;

                /**
                 * If the mouse has been pointer locked successfully this will be set to true.
                 */
                locked: boolean;

                /**
                 * [description]
                 */
                boot(): void;

                /**
                 * [description]
                 */
                disableContextMenu(): Phaser.Input.Mouse.MouseManager;

                /**
                 * If the browser supports it, you can request that the pointer be locked to the browser window.
                 * 
                 * This is classically known as 'FPS controls', where the pointer can't leave the browser until
                 * the user presses an exit key.
                 * 
                 * If the browser successfully enters a locked state, a `POINTER_LOCK_CHANGE_EVENT` will be dispatched,
                 * from the games Input Manager, with an `isPointerLocked` property.
                 * 
                 * It is important to note that pointer lock can only be enabled after an 'engagement gesture',
                 * see: https://w3c.github.io/pointerlock/#dfn-engagement-gesture.
                 */
                requestPointerLock(): void;

                /**
                 * Internal pointerLockChange handler.
                 * @param event The native event from the browser.
                 */
                pointerLockChange(event: MouseHandler): void;

                /**
                 * If the browser supports pointer lock, this will request that the pointer lock is released. If
                 * the browser successfully enters a locked state, a 'POINTER_LOCK_CHANGE_EVENT' will be
                 * dispatched - from the game's input manager - with an `isPointerLocked` property.
                 */
                releasePointerLock(): void;

                /**
                 * [description]
                 */
                startListeners(): void;

                /**
                 * [description]
                 */
                stopListeners(): void;

                /**
                 * [description]
                 */
                destroy(): void;

            }

        }

        /**
         * [description]
         */
        class Pointer {
            /**
             * 
             * @param manager [description]
             * @param id [description]
             */
            constructor(manager: Phaser.Input.InputManager, id: integer);

            /**
             * [description]
             */
            manager: Phaser.Input.InputManager;

            /**
             * [description]
             */
            id: integer;

            /**
             * [description]
             */
            event: null;

            /**
             * The camera the Pointer interacted with during its last update.
             * A Pointer can only ever interact with one camera at once, which will be the top-most camera
             * in the list should multiple cameras be positioned on-top of each other.
             */
            camera: Phaser.Cameras.Scene2D.Camera;

            /**
             * 0: No button or un-initialized
             * 1: Left button
             * 2: Right button
             * 4: Wheel button or middle button
             * 8: 4th button (typically the "Browser Back" button)
             * 16: 5th button (typically the "Browser Forward" button)
             */
            buttons: number;

            /**
             * [description]
             */
            position: Phaser.Math.Vector2;

            /**
             * X coordinate of the Pointer when Button 1 (left button), or Touch, was pressed, used for dragging objects.
             */
            downX: number;

            /**
             * Y coordinate of the Pointer when Button 1 (left button), or Touch, was pressed, used for dragging objects.
             */
            downY: number;

            /**
             * Time when Button 1 (left button), or Touch, was pressed, used for dragging objects.
             */
            downTime: number;

            /**
             * X coordinate of the Pointer when Button 1 (left button), or Touch, was released, used for dragging objects.
             */
            upX: number;

            /**
             * Y coordinate of the Pointer when Button 1 (left button), or Touch, was released, used for dragging objects.
             */
            upY: number;

            /**
             * Time when Button 1 (left button), or Touch, was released, used for dragging objects.
             */
            upTime: number;

            /**
             * Is the primary button down? (usually button 0, the left mouse button)
             */
            primaryDown: boolean;

            /**
             * The Drag State of the Pointer:
             * 
             * 0 = Not dragging anything
             * 1 = Being checked if dragging
             * 2 = Dragging something
             */
            dragState: number;

            /**
             * Is _any_ button on this pointer considered as being down?
             */
            isDown: boolean;

            /**
             * [description]
             */
            dirty: boolean;

            /**
             * [description]
             */
            justDown: boolean;

            /**
             * [description]
             */
            justUp: boolean;

            /**
             * [description]
             */
            justMoved: boolean;

            /**
             * Did the previous input event come from a Touch input (true) or Mouse? (false)
             */
            wasTouch: boolean;

            /**
             * If the mouse is locked, the horizontal relative movement of the Pointer in pixels since last frame.
             */
            movementX: number;

            /**
             * If the mouse is locked, the vertical relative movement of the Pointer in pixels since last frame.
             */
            movementY: number;

            /**
             * [description]
             * @param camera [description]
             * @param output [description]
             */
            positionToCamera(camera: Phaser.Cameras.Scene2D.Camera, output: Phaser.Math.Vector2 | object): Phaser.Math.Vector2 | object;

            /**
             * [description]
             */
            x: number;

            /**
             * [description]
             */
            y: number;

            /**
             * [description]
             */
            reset(): void;

            /**
             * [description]
             * @param event [description]
             * @param time The current timestamp as generated by the Request Animation Frame or SetTimeout.
             */
            touchmove(event: TouchEvent, time: integer): void;

            /**
             * [description]
             * @param event [description]
             * @param time The current timestamp as generated by the Request Animation Frame or SetTimeout.
             */
            move(event: MouseEvent, time: integer): void;

            /**
             * [description]
             * @param event [description]
             * @param time The current timestamp as generated by the Request Animation Frame or SetTimeout.
             */
            down(event: MouseEvent, time: integer): void;

            /**
             * [description]
             * @param event [description]
             * @param time The current timestamp as generated by the Request Animation Frame or SetTimeout.
             */
            touchstart(event: TouchEvent, time: integer): void;

            /**
             * [description]
             * @param event [description]
             * @param time The current timestamp as generated by the Request Animation Frame or SetTimeout.
             */
            up(event: MouseEvent, time: integer): void;

            /**
             * [description]
             * @param event [description]
             * @param time The current timestamp as generated by the Request Animation Frame or SetTimeout.
             */
            touchend(event: TouchEvent, time: integer): void;

            /**
             * [description]
             */
            noButtonDown(): boolean;

            /**
             * [description]
             */
            leftButtonDown(): boolean;

            /**
             * [description]
             */
            rightButtonDown(): boolean;

            /**
             * [description]
             */
            middleButtonDown(): boolean;

            /**
             * [description]
             */
            backButtonDown(): boolean;

            /**
             * [description]
             */
            forwardButtonDown(): boolean;

            /**
             * [description]
             */
            destroy(): void;

        }

        namespace Touch {
            /**
             * [description]
             */
            class TouchManager {
                /**
                 * 
                 * @param inputManager [description]
                 */
                constructor(inputManager: Phaser.Input.InputManager);

                /**
                 * [description]
                 */
                manager: Phaser.Input.InputManager;

                /**
                 * If true the DOM events will have event.preventDefault applied to them, if false they will propagate fully.
                 */
                capture: boolean;

                /**
                 * [description]
                 */
                enabled: boolean;

                /**
                 * [description]
                 */
                target: null;

                /**
                 * [description]
                 */
                handler: TouchHandler;

                /**
                 * [description]
                 */
                boot(): void;

                /**
                 * [description]
                 */
                startListeners(): void;

                /**
                 * [description]
                 */
                stopListeners(): void;

                /**
                 * [description]
                 */
                destroy(): void;

            }

        }

    }

    namespace Loader {
        /**
         * [description]
         */
        class File {
            /**
             * 
             * @param fileConfig [description]
             */
            constructor(fileConfig: FileConfig);

            /**
             * The file type string (image, json, etc) for sorting within the Loader.
             */
            type: string;

            /**
             * Unique cache key (unique within its file type)
             */
            key: string;

            /**
             * The URL of the file, not including baseURL.
             */
            url: string;

            /**
             * Set when the Loader calls 'load' on this file.
             */
            src: string;

            /**
             * The merged XHRSettings for this file.
             */
            xhrSettings: XHRSettingsObject;

            /**
             * The LoaderPlugin instance that is loading this file.
             */
            loader: Phaser.Loader.LoaderPlugin;

            /**
             * The XMLHttpRequest instance (as created by XHR Loader) that is loading this File.
             */
            xhrLoader: XMLHttpRequest;

            /**
             * The current state of the file. One of the FILE_CONST values.
             */
            state: integer;

            /**
             * The total size of this file.
             * Set by onProgress and only if loading via XHR.
             */
            bytesTotal: number;

            /**
             * Updated as the file loads.
             * Only set if loading via XHR.
             */
            bytesLoaded: number;

            /**
             * A percentage value between 0 and 1 indicating how much of this file has loaded.
             * Only set if loading via XHR.
             */
            percentComplete: number;

            /**
             * For CORs based loading.
             * If this is undefined then the File will check BaseLoader.crossOrigin and use that (if set)
             */
            crossOrigin: string | undefined;

            /**
             * The processed file data, stored in here after the file has loaded.
             */
            data: any;

            /**
             * A config object that can be used by file types to store transitional data.
             */
            config: object;

            /**
             * If this is a multipart file, i.e. an atlas and its json together, then this is a reference
             * to the linked file. Set and used internally by the Loader.
             */
            linkFile: Phaser.Loader.File;

            /**
             * If this is a multipart file, i.e. an atlas and its json together, then this is a reference
             * to the type of linked association. Set and used internally by the Loader.
             */
            linkType: string;

            /**
             * If this is a link file, is this the parent or the sibbling?
             */
            linkParent: boolean;

            /**
             * If this is a multipart file, i.e. an atlas and its json together, then this is a reference
             * to the linked file. Set and used internally by the Loader.
             * @param fileB The linked file.
             * @param linkType The type of association.
             */
            setLinkFile(fileB: Phaser.Loader.File, linkType: string): void;

            /**
             * Resets the XHRLoader instance.
             */
            resetXHR(): void;

            /**
             * Called by the Loader, starts the actual file downloading.
             * During the load the methods onLoad, onProgress, etc are called based on the XHR events.
             * @param loader The Loader that will load this File.
             */
            load(loader: Phaser.Loader.LoaderPlugin): void;

            /**
             * Called when the file finishes loading, is sent a DOM ProgressEvent.
             * @param event The DOM ProgressEvent that resulted from this load.
             */
            onLoad(event: ProgressEvent): void;

            /**
             * Called if the file errors while loading, is sent a DOM ProgressEvent.
             * @param event The DOM ProgressEvent that resulted from this error.
             */
            onError(event: ProgressEvent): void;

            /**
             * Called during the file load progress. Is sent a DOM ProgressEvent.
             * @param event The DOM ProgressEvent.
             */
            onProgress(event: ProgressEvent): void;

            /**
             * Usually overridden by the FileTypes and is called by Loader.finishedLoading.
             * The callback is Loader.processUpdate
             * @param callback The callback to invoke to process this File.
             */
            onProcess(callback: FileProcessCallback): void;

            /**
             * Called with the File has completed loading.
             * Checks on the state of its linkfile, if set.
             */
            onComplete(): void;

            /**
             * Static method for creating object URL using URL API and setting it as image 'src' attribute.
             * If URL API is not supported (usually on old browsers) it falls back to creating Base64 encoded url using FileReader.
             * @param image Image object which 'src' attribute should be set to object URL.
             * @param blob A Blob object to create an object URL for.
             * @param defaultType Default mime type used if blob type is not available.
             */
            static createObjectURL(image: Image, blob: Blob, defaultType: string): void;

            /**
             * Static method for releasing an existing object URL which was previously created
             * by calling {@link File#createObjectURL} method.
             * @param image Image object which 'src' attribute should be revoked.
             */
            static revokeObjectURL(image: Image): void;

        }

        namespace FileTypes {
            /**
             * An Animation JSON File.
             * @param key The key of the file within the loader.
             * @param url The url to load the file from.
             * @param path The path of the file.
             * @param xhrSettings Optional file specific XHR settings.
             */
            function AnimationJSONFile(key: string, url: string, path: string, xhrSettings: XHRSettingsObject): any;

            /**
             * An Atlas JSON File.
             * @param key The key of the file within the loader.
             * @param textureURL The url to load the texture file from.
             * @param atlasURL The url to load the atlas file from.
             * @param path The path of the file.
             * @param textureXhrSettings Optional texture file specific XHR settings.
             * @param atlasXhrSettings Optional atlas file specific XHR settings.
             */
            function AtlasJSONFile(key: string, textureURL: string, atlasURL: string, path: string, textureXhrSettings: XHRSettingsObject, atlasXhrSettings: XHRSettingsObject): object;

            /**
             * [description]
             */
            class AudioFile extends Phaser.Loader.File {
                /**
                 * 
                 * @param key [description]
                 * @param url [description]
                 * @param path [description]
                 * @param xhrSettings [description]
                 * @param audioContext [description]
                 */
                constructor(key: string, url: string, path: string, xhrSettings: XHRSettingsObject, audioContext: AudioContext);

                /**
                 * [description]
                 * @param callback [description]
                 */
                onProcess(callback: FileProcessCallback): void;

            }

            /**
             * [description]
             */
            class BinaryFile extends Phaser.Loader.File {
                /**
                 * 
                 * @param key [description]
                 * @param url [description]
                 * @param path [description]
                 * @param xhrSettings [description]
                 */
                constructor(key: string, url: string, path: string, xhrSettings: XHRSettingsObject);

            }

            /**
             * An Bitmap Font File.
             * @param key The key of the file within the loader.
             * @param textureURL The url to load the texture file from.
             * @param xmlURL The url to load the atlas file from.
             * @param path The path of the file.
             * @param textureXhrSettings Optional texture file specific XHR settings.
             * @param xmlXhrSettings Optional atlas file specific XHR settings.
             */
            function BitmapFontFile(key: string, textureURL: string, xmlURL: string, path: string, textureXhrSettings: XHRSettingsObject, xmlXhrSettings: XHRSettingsObject): object;

            /**
             * [description]
             */
            class GLSLFile extends Phaser.Loader.File {
                /**
                 * 
                 * @param key [description]
                 * @param url [description]
                 * @param path [description]
                 * @param xhrSettings [description]
                 */
                constructor(key: string, url: string, path: string, xhrSettings: XHRSettingsObject);

            }

            /**
             * [description]
             */
            class HTML5AudioFile extends Phaser.Loader.File {
                /**
                 * 
                 * @param key [description]
                 * @param url [description]
                 * @param path [description]
                 * @param config [description]
                 * @param locked [description]
                 */
                constructor(key: string, url: string, path: string, config: XHRSettingsObject, locked: boolean);

            }

            /**
             * [description]
             */
            class HTMLFile extends Phaser.Loader.File {
                /**
                 * 
                 * @param key [description]
                 * @param url [description]
                 * @param width [description]
                 * @param height [description]
                 * @param path [description]
                 * @param xhrSettings [description]
                 */
                constructor(key: string, url: string, width: number, height: number, path: string, xhrSettings: XHRSettingsObject);

            }

            /**
             * [description]
             */
            class ImageFile extends Phaser.Loader.File {
                /**
                 * 
                 * @param key [description]
                 * @param url [description]
                 * @param path [description]
                 * @param xhrSettings [description]
                 * @param config [description]
                 */
                constructor(key: string, url: string, path: string, xhrSettings: XHRSettingsObject, config: object);

            }

            /**
             * [description]
             */
            class JSONFile extends Phaser.Loader.File {
                /**
                 * 
                 * @param key [description]
                 * @param url [description]
                 * @param path [description]
                 * @param xhrSettings [description]
                 */
                constructor(key: string, url: string, path: string, xhrSettings: XHRSettingsObject);

            }

            /**
             * [description]
             */
            class PluginFile extends Phaser.Loader.File {
                /**
                 * 
                 * @param key [description]
                 * @param url [description]
                 * @param path [description]
                 * @param xhrSettings [description]
                 */
                constructor(key: string, url: string, path: string, xhrSettings: XHRSettingsObject);

            }

            /**
             * [description]
             */
            class ScriptFile extends Phaser.Loader.File {
                /**
                 * 
                 * @param key [description]
                 * @param url [description]
                 * @param path [description]
                 * @param xhrSettings [description]
                 */
                constructor(key: string, url: string, path: string, xhrSettings: XHRSettingsObject);

            }

            /**
             * A Sprite Sheet File.
             * @param key The key of the file within the loader.
             * @param url The url to load the texture file from.
             * @param config Optional texture file specific XHR settings.
             * @param path Optional texture file specific XHR settings.
             * @param xhrSettings Optional atlas file specific XHR settings.
             */
            function SpriteSheetFile(key: string, url: string, config: object, path: string, xhrSettings: XHRSettingsObject): object;

            /**
             * [description]
             */
            class SVGFile extends Phaser.Loader.File {
                /**
                 * 
                 * @param key [description]
                 * @param url [description]
                 * @param path [description]
                 * @param xhrSettings [description]
                 */
                constructor(key: string, url: string, path: string, xhrSettings: XHRSettingsObject);

            }

            /**
             * [description]
             */
            class TextFile extends Phaser.Loader.File {
                /**
                 * 
                 * @param key [description]
                 * @param url [description]
                 * @param path [description]
                 * @param xhrSettings [description]
                 */
                constructor(key: string, url: string, path: string, xhrSettings: XHRSettingsObject);

            }

            /**
             * [description]
             */
            class TilemapCSVFile extends Phaser.Loader.File {
                /**
                 * 
                 * @param key [description]
                 * @param url [description]
                 * @param path [description]
                 * @param format [description]
                 * @param xhrSettings [description]
                 */
                constructor(key: string, url: string, path: string, format: string, xhrSettings: XHRSettingsObject);

            }

            /**
             * A Tilemap File.
             * @param key [description]
             * @param url [description]
             * @param path [description]
             * @param format [description]
             * @param xhrSettings [description]
             */
            function TilemapJSONFile(key: string, url: string, path: string, format: string, xhrSettings: XHRSettingsObject): object;

            /**
             * An Atlas JSON File.
             * @param key The key of the file within the loader.
             * @param textureURL The url to load the texture file from.
             * @param atlasURL The url to load the atlas file from.
             * @param path The path of the file.
             * @param textureXhrSettings Optional texture file specific XHR settings.
             * @param atlasXhrSettings Optional atlas file specific XHR settings.
             */
            function UnityAtlasFile(key: string, textureURL: string, atlasURL: string, path: string, textureXhrSettings: XHRSettingsObject, atlasXhrSettings: XHRSettingsObject): object;

            /**
             * [description]
             */
            class XMLFile extends Phaser.Loader.File {
                /**
                 * 
                 * @param key [description]
                 * @param url [description]
                 * @param path [description]
                 * @param xhrSettings [description]
                 */
                constructor(key: string, url: string, path: string, xhrSettings: XHRSettingsObject);

            }

        }

        /**
         * Given a File and a baseURL value this returns the URL the File will use to download from.
         * @param file The File object.
         * @param baseURL A default base URL.
         */
        function GetURL(file: Phaser.Loader.File, baseURL: string): string;

        /**
         * [description]
         */
        class LoaderPlugin extends Phaser.Events.EventEmitter {
            /**
             * 
             * @param scene [description]
             */
            constructor(scene: Phaser.Scene);

            /**
             * Adds an Animation JSON file to the current load queue.
             * 
             * Note: This method will only be available if the Animation JSON File type has been built into Phaser.
             * 
             * The file is **not** loaded immediately after calling this method.
             * Instead, the file is added to a queue within the Loader, which is processed automatically when the Loader starts.
             * @param key A unique string to be used as the key to reference this file from the Cache. Must be unique within this file type.
             * @param url URL of the file. If `undefined` or `null` the url will be set to `<key>.json`,
             * i.e. if `key` was "alien" then the URL will be "alien.json".
             * @param xhrSettings File specific XHR settings to be used during the load. These settings are merged with the global Loader XHR settings.
             */
            animation(key: string | any[] | object, url?: string, xhrSettings?: XHRSettingsObject): Phaser.Loader.LoaderPlugin;

            /**
             * Adds a Texture Atlas file to the current load queue.
             * 
             * Note: This method will only be available if the Atlas JSON File type has been built into Phaser.
             * 
             * The file is **not** loaded immediately after calling this method.
             * Instead, the file is added to a queue within the Loader, which is processed automatically when the Loader starts.
             * @param key The key of the file within the loader.
             * @param textureURL The url to load the texture file from.
             * @param atlasURL The url to load the atlas file from.
             * @param textureXhrSettings Optional texture file specific XHR settings.
             * @param atlasXhrSettings Optional atlas file specific XHR settings.
             */
            atlas(key: string, textureURL: string, atlasURL: string, textureXhrSettings: XHRSettingsObject, atlasXhrSettings: XHRSettingsObject): Phaser.Loader.LoaderPlugin;

            /**
             * Adds an Audio file to the current load queue.
             * 
             * Note: This method will only be available if the Audio File type has been built into Phaser.
             * 
             * The file is **not** loaded immediately after calling this method.
             * Instead, the file is added to a queue within the Loader, which is processed automatically when the Loader starts.
             * @param key [description]
             * @param urls [description]
             * @param config [description]
             * @param xhrSettings [description]
             */
            audio(key: string, urls: string | string[], config: object, xhrSettings: object): Phaser.Loader.LoaderPlugin;

            /**
             * Adds an Audio Sprite file to the current load queue.
             * 
             * Note: This method will only be available if the Audio Sprite File type has been built into Phaser.
             * 
             * The file is **not** loaded immediately after calling this method.
             * Instead, the file is added to a queue within the Loader, which is processed automatically when the Loader starts.
             * @param key [description]
             * @param urls [description]
             * @param json [description]
             * @param config [description]
             * @param audioXhrSettings Optional file specific XHR settings.
             * @param jsonXhrSettings Optional file specific XHR settings.
             */
            audioSprite(key: string, urls: string | string[], json: object, config: object, audioXhrSettings: XHRSettingsObject, jsonXhrSettings: XHRSettingsObject): Phaser.Loader.LoaderPlugin;

            /**
             * Adds Binary file to the current load queue.
             * 
             * Note: This method will only be available if the Binary File type has been built into Phaser.
             * 
             * The file is **not** loaded immediately after calling this method.
             * Instead, the file is added to a queue within the Loader, which is processed automatically when the Loader starts.
             * @param key [description]
             * @param url [description]
             * @param xhrSettings [description]
             */
            binary(key: string, url: string, xhrSettings: XHRSettingsObject): Phaser.Loader.LoaderPlugin;

            /**
             * Adds a Bitmap Font file to the current load queue.
             * 
             * Note: This method will only be available if the Bitmap Font File type has been built into Phaser.
             * 
             * The file is **not** loaded immediately after calling this method.
             * Instead, the file is added to a queue within the Loader, which is processed automatically when the Loader starts.
             * @param key [description]
             * @param textureURL [description]
             * @param xmlURL [description]
             * @param textureXhrSettings [description]
             * @param xmlXhrSettings [description]
             */
            bitmapFont(key: string, textureURL: string, xmlURL: string, textureXhrSettings: XHRSettingsObject, xmlXhrSettings: XHRSettingsObject): Phaser.Loader.LoaderPlugin;

            /**
             * Adds a GLSL file to the current load queue.
             * 
             * Note: This method will only be available if the GLSL File type has been built into Phaser.
             * 
             * The file is **not** loaded immediately after calling this method.
             * Instead, the file is added to a queue within the Loader, which is processed automatically when the Loader starts.
             * @param key [description]
             * @param url [description]
             * @param xhrSettings [description]
             */
            glsl(key: string, url: string, xhrSettings: XHRSettingsObject): Phaser.Loader.LoaderPlugin;

            /**
             * Adds an HTML file to the current load queue.
             * 
             * Note: This method will only be available if the HTML File type has been built into Phaser.
             * 
             * The file is **not** loaded immediately after calling this method.
             * Instead, the file is added to a queue within the Loader, which is processed automatically when the Loader starts.
             * @param key [description]
             * @param url [description]
             * @param width [description]
             * @param height [description]
             * @param xhrSettings [description]
             */
            html(key: string, url: string, width: number, height: number, xhrSettings: XHRSettingsObject): Phaser.Loader.LoaderPlugin;

            /**
             * Adds an Image file to the current load queue.
             * 
             * Note: This method will only be available if the Image File type has been built into Phaser.
             * 
             * The file is **not** loaded immediately after calling this method.
             * Instead, the file is added to a queue within the Loader, which is processed automatically when the Loader starts.
             * @param key [description]
             * @param url [description]
             * @param xhrSettings [description]
             */
            image(key: string, url: string, xhrSettings: XHRSettingsObject): Phaser.Loader.LoaderPlugin;

            /**
             * Adds a JSON file to the current load queue.
             * 
             * Note: This method will only be available if the JSON File type has been built into Phaser.
             * 
             * The file is **not** loaded immediately after calling this method.
             * Instead, the file is added to a queue within the Loader, which is processed automatically when the Loader starts.
             * @param key [description]
             * @param url [description]
             * @param xhrSettings [description]
             */
            json(key: string, url: string, xhrSettings: XHRSettingsObject): Phaser.Loader.LoaderPlugin;

            /**
             * Adds a Multi File Texture Atlas to the current load queue.
             * 
             * Note: This method will only be available if the Multi Atlas File type has been built into Phaser.
             * 
             * The file is **not** loaded immediately after calling this method.
             * Instead, the file is added to a queue within the Loader, which is processed automatically when the Loader starts.
             * @param key [description]
             * @param textureURLs [description]
             * @param atlasURLs [description]
             * @param textureXhrSettings [description]
             * @param atlasXhrSettings [description]
             */
            multiatlas(key: string, textureURLs: string[], atlasURLs: string[], textureXhrSettings: XHRSettingsObject, atlasXhrSettings: XHRSettingsObject): Phaser.Loader.LoaderPlugin;

            /**
             * Adds a Plugin file to the current load queue.
             * 
             * Note: This method will only be available if the Plugin File type has been built into Phaser.
             * 
             * The file is **not** loaded immediately after calling this method.
             * Instead, the file is added to a queue within the Loader, which is processed automatically when the Loader starts.
             * @param key [description]
             * @param url [description]
             * @param xhrSettings [description]
             */
            plugin(key: string, url: string, xhrSettings: XHRSettingsObject): Phaser.Loader.LoaderPlugin;

            /**
             * Adds a JavaScript file to the current load queue.
             * 
             * Note: This method will only be available if the Script File type has been built into Phaser.
             * 
             * The file is **not** loaded immediately after calling this method.
             * Instead, the file is added to a queue within the Loader, which is processed automatically when the Loader starts.
             * @param key [description]
             * @param url [description]
             * @param xhrSettings [description]
             */
            script(key: string, url: string, xhrSettings: XHRSettingsObject): Phaser.Loader.LoaderPlugin;

            /**
             * Adds a Sprite Sheet file to the current load queue.
             * 
             * Note: This method will only be available if the Sprite Sheet File type has been built into Phaser.
             * 
             * The file is **not** loaded immediately after calling this method.
             * Instead, the file is added to a queue within the Loader, which is processed automatically when the Loader starts.
             * @param key [description]
             * @param url [description]
             * @param config config can include: frameWidth, frameHeight, startFrame, endFrame, margin, spacing.
             * @param xhrSettings [description]
             */
            spritesheet(key: string, url: string, config: object, xhrSettings: XHRSettingsObject): Phaser.Loader.LoaderPlugin;

            /**
             * Adds an SVG file to the current load queue.
             * 
             * Note: This method will only be available if the SVG File type has been built into Phaser.
             * 
             * The file is **not** loaded immediately after calling this method.
             * Instead, the file is added to a queue within the Loader, which is processed automatically when the Loader starts.
             * @param key [description]
             * @param url [description]
             * @param xhrSettings [description]
             */
            svg(key: string, url: string, xhrSettings: XHRSettingsObject): Phaser.Loader.LoaderPlugin;

            /**
             * Adds a Text file to the current load queue.
             * 
             * Note: This method will only be available if the Text File type has been built into Phaser.
             * 
             * The file is **not** loaded immediately after calling this method.
             * Instead, the file is added to a queue within the Loader, which is processed automatically when the Loader starts.
             * @param key [description]
             * @param url [description]
             * @param xhrSettings [description]
             */
            text(key: string, url: string, xhrSettings: XHRSettingsObject): Phaser.Loader.LoaderPlugin;

            /**
             * Adds a Tilemap CSV file to the current load queue.
             * 
             * Note: This method will only be available if the Tilemap CSV File type has been built into Phaser.
             * 
             * The file is **not** loaded immediately after calling this method.
             * Instead, the file is added to a queue within the Loader, which is processed automatically when the Loader starts.
             * @param key [description]
             * @param url [description]
             * @param xhrSettings [description]
             */
            tilemapCSV(key: string, url: string, xhrSettings: XHRSettingsObject): Phaser.Loader.LoaderPlugin;

            /**
             * Adds a Tilemap (Tiled JSON Format) file to the current load queue.
             * 
             * Note: This method will only be available if the Tilemap File type has been built into Phaser.
             * 
             * The file is **not** loaded immediately after calling this method.
             * Instead, the file is added to a queue within the Loader, which is processed automatically when the Loader starts.
             * @param key [description]
             * @param url [description]
             * @param xhrSettings [description]
             */
            tilemapTiledJSON(key: string, url: string, xhrSettings: XHRSettingsObject): Phaser.Loader.LoaderPlugin;

            /**
             * Adds a Tilemap (Weltmeister Format) file to the current load queue.
             * 
             * Note: This method will only be available if the Tilemap File type has been built into Phaser.
             * 
             * The file is **not** loaded immediately after calling this method.
             * Instead, the file is added to a queue within the Loader, which is processed automatically when the Loader starts.
             * @param key [description]
             * @param url [description]
             * @param xhrSettings [description]
             */
            tilemapWeltmeister(key: string, url: string, xhrSettings: XHRSettingsObject): Phaser.Loader.LoaderPlugin;

            /**
             * Adds a Unity Texture Atlas file to the current load queue.
             * 
             * Note: This method will only be available if the Unity Atlas File type has been built into Phaser.
             * 
             * The file is **not** loaded immediately after calling this method.
             * Instead, the file is added to a queue within the Loader, which is processed automatically when the Loader starts.
             * @param key The key of the file within the loader.
             * @param textureURL The url to load the texture file from.
             * @param atlasURL The url to load the atlas file from.
             * @param textureXhrSettings Optional texture file specific XHR settings.
             * @param atlasXhrSettings Optional atlas file specific XHR settings.
             */
            unityAtlas(key: string, textureURL: string, atlasURL: string, textureXhrSettings: XHRSettingsObject, atlasXhrSettings: XHRSettingsObject): Phaser.Loader.LoaderPlugin;

            /**
             * Adds an XML file to the current load queue.
             * 
             * Note: This method will only be available if the XML File type has been built into Phaser.
             * 
             * The file is **not** loaded immediately after calling this method.
             * Instead, the file is added to a queue within the Loader, which is processed automatically when the Loader starts.
             * @param key [description]
             * @param url [description]
             * @param xhrSettings [description]
             */
            xml(key: string, url: string, xhrSettings: XHRSettingsObject): Phaser.Loader.LoaderPlugin;

            /**
             * [description]
             */
            scene: Phaser.Scene;

            /**
             * [description]
             */
            systems: Phaser.Scenes.Systems;

            /**
             * [description]
             */
            path: string;

            /**
             * [description]
             */
            baseURL: string;

            /**
             * [description]
             */
            enableParallel: boolean;

            /**
             * [description]
             */
            maxParallelDownloads: integer;

            /**
             * xhr specific global settings (can be overridden on a per-file basis)
             */
            xhr: XHRSettingsObject;

            /**
             * [description]
             */
            crossOrigin: string;

            /**
             * [description]
             */
            totalToLoad: number;

            /**
             * [description]
             */
            progress: number;

            /**
             * [description]
             */
            list: Phaser.Structs.Set<Phaser.Loader.File>;

            /**
             * [description]
             */
            inflight: Phaser.Structs.Set<Phaser.Loader.File>;

            /**
             * [description]
             */
            failed: Phaser.Structs.Set<Phaser.Loader.File>;

            /**
             * [description]
             */
            queue: Phaser.Structs.Set<Phaser.Loader.File>;

            /**
             * [description]
             */
            storage: Phaser.Structs.Set<(Phaser.Loader.File|LinkFileObject)>;

            /**
             * [description]
             */
            state: integer;

            /**
             * [description]
             */
            boot(): void;

            /**
             * [description]
             * @param url [description]
             */
            setBaseURL(url: string): Phaser.Loader.LoaderPlugin;

            /**
             * [description]
             * @param path [description]
             */
            setPath(path: string): Phaser.Loader.LoaderPlugin;

            /**
             * [description]
             * @param crossOrigin [description]
             */
            setCORS(crossOrigin: string): Phaser.Loader.LoaderPlugin;

            /**
             * [description]
             * @param file [description]
             */
            addFile(file: Phaser.Loader.File): Phaser.Loader.File;

            /**
             * Is the Loader actively loading (or processing loaded files)
             */
            isLoading(): boolean;

            /**
             * Is the Loader ready to start a new load?
             */
            isReady(): boolean;

            /**
             * [description]
             */
            start(): void;

            /**
             * [description]
             */
            updateProgress(): void;

            /**
             * [description]
             */
            processLoadQueue(): void;

            /**
             * [description]
             * @param file [description]
             */
            loadFile(file: Phaser.Loader.File): void;

            /**
             * [description]
             * @param previousFile [description]
             * @param success [description]
             */
            nextFile(previousFile: Phaser.Loader.File, success: boolean): void;

            /**
             * [description]
             */
            finishedLoading(): void;

            /**
             * Called automatically by the File when it has finished processing.
             * @param file [description]
             */
            processUpdate(file: Phaser.Loader.File): void;

            /**
             * [description]
             * @param file [description]
             */
            removeFromQueue(file: Phaser.Loader.File): void;

            /**
             * [description]
             */
            processComplete(): void;

            /**
             * The Loader has finished.
             */
            processCallback(): void;

            /**
             * [description]
             * @param data [description]
             * @param filename [description] Default file.json.
             */
            saveJSON(data: any, filename?: string): Phaser.Loader.LoaderPlugin;

            /**
             * [description]
             * @param data [description]
             * @param filename [description] Default file.json.
             * @param filetype [description] Default application/json.
             */
            save(data: any, filename?: string, filetype?: string): Phaser.Loader.LoaderPlugin;

            /**
             * [description]
             */
            reset(): void;

            /**
             * [description]
             * @param files [description]
             */
            loadArray(files: LoaderFileObject[]): boolean;

            /**
             * [description]
             * @param file [description]
             */
            file(file: LoaderFileObject): Phaser.Loader.File;

            /**
             * [description]
             */
            shutdown(): void;

            /**
             * [description]
             */
            destroy(): void;

        }

        /**
         * Takes two XHRSettings Objects and creates a new XHRSettings object from them.
         * 
         * The new object is seeded by the values given in the global settings, but any setting in
         * the local object overrides the global ones.
         * @param global The global XHRSettings object.
         * @param local The local XHRSettings object.
         */
        function MergeXHRSettings(global: XHRSettingsObject, local: XHRSettingsObject): XHRSettingsObject;

        /**
         * Creates a new XMLHttpRequest (xhr) object based on the given File and XHRSettings
         * and starts the download of it. It uses the Files own XHRSettings and merges them
         * with the global XHRSettings object to set the xhr values before download.
         * @param file The File to download.
         * @param globalXHRSettings The global XHRSettings object.
         */
        function XHRLoader(file: Phaser.Loader.File, globalXHRSettings: XHRSettingsObject): XMLHttpRequest;

        /**
         * Creates an XHRSettings Object with default values.
         * @param responseType The responseType, such as 'text'. Default ''.
         * @param async Should the XHR request use async or not? Default true.
         * @param user Optional username for the XHR request. Default ''.
         * @param password Optional password for the XHR request. Default ''.
         * @param timeout Optional XHR timeout value. Default 0.
         */
        function XHRSettings(responseType?: XMLHttpRequestResponseType, async?: boolean, user?: string, password?: string, timeout?: integer): XHRSettingsObject;

    }

    namespace Math {
        namespace Angle {
            /**
             * [description]
             * @param x1 [description]
             * @param y1 [description]
             * @param x2 [description]
             * @param y2 [description]
             */
            function Between(x1: number, y1: number, x2: number, y2: number): number;

            /**
             * [description]
             * @param point1 [description]
             * @param point2 [description]
             */
            function BetweenPoints(point1: Phaser.Geom.Point | object, point2: Phaser.Geom.Point | object): number;

            /**
             * [description]
             * @param point1 [description]
             * @param point2 [description]
             */
            function BetweenPointsY(point1: Phaser.Geom.Point | object, point2: Phaser.Geom.Point | object): number;

            /**
             * [description]
             * @param x1 [description]
             * @param y1 [description]
             * @param x2 [description]
             * @param y2 [description]
             */
            function BetweenY(x1: number, y1: number, x2: number, y2: number): number;

            /**
             * [description]
             * @param angle [description]
             */
            function Normalize(angle: number): number;

            /**
             * [description]
             * @param angle [description]
             */
            function Reverse(angle: number): number;

            /**
             * Rotates `currentAngle` towards `targetAngle`, taking the shortest rotation distance. The `lerp` argument is the amount to rotate by in this call.
             * @param currentAngle The current angle, in radians.
             * @param targetAngle The target angle to rotate to, in radians.
             * @param lerp The lerp value to add to the current angle. Default 0.05.
             */
            function RotateTo(currentAngle: number, targetAngle: number, lerp?: number): number;

            /**
             * Gets the shortest angle between `angle1` and `angle2`.
             * Both angles must be in the range -180 to 180, which is the same clamped
             * range that `sprite.angle` uses, so you can pass in two sprite angles to
             * this method and get the shortest angle back between the two of them.
             * 
             * The angle returned will be in the same range. If the returned angle is
             * greater than 0 then it's a counter-clockwise rotation, if < 0 then it's
             * a clockwise rotation.
             * @param angle1 The first angle in the range -180 to 180.
             * @param angle2 The second angle in the range -180 to 180.
             */
            function ShortestBetween(angle1: number, angle2: number): number;

            /**
             * [description]
             * @param angle [description]
             */
            function Wrap(angle: number): number;

            /**
             * [description]
             * @param angle [description]
             */
            function WrapDegrees(angle: number): number;

        }

        /**
         * [description]
         * @param values [description]
         */
        function Average(values: number[]): number;

        /**
         * [description]
         * @param n [description]
         * @param i [description]
         */
        function Bernstein(n: number, i: number): number;

        /**
         * [description]
         * @param min [description]
         * @param max [description]
         */
        function Between(min: integer, max: integer): integer;

        /**
         * [description]
         * @param t [description]
         * @param p0 [description]
         * @param p1 [description]
         * @param p2 [description]
         * @param p3 [description]
         */
        function CatmullRom(t: number, p0: number, p1: number, p2: number, p3: number): number;

        /**
         * [description]
         * @param value [description]
         * @param place [description] Default 0.
         * @param base [description] Default 10.
         */
        function CeilTo(value: number, place?: number, base?: integer): number;

        /**
         * Force a value within the boundaries by clamping it to the range `min`, `max`.
         * @param value The value to be clamped.
         * @param min The minimum bounds.
         * @param max The maximum bounds.
         */
        function Clamp(value: number, min: number, max: number): number;

        /**
         * [description]
         * @param degrees [description]
         */
        function DegToRad(degrees: integer): number;

        /**
         * [description]
         * @param a [description]
         * @param b [description]
         */
        function Difference(a: number, b: number): number;

        namespace Distance {
            /**
             * [description]
             * @param x1 [description]
             * @param y1 [description]
             * @param x2 [description]
             * @param y2 [description]
             */
            function Between(x1: number, y1: number, x2: number, y2: number): number;

            /**
             * [description]
             * @param x1 [description]
             * @param y1 [description]
             * @param x2 [description]
             * @param y2 [description]
             * @param pow [description]
             */
            function Power(x1: number, y1: number, x2: number, y2: number, pow: number): number;

            /**
             * [description]
             * @param x1 [description]
             * @param y1 [description]
             * @param x2 [description]
             * @param y2 [description]
             */
            function Squared(x1: number, y1: number, x2: number, y2: number): number;

        }

        namespace Easing {
            namespace Back {
                /**
                 * [description]
                 * @param v [description]
                 * @param overshoot [description] Default 1.70158.
                 */
                function In(v: number, overshoot?: number): number;

                /**
                 * [description]
                 * @param v [description]
                 * @param overshoot [description] Default 1.70158.
                 */
                function InOut(v: number, overshoot?: number): number;

                /**
                 * [description]
                 * @param v [description]
                 * @param overshoot [description] Default 1.70158.
                 */
                function Out(v: number, overshoot?: number): number;

            }

            namespace Bounce {
                /**
                 * [description]
                 * @param v [description]
                 */
                function In(v: number): number;

                /**
                 * [description]
                 * @param v [description]
                 */
                function InOut(v: number): number;

                /**
                 * [description]
                 * @param v [description]
                 */
                function Out(v: number): number;

            }

            namespace Circular {
                /**
                 * [description]
                 * @param v [description]
                 */
                function In(v: number): number;

                /**
                 * [description]
                 * @param v [description]
                 */
                function InOut(v: number): number;

                /**
                 * [description]
                 * @param v [description]
                 */
                function Out(v: number): number;

            }

            namespace Cubic {
                /**
                 * [description]
                 * @param v [description]
                 */
                function In(v: number): number;

                /**
                 * [description]
                 * @param v [description]
                 */
                function InOut(v: number): number;

                /**
                 * [description]
                 * @param v [description]
                 */
                function Out(v: number): number;

            }

            namespace Elastic {
                /**
                 * [description]
                 * @param v [description]
                 * @param amplitude [description] Default 0.1.
                 * @param period [description] Default 0.1.
                 */
                function In(v: number, amplitude?: number, period?: number): number;

                /**
                 * [description]
                 * @param v [description]
                 * @param amplitude [description] Default 0.1.
                 * @param period [description] Default 0.1.
                 */
                function InOut(v: number, amplitude?: number, period?: number): number;

                /**
                 * [description]
                 * @param v [description]
                 * @param amplitude [description] Default 0.1.
                 * @param period [description] Default 0.1.
                 */
                function Out(v: number, amplitude?: number, period?: number): number;

            }

            namespace Expo {
                /**
                 * [description]
                 * @param v [description]
                 */
                function In(v: number): number;

                /**
                 * [description]
                 * @param v [description]
                 */
                function InOut(v: number): number;

                /**
                 * [description]
                 * @param v [description]
                 */
                function Out(v: number): number;

            }

            /**
             * [description]
             * @param v [description]
             */
            function Linear(v: number): number;

            namespace Quadratic {
                /**
                 * [description]
                 * @param v [description]
                 */
                function In(v: number): number;

                /**
                 * [description]
                 * @param v [description]
                 */
                function InOut(v: number): number;

                /**
                 * [description]
                 * @param v [description]
                 */
                function Out(v: number): number;

            }

            namespace Quartic {
                /**
                 * [description]
                 * @param v [description]
                 */
                function In(v: number): number;

                /**
                 * [description]
                 * @param v [description]
                 */
                function InOut(v: number): number;

                /**
                 * [description]
                 * @param v [description]
                 */
                function Out(v: number): number;

            }

            namespace Quintic {
                /**
                 * [description]
                 * @param v [description]
                 */
                function In(v: number): number;

                /**
                 * [description]
                 * @param v [description]
                 */
                function InOut(v: number): number;

                /**
                 * [description]
                 * @param v [description]
                 */
                function Out(v: number): number;

            }

            namespace Sine {
                /**
                 * [description]
                 * @param v [description]
                 */
                function In(v: number): number;

                /**
                 * [description]
                 * @param v [description]
                 */
                function InOut(v: number): number;

                /**
                 * [description]
                 * @param v [description]
                 */
                function Out(v: number): number;

            }

            /**
             * [description]
             * @param v [description]
             * @param steps [description] Default 1.
             */
            function Stepped(v: number, steps?: number): number;

        }

        /**
         * [description]
         * @param value [description]
         */
        function Factorial(value: number): number;

        /**
         * [description]
         * @param min [description]
         * @param max [description]
         */
        function FloatBetween(min: number, max: number): number;

        /**
         * [description]
         * @param value [description]
         * @param place  Default 0 - [description.
         * @param base [description] Default 10.
         */
        function FloorTo(value: number, place?: integer, base?: integer): number;

        /**
         * Return a value based on the range between `min` and `max` and the percentage given.
         * @param percent A value between 0 and 1 representing the percentage.
         * @param min [description]
         * @param max [description]
         */
        function FromPercent(percent: number, min: number, max?: number): number;

        namespace Fuzzy {
            /**
             * [description]
             * @param value [description]
             * @param epsilon [description] Default 0.0001.
             */
            function Ceil(value: number, epsilon?: number): number;

            /**
             * [description]
             * @param a [description]
             * @param b [description]
             * @param epsilon [description] Default 0.0001.
             */
            function Equal(a: number, b: number, epsilon?: number): boolean;

            /**
             * [description]
             * @param value [description]
             * @param epsilon [description] Default 0.0001.
             */
            function Floor(value: number, epsilon?: number): number;

            /**
             * [description]
             * @param a [description]
             * @param b [description]
             * @param epsilon [description] Default 0.0001.
             */
            function GreaterThan(a: number, b: number, epsilon?: number): boolean;

            /**
             * [description]
             * @param a [description]
             * @param b [description]
             * @param epsilon [description] Default 0.0001.
             */
            function LessThan(a: number, b: number, epsilon?: number): boolean;

        }

        /**
         * [description]
         * @param distance The distance to travel in pixels.
         * @param time The time, in ms, to cover the distance in.
         */
        function GetSpeed(distance: number, time: integer): number;

        namespace Interpolation {
            /**
             * [description]
             * @param v [description]
             * @param k [description]
             */
            function Bezier(v: number, k: number): number;

            /**
             * [description]
             * @param v [description]
             * @param k [description]
             */
            function CatmullRom(v: number, k: number): number;

            /**
             * [description]
             * @param t [description]
             * @param p0 [description]
             * @param p1 [description]
             * @param p2 [description]
             * @param p3 [description]
             */
            function CubicBezier(t: number, p0: number, p1: number, p2: number, p3: number): number;

            /**
             * A Linear Interpolation Method.
             * @param v The input array of values to interpolate between.
             * @param k The percentage of interploation, between 0 and 1.
             */
            function Linear(v: number[], k: number): number;

            /**
             * [description]
             * @param t [description]
             * @param p0 [description]
             * @param p1 [description]
             * @param p2 [description]
             */
            function QuadraticBezier(t: number, p0: number, p1: number, p2: number): number;

        }

        /**
         * [description]
         * @param value [description]
         */
        function IsEven(value: number): boolean;

        /**
         * [description]
         * @param value [description]
         */
        function IsEvenStrict(value: number): boolean;

        /**
         * Calculates a linear (interpolation) value over t.
         * @param p0 The first point
         * @param p1 The second point
         * @param t The percentage between p0 and p1 to return represented as a number between 0 and 1.
         */
        function Linear(p0: number, p1: number, t: number): number;

        /**
         * [description]
         */
        class Matrix3 {
            /**
             * 
             * @param m [description]
             */
            constructor(m?: Phaser.Math.Matrix3);

            /**
             * [description]
             */
            val: Float32Array;

            /**
             * [description]
             */
            clone(): Phaser.Math.Matrix3;

            /**
             * [description]
             * @param src [description]
             */
            set(src: Phaser.Math.Matrix3): Phaser.Math.Matrix3;

            /**
             * [description]
             * @param src [description]
             */
            copy(src: Phaser.Math.Matrix3): Phaser.Math.Matrix3;

            /**
             * [description]
             * @param m [description]
             */
            fromMat4(m: Phaser.Math.Matrix4): Phaser.Math.Matrix3;

            /**
             * [description]
             * @param a [description]
             */
            fromArray(a: any[]): Phaser.Math.Matrix3;

            /**
             * [description]
             */
            identity(): Phaser.Math.Matrix3;

            /**
             * [description]
             */
            transpose(): Phaser.Math.Matrix3;

            /**
             * [description]
             */
            invert(): Phaser.Math.Matrix3;

            /**
             * [description]
             */
            adjoint(): Phaser.Math.Matrix3;

            /**
             * [description]
             */
            determinant(): number;

            /**
             * [description]
             * @param src [description]
             */
            multiply(src: Phaser.Math.Matrix3): Phaser.Math.Matrix3;

            /**
             * [description]
             * @param v [description]
             */
            translate(v: Phaser.Math.Vector2 | Phaser.Math.Vector3 | Phaser.Math.Vector4): Phaser.Math.Matrix3;

            /**
             * [description]
             * @param rad [description]
             */
            rotate(rad: number): Phaser.Math.Matrix3;

            /**
             * [description]
             * @param v [description]
             */
            scale(v: Phaser.Math.Vector2 | Phaser.Math.Vector3 | Phaser.Math.Vector4): Phaser.Math.Matrix3;

            /**
             * [description]
             * @param q [description]
             */
            fromQuat(q: Phaser.Math.Quaternion): Phaser.Math.Matrix3;

            /**
             * [description]
             * @param m [description]
             */
            normalFromMat4(m: Phaser.Math.Matrix4): Phaser.Math.Matrix3;

        }

        /**
         * [description]
         */
        class Matrix4 {
            /**
             * 
             * @param m [description]
             */
            constructor(m?: Phaser.Math.Matrix4);

            /**
             * [description]
             */
            val: Float32Array;

            /**
             * [description]
             */
            clone(): Phaser.Math.Matrix4;

            /**
             * [description]
             * @param src [description]
             */
            set(src: Phaser.Math.Matrix4): Phaser.Math.Matrix4;

            /**
             * [description]
             * @param src [description]
             */
            copy(src: Phaser.Math.Matrix4): Phaser.Math.Matrix4;

            /**
             * [description]
             * @param a [description]
             */
            fromArray(a: any[]): Phaser.Math.Matrix4;

            /**
             * [description]
             */
            zero(): Phaser.Math.Matrix4;

            /**
             * [description]
             * @param x [description]
             * @param y [description]
             * @param z [description]
             */
            xyz(x: number, y: number, z: number): Phaser.Math.Matrix4;

            /**
             * [description]
             * @param x [description]
             * @param y [description]
             * @param z [description]
             */
            scaling(x: number, y: number, z: number): Phaser.Math.Matrix4;

            /**
             * [description]
             */
            identity(): Phaser.Math.Matrix4;

            /**
             * [description]
             */
            transpose(): Phaser.Math.Matrix4;

            /**
             * [description]
             */
            invert(): Phaser.Math.Matrix4;

            /**
             * [description]
             */
            adjoint(): Phaser.Math.Matrix4;

            /**
             * [description]
             */
            determinant(): number;

            /**
             * [description]
             * @param src [description]
             */
            multiply(src: Phaser.Math.Matrix4): Phaser.Math.Matrix4;

            /**
             * [description]
             * @param src [description]
             */
            multiplyLocal(src: Phaser.Math.Matrix4): Phaser.Math.Matrix4;

            /**
             * [description]
             * @param v [description]
             */
            translate(v: Phaser.Math.Vector3 | Phaser.Math.Vector4): Phaser.Math.Matrix4;

            /**
             * [description]
             * @param v [description]
             */
            scale(v: Phaser.Math.Vector3 | Phaser.Math.Vector4): Phaser.Math.Matrix4;

            /**
             * [description]
             * @param axis [description]
             * @param angle The angle of rotation in radians.
             */
            makeRotationAxis(axis: Phaser.Math.Vector3 | Phaser.Math.Vector4, angle: number): Phaser.Math.Matrix4;

            /**
             * [description]
             * @param rad [description]
             * @param axis [description]
             */
            rotate(rad: number, axis: Phaser.Math.Vector3): Phaser.Math.Matrix4;

            /**
             * [description]
             * @param rad [description]
             */
            rotateX(rad: number): Phaser.Math.Matrix4;

            /**
             * [description]
             * @param rad [description]
             */
            rotateY(rad: number): Phaser.Math.Matrix4;

            /**
             * [description]
             * @param rad [description]
             */
            rotateZ(rad: number): Phaser.Math.Matrix4;

            /**
             * [description]
             * @param q [description]
             * @param v [description]
             */
            fromRotationTranslation(q: Phaser.Math.Quaternion, v: Phaser.Math.Vector3): Phaser.Math.Matrix4;

            /**
             * [description]
             * @param q [description]
             */
            fromQuat(q: Phaser.Math.Quaternion): Phaser.Math.Matrix4;

            /**
             * Generates a frustum matrix with the given bounds.
             * @param left The left bound of the frustum.
             * @param right The right bound of the frustum.
             * @param bottom The bottom bound of the frustum.
             * @param top The top bound of the frustum.
             * @param near The near bound of the frustum.
             * @param far The far bound of the frustum.
             */
            frustum(left: number, right: number, bottom: number, top: number, near: number, far: number): Phaser.Math.Matrix4;

            /**
             * Generates a perspective projection matrix with the given bounds.
             * perspective fov lh
             * @param fovy Vertical field of view in radians
             * @param aspect Aspect ratio. Typically viewport width  /height.
             * @param near Near bound of the frustum.
             * @param far Far bound of the frustum.
             */
            perspective(fovy: number, aspect: number, near: number, far: number): Phaser.Math.Matrix4;

            /**
             * [description]
             * @param width [description]
             * @param height [description]
             * @param near Near bound of the frustum.
             * @param far Far bound of the frustum.
             */
            perspectiveLH(width: number, height: number, near: number, far: number): Phaser.Math.Matrix4;

            /**
             * Generates a orthogonal projection matrix with the given bounds.
             * @param left The left bound of the frustum.
             * @param right The right bound of the frustum.
             * @param bottom The bottom bound of the frustum.
             * @param top The top bound of the frustum.
             * @param near The near bound of the frustum.
             * @param far The far bound of the frustum.
             */
            ortho(left: number, right: number, bottom: number, top: number, near: number, far: number): Phaser.Math.Matrix4;

            /**
             * Generates a look-at matrix with the given eye position, focal point, and up axis.
             * @param eye Position of the viewer
             * @param center Point the viewer is looking at
             * @param up vec3 pointing up.
             */
            lookAt(eye: Phaser.Math.Vector3, center: Phaser.Math.Vector3, up: Phaser.Math.Vector3): Phaser.Math.Matrix4;

            /**
             * [description]
             * @param yaw [description]
             * @param pitch [description]
             * @param roll [description]
             */
            yawPitchRoll(yaw: number, pitch: number, roll: number): Phaser.Math.Matrix4;

            /**
             * [description]
             * @param rotation [description]
             * @param position [description]
             * @param scale [description]
             * @param viewMatrix [description]
             * @param projectionMatrix [description]
             */
            setWorldMatrix(rotation: Phaser.Math.Vector3, position: Phaser.Math.Vector3, scale: Phaser.Math.Vector3, viewMatrix?: Phaser.Math.Matrix4, projectionMatrix?: Phaser.Math.Matrix4): Phaser.Math.Matrix4;

        }

        /**
         * [description]
         * @param value [description]
         * @param amount [description]
         * @param max [description]
         */
        function MaxAdd(value: number, amount: number, max: number): number;

        /**
         * [description]
         * @param value [description]
         * @param amount [description]
         * @param min [description]
         */
        function MinSub(value: number, amount: number, min: number): number;

        /**
         * Work out what percentage `value` is of the range between `min` and `max`.
         * If `max` isn't given then it will return the percentage of `value` to `min`.
         * 
         * You can optionally specify an `upperMax` value, which is a mid-way point in the range that represents 100%, after which the % starts to go down to zero again.
         * @param value [description]
         * @param min [description]
         * @param max [description]
         * @param upperMax [description]
         */
        function Percent(value: number, min: number, max?: number, upperMax?: number): number;

        namespace Pow2 {
            /**
             * Returns the nearest power of 2 to the given `value`.
             * @param value [description]
             */
            function GetPowerOfTwo(value: number): integer;

            /**
             * Checks if the given `width` and `height` are a power of two.
             * Useful for checking texture dimensions.
             * @param width The width.
             * @param height The height.
             */
            function IsSizePowerOfTwo(width: number, height: number): boolean;

            /**
             * Tests the value and returns `true` if it is a power of two.
             * @param value The value to check if it's a power of two.
             */
            function IsValuePowerOfTwo(value: number): boolean;

        }

        /**
         * [description]
         */
        class Quaternion {
            /**
             * 
             * @param x [description]
             * @param y [description]
             * @param z [description]
             * @param w [description]
             */
            constructor(x?: number, y?: number, z?: number, w?: number);

            /**
             * The x component of this Quaternion.
             */
            x: number;

            /**
             * The y component of this Quaternion.
             */
            y: number;

            /**
             * The z component of this Quaternion.
             */
            z: number;

            /**
             * The w component of this Quaternion.
             */
            w: number;

            /**
             * [description]
             * @param src [description]
             */
            copy(src: Phaser.Math.Quaternion | Phaser.Math.Vector4): Phaser.Math.Quaternion;

            /**
             * [description]
             * @param x [description] Default 0.
             * @param y [description] Default 0.
             * @param z [description] Default 0.
             * @param w [description] Default 0.
             */
            set(x?: number | object, y?: number, z?: number, w?: number): Phaser.Math.Quaternion;

            /**
             * [description]
             * @param v [description]
             */
            add(v: Phaser.Math.Quaternion | Phaser.Math.Vector4): Phaser.Math.Quaternion;

            /**
             * [description]
             * @param v [description]
             */
            subtract(v: Phaser.Math.Quaternion | Phaser.Math.Vector4): Phaser.Math.Quaternion;

            /**
             * [description]
             * @param scale [description]
             */
            scale(scale: number): Phaser.Math.Quaternion;

            /**
             * [description]
             */
            length(): number;

            /**
             * [description]
             */
            lengthSq(): number;

            /**
             * [description]
             */
            normalize(): Phaser.Math.Quaternion;

            /**
             * [description]
             * @param v [description]
             */
            dot(v: Phaser.Math.Quaternion | Phaser.Math.Vector4): number;

            /**
             * [description]
             * @param v [description]
             * @param t [description] Default 0.
             */
            lerp(v: Phaser.Math.Quaternion | Phaser.Math.Vector4, t?: number): Phaser.Math.Quaternion;

            /**
             * [description]
             * @param a [description]
             * @param b [description]
             */
            rotationTo(a: Phaser.Math.Vector3, b: Phaser.Math.Vector3): Phaser.Math.Quaternion;

            /**
             * [description]
             * @param view [description]
             * @param right [description]
             * @param up [description]
             */
            setAxes(view: Phaser.Math.Vector3, right: Phaser.Math.Vector3, up: Phaser.Math.Vector3): Phaser.Math.Quaternion;

            /**
             * [description]
             */
            identity(): Phaser.Math.Quaternion;

            /**
             * [description]
             * @param axis [description]
             * @param rad [description]
             */
            setAxisAngle(axis: Phaser.Math.Vector3, rad: number): Phaser.Math.Quaternion;

            /**
             * [description]
             * @param b [description]
             */
            multiply(b: Phaser.Math.Quaternion | Phaser.Math.Vector4): Phaser.Math.Quaternion;

            /**
             * [description]
             * @param b [description]
             * @param t [description]
             */
            slerp(b: Phaser.Math.Quaternion | Phaser.Math.Vector4, t: number): Phaser.Math.Quaternion;

            /**
             * [description]
             */
            invert(): Phaser.Math.Quaternion;

            /**
             * [description]
             */
            conjugate(): Phaser.Math.Quaternion;

            /**
             * [description]
             * @param rad [description]
             */
            rotateX(rad: number): Phaser.Math.Quaternion;

            /**
             * [description]
             * @param rad [description]
             */
            rotateY(rad: number): Phaser.Math.Quaternion;

            /**
             * [description]
             * @param rad [description]
             */
            rotateZ(rad: number): Phaser.Math.Quaternion;

            /**
             * [description]
             */
            calculateW(): Phaser.Math.Quaternion;

            /**
             * [description]
             * @param mat [description]
             */
            fromMat3(mat: Phaser.Math.Matrix3): Phaser.Math.Quaternion;

        }

        /**
         * [description]
         * @param radians [description]
         */
        function RadToDeg(radians: number): integer;

        /**
         * [description]
         */
        class RandomDataGenerator {
            /**
             * 
             * @param seeds [description]
             */
            constructor(seeds?: string[]);

            /**
             * [description]
             */
            sign: number[];

            /**
             * [description]
             * @param seeds [description]
             */
            init(seeds: string | string[]): void;

            /**
             * Reset the seed of the random data generator.
             * 
             * _Note_: the seed array is only processed up to the first `undefined` (or `null`) value, should such be present.
             * @param seeds The array of seeds: the `toString()` of each value is used.
             */
            sow(seeds: string[]): void;

            /**
             * Returns a random integer between 0 and 2^32.
             */
            integer(): number;

            /**
             * Returns a random real number between 0 and 1.
             */
            frac(): number;

            /**
             * Returns a random real number between 0 and 2^32.
             */
            real(): number;

            /**
             * Returns a random integer between and including min and max.
             * @param min The minimum value in the range.
             * @param max The maximum value in the range.
             */
            integerInRange(min: number, max: number): number;

            /**
             * Returns a random integer between and including min and max.
             * This method is an alias for RandomDataGenerator.integerInRange.
             * @param min The minimum value in the range.
             * @param max The maximum value in the range.
             */
            between(min: number, max: number): number;

            /**
             * Returns a random real number between min and max.
             * @param min The minimum value in the range.
             * @param max The maximum value in the range.
             */
            realInRange(min: number, max: number): number;

            /**
             * Returns a random real number between -1 and 1.
             */
            normal(): number;

            /**
             * Returns a valid RFC4122 version4 ID hex string from https://gist.github.com/1308368
             */
            uuid(): string;

            /**
             * Returns a random element from within the given array.
             * @param array The array to pick a random element from.
             */
            pick(array: any[]): any;

            /**
             * Returns a random element from within the given array, favoring the earlier entries.
             * @param array The array to pick a random element from.
             */
            weightedPick(array: any[]): any;

            /**
             * Returns a random timestamp between min and max, or between the beginning of 2000 and the end of 2020 if min and max aren't specified.
             * @param min The minimum value in the range.
             * @param max The maximum value in the range.
             */
            timestamp(min: number, max: number): number;

            /**
             * Returns a random angle between -180 and 180.
             */
            angle(): number;

            /**
             * Returns a random rotation in radians, between -3.141 and 3.141
             */
            rotation(): number;

            /**
             * Gets or Sets the state of the generator. This allows you to retain the values
             * that the generator is using between games, i.e. in a game save file.
             * 
             * To seed this generator with a previously saved state you can pass it as the
             * `seed` value in your game config, or call this method directly after Phaser has booted.
             * 
             * Call this method with no parameters to return the current state.
             * 
             * If providing a state it should match the same format that this method
             * returns, which is a string with a header `!rnd` followed by the `c`,
             * `s0`, `s1` and `s2` values respectively, each comma-delimited.
             * @param state Generator state to be set.
             */
            state(state?: string): string;

        }

        /**
         * [description]
         * @param vector [description]
         * @param scale [description]
         */
        function RandomXY(vector: Phaser.Math.Vector2, scale: number): Phaser.Math.Vector2;

        /**
         * [description]
         * @param vec3 [description]
         * @param radius [description] Default 1.
         */
        function RandomXYZ(vec3: Phaser.Math.Vector3, radius?: number): Phaser.Math.Vector3;

        /**
         * [description]
         * @param vec4 [description]
         * @param scale [description] Default 1.
         */
        function RandomXYZW(vec4: Phaser.Math.Vector4, scale?: number): Phaser.Math.Vector4;

        /**
         * [description]
         * @param point [description]
         * @param angle [description]
         */
        function Rotate(point: Phaser.Geom.Point | object, angle: number): Phaser.Geom.Point;

        /**
         * [description]
         * @param point [description]
         * @param x [description]
         * @param y [description]
         * @param angle [description]
         */
        function RotateAround(point: Phaser.Geom.Point | object, x: number, y: number, angle: number): Phaser.Geom.Point;

        /**
         * [description]
         * @param point The Point to be rotated.
         * @param x The horizontal coordinate to rotate around.
         * @param y The vertical coordinate to rotate around.
         * @param angle The angle of rotation in radians.
         * @param distance [description]
         */
        function RotateAroundDistance(point: Phaser.Geom.Point | object, x: number, y: number, angle: number, distance: number): Phaser.Geom.Point;

        /**
         * Rotates a vector in place by axis angle.
         * 
         * This is the same as transforming a point by an 
         * axis-angle quaternion, but it has higher precision.
         * @param vec [description]
         * @param axis [description]
         * @param radians [description]
         */
        function RotateVec3(vec: Phaser.Math.Vector3, axis: Phaser.Math.Vector3, radians: number): Phaser.Math.Vector3;

        /**
         * [description]
         * @param value [description]
         */
        function RoundAwayFromZero(value: number): number;

        /**
         * [description]
         * @param value [description]
         * @param place [description] Default 0.
         * @param base [description] Default 10.
         */
        function RoundTo(value: number, place?: integer, base?: integer): number;

        /**
         * [description]
         * @param length [description]
         * @param sinAmp [description]
         * @param cosAmp [description]
         * @param frequency [description]
         */
        function SinCosTableGenerator(length: number, sinAmp: number, cosAmp: number, frequency: number): SinCosTable;

        /**
         * [description]
         * @param x [description]
         * @param min [description]
         * @param max [description]
         */
        function SmootherStep(x: number, min: number, max: number): number;

        /**
         * [description]
         * @param x [description]
         * @param min [description]
         * @param max [description]
         */
        function SmoothStep(x: number, min: number, max: number): number;

        namespace Snap {
            /**
             * [description]
             * @param value [description]
             * @param gap [description]
             * @param start [description] Default 0.
             */
            function Ceil(value: number, gap: number, start?: number): number;

            /**
             * [description]
             * @param value [description]
             * @param gap [description]
             * @param start [description] Default 0.
             */
            function Floor(value: number, gap: number, start?: number): number;

            /**
             * [description]
             * @param value [description]
             * @param gap [description]
             * @param start [description] Default 0.
             */
            function To(value: number, gap: number, start?: number): number;

        }

        /**
         * Takes the `x` and `y` coordinates and transforms them into the same space as
         * defined by the position, rotation and scale values.
         * @param x The x coordinate to be transformed.
         * @param y The y coordinate to be transformed.
         * @param positionX Horizontal position of the transform point.
         * @param positionY Vertical position of the transform point.
         * @param rotation Rotation of the transform point, in radians.
         * @param scaleX Horizontal scale of the transform point.
         * @param scaleY Vertical scale of the transform point.
         * @param output [description]
         */
        function TransformXY(x: number, y: number, positionX: number, positionY: number, rotation: number, scaleX: number, scaleY: number, output?: Phaser.Math.Vector2 | Phaser.Geom.Point | object): Phaser.Math.Vector2 | Phaser.Geom.Point | object;

        /**
         * [description]
         */
        class Vector2 {
            /**
             * 
             * @param x [description]
             * @param y [description]
             */
            constructor(x?: number, y?: number);

            /**
             * The x component of this Vector.
             */
            x: number;

            /**
             * The y component of this Vector.
             */
            y: number;

            /**
             * [description]
             */
            clone(): Phaser.Math.Vector2;

            /**
             * [description]
             * @param src [description]
             */
            copy(src: Phaser.Math.Vector2): Phaser.Math.Vector2;

            /**
             * [description]
             * @param obj [description]
             */
            setFromObject(obj: Vector2Like): Phaser.Math.Vector2;

            /**
             * [description]
             * @param x [description]
             * @param y [description] Default x.
             */
            set(x: number, y?: number): Phaser.Math.Vector2;

            /**
             * Sets the `x` and `y` values of this object from a given polar coordinate.
             * @param azimuth The angular coordinate, in radians.
             * @param radius The radial coordinate (length). Default 1.
             */
            setToPolar(azimuth: number, radius?: number): Phaser.Math.Vector2;

            /**
             * [description]
             * @param v [description]
             */
            equals(v: Phaser.Math.Vector2): boolean;

            /**
             * [description]
             */
            angle(): number;

            /**
             * [description]
             * @param src [description]
             */
            add(src: Phaser.Math.Vector2): Phaser.Math.Vector2;

            /**
             * [description]
             * @param src [description]
             */
            subtract(src: Phaser.Math.Vector2): Phaser.Math.Vector2;

            /**
             * [description]
             * @param src [description]
             */
            multiply(src: Phaser.Math.Vector2): Phaser.Math.Vector2;

            /**
             * [description]
             * @param value [description]
             */
            scale(value: number): Phaser.Math.Vector2;

            /**
             * [description]
             * @param src [description]
             */
            divide(src: Phaser.Math.Vector2): Phaser.Math.Vector2;

            /**
             * [description]
             */
            negate(): Phaser.Math.Vector2;

            /**
             * [description]
             * @param src [description]
             */
            distance(src: Phaser.Math.Vector2): number;

            /**
             * [description]
             * @param src [description]
             */
            distanceSq(src: Phaser.Math.Vector2): number;

            /**
             * [description]
             */
            length(): number;

            /**
             * [description]
             */
            lengthSq(): number;

            /**
             * [description]
             */
            normalize(): Phaser.Math.Vector2;

            /**
             * [description]
             */
            normalizeRightHand(): Phaser.Math.Vector2;

            /**
             * [description]
             * @param src [description]
             */
            dot(src: Phaser.Math.Vector2): number;

            /**
             * [description]
             * @param src [description]
             */
            cross(src: Phaser.Math.Vector2): number;

            /**
             * [description]
             * @param src [description]
             * @param t [description] Default 0.
             */
            lerp(src: Phaser.Math.Vector2, t?: number): Phaser.Math.Vector2;

            /**
             * [description]
             * @param mat [description]
             */
            transformMat3(mat: Phaser.Math.Matrix3): Phaser.Math.Vector2;

            /**
             * [description]
             * @param mat [description]
             */
            transformMat4(mat: Phaser.Math.Matrix4): Phaser.Math.Vector2;

            /**
             * [description]
             */
            reset(): Phaser.Math.Vector2;

            /**
             * A static zero Vector2 for use by reference.
             */
            static ZERO(): void;

        }

        /**
         * [description]
         */
        class Vector3 {
            /**
             * 
             * @param x [description]
             * @param y [description]
             * @param z [description]
             */
            constructor(x?: number, y?: number, z?: number);

            /**
             * The x component of this Vector.
             */
            x: number;

            /**
             * The y component of this Vector.
             */
            y: number;

            /**
             * The z component of this Vector.
             */
            z: number;

            /**
             * [description]
             */
            up(): Phaser.Math.Vector3;

            /**
             * [description]
             */
            clone(): Phaser.Math.Vector3;

            /**
             * [description]
             * @param a [description]
             * @param b [description]
             */
            crossVectors(a: Phaser.Math.Vector3, b: Phaser.Math.Vector3): Phaser.Math.Vector3;

            /**
             * [description]
             * @param v The Vector3 to compare against.
             */
            equals(v: Phaser.Math.Vector3): boolean;

            /**
             * [description]
             * @param src [description]
             */
            copy(src: Phaser.Math.Vector2 | Phaser.Math.Vector3): Phaser.Math.Vector3;

            /**
             * [description]
             * @param x [description]
             * @param y [description]
             * @param z [description]
             */
            set(x: number | object, y?: number, z?: number): Phaser.Math.Vector3;

            /**
             * [description]
             * @param v [description]
             */
            add(v: Phaser.Math.Vector2 | Phaser.Math.Vector3): Phaser.Math.Vector3;

            /**
             * [description]
             * @param v [description]
             */
            subtract(v: Phaser.Math.Vector2 | Phaser.Math.Vector3): Phaser.Math.Vector3;

            /**
             * [description]
             * @param v [description]
             */
            multiply(v: Phaser.Math.Vector2 | Phaser.Math.Vector3): Phaser.Math.Vector3;

            /**
             * [description]
             * @param scale [description]
             */
            scale(scale: number): Phaser.Math.Vector3;

            /**
             * [description]
             * @param v [description]
             */
            divide(v: Phaser.Math.Vector2 | Phaser.Math.Vector3): Phaser.Math.Vector3;

            /**
             * [description]
             */
            negate(): Phaser.Math.Vector3;

            /**
             * [description]
             * @param v [description]
             */
            distance(v: Phaser.Math.Vector2 | Phaser.Math.Vector3): number;

            /**
             * [description]
             * @param v [description]
             */
            distanceSq(v: Phaser.Math.Vector2 | Phaser.Math.Vector3): number;

            /**
             * [description]
             */
            length(): number;

            /**
             * [description]
             */
            lengthSq(): number;

            /**
             * [description]
             * @param v [description]
             */
            normalize(v: Phaser.Math.Vector2 | Phaser.Math.Vector3): Phaser.Math.Vector3;

            /**
             * [description]
             * @param v [description]
             */
            dot(v: Phaser.Math.Vector3): number;

            /**
             * [description]
             * @param v [description]
             */
            cross(v: Phaser.Math.Vector3): Phaser.Math.Vector3;

            /**
             * [description]
             * @param v [description]
             * @param t [description] Default 0.
             */
            lerp(v: Phaser.Math.Vector3, t?: number): Phaser.Math.Vector3;

            /**
             * [description]
             * @param mat [description]
             */
            transformMat3(mat: Phaser.Math.Matrix3): Phaser.Math.Vector3;

            /**
             * [description]
             * @param mat [description]
             */
            transformMat4(mat: Phaser.Math.Matrix4): Phaser.Math.Vector3;

            /**
             * [description]
             * @param mat [description]
             */
            transformCoordinates(mat: Phaser.Math.Matrix4): Phaser.Math.Vector3;

            /**
             * [description]
             * @param q [description]
             */
            transformQuat(q: Phaser.Math.Quaternion): Phaser.Math.Vector3;

            /**
             * Multiplies this Vector3 by the specified matrix, applying a W divide. This is useful for projection,
             * e.g. unprojecting a 2D point into 3D space.
             * @param mat [description]
             */
            project(mat: Phaser.Math.Matrix4): Phaser.Math.Vector3;

            /**
             * Unproject this point from 2D space to 3D space.
             * The point should have its x and y properties set to
             * 2D screen space, and the z either at 0 (near plane)
             * or 1 (far plane). The provided matrix is assumed to already
             * be combined, i.e. projection * view * model.
             * 
             * After this operation, this vector's (x, y, z) components will
             * represent the unprojected 3D coordinate.
             * @param viewport Screen x, y, width and height in pixels.
             * @param invProjectionView Combined projection and view matrix.
             */
            unproject(viewport: Phaser.Math.Vector4, invProjectionView: Phaser.Math.Matrix4): Phaser.Math.Vector3;

            /**
             * [description]
             */
            reset(): Phaser.Math.Vector3;

        }

        /**
         * [description]
         */
        class Vector4 {
            /**
             * 
             * @param x [description]
             * @param y [description]
             * @param z [description]
             * @param w [description]
             */
            constructor(x?: number, y?: number, z?: number, w?: number);

            /**
             * The x component of this Vector.
             */
            x: number;

            /**
             * The y component of this Vector.
             */
            y: number;

            /**
             * The z component of this Vector.
             */
            z: number;

            /**
             * The w component of this Vector.
             */
            w: number;

            /**
             * [description]
             */
            clone(): Phaser.Math.Vector4;

            /**
             * [description]
             * @param src [description]
             */
            copy(src: Phaser.Math.Vector4): Phaser.Math.Vector4;

            /**
             * [description]
             * @param v [description]
             */
            equals(v: Phaser.Math.Vector4): boolean;

            /**
             * [description]
             * @param x [description]
             * @param y [description]
             * @param z [description]
             * @param w [description]
             */
            set(x: number, y: number, z: number, w: number): Phaser.Math.Vector4;

            /**
             * [description]
             * @param v [description]
             */
            add(v: Phaser.Math.Vector2 | Phaser.Math.Vector3 | Phaser.Math.Vector4): Phaser.Math.Vector4;

            /**
             * [description]
             * @param v [description]
             */
            subtract(v: Phaser.Math.Vector2 | Phaser.Math.Vector3 | Phaser.Math.Vector4): Phaser.Math.Vector4;

            /**
             * [description]
             * @param scale [description]
             */
            scale(scale: number): Phaser.Math.Vector4;

            /**
             * [description]
             */
            length(): number;

            /**
             * [description]
             */
            lengthSq(): number;

            /**
             * [description]
             */
            normalize(): Phaser.Math.Vector4;

            /**
             * [description]
             * @param v [description]
             */
            dot(v: Phaser.Math.Vector4): number;

            /**
             * [description]
             * @param v [description]
             * @param t [description] Default 0.
             */
            lerp(v: Phaser.Math.Vector4, t?: number): Phaser.Math.Vector4;

            /**
             * [description]
             * @param v [description]
             */
            multiply(v: Phaser.Math.Vector2 | Phaser.Math.Vector3 | Phaser.Math.Vector4): Phaser.Math.Vector4;

            /**
             * [description]
             * @param v [description]
             */
            divide(v: Phaser.Math.Vector2 | Phaser.Math.Vector3 | Phaser.Math.Vector4): Phaser.Math.Vector4;

            /**
             * [description]
             * @param v [description]
             */
            distance(v: Phaser.Math.Vector2 | Phaser.Math.Vector3 | Phaser.Math.Vector4): number;

            /**
             * [description]
             * @param v [description]
             */
            distanceSq(v: Phaser.Math.Vector2 | Phaser.Math.Vector3 | Phaser.Math.Vector4): number;

            /**
             * [description]
             */
            negate(): Phaser.Math.Vector4;

            /**
             * [description]
             * @param mat [description]
             */
            transformMat4(mat: Phaser.Math.Matrix4): Phaser.Math.Vector4;

            /**
             * [description]
             * @param q [description]
             */
            transformQuat(q: Phaser.Math.Quaternion): Phaser.Math.Vector4;

            /**
             * [description]
             */
            reset(): Phaser.Math.Vector4;

        }

        /**
         * Checks if the two values are within the given `tolerance` of each other.
         * @param a [description]
         * @param b [description]
         * @param tolerance The tolerance. Anything equal to or less than this value is considered as being within range.
         */
        function Within(a: number, b: number, tolerance: number): boolean;

        /**
         * [description]
         * @param value [description]
         * @param min [description]
         * @param max [description]
         */
        function Wrap(value: number, min: number, max: number): number;

    }

    namespace Physics {
        namespace Arcade {
            /**
             * An Arcade Physics Image Game Object.
             * 
             * 
             * 
             * An Image is a light-weight Game Object useful for the display of static images in your game,
             * 
             * such as logos, backgrounds, scenery or other non-animated elements. Images can have input
             * 
             * events and physics bodies, or be tweened, tinted or scrolled. The main difference between an
             * 
             * Image and a Sprite is that you cannot animate an Image as they do not have the Animation component.
             */
            class Image extends Phaser.GameObjects.Image implements Components.Acceleration, Components.Angular, Components.Bounce, Components.Debug, Components.Drag, Components.Enable, Components.Friction, Components.Gravity, Components.Immovable, Components.Mass, Components.Size, Components.Velocity, Phaser.GameObjects.Components.Alpha, Phaser.GameObjects.Components.BlendMode, Phaser.GameObjects.Components.Depth, Phaser.GameObjects.Components.Flip, Phaser.GameObjects.Components.GetBounds, Phaser.GameObjects.Components.Origin, Phaser.GameObjects.Components.Pipeline, Phaser.GameObjects.Components.ScaleMode, Phaser.GameObjects.Components.ScrollFactor, Phaser.GameObjects.Components.Size, Phaser.GameObjects.Components.Texture, Phaser.GameObjects.Components.Tint, Phaser.GameObjects.Components.Transform, Phaser.GameObjects.Components.Visible {
                /**
                 * 
                 * @param scene The Scene to which this Game Object belongs. A Game Object can only belong to one Scene at a time.
                 * @param x The horizontal position of this Game Object in the world.
                 * @param y The vertical position of this Game Object in the world.
                 * @param texture The key of the Texture this Game Object will use to render with, as stored in the Texture Manager.
                 * @param frame An optional frame from the Texture this Game Object is rendering with.
                 */
                constructor(scene: Phaser.Scene, x: number, y: number, texture: string, frame?: string | integer);

                /**
                 * Clears all alpha values associated with this Game Object.
                 * Immediately sets the alpha levels back to 1 (fully opaque)
                 */
                clearAlpha(): Phaser.GameObjects.GameObject;

                /**
                 * Set the Alpha level of this Game Object. The alpha controls the opacity of the Game Object as it renders.
                 * Alpha values are provided as a float between 0, fully transparent, and 1, fully opaque.
                 * 
                 * If your game is running under WebGL you can optionally specify four different alpha values, each of which
                 * correspond to the four corners of the Game Object. Under Canvas only the `topLeft` value given is used.
                 * @param topLeft The alpha value used for the top-left of the Game Object. If this is the only value given it's applied across the whole Game Object. Default 1.
                 * @param topRight The alpha value used for the top-right of the Game Object. WebGL only.
                 * @param bottomLeft The alpha value used for the bottom-left of the Game Object. WebGL only.
                 * @param bottomRight The alpha value used for the bottom-right of the Game Object. WebGL only.
                 */
                setAlpha(topLeft?: number, topRight?: number, bottomLeft?: number, bottomRight?: number): Phaser.GameObjects.GameObject;

                /**
                 * The alpha value of the Game Object.
                 * 
                 * This is a global value, impacting the entire Game Object, not just a region of it.
                 */
                alpha: number;

                /**
                 * The alpha value starting from the top-left of the Game Object.
                 * This value is interpolated from the corner to the center of the Game Object.
                 */
                alphaTopLeft: number;

                /**
                 * The alpha value starting from the top-right of the Game Object.
                 * This value is interpolated from the corner to the center of the Game Object.
                 */
                alphaTopRight: number;

                /**
                 * The alpha value starting from the bottom-left of the Game Object.
                 * This value is interpolated from the corner to the center of the Game Object.
                 */
                alphaBottomLeft: number;

                /**
                 * The alpha value starting from the bottom-right of the Game Object.
                 * This value is interpolated from the corner to the center of the Game Object.
                 */
                alphaBottomRight: number;

                /**
                 * Sets the Blend Mode being used by this Game Object.
                 * 
                 * This can be a const, such as `Phaser.BlendModes.SCREEN`, or an integer, such as 4 (for Overlay)
                 * 
                 * Under WebGL only the following Blend Modes are available:
                 * 
                 * * ADD
                 * * MULTIPLY
                 * * SCREEN
                 * 
                 * Canvas has more available depending on browser support.
                 * 
                 * You can also create your own custom Blend Modes in WebGL.
                 * 
                 * Blend modes have different effects under Canvas and WebGL, and from browser to browser, depending
                 * on support. Blend Modes also cause a WebGL batch flush should it encounter a new blend mode. For these
                 * reasons try to be careful about the construction of your Scene and the frequency of which blend modes
                 * are used.
                 */
                blendMode: Phaser.BlendModes | string;

                /**
                 * Sets the Blend Mode being used by this Game Object.
                 * 
                 * This can be a const, such as `Phaser.BlendModes.SCREEN`, or an integer, such as 4 (for Overlay)
                 * 
                 * Under WebGL only the following Blend Modes are available:
                 * 
                 * * ADD
                 * * MULTIPLY
                 * * SCREEN
                 * 
                 * Canvas has more available depending on browser support.
                 * 
                 * You can also create your own custom Blend Modes in WebGL.
                 * 
                 * Blend modes have different effects under Canvas and WebGL, and from browser to browser, depending
                 * on support. Blend Modes also cause a WebGL batch flush should it encounter a new blend mode. For these
                 * reasons try to be careful about the construction of your Scene and the frequency of which blend modes
                 * are used.
                 * @param value The BlendMode value. Either a string or a CONST.
                 */
                setBlendMode(value: string | Phaser.BlendModes): Phaser.GameObjects.GameObject;

                /**
                 * The depth of this Game Object within the Scene.
                 * 
                 * The depth is also known as the 'z-index' in some environments, and allows you to change the rendering order
                 * of Game Objects, without actually moving their position in the display list.
                 * 
                 * The depth starts from zero (the default value) and increases from that point. A Game Object with a higher depth
                 * value will always render in front of one with a lower value.
                 * 
                 * Setting the depth will queue a depth sort event within the Scene.
                 */
                depth: number;

                /**
                 * The depth of this Game Object within the Scene.
                 * 
                 * The depth is also known as the 'z-index' in some environments, and allows you to change the rendering order
                 * of Game Objects, without actually moving their position in the display list.
                 * 
                 * The depth starts from zero (the default value) and increases from that point. A Game Object with a higher depth
                 * value will always render in front of one with a lower value.
                 * 
                 * Setting the depth will queue a depth sort event within the Scene.
                 * @param value The depth of this Game Object.
                 */
                setDepth(value: integer): Phaser.GameObjects.GameObject;

                /**
                 * The horizontally flipped state of the Game Object.
                 * A Game Object that is flipped horizontally will render inversed on the horizontal axis.
                 * Flipping always takes place from the middle of the texture and does not impact the scale value.
                 */
                flipX: boolean;

                /**
                 * The vertically flipped state of the Game Object.
                 * A Game Object that is flipped vertically will render inversed on the vertical axis (i.e. upside down)
                 * Flipping always takes place from the middle of the texture and does not impact the scale value.
                 */
                flipY: boolean;

                /**
                 * Toggles the horizontal flipped state of this Game Object.
                 */
                toggleFlipX(): Phaser.GameObjects.GameObject;

                /**
                 * Toggles the vertical flipped state of this Game Object.
                 */
                toggleFlipY(): Phaser.GameObjects.GameObject;

                /**
                 * Sets the horizontal flipped state of this Game Object.
                 * @param value The flipped state. `false` for no flip, or `true` to be flipped.
                 */
                setFlipX(value: boolean): Phaser.GameObjects.GameObject;

                /**
                 * Sets the vertical flipped state of this Game Object.
                 * @param value The flipped state. `false` for no flip, or `true` to be flipped.
                 */
                setFlipY(value: boolean): Phaser.GameObjects.GameObject;

                /**
                 * Sets the horizontal and vertical flipped state of this Game Object.
                 * @param x The horizontal flipped state. `false` for no flip, or `true` to be flipped.
                 * @param y The horizontal flipped state. `false` for no flip, or `true` to be flipped.
                 */
                setFlip(x: boolean, y: boolean): Phaser.GameObjects.GameObject;

                /**
                 * Resets the horizontal and vertical flipped state of this Game Object back to their default un-flipped state.
                 */
                resetFlip(): Phaser.GameObjects.GameObject;

                /**
                 * Gets the center coordinate of this Game Object, regardless of origin.
                 * @param output An object to store the values in. If not provided a new Vector2 will be created.
                 */
                getCenter<O extends Phaser.Math.Vector2>(output?: O): O;

                /**
                 * Gets the top-left corner coordinate of this Game Object, regardless of origin.
                 * @param output An object to store the values in. If not provided a new Vector2 will be created.
                 */
                getTopLeft<O extends Phaser.Math.Vector2>(output?: O): O;

                /**
                 * Gets the top-right corner coordinate of this Game Object, regardless of origin.
                 * @param output An object to store the values in. If not provided a new Vector2 will be created.
                 */
                getTopRight<O extends Phaser.Math.Vector2>(output?: O): O;

                /**
                 * Gets the bottom-left corner coordinate of this Game Object, regardless of origin.
                 * @param output An object to store the values in. If not provided a new Vector2 will be created.
                 */
                getBottomLeft<O extends Phaser.Math.Vector2>(output?: O): O;

                /**
                 * Gets the bottom-right corner coordinate of this Game Object, regardless of origin.
                 * @param output An object to store the values in. If not provided a new Vector2 will be created.
                 */
                getBottomRight<O extends Phaser.Math.Vector2>(output?: O): O;

                /**
                 * Gets the bounds of this Game Object, regardless of origin.
                 * The values are stored and returned in a Rectangle, or Rectangle-like, object.
                 * @param output An object to store the values in. If not provided a new Rectangle will be created.
                 */
                getBounds<O extends Phaser.Math.Vector2>(output?: O): O;

                /**
                 * The horizontal origin of this Game Object.
                 * The origin maps the relationship between the size and position of the Game Object.
                 * The default value is 0.5, meaning all Game Objects are positioned based on their center.
                 * Setting the value to 0 means the position now relates to the left of the Game Object.
                 */
                originX: number;

                /**
                 * The vertical origin of this Game Object.
                 * The origin maps the relationship between the size and position of the Game Object.
                 * The default value is 0.5, meaning all Game Objects are positioned based on their center.
                 * Setting the value to 0 means the position now relates to the top of the Game Object.
                 */
                originY: number;

                /**
                 * The horizontal display origin of this Game Object.
                 * The origin is a normalized value between 0 and 1.
                 * The displayOrigin is a pixel value, based on the size of the Game Object combined with the origin.
                 */
                displayOriginX: number;

                /**
                 * The vertical display origin of this Game Object.
                 * The origin is a normalized value between 0 and 1.
                 * The displayOrigin is a pixel value, based on the size of the Game Object combined with the origin.
                 */
                displayOriginY: number;

                /**
                 * Sets the origin of this Game Object.
                 * 
                 * The values are given in the range 0 to 1.
                 * @param x The horizontal origin value. Default 0.5.
                 * @param y The vertical origin value. If not defined it will be set to the value of `x`. Default x.
                 */
                setOrigin(x?: number, y?: number): Phaser.GameObjects.GameObject;

                /**
                 * Sets the origin of this Game Object based on the Pivot values in its Frame.
                 */
                setOriginFromFrame(): Phaser.GameObjects.GameObject;

                /**
                 * Sets the display origin of this Game Object.
                 * The difference between this and setting the origin is that you can use pixel values for setting the display origin.
                 * @param x The horizontal display origin value. Default 0.
                 * @param y The vertical display origin value. If not defined it will be set to the value of `x`. Default x.
                 */
                setDisplayOrigin(x?: number, y?: number): Phaser.GameObjects.GameObject;

 