/**
 * Created by rockyl on 2019-03-19.
 */
 
const glob = require('glob');
const fs = require('fs');

let files = glob.sync('src/**/!(index|registerAllComponents).ts');

let fileContent = `import {registerDef} from "scilla-core"

`;

const imports = [];
const contents = [];

for(let file of files){
	let requirePath = '.' + file.replace('src', '').replace('.ts', '');
	let fullClassName = file.replace('src', 'components').replace('.ts', '');
	let shortClassName = fullClassName.substr(fullClassName.lastIndexOf('/') + 1);

	imports.push(`import ${shortClassName} from '${requirePath}';`);
	contents.push(`	registerDef('${fullClassName}', ${shortClassName});`);
}

fileContent += imports.join('\n') + `

export function registerAllComponents(){
` + contents.join('\n') + '\n}';

fs.writeFileSync('src/registerAllComponents.ts', fileContent);