/**
 * Created by rockyl on 2018-12-03.
 */
import {Entity} from "./Entity";
import {loadResItems} from "../assets-manager";

export class Scene {
	name: string;
	root: Entity;
	resourceGroups: any = {
		preload: [],
		delay: [],
	};

	config: any;

	initByConfig(config){
		this.config = config;
		this.name = config.name;

		const resourceGroups = config['resource-groups'];
		for(let key in resourceGroups){
			this.resourceGroups[key] = resourceGroups[key];
		}
	}

	async loadResGroup(name, progress?){
		await loadResItems(this.resourceGroups[name], progress);
	}
}
