import {registerDef} from "scilla"

import BounceZoom from './animation/BounceZoom';
import Fade from './animation/Fade';
import Rotation from './animation/Rotation';
import RoundLoop from './animation/RoundLoop';
import Swing from './animation/Swing';
import TouchZoom from './animation/TouchZoom';
import Wave from './animation/Wave';
import ZoomLoop from './animation/ZoomLoop';
import InteractComponent from './base/InteractComponent';
import TouchInterrupt from './base/TouchInterrupt';
import Transform from './base/Transform';
import CameraController from './other/CameraController';
import ContentSizeFitter from './other/ContentSizeFitter';
import RelativeLayout from './other/RelativeLayout';
import CircleRenderer from './renderer/CircleRenderer';
import FrameAnimationRenderer from './renderer/FrameAnimationRenderer';
import GraphicRenderer from './renderer/GraphicRenderer';
import LineRenderer from './renderer/LineRenderer';
import RectRenderer from './renderer/RectRenderer';
import Renderer from './renderer/Renderer';
import TextRenderer from './renderer/TextRenderer';
import TextureRenderer from './renderer/TextureRenderer';
import Button from './ui/Button';
import ProgressBar from './ui/ProgressBar';
import ScrollView from './ui/ScrollView';

export function registerAllComponents(){
	registerDef('components/animation/BounceZoom', BounceZoom);
	registerDef('components/animation/Fade', Fade);
	registerDef('components/animation/Rotation', Rotation);
	registerDef('components/animation/RoundLoop', RoundLoop);
	registerDef('components/animation/Swing', Swing);
	registerDef('components/animation/TouchZoom', TouchZoom);
	registerDef('components/animation/Wave', Wave);
	registerDef('components/animation/ZoomLoop', ZoomLoop);
	registerDef('components/base/InteractComponent', InteractComponent);
	registerDef('components/base/TouchInterrupt', TouchInterrupt);
	registerDef('components/base/Transform', Transform);
	registerDef('components/other/CameraController', CameraController);
	registerDef('components/other/ContentSizeFitter', ContentSizeFitter);
	registerDef('components/other/RelativeLayout', RelativeLayout);
	registerDef('components/renderer/CircleRenderer', CircleRenderer);
	registerDef('components/renderer/FrameAnimationRenderer', FrameAnimationRenderer);
	registerDef('components/renderer/GraphicRenderer', GraphicRenderer);
	registerDef('components/renderer/LineRenderer', LineRenderer);
	registerDef('components/renderer/RectRenderer', RectRenderer);
	registerDef('components/renderer/Renderer', Renderer);
	registerDef('components/renderer/TextRenderer', TextRenderer);
	registerDef('components/renderer/TextureRenderer', TextureRenderer);
	registerDef('components/ui/Button', Button);
	registerDef('components/ui/ProgressBar', ProgressBar);
	registerDef('components/ui/ScrollView', ScrollView);
}