/**
 * Created by rockyl on 2018/11/9.
 *
 * 装饰器
 */

/**
 * 属性修改时触发
 * @param onChange
 */
export function fieldChanged(onChange) {
	return function (target: any, key: string) {
		const privateKey = '_' + key;
		Object.defineProperty(target, key, {
			enumerable: true,
			get: function () {
				return this[privateKey];
			},
			set: function (v) {
				const oldValue = this[privateKey];
				if (oldValue !== v) {
					this[privateKey] = v;
					onChange.apply(this, [v, key, oldValue]);
				}
			}
		})
	}
}

/**
 * 属性变脏时设置宿主的dirty属性为true
 */
export const dirtyFieldDetector = fieldChanged(
	function (value, key, oldValue) {
		this['dirty'] = true;
	}
);

/**
 * 属性变脏时触发onModify方法
 */
export const dirtyFieldTrigger = fieldChanged(
	function (value, key, oldValue) {
		this['onModify'] && this['onModify'](value, key, oldValue);
	}
);
