/**
 * Created by rockyl on 2018/8/1.
 *
 * 对象池
 */
 
let all = {};

function getGroup(name){
	let group = all[name];
	if(!group){
		throw new Error('group ' + name + ' not registered.');
	}

	return group;
}

export function register(name, newFunc, initFunc){
	all[name] = {name, newFunc, initFunc, pool: []};
}

export function get(name, ...params){
	let group = getGroup(name);

	let {newFunc, initFunc, pool} = group;

	let instance;
	if(pool.length == 0){
		instance = newFunc();
	}else{
		instance = pool.pop();
	}

	initFunc(instance, ...params);

	return instance;
}

export function recycle(name, instance){
	let group = getGroup(name);

	group.pool.push(instance);
}