/**
 * Created by rockyl on 2018/11/6.
 */

import GraphicRenderer from "./GraphicRenderer";
import {decorators} from "scilla"

const {dirtyFieldDetector} = decorators;

/**
 * (圆角)矩形渲染器
 */
export default class RectRenderer extends GraphicRenderer {
	@dirtyFieldDetector
	width = 100;
	@dirtyFieldDetector
	height = 100;
	@dirtyFieldDetector
	cornerRadius = 0;

	protected getRenderSize(): any {
		const {width, height} = this;
		return {width, height};
	}

	/**
	 * @inheritDoc
	 */
	protected draw() {
		const {PI} = Math;
		const {context, cornerRadius: r, bounds: {width, height}, _margin, _useCacheMode} = this;

		let offset = _useCacheMode ? _margin : 0;

		if (r) {
			context.moveTo(offset + r, offset + 0);
			context.lineTo(offset + width - r, offset + 0);
			context.arc(offset + width - r, offset + r, r, PI * 3 / 2, PI * 2);
			context.lineTo(offset + width, offset + height - r);
			context.arc(offset + width - r, offset + height - r, r, 0, PI / 2);
			context.lineTo(offset + r, offset + height);
			context.arc(offset + r, offset + height - r, r, PI / 2, PI);
			context.lineTo(offset + 0, offset + r);
			context.arc(offset + r, offset + r, r, PI, PI * 3 / 2);
		} else {
			context.rect(offset, offset, width, height);
		}

		super.draw();
	}
}
