/**
 * Created by rockyl on 2018-12-17.
 *
 * 内容组件尺寸自适应组件
 */

import {ScillaComponent, Size} from "scilla";
import Transform from "../base/Transform";

export default class ContentSizeFitter extends ScillaComponent {
	private _measureSize: Size = new Size();

	afterUpdate() {
		super.afterUpdate();

		const measureSize = this._measureSize;
		measureSize.set(0, 0);
		for(let child of this.entity.children){
			const transform = child.getComponent(Transform);
			if(transform){
				const {width, height, pivot} = transform;
				measureSize.width += width;
				measureSize.height += height;
			}
		}

		this.transform.width = measureSize.width;
		this.transform.height = measureSize.height;
	}
}
