import { Entity, ScillaComponent, createTween, Vector2D, createVector2D } from 'scilla-core/src';
import { getTransForm } from './utils';
import { setLabelText } from './labelUtils';
import { setX, setY } from './setXY';

export default class Slider extends ScillaComponent {
    slidermask: Entity;
    sliderLabel1: Entity;
    sliderLabel2: Entity;

    currentLabel1: Entity;
    currentLabel2: Entity;

    private dataList: string[];
    _timer;

    onCreate() {
        super.onCreate();
        this.dataList = [
            '11111111',
            '222222222',
            '33333333',
            '4444444',
            '55555555',
        ];
    }

    updateSlider() {
        //prepare
        this.currentLabel1 = this.sliderLabel1;
        this.currentLabel2 = this.sliderLabel2;

        setLabelText(this.sliderLabel1, this.dataList[0]);
        setLabelText(this.sliderLabel2, this.dataList[1]);

        setY(this.currentLabel1, 0);
        setY(this.currentLabel2, 41);
        //ready to slide
        createTween(getTransForm(this.currentLabel1), false, {
            clazz: Vector2D,
            fields: ['y'],
            autoPlay: true,
            initFields: ['_position']
        })
            .to({
                position: createVector2D(0, -41)
            }, 1000);

        createTween(getTransForm(this.currentLabel2), false, {
            clazz: Vector2D,
            fields: ['y'],
            autoPlay: true,
            initFields: ['_position']
        })
            .to({
                position: createVector2D(0, 0)
            }, 1000).call(() => {
                //on slide over
                setY(this.currentLabel1, 41);
                const tmp1 = this.currentLabel1;
                const tmp2 = this.currentLabel2;
                this.currentLabel1 = tmp2;
                this.currentLabel2 = tmp1;

                const first = this.dataList.shift();
                this.dataList.push(first);

                setLabelText(this.currentLabel2, this.dataList[1]);
            });
    }

    onAwake() {
        super.onAwake();

        setLabelText(this.sliderLabel1, this.dataList[0]);
        setLabelText(this.sliderLabel2, this.dataList[1]);

        this._timer = setInterval(() => {
            this.updateSlider();
        }, 4000);
    }
}