/**
 * Created by rockyl on 2018-12-07.
 */
import {dirtyFieldTrigger} from "../tools/decorators";

/**
 * 尺寸
 */
export default class Size {
	@dirtyFieldTrigger
	width: number;
	@dirtyFieldTrigger
	height: number;

	onChange;

	constructor(width = NaN, height = NaN) {
		this.width = width;
		this.height = height;
	}

	setNaN(){
		this.width = NaN;
		this.height = NaN;
	}

	isEmpty(){
		
	}

	set(width?, height?) {
		if (width !== undefined) {
			this.width = width;
		}

		if (height !== undefined) {
			this.height = height;
		}
	}

	clone() {
		return new Size(this.width, this.height);
	}

	copyFrom(target) {
		this.width = target.width;
		this.height = target.height;
	}

	onModify(value, key, oldValue) {
		this.onChange && this.onChange(value, key, oldValue);
	}
}
