import { Entity, Texture, Vector2D } from 'scilla-core/src';
import { Renderer, Transform, TextureRenderer, RectRenderer } from 'scilla-components/src';

export const createMask = (parent: Entity, width: number, height: number) => {
    //遮罩的实现
    //1 父实体、子实体(即需要遮罩的实体)
    const mask = createEntity(parent); //
    const child = createEntity(mask);
    const rect = createRectangeRenderer(width, height, mask);
    rect.isUsedToMask = true;
    rect.anchor.x = -width / 2;
    child['mask'] = mask;
    return child
}

export const createMask2 = (progress: Entity, progressBarFrontBg: Entity, width: number, height: number) => {
    const mask = createEntity(progress);
    const child = progressBarFrontBg;
    (child.getComponent(Transform) as Transform).alpha = 0;
    // mask.addChild(child);
    const rect = createRectangeRenderer(width, height, mask);
    // rect.isUsedToMask = true;
    // rect.anchor.x = -width / 2;
    // child['mask'] = mask;
    return child
}

export const createEntity = (parent?: Entity, renderer?: Renderer) => {
    const entity = new Entity();
    entity.addComponent(new Transform());
    renderer && entity.addComponent(renderer);
    parent && parent.addChild(entity);
    return entity;
}

export const createTextureRenderer = (entity?: Entity, texture?: Texture) => {
    const textureRenderer = new TextureRenderer();
    entity && entity.addComponent(textureRenderer);
    texture && (textureRenderer.texture = texture);
    return textureRenderer;
}

export const createRectangeRenderer = (shapeWidth: number, shapeHeight: number, entity?: Entity) => {
    const renderer = new RectRenderer();
    renderer.cornerRadius = 12;
    renderer.width = shapeWidth;
    renderer.height = shapeHeight;
    renderer.fillColor = 'white';
    entity && entity.addComponent(renderer);
    return renderer;
}

export const getTextureWidth = (entity: Entity) => {
    const renderer = entity.getComponent(TextureRenderer) as TextureRenderer;
    return renderer.texture.width;
}

export const getTextureHeight = (entity: Entity) => {
    const renderer = entity.getComponent(TextureRenderer) as TextureRenderer;
    return renderer.texture.height;
}

const getTransform = (entity: Entity): Transform => {
    return entity.getComponent(Transform);
}

export const getPosition = (entity: Entity): Vector2D => {
    return getTransform(entity).position;
}

export const setXY = (entity: Entity, x: number, y: number) => {
    getPosition(entity).setXY(x, y);
}

export const setX = (entity: Entity, x: number) => {
    getPosition(entity).x = x
}

export const setY = (entity: Entity, y: number) => {
    getPosition(entity).y = y
}
