import { ScillaComponent, Entity } from 'scilla-core/src';
import { TextureRenderer } from 'scilla-components/src';
import { createMask, setXY, setX, createMask2 } from 'assets/utils/utils';

/**
 * 控件为随时间而变的任务进度提供了形象化的表示。
 **/
export default class ProgressBar extends ScillaComponent {
    _maximum: number;
    _minimum: number;
    _value: number;
    _fg: Entity;
    fgRenderer: TextureRenderer;
    _created = false;
    // _x = 0;
    // _y = 0;
    constructor(maximum: number, minimum: number) {
        super();
        this._maximum = maximum;
        this._minimum = minimum;
    }

    onCreate() {
        super.onCreate();
        const { entity } = this;//entity
        //从模板创建一个带遮罩的前景
        this.fgRenderer = this._fg.getComponent(TextureRenderer);

        createMask2(entity, this._fg, this.fgRenderer.texture.width, this.fgRenderer.texture.height);
        this._created = true;
        // setXY(this._fg.parent, this._x, this._y)
    }

    // set x(val: number) {
    //     this._x = val;
    //     if (!this._created) return;
    //     setX(this._fg.parent, this._x);
    // }
    // set y(val: number) {
    //     this._y = val;
    //     if (!this._created) return;
    //     setX(this._fg.parent, this._y);
    // }

    // updateRenderer() {
    //     if (!this._created) return;
    //     const distance = this._maximum - this._minimum;
    //     setX(this._fg, -this.fgRenderer.texture.width * (1 - (this._value - this._minimum) / distance));
    // }

    // set value(val: number) {
    //     this._value = val;
    //     this.updateRenderer();
    // }

    // get value() {
    //     return this._value;
    // }
}