/**
 * Created by rockyl on 2018/11/5.
 *
 * 自转组件
 */

import {createTween, ScillaComponent, ScillaEvent, Tween} from "scilla";

export default class Rotation extends ScillaComponent {
	duration: number = 10000;
	autoPlay: boolean = false;
	loop: number = -1;
	onComplete: ScillaEvent = new ScillaEvent();
	
	private _tween: Tween;

	onCreate() {
		super.onCreate();

	}

	onAwake() {
		super.onAwake();

		if(!this._tween){
			this._tween = createTween(this.transform, false, {autoPlay: this.autoPlay, loop: this.loop, initFields: ['_rotation']})
				.to({rotation: 360}, this.duration)
				.call(()=>{
					this.onComplete.invoke();
				});
		}
	}

	play(){
		this._tween.play(true);
	}

	stop(){
		this._tween.stop();
	}
}
