/**
 * Created by rockyl on 2018-11-29.
 */

import {dirtyFieldTrigger} from "../tools/decorators";

export enum FontStyle{
	/**
	 * 正常
	 */
	NORMAL =  'normal',
	/**
	 * 斜体
	 */
	ITALIC =  'italic',
	/**
	 * 倾斜
	 */
	OBLIQUE =  'oblique',
}

export enum FontVariant{
	/**
	 * 正常
	 */
	NORMAL =  'normal',
	/**
	 * 小型大写
	 */
	SMALL_CAPS =  'small-caps',
}

export enum FontWeight{
	/**
	 * 正常
	 */
	NORMAL = 'normal',
	/**
	 * 粗体
	 */
	BOLD = 'bold',
	/**
	 * 更粗
	 */
	BOLDER = 'bolder',
	/**
	 * 更细
	 */
	LIGHTER = 'lighter',
}

/**
 * 文本样式
 */
export class TextStyle {
	private readonly _callback;
	onChange;

	/**
	 * 字体样式
	 */
	@dirtyFieldTrigger
	fontStyle: FontStyle = FontStyle.NORMAL;

	/**
	 * 字体倾斜
	 */
	@dirtyFieldTrigger
	fontVariant: FontVariant = FontVariant.NORMAL;

	/**
	 * 字体宽度
	 */
	@dirtyFieldTrigger
	fontWeight: FontWeight = FontWeight.NORMAL;

	/**
	 * 字体尺寸
	 */
	@dirtyFieldTrigger
	fontSize: number = 25;

	/**
	 * 字体名称
	 */
	@dirtyFieldTrigger
	fontFamily: string = 'Arial';

	onModify(value, key, oldValue) {
		this.onChange && this.onChange(value, key, oldValue, 'textStyle');
	}
}
