/**
 * Created by rockyl on 2019-01-04.
 */

export default class LocalStorage {
	ID: string;

	constructor(ID: string) {
		this.ID = ID;
	}

	getName(key: string, prefix: string = null): string {
		return (prefix || !this.ID || this.ID == '' ? prefix : this.ID) + '_' + key;
	}

	getItem(key: string, prefix: string = null): string {
		return localStorage.getItem(this.getName(key, prefix));
	}

	setItem(key: string, value: string, prefix: string = null) {
		localStorage.setItem(this.getName(key, prefix), value);
	}

	getItemObj(key: string, defaultObj: any = null, prefix: string = null): any {
		let result: any;
		try {
			result = JSON.parse(this.getItem(key, prefix));
		} catch (e) {

		}
		if (!result) {
			result = defaultObj;
		}
		return result;
	}

	setItemObj(key: string, itemObj: any, prefix: string = null) {
		this.setItem(key, JSON.stringify(itemObj), prefix);
	}
}