/**
 * Created by rockyl on 2018/11/5.
 *
 * 游戏入口
 */

import {
	setup,
	launchScene, modifyEngineConfig,
	loadJson,
	setResPath,
	utils,
} from 'scilla'

import './generated/MustCompile'
//import lang from "lang";
import launchOptions, {inject} from "launchOptions";

modifyEngineConfig({
	lineHeightRatio: 1.2,
	entityEnabled: false,
	awakeComponentWhenAdded: false,
	sleepComponentWhenRemoved: false,
	drawRenderRect: false,
});

export async function startup(containerElement, options, onProgress) {
	const manifest = await loadJson('manifest.json');

	inject(manifest);
	inject(options);

	setResPath(DEBUG ? 'assets/' : launchOptions.resPath);

	let canvas = document.createElement('canvas');
	containerElement.appendChild(canvas);

	let config = {
		canvas,
	};
	if (options.config) {
		utils.injectProp(config, options.config);
	}
	setup(config);

	launchScene('main', onProgress).catch(e => {
		console.log(e);
	});
}
