/**
 * Created by rockyl on 2018/11/6.
 */

import GraphicRenderer from "./GraphicRenderer";

/**
 * 线段渲染组件
 */
export default class LineRenderer extends GraphicRenderer {
	x0: number = 0;
	y0: number = 0;
	x1: number = 0;
	y1: number = 0;

	/**
	 * @inheritDoc
	 */
	draw() {
		super.draw();

		const {context, x0, y0, x1, y1} = this;

		context.moveTo(x0, y0);
		context.lineTo(x1, y1);
	}

	/**
	 * @inheritDoc
	 */
	measureBounds() {
		const {bounds} = this;
		bounds.width = 0;
		bounds.height = 0;

		super.measureBounds();
	}
}
