/**
 * Created by rockyl on 2018/11/6.
 */

import GraphicRenderer from "./GraphicRenderer";
import {decorators} from "scilla";

const {dirtyFieldDetector} = decorators;

/**
 * 圆形渲染组件
 */
export default class CircleRenderer extends GraphicRenderer {
	/**
	 * 半径
	 */
	@dirtyFieldDetector
	radius = 50;

	/**
	 * 开始角度
	 */
	@dirtyFieldDetector
	startAngle: number = 0;

	/**
	 * 结束角度
	 */
	@dirtyFieldDetector
	endAngle: number = 360;

	/**
	 * 是否回归到圆心
	 */
	@dirtyFieldDetector
	backToCenter: boolean = true;

	protected getRenderSize(): any {
		const {radius} = this;
		return {width: radius * 2, height: radius * 2};
	}

	/**
	 * @inheritDoc
	 */
	protected draw() {
		const {context, bounds: {width, height}, startAngle, endAngle, backToCenter, _margin, _useCacheMode} = this;
		let offset = _useCacheMode ? _margin : 0;

		const radius = Math.min(width, height) / 2;
		const pos = offset + radius;

		if(startAngle == 0 && endAngle == 360){
			context.arc(pos, pos, radius, 0, 2 * Math.PI);
		}else{
			if(backToCenter){
				context.moveTo(pos, pos);
			}
			context.arc(pos, pos, radius, startAngle * Math.PI / 180, endAngle * Math.PI / 180);
			if(backToCenter){
				context.lineTo(pos, pos);
			}
		}

		super.draw();
	}
}
