/**
 * Created by rockyl on 2019-01-04.
 *
 * 弹动缩放
 */

import {ScillaComponent, createTween, Tween, Vector2D, createVector2D} from "scilla";

const originScale: Vector2D = createVector2D(1, 1);

export default class BounceZoom extends ScillaComponent {
	targetScale: Vector2D = createVector2D(1.5, 1.5);
	duration:number = 100;

	private _tween: Tween;

	onAwake() {
		super.onAwake();

		this._tween = createTween(this.transform, false,
			{clazz: Vector2D, fields: ['x', 'y'], autoPlay: false}
			)
			.to({scale: this.targetScale.clone()}, this.duration * 0.5)
			.to({scale: originScale.clone()}, this.duration * 0.5)
	}

	play(){
		this._tween.play(true);
	}
}
