/**
 * Created by rockyl on 2019-01-04.
 *
 * 渐变组件
 */

import {math, ScillaComponent} from "scilla";

export default class Fade extends ScillaComponent {
	fromAlpha: number = 0;
	toAlpha: number = 1;
	duration: number = 1000;

	private _startTime: number;
	private _playing: boolean;

	onUpdate(t) {
		super.onUpdate(t);

		if(this._playing){
			if(!this._startTime){
				this._startTime = t;
			}

			let ratio = (t - this._startTime) / this.duration;

			this.transform.alpha = math.lerp(this.fromAlpha, this.toAlpha, ratio);

			if(ratio >= 1){
				this.stop();
			}
		}
	}

	play(){
		this._startTime = 0;
		this._playing = true;
	}

	stop(){
		this._playing = false;
	}
}
