/**
 * 防连点
 * @param fn 点击处理方法
 * @param wait 等待时间，单位毫秒，默认2000
 */
export const debounce = (fn, wait=2000, immediate = true) => {
    let timer;
    return function () {
        if (timer) clearTimeout(timer)
        if (immediate) {
            // 如果已经执行过，不再执行
            var callNow = !timer
            timer = setTimeout(() => {
                timer = null
            }, wait)
            if (callNow) {
                fn()
            }
        } else {
            timer = setTimeout(() => {
                fn()
            }, wait)
        }
    }
}