const  SVGA = require("svgaplayerweb");

var svgaParser = new SVGA.Parser();

/**
 * 快速加载svga资源，但不装载
 * @param url 资源URL
 */
export const loadSVGA = (url) => {
    return new Promise((resolve, reject) => {
        svgaParser.load(url, (videoItem) => {
            resolve(videoItem)
        }, (err) => {
            reject(err)
        })
    })
}
/**
 * 快速装载一个svga动画
 * @param url 资源URL
 * @param className 挂载元素的class name
 * @param loops 播放次数。默认为空，循环播放。
 * @param clearsAfterStop 
 */
export const getSVGA = async (url, className, loops, clearsAfterStop) => {
    const videoItem = await loadSVGA(url);
    var svga = new SVGA.Player(className);
    if (loops)
        svga.loops = loops;
    if (clearsAfterStop)
        svga.clearsAfterStop = clearsAfterStop;
    svga.setVideoItem(videoItem);
    svga.startAnimation();
    return svga
}