'use strict';

import React, { Component } from 'react';
import resList from '../../resconfig/resList'; //import API from '../../api';
import API from '../../api';
import './main3.less';
import { CanvasWidget } from 'spark-utils';
import { Guideact } from '@spark/guideact';//'./bundle';//
import { getStepData, widgetConfig } from './widgetConfig';
import { GDispatcher } from "spark-wrapper-fyge"
import dataCenter, { Store } from '../../dataCenter';
import { getSVGA } from '../../svga';
import { Toast } from '@spark/ui';
import ViewCtrl from "../../util/viewCtrl";
import Enum from '../../util/enum';

let _widget;

function getActivityInfo(actId) {
  console.log('getActivityInfo')
  if (ICBCUtilTools.isAndroid()) {      // 如果是安卓
    window.Myutils.getActivityInfo(actId);
    return;
  }
  if (ICBCUtilTools.isiPhone()) {
    window.WebViewJavascriptBridge.callHandler("Myutils.getActivityInfo", actId)
  }
}

class Main3 extends Component {
  constructor(props) {
    super(props);
    this.state = {
      resList: resList,
      nickName: '',
      joyBeans: "0",
      figureId: -1,
      needguide: false,
      rolepop: false,
      whitePersonFlag: false
    };
  }

  onclick_main3_role = () => {
    this.setState({ rolepop: true })
    setTimeout(() => {
      this.setState({ rolepop: false })
    }, 3000);

  }

  gotoURL = (type) => {
    console.log("==========跳转======")
   
    if (type === 'renwudating') {
      //Toast('暂未开放，敬请期待')
      // TODO 活动结束后不可点击
      if(this.checkActivityEnd()) return;
      ViewCtrl.showWin(Enum.Com.Task);
      return;
    }
    if (type === 'ganji') {
      // getActivityInfo('HD0460200216484')
      // 更换链接
      // getActivityInfo('HD046012GoVX3K3Crj')
      // location.href="weixin://dl/business/?t=a2cQGEsrkda"
      // getActivityInfo('HD046012Jbdn6NidNP')
      // TODO 活动结束后不可点击
      if(this.checkActivityEnd()) return;
      getActivityInfo('HD046012JWN7ocK5tb')
      return;
    }
    if( type === "wodeejia"){
      if(this.checkActivityEnd()) return;
    }
    const urlmap = {
      xiaomaibu: 'https://gonghang.activity-1.m.duiba.com.cn/projectx/pa14d7c75/index.html?appID=66480',
      equnongchang: 'https://gonghang.activity-1.m.duiba.com.cn/projectx/pb3bde510/index.html?appID=66480',
      // equnongchang:'https://gonghang.activity-1.m.duiba.com.cn/projectx/p6e9a59d7/index.html?appID=66480',
      // equnongchang: 'https://gonghang.activity-1.m.duiba.com.cn/projectx/p6e9a59d7/index.html?appID=66480',
      wodeejia: 'https://gonghang.activity-1.m.duiba.com.cn/projectx/pb3bde510/index.html?appID=66480&gohome=true',
    }
    console.log('goto', urlmap[type])
    location.href = urlmap[type]
  }

  onClick_userinfo = () => {
    ViewCtrl.showWin(Enum.Com.Userinfo, { figureId: this.state.figureId });
  }

  onClick_signBtn = () => {
    // TODO 校验活动结束
    if(this.checkActivityEnd()) return;
    API.signInfo().then((res) => {
      ViewCtrl.showWin(Enum.Com.Sign, res.data);
    })
  }

  onClick_shareBtn = () => {
    console.log('onClick_shareBtn')
    // TODO 校验活动结束
    if(this.checkActivityEnd()) return;
    window.icbcshare();
    API.doshare().then(res => {
      console.log('doshare', res)
    })
  }

  onClick_rulebtn = () => {
    // console.log('onClick_rulebtn')

    ViewCtrl.showWin(Enum.Com.Rule);
  }


  onclick_jingcai = () => {
    console.log('onclick_jingcai')
    location.href = "https://gonghang.activity-1.m.duiba.com.cn/projectx/p4f90ce5d/index.html?appID=66480"
  }

  componentDidMount() {
    this.freshHomeInfo();
    this.initEvent();


    getSVGA('//yun.duiba.com.cn/spark/assets/37b62d421a7d224b291960c898bdc9fd1824f561.svga', '.main3_role')
    getSVGA('//yun.duiba.com.cn/spark/assets/8928d4a90feb4614b76753de25ad3694f85c11d6.svga', '.main3_btn_jingcai2')
    getSVGA('//yun.duiba.com.cn/spark/assets/327e6a094060ad20d67bfccc16ffe42f20adc1d1.svga', '.main3_cursor ')

    if (this.props.data && !this.props.data.isnewUser) { //不是新用户
      API.signInfo().then((res) => {
        const { needPopup } = res.data;
        console.log("res.data:----------->", res.data);
        // const needPopup = res && res.data && res.data.needPopup;
        if (needPopup) {
          ViewCtrl.showWin(Enum.Com.Sign, res.data);
        }
      });
    }
    ViewCtrl.showWin(Enum.Com.Tips);

  }

  initEvent() {
    GDispatcher.addEventListener(Store.homeinfo, this.freshHomeInfo, this);
    GDispatcher.addEventListener(Store.needguide, this.changeGuideShow, this);
  }
  removeEvent() {

  }

  checkActivityEnd = () => {
    let now = new Date().getTime();
    console.log(now, CFG.endTime)
    console.log("======点击了======",now > CFG.endTime)
    if(now > CFG.endTime){
      return true;
    }else{
      return false;
    }
  }
  //首页信息显示更新
  freshHomeInfo() {
    let homeinfo = dataCenter.getData(Store.homeinfo);
    if (!homeinfo) return;
    console.log('freshHomeInfo', homeinfo.userInfo);
    this.setState({
      whitePersonFlag: homeinfo.whiteUser
    })
    if (homeinfo.userInfo)
      this.setState({
        nickName: homeinfo.userInfo.nickName,
        joyBeans: homeinfo.userInfo.joyBeans,
        figureId: homeinfo.userInfo.figureId,
      })
  }
  changeGuideShow() {
    let needguide = dataCenter.getData(Store.needguide);
    this.setState({
      needguide: needguide
    });
  }
  //引导数据
  guideconfig = {};
  onReady(widget) {
    _widget = widget;


  }
  //新手引导的位置设定
  setGuideConfig() {
    this.guideconfig = getStepData();
    _widget && _widget.dispatchInEvent("setStepConfig", this.guideconfig);
    this.startGuide();
  }
  startGuide() {
    _widget && _widget.dispatchInEvent("startGuide");
  }
  onEvent(type, payload) {
    console.log(type, payload);
    switch (type) {
      case "canvasready":
        this.setGuideConfig();
        break;

      case "guidecomplete":
        dataCenter.setData(Store.needguide, false);
        API.signInfo().then((res) => {
          const { needPopup } = res.data;
          if (needPopup) {
            ViewCtrl.showWin(Enum.Com.Sign, res.data);
          }
        })
        break;

      case "nowstep":
        //当前所处引导步骤
        let nowstepdata = this.guideconfig[payload];
        if (nowstepdata) {
          let nowpagey = nowstepdata.pagey;
          this.refs.main3.scrollTop = nowpagey * window.remScale;
        }
        break;

      default:
        break;

    }
  }
  onAssetsProcess(loaded, total) {
    console.log(`assets load process:${loaded}/${total}`)
  }

  onAssetsComplete() {
    console.log(`assets load complete`)
  }


  // 白名单用户点击
  whitePerson = async () => {
    let { whitePersonFlag } = this.state
    let u = navigator.userAgent
    let android = u.indexOf('Android') > -1 || u.indexOf('Linux') > -1;
    let iPhone = u.indexOf('iPhone') > -1 || u.indexOf('Mac') > -1;
    let weixin = u.toLowerCase().indexOf('micromessenger') > -1;
    if (whitePersonFlag) {
      // 白名单，可点击
      if (weixin) {
        // 微信环境
        window.location.href = 'https://elife.icbc.com.cn/ELIFENEWBASEH5/dist/#/TransferMinPro?actId=HD046012HXxWUvDEV5'
      } else {
        // app环境
        window.location.href = 'weixin://dl/business/?t=wXDaa7bcNWm';
      }
    }
  }

  render() {
    const { rolepop, figureId, nickName, joyBeans, needguide, whitePersonFlag } = this.state;
    return (
      <div className="main3" uuid="8754a9d1-7453-474b-b722-7cb71483ae85" ref="main3" >
        <img
          className="main3_bg "
          // src='http://yun.duiba.com.cn/spark/assets/f814904585bbeb176da6121c1dcd253196017b1b.jpg'
          // src="//yun.duiba.com.cn/spark/assets/1e8e7c7a761f6d4d84b157129333ab8f79262d25.png"
          src="//yun.duiba.com.cn/spark/assets/93fece351d90ee288ce6f5618a6ae2f8392cb8c3.png"
        // uuid="25a6c3f8-3f78-4758-b2ab-5bcbfaa0d8bc"
        // src="//yun.duiba.com.cn/spark/assets/3dff859e5097ca38eebf736863ea0344dfc1ac76.png"
        />
        <div className="main3_top " uuid="257105ac-5616-4e29-a4dc-302ed2604193">
          <div
            onClick={this.onClick_userinfo} className="main3_userinfo " uuid="25d45126-3476-4d8e-9756-34e2ccf96163">
            <img
              className="main3_userinfo_bg "
              uuid="5316b02a-5b8e-4355-b556-cd801852df7e"
              src={this.state.resList['31522099-3ea6-4d2b-ae84-99e2877bd2d0'].url}
            />
            {figureId == 1 && (
              <img
                className="main3_avatar1 "
                uuid="f2277018-36fd-4f47-9124-d73324505dff"
                src={this.state.resList['6dda365e-565e-4e15-9fc9-89b5e173dcd9'].url}
              />
            )}
            {figureId == 2 && (
              <img
                className="main3_avatar2 "
                uuid="07d1620b-d31e-4ef7-a63a-9b0ef49497da"
                src={this.state.resList['6ff31046-e036-4218-8cc9-5d715dfa64a1'].url}
              />
            )}
            {figureId == 3 && (
              <img
                className="main3_avatar3 "
                uuid="dc2306b9-90e0-4e98-a967-e0f263a3217a"
                src={this.state.resList['b4aa3a56-6a4f-4984-9aa2-1932c35de3b4'].url}
              />
            )}
            <span className="main3_num " uuid="018875e0-9592-4854-ba0b-2cd58464a6a2">
              欢趣豆:{joyBeans}
            </span>
            <span className="main3_nick " uuid="a7518930-17cc-427a-a6e5-27a593b309c4">
              {nickName}
            </span>
            <img
              onClick={(e) => {
                e.stopPropagation();
                this.props.navigateTo('detail');
              }}
              className="main3_btn_detail md10"
              uuid="2021e306-1521-4373-a890-5a4feb45c7cb"
              src={this.state.resList['25098e28-9948-4954-9bf3-c884fdcd230a'].url}
            />
          </div>
          <img
            onClick={this.onClick_signBtn}
            className="main3_sign md3"
            uuid="fdb364dd-23db-46fe-8ab4-df733ce0596b"
            src={this.state.resList['e4ba9074-781a-4dc1-a696-34753b57f924'].url}
          />
          <img
            onClick={this.onClick_rulebtn}
            className="main3_rule md1"
            uuid="46338849-e102-41a8-9298-43639f634bcf"
            src={this.state.resList['98666530-5e40-49d7-8b86-8397e3ee0889'].url}
          />
          <img
            onClick={this.onClick_shareBtn}
            className="main3_share md2"
            uuid="def4d721-bfe0-4c42-970c-40d99e1c2944"
            src={this.state.resList['82a28387-28f0-4e49-856a-dbe5e981bbb1'].url}
          />
          <div className="main3_btn_jingcai2 " />
          <img
            onClick={this.onclick_jingcai}
            className="main3_btn_jingcai md4"
            uuid="de6b0150-9221-439d-adf7-ec3e3ad5466e"
            src={this.state.resList['8d1cc843-b298-42e1-a092-954edfcf93e2'].url}
          />

        </div>
        <img
          onClick={() => this.gotoURL('wodeejia')}
          className="main3_btn5 md9"
          uuid="72de3087-a678-4c8e-90f0-98174bb08c70"
          src={this.state.resList['bd2d0b8b-f567-4146-be92-dc1704f06b4a'].url}
        />
        <img
          onClick={() => this.gotoURL('xiaomaibu')}
          className="main3_btn4 md8"
          uuid="031a922c-6690-49a4-9659-2055ef8c174f"
          src={this.state.resList['197b83b3-3d8a-47ed-bede-dd07bf533edc'].url}
        />
        <img
          onClick={() => this.gotoURL('renwudating')}
          className="main3_btn3 md7"
          uuid="06d08e49-d168-4d83-93cb-422e8053ffa1"
          src={this.state.resList['febc6038-d4f1-48ad-a855-b45656bdc9f9'].url}
        />
        <img
          onClick={() => this.gotoURL('equnongchang')}
          className="main3_btn2 md6"
          uuid="7bd21565-f46e-4c72-ad2c-d978d90ff4b3"
          src={this.state.resList['b1c1b1ea-7d5e-40b5-b95f-e66ed468ac18'].url}
        />
        <img
          onClick={() => this.gotoURL('ganji')}
          className="main3_btn1 md5"
          uuid="732aaae8-c0d9-4477-9ebf-2a47171d60e8"
          src={this.state.resList['732aaae8-c0d9-4477-9ebf-2a47171d60e8'].url}
        />
        <div
          className="main3_cursor "

        />
        <div className="main3_role " onClick={this.onclick_main3_role} />
        {
          whitePersonFlag
            ?
            <img
              className="main3_rolepop "
              uuid="c27fef65-4506-42f8-85df-207999e11de1"
              // onClick={() => this.whitePerson()}
              // src="//yun.duiba.com.cn/spark/assets/77234d6cb9376e89e6aea4d13009b3f859f36197.png"
              // src="//yun.duiba.com.cn/spark/assets/ba78770db08f0ad4d7bb73ee59526e7751589946.png"
              src="//yun.duiba.com.cn/spark/assets/645c2c36ccbfaed53c9ff76b0c0505138423553f.png"
            />
            :
            (rolepop &&
              <img
                className="main3_rolepop "
                uuid="c27fef65-4506-42f8-85df-207999e11de1"
                src="//yun.duiba.com.cn/spark/assets/77234d6cb9376e89e6aea4d13009b3f859f36197.png"
              />)
        }

        {needguide ? <CanvasWidget className="diacontmidpos canvasLayer" widgetFactory={Guideact} widgetConfig={widgetConfig}
          onEvent={this.onEvent.bind(this)}
          onReady={this.onReady.bind(this)} onAssetsProcess={this.onAssetsProcess.bind(this)}
          onAssetsComplete={this.onAssetsComplete.bind(this)} /> : ""}

      </div>
    );
  }
}

export default Main3;
