import { Shape, Container, TextField, TEXT_ALIGN, TEXT_lINETYPE, Sprite, MouseEvent, TextureCache, WidgetBase, Tween, MovieClip } from 'spark-wrapper-fyge';
import metaConfig from './meta.json';

/*! *****************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
/* global Reflect, Promise */

var extendStatics = function(d, b) {
    extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
    return extendStatics(d, b);
};

function __extends(d, b) {
    extendStatics(d, b);
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}

function __awaiter(thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
}

function __generator(thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
}

var GameStage = /** @class */ (function (_super) {
    __extends(GameStage, _super);
    function GameStage() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._step = 1;
        _this.canclick = true;
        _this.guideconfig = {};
        _this.anirolesvga = "https://yun.duiba.com.cn/spark/assets/14b5846d42f0e6a48f0e463500ce04720cee70d9.svga";
        _this.shousvga = "https://yun.duiba.com.cn/spark/assets/327e6a094060ad20d67bfccc16ffe42f20adc1d1.svga";
        _this.anifinarolesvga = "https://yun.duiba.com.cn/spark/assets/cc46b3281cad2db353c6d63a4a49ae4f929dfe5b.svga";
        return _this;
    }
    Object.defineProperty(GameStage.prototype, "step", {
        get: function () {
            return this._step;
        },
        set: function (val) {
            if (this._step != val) {
                this._step = val;
                this.dispatchOutEvent("nowstep", val);
            }
        },
        enumerable: false,
        configurable: true
    });
    GameStage.prototype.onLaunched = function () {
        this.stagew = this.stage.viewRect.width;
        this.stageh = this.stage.viewRect.height;
        this.guideRect = new Shape();
        this.addChild(this.guideRect);
        this.rolecont = new Container();
        this.addChild(this.rolecont);
        this.messagetxt = new TextField();
        this.messagetxt.size = 32;
        this.messagetxt.textAlign = TEXT_ALIGN.LEFT;
        this.messagetxt.lineSpacing = 10;
        this.messagetxt.lineType = TEXT_lINETYPE.MULTI;
        this.addChild(this.messagetxt);
        this.nextbtn = new Sprite();
        this.addChild(this.nextbtn);
        this.touchrect = new Shape();
        this.addChild(this.touchrect);
        this.skipbtn = new Sprite();
        this.addChild(this.skipbtn);
        this.guideconfig = this.props['guideconfig'];
        this.skipbtn.addEventListener(MouseEvent.CLICK, this.skipGuide, this);
        this.touchrect.addEventListener(MouseEvent.CLICK, this.toNextLevel, this);
        this.getAnirole();
        this.getShou();
        this.getFinarole();
        this.dispatchOutEvent("canvasready", null);
    };
    /**
     * 事件回调
     * @param type
     * @param payload
     */
    GameStage.prototype.onEvent = function (type, payload) {
        console.error("游戏内监听===》", type, payload);
        switch (type) {
            case "setStepData":
                this.setStepData(payload);
                break;
            case "setStepConfig":
                this.setStepConfig(payload);
                break;
            case "startGuide":
                this.step = 1;
                this.setGuideShow();
                break;
            default:
                console.error("为定义监听类型===》", payload);
                break;
        }
    };
    //设定单个关卡
    GameStage.prototype.setStepData = function (payload) {
        var step = payload.step;
        var stepdata = payload.stepdata;
        this.guideconfig[step] = stepdata;
    };
    //一次设定所有的引导数据
    GameStage.prototype.setStepConfig = function (payload) {
        this.guideconfig = payload;
    };
    /**
     * 销毁回调
     */
    GameStage.prototype.onDestroy = function () {
    };
    //skipLevel
    GameStage.prototype.skipGuide = function () {
        var _this = this;
        if (!this.canclick) {
            return;
        }
        this.canclick = false;
        setTimeout(function () {
            _this.canclick = true;
        }, 200);
        var stepdata = this.guideconfig[this.step];
        var skipbtn = stepdata.skipbtn;
        var lastlevel;
        if (skipbtn) {
            lastlevel = skipbtn.skiplevel;
        }
        this.step = lastlevel;
        this.setGuideShow();
    };
    //toNextLevel
    GameStage.prototype.toNextLevel = function () {
        var _this = this;
        if (!this.canclick) {
            return;
        }
        this.canclick = false;
        setTimeout(function () {
            _this.canclick = true;
        }, 1000);
        this.step++;
        this.setGuideShow();
    };
    //步数渲染
    GameStage.prototype.setGuideShow = function () {
        return __awaiter(this, void 0, void 0, function () {
            var stepdata, hole, txt, role, nextbtn, skipbtn, touch, holetype, holex, holey, holesize, cirectwid, cirecthei, cirectrad, dot1, dot2, dot3, dot4, dot5, dot6, dot7, dot8, text, txtwidth, txtx, txty, txtalign, _a, rolex, roley, _b, goldprize, firstcont, svga, btnx, btny, btntex, skipx, skipy, skiptex, touchx, touchy, touchsize;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        stepdata = this.guideconfig[this.step];
                        if (!stepdata) {
                            console.error("引导完毕====》");
                            this.dispatchOutEvent("guidecomplete", null);
                            return [2 /*return*/];
                        }
                        hole = stepdata.hole, txt = stepdata.txt, role = stepdata.role, nextbtn = stepdata.nextbtn, skipbtn = stepdata.skipbtn, touch = stepdata.touch;
                        this.guideRect.clear();
                        this.guideRect.beginFill(0x000000, 0.7);
                        this.guideRect.drawRect(0, 0, this.stagew, this.stageh);
                        if (hole) {
                            holetype = hole.holetype, holex = hole.holex, holey = hole.holey, holesize = hole.holesize;
                            switch (holetype) {
                                case "cir":
                                    this.guideRect.arc(holex, holey, holesize[0], 0, Math.PI * 2, true);
                                    break;
                                case "cirect":
                                    console.log("画圆角洞====》");
                                    cirectwid = holesize[0];
                                    cirecthei = holesize[1];
                                    cirectrad = holesize[2];
                                    dot1 = [holex + cirectrad, holey];
                                    dot2 = [holex, holey + cirectrad];
                                    dot3 = [holex, holey + cirecthei - cirectrad];
                                    dot4 = [holex + cirectrad, holey + cirecthei];
                                    dot5 = [holex + cirectwid - cirectrad, holey + cirecthei];
                                    dot6 = [holex + cirectwid, holey + cirecthei - cirectrad];
                                    dot7 = [holex + cirectwid, holey + cirectrad];
                                    dot8 = [holex + cirectwid - cirectrad, holey];
                                    this.guideRect.moveTo(dot1[0], dot1[1]);
                                    this.guideRect.quadraticCurveTo(holex, holey, dot2[0], dot2[1]);
                                    this.guideRect.lineTo(dot3[0], dot3[1]);
                                    this.guideRect.quadraticCurveTo(holex, holey + cirecthei, dot4[0], dot4[1]);
                                    this.guideRect.lineTo(dot5[0], dot5[1]);
                                    this.guideRect.quadraticCurveTo(holex + cirectwid, holey + cirecthei, dot6[0], dot6[1]);
                                    this.guideRect.lineTo(dot7[0], dot7[1]);
                                    this.guideRect.quadraticCurveTo(holex + cirectwid, holey, dot8[0], dot8[1]);
                                    this.guideRect.lineTo(dot1[0], dot1[1]);
                                    break;
                                case "rect":
                                    break;
                                case "nohole":
                                    break;
                                default:
                                    console.error("为定义类型");
                                    break;
                            }
                        }
                        this.guideRect.endFill();
                        if (txt) {
                            text = txt.text, txtwidth = txt.txtwidth, txtx = txt.txtx, txty = txt.txty, txtalign = txt.txtalign;
                            this.messagetxt.text = text;
                            this.messagetxt.x = txtx;
                            this.messagetxt.y = txty;
                            this.messagetxt.textWidth = txtwidth;
                            this.messagetxt.visible = true;
                            this.messagetxt.textAlign = txtalign || TEXT_ALIGN.LEFT;
                        }
                        else {
                            this.messagetxt.visible = false;
                        }
                        _a = role[0], rolex = _a.rolex, roley = _a.roley;
                        if (!(this.step != 9)) return [3 /*break*/, 4];
                        if (this.firstTcont && this.firstTcont.parent) {
                            this.rolecont.removeChild(this.firstTcont);
                        }
                        if (!(this.anirole && this.anirole.parent)) return [3 /*break*/, 1];
                        this.anirole.x = rolex;
                        this.anirole.y = roley;
                        return [3 /*break*/, 3];
                    case 1:
                        console.error("新增svga动画===》");
                        _b = this;
                        return [4 /*yield*/, this.getAnirole()];
                    case 2:
                        _b.anirole = _c.sent();
                        if (this.anirole) {
                            this.anirole.x = rolex;
                            this.anirole.y = roley;
                            this.rolecont.addChild(this.anirole);
                        }
                        _c.label = 3;
                    case 3:
                        if (this.step == 1) {
                            goldprize = stepdata.goldprize;
                            firstcont = this.getFirstTcont(goldprize);
                            this.rolecont.addChild(firstcont);
                            console.log("添加firstCont===>", firstcont);
                            firstcont.x = rolex - 300;
                            firstcont.y = roley - 380;
                            firstcont.scaleX = 0;
                            firstcont.scaleY = 0;
                            Tween.get(firstcont, { loop: false })
                                .to({
                                scaleX: 1,
                                scaleY: 1,
                            }, 200);
                            console.log("firstcont添加完毕");
                        }
                        return [3 /*break*/, 6];
                    case 4:
                        if (!(this.step == 9)) return [3 /*break*/, 6];
                        this.rolecont.removeChildren();
                        return [4 /*yield*/, this.getFinarole()];
                    case 5:
                        svga = _c.sent();
                        if (svga) {
                            svga.x = rolex;
                            svga.y = roley;
                            this.rolecont.addChild(svga);
                        }
                        _c.label = 6;
                    case 6:
                        if (nextbtn) {
                            btnx = nextbtn.btnx, btny = nextbtn.btny, btntex = nextbtn.btntex;
                            this.nextbtn.texture = TextureCache[btntex];
                            this.nextbtn.x = btnx;
                            this.nextbtn.y = btny;
                            this.nextbtn.visible = true;
                        }
                        else {
                            this.nextbtn.visible = false;
                        }
                        if (skipbtn) {
                            skipx = skipbtn.skipx, skipy = skipbtn.skipy, skiptex = skipbtn.skiptex;
                            this.skipbtn.texture = TextureCache[skiptex];
                            this.skipbtn.x = skipx;
                            this.skipbtn.y = skipy;
                            this.skipbtn.visible = true;
                            console.log("skipbtn====》", skipbtn);
                        }
                        else {
                            this.skipbtn.visible = false;
                        }
                        if (touch) {
                            touchx = touch.touchx, touchy = touch.touchy, touchsize = touch.touchsize;
                            this.touchrect.clear();
                            this.touchrect.beginFill(0x000000, 0.01);
                            this.touchrect.drawRect(touchx, touchy, touchsize[0], touchsize[1]);
                            this.touchrect.endFill();
                        }
                        else {
                            console.error("没有点击区域====》");
                        }
                        return [2 /*return*/];
                }
            });
        });
    };
    GameStage.prototype.getFirstTcont = function (goldprize) {
        this.firstTcont = new Container();
        this.firstTcont.addChild(new Sprite(TextureCache["guide1"]));
        this.firstTcont.width = 633;
        this.firstTcont.height = 410;
        this.firstTxt = new TextField();
        this.firstTxt.fillColor = "#e9381b";
        this.firstTxt.size = 30;
        this.firstTxt.x = 266;
        this.firstTxt.y = 186;
        if (!goldprize) {
            goldprize = 0;
        }
        this.firstTxt.text = goldprize + "欢趣豆";
        this.firstTcont.addChild(this.firstTxt);
        this.firstTcont.anchorX = 390;
        this.firstTcont.anchorY = 410;
        return this.firstTcont;
    };
    GameStage.prototype.getAnirole = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (this.anirole) {
                            return [2 /*return*/, this.anirole];
                        }
                        return [4 /*yield*/, this.loadSvga(this.anirolesvga, this.anirole)];
                    case 1: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    GameStage.prototype.getShou = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (this.shou) {
                            return [2 /*return*/, this.shou];
                        }
                        return [4 /*yield*/, this.loadSvga(this.shousvga, this.shou)];
                    case 1: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    GameStage.prototype.getFinarole = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (this.anifinarole) {
                            return [2 /*return*/, this.anifinarole];
                        }
                        return [4 /*yield*/, this.loadSvga(this.anifinarolesvga, this.anifinarole)];
                    case 1: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    GameStage.prototype.loadSvga = function (src, target) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, new Promise(function (res) {
                        window["SvgaParser"].loadSvga(src, function (_v) {
                            target = new MovieClip(_v);
                            res(target);
                        }, function (e) {
                            res(null);
                        });
                    })];
            });
        });
    };
    return GameStage;
}(WidgetBase));

/**
 * Created by rockyl on 2020/9/19.
 */
/**
 * @type CANVAS_WIDGET
 * @name 测试模块
 * @desc 测试模块的工厂方法
 */
function Guideact() {
    return new GameStage(getMetaConfig('Guideact'));
}
function getMetaConfig(id){
	return metaConfig[id]
}
//===== END APPEND CODE =====

export { Guideact };
