'use strict';

import { appID } from 'duiba-utils';
import React, { Component } from 'react'; 

import resList from '../../resconfig/resList'; //import API from '../../api';

import API from '../../api';
import './loading.less';
import dataCenter, { getAPIdata, getHomeInfo, Store } from '../../dataCenter';
import ViewCtrl from "../../util/viewCtrl";
import Enum from '../../util/enum';

class Loading extends Component {
  constructor(props) {
    super(props);
    this.state = {
      resList: resList,
    };
  }

  jianum = 90;
  time1 = 1;
  loadnum1 = 0;
  loadnum2 = 0;
  nshowload = 0; //load有无完毕

  close = false;

  componentDidMount() {
    this.time1 = setInterval(this.updateLoad.bind(this), 30);
    this.getHomeData();
    this.getRule();
  }

  async getHomeData() {
    await getHomeInfo();
    this.addLoadPro('homeinfo');
  }

  async getRule() {
    let ruledata = await getAPIdata(Store.ruledata);

    if (ruledata && ruledata.success && ruledata.data) {
      dataCenter.setData(Store.ruledata, ruledata.data);
    }

    this.addLoadPro('ruledata');
  }

  needLoad = ['homeinfo', 'ruledata'];
  needLoadnum = 2;

  addLoadPro(type) {
    let idx = this.needLoad.indexOf(type);

    if (idx != -1) {
      this.needLoad.splice(idx, 1);
      this.loadnum2 += (100 - this.jianum) / this.needLoadnum;
    }
  }

  updateLoad() {
    this.loadnum1 += 2;

    if (this.loadnum1 > this.jianum) {
      this.loadnum1 = this.jianum;
    }

    let tload = this.loadnum1 + this.loadnum2;

    if (this.nshowload <= tload) {
      this.nshowload += 2;
    }

    if (this.nshowload > 100) {
      this.nshowload = 100;
      clearInterval(this.time1);
    }

    this.changeLoadShow();
  }

  changeLoadShow() {
    let ratio = document.body.clientWidth / 750;
    let percent = this.nshowload / 100;

    if (percent >= 1) {
      percent = 1;

      if (!this.close) {
        this.close = true;
        setTimeout(() => {
          this.oncomplete();
        }, 100);
      }
    }

    let pro = (percent - 1) * 608 * ratio;
    this.refs.loadbar.style.WebkitMaskPosition = pro + 'px 0px';
  }

  oncomplete() {
    let isnewUser;
    let homeinfo = dataCenter.getData(Store.homeinfo);

    if (homeinfo) {
      const { newUser } = homeinfo;

      if (newUser) {
        //新用户，走选择，然后再走引导，引导结束后，走签到
        ViewCtrl.showWin(Enum.Com.Select);
        isnewUser = 1;
      }
    }

    this.props.navigateTo('mainpage', {
      isnewUser,
    });
  }

  render() {
    return (
      <div className="loading diacontmidpos" uuid="b325d068-5750-48c1-8447-29b6f572e955">
        <img
          className="loading_bg "
          uuid="caa1574c-edd4-4b5c-8332-18002df91464"
          src={this.state.resList['486d644d-196a-4d71-99fe-bbaf06ecacbf'].url}
        />
        <img
          className="loading_front "
          uuid="0fadc807-1e4c-45df-9cb8-db801c1a5426"
          src="//yun.duiba.com.cn/spark/assets/b0640cb00316b2e9b25ca0967151d766ba209ed6.png"
        />
        <img
          className="loading_progress "
          uuid="19f75998-1403-415a-a816-090af61cfc2e"
          src={this.state.resList['97cb2a19-7bb9-4b41-ad0d-2b0f757b97ad'].url}
          ref="loadbar"
        />
        <img
          className="loading_icon "
          uuid="fe96070d-8add-43d9-8575-a519d4981222"
          src={this.state.resList['c2df1a83-e9ea-4627-b376-1ac7f3e87b5c'].url}
        />
      </div>
    );
  }
}

export default Loading;
