'use strict';

import React, { Component } from 'react';
import resList from '../../resconfig/resList'; //import API from '../../api';

import './detail2.less';
import API from '../../api';
const pagesize = 20;
const ratio = 2;
const listWrapperHeight = document.body.clientHeight * ratio - 214;
let canLoading = true;
let currentPage = 1;
class Detail2 extends Component {
  constructor(props) {
    super(props);
    this.state = {
      resList: resList,
      list: []
    };
  }

  onScroll = () => {
    console.log('%c onScroll function run', 'color:blue;font-size:20px;font-weight:900;')
    if (!canLoading) {
      console.log('不能加载了')
      return;
    };
    const { list } = this.state;
    const targetScrollTop = list.length * 55 * ratio - listWrapperHeight;
    const currentScrollTop = this.refs.listref.scrollTop * ratio;
    if (currentScrollTop >= targetScrollTop - 300) {
      console.log('加载新数据');
      canLoading = false;
      this.loadPage();

    }
    console.log(currentScrollTop, targetScrollTop)
  }

  loadPage() {
    const { list } = this.state;
    currentPage++;
    API.pageList({
      pageNo: currentPage,
      pageSize: pagesize
    }).then((res) => {
      canLoading = true;
      const list2 = list.concat(res);
      this.setState({ list: list2 });

      if (res.length < pagesize) {
        canLoading = false;
        console.log('加载好了，但数据太短了不继续加载了')
      }
    })
  }

  componentDidMount() {
    currentPage=1;
    canLoading = true;
    API.pageList({
      pageNo: currentPage,
      pageSize: pagesize
    }).then((res) => {
      console.log('pagelist ', res)
      this.setState({ list: res })
      if (res.length < pagesize) {
        canLoading = false;
        console.log('数据太短了不能滚了')
      }
    })
  }

  render() {
    const { list } = this.state
    const list2 = list.map(i => {
      return {
        description: i.description,
        gmtCreate: i.gmtCreate,
        nums: i.bizType == 'ADD' ? `+${i.credits}` : `-${i.credits}`
      }
    })
    return (
      <div className="detail2 " uuid="c5abc304-1a0b-4804-956a-d61c1d5b75ed">

        <div className="detail2_wrapper" uuid="583667d9-e382-49d8-bfc9-50b6d800c794">
          <img
            className="detail2_bg"
            uuid="2b6c5d97-e458-42a0-b49b-49e9efc6abbc"
            src={this.state.resList['9d6135a5-469f-4293-b931-17786c977974'].url}
          />
          <img onClick={() => {currentPage=1;this.props.navigateTo('mainpage');}  } className="detail2_back" uuid="detail2_back" src="//yun.duiba.com.cn/spark/assets/805d9455ffa59e37f0f0f19249959c3a9c458f96.png"></img>
          <div ref="listref" onScroll={this.onScroll} className="detail2_item_list" uuid="3804f60d-697f-4d68-98b5-ca8cf2e2d3ba">
            {
              list2.map(({ description, gmtCreate, nums }, i) => (
                <div key={i} className="detail2_item " uuid="4d8289ea-9464-4a92-a81c-3e24c364e707">
                  <span className="detail2_item_title " uuid="48b63d65-a3d8-4b94-b979-3fcb19c9d89c">
                    {description}
                  </span>
                  <span className="detail2_item_day " uuid="5e6c50df-f25c-4b91-acc7-95d4829ff7db">
                    {gmtCreate}
                  </span>
                  <span className="detail2_item_num " uuid="e576e938-d57d-4101-82bc-c0b0782033c9">
                    {nums}
                  </span>
                  <img
                    className="detail2_item_bg "
                    uuid="46e8b6fd-f561-445c-85eb-be7136ea5183"
                    src={this.state.resList['eed0f2f8-74ef-4680-a29c-d5db6818738f'].url}
                  />
                </div>

              ))
            }
          </div>
        </div>
      </div>
    );
  }
}

export default Detail2;
