import { GDispatcher } from 'spark-wrapper-fyge';
import API from './api'
export const Store = {
    homeinfo: "homeinfo",
    ruledata: "ruledata",
    updateUinfo: "updateUinfo",
    doshare: "doshare",
    signInfo: "signInfo",
    dosign: "dosign",
    judgeAuthority: "judgeAuthority",


    //新手引导
    needguide: "needguide",
    newgoldnum: "newgoldnum",
}
//人物角色对应
export let Role = {
    1: {
        name: "熊猫1男",
        figureid: 1,
    },
    2: {
        name: "熊猫2女",
        figureid: 2,
    },
    3: {
        name: "熊猫3墨镜",
        figureid: 3,
    }
}
export const netErrMsg = "活动太火爆了，请稍后再试";
export async function getAPIdata(netname, reqdata = null) {
    let apidata;
    try {
        if (reqdata) {
            apidata = await API[netname](reqdata);
        } else {
            apidata = await API[netname]();
        }
    } catch (e) {
        console.log(e)
    }
    return apidata;
}
export async function getHomeInfo() {
    let homeinfo = await getAPIdata(Store.homeinfo);
    // homeinfo = {
    //     "code": null,
    //     "data": {
    //         "canUpdateNickName": null,
    //         "figures": [
    //             { "figureId": "1" }, { "figureId": "2" }, { "figureId": "3" }
    //         ],
    //         "newUser": true,
    //         "userInfo": null
    //     },
    //     "message": null,
    //     "success": true
    // }

    if (homeinfo && homeinfo.success && homeinfo.data) {
        dataCenter.setData(Store.homeinfo, homeinfo.data);
    }
}


const Datas = new Map();

const dataCenter = {
    setData: (key, value) => {
        Datas.set(key, value);
        if (key == Store.homeinfo || key == Store.needguide) {
            GDispatcher.dispatchEvent(key)
        }
    },

    getData: (key) => {
        return Datas.get(key)
    }
}

export default dataCenter
