'use strict';

import { Toast } from '@spark/ui';
import React, { Component } from 'react';
import API from '../../api';
import { getHomeInfo } from '../../dataCenter';
import resList from '../../resconfig/resList';
import { debounce } from '../../ui';
import './userinfo.less';
class Userinfo extends Component {
  constructor(props) {
    super(props);
    this.state = {
      resList: resList,
      figureId: props.data.figureId
    };
  }

  onKeyUp=(e)=>{
    // let planame = this.refs.planame.value;
    // if(planame.length > 6) {
    //   this.refs.planame.value = planame.slice(0,6)
    // }
  }

  onclick = async () => {
    let planame = this.refs.planame.value;
    if (planame.length < 1) {
      return Toast("昵称不能为空");
    }

    var regEn = /[`~!@#$%^&*()_+<>?:"{},.\/;'[\]]/im,
      regCn = /[·！#￥（——）：；“”‘、，|《。》？、【】[\]]/im;
    if (regEn.test(planame) || regCn.test(planame)) {
      Toast("昵称格式错误，只能使用6个字符以内的字母、数字、中文");
      return false;
    }

    API.updateUinfo({ type: 2, nickName: planame }).then(res => {
      console.log('res', res);
      if (res && res.success) {
        getHomeInfo();
        this.props.closeWin();
      } else {
        switch (res.code) {
          case '10004':
            Toast('存在敏感词，请重新检查昵称')
            break;
          case '10005':
            Toast('网络错误，发放欢趣豆失败')
            break;
          case '10011':
            Toast('今天不可修改昵称哦～请明天再试试')
            break;
          default:
            Toast(res.message || '网络异常，请稍后重试~')
        }
      }
    }).catch(e => {
      console.log('err', e);
    });

    // let updateuinfo = await getAPIdata(Store.updateUinfo, {
    //   type: 2,
    //   nickName: planame
    // });
    // if (updateuinfo && updateuinfo.success) {
    //   // if(updateuinfo.data){
    //   //   const {result,joyBeans} = updateuinfo.data;
    //   //   if(result){
    //   //     dataCenter.setData(Store.newgoldnum,joyBeans);
    //   //   }
    //   // }
    //   // getHomeInfo();
    //   // this.props.closeWin();
    //   // dataCenter.setData(Store.needguide,true);
    // } else {
    //   // if(updateuinfo){
    //   //   let msg = updateuinfo.message;
    //   //   Toast(msg);
    //   // }else{
    //   //   Toast(netErrMsg)
    //   // }
    // }

  }

  render() {
    const { figureId } = this.state;
    return (
      <div className="userinfo " uuid="a9143822-c421-48d3-92c3-de9eafe5c234">
        <input onKeyUp={this.onKeyUp} className="planame" type="text" placeholder="请输入昵称（不超过六字）" ref="planame" />
        <img
          className="userinfo_bg "
          uuid="cf852278-516f-48f3-bad2-0e38a1431c4e"
          src="//yun.duiba.com.cn/spark/assets/abade6773357b20b6d7e25acfa6266feabee0c09.png"
        />
        <img
          className="userinfo_avatar "
          uuid="1addc1b2-f339-4f8b-81c8-21153b03653a"
          src={this.state.resList['5406c697-b889-4062-8910-343038c4dc93'].url}
        />

        {figureId == 1 && <img className="userinfo_avatar " src="//yun.duiba.com.cn/spark/assets/393b5936219fa987a141cfcce17d2ffe13cc924e.png" />}
        {figureId == 2 && <img className="userinfo_avatar " src="//yun.duiba.com.cn/spark/assets/042c2b238932872aa066fd989f2169715789a3c3.png" />}
        {figureId == 3 && <img className="userinfo_avatar " src="//yun.duiba.com.cn/spark/assets/5a672d98433d289091b879a2d546970c281cb9d2.png" />}
        <img
          onClick={this.props.closeWin}
          className="userinfo_close "
          uuid="4f217b43-8438-451e-b28f-0e9d611fce2b"
          src={this.state.resList['c7826e1a-8b74-44da-922f-0fe078587999'].url}
        />
        <img
          onClick={debounce(this.onclick)}
          className="userinfo_btn "
          uuid="dbbad0c1-ead1-4515-ae55-144e26640415"
          src={this.state.resList['2208dc94-a012-4a45-8f4e-64468993e652'].url}
        />
      </div>
    );
  }
}

export default Userinfo;
