'use strict';

import React, { Component } from 'react';
import { Toast, Loading } from '@spark/ui';
import resList from '../../resconfig/resList';
import API from '../../api';
import './task.less';
class Task extends Component {
  constructor(props) {
    super(props);
    this.state = {
      resList: resList,
      flag: ''
    };
  }
  componentDidMount() {
    Loading.show();
    this.judgeAuthority();
  }


  judgeAuthority = async () => {
    let result = await API.judgeAuthority();
    if (result && result.success) {
      if (typeof result.data == 'string') {
        result.data = JSON.parse(result.data);
      }
      if (result.data.authority == 'yes') {
        this.setState({
          flag: false,
        })
      } else {
        this.setState({
          flag: true
        })
      }
    } else {

      Toast("网络错误，请刷新页面后重试");

    }
    Loading.hide();
  }

  getActivityInfo = (actId) => {
    console.log('getActivityInfo')
    if (ICBCUtilTools.isAndroid()) {      // 如果是安卓
      window.Myutils.getActivityInfo(actId);
      return;
    }
    if (ICBCUtilTools.isiPhone()) {
      window.WebViewJavascriptBridge.callHandler("Myutils.getActivityInfo", actId)
    }
  }

  toApplyCard = () => {
    window.location.href = "https://elife.icbc.com.cn/OFSTCARD/creditCard/apply.do?channel=105BKRK0001000000000000000&coreCode=HZDW000174463&paraPromoCode=EW0004600000000EL01";
  }

  toPurchase = () => {
    // window.location.href = "https://ghjf.g-town.com.cn/activity/wsd.html?type=wsd";
    this.getActivityInfo('HD046012MadrYFGPcb');
  }


  render() {
    return (
      <div className="ren_wu_da_ting_jie_mian ">
        <img className="bei_jing " src={this.state.resList['efe9d3d9-57ff-47a0-97ec-27847da411f9'].url} />
        <div className="pai_zi ">
          <img className="pai_zi_di_tu " src={this.state.resList['89624160-97ff-4924-9d9b-1078ba3d2e65'].url} />
          {this.state.flag && <img className="ban_li_wan_shi_da" src={this.state.resList['f2aea33a-42cd-4518-92e4-a79e80e8c487'].url} />}
          {!this.state.flag && <img className="di_shi_ni_men_piao" src={this.state.resList['da5960d0-0d03-4dd8-9673-465c261d3ef2'].url} />}
          <img className="xing_qiu_da_zuo_zhan " src={this.state.resList['654f2e6f-aea1-4555-979b-3ca520ed7381'].url} />
          <img className="dong_wu_lian_meng " src={this.state.resList['b635ec14-2e70-4f6c-b304-d031e4b0b5d9'].url} />
        </div>

        <div className="jiao_hu_kuang ">
          <img className="qian_jing " src={this.state.resList['d9131617-ff12-4e1b-87ea-97304f2f5316'].url} />
          {this.state.flag && <img className="qu_ban_li md14" src={this.state.resList['bd9cf4ad-19c0-42b7-a003-fd3a0e948215'].url} onClick={this.toApplyCard} />}
          {!this.state.flag && <img className="qu_qiang_gou md13" src={this.state.resList['8d553195-1c36-4d3f-be97-34b0e697813e'].url} onClick={this.toPurchase} />}
          <img
            className="xing_qiu_da_zuo_zhan_qu_wan_wan md15 "
            src={this.state.resList['36bcd134-df2c-4957-b97f-0b8463b4481b'].url}
            onClick={
              () => {
                console.log('星球大作战去看看')
                location.href = " https://gonghang.activity-1.m.duiba.com.cn/projectx/pb3bde510/fa619cc4d.html?appID=66480"
              }
            }
          />
          <img
            className="dong_wu_lian_meng_qu_wan_wan md16 "
            src={this.state.resList['36bcd134-df2c-4957-b97f-0b8463b4481b'].url}
            onClick={
              () => {
                console.log('动物连萌去看看')
                location.href = ' https://gonghang.activity-1.m.duiba.com.cn/projectx/pb3bde510/f005ba072.html?appID=66480&history=1'
              }
            }
          />
        </div>
        <img
          className="fan_hui_nong_chang_an_niu "
          src={this.state.resList['74bb50cd-5998-4274-af3e-e91b20099433'].url}
          onClick={this.props.closeWin}
        />
      </div>
    );
  }
}
export default Task;