'use strict';

import { Toast } from '@spark/ui';
import React, { Component } from 'react';
import API from '../../api';
import { getHomeInfo } from '../../dataCenter';
import resList from '../../resconfig/resList'; //import API from '../../api';
import { debounce } from '../../ui';
import './sign.less';
import ViewCtrl from "../../util/viewCtrl";
import Enum from '../../util/enum';

class Sign extends Component {
  constructor(props) {
    super(props);
    const { todaySigned, continuousDays, signLists } = props.data;
    this.state = {
      resList: resList,
      todaySigned,
      continuousDays,
      signLists
    };
  }

  componentDidMount() {
    setTimeout(() => {
      // Toast('sdfsdfsdfsdf', 1000 * 100);
    }, 1000);
  }

  doSign = () => {
    API.dosign().then((res) => {
      if (res && res.success) {
        const continuousDays = this.state.continuousDays + 1;
        this.setState({ todaySigned: true, continuousDays: continuousDays });
        getHomeInfo();

        if (res.data.type !== 'joyBean') {
          this.props.closeWin();
          ViewCtrl.showWin(Enum.Com.Comprize, res.data);
        } else {
          this.props.closeWin();
          Toast(`恭喜你成功领取${res.data.awardName}`)
        }
      } else {
        switch (res.code) {
          case '10010':
            Toast('网络错误，请联系客服')
            break;
            default:
            Toast('网络错误，请联系客服')
            // Toast(res.message || '网络异常，请稍后重试~')
        }
      }
    });
  };

  render() {
    const { todaySigned, signLists, continuousDays } = this.state;
    const signedList = [];
    for (let i = 0; i < 7; i++) {
      signedList[i] = i < continuousDays;
    }
    let lineList = [];
    switch (continuousDays) {
      case 0:
        lineList = []
        break;
      case 1:
        if (todaySigned)
          lineList = []
        else
          lineList = [1]
        break;
      case 2:
        if (todaySigned)
          lineList = [1]
        else
          lineList = [1, 1]
        break;
      case 3:
        if (todaySigned)
          lineList = [1, 1]
        else
          lineList = [1, 1, 1]
        break;
      case 4:
        if (todaySigned)
          lineList = [1, 1, 1]
        else
          lineList = [1, 1, 1, 1]
        break;
      case 5:
        if (todaySigned)
          lineList = [1, 1, 1, 1]
        else
          lineList = [1, 1, 1, 1, 1]
        break;
      case 6:
        if (todaySigned)
          lineList = [1, 1, 1, 1, 1]
        else
          lineList = [1, 1, 1, 1, 1, 1]
        break;
      case 7:
        if (todaySigned)
          lineList = [1, 1, 1, 1, 1, 1]
        else
          lineList = [1, 1, 1, 1, 1, 1, 1]
        break;
    }


    return (
      <div className="sign " uuid="14a66aed-4e41-4fea-9d16-6aa02c1bad5a">
        <img
          className="sign_bg "
          uuid="69e6aa13-c1b2-4c3c-98a7-abebd5e955bd"
          src={this.state.resList['7d7b7747-b417-45c0-959c-3d39603afc69'].url}
        />
        <img
          onClick={this.props.closeWin}
          className="sign_close "
          uuid="e112e990-527f-4a53-8eb4-3eb6bc60ad40"
          src={this.state.resList['104ff753-c9bc-4218-969c-3c3fa4d11610'].url}
        />
        <div className="sign_progress " uuid="3338eb8a-7cf6-4419-a49f-450bc7b73ff6">
          <img
            className="sign_progress_bg "
            uuid="07f33a4a-3703-4ae2-870b-c32ab66c2293"
            src={this.state.resList['61973e7b-efa4-42ee-b8c7-be7397ebbbb3'].url}
          />
          {signedList[0] && <img
            className="sign_progress_dot1 "
            uuid="39cd9c87-74cc-456c-b35f-d7ad1de8a1c8"
            src={this.state.resList['5cae1415-9956-47e8-9a26-bfbd4b7c7d7a'].url}
          />}
          {signedList[1] && <img
            className="sign_progress_dot2 "
            uuid="baa83cd1-6f94-4ff9-b454-c8ada9c465fa"
            src={this.state.resList['5cae1415-9956-47e8-9a26-bfbd4b7c7d7a'].url}
          />}
          {signedList[2] && <img
            className="sign_progress_dot3 "
            uuid="ea1a7572-0d0d-4395-99a5-549cf4f5cdec"
            src={this.state.resList['5cae1415-9956-47e8-9a26-bfbd4b7c7d7a'].url}
          />}
          {signedList[3] && <img
            className="sign_progress_dot4 "
            uuid="45d60d76-9ed6-4899-ae2c-6499bf4d4946"
            src={this.state.resList['5cae1415-9956-47e8-9a26-bfbd4b7c7d7a'].url}
          />}
          {signedList[4] && <img
            className="sign_progress_dot5 "
            uuid="acfad11b-093b-467e-877f-a0d2ad282069"
            src={this.state.resList['5cae1415-9956-47e8-9a26-bfbd4b7c7d7a'].url}
          />}
          {signedList[5] && <img
            className="sign_progress_dot6 "
            uuid="1aff7c26-b98b-4c1d-9bb9-818326d304b5"
            src={this.state.resList['5cae1415-9956-47e8-9a26-bfbd4b7c7d7a'].url}
          />}
          {signedList[6] && <img
            className="sign_progress_dot7 "
            uuid="8b7bc509-e55a-4c5c-b587-18abcc9bd75e"
            src={this.state.resList['5cae1415-9956-47e8-9a26-bfbd4b7c7d7a'].url}
          />}
          {!!lineList[2] && <img
            className="sign_progress_line3 "
            uuid="c84309d1-c863-4209-bb4d-ba8cdb90e00f"
            src={this.state.resList['76a9336d-fc89-4b21-aa95-b5b6fa1e09e5'].url}
          />}
          {!!lineList[5] && <img
            className="sign_progress_line6 "
            uuid="b4e4d782-3517-408f-a0ed-21dc03bbc399"
            src={this.state.resList['76a9336d-fc89-4b21-aa95-b5b6fa1e09e5'].url}
          />}
          {!!lineList[3] && <img
            className="sign_progress_line4 "
            uuid="35be9a32-90f1-454f-9e57-ee84d5ef008b"
            src={this.state.resList['76a9336d-fc89-4b21-aa95-b5b6fa1e09e5'].url}
          />}
          {!!lineList[4] && <img
            className="sign_progress_line5 "
            uuid="280540ed-e886-44e7-9897-c4f26ee3b4ab"
            src={this.state.resList['76a9336d-fc89-4b21-aa95-b5b6fa1e09e5'].url}
          />}
          {!!lineList[1] && <img
            className="sign_progress_line2 "
            uuid="997cf0d4-ce93-436c-9a57-b2f1f305c4f3"
            src={this.state.resList['76a9336d-fc89-4b21-aa95-b5b6fa1e09e5'].url}
          />}
          {!!lineList[0] && <img
            className="sign_progress_line1 "
            uuid="687b92c8-1051-4ad2-9841-d376b567904c"
            src={this.state.resList['76a9336d-fc89-4b21-aa95-b5b6fa1e09e5'].url}
          />}
        </div>
        <div className="sgin_1 " uuid="96df8cfc-972a-4346-baa6-d0b054c1f234">
          <img
            className="sgin_1_bg "
            uuid="23d3f0ed-ac94-4b3e-96eb-c59a81f9bac2"
            src={this.state.resList['f8cdaceb-06cb-4f02-9774-9cbfb0108a42'].url}
          />
          <span className="sgin_1_day " uuid="3bd1bc00-57b2-4ea1-b91e-bce13169f9e5">
            第1天
          </span>
          <span className="sgin_1_num " uuid="5c0b6718-64b6-40eb-b06c-f73cd91df196">
            +{signLists[0].awardValue}
          </span>
        </div>
        <div className="sgin_2 " uuid="4db452f3-1f3c-4704-9fa0-eb01a567be79">
          <img
            className="sgin_2_bg "
            uuid="68152498-d376-4e83-9294-8a9a7391495a"
            src={this.state.resList['13bb2f98-e796-4b96-84a8-839a71415383'].url}
          />
          <span className="sgin_2_day " uuid="a9131f91-c039-41e9-8ab5-b58178e0ce39">
            第2天
          </span>
          <span className="sgin_2_num " uuid="833e9ef5-e365-466c-85bf-0755cf94ee68">
            +{signLists[1].awardValue}
          </span>
        </div>
        <div className="sgin_5 " uuid="9c432630-cf94-4f07-8aa3-001676bf2e67">
          <img
            className="sgin_5_bg "
            uuid="aba2cb3b-b699-411f-87ed-b7665c324ffe"
            src={this.state.resList['7ca30906-4d3e-46f8-8777-3f2fb7dce83d'].url}
          />
          <span className="sgin_5_day " uuid="d3a3faf5-9d43-46a7-8c2e-1ec55195c907">
            第5天
          </span>
          <span className="sgin_5_num " uuid="86e3ec53-08fd-4a08-ba6a-e05313166294">
            +{signLists[4].awardValue}
          </span>
        </div>
        <div className="sgin_6 " uuid="1cd3c04d-2ef6-402d-93d2-119907b58b84">
          <img
            className="sgin_6_bg "
            uuid="d8d771bc-e9af-4ccd-9323-c0ce42551b15"
            src={this.state.resList['b16ba939-bf9b-4aa1-bdcb-e1df07e2fddb'].url}
          />
          <span className="sgin_6_day " uuid="1a9716ac-46b5-46b4-84c7-ad3c9210b9cb">
            第6天
          </span>
          <span className="sgin_6_num " uuid="40335448-620f-4082-baa3-426b9a09e136">
            +{signLists[5].awardValue}
          </span>
        </div>
        <div className="sgin_7 " uuid="7bee93bb-797d-4e2b-bfcf-4d56d4a68eaa">
          <img
            className="sgin_7_bg "
            uuid="42359a15-6789-4b84-b75b-c1a91b1120df"
            src={this.state.resList['20d3c271-62ed-479a-a674-8d5b3a4f4418'].url}
          />
          <span className="sgin_7_day " uuid="548bd25a-6ef9-4a79-8e0f-9cdb20f33971">
            第7天
          </span>
        </div>
        <div className="sgin_3 " uuid="f904c623-f665-4e05-aea4-8b0499f1921f">
          <img
            className="sgin_3_bg "
            uuid="9797e7cf-abb8-40a7-9db7-1952eb6b9362"
            src={this.state.resList['68483b6e-8f97-491f-8299-5eaa2109bac1'].url}
          />
          <span className="sgin_3_day " uuid="194e98ba-32e0-4e71-a41f-b90e13a73c8d">
            第3天
          </span>
          <span className="sgin_3_num " uuid="3aec9445-daf0-4652-bacb-33f2af91c0ea">
            +{signLists[2].awardValue}
          </span>
        </div>
        <div className="sgin_4 " uuid="5934c1d6-e941-433c-babf-2b911fe6e1b8">
          <img
            className="sgin_4_bg "
            uuid="9be7252b-5347-4a04-bd70-612960b93b62"
            src={this.state.resList['424234d5-3268-4a69-8b8d-601ed926da28'].url}
          />
          <span className="sgin_4_day " uuid="6cc2390d-15ab-4953-bd80-b8658c13a615">
            第4天
          </span>
          <span className="sgin_4_num " uuid="68491c5e-a63c-47af-8534-879f6470725f">
            +{signLists[3].awardValue}
          </span>
        </div>
        {signedList[0] && <div className="signed_1 " uuid="91dc6812-e5ab-45ea-8cf6-cfbe7ede032d">
          <img
            className="signed_1_bg "
            uuid="93055c77-f9cc-41c4-ab23-d0920885f86c"
            src={this.state.resList['b06cac32-457b-494d-aac1-3c410a30bc65'].url}
          />
          <span className="signed_1_day " uuid="1705a605-5750-4e46-b8ba-c4bd7f0c9e98">
            第1天
          </span>
          <span className="signed_1_num " uuid="6ca77850-6185-495a-afec-0b288f039b64">
            +{signLists[0].awardValue}
          </span>
        </div>}
        {signedList[1] && <div className="signed_2 " uuid="01a19090-6b12-408a-8ae2-04fa052b421e">
          <img
            className="signed_2_bg "
            uuid="499e7734-4c6e-4dc1-ae57-9533cfadbe7c"
            src={this.state.resList['b06cac32-457b-494d-aac1-3c410a30bc65'].url}
          />
          <span className="signed_2_day " uuid="14e30af7-16e8-43f6-8bc8-6bcb9924076f">
            第2天
          </span>
          <span className="signed_2_num " uuid="acfbff8d-8670-436a-8f7e-e960d7b7c82a">
            +{signLists[1].awardValue}
          </span>
        </div>}
        {signedList[2] && <div className="signed_3 " uuid="94200bbc-fca2-41e5-a9a5-0ab43ece60d7">
          <img
            className="signed_3_bg "
            uuid="4a7e2ba6-0719-4cac-bc14-365998f2175d"
            src={this.state.resList['b06cac32-457b-494d-aac1-3c410a30bc65'].url}
          />
          <span className="signed_3_day " uuid="d9d9cc2c-4b61-4c8e-8255-ac3e93845afd">
            第3天
          </span>
          <span className="signed_3_num " uuid="81f622ec-d099-4270-92c8-1da247bcf4f3">
            +{signLists[2].awardValue}
          </span>
        </div>}
        {signedList[3] && <div className="signed_4 " uuid="bf7a2ddd-c662-4ab2-93a5-a60693043863">
          <img
            className="signed_4_bg "
            uuid="afb52fc3-1968-4bf5-a9ab-9d19dee08d6c"
            src={this.state.resList['b06cac32-457b-494d-aac1-3c410a30bc65'].url}
          />
          <span className="signed_4_day " uuid="14e55262-f09c-4ff7-9e5c-f0dc770f8d8c">
            第4天
          </span>
          <span className="signed_4_num " uuid="09492167-4793-4be4-8a32-e37ce5d4dcc1">
            +{signLists[3].awardValue}
          </span>
        </div>}
        {signedList[4] && <div className="signed_5 " uuid="a49b0dac-b1ea-41e3-988d-79f164620568">
          <img
            className="signed_5_bg "
            uuid="0e3d6178-e9cc-4f47-9344-585b8bc1e15f"
            src={this.state.resList['b06cac32-457b-494d-aac1-3c410a30bc65'].url}
          />
          <span className="signed_5_day " uuid="83ae0eb9-75a1-49e4-a22d-db39509f56ea">
            第5天
          </span>
          <span className="signed_5_num " uuid="a214fe3b-e6cf-4ecb-ae8d-6bdc8f445a0d">
            +{signLists[4].awardValue}
          </span>
        </div>}
        {signedList[5] && <div className="signed_6 " uuid="96acf396-cef8-43a4-bd69-fb7d9c1467c6">
          <img
            className="signed_6_bg "
            uuid="af53284f-de9a-4ed6-94f8-90576911d120"
            src={this.state.resList['b06cac32-457b-494d-aac1-3c410a30bc65'].url}
          />
          <span className="signed_6_day " uuid="e69ddc22-7496-4a50-914d-5df5fbe5dfe5">
            第6天
          </span>
          <span className="signed_6_num " uuid="410b5238-9514-4c4f-abe1-9977ba0d29ea">
            +{signLists[5].awardValue}
          </span>
        </div>}
        {todaySigned && (
          <img
            className="sign_signed_btn "
            uuid="d8ca8cb8-92f1-4512-aead-d674cac5a46c"
            src={this.state.resList['534772d2-3e5a-487d-8236-8913de270cb0'].url}
          />
        )}

        <img
          onClick={() => { location.href = 'ff1c082c5.html' }}
          className="sign_recordbtn "
          src="//yun.duiba.com.cn/spark/assets/3d41e1c0c6efe7f06324dd82292b728242d3eef8.png"
        />

        {!todaySigned && (
          <img
            onClick={debounce(this.doSign, 2000, 1)}
            className="sign_btn md11"
            uuid="4dfe2b82-10bd-4442-a01e-65c18869a18e"
            src={this.state.resList['13b618c4-cd2a-4037-9664-b77381fbfade'].url}
          />
        )}
        {signedList[6] && <div className="signed_7 " uuid="7b91c31c-0de4-4148-9887-6ab24e963258">
          <img
            className="signed_7_bg "
            uuid="348400d8-166c-463b-b6a4-e4b3a24d9a7b"
            src={this.state.resList['c8e34ab2-dc51-4eeb-a949-3b03636ec3a2'].url}
          />
          <span className="signed_7_txt " uuid="32c14336-2aa7-4bdd-8e5f-8c3763ad8c6b">
            第7天
          </span>
        </div>}
      </div>
    );
  }
}

export default Sign;
