'use strict';

import { Toast } from '@spark/ui';
import React, { Component } from 'react';
import dataCenter, { getAPIdata, getHomeInfo, netErrMsg, Role, Store } from '../../dataCenter';
import resList from '../../resconfig/resList'; //import API from '../../api';
import { debounce } from '../../ui';

import './select.less';
const startselidx = 1;
class Select extends Component {
  constructor(props) {
    super(props);
    this.state = {
      resList: resList,
      nshowidx:2,
      changed:false,
      selected:true
    };
  }

  onKeyUp=(e)=>{
    // let planame = this.refs.planame.value;
    // if(planame.length > 6) {
    //   this.refs.planame.value = planame.slice(0,6)
    // }
  }

  componentDidMount() {
    const {figures} = dataCenter.getData(Store.homeinfo);
    //现只有三个
    for(let i=1;i<4;i++){
      let ifigure = figures[i-1];
      if(ifigure){
        Role[i].figureid = ifigure.figureId;
      }
    }
    // console.log("figureid设置==》",Role);
    // setTimeout(() => {
    //   console.log('关闭这个弹窗');
    //   this.props.closeWin();
    // }, 1000);

    this.nshowidx = startselidx;
    this.setState({
      nshowidx:startselidx
    });
    let startClass = [
      ["cardtwo","cardthr","cardone"],
      ["cardone","cardtwo","cardthr"],
      ["cardthr","cardone","cardtwo"],
    ]
    
    this.refs.cardone.className = startClass[startselidx-1][0];
    this.refs.cardtwo.className = startClass[startselidx-1][1];
    this.refs.cardthr.className = startClass[startselidx-1][2];
  }
  cantouch = false;
  lastouchx;
  touchSolve(e) {
    let touchtype = e.type;
    let screenx = e.nativeEvent.changedTouches[0].screenX;
    if (touchtype == "touchstart") {
      this.cantouch = true;
      this.lastouchx = screenx;
    } else if (touchtype == "touchmove") {
      if (this.cantouch) {
        if (screenx - this.lastouchx > 10) {
          this.cantouch = false;
          this.changeShowRole("right");
        } else if (screenx - this.lastouchx < -10) {
          this.cantouch = false;
          this.changeShowRole("left");
        }
        this.lastouchx = screenx;
      }
    } else if (touchtype == "touchend") {

    }
  }
  nshowidx = 2;
  changeShowRole(dir){
    let changenum = dir=="left"?+1:-1;
    
    let nshowidx = this.nshowidx + changenum;
    this.nshowidx = this.changeIdxShow(nshowidx,this.refs.cardtwo,"onemaskadd");

    let lshowidx = this.nshowidx+1;
    let tshowidx = this.nshowidx-1;
    this.changeIdxShow(lshowidx,this.refs.cardone,"twomaskadd");
    this.changeIdxShow(tshowidx,this.refs.cardthr,"thrmaskadd");
    this.setState({
      nshowidx:this.nshowidx,
      changed:true,
    });

    console.error("当前选中====》",this.nshowidx);
  }
  changeIdxShow(showidx,target,maskadd){
    if(showidx==4){
      showidx = 1;
    }
    if(showidx==0){
      showidx = 3;
    }
    // let maskcard = target.getElementsByTagName("img")[1];

    let srcClass = target.className;

    let showclass = ['cardthr','cardtwo','cardone'][showidx-1];
    let aniclass = '';
    if(showclass=="cardone"){
      if(srcClass.indexOf("cardtwo")!=-1){
        aniclass = "twoAnione";
      }else{
        aniclass = "thrAnione";
      }
    }
    else if(showclass=="cardtwo"){
      if(srcClass.indexOf("cardone")!=-1){
        aniclass = "oneAnitwo";
      }else{
        aniclass = "thrAnitwo";
      }
    }
    else if(showclass=="cardthr"){
      if(srcClass.indexOf("cardone")!=-1){
        aniclass = "oneAnithr";
      }else{
        aniclass = "twoAnithr";
      }
    }
    target.className = showclass+" "+aniclass;


    // if(srcClass=="cardtwo"){
    //   if(maskadd=="onemaskadd"){

    //   }
    // }else if(showclass=="cardtwo"){

    // }
    
    return showidx;
  }
  async selectRole(){
    let planame = this.refs.planame.value;
    if(planame.length<1){
      return Toast("昵称不能为空");
    }
    var regEn = /[`~!@#$%^&*()_+<>?:"{},.\/;'[\]]/im,
    	regCn = /[·！#￥（——）：；“”‘、，|《。》？、【】[\]]/im;
    if(regEn.test(planame) || regCn.test(planame)) {
      Toast("昵称格式错误，只能使用6个字符以内的字母、数字、中文");
      return false;
    }
    let updateuinfo = await getAPIdata(Store.updateUinfo,{
      type:1,
      nickName: planame,
      figureId:Role[this.nshowidx].figureid
    });
    // updateuinfo = {"code":"10004","data":null,"message":"昵称包含敏感词","success":true};
    
    if(updateuinfo&&updateuinfo.success){
      if(updateuinfo.data){
        const {result,joyBeans} = updateuinfo.data;
        if(result){
          dataCenter.setData(Store.newgoldnum,joyBeans);
        }
      }
      getHomeInfo();
      this.props.closeWin();
      dataCenter.setData(Store.needguide,true);
    }else{
      if(updateuinfo){
        // let msg = updateuinfo.message;
        // Toast(msg);

        switch (updateuinfo.code) {
          case '10004':
            Toast('存在敏感词，请重新检查昵称')
            break;
          case '10005':
            Toast('网络错误，发放欢趣豆失败')
            break;
          default:
            Toast(updateuinfo.message || '网络异常，请稍后重试~')
        }

      }else{
        Toast(netErrMsg)
      }
    }
  }
  render() {
    const {nshowidx,changed,selected} = this.state;
    return (
      <div className="select diacontmidpos" uuid="298ea3b7-efbb-42ac-adea-ee68aa1db627">
        <div className="cardone" uuid="36334c7a-26df-4f9e-83d3-6ac81e49d6db" ref="cardone">
          <img
            className="select_role1 "
            uuid="76f06526-a55d-4f2a-b817-d450126bdf54"
            src={this.state.resList['8872d3a6-1d19-4a83-a07d-ae084b8a1392'].url}
          />
          <img
            className={"onemask "+(nshowidx==1?"opacitycur":"opacitylat")+(changed?nshowidx==1?" opalatocur":" opacurtolat":"")}
            src={this.state.resList['5608e852-913b-47e0-a286-0c33a86aed10'].url}
            uuid="912dc687-6727-4bb1-9e87-936ea77074ce"
          />
        </div>
        <div className="cardtwo" uuid="a24b6660-832b-4fd0-94e6-b627f4aefb68" ref="cardtwo">
          <img
            className="select_role2 "
            uuid="cb643df1-dd96-4249-ac24-04136f106467"
            src={this.state.resList['61eeafb1-d01e-4f8c-b7a8-5ee9432efb9b'].url}
          />
          <img
            className={"twomask "+(nshowidx==2?"opacitycur":"opacitylat")+(changed?nshowidx==2?" opalatocur":" opacurtolat":"")}
            src={this.state.resList['5608e852-913b-47e0-a286-0c33a86aed10'].url}
            uuid="d54f2e03-e401-42a3-8132-8e8138e5c4f9"
          />
        </div>
        <div className="cardthr" uuid="68b6c97e-82f0-412b-8950-2665aba842fa" ref="cardthr">
          <img
            className="select_role3 "
            uuid="f26ff0c9-78dc-47b8-970b-dfe5a6938464"
            src={this.state.resList['9da0a542-17dc-4c4c-bcc3-2ee8fba66ffa'].url}
          />
          <img
            className={"thrmask "+(nshowidx==3?"opacitycur":"opacitylat")+(changed?nshowidx==3?" opalatocur":" opacurtolat":"")}
            src={this.state.resList['5608e852-913b-47e0-a286-0c33a86aed10'].url}
            uuid="28141b28-0c40-4810-8233-cc392753d698"
          />
        </div>
        <img
          className="select_bg "
          uuid="b7fef7c6-cc6d-4147-baa2-1b836b23f5cf"
          src="//yun.duiba.com.cn/spark/assets/25ef4023896f749bc7f9e202abf680085f4e7c4d.png"
        />
        {selected?<img
          className="select_btndisabled "
          uuid="b5ffc84d-26e8-4c5a-aa13-b450672682e2"
          src={this.state.resList['fa7ec292-bf36-4ca1-bf04-2e2360176044'].url}
        />:<img
        className="select_btn "
        uuid="553dac18-d798-4eeb-a64e-dd850711d44e"
        src={this.state.resList['2f3d6f0d-0695-4acf-ae87-4e6743772531'].url}
        onClick={   debounce(this.selectRole.bind(this), 2000, 1)  }
      />}
        
        
        <div className="scrolldiv" onTouchStart={this.touchSolve.bind(this)} onTouchMove={this.touchSolve.bind(this)} onTouchEnd={this.touchSolve.bind(this)} >

        </div>
        <img
          className="select_right "
          uuid="c98966a6-06b5-4262-98b9-aca82095b372"
          src={this.state.resList['5b40f5cf-2a46-4a68-9a79-40c8179ce379'].url}
          onClick={this.changeShowRole.bind(this,"right")}
        />
        <img
          className="select_left "
          uuid="01088a9b-53d1-43f3-b09d-3eabfe156c0f"
          src={this.state.resList['a4412ebd-65be-4908-8894-b0aea8cbd4cf'].url}
          onClick={this.changeShowRole.bind(this,"left")}
        />
        <input onKeyUp={this.onKeyUp} onChange={()=>{this.setState({selected:false})}} className="planame" type="text" placeholder="请输入昵称（不超过六字）" ref="planame" />
      </div>
    );
  }
}

export default Select;
