import apiCfg from './apicfg';
import { getPxToken } from "@spark/projectx";
import { callApi } from '@spark/api-base'

import { isFromShare, newUser } from 'duiba-utils';

let mergeData = {
  user_type: newUser ? '0' : '1',
  is_from_share: isFromShare ? '0' : '1',
}

const apiList = {
  ...apiCfg
}


const API = generateAPI(apiList);
export default API;

function getRequestParams(value) {
  if (typeof value === 'string') {
    return {
      uri: value,
      method: 'get'
    }
  } else if (typeof value === 'object') {
    const { uri, method = 'post', headers, withToken, secret, secretKey } = value;
    return {
      uri,
      method,
      headers,
      withToken,
      secret,
      secretKey,
    }
  } else {
    console.error('getRequestParams: 传参有误');
  }
}


function generateAPI(apiList) {
  const api = {};
  for (let key in apiList) {
    let value = apiList[key];

    const { method, uri, headers: mHeaders, withToken, secret, secretKey } = getRequestParams(value);
    api[key] = async (params = {}, headers) => {
      let token;
      if (withToken) {
        const { type, payload } = await getPxToken();
        switch (type) {
          case 'success':
            token = payload.token;
            break;
          case 'failed':
            location.reload();
            break;
        }
      }

      let mergedHeaders = { ...mHeaders, ...headers }
      if (withToken && token) {
        params.token = token;
      }

      params = { ...params, ...mergeData };
      window.fucklog('callApi:'+uri)
      const result = await callApi(uri, params, method, mergedHeaders, false, secret, secretKey);
      try {
        window.fucklog('uri='+uri+',result'+JSON.stringify(result));
      } catch (error) {
        
      }
      
      if (result.type === 'success') {
        return result.payload;
      }
      throw new Error(result.payload);
    }
  }

  return api;
}
