import { OptionItem } from '../gameLose/OptionItem';
import { GameWinModule, ModuleName } from "duiba_wx";
import { DataManager, NetManager } from "duiba_tw";
import { StageManager, ModuleManager } from "duiba_tl";
import { GFun } from "duiba_tc";
export class ExGameWinModule extends GameWinModule {
    /**
     * 奖品列表
     */
    private list: annieUI.ScrollList;

    public updateData(score: number, ...args): void {
        super.updateData(score);
        this.view.rankTxt.text = '目前排名：' + DataManager.ins.getInfoData.rank;
    }

    protected initUI(): void {
        super.initUI();
        this.list = new annieUI.ScrollList(OptionItem, 146, 174, 146*4, 174, false);
        StageManager.ins.addChild(this.list, this.view);
        this.list.x = 35;
        this.list.y = 820;
        NetManager.ins.getOptions(function(){
            this.view.endTimeTxt.text = GFun.replace('截止到{0}', [DataManager.ins.gameCfgData.game.offDate]);
            this.list.updateData(DataManager.ins.getOptionsData.optionList, true);
        }.bind(this));
    }

    protected addEvent(): void {
        super.addEvent();
        this.addClick(this.view.realTimeRankBtn, this.onClick_realTimeRankBtn);
    }

    protected onClick_realTimeRankBtn(e: annie.MouseEvent): void {
        this.enableMouseEvt(false);
        NetManager.ins.realtimerank(function(){
            ModuleManager.ins.openModule(ModuleName.GAME_REAL_TIME_RANK_PANEL);
            this.enableMouseEvt(true);
        }.bind(this), 0, 30);
    }

    protected removeEvent(): void {
        super.removeEvent();
        this.removeClick(this.view.realTimeRankBtn);
    }
}