import { GMath, GPool } from "duiba_tc";
import { StageManager } from "duiba_tl";

export class Level extends annie.Sprite {
    public type: number;
    public view: any;

    public updateData(type?: number): void {
        this.clean();
        this.type = type;
        if(!this.type) {
            this.type = GMath.random(1, 2, true);
        }
        //获取关卡
        this.view = GPool.takeOut('gamePlaySkin.Level' + this.type);
        StageManager.ins.addChild(this.view, this);
    }

    /**
     * 检测道具碰撞
     * @param wallet
     * @return {boolean}
     */
    public hitTest(car: annie.Sprite): boolean {
        var condition1 = Math.abs(car.x - (this.view.obscale.x + this.x)) < (185 + 135) * 0.5;
        var condition2 = car.y == this.view.obscale.y;
        return condition1 && condition2;
    }

    /**
     * 清理
     */
    private clean(): void {
        if(this.view) {
            StageManager.ins.removeChild(this.view);
            GPool.recover('gamePlaySkin.Level' + this.type, this.view);
            this.view = null;
        }
    }
}