import { GamePlayModule } from "duiba_wx";
import { Level } from "./Level";
import { DataManager } from "duiba_tw";
import { GPool, GTime, IModuleData } from "duiba_tc";
import { StageManager } from "duiba_tl";

export class ExGamePlayModule extends GamePlayModule {
    private SCREEN_WIDTH = 640 * 2;
    //两个关卡交替循环
    private level1: Level;
    private level2: Level;
    //背景移动速度
    private bgSpeed: number = 2;
    //背景加速度     
    private bgAddSpeed: number;
    //上一次进入帧系统时间    
    private lastSystemTime: number;
    //最高分数
    private maxScore: number;
    //进入帧回调
    private onEnterFrameBind: Function;

    constructor(moduleData: IModuleData){
        super(moduleData);
        trace('构造', this.bgSpeed);
    }

    protected initUI(): void {
        super.initUI();
        this.bgSpeed = 3;
        trace('init', this.bgSpeed);
    }
    
    protected resetGame(): void {
        super.resetGame();
        trace('show', this.bgSpeed);
        //如果在全局定义了速度则获取全局的(用于在皮肤内快速调整)
        this.updateScore(3, 0);
        this.maxScore = DataManager.ins.getInfoData.maxScore;
        this.view.currScoreTxt.text = this.score;
        this.view.maxScoreTxt.text = this.maxScore ? this.maxScore : 0;
        this.bgSpeed = window['bgSpeed'] ? window['bgSpeed'] : 10;
        this.bgAddSpeed = window['bgAddSpeed'] ? window['bgAddSpeed'] : 0.1;
        trace(Level);
        if (!this.level1) {
            this.level1 = GPool.takeOut('Level', Level);
            if (!this.level1) {
                this.level1 = new Level();
            }
            StageManager.ins.addChild(this.level1, this.view, 0);
        }
        this.level1.updateData(1);
        this.level1.x = 0;
        if (!this.level2) {
            this.level2 = GPool.takeOut('Level', Level);
            if (!this.level2) {
                this.level2 = new Level();
            }
            StageManager.ins.addChild(this.level2, this.view, 1);
        }
        this.level2.updateData(2);
        this.level2.x = this.level1.x + this.SCREEN_WIDTH;
        this.view.car.y = 773;
        this.view.car.scaleY = 1;
        this.view.addEventListener(annie.Event.ENTER_FRAME, this.onEnterFrameBind = this.onEnterFrame.bind(this));
    }

    private onEnterFrame(e: annie.Event): void {
        //本次进入帧消耗的时间
        var useTime;
        if (this.lastSystemTime) {
            useTime = GTime.getTimestamp() - this.lastSystemTime;
        } else {
            useTime = 1000 / 30;
        }
        //本次消耗的时间 / 正常每帧应该消耗的时间 算出倍率
        var times = useTime / (1000 / 30);
        //速度 * 倍率 = 本次应该移动的距离
        this.level1.x -= this.bgSpeed * times;
        this.level2.x -= this.bgSpeed * times;

        this.bgSpeed += this.bgAddSpeed * times;
        this.updateScore(1, 1);
        if (this.score > this.maxScore) {
            this.view.maxScoreTxt.text = this.score;
        }
        this.view.currScoreTxt.text = this.score;

        if (this.level1.x <= -this.SCREEN_WIDTH) {
            this.level1.updateData();
            this.level1.x = this.level2.x + this.SCREEN_WIDTH;
        }

        if (this.level2.x <= -this.SCREEN_WIDTH) {
            this.level2.updateData();
            this.level2.x = this.level1.x + this.SCREEN_WIDTH;
        }
        
        var level: Level;
        //在哪个关卡内就跟哪个检测碰撞
        if (this.view.car.x > this.level1.x && this.view.car.x < this.level1.x + this.SCREEN_WIDTH) {
            level = this.level1;
        } else {
            level = this.level2;
        }
        if (level.hitTest(this.view.car)) {
            this.view.removeEventListener(annie.Event.ENTER_FRAME, this.onEnterFrameBind);
            var self: any = this;
            var tw: number = annie.Tween.to(this.view.car, 0.1, { alpha: 0, yoyo: 3 });
            setTimeout(function () {
                self.gameOver();
            }, 1000);
        }
    }

    protected onMouseDown(e: annie.MouseEvent): void {
        super.onMouseDown(e);
        this.view.car.scaleY = -this.view.car.scaleY;
        if (this.view.car.scaleY == 1) {
            this.view.car.y = 773;
        } else {
            this.view.car.y = 840;
        }
    }
}