import { ExGameRealTimeRankUserItem } from "./gameRealTimeRank/ExGameRealTimeRankUserItem";
import { ExGamePlayModule } from "./gamePlay/ExGamePlayModule";
import { ExGameWinModule } from "./gameWin/ExGameWinModule";
import { ExGameLoseModule } from "./gameLose/ExGameLoseModule";
import { ExGameEndRankItem } from "./gameEndRank/ExGameEndRankItem";
import { IModuleData, LayoutType, ResPriority, GConsole, ModuleType, GLang } from "duiba_tc";
import { StageManager, ModuleManager, ResManager, WaitingModule, TlModuleName, Animation, MsgModule } from "duiba_tl";
import { ModuleName, RuleModule, GameRealTimeRankModule, GameStartModule, GameGuideModule, GameEndRankModule, GameWinnerModule, GameEndModule } from "duiba_wx";
import { DataManager, GameCfgData, NetManager, Buried } from "duiba_tw";

window.addEventListener("load", function () {
    window['_error_storage_'] = [];
    window['ERROR_CONFIG'] = {
        client: "duiba-game",
        pageId: window['CFG'].oaId || window['CFG'].gameInfo.oaId,
        imgUrl: "http://retcode.tuipink.com/report?"
    };

    function r() {
        window['_error_storage_'] && window['_error_storage_'].push([].slice.call(arguments))
    }
    window.addEventListener && window.addEventListener("error", r, true);
    var t = 3,
    n = function e() {
        var r = document.createElement("script");
        r.async = !0, r.src = "//yun.tuia.cn/tuia/skyeye/skyeye.js", r.crossOrigin = "anonymous", r.onerror =
            function () {
                t--, t > 0 && setTimeout(e, 1500)
            }, document.head && document.head.appendChild(r)
    };
    setTimeout(n, 1500);
    // const str = GFun.replace('1{0}2',['haha']);
    // alert(str);
    new Main();
});

export class Main {
    /**
     * 舞台
     */
    private stage: annie.Stage;

    constructor() {
        annie.debug = false;
        window['F2xExtend'] = eval('__extends');
        /**
         * 最上层div的id,可以在一个页面同时放多个stage.
         * 设计尺寸的宽
         * 设计尺寸的高
         * FPS刷新率
         * 缩放模式
         * 渲染模式
         */
        this.stage = new annie.Stage("annieEngine", 640, 1030, 60, annie.StageScaleMode.FIXED_WIDTH, 0);
        //默认关闭自动旋转和自动resize
        //stage.autoResize=true;
        //stage.autoSteering=true;

        this.stage.addEventListener(annie.Event.INIT_TO_STAGE, this.onAddToStage.bind(this));
    }

    private onAddToStage(e: annie.Event): void {
        DataManager.ins.gameCfgData = new GameCfgData();
        DataManager.ins.gameCfgData.update(window['CFG']);
        NetManager.ins.getInfo(() => {
            var modules: IModuleData[];
            if (DataManager.ins.getInfoData.status.code == 4) {
                this.commonModules = this.commonModules.concat(this.endModules2);
            } else if (DataManager.ins.getInfoData.status.code == 5) {
                this.commonModules = this.commonModules.concat(this.endModules1);
            } else {
                this.commonModules = this.commonModules.concat(this.openModules);
            }
            StageManager.ins.init(this.stage, LayoutType.TOP, 1386, 1030);
            Buried.init();
            ModuleManager.ins.init(this.commonModules, this.waitingModule, this.msgModule, this.loadingModule);
            ResManager.ins.loadRes(window['resPath' || ''], this.onResProgress.bind(this));
        });
    }

    private onResProgress(step: ResPriority): void {
        if (step == ResPriority.PRE) {
            GConsole.log(GLang.lang_001);
        } else if (step == ResPriority.NOMARL) {
            GConsole.log(GLang.lang_002);
            var code: number = DataManager.ins.getInfoData.status.code;
            if (code == 5) {
                NetManager.ins.winRanks(() => {
                    ModuleManager.ins.openModule(ModuleName.GAME_WINNER_SCENE);
                });
            } else {
                if (code == 4) {
                    ModuleManager.ins.openModule(ModuleName.GAME_END_SCENE);
                } else {
                    ModuleManager.ins.openModule(ModuleName.GAME_START_SCENE);
                }
            }
        } else if (step == ResPriority.DELAY) {
            GConsole.log(GLang.lang_003);
        }
    }

    private loadingModule: IModuleData;

    private waitingModule: IModuleData = {
        moduleName: TlModuleName.WAITING_PANEL,
        moduleClass: WaitingModule,
        viewClass: 'waitingSkin.WaitingSkin',
        res: 'waitingSkin',
        resPriority: ResPriority.PRE,
        type: ModuleType.PANEL,
        layerIndex: 2,
        showBg: true,
        eventPenetrate: false,
        showAnimation: Animation.showPanel,
        hideAnimation: null
    };

    private msgModule: IModuleData = {
        moduleName: TlModuleName.MSG_PANEL,
        moduleClass: MsgModule,
        viewClass: 'msgSkin.MsgSkin',
        res: 'msgSkin',
        resPriority: ResPriority.DELAY,
        type: ModuleType.PANEL,
        layerIndex: 3,
        showBg: true,
        eventPenetrate: false,
        showAnimation: Animation.showPanel,
        hideAnimation: null
    }

    /**
     * 公用模块
     */
    private commonModules: IModuleData[] = [
        {
            moduleName: ModuleName.RULE_PANEL,
            moduleClass: RuleModule,
            viewClass: 'ruleSkin.RuleSkin',
            res: 'ruleSkin',
            resPriority: ResPriority.DELAY,
            type: ModuleType.PANEL,
            layerIndex: 2,
            showBg: true,
            eventPenetrate: false,
            showAnimation: Animation.showPanel,
            hideAnimation: null,
            uiCfg: {
                ox: 85,
                oy: 290,
                ow: 470,
                oh: 510,
                fs: 28,
                fc: '#000',
                lh: 38
            }
        },
        {
            moduleName: ModuleName.GAME_REAL_TIME_RANK_PANEL,
            moduleClass: GameRealTimeRankModule,
            viewClass: 'gameRealTimeRankSkin.GameRealTimeRankSkin',
            res: 'gameRealTimeRankSkin',
            resPriority: ResPriority.DELAY,
            type: ModuleType.PANEL,
            layerIndex: 3,
            showBg: true,
            eventPenetrate: false,
            showAnimation: Animation.showPanel,
            hideAnimation: null,
            uiCfg: {
                iw: 552,
                ih: 57,
                lx: 44,
                ly: 330,
                lw: 552,
                lh: 550,
                itemClass: ExGameRealTimeRankUserItem
            }
        }
    ];

    /**
     * 活动开启模块
     */
    private openModules: IModuleData[] = [
        {
            moduleName: ModuleName.GAME_START_SCENE,
            moduleClass: GameStartModule,
            viewClass: 'gameStartSkin.GameStartSkin',
            res: 'gameStartSkin',
            resPriority: ResPriority.NOMARL,
            type: ModuleType.SCENE,
            layerIndex: 1,
            showBg: false,
            eventPenetrate: false,
            showAnimation: null,
            hideAnimation: Animation.hideScene
        },
        {
            moduleName: ModuleName.GAME_GUIDE_SCENE,
            moduleClass: GameGuideModule,
            viewClass: 'gameGuideSkin.GameGuideSkin',
            res: 'gameGuideSkin',
            resPriority: ResPriority.DELAY,
            type: ModuleType.SCENE,
            layerIndex: 1,
            showBg: false,
            eventPenetrate: false,
            showAnimation: null,
            hideAnimation: Animation.hideScene
        },
        {
            moduleName: ModuleName.GAME_PLAY_SCENE,
            moduleClass: ExGamePlayModule,
            viewClass: 'gamePlaySkin.GamePlaySkin',
            res: 'gamePlaySkin',
            resPriority: ResPriority.DELAY,
            type: ModuleType.SCENE,
            layerIndex: 1,
            showBg: false,
            eventPenetrate: false,
            showAnimation: null,
            hideAnimation: Animation.hideScene
        },
        {
            moduleName: ModuleName.GAME_WIN_PANEL,
            moduleClass: ExGameWinModule,
            viewClass: 'gameWinSkin.GameWinSkin',
            res: 'gameWinSkin',
            resPriority: ResPriority.DELAY,
            type: ModuleType.PANEL,
            layerIndex: 2,
            showBg: true,
            eventPenetrate: false,
            showAnimation: Animation.showPanel,
            hideAnimation: null,
            uiCfg: {
                ix_b: 132,
                iy_b: 436,
                iw_b: 381,
                ih_b: 178
            }
        },
        {
            moduleName: ModuleName.GAME_LOSE_PANEL,
            moduleClass: ExGameLoseModule,
            viewClass: 'gameLoseSkin.GameLoseSkin',
            res: 'gameLoseSkin',
            resPriority: ResPriority.DELAY,
            type: ModuleType.PANEL,
            layerIndex: 2,
            showBg: true,
            eventPenetrate: false,
            showAnimation: Animation.showPanel,
            hideAnimation: null
        }
    ];

    /**
     * 活动结束已开奖
     */
    private endModules1: IModuleData[] = [
        {
            moduleName: ModuleName.GAME_END_RANK_PANEL,
            moduleClass: GameEndRankModule,
            viewClass: 'gameEndRankSkin.GameEndRankSkin',
            res: 'gameEndRankSkin',
            resPriority: ResPriority.DELAY,
            type: ModuleType.PANEL,
            layerIndex: 2,
            showBg: true,
            eventPenetrate: false,
            showAnimation: Animation.showPanel,
            hideAnimation: null,
            uiCfg: {
                sx: 65,
                sy: 200,
                sw: 510,
                sh: 710,
                gap: 10,
                isVertical: true,
                itemClass: ExGameEndRankItem
            },
        },

        {
            moduleName: ModuleName.GAME_WINNER_SCENE,
            moduleClass: GameWinnerModule,
            viewClass: 'gameWinnerSkin.GameWinnerSkin',
            res: 'gameWinnerSkin',
            resPriority: ResPriority.NOMARL,
            type: ModuleType.SCENE,
            layerIndex: 1,
            showBg: false,
            eventPenetrate: false,
            showAnimation: null,
            hideAnimation: Animation.hideScene
        }
    ];

    //活动结束未开奖
    private endModules2: IModuleData[] = [
        {
            moduleName: ModuleName.GAME_END_SCENE,
            moduleClass: GameEndModule,
            viewClass: 'gameEndSkin.GameEndSkin',
            res: 'gameEndSkin',
            resPriority: ResPriority.NOMARL,
            type: ModuleType.SCENE,
            layerIndex: 1,
            showBg: false,
            eventPenetrate: false,
            showAnimation: null,
            hideAnimation: Animation.hideScene
        }
    ];

}