import { GMath } from "duiba_tc";
import { GameUserItem } from "duiba_wx";
import { UserData } from "duiba_tw";

export class ExGameRealTimeRankUserItem extends GameUserItem {
    constructor() {
        super();
        this.bw = 552;
        this.bh = 57;
        this.skinClass = eval('gameRealTimeRankSkin.AlwaysRankListItem');
    }

    public initData(id: number, userData: UserData): void {
        if(!userData) {
            return;
        }
        super.initData(id, userData);
        if(userData.rank <= 3) {
            this.view.rankTxt.visible = false;
            this.view.rankMc.visible = true;
            this.view.rankMc.gotoAndStop(GMath.int(userData.rank));
        } else {
            this.view.rankTxt.visible = true;
            this.view.rankMc.visible = false;
            this.view.rankMc.gotoAndStop(1);
        }
    }
}