import { GameLoseModule, ModuleName } from "duiba_wx";
import { DataManager, NetManager } from "duiba_tw";
import { StageManager, ModuleManager } from "duiba_tl";
import { OptionItem } from "./OptionItem";
import { GFun } from "duiba_tc";

export class ExGameLoseModule extends GameLoseModule {
    /**
     * 奖品列表
     */
    private list: annieUI.ScrollList;

    public updateData(score: number): void {
        super.updateData(score);
        this.view.rankTxt.text = '目前排名：' + DataManager.ins.getInfoData.rank;
    }

    protected initUI(): void {
        super.initUI();
        this.list = new annieUI.ScrollList(OptionItem, 146, 174, 146 * 4, 174, false);
        StageManager.ins.addChild(this.list, this.view);
        this.list.x = 33;
        this.list.y = 770;
        NetManager.ins.getOptions(() => {
            this.view.endTimeTxt.text = GFun.replace('截止到{0}', [DataManager.ins.gameCfgData.game.offDate]);
            this.list.updateData(DataManager.ins.getOptionsData.optionList, true);
        });
    }

    protected addEvent(): void {
        super.addEvent();
        this.addClick(this.view.realTimeRankBtn, this.onClick_realTimeRankBtn);
    }

    protected onClick_realTimeRankBtn(e: annie.MouseEvent): void {
        this.enableMouseEvt(false);
        NetManager.ins.realtimerank(() => {
            ModuleManager.ins.openModule(ModuleName.GAME_REAL_TIME_RANK_PANEL);
            this.enableMouseEvt(true);
        }, 0, 30);
    }

    protected removeEvent(): void {
        super.removeEvent();
        this.removeClick(this.view.realTimeRankBtn);
    }
}