import { Item, Img, WxLang } from "duiba_wx";
import { GameOptionData } from "duiba_tw";
import { StageManager } from "duiba_tl";
import { GFun } from "duiba_tc";

export class OptionItem extends Item {
    /**
     * 奖品图片
     */
    private img: Img;

    constructor() {
        super();
        this.skinClass = eval('gameLoseSkin.OptionItemSkin');
    }

    public initData(id: number, gameOption: GameOptionData): void {
        super.initData(id);
        if(!gameOption) {
            return;
        }
        //奖励图片
        if(!this.img) {
            this.img = new Img();
            StageManager.ins.addChild(this.img, this.view);
        }
        this.img.updateData(gameOption.img, 0, 0, 136, 136);

        //奖励范围
        if(this.view.scopeTxt) {
            if(window["specialName"]){
                this.view.scopeTxt.text = window["specialName"];
            } else {
                //自动开奖
                if(gameOption.autoOpen) {
                    this.view.scopeTxt.text = WxLang.lang_005;
                } else {
                    this.view.scopeTxt.text = GFun.replace(WxLang.lang_006, [gameOption.scope]);
                }
            }
        }
    }
}