# Egret游戏开发：hello world

## 创建入口index.html
在根目录创建`index.html`文件，这是本地项目访问入口。
在`body`标签内创建class属性值为`egret-player`的div标签，这是画布`canvas`的容器。这个标签上还有其他的一些配置相关的属性。详细如下：
```html
<div style="margin: auto;width: 100%;height: 100%;" class="egret-player" data-entry-class="Main" data-orientation="auto"
    data-scale-mode="showAll" data-frame-rate="30" data-content-width="750" data-content-height="1624"
    data-multi-fingered="2" data-show-fps="false" data-show-log="false" data-show-fps-style="x:0,y:0,size:12,textColor:0xffffff,bgAlpha:0.9">
</div>
```

然后，在`index.html`引入Egret的代码库文件egret.min.js以及egret.web.min.js。
```html
<script src="https://yun.duiba.com.cn/db_games/egret_5.2.9/egret.min.js"></script>
<script src="https://yun.duiba.com.cn/db_games/egret_5.2.9/egret.web.min.js"></script>
```

之后，我们再把用户代码文件`main.js`引入进来。
```html
<script src="main.js"></script>
```

## 编写代码
在根目录创建`main.js`用户代码文件。


```html
<script>
    egret.runEgret({
        renderMode: "webgl", audioType: 0, calculateCanvasScaleFactor: function (context) {
            var backingStore = context.backingStorePixelRatio ||
                context.webkitBackingStorePixelRatio ||
                context.mozBackingStorePixelRatio ||
                context.msBackingStorePixelRatio ||
                context.oBackingStorePixelRatio ||
                context.backingStorePixelRatio || 1;
            return (window.devicePixelRatio || 1) / backingStore;
        }
    });
```

## 引入TypeScript声明文件
``` bash
mkdir egret
```
在根目录创建`defs`子文件夹。`defs`文件夹用于存放项目所依赖的代码库的`TypeScript声明文件`。这些文件包括：
- egret.d.ts
- eui.d.ts
- assetsmanager.d.ts
- tween.d.ts
从示例项目中复制这些`TypeScript声明文件`到`defs`文件夹。

## 开始编写TypeScript代码
接下来，在根目录创建`src`目录，并在`src`下创建入口源码文件`Main.ts`。并在其中创建一个名为`Main`的类文件，之后把这个类暴露到`window`对象中。
```js
export default class Main {}
window['Main']=Main;
```

## 代码构建
我们使用`webpack`来进行代码的构建。首先进行仓库初始化。
``` bash
npm init -y
```
接着来安装
``` bash
npm install --save-dev webpack
```

