# 引入TypeScript
这篇文章，我们将会用TypeScript来重新改造一下之前的hello world实例，并把用户代码转为ES5。项目示例源码请见：http://gitlab2.dui88.com/wanghongyuan/egret-typescript。

## 将会有哪些变化
- 因为我们只是改变`main.js`的编写的方式，即由JavaScript改为TypeScript，那么`index.html`不会有有所变化。
- 我们将引入ES6 module来改变代码的组织方式。
- 我们将引入TypeScript工作流程。

## 修改代码结构
在根目录创建`src`文件夹来存放用户代码以及`defs`文件夹来存放TypeScript声明文件。
``` bash
mkdir src && mkdir defs
```
之后把`main.js`文件移入`src`。

## 创建TypeScript配置
首先我们再项目根目录创建TypeScript配置文件`tsconfig.json`。

## 引入TypeScript和ES6 module
首先我们把`main.js`修改为`main.ts`，并使用ES6 module来改变代码组织方式：使用`export default`来包裹`Main Class`的定义。
```js
export default class Main extends egret.DisplayObjectContainer {}
```

修改本地变量`context`为any类型。
```js
function (context: any) {}
```
